<?php
/* -----------------------------------------------------------------------------------------
   $Id: account_history_info.php,v 1.24 2020/08/03 08:37:02 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(account_history_info.php,v 1.97 2003/05/19); www.oscommerce.com 
   (c) 2003	 nextcommerce (account_history_info.php,v 1.17 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');

$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );
$oID = yes_getIntFromRequest('order_id');
if($oID < 1){
    xtc_redirect(xtc_href_link(FILENAME_ACCOUNT_HISTORY,'error_msg=Invalid%20Parameters'));
}

// include needed functions
require_once(DIR_FS_INC . 'xtc_get_orders_ebay_seller.inc.php');
require_once (DIR_FS_INC.'xtc_get_short_description.inc.php');
require_once(DIR_FS_INC . 'xtc_get_ebay_seller_data.inc.php');
require_once(DIR_FS_INC . 'xtc_date_short.inc.php');
require_once(DIR_FS_INC . 'xtc_get_all_get_params.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_display_tax_value.inc.php');
require_once(DIR_FS_INC . 'xtc_format_price_order.inc.php');
require_once(DIR_FS_INC . 'xtc_get_payment_method_title.inc.php');
require_once(DIR_FS_INC . 'xtc_get_customers_status_export_note.inc.php');
require_once(DIR_FS_INC . 'xtc_get_vpe_name.inc.php');
require_once(DIR_WS_CLASSES.'product.php');
if (!isset($_SESSION['customer_id'])) {
    xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
}
if (!isset($_GET['order_id']) || (isset($_GET['order_id']) && !is_numeric($_GET['order_id']))) {
    xtc_redirect(xtc_href_link(FILENAME_ACCOUNT_HISTORY, '', 'SSL'));
}
$check_customer = true;
if(isset($_GET['action']) and $_GET['action'] == 'update_dhl_wunschpaket'){
    $update_sql_array = [];
    if(isset($_POST['preferredLocation']) and $_POST['preferredLocation'] == 1){
        $update_sql_array['preferredLocation'] = $_POST['preferredLocation_text'];
    }else{
        $update_sql_array['preferredLocation'] = '';
    }
    if(isset($_POST['neighbour'])){
        if($_POST['neighbour'] == 'noNeighbourDelivery'){
            $update_sql_array['noNeighbourDelivery'] = 1;
            $update_sql_array['preferredNeighbour'] = '';
        }else{
            $update_sql_array['noNeighbourDelivery'] = 0;
            $update_sql_array['preferredNeighbour'] = $_POST['preferredNeighbour_text'];
        }
    }else{
        $update_sql_array['noNeighbourDelivery'] = 0;
        $update_sql_array['preferredNeighbour'] = '';
    }
    if(isset($_POST['preferredDay_active']) and $_POST['preferredDay_active'] == 1){
        $update_sql_array['preferredDay'] = $_POST['preferredDay'];
    }else{
        $update_sql_array['preferredDay'] = '0000-00-00';
    }
    
    if(isset($_POST['preferredTime_active']) and $_POST['preferredTime_active'] == 1){
        $update_sql_array['preferredTime'] = $_POST['preferredTime'];
    }else{
        $update_sql_array['preferredTime'] = '';
    }
    
    if(isset($_POST['sameDayDelivery_active']) and $_POST['sameDayDelivery_active'] == 1){
        $update_sql_array['sameDayDelivery'] = $_POST['sameDayDelivery'];
    }else{
        $update_sql_array['sameDayDelivery'] = '';
    }
    yes_db_perform('orders_dhl_paketsteuerung',$update_sql_array,'update',
        ['orders_id'=>(int)$_GET['order_id'] ]
    );
    xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))));
}
if($check_customer){
    $customer_info_query_raw = sprintf(
        "select customers_id from %s where orders_id=:orders_id",
        TABLE_ORDERS,
    );
    $parameters = [
        'orders_id'=>$oID
    ];
    $customer_info = yes_query($customer_info_query_raw,$parameters,true);
    if ($customer_info['customers_id'] != $_SESSION['customer_id']) {
        xtc_redirect(xtc_href_link(FILENAME_ACCOUNT_HISTORY, '', 'SSL'));
    }
}
$breadcrumb->add(NAVBAR_TITLE_1_ACCOUNT_HISTORY_INFO, xtc_href_link(FILENAME_ACCOUNT, '', 'SSL'));
$breadcrumb->add(NAVBAR_TITLE_2_ACCOUNT_HISTORY_INFO, xtc_href_link(FILENAME_ACCOUNT_HISTORY, '', 'SSL'));
$breadcrumb->add(sprintf(NAVBAR_TITLE_3_ACCOUNT_HISTORY_INFO, $_GET['order_id']), xtc_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $_GET['order_id'], 'SSL'));

require(DIR_WS_CLASSES . 'order.php');
$order = new order($oID,$xtPrice);
require(DIR_WS_INCLUDES . 'header.php');

$smarty->assign('ORDER_NUMBER',$order->info['id']);
$smarty->assign('cID',$order->customer['id']);
$smarty->assign('COMMENTS_VISIBLE',$order->info['comments_visible']);
$smarty->assign('ORDER_DATE',xtc_date_long($order->info['date_purchased']));
$smarty->assign('ORDER_STATUS',$order->info['orders_status']);
$smarty->assign('BILLING_LABEL',xtc_address_format($order->billing['format_id'], $order->billing, 1, ' ', '<br>'));
$smarty->assign('PRODUCTS_EDIT',xtc_href_link(FILENAME_SHOPPING_CART, '', 'SSL'));
$smarty->assign('SHIPPING_ADDRESS_EDIT',xtc_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS, '', 'SSL'));
$smarty->assign('BILLING_ADDRESS_EDIT',xtc_href_link(FILENAME_CHECKOUT_PAYMENT_ADDRESS, '', 'SSL'));
$smarty->assign('BUTTON_PRINT','<img src="'.'templates/'.CURRENT_TEMPLATE.'/buttons/' . $_SESSION['language'].'/button_print.gif" style="cursor:hand" onClick="window.open(\''. xtc_href_link(FILENAME_PRINT_ORDER,'oID='.$_GET['order_id']).'\', \'popup\', \'toolbar=yes,scrollbars=yes,resizable=yes, width=640, height=600\')">');

$tracking_nr = array();
$query = xtc_db_query(sprintf(
      "SELECT stn.tracking_number FROM shippings_tracking_numbers stn LEFT JOIN shippings s ON s.id=stn.shippings_id WHERE s.orders_id='%s'",
      $order->info['id']
));
while($record = xtc_db_fetch_array($query)){
    $tracking_nr[] = $record['tracking_number'];
}
$smarty->assign('TRACKING_NUMBERS',$tracking_nr);
$payi = $order->get_paymentinstructions();
if(sizeOf($order->get_paymentinstructions())){
    $smarty->assign('PAYMENTINSTRUCTIONS',current($payi));
}

$ebay_seller = xtc_get_orders_ebay_seller($order->info['id']);
if($ebay_seller != ''){
    $smarty->assign('EBAY_SELLER_DATA',xtc_get_ebay_seller_data($ebay_seller));
}
if($order->info['ebay_id'] != ''){
    $smarty->assign('EBAY_ID',$order->info['ebay_id']);
}
$smarty->assign('BANK_WRAP',BANK_WRAP);



if ($order->delivery != false) {
    $smarty->assign('DELIVERY_LABEL',xtc_address_format($order->delivery['format_id'], $order->delivery, 1, ' ', '<br />'));
    if ($order->info['shipping_method']) {
        $smarty->assign('SHIPPING_METHOD',$order->info['shipping_method']);
    }
}
if($order->info['date_shipping'] > 0){
    $smarty->assign('DATE_SHIPPING',xtc_date_long($order->info['date_shipping']));
}
if(strstr($order->info['shipping_class'],'dhlgkapi')){
    require_once('includes/modules/shipping/dhlgkapi.php');
    $dhlgkapi = new dhlgkapi;
    if(!$dhlgkapi->shipment_id_exists($order->info['id'])){
        $smarty->assign(array(
            'DHL_WUNSCHPAKET' => $dhlgkapi->get_wunschpaket_account_html($order->info['id'],$order->delivery['postcode']),
            'DHL_WUNSCHPAKET_FORM' => xtc_draw_form('dhl_wunschpaket',basename(__FILE__).'?'.xtc_get_all_get_params(array('action')).'action=update_dhl_wunschpaket','POST'),
        ));
    }
}

// FIBUNUMBER ADDON
$fibu_number = $order->get_fibunumber();
if($fibu_number != '0'){
        $smarty->assign('FIBU_NUMBER',$fibu_number);
}

$data_products = '<table width="100%" border="0" cellspacing="0" cellpadding="0">';
$array_products = array();
for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
// BOF - CART BUTTONS TICKET 1852      
    // ADD_QTY sowie ADD_CART_BUTTON stehen, sofern der Artikel aktiv ist und 
    // der Kunde die entsprechenden Rechte hat, der PRODUCTS_ARRAY Variable zur 
    // Verfuegung. Wie und wo das verwendet wird, kann jeder Kunde selbst
    // entscheiden und der Webdesigner nach Kundenwunsch implementieren
    $product = new product($order->products[$i]['id']);
    $product_info = $product->data;
    $pInfo = $product->buildDataArray($product_info);
    if ($product_info['products_status'] == 1) {
	$order->products[$i]['PRODUCTS_DETAILS_LINK'] = $pInfo['PRODUCTS_LINK'];
    }
// EOF - CART BUTTONS TICKET 1852      
    if(SHOW_PRODUCTS_IN_ACCOUNT_HISTORY_INFO == 'True'){
	$img = '';
	$img_query_raw = sprintf("SELECT products_image FROM products WHERE products_id='%s'",$order->products[$i]['id']);
	$img_query = xtc_db_query($img_query_raw);
	if(xtc_db_num_rows($img_query)){
            $image = xtc_db_fetch_array($img_query);
            $img = '<td><img src="'.DIR_WS_THUMBNAIL_IMAGES.$image['products_image'].'" border="0" style="max-width:100px;" /></td>'."\r\n";
	}
    }else{
	$img = '';
    }
	
    $order->products[$i]['PRODUCTS_VPE'] = '';
    $products_vpe_query = xtc_db_query(sprintf(
        "SELECT products_vpe,products_vpe_status,products_vpe_value FROM %s WHERE products_id='%s'",
        TABLE_PRODUCTS,$order->products[$i]['id']
    ));
    $products_vpe = xtc_db_fetch_array($products_vpe_query);
    if ($products_vpe['products_vpe_status'] == 1 && $products_vpe['products_vpe_value'] != 0.0){
        $order->products[$i]['PRODUCTS_VPE'] = $xtPrice->xtcFormat($order->products[$i]['final_price']  * (1 / $products_vpe['products_vpe_value']), true).TXT_PER.xtc_get_vpe_name($products_vpe['products_vpe']);
    }

    $properties = '';
    if(sizeOf($order->products[$i]['properties'])){
        $properties .= '<br />'.TEXT_PROPERTIES.'<br />';
        foreach($order->products[$i]['properties'] as $prop){
            $properties .= sprintf('%s: %s<br />',$prop['property_title'],$prop['property_value']);
            if( isset($prop['input_span']) and $prop['input_span'] != ''){
                $properties .= sprintf('%s: %s<br />',
                    INPUT_SPAN_USERVALUE_PREFIX,
                    $prop['input_span']
                );
            }
        }
    }
	
	
    $data_products .= '          <tr>' . "\n" .$img.
         '            <td class="main" nowrap align="left" valign="top" width="">' . 
						$order->products[$i]['qty'] .' x '.$order->products[$i]['name']. (($order->products[$i]['PRODUCTS_VPE'] != '')?'<br /><i>'.$order->products[$i]['PRODUCTS_VPE']:'').
						$properties.
					  '</td>' . "\n" .
     '                <td class="main" align="right" valign="top">' .xtc_format_price_order($order->products[$i]['final_price'],1,$order->info['currency']). '</td></tr>' . "\n" ;

	$order->products[$i]['img'] = $img;
	$order->products[$i]['PRODUCTS_SHORT_DESCRIPTION'] = xtc_get_short_description($order->products[$i]['id'],$_SESSION['languages_id']);
	$array_products[] = $order->products[$i];

    $data_products .= '' . "\n";

    if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
      if (sizeof($order->info['tax_groups']) > 1) $data_products .= '            <td class="main" valign="top" align="right">' . xtc_display_tax_value($order->products[$i]['tax']) . '%</td>' . "\n";
    }
     $data_products .=    '          </tr>' . "\n";
  }
  $data_products .= '</table>';
  $smarty->assign('PRODUCTS_BLOCK',$data_products);
  $smarty->assign('PRODUCTS_ARRAY',$array_products);
  $smarty->assign('PAYMENT_METHOD',xtc_get_payment_method_title($order->info['payment_method']));
  $smarty->assign('PAYMENT_CLASS',$order->info['payment_class']);
  $total_block='<table>';
  for ($i=0, $n=sizeof($order->totals); $i<$n; $i++) {
    $total_block.= '            <tr>' . "\n" .
         '                <td class="main"  align="right" width="100%">' . $order->totals[$i]['title'] . '</td>' . "\n" .
         '                <td class="main" nowrap align="right">' . $order->totals[$i]['text'] . '</td>' . "\n" .
         '              </tr>' . "\n";
  }
  $total_block.='</table>';
    $smarty->assign('TOTAL_BLOCK',$total_block);

  // das muss kundengruppenabh. sein
  $export_note = xtc_get_customers_status_export_note($_SESSION['customers_status']['customers_status_id'],$_SESSION['languages_id']);
  if($export_note != '')
	$smarty->assign('export_note',$export_note);
  
  $history_block='';
  $smarty->assign(array(
      'HISTORY_BLOCK'=>$history_block,
      'IMAGE_UPDATE'=>IMAGE_BUTTON_UPDATE
  ));

if (DOWNLOAD_ENABLED == 'true') include(DIR_WS_MODULES . 'downloads.php');
$smarty->assign('BUTTON_BACK','<a href="' . xtc_href_link(FILENAME_ACCOUNT, xtc_get_all_get_params(array('order_id')), 'SSL') . '">' . xtc_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>');

if(isset($payment_block)){
	$smarty->assign('PAYMENT_BLOCK',$payment_block);
}
$smarty->assign('YESORDER',$order->get_order_positions());
$smarty->caching = 0;
$main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/account_history_info.html');

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')) $smarty->load_filter('output', 'note');
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include( 'includes/application_bottom.php');
