<?php
require('includes/application_top.php');
require_once(DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/categories.php');
require_once(DIR_FS_CATALOG.'/includes/classes/xtcPrice.php');
require_once(DIR_WS_CLASSES . 'currencies.php');
require_once(DIR_WS_CLASSES . 'product.php');
require_once(DIR_WS_CLASSES . 'amazon_export.php');
require_once(DIR_FS_INC.'xtc_get_product_path.inc.php');
require_once(DIR_FS_INC.'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_INC.'xtc_get_category_path.inc.php');
require_once(DIR_FS_INC.'xtc_productgroups.inc.php');
if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
    require_once(DIR_WS_CLASSES . 'yes_hitmeister.php');
}

$ae = new amazon_export($_SESSION['language']);

$box_content_smarty = new yesSmarty;
$box_content_smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$box_content_smarty->assign('FORM_END','</form>');

$cPath = (isset($_GET['cPath']))?$_GET['cPath']:'';
$cID = (isset($_GET['cID']))?$_GET['cID']:'';
$xtPrice = new xtcPrice($_SESSION['currency'],$_SESSION['customers_status']['customers_status_id']);
$currencies = new currencies();
if($cID){
	$cinfo_query = xtc_db_query(sprintf("SELECT c.*,cd.* FROM categories c,categories_description cd WHERE c.categories_id=cd.categories_id and c.categories_id='%s' and cd.language_id='%s'",$cID,$_SESSION['languages_id']));
	$cinfo_array = xtc_db_fetch_array($cinfo_query);
	$category_childs = array('childs_count' => xtc_childs_in_category_count($cinfo_array['categories_id']));
	$category_products = array('products_count' => xtc_products_in_category_count($cinfo_array['categories_id'],true));
	$cInfo_array = xtc_array_merge($cinfo_array, $category_childs, $category_products);
	$cInfo = new objectInfo($cInfo_array);
}
$pID = (isset($_GET['pID']))?$_GET['pID']:0;
if($pID>0){
	$products_query = xtc_db_query(sprintf("SELECT p.*,pd.* FROM products p,products_description pd WHERE p.products_id=pd.products_id and p.products_id='%d' and pd.language_id='%d'",$pID,$_SESSION['languages_id']));
	$products = xtc_db_fetch_array($products_query);
	// find out the rating average from customer reviews
	$reviews_query = xtc_db_query("select (avg(reviews_rating) / 5 * 100) as average_rating from " . TABLE_REVIEWS . " where products_id = '" . $products['products_id'] . "'");
	$reviews = xtc_db_fetch_array($reviews_query);
	$pInfo_array = xtc_array_merge($products, $reviews);
        $pInfo_array['products_tax_class_id'] = yes_eu_oss_get_products_tax_class_id($pID, STORE_COUNTRY);
	$pInfo = new objectInfo($pInfo_array);
}

// yes accounting  
$admin_access = main::get_admin_access();
$action = (isset($_GET['action']))?$_GET['action']:'';
switch ($action) {
      case 'delete_category':
        $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_DELETE_CATEGORY . '</b>');

        $contents = array('form' => xtc_draw_form('categories', FILENAME_CATEGORIES, 'action=delete_category_confirm&cPath=' . $cPath) . xtc_draw_hidden_field('categories_id', $cInfo->categories_id));
        $contents[] = array('text' => TEXT_DELETE_CATEGORY_INTRO);
        $contents[] = array('text' => '<br /><b>' . $cInfo->categories_name . '</b>');
        if ($cInfo->childs_count > 0) $contents[] = array('text' => '<br />' . sprintf(TEXT_DELETE_WARNING_CHILDS, $cInfo->childs_count));
        if ($cInfo->products_count > 0) $contents[] = array('text' => '<br />' . sprintf(TEXT_DELETE_WARNING_PRODUCTS, $cInfo->products_count));
        $no_delete = false;
		if($cInfo->products_count > 0){
            if(defined('MAX_DELETE_PRODUCTS_LIMIT')){
                $delete_limit = (int)MAX_DELETE_PRODUCTS_LIMIT;
            }else{
                $delete_limit = 1000;
            }
            $no_delete = true;
            if($cInfo->products_count > $delete_limit){
                $contents[] = array('text' => '<br /><font color="red"><b>' . sprintf(MSG_ERROR_DELETE_PRODUCTS_MAXIMUM, $delete_limit,$cInfo->products_count).'</b></font>');
            }else{
                $categories = \YES4Trade\Model\category::get_categories_id_text_values_by_categories_id($cInfo->categories_id);
                $products = array();
                for ($i = 0, $n = sizeof($categories); $i < $n; $i++) {
                    $product_ids_query = xtc_db_query("select products_id from " . TABLE_PRODUCTS_TO_CATEGORIES . " where categories_id = '" . $categories[$i]['id'] . "'");
                    while ($product_ids = xtc_db_fetch_array($product_ids_query)) {
                        $products[$product_ids['products_id']] = true;
                    }
                }
                $contents[] = array('text' => yes_draw_multiple_products_delete_check($products,'input.delete_category_button'));
                $contents[] = array('text' => '<br />' . yes_draw_href_button(IMAGE_DELETE,'','width:130px;display:none;','submit','ui-button ui-corner-all ui-state-error delete_category_button') . ' '.yes_draw_href_button(IMAGE_CANCEL,'javascript:$(\'#orderdetails\').html(\'\');','width:130px;'));
            }
        }
        
	if(!$no_delete){
	    $contents[] = array( 'text' => '<br />' . yes_draw_href_button(IMAGE_DELETE,'','width:130px;','submit') . ' '.yes_draw_href_button(IMAGE_CANCEL,'javascript:$(\'#orderdetails\').html(\'\');','width:130px;'));
	}
        break;

      case 'move_category':
        $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_MOVE_CATEGORY . '</b>');

        $contents = array('form' => xtc_draw_form('categories', FILENAME_CATEGORIES, 'action=move_category_confirm','POST','id="copy_to_form"') . xtc_draw_hidden_field('categories_id', $cInfo->categories_id));
        $contents[] = array('text' => sprintf(TEXT_MOVE_CATEGORIES_INTRO, $cInfo->categories_name));
        $contents[] = array('text' => '<br />' . sprintf(TEXT_MOVE, $cInfo->categories_name) . '<br />');

		$cat_select = \YES4Trade\Model\category::get_categories_tree_select([
			'return_function'=>sprintf('$(\'input[name="move_to_category_id"]\').val(id);'),
			'ALL_ITEMS_SELECTABLE'=>'true'
		], new \yesSmarty());
		$contents[] = array('text' => $cat_select
			. '<br />Category ID'
			. xtc_draw_input_field('move_to_category_id','','size="8"',false,'number')
		);
        $contents[] = array( 'text' => '<br />' . yes_draw_href_button(IMAGE_MOVE,'','width:130px;','submit') . ' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&cID=' . $cInfo->categories_id),'width:130px;'));
        break;

      case 'add_special':
        $heading[] = array('text' => sprintf('<b>%s</b>',TEXT_ADD_SPECIAL));
	$from_link = urlencode( xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))) );
        $contents = array('form' => xtc_draw_form('new_special', FILENAME_SPECIALS, 'action=insert&from='.$from_link) . xtc_draw_hidden_field('products_id', $pInfo->products_id));
        $contents[] = array('text'=>sprintf('<p>%s</p><p>%s</p><p>%s</p><p>%s</p>',
                TEXT_SPECIAL_PRICE_INTRO,
                TEXT_SPECIAL_PRICE_INTRO2,
                TEXT_SPECIAL_PRICE_INTRO3,
                TEXT_SPECIAL_PRICE_INTRO4
        ));
        $contents[] = array('text'=>TEXT_SPECIAL_PRICE.':<br />'.xtc_draw_input_field('specials_price','','size="8" maxlength="10"'));
        $contents[] = array('text'=>TEXT_SPECIAL_DATE_FROM.':<br />'.xtc_draw_input_field('specials_date_from', '', 'size="16" maxlength="16" id="specials_date_from"',false,'date'));
        $contents[] = array('text'=>TEXT_SPECIAL_DATE_TO.':<br />'.xtc_draw_input_field('specials_date', '', 'size="16" maxlength="16" id="specials_date"',false,'date'));
        $contents[] = array('text'=>TEXT_SPECIAL_EBAY_REVISE.':<br />'.xtc_draw_checkbox_field('ebay_price_revise', '1',false));
        $contents[] = array( 'text' => '<br />' . yes_draw_href_button(IMAGE_SAVE,'','width:130px;','submit') . ' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&cID=' . $cInfo->categories_id),'width:130px;'));
        break;
    case 'edit_special':
        $heading[] = array('text' => sprintf('<b>%s</b>',TEXT_EDIT_SPECIAL));
        if(isset($_REQUEST['from'])){
                $from_link = urlencode( $_REQUEST['from'] );
        }else{
                $from_link = urlencode( xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action'))) );
        }
        $special_query = xtc_db_query("SELECT * FROM specials WHERE products_id='".$pInfo->products_id."'");
        if(xtc_db_num_rows($special_query)){
            $allow_edit = true;
            $special = xtc_db_fetch_array($special_query);
            if($special['ebay_price_revise'] == 1){
                require_once(DIR_WS_CLASSES.'specials_ebay_revise.php');
                $ser_array = specials_ebay_revise::get_specials_ebay_revise_id_from_specials_id($special['specials_id']);
                if(sizeOf($ser_array)){
                    $allow_edit = false;
                }
            }
            $contents = array('form' => xtc_draw_form('new_special', FILENAME_SPECIALS, 'action=update&specials_id='.$special['specials_id'].'&from='.$from_link) . xtc_draw_hidden_field('products_id', $pInfo->products_id));
            if(!$allow_edit){
                $contents[] = array(
                    'text'=>TEXT_SPECIALS_EBAY_PRICE_REVISE_ACTIVE
                );
            }else{
                if(PRICE_IS_BRUTTO == 'true'){
                    $tax_rate = xtc_get_tax_rate($pInfo->products_tax_class_id); // EU OSS SAFE
                    $special['specials_new_products_price'] = $xtPrice->xtcAddTax($special['specials_new_products_price'], $tax_rate);

                }
                $contents[] = array('text'=>sprintf('<p>%s</p><p>%s</p><p>%s</p><p>%s</p>',
                        TEXT_SPECIAL_PRICE_INTRO,
                        TEXT_SPECIAL_PRICE_INTRO2,
                        TEXT_SPECIAL_PRICE_INTRO3,
                        TEXT_SPECIAL_PRICE_INTRO4
                ));
                $contents[] = array('text'=>TEXT_SPECIAL_PRICE.':<br />'.xtc_draw_input_field('specials_price',number_format($special['specials_new_products_price'],2,',',''),'size="8" maxlength="10"'));
                $contents[] = array('text'=>TEXT_SPECIAL_DATE_FROM.':<br />'.xtc_draw_input_field('start_datum', date('Y-m-d',strtotime($special['start_date'])), 'size="16" maxlength="16" id="specials_date_from"',false,'date'));
                $contents[] = array('text'=>TEXT_SPECIAL_DATE_TO.':<br />'.xtc_draw_input_field('datum', date('Y-m-d',strtotime($special['expires_date'])), 'size="16" maxlength="16" id="specials_date"',false,'date'));
                //$contents[] = array('text'=>TEXT_SPECIAL_SELL_TO_V1NULL.':<br />'.xtc_draw_checkbox_field('sell_to_v1null', '1',$special['sell_to_v1null']));
                $contents[] = array('text'=>TEXT_SPECIAL_EBAY_REVISE.':<br />'.xtc_draw_checkbox_field('ebay_price_revise', '1',$special['ebay_price_revise']));

                $contents[] = array( 'text' => '<br />' . yes_draw_href_button(IMAGE_SAVE,'','width:130px;','submit') . ' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath),'width:130px;'));
            }
        }
        break;
    case 'delete_product':
        $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_DELETE_PRODUCT . '</b>');

        $contents = array('form' => xtc_draw_form('products', FILENAME_CATEGORIES, 'action=delete_product_confirm&cPath=' . $cPath) . xtc_draw_hidden_field('products_id', $pInfo->products_id));
        $contents[] = array('text' => TEXT_DELETE_PRODUCT_INTRO);
        $contents[] = array('text' => '<br /><b>' . $pInfo->products_name . '</b>');

        $product_categories_string = '';
        $product_categories = xtc_generate_category_path($pInfo->products_id, 'product');
        for ($i = 0, $n = sizeof($product_categories); $i < $n; $i++) {
          $category_path = '';
          for ($j = 0, $k = sizeof($product_categories[$i]); $j < $k; $j++) {
            $category_path .= $product_categories[$i][$j]['text'] . '&nbsp;&gt;&nbsp;';
          }
          $category_path = substr($category_path, 0, -16);
          $product_categories_string .= xtc_draw_checkbox_field('product_categories[]', $product_categories[$i][sizeof($product_categories[$i])-1]['id'], true) . '&nbsp;' . $category_path . '<br />';
        }
        $product_categories_string = substr($product_categories_string, 0, -4);

        $contents[] = array('text' => '<br />' . $product_categories_string);
        $contents[] = array( 'text' => '<br />' . xtc_image_submit('button_delete.gif', IMAGE_DELETE) . ' <a href="' . xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&pID=' . $pInfo->products_id) . '">' . xtc_image_button('button_cancel.gif', IMAGE_CANCEL) . '</a>');
        break;

      case 'move_product':
        $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_MOVE_PRODUCT . '</b>');
        $contents = array('form' => xtc_draw_form('products', FILENAME_CATEGORIES, 'action=move_product_confirm&cPath=' . $cPath,'POST','id="copy_to_form"') . xtc_draw_hidden_field('products_id', $pInfo->products_id));
        $contents[] = array('text' => sprintf(TEXT_MOVE_PRODUCTS_INTRO, $pInfo->products_name));
        $contents[] = array('text' => '<br />' . TEXT_INFO_CURRENT_CATEGORIES . '<br /><b>' . xtc_output_generated_category_path($pInfo->products_id, 'product') . '</b>');
		$parent_id = 0;
		$cat_select = \YES4Trade\Model\category::get_categories_tree_select([
			'return_function'=>sprintf('$(\'input[name="move_to_category_id"]\').val(id);'),
			'ALL_ITEMS_SELECTABLE'=>'false'
		], new \yesSmarty());
		$contents[] = array('text' => '<hr noshade="noshade" />'.sprintf(TEXT_MOVE, $pInfo->products_name) 
			. $cat_select
			. '<br />Category ID'
			. xtc_draw_input_field('move_to_category_id','','size="8"',false,'number')
		);
        $contents[] = array( 'text' => '<br />' . yes_draw_href_button(IMAGE_MOVE,'','width:130px;','submit') . ' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&pID=' . $pInfo->products_id),'width:130px;'));
        break;

      case 'copy_to':
		$heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_COPY_TO . '</b>');
        $contents = array('form' => xtc_draw_form(
            'copy_to',
            'categories.php',
            xtc_get_all_get_params(array('action')).'action=copy_to_confirm',
            'POST',
            'id="copy_to_form"'
            ) . xtc_draw_hidden_field('products_id', $pInfo->products_id)
		);
        $contents[] = array('text' => TEXT_INFO_COPY_TO_INTRO);
        $contents[] = array('text' => '<br />' . TEXT_INFO_CURRENT_CATEGORIES . '<br /><b>' . xtc_output_generated_category_path($pInfo->products_id, 'product') . '</b>');

        $contents[] = array('text' => '<br />' . TEXT_HOW_TO_COPY 
			. '<br />' . xtc_draw_radio_field('copy_as', 'link') 
			. ' ' . TEXT_COPY_AS_LINK . '<br />' 
			. xtc_draw_radio_field('copy_as', 'duplicate',true) 
			. ' ' . TEXT_COPY_AS_DUPLICATE);
        $contents[] = array('text' => '<br />' . TEXT_CATEGORIES . '<br />');

		$cat_select = \YES4Trade\Model\category::get_categories_tree_select([
			'return_function'=>sprintf('$(\'input[name="categories_id"]\').val(id);'),
			'ALL_ITEMS_SELECTABLE'=>'false'
		], new \yesSmarty());
		$contents[] = array('text' => $cat_select
			. '<br />Category ID'
			. xtc_draw_input_field('categories_id','','size="8"',false,'number')
		);
        $contents[] = array('text' => 'Beim Duplizieren des Produkts k&ouml;nnen Sie hier angeben, wieviel verschiedene Kopien erzeugt werden sollen. (Max. 500)<br />' . xtc_draw_input_field('copy_qty', '1', 'size="4" maxlength="3"',false,'number"'));
        $contents[] = array( 'text' => '<br />' . yes_draw_href_button(IMAGE_COPY,'','width:130px;','submit') . ' '.yes_draw_href_button(IMAGE_CANCEL,'javascript:$(\'#orderdetails\').html(\'\');','width:130px;'));
        break;

      default:
		  $heading = array();
		if (isset($cInfo) and is_object($cInfo)) { // category info box contents
			//$heading[] = array('text' => '<b>' . $cInfo->categories_name . '</b>');
			// yes accounting
			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_edit'] == '1')) {
				if( $cInfo->categories_name != 'RETOURE'){
					$contents[] = array( 'text' => yes_draw_href_button(IMAGE_EDIT,xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('cPath','cID','action')).'cPath=' . $cPath . '&cID=' . $cInfo->categories_id . '&action=edit_category_ACD'),'width:180px;') );
					$contents[] = array( 'text' => yes_draw_href_button(IMAGE_MOVE,'javascript:yes_ajax_box_action(\''.xtc_href_link('ajax_categories_details.php',xtc_get_all_get_params(array('action')).'action=move_category').'\');','width:180px;') );
				}else{
					$contents[] = array( 'text' => '<b>'.TEXT_SYSTEMCATEGORY.'</b><br />');
				}
			}
			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_editspecial'] == '1')) {
				if( $cInfo->categories_name != 'RETOURE'){
					$contents[] = array( 'text' => yes_draw_href_button(IMAGE_DELETE,'javascript:yes_ajax_box_action(\''.xtc_href_link('ajax_categories_details.php',xtc_get_all_get_params(array('action')).'action=delete_category').'\');','width:180px;'));
				}
			}
			
			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['notiz'] == '1')) {
			    $contents[] = array( 'text' => yes_draw_href_button(ADD_QUICKNOTE,'javascript:void(acd_quicknoteadd());','width:180px;'));
			}
			
			
			if ( $admin_access['specials'] == '1' ) {
				if($cInfo->products_count > 500){
					$contents[] = array( 'text' => '<span class="errorText">Zu viele Artikel innerhalb der Kategoriestruktur um Sonderangebote anzulegen. (max. 500)</span>');
				}else{
					$contents[] = array( 'text' =>yes_draw_href_button(TEXT_SPECIALS,'javascript:yes_ajax_box_action(\''.xtc_href_link('specials.php','cID='.$cInfo->categories_id.'&action=add_multiple_category_confirm').'\');','width:180px;','button'));
				}
			}
        		$contents[] = array( 'text' =>yes_draw_href_button(TEXT_CATEGORY_COPY,'javascript:yes_ajax_box_action(\''.xtc_href_link(FILENAME_CATEGORIES,'cID='.$cInfo->categories_id.'&action=copy_category_confirm').'\');','width:180px;','button'));

			$contents[] = array('text' => '<br />' . TEXT_DATE_ADDED . ' ' . xtc_date_short($cInfo->date_added));
			if (xtc_not_null($cInfo->last_modified)){
				$contents[] = array('text' => TEXT_LAST_MODIFIED . ' ' . xtc_date_short($cInfo->last_modified));
			}
			if(is_file(DIR_FS_CATALOG.'images/categories/'.$cInfo->categories_image)){
				$box_image = HTTP_SERVER.'images/categories/'.$cInfo->categories_image;
			}
			$contents[] = array('text' => '<br />' . TEXT_SUBCATEGORIES . ' ' . $cInfo->childs_count . '<br />' . TEXT_PRODUCTS . ' ' . $cInfo->products_count);
			
			$cart_items_query = xtc_db_query(sprintf(
				"SELECT COUNT(ep.id) as num FROM ebay_products ep LEFT JOIN products_to_categories p2c USING ( products_id ) WHERE p2c.categories_id=%s",
				(int)$cInfo->categories_id
			));
			$cart_items = xtc_db_fetch_array($cart_items_query);
			$cart_items_nr = $cart_items['num'];
			if($cart_items_nr > 0){
			    $contents[] = array( 'text' => TEXT_CART_ITEMS.' '.'<a href="'.xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('categories_id','action','cID')).'categories_id='.$cInfo->categories_id).'">'.$cart_items_nr.'</a>');
			    if($cInfo->link_id > 0){
				    $contents[] = array('text' => '<br />' . TEXT_LINK_ID . ': ' . $cInfo->link_id);
			    }
			}
			
			if(isset($cInfo->amazon_flatfile)){
			    $contents[] = array('text'=>'<br />'.xtc_image('images/logo_amazon.gif'));
			    $contents[] = array(
				'text'=>sprintf('<b>%s:</b> %s',TEXT_AMAZON_FLATFILE,$cInfo->amazon_flatfile)
			    );
			    $browse_node_text = '';
			    if($cInfo->amazon_browse_node_id != '' and $cInfo->amazon_flatfile != ''){
				$browse_node_text = '<br /><i>'.$ae->get_amazon_browse_node_title($cInfo->amazon_flatfile,$cInfo->amazon_browse_node_id).'</i>';
			    }
			    $contents[] = array(
				'text'=>sprintf('<b>%s:</b> %s',TEXT_AMAZON_BROWSE_NODE_ID,$cInfo->amazon_browse_node_id.$browse_node_text)
			    );
			}
			
			
		} elseif (is_object($pInfo)) { // product info box contents
			$cPath = xtc_get_product_path($pInfo->products_id);
			if (xtc_get_products_master_status($pInfo->products_id) ==1 ) {
				$link = xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&pID=' . $pInfo->products_id . '&action=new_master');
			}else{
				$link = xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cPath . '&pID=' . $pInfo->products_id . '&action=new_product');
			}

			$new_tab_link = sprintf('<a href="%s" target="_new"><span class="ui-icon ui-icon-newwin" style="float:left;"></span></a>',$link);
			// yes accounting
			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_edit'] == '1')) {
		
				// MASTER/SLAVE
				if (xtc_get_products_master_status($pInfo->products_id) ==1 ) {
					$contents[] = array( 'text' => yes_draw_href_button(IMAGE_EDIT,$link,'width:180px;') );
				}else{
				// MASTER/SLAVE END
					$contents[] = array( 'text' => yes_draw_href_button(IMAGE_EDIT,$link,'width:180px;'));
				}
            	    
		    }

			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['xsell_products'] == '1')){
				$contents[] = array( 'text'=> yes_draw_href_button(BOX_XSELL_PRODUCTS,xtc_href_link(FILENAME_XSELL_PRODUCTS, 'add_related_product_ID=' . $pInfo->products_id ),'width:180px;') );
			}

			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_editspecial'] == '1')) {

				if(!$cPath){
					$source_cat_query = xtc_db_query("SELECT categories_id FROM products_to_categories WHERE products_id='".$pInfo->products_id."'");
					while($source_cat = xtc_db_fetch_array($source_cat_query)){
						if(!$first)
							$first = $source_cat['categories_id'];
					}
					$cPath = $first;
				}
				$contents[] = array( 'text' =>yes_draw_href_button(IMAGE_COPY_TO,'javascript:yes_ajax_box_action(\'' . xtc_href_link('ajax_categories_details.php',xtc_get_all_get_params(array('action')).'action=copy_to') . '\');','width:180px;'));
				$contents[] = array( 'text' =>yes_draw_href_button(TEXT_INFO_HEADING_MOVE_PRODUCT,'javascript:yes_ajax_box_action(\'' . xtc_href_link('ajax_categories_details.php',xtc_get_all_get_params(array('action')).'action=move_product') . '\');','width:180px;'));
                        }

			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['storage'] == '1')) {
//				$contents[] = array( 'text' =>yes_draw_href_button(IMAGE_STORAGE_ADMIN,xtc_href_link('products.php','pID='.$pInfo->products_id.'&action=storage_admin'),'width:180px;','button','lbOn bigWidth'));
				$contents[] = array('text' =>yes_draw_href_button(IMAGE_STORAGE_ADMIN,'javascript:yes_ajax_box_action(\''.xtc_href_link('products.php','pID='.$pInfo->products_id.'&action=storage_admin').'\');','width:180px;') );
                        }
			if (  ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['distributor_products'] == '1')) {
				$contents[] = array( 'text' =>yes_draw_href_button(IMAGE_DISTRIBUTOR_ADMIN,xtc_href_link('products.php','pID='.$pInfo->products_id.'&action=distributor_admin'),'width:180px;','button','lbOn bigWidth ui-button ui-corner-all ui-state-default'));
//				$contents[] = array('text' =>yes_draw_href_button(IMAGE_DISTRIBUTOR_ADMIN,'javascript:yes_ajax_box_action(\''.xtc_href_link('products.php','pID='.$pInfo->products_id.'&action=distributor_admin').'\');','width:180px;') );
                        }
			if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
				if(!yes_hitmeister::is_hitmeister_product($pInfo->products_id)){
					$contents[] = array( 'text' =>yes_draw_href_button('Real Export',xtc_href_link('hitmeister.php','action=import_yes_product&products_id='.$pInfo->products_id),'width:180px;','button','lbOn bigWidth  ui-button ui-corner-all ui-state-default'));
				}
			}

			// ADDON SPECIALS
			$specials_query = xtc_db_query(sprintf("SELECT specials_id FROM %s WHERE products_id='%s'",TABLE_SPECIALS,$pInfo->products_id));
			if(xtc_db_num_rows($specials_query)){
				$specials_id = xtc_db_fetch_array($specials_query);
				$contents[] = array('text' =>yes_draw_href_button(TEXT_EDIT_SPECIAL,'javascript:yes_ajax_box_action(\''.xtc_href_link('ajax_categories_details.php',xtc_get_all_get_params(array('action','products_id','from')).'action=edit_special&products_id='.$pInfo->products_id.'&from='.urldecode($_SERVER['HTTP_REFERER']) ).'\');','width:180px;') );
			}else{
				$contents[] = array('text' =>yes_draw_href_button(TEXT_ADD_SPECIAL,'javascript:yes_ajax_box_action(\''.xtc_href_link('ajax_categories_details.php',xtc_get_all_get_params(array('action','products_id')).'action=add_special&products_id='.$pInfo->products_id).'\');','width:180px;') );
			}

			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['ebayapi_cart'] == '1')) {
			    
				if (xtc_get_products_master_status($pInfo->products_id) ==1 ) {
				    $cart_id = (isset($_SESSION['ebay_sammler'])) ? $_SESSION['ebay_sammler'] : 0;
				    $cvar_error = '';
				    $EC = (defined('EBAY_CATEGORY')) ? EBAY_CATEGORY : '';
				    if($cart_id == 0 and empty($EC)){
					$cvar_error = JS_ERROR_DEFINE_EBAY_DEFAULT_CATEGORY;
				    }else{
					if($cart_id > 0){
					    $query = xtc_db_query(sprintf(
						    "SELECT category,titel FROM ebay_sammler WHERE id='%s'",
						    $cart_id
					    ));
					    $record = xtc_db_fetch_array($query);
					    if(empty($record['category'])){
						$cvar_error = sprintf(JS_ERROR_DEFINE_EBAY_SAMMLER_CATEGORY,xtc_db_prepare_input(str_replace('"','',$record['titel'])));
					    }
					}
				    }
				    if($cvar_error != ''){
					$contents[] = array('text' =>yes_draw_href_button(TEXT_ADD_TO_SAMMLER_AS_VARIATIONSET,'javascript:alert(\''.$cvar_error.'\');','width:180px;','button') );
				    }else{
					$contents[] = array('text' =>yes_draw_href_button(TEXT_ADD_TO_SAMMLER_AS_VARIATIONSET,xtc_href_link('ebayapi_cart.php','action=saveshopproducts&add_pid='.$pInfo->products_id.'&create_variationset=1'),'width:180px;','button') );
				    }
				}
				$contents[] = array('text' =>yes_draw_href_button(TEXT_ADD_TO_SAMMLER,xtc_href_link('ebayapi_cart.php','action=saveshopproducts&add_pid='.$pInfo->products_id),'width:180px;','button') );
				
				
				$contents[] = array('text' =>'<input type="button" id="'.xtc_href_link('categories.php','action=change_cart_prices&products_id='.$pInfo->products_id).'" class="lbOn ui-button ui-corner-all ui-state-default" style="width:180px;" value="'.BUTTON_UPDATE_CART_PRICES.'" title="'.BUTTON_UPDATE_CART_PRICES.'" />');
				$contents[] = array('text' =>'<input type="button" id="'.xtc_href_link('categories.php','action=change_cart_ebay_title&products_id='.$pInfo->products_id).'" class="lbOn ui-button ui-corner-all ui-state-default" style="width:180px;" value="'.BUTTON_UPDATE_CART_EBAY_TITLE.'" title="'.BUTTON_UPDATE_CART_EBAY_TITLE.'" />');
			}
			$contents[] = array('text' =>'<input type="button" id="'.xtc_href_link('products.php','action=history&pID='.$pInfo->products_id).'" class="lbOn ui-button ui-corner-all ui-state-default" style="width:180px;" value="'.TEXT_PRODUCTS_HISTORY.'" title="'.TEXT_PRODUCTS_HISTORY.'" />');


			$contents[] = array('text' =>yes_draw_href_button('Shop '.IMAGE_PREVIEW,xtc_href_link(DIR_WS_CATALOG.'admin_product_info.php','products_id='.$pInfo->products_id),'width:180px;','button','ui-button ui-corner-all ui-state-default',$target=true) );
			if($admin_access['module_export'] == 1 and defined('MODULE_YES2_STATUS') and MODULE_YES2_STATUS == 'True'){
				$contents[] = array('text' => yes_draw_href_button(IMAGE_EXPORT,
						xtc_href_link(FILENAME_MODULE_EXPORT,'set=&module=yes2&action=save&products_id_export='.$pInfo->products_id.'&configuration[MODULE_YES2_FILE]='.MODULE_YES2_FILE.'&configuration[MODULE_YES2_STATUS]='.MODULE_YES2_STATUS.'&export=yes&export_config_file=&distributors_id=&allCat=1'),
						'width:180px;','button','ui-button ui-corner-all ui-state-default',$target=true)
				);
			}
                        
          	$contents[] = array('text' =>yes_draw_href_button(BUTTON_IMAGES_UPLOAD,xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('action')).'action=images_upload'),'width:180px;','button','ui-button ui-corner-all ui-state-default','_blank') );
			
			if( $pInfo->products_ean != '' and is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/barcode_products.conf') and is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/barcode_products.html')){
				$contents[] = array('text' =>yes_draw_href_button(TEXT_BARCODE_PRODUCTS,xtc_href_link(FILENAME_CATEGORIES,'action=labelprint&pID='.$pInfo->products_id),'width:180px;','button','ui-button ui-corner-all ui-state-default','_blank') );
			}
			if( is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/barcode_products.conf') and is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/product_label.html')){
				$contents[] = array('text' =>yes_draw_href_button(TEXT_PRODUCT_LABEL,xtc_href_link('products.php','action=print_label&pID='.$pInfo->products_id),'width:180px;','button','ui-button ui-corner-all ui-state-default','_blank') );
			}
			$pg = xtc_get_product_groups($pInfo->products_id);
			$contents[] = array('text' =>yes_draw_href_button(HEADING_TITLE_GROUPS_ALLOCATION.' ('.sizeOf($pg).')',xtc_href_link('products.php','action=groups_allocation&pID='.$pInfo->products_id),'width:180px;','button','lbOn ui-button ui-corner-all ui-state-default product_groups_button bigWidth') );
		
			$contents[] = array('text' => xtc_draw_separator('pixel_black.gif'));
	    
			$contents[] = array('text' => '<b>'.TEXT_SHOP_STATUS.'</b> '.(($pInfo->products_listing_status==1)?YES:NO));
	    
			// yes accounting
			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_categories_edit'] == '1')) {
				// REMOVE LINKS
				$link_query = xtc_db_query("SELECT p2c.categories_id,cd.categories_name FROM products_to_categories p2c LEFT JOIN categories_description cd USING(categories_id) WHERE cd.language_id='".$_SESSION['languages_id']."' AND products_id='".$pInfo->products_id."'");
				if(xtc_db_num_rows($link_query) > 1){
					$_current_cid = current(array_reverse(explode('_',$cPath)));
					$contents[] = array('text' => '<b>'.TEXT_MULTIPLE_LINKS.'</b>');
					while($links = xtc_db_fetch_array($link_query)){
						if($_current_cid != $links['categories_id']){
							$contents[] = array('text' => '<div id="rem_link_'.$links['categories_id'].'">'.$links['categories_name'].
								' <a href="javascript:;" onclick="rem_other_link('.$links['categories_id'].',\'' . xtc_href_link('categories.php',xtc_get_all_get_params(array('action','pID','cPath')).'ajax_mode=1&action=remove_link&pID='.$pInfo->products_id.'&cPath='.$links['categories_id']).'\');">'.
								'<u>'.IMAGE_DELETE.'</u></a></div>'
							);
						}
					}
                                        
					$contents[] = array('text' => 
						'<br /><a href="#" onClick="rem_link(\'' . xtc_href_link('categories.php',xtc_get_all_get_params(array('action','pID','cPath')).'action=remove_link&pID='.$pInfo->products_id.'&cPath='.$_GET['cPath']).'\');">'.
						'<u>'.TEXT_DELETE_LINK.'</u></a> &nbsp; '.
						'<a href="#" onClick="rem_other_links(\'' . xtc_href_link('categories.php',xtc_get_all_get_params(array('action','pID','cPath')).'action=remove_other_links&pID='.$pInfo->products_id.'&cPath='.$_GET['cPath']).'\');">'.
						'<u>'.TEXT_DELETE_OTHER_LINKS.'</u></a>'
					);
					$contents[] = array('text' => xtc_draw_separator('pixel_black.gif'));
				}
			}

			$product = new product($pInfo->products_id);
			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['ebayapi_cart'] == '1')) {
				$cart_products = $product->get_ebay_products();
				$count_cart_products = sizeOf($cart_products);
				$content_string = sizeOf($cart_products);
				if($count_cart_products > 0){
					$content_string .= '&nbsp;<a href="';
					$content_string .= xtc_href_link('ebayapi_cart.php',sprintf('searchword=%s&pid=1&menugroup=interfaces',$pInfo->products_id));
					$content_string .= '"><u>'.TEXT_LINK_VIEW.'</u></a>';
				}
				$contents[] = array('text' => '<b>'.TEXT_CART_ITEMS.'</b> '.$content_string);
			}

			$contents[] = array('text' => '<b>'.TEXT_SHIPPINGCOSTS.'</b> <a href="#" onClick="window.open(\''.xtc_href_link('../popup_shippingcosts.php','products_id='.$pInfo->products_id).'\',\'popup\',\'width='.EXT_POPUP_WIDTH.',height='.EXT_POPUP_HEIGHT.',scrollbars=yes,resizable=yes\');"><u>'.TEXT_LINK_VIEW.'</u></a>');
	    	    
			$contents[] = array('text' => '<b>' . TEXT_DATE_ADDED . '</b> ' . xtc_date_short($pInfo->products_date_added));
            
			if (xtc_not_null($pInfo->products_last_modified)){
				$contents[] = array('text' => '<b>'.TEXT_LAST_MODIFIED . '</b> ' . xtc_date_short($pInfo->products_last_modified));
			}
            
			if (date('Y-m-d') < $pInfo->products_date_available){
				$contents[] = array('text' => '<b>'.TEXT_DATE_AVAILABLE . '</b> ' . xtc_date_short($pInfo->products_date_available));
			}
           
			if(xtc_not_null($pInfo->products_image) ){
				$box_image = HTTP_SERVER.'images/product_images/thumbnail_images/'.$pInfo->products_image;
			}

			$price=$pInfo->products_price;
			$price=xtc_round($price,PRICE_PRECISION);
			$price_string=TEXT_PRODUCTS_PRICE_INFO . ' ' . $currencies->format($price);
			if (PRICE_IS_BRUTTO=='true' && ((isset($_GET['read']) and $_GET['read'] == 'only') || (!isset($_GET['action']) or $_GET['action'] != 'new_product_preview')) ){
				$price_netto=xtc_round($price,PRICE_PRECISION);
                                $tax = ['tax_rate'=>xtc_get_tax_rate($pInfo->products_tax_class_id, STORE_COUNTRY)]; // EU-OSS SAFE
				$price = ($price*($tax['tax_rate']+100)/100);

				$price_string = '<b>'.TEXT_PRODUCTS_PRICE_INFO . '</b> ' . $currencies->format($price);
				$netto_price_string = '<b>' . TXT_NETTO . '</b> '.$currencies->format($price_netto);
			}
			$contents[] = array('text' => $price_string);
			$contents[] = array('text' => $netto_price_string);
			$contents[] = array('text' => '<b>'.TEXT_PRODUCTS_DISCOUNT_ALLOWED_INFO .  '</b> ' . $pInfo->products_discount_allowed);

			$distributors = $product->get_distributors();
			if(sizeOf($distributors)){
				$box_content_smarty->assign('DISTRIBUTORS',$distributors);
			}
			
			$contents[] = array('text'=>$box_content_smarty->fetch('ajax_categories_details.html'));
			$storages = $product->get_storages();
			if(sizeOf($storages)){
				$contents[] = array('text'=>'<p style="font-weight:bold;">'.TEXT_PRODUCTS_STORAGE_NUMBERS.'</p><div id="storage_container"></div>');
				/*
				$contents[] = array('ajax_toggle_content'=>array(
						'link'=>xtc_href_link('storage.php','action=info&products_id='.$pInfo->products_id),'text'=>'Lagerinfos',
						'unique_id'=>'storage_info'
					),
					'text'=>TEXT_PRODUCTS_STORAGE_NUMBERS
				);
				 * 
				 */
			}
		
			// OFFENE LIEFERANTENBESTELLUNGEN
			$distributor_orders = array();
			$do_query = xtc_db_query(sprintf("SELECT do.distributor_orders_id,do.distributor_id,DATE_FORMAT(do.estimated_date_receipt,'%%d.%%m.%%Y') as date_receipt,dop.products_quantity,dop.qty_rueckbuch,dop.collie_qty,dop.stuecklisten_id FROM distributor_orders do LEFT JOIN distributor_orders_products dop USING(distributor_orders_id) WHERE dop.products_id='%s' AND (do.orders_status='1' OR do.orders_status='2')",$pInfo->products_id));
			while($do = xtc_db_fetch_array($do_query)){
				$do['distributor_name'] = xtc_get_distributor_name($do['distributor_id']);
				$distributor_orders[] = $do;
			}
			if(sizeOf($distributor_orders)>0){
				$contents[] = array('text' => '<br /><b>'.TEXT_DISTRIBUTOR_ORDERS_OPEN.'</b>');
				$do_table =  '<table border="0" width="100%">';
				$do_table .= '<tr class="dataTableHeadingRow">';
				$do_table .= '	<td class="dataTableHeadingContent">'.TEXT_ORDER_SHORT.'</td>';
				$do_table .= '	<td class="dataTableHeadingContent">'.TEXT_DISTRIBUTOR.'</td>';
				$do_table .= '	<td class="dataTableHeadingContent">'.TEXT_QUANTITY.'</td>';
				$do_table .= '	<td class="dataTableHeadingContent">'.TEXT_DATE_EXPECTED.'</td>';
				$do_table .= '</tr>';
				foreach($distributor_orders as $k=>$order){
					$qty = ($order['stuecklisten_id'] > 0) ? $order['products_quantity']*$order['collie_qty'] : $order['products_quantity'];
					$qty_r = ($order['stuecklisten_id'] > 0) ? $order['qty_rueckbuch']*$order['collie_qty'] : $order['qty_rueckbuch'];
					$do_table .= '<tr class="dataTableRow">';
					$do_link = '<a href="'.xtc_href_link('distributor_orders.php','doID='.$order['distributor_orders_id'].'&action=edit').'" title="Lieferantenbestellung aufrufen">';
					$do_table .= '	<td class="dataTableContent">'.$do_link.'<u>'.$order['distributor_orders_id'].'</u></a></td>';
					if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['distributor'] == '1')) {
						$do_table .= '	<td class="dataTableContent">'.$order['distributor_name'].'</td>';
					}else{
						$do_table .= '	<td class="dataTableContent"><i>'.TEXT_NAME_HIDDEN.'</i></td>';
					}
					$do_table .= '	<td class="dataTableContent">'.$qty_r.'/'.$qty.'</td>';
					$do_table .= '	<td class="dataTableContent">'.(($order['date_receipt']!='00.00.0000')?$order['date_receipt']:'&nbsp;').'</td>';
					$do_table .= '</tr>';
				}
				$do_table .= '</table>';
				$contents[] = array('text' => $do_table);
			}
	    
			$contents[] = array('text' => '<b>' . TEXT_PRODUCTS_AVERAGE_RATING . '</b> ' . number_format($pInfo->average_rating, 2) . '%');
			if(isset($pInfo->amazon_flatfile)){
			    $contents[] = array('text'=>'<br />'.xtc_image('images/logo_amazon.gif'));
			    $contents[] = array(
				'text'=>sprintf('<b>%s:</b> %s',TEXT_AMAZON_FLATFILE,$pInfo->amazon_flatfile)
			    );
			    if($pInfo->amazon_browse_node_id != '' and $pInfo->amazon_flatfile != ''){
				$browse_node_text = '<br /><i>'.$ae->get_amazon_browse_node_title($pInfo->amazon_flatfile,$pInfo->amazon_browse_node_id).'</i>';
			    }
			    $contents[] = array(
				'text'=>sprintf('<b>%s:</b> %s',TEXT_AMAZON_BROWSE_NODE_ID,$pInfo->amazon_browse_node_id.$browse_node_text)
			    );
			}
			if(xtc_not_null($pInfo->products_ean))
				$contents[] = array('text' => '<b>'.TEXT_PRODUCTS_EAN.'</b> ' . $pInfo->products_ean);
			}
			
			
			
	break;
}
include(DIR_WS_CLASSES.'yes_table_block.php');
include(DIR_WS_CLASSES.'yes_box.php');
$box = new yes_box;
if(isset($box_image) and $box_image != ''){
	$box->image = $box_image;
}
header('Content-Type: text/html; charset='.CHARSET);
?>
<script type="text/javascript">
var YES_MODAL_FULLWIDTH = '1200';
var YES_MODAL_BIGWIDTH = '900';
$(function(){
<?php
if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['storage'] == '1')) {
?>
	$('#storage_container').load('<?php echo xtc_href_link('storage.php','action=info&products_id='.@$pInfo->products_id); ?>');
<?php
}else{
?>
	$('#storage_container').html('<i>Keine Berechtigung</i>');
<?php
}
?>
	$('.lbOn').click(function(){
		var url = this.id;
		var title = this.title;
		var width = YES_MODAL_WIDTH;
		if($(this).hasClass('bigWidth'))
			width = YES_MODAL_BIGWIDTH;
		if($(this).hasClass('fullWidth')){
			width = 'auto';
		}
		showPreloader();
		$('#modal_window').dialog({title: title,width: width, modal:true, maxHeight:YES_MODAL_HEIGHT}).load(url,function(){
			if($('#modal_window').height() >= YES_MODAL_HEIGHT )
				$('#modal_window').dialog('option','height',YES_MODAL_HEIGHT);
			hidePreloader();
		});
	});
});
function move_product_catselect(link){
    $('#m2c_container').dialog({
        modal: true,
        width: 'auto',
        height: 'auto',
        title: 'Kategorieauswahl'
    }).load(link);
}
function acd_quicknoteadd(){
    //$('#modal_window').dialog('option','width',900);
    toggleBox('addquicknote');
}
</script>
<?php
if (isset($cInfo) and is_object($cInfo)) { // category info box contents
    yes_draw_quicknote(xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('cPath','cID','action')).'cPath=' . $cPath . '_' . $cInfo->categories_id),false,'',true);
}
echo $box->infoBox($heading, $contents);
