<?php
/**
 * diese defines sind bei jedem System gleich - keine extra konfiguration
 */
include(__DIR__.'/includes/classes/amazon-sp/autoload.php');

include('includes/cron_application_top.php');
use SellingPartnerApi\Api\SellersV1Api as SellersApi;
use SellingPartnerApi\Configuration;
use SellingPartnerApi\Endpoint;

require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_WS_CLASSES.'amazon_sp.php');

// hier muss ein Switch rein, der bei multiusern immer den naechsten holt
$ASP_blank = new amazon_sp(null, false);
foreach($ASP_blank->auth_params->users as $cs=>$data){
    $current_seller = $cs;
}
$ASP = new amazon_sp($current_seller);


if(!defined('MODULE_OTHER_AMAZON_STATUS')){
    die('Amazon Modul not installed.');
}
$basics = new basics;

function prepare_data( $order ){
    
    $products = array();
    $items_in_order_processed = 0;
    $buyerInfo = $order->getBuyerInfo();
    if( is_null($buyerInfo) ){
        if(main::isDev(true)){
            $buyer_address = [
                'buyer_email'=>current($order->BillingData->BuyerEmailAddress),
                'buyer_name'=>$this->prepare_string(current($order->BillingData->BuyerName)),
                'buyer_phone_number'=>current($order->BillingData->BuyerPhoneNumber),
                'bill_name'=>$this->prepare_string(current($order->BillingData->Address->Name)),
                'bill_address_1'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldOne)),
                'bill_address_2'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldTwo)),
                'bill_address_3'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldThree)),
                'bill_city'=>$this->prepare_string(current($order->BillingData->Address->City)),
                'bill_state'=>$this->prepare_string(current($order->BillingData->Address->StateOrRegion)),
                'bill_postal_code'=>current($order->BillingData->Address->PostalCode),
                'bill_country_code'=>current($order->BillingData->Address->CountryCode),
                'bill_phone_number'=>current($order->BillingData->Address->PhoneNumber),
            ];
        }
    }else{
        $buyer_address = [
            'buyer_email'=>$buyerInfo->getBuyerEmail(),
            'buyer_name'=>$this->prepare_string($buyerInfo->getBuyerName()),
            'buyer_phone_number'=>null,
            'bill_name'=>$this->prepare_string(current($order->BillingData->Address->Name)),
            'bill_address_1'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldOne)),
            'bill_address_2'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldTwo)),
            'bill_address_3'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldThree)),
            'bill_city'=>$this->prepare_string(current($order->BillingData->Address->City)),
            'bill_state'=>$this->prepare_string(current($order->BillingData->Address->StateOrRegion)),
            'bill_postal_code'=>current($order->BillingData->Address->PostalCode),
            'bill_country_code'=>current($order->BillingData->Address->CountryCode),
            'bill_phone_number'=>current($order->BillingData->Address->PhoneNumber),
        ];
    }
    echo 'email: '.$amazon_order->getBuyerInfo()->getBuyerEmail()."\n";

    /**
     * Haben alle Artikel des Auftrags eine pID?
     * Wenn ein Artikel unbekannt ist, wird das Flag auf
     * false gesetzt und die Rechnung darf nicht importiert
     * werden
     */
    $valid_products_ids = true;
    $currency = 'EUR'; // IN DEN ITEMS SPEICHERN WIR DEN ZULETZT VERWENDETEN WERT ALS CURRENCY
    foreach($order->Item as $order_product){
            $item_orders_id = $this->get_orders_id_from_amazon_item(current($order->AmazonOrderID),$order_product->AmazonOrderItemCode);
            if($item_orders_id > 0)
                    $items_in_order_processed++;

            $item_prices = array();
            foreach($order_product->ItemPrice->children() as $component){
                    $item_amounts = array();
                    foreach($component->Amount as $amt){
                            $priceAtt = $amt->attributes();
                            $item_amounts[] = array(
                                    'amount'=>''.$amt,
                                    'currency'=>current($priceAtt['currency'])
                            );
                    }
                    $item_prices[] = array(
                            'type'=>current($component->Type),
                            'amounts'=>$item_amounts
                    );
            }
            $item_fees = array();
            $total_item_fee = 0;
            foreach($order_product->ItemFees->children() as $fee){
                    $priceAtt = $fee->Amount->attributes();
                    $item_fees[] = array(
                            'type'=>current($fee->Type),
                            'amount'=>''.$fee->Amount,
                            'currency'=>current($priceAtt['currency'])
                    );
                    $total_item_fee += $fee->Amount;
                    $currency = current($priceAtt['currency']);
            }
            $products_id = yes_get_products_id_from_amazon_sku(current($order_product->SKU),$request->Merchant);
            if(defined('MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID') and MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID > 0){
                    $products_id = MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID;
            }
            if($products_id < 1)
                    $valid_products_ids = false;

            $products[] = array(
                    'amazon_order_item_code'=>current($order_product->AmazonOrderItemCode),
                    'sku'=>current($order_product->SKU),
                    'products_id'=>$products_id,
                    'name'=>yes_decode_string(current($order_product->Title)),
                    'quantity_purchased'=>current($order_product->Quantity),
                    'product_tax_code'=>current($order_product->ProductTaxCode),
                    'price'=>$item_prices,
                    'fees'=>$item_fees,
                    'total_item_fee'=>$total_item_fee,
                    'orders_id'=>$item_orders_id
            );
    }
    $orders[] = array(
            'items_in_order_processed'=>$items_in_order_processed,
            'items_in_order'=>sizeOf($order->Item),
            'valid_products_ids'=>$valid_products_ids,
            'order_id' => current($order->AmazonOrderID),
            'session_id'=>current($order->AmazonSessionID),
            'purchase_date'=>current($order->OrderDate),
            'posted_date'=>current($order->OrderPostedDate),
            'buyer_email'=>current($order->BillingData->BuyerEmailAddress),
            'buyer_name'=>$this->prepare_string(current($order->BillingData->BuyerName)),
            'buyer_phone_number'=>current($order->BillingData->BuyerPhoneNumber),
            'bill_name'=>$this->prepare_string(current($order->BillingData->Address->Name)),
            'bill_address_1'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldOne)),
            'bill_address_2'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldTwo)),
            'bill_address_3'=>$this->prepare_string(current($order->BillingData->Address->AddressFieldThree)),
            'bill_city'=>$this->prepare_string(current($order->BillingData->Address->City)),
            'bill_state'=>$this->prepare_string(current($order->BillingData->Address->StateOrRegion)),
            'bill_postal_code'=>current($order->BillingData->Address->PostalCode),
            'bill_country_code'=>current($order->BillingData->Address->CountryCode),
            'bill_phone_number'=>current($order->BillingData->Address->PhoneNumber),
            'shipping_method'=>current($FF->FulfillmentMethod),
            'shipping_service_level'=>$order->getShipServiceLevel(),
            'shipment_service_level_category'=>$order->getShipmentServiceLevelCategory(),
            'recipient_name'=>$this->prepare_string(current($FF->Address->Name)),
            'ship_address_1'=>$this->_get_address_field(current($FF->Address->AddressFieldOne)),
            'ship_address_2'=>$this->_get_address_field(current($FF->Address->AddressFieldTwo)),
            'ship_address_3'=>$this->_get_address_field(current($FF->Address->AddressFieldThree)),
            'ship_city'=>$this->prepare_string(current($FF->Address->City)),
            'ship_state'=>$this->prepare_string(current($FF->Address->StateOrRegion)),
            'ship_postal_code'=>current($FF->Address->PostalCode),
            'ship_country_code'=>current($FF->Address->CountryCode),
            'ship_phone_number'=>current($FF->Address->PhoneNumber),
            'items'=>$products,
            'currency'=>$currency,
            'merchant_id'=>$request->Merchant,
        'IsPrime'=>(isset($order->IsPrime) and $order->IsPrime == 'true') ? true : false
    );
}

function import_order($amazon_order,$import_unknown_products = false){
        global $basics;
        if(!class_exists('product'))
                die("No class 'product' defined.");
        /**
         * Dieses Array enthaelt am Ende alle Werte die notwendigen Variablen
         * fuer den Bestellbestaetigung Feed
         */
        print_r($amazon_order);exit;
        $orders_created = array();
        $query = xtc_db_query(sprintf(
                "SELECT customers_id FROM amazon_orders WHERE buyer_email_address='%s and customers_id>0'",
                $amazon_order['buyer_email']
        ));
        // CUSTOMER HAS ALREADY AN AMAZON ORDER
        if(xtc_db_num_rows($query)){
                $record = xtc_db_fetch_array($query);
                $customers_id = $record['customers_id'];
                $query = xtc_db_query(sprintf(
                        "SELECT customers_default_address_id FROM customers WHERE customers_id='%s'",
                        $customers_id
                ));
                $record = xtc_db_fetch_array($query);
                $address_book_id = $record['customers_default_address_id'];
        }else{
                $query = xtc_db_query(sprintf(
                        "SELECT customers_default_address_id,customers_id FROM customers WHERE customers_email_address='%s'",
                        $amazon_order['buyer_email']
                ));
                // CUSTOMER IS REGISTERED IN CUSTOMERS
                if(xtc_db_num_rows($query)){
                        $record = xtc_db_fetch_array($query);
                        $customers_id = $record['customers_id'];
                        $address_book_id = $record['customers_default_address_id'];
                }else{
                        $password = $basics->generate_password();
                        $name_pairs = $this->get_name_pairs($amazon_order['buyer_name']);
                        $insert_sql_array = array(
                                'customers_email_address'=>$amazon_order['buyer_email'],
                                'customers_status'=>MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID,
                                'customers_firstname'=>$name_pairs['first_name'],
                                'customers_lastname'=>$name_pairs['last_name'],
                                'customers_default_address_id'=>'',
                                'customers_telephone'=>$amazon_order['buyer_phone_number'],
                                'customers_password'=>xtc_encrypt_password($password)
                        );
                        xtc_db_perform('customers',$insert_sql_array);
                        $customers_id = xtc_db_insert_id();

                        $name_pairs = $this->get_name_pairs($amazon_order['bill_name']);
                        $bill_country_id = yes_get_country_id_from_iso2($amazon_order['bill_country_code']);
                        $new = new \YES4Trade\Model\address_book([
                            'customers_id'=>(int)$customers_id,
                            'entry_company'=>'',
                            'entry_firstname'=>$name_pairs['first_name'],
                            'entry_lastname'=>$name_pairs['last_name'],
                            'entry_street_address'=>$amazon_order['bill_address_1'],
                            'entry_suburb'=>$amazon_order['bill_address_2'].(
                                    (!empty($amazon_order['bill_address_3']) ? ' '.$amazon_order['bill_address_3']:'')
                            ),
                            'entry_postcode'=>$amazon_order['bill_postal_code'],
                            'entry_city'=>$amazon_order['bill_city'],
                            'entry_state'=>$amazon_order['bill_state'],
                            'entry_country_id'=>(int)$bill_country_id,
                            'entry_zone_id'=>0,
                            'address_class'=>'',
                            'address_date_added'=>date('Y-m-d H:i:s')
                        ]);
                        $address_book_id = $new->create();

                        $query = xtc_db_query(sprintf(
                                "UPDATE customers SET customers_default_address_id='%s' WHERE customers_id='%s'",
                                $address_book_id,$customers_id
                        ));
                }
        }

        $cs_query = yes_db_query(sprintf(
                "SELECT customers_status_name, customers_status_image FROM customers_status WHERE customers_status_id='%s'",
                MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID
        ),true);
        if($cs_query){
                $cs = current($cs_query);
        }else{
                $cs = array('Unbekannt', '');
        }
        if(!isset($bill_country_id)) // FALLS ADRESSE SCHON BEKANNT
                $bill_country_id = yes_get_country_id_from_iso2($amazon_order['bill_country_code']);
        $ship_country_id = yes_get_country_id_from_iso2($amazon_order['ship_country_code']);
        $total_items = sizeOf($amazon_order['items']);

        foreach($amazon_order['items'] as $current_item_nr=>$product){
if($amazon_order['IsPrime'] === true){
//	yes_mail_debug(print_r($amazon_order,true));
}
                $orders_id = $this->get_orders_id_from_amazon_item($amazon_order['order_id'], $product['amazon_order_item_code']);
                if($orders_id > 0){
                        continue;
                }
                $YESproduct = new product($product['products_id']);
                if(!isset($YESproduct->info['products_id']) and !$import_unknown_products)
                                continue;

                unset($orders_id);
                $price_netto = 0;
                $price_brutto = 0;
                $products_tax = 0;
                $shipping_costs = 0;
                $shipping_tax = 0;
                $additional_costs = 0; // for amazon_features
                if($product['products_id'] <= 0){
                        $tax_class_id = MODULE_SHIPPING_AMAZON_TAX_CLASS;
                }else{
                    // EU OSS
                    $tax_class_id = yes_eu_oss_get_products_tax_class_id($product['products_id'], $ship_country_id);

                    //ALT: $tax_class_id = $YESproduct->info['products_tax_class_id'];
                }
                $tax_rate = xtc_get_tax_rate($tax_class_id,$ship_country_id);
                foreach($product['price'] as $price){
                        switch($price['type']){
                                case 'Principal':
                                        foreach($price['amounts'] as $amt){
                                                $price_netto += $amt['amount'] / ((100+$tax_rate)/100);
                                                $price_brutto += $amt['amount'];
                                                if(!isset($currency))
                                                        $currency = $amt['currency'];
                                        }
                                        break;
                                case 'Shipping':
                                        foreach($price['amounts'] as $amt){
                                                $shipping_costs += $amt['amount'];
                                        }
                                        break;
                                case 'ShippingTax':
                                        /**
                                         *  shippingtax berechnen wir separat - hier nur der
                                         * vollstaendigkeit halber
                                         */
                                        foreach($price['amounts'] as $amt){
                                                $shipping_tax += $amt['amount'];
                                        }
                                        break;
                                case 'Tax':
                                        foreach($price['amounts'] as $amt){
                                                $tax += $amt['amount'];
                                        }
                                        break;
                                default:
                                        echo '<h4>Achtung: Unbekannte Preiskomponente. Bitte informieren Sie das YES4trade Team</h4><pre>';
                                        print_r($price);
                                        echo '</pre>';
                                        exit;
                                        break;
                        }
                }


                $a1 = $this->_get_address_field($amazon_order['ship_address_1'],false);
                $a2 = $this->_get_address_field($amazon_order['ship_address_2'],false);
                $a3 = $this->_get_address_field($amazon_order['ship_address_3'],false);
                if(empty($a2)){
                        $delivery_street_address = $a1;
                        $delivery_company = '';
                        $delivery_suburb = $a2;
                        if($a3 != ''){
                                $delivery_suburb .= ' '.$a3;
                        }
                }else{
                        $delivery_street_address = $a2;
                        $delivery_company = $a1;
                        $delivery_suburb = $a3;
                }

                $customers_company = '';
                $customers_street_address = '';
                $customers_suburb = '';
                if(empty($amazon_order['bill_address_2'])){
                        $customers_street_address = $amazon_order['bill_address_1'];
                        $customers_company = '';
                        $customers_suburb = $amazon_order['bill_address_2'].(
                                        (!empty($amazon_order['bill_address_3']) ? ' '.$amazon_order['bill_address_3']:'')
                        );
                }else{
                        $customers_street_address = $amazon_order['bill_address_2'];
                        $customers_company = $amazon_order['bill_address_1'];
                        $customers_suburb = $amazon_order['bill_address_3'];
                }
                $billing_company = $customers_company;
                $billing_street_address = $customers_street_address;
                $billing_suburb = $customers_suburb;

                $shipping_class = 'amazon';
                if(in_array(strtolower($amazon_order['shipping_service_level']),array('nextday','secondday'))){
                    $shipping_class .= '_'.strtolower($amazon_order['shipping_service_level']);
                }

                $insert_sql_array = array(
                        'customers_id'=>$customers_id,
                        'customers_cid'=>'',
                        'customers_vat_id'=>'',
                        'customers_status'=>MODULE_OTHER_AMAZON_CUSTOMERS_STATUS_ID,
                        'customers_status_name'=>$cs['customers_status_name'],
                        'customers_status_image'=>$cs['customers_status_image'],
                        'customers_status_discount'=>0,
                        'customers_name'=>$amazon_order['buyer_name'],
                        'customers_company'=>$customers_company,
            'customers_street_address'=>$customers_street_address,
            'customers_suburb'=>$customers_suburb,
                        'customers_city'=>$amazon_order['bill_city'],
                        'customers_postcode'=>$amazon_order['bill_postal_code'],
                        'customers_state'=>$amazon_order['bill_state'],
                        'customers_country'=>xtc_get_country_name($bill_country_id),
                        'customers_telephone'=>$amazon_order['buyer_phone_number'],
                        'customers_mobile'=>'',
                        'customers_email_address'=>$amazon_order['buyer_email'],
                        'customers_address_format_id'=>AMAZON_ADDRESS_FORMAT_ID,
                        'delivery_name'=>$amazon_order['recipient_name'],
                        'delivery_company'=>$delivery_company,
            'delivery_street_address'=>$delivery_street_address,
            'delivery_suburb'=>$delivery_suburb,
                        'delivery_city'=>$amazon_order['ship_city'],
                        'delivery_postcode'=>$amazon_order['ship_postal_code'],
                        'delivery_state'=>$amazon_order['ship_state'],
                        'delivery_country'=>xtc_get_country_name($ship_country_id),
                        'delivery_address_format_id'=>AMAZON_ADDRESS_FORMAT_ID,
                        'billing_name'=>$amazon_order['buyer_name'],
                        'billing_company'=>$billing_company,
            'billing_street_address'=>$billing_street_address,
            'billing_suburb'=>$billing_suburb,
                        'billing_city'=>$amazon_order['bill_city'],
                        'billing_postcode'=>$amazon_order['bill_postal_code'],
                        'billing_state'=>$amazon_order['bill_state'],
                        'billing_country'=>xtc_get_country_name($bill_country_id),
                        'billing_address_format_id'=>AMAZON_ADDRESS_FORMAT_ID,
                        'payment_method'=>'amazon_payment',
                    // ticket 2508
                        'comments'=>'',/*sprintf(
                                'AMAZON IMPORT %s %s/%s',
                                $amazon_order['order_id'],
                                ($current_item_nr+1),$total_items
                        ),*/
                        'date_purchased'=>$amazon_order['purchase_date'],
                        'orders_status'=>MODULE_PAYMENT_AMAZON_ORDER_STATUS_ID,
                        'orders_date_finished'=>null,
                        'currency'=>$amazon_order['currency'],
                        'currency_value'=>0.000000,
                        'account_type'=>0,
                        'payment_class'=>'amazon_payment',
                        'shipping_method'=>$amazon_order['shipping_method'].'_'.$amazon_order['shipping_service_level'],
                        'shipping_class'=>$shipping_class,
                        'language'=>'german',
                        'source'=>'amazon',
                    'amazon_prime'=>(int)$amazon_order['IsPrime']
                );
                xtc_db_perform('orders',$insert_sql_array);
                $orders_id = xtc_db_insert_id();
                $insert_sql_array = array(
                        'orders_id'=>$orders_id,
                        'customers_id'=>$customers_id,
                        'orig_amazon_orders_id'=>$amazon_order['order_id'],
                        'date_created'=>$amazon_order['purchase_date'],
                        'buyer_name'=>$amazon_order['buyer_name'],
                        'buyer_email_address'=>$amazon_order['buyer_email'],
                        'buyer_telephone_number'=>$amazon_order['buyer_phone_number'],
                        'shipping_method'=>$amazon_order['shipping_method'],
                        'shipping_method_service_level'=>$amazon_order['shipping_service_level'],
                        'merchant_id'=>$amazon_order['merchant_id']
                );
                xtc_db_perform('amazon_orders',$insert_sql_array);
                $amazon_orders_id = xtc_db_insert_id();

                $insert_sql_array = array(
                        'amazon_orders_id'=>$amazon_orders_id,
                        'amazon_order_item_code'=>$product['amazon_order_item_code'],
                        'sku'=>$product['sku'],
                        'title'=>$product['name'],
                        'quantity'=>$product['quantity_purchased'],
                        'product_tax_code'=>$product['product_tax_code'],
                        'promotion_claim_code'=>$product['promotion_claim_code'],
                        'merchant_promotion_id'=>$product['merchant_promotion_id'],
                        'item_fees'=>$product['total_item_fee'],
                        'price_principal'=>$price_brutto,
                        'price_shipping'=>$shipping_costs,
                        'price_tax'=>$tax,
                        'price_shipping_tax'=>$shipping_tax
                );
                xtc_db_perform('amazon_orders_products',$insert_sql_array);
                $pname = $product['name'];
                if($product['products_id'] > 0 and defined('MODULE_OTHER_AMAZON_PRODUCTS_NAME_FROM_AMAZON') and MODULE_OTHER_AMAZON_PRODUCTS_NAME_FROM_AMAZON == 'True'){
                        if($product['products_id'] != MODULE_OTHER_AMAZON_DUMMY_PRODUCTS_ID){
                                $pname = xtc_get_products_name($product['products_id']);
                        }
                }
                $insert_sql_array = array(
                        'orders_id'=>$orders_id,
                        'products_id'=>$product['products_id'],
                        'products_model'=>$YESproduct->info['products_model'],
                        'products_name'=>$pname,
                        'products_price'=>($price_brutto / $product['quantity_purchased']),
                        'products_discount_made'=>0,
                        'final_price'=>$price_brutto,
                        'products_tax'=>$tax_rate,
                        'products_quantity'=>$product['quantity_purchased'],
                        'allow_tax'=>1,
                        'date_added'=>'now()',
                        'amazon_order_item_code'=>$product['amazon_order_item_code'],
                        'amazon_sku'=>$product['sku']
                );
                xtc_db_perform('orders_products',$insert_sql_array);
                $opID = xtc_db_insert_id();

                // AUS AMAZON_PRODUCTS SUBTRAHIEREN
                $query = yes_db_query(sprintf(
                        "SELECT quantity FROM amazon_products WHERE products_id='%s'",
                        $product['products_id']
                ));
                $record = current($query);
                if($record['quantity'] > 0 and $product['products_id'] >= 0){
                        xtc_db_query(sprintf(
                                "UPDATE amazon_products SET quantity=quantity-%s WHERE products_id='%s'",
                                $product['quantity_purchased'],
                                $product['products_id']
                        ));
                }

                // -------------------------------------------
                // VERKAUFTE-PRODUKTE-COUNTER IN products HOCHSETZEN
                // -------------------------------------------
                if($product['products_id'] >= 0){
                        xtc_db_query("update " . TABLE_PRODUCTS . " set products_ordered = products_ordered + " . sprintf('%d', $product['quantity_purchased'] ). " where products_id = '" . $product['products_id'] . "'");
                        if( sizeOf($YESproduct->collies)>0 and STOCK_ALLOW_CHECKOUT != 'true' ){
                                foreach($YESproduct->collies as $k=>$collie){
                                        xtc_db_query("update " . TABLE_PRODUCTS . " set products_ordered = products_ordered + " . sprintf('%d', $product['quantity_purchased'] * $collie['quantity'] ). " where products_id = '" . $product['collie_products_id'] . "'");
                                }
                        }
                }

                if($product['products_id'] > 0 and defined('EBAY_END_AUCTION_AT_SHOPORDER') and EBAY_END_AUCTION_AT_SHOPORDER == 'True'){
                        yes_end_auction_add($product['products_id'],$product['quantity_purchased']);
                }
                // -------------------------------------------
                // SUBTOTAL
                // -------------------------------------------
                $orders_total_subtotal_array = array(
                        'orders_id'=>$orders_id,
                        'title'=>MODULE_ORDER_TOTAL_SUBTOTAL_TITLE.':',
                        'text'=>number_format($price_brutto,2,',','.').' '.$currency,
                        'value'=>$price_brutto,
                        'class'=>'ot_subtotal',
                        'sort_order'=>MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER
                );
                xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_subtotal_array);

                // -------------------------------------------
                // SHIPPINGTOTAL
                // -------------------------------------------
                $orders_total_shipping_array = array(
                        'orders_id'=>$orders_id,
                        'title'=>sprintf(TEXT_AMAZON_SHIPPING_TITLE,
                                $amazon_order['shipping_method'],
                                $amazon_order['shipping_service_level']
                        ),
                        'text'=>number_format($shipping_costs,2,',','.').' '.$currency,
                        'value'=>$shipping_costs,
                        'class'=>'ot_shipping',
                        'sort_order'=>MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER
                );
                xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_shipping_array);

                // -------------------------------------------
                // VATTOTAL
                // -------------------------------------------
                // WIR BERECHNEN UNSERE EIGENE SHIPPINGCOSTS-MWST
//TAXRATEPERCENT	$shipping_tax_rate = xtc_get_tax_rate(MODULE_SHIPPING_AMAZON_TAX_CLASS,STORE_COUNTRY);
//			$shipping_tax_rate =$tax_rate;
                if($shipping_costs > 0){
                    $shipping_costs_netto = $shipping_costs / ((100+$tax_rate)/100);
                }else{
                    $shipping_costs_netto = 0; // nicht durch null teilen, darum so
                }
                $shipping_tax = $shipping_costs - $shipping_costs_netto;
                $products_price_tax = ($price_brutto - $price_netto);
                /**
                 * Versand Steuerklasse gleich Produkt Steuerklasse
                 * Wir addieren beide und haben die gesamte Steuer
                 */
                $ot_tax_value = $shipping_tax + $products_price_tax;
                $orders_total_tax_array = array(
                        'orders_id'=>$orders_id,
                        'title'=>sprintf(AMAZON_TOTAL_TAX_TITLE,
                                number_format($tax_rate,0,',','.')),
                        'text'=> number_format($ot_tax_value,2,',','.' ).' '.$currency,
                        'value'=>$ot_tax_value,
                        'class'=>'ot_tax',
                        'sort_order'=>MODULE_ORDER_TOTAL_TAX_SORT_ORDER,
                    'tax_rate_percent'=>$tax_rate
                );
                xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_tax_array);

                // -------------------------------------------
                // TOTAL
                // -------------------------------------------
                $orders_total_total_array = array(
                        'orders_id'=>$orders_id,
                        'title'=>MODULE_ORDER_TOTAL_TOTAL_TITLE,
                        'text'=>number_format($price_brutto+$shipping_costs+$additional_costs,2,',','.').' '.$currency,
                        'value'=>$price_brutto+$shipping_costs+$additional_costs,
                        'class'=>'ot_total',
                        'sort_order'=>MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER
                );
                xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_total_array);

                // ----------------------------------------------------
                // IN BESTELLHISTORIE HINZUFUEGEN orders_status_history
                // ----------------------------------------------------
                $customer_notification = (SEND_EMAILS == 'true') ? '1' : '0';
                $order_history_sql_array = array(
                        'orders_id' => $orders_id,
                        'orders_status_id' => MODULE_PAYMENT_AMAZON_ORDER_STATUS_ID,
                        'date_added' => 'now()',
                        'customer_notified' => $customer_notification,
                        'comments' => sprintf(TEXT_AMAZON_ORDER_IMPORTED,
                                $amazon_order['order_id']
                        )
                );
                xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $order_history_sql_array);
                $orders_created[] = array(
                        'merchant_orders_id'=>$orders_id,
                        'amazon_orders_id'=>$amazon_order['order_id'],
                        'items'=>array(0=>array(
                                'amazon_order_item_code'=>$product['amazon_order_item_code'],
                                'merchant_order_item_id'=>$opID
                        ))
                );
        }
        if(sizeOf($orders_created))
                return $orders_created;
        else
                return array();
}
$apiInstance = new SellingPartnerApi\Api\TokensV20210301Api($ASP->configObj);
$orderId = '303-3809296-8800321';
$resource = new SellingPartnerApi\Model\TokensV20210301\RestrictedResource([
    "method" => "GET",
    "path" => "/orders/v0/orders/'.$orderId.'/buyerInfo",
    //"path" => "/orders/v0/orders/$orderId/address",
    //"data_elements" => ["buyerInfo", "shippingAddress"]
]);
// \SellingPartnerApi\Model\TokensV20210301\CreateRestrictedDataTokenRequest | The restricted data token request details.
$body_data = [
    "target_application" => "amzn1.sellerapps.app.target-application",
    "restricted_resources" => [$resource],
];

$body = new \SellingPartnerApi\Model\TokensV20210301\CreateRestrictedDataTokenRequest($body_data);

$result = $apiInstance->createRestrictedDataToken($body);
$RDT = $result->getRestrictedDataToken();
$ASP->configObj->setLwaRefreshToken($RDT);
$apiInstance = new SellingPartnerApi\Api\OrdersV0Api($ASP->configObj);

$CreatedAfter = '2023-10-01T22:00:00';

$MarketplaceIds = ["A1PA6795UKMFR9"];
try {
    $result = $apiInstance->getOrder($orderId,['buyerInfo']);
} catch (Exception $e) {
    echo 'Exception when calling ReportsV20210630Api->getOrders: ', $e->getMessage(), PHP_EOL;
    exit;
}
$payload = $result->getPayload();
print_r($payload);
exit;

foreach($payload->getOrders() as $o){
    
    
    /*
    $ASP->configObj->setLwaClientId($RDT);
    */
    
    
    //import_order($o);
    print_r($o);
    continue;
    exit;
    try {
        $addr_result = $apiInstance->getOrderAddress($o->getAmazonOrderId());
        print_r($addr_result);
    } catch (Exception $e) {
        echo 'Exception when calling ReportsV20210630Api->getOrderAdress('.$addressOrderId.'): ', $e->getMessage(), PHP_EOL;
        exit;
    }
    
    echo $o->getAmazonOrderId()."\n";
}
