<?php
$cID = intval($_GET['cID']??0);
$abID =  intval($_GET['abID']??0);
if($cID == 0){
    $messageStack->add_session('Invalid customers_id','error');
    xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS));
}
$delete_address_book = intval($_GET['delete_address_book']??0);
if($delete_address_book > 0){
    if(intval($customer->customers_default_address_id) != $delete_address_book){
        \YES4Trade\Model\address_book::delete($delete_address_book);
        $memo = new \YES4Trade\Model\customers_memo([
            'customers_id'=>$cID,
            'memo_date'=>date('Y-m-d H:i:s'),
            'memo_title'=>MEMO_ADDRESS_BOOK_DELETED_TITLE,
            'memo_text'=>sprintf(MEMO_ADDRESS_BOOK_DELETED,$delete_address_book),
            'poster_id'=>intval($_SESSION['customer_id'])
        ]);
        $memo->create();
        $messageStack->add_session(HISTORY_MEMO_ADDRESS_BOOK_ENTRY_DELETE,'success');
    }else{
        $messageStack->add_session(MSG_ERROR_DEFAULT_ADDRESS_NO_DELETE,'error');
    }
    xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(['delete_address_book'])));
}
$update_default_address_book_id = intval($_GET['update_default_address_book_id']??0);
if($update_default_address_book_id > 0){
    $upd = new \YES4Trade\Model\customers([
        'customers_id'=>$cID,
        'customers_last_modified'=>date('Y-m-d H:i:s'),
        'customers_default_address_id'=>$update_default_address_book_id
    ]);
    $upd->update();
    $memo = new \YES4Trade\Model\customers_memo([
        'customers_id'=>$cID,
        'memo_date'=>date('Y-m-d H:i:s'),
        'memo_title'=>'Neue Defaultadresse',
        'memo_text'=>sprintf(MEMO_ADDRESS_BOOK_DEFAULT_CHANGED,$update_default_address_book_id),
        'poster_id'=>intval($_SESSION['customer_id'])
    ]);
    $memo->create();
    $messageStack->add_session(HISTORY_MEMO_NEW_DEFAULT_ADDRESS_BOOK_ENTRY,'success');
    xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(['update_default_address_book_id'])));
}
$customer = \YES4Trade\Model\customers::get_by_customers_id($cID);
if(isset($_POST['entry_country_id'])){
    // update
    $update = ($abID > 0)?true:false;
    $data = [
        'entry_gender' => $_POST['entry_gender']??'',
        'entry_company' => $_POST['entry_company']??'',
        'entry_firstname' => $_POST['entry_firstname']??'',
        'entry_lastname' => $_POST['entry_lastname']??'',
        'entry_street_address' => $_POST['entry_street_address']??'',
        'entry_suburb' => $_POST['entry_suburb']??'',
        'entry_postcode' => $_POST['entry_postcode']??'',
        'entry_city' => $_POST['entry_city']??'',
        'entry_country_id' => intval($_POST['entry_country_id']??0),
        'entry_zone_id' => intval($_POST['entry_zone_id']??0),
        'address_class' => $_POST['address_class']??'customer',
    ];
    if($update === false){
        $data['customers_id'] = $cID;
        $data['address_date_added'] = date('Y-m-d H:i:s');
        $create = new \YES4Trade\Model\address_book($data);
        $abID = $create->create();
        $memo = new \YES4Trade\Model\customers_memo([
            'customers_id'=>$cID,
            'memo_date'=>date('Y-m-d H:i:s'),
            'memo_title'=>sprintf(MEMO_ADDRESS_BOOK_ADDED,$abID),
            'memo_text'=>implode(', ', array_map(
                fn($k, $v) => "$k: $v",
                    array_keys($data),
                    $data
                )
            ),
            'poster_id'=>intval($_SESSION['customer_id'])
        ]);
        $memo->create();
        $msg = MSG_SUCCESS_ADDRESS_CREATE;
    }else{
        $data['address_book_id'] = $abID;
        $data['address_last_modified'] = date('Y-m-d H:i:s');
        $upd = new \YES4Trade\Model\address_book($data);
        $upd->update();
        $memo = new \YES4Trade\Model\customers_memo([
            'customers_id'=>$cID,
            'memo_date'=>date('Y-m-d H:i:s'),
            'memo_title'=>sprintf(MEMO_ADDRESS_BOOK_UPDATED,$abID),
            'memo_text'=>implode(', ', array_map(
                fn($k, $v) => "$k: $v",
                    array_keys($data),
                    $data
                )
            ),
            'poster_id'=>intval($_SESSION['customer_id'])
        ]);
        $memo->create();
        $msg = MSG_SUCCESS_ADDRESS_UPDATE;
    }
    $messageStack->add_session($msg,'success');
    xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(['insert','abID']).'abID='.$abID));
}

$insert_mode = intval($_GET['insert']??0);
$address_books = \YES4Trade\Model\address_book::get_by_customers_id($cID);
$edit = [];
$edit_base_id = 0;
if($abID > 0 and $insert_mode == 0){
    foreach($address_books as $abNr=>$ab){
        if(intval($ab->address_book_id) == $abID){
            $edit_base_id = $abNr;
        }
    }
    $edit_base = $address_books[$edit_base_id]->toArray();
}else if($insert_mode == 1){
    $edit_base = [
        'entry_gender' => 'm',
        'entry_company' => '',
        'entry_firstname' => '',
        'entry_lastname' => '',
        'entry_street_address' => '',
        'entry_suburb' => '',
        'entry_postcode' => '',
        'entry_city' => '',
        'entry_country_id' => yes_get_store_country_id(),
        'entry_zone_id' => 0,
        'address_class' => 'customer',
    ];
}else{
    $edit_base = $address_books[$edit_base_id]->toArray();
}

setlocale(LC_TIME, 'de_DE.UTF-8');
foreach($edit_base as $k=>$v){
    $value = $v;
    $display = true;
    switch($k){
        case 'address_book_id':
        case 'entry_zone_id':
        case 'customers_id':
            $display = false;
            break;
        case 'entry_gender':
            $name = constant(strtoupper($k));
            $value = xtc_draw_pull_down_menu($k,[['id'=>'','text'=>TEXT_SELECT],['id'=>'m','text'=>MALE],['id'=>'f','text'=>FEMALE]],$v);
            break;
        case 'entry_firstname':
            $name = ENTRY_FIRST_NAME;
            $value = xtc_draw_input_field($k, $v);
            break;
        case 'entry_lastname':
            $name = ENTRY_LAST_NAME;
            $value = xtc_draw_input_field($k, $v);
            break;
        case 'entry_postcode':
            $name = ENTRY_POST_CODE;
            $value = xtc_draw_input_field($k, $v, 'size="8"');
            break;
        case 'entry_country_id':
            $name = ENTRY_COUNTRY;
            $value = xtc_draw_pull_down_menu($k, xtc_get_countries(),$v );
            break;
        case 'entry_state':
            $name = constant(strtoupper($k));

            if (defined('ACCOUNT_STATE') and constant('ACCOUNT_STATE') == 'true') {
                $zones_array = array();
                $zones_query = xtc_db_query("select zone_name from " . TABLE_ZONES . " where zone_country_id = '" . $edit_base['entry_country_id'] . "' order by zone_name");
                while ($zones_values = xtc_db_fetch_array($zones_query)) {
                    $zones_array[] = array('id' => $zones_values['zone_name'], 'text' => $zones_values['zone_name']);
                }
                $value = xtc_draw_pull_down_menu($k,$zones_array,$v);
            }else{
                $display = false;
            }
            break;
        case 'address_class':
            $name = ENTRY_ADDRESS_CLASS;
            $address_classes = yes_get_address_book_classes();
            $value = xtc_draw_pull_down_menu($k,$address_classes,$v);
            break;
        case 'address_date_added':
            $name = ENTRY_DATE_CREATED;
            if($v == '-0001-11-30T00:00:00.000Z'){
                $value = '';
            }else{
                try {
                    $date = new \DateTime($v, new DateTimeZone('UTC'));
                    $formatter = new IntlDateFormatter(
                        'de_DE',
                        IntlDateFormatter::FULL,
                        IntlDateFormatter::NONE,
                        'UTC',
                        null,
                        $format
                    );
                    $value = $formatter->format($date);
                } catch (Exception $e) {
                    echo $e->getMessage();
                    $value = '';
                }
            }
            break;
        case 'address_last_modified':
            $name = ENTRY_LAST_MODIFIED;
            if($v == '-0001-11-30T00:00:00.000Z'){
                $value = '';
            }else{
                try {
                    $date = new \DateTime($v, new DateTimeZone('UTC'));
                    $formatter = new IntlDateFormatter(
                        'de_DE',
                        IntlDateFormatter::FULL,
                        IntlDateFormatter::NONE,
                        'UTC',
                        null,
                        $format
                    );
                    $value = $formatter->format($date);
                } catch (Exception $e) {
                    echo $e->getMessage();
                    $value = '';
                }
            }
            break;
        default:
            $name = constant(strtoupper($k));
            $value = xtc_draw_input_field($k, $v);
            break;
    }
    if($display === true){
        $edit[] = [
            'name'=>$name,'value'=>$value
        ];
    }
}

$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
$contents = [[
    ['text'=>'ID','th'=>true],
    ['text'=>str_replace(':','',ENTRY_NAME),'th'=>true],
    ['text'=>'Info','th'=>true],
    ['text'=>'Aktion','th'=>true],
]];
foreach($address_books as $ab_nr=>$ab){
    $comp = (!empty($ab->entry_company))?$ab->entry_company.', ':'';
    $dateC = 'unbekannt';
    if($ab->address_date_added->format('Y') > 2000){
        $dateC = $ab->address_date_added->format('d.m.Y');
    }
    $def = false;
    if(intval($customer->customers_default_address_id) == intval($ab->address_book_id)){
        $def = true;
    }
    $edit_link = sprintf('<a href="%s" style="text-decoration:none;" title="%s"><button type="button" class="ui-button" style="padding: 4px;font-size: 1.3em;">&#128393;</button></a>',
        xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('abID')).'abID='.$ab->address_book_id),
        IMAGE_EDIT
    );
    if($abID == intval($ab->address_book_id)){
        $id = $ab->address_book_id;
    }
    $text = $comp.$ab->entry_firstname.' '.$ab->entry_lastname;
    if(strlen($text)>45){
        $text = substr($text,0,45).'...';
    }
    $toggle_def = sprintf('<a href="javascript:;" style="text-decoration: none;" data-abid="%d" class="toggle_default"><button type="button" class="ui-button" style="padding: 4px;font-size: 1.5em;">%s</button></a>',
        $ab->address_book_id, '&#10026;'
    );
    $actions = [];
    if($abID != intval($ab->address_book_id)){
        if($abID == 0 and $ab_nr == 0){
        }else{
            $actions[] = $edit_link;
        }
    }
    if(!$def){
        $actions[] = $toggle_def;
    }
    if(intval($customer->customers_default_address_id) != intval($ab->address_book_id)){
        $actions[] = sprintf(
            '<a class="delete_address_book" data-abid="%d" title="%s"><button type="button" class="ui-button ui-state-error" style="padding: 4px;font-size: 1.5em;">&#10006;</button></a>',
            $ab->address_book_id, IMAGE_DELETE, IMAGE_DELETE
        );
    }
    $default_info = '';
    if($def){
        $default_info = sprintf('<span style="font-size: 1.5em;color: green; font-weight: bold;margin-right: 5px;">&#10026;</span>');
    }
    $contents[] = [
        ['text'=>$default_info.$ab->address_book_id],
        ['text'=>$text],
        ['text'=>(($ab->address_class != '')?yes_get_address_book_class_name($ab->address_class):TEXT_NO_ADDRESS_BOOK_CLASS).'<br />'.TEXT_ADDRESS_BOOK_CREATED.': '.$dateC],
        ['text'=>implode('&nbsp;',$actions),'align'=>'right'],
        'params'=>($insert_mode != 1 and $abID == $ab->address_book_id or ($abID == 0 and $ab_nr == 0))?'class="highlight"':''
    ];
}
$smarty = new \yesSmarty;
$smarty->assign([
    'PAGE_HEADING_MENU_BUTTONS'=>[
        [
            'text'=>IMAGE_BACK,
            'link'=>xtc_href_link('customers.php',xtc_get_all_get_params(array('abID','action')).'action=edit'),
            'auth'=>true,
            'lbOn'=>false
        ],
        [
            'text'=>ADD_ADDRESS_BOOK,
            'link'=>xtc_href_link('customers.php',xtc_get_all_get_params(array('insert')).'insert=1'),
            'auth'=>true,
            'lbOn'=>false
        ]
    ],
    'ABID'=>$edit_base['address_book_id'],
    'INSERT_MODE'=>$insert_mode,
    'HEADING_TITLE'=>ADDRESS_BOOKS_HEADING_TITLE,
    'ADDITIONAL_HEADING_TITLE'=>'Customer ID '.$customer->customers_id.': '.$customer->customers_firstname.' '.$customer->customers_lastname,
    'ADD_ADDRESS_BOOK'=>ADD_ADDRESS_BOOK,
    'ADDRESS_BOOK_ENTRY'=>ADDRESS_BOOK_ENTRY,
    'ADDRESS_BOOKS'=>$table->tableBlock_draw($contents),
    'ADDRESS_BOOK'=>$edit,
    'UPDATE_FORM'=>xtc_draw_form('address_book_update',FILENAME_CUSTOMERS,xtc_get_all_get_params(array('abID')).'abID='.$edit_base['address_book_id']),
    'DEFAULT_ADDRESS_BOOK_ID'=>"".$customer->customers_default_address_id,
    'JS_REALLY_TOGGLE_DEFAULT_ADDRESS_BOOK'=>JS_REALLY_TOGGLE_DEFAULT_ADDRESS_BOOK,
    'TOGGLE_DEFAULT_ADDRESS_BOOK_LINK'=>xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('update_default_address_book_id')).'update_default_address_book_id='),
    'TEXT_NEW_ADDRESS_BOOK_ENTRY'=>TEXT_NEW_ADDRESS_BOOK_ENTRY,
    'DELETE_ADDRESS_BOOK_LINK' => xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('delete_address_book')).'delete_address_book='),
    'JS_CONFIRM_REALLY_DELETE_ADDRESS_BOOK_ENTRY' => JS_CONFIRM_REALLY_DELETE_ADDRESS_BOOK_ENTRY
]);
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty->display('address_books.html');
