<?php
require ('includes/application_top.php');
require_once(DIR_WS_CLASSES.'yes_shipping.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_CLASSES.'yes_dhl_api.php');
require_once (DIR_WS_CLASSES.'order.php');
require_once (DIR_WS_CLASSES.'reclamation.php');
require_once (DIR_FS_CATALOG.DIR_WS_CLASSES.'xtcPrice.php');
require_once (DIR_FS_INC.'xtc_php_mail.inc.php');
require_once (DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
require_once (DIR_FS_INC.'xtc_collis.inc.php');


$valid_services=array();
$valid_services['V01PAK']=array(
    'DayOfDelivery' => '0',
    'DeliveryTimeframe' => '0', 
    'PreferredTime' => '1',
    'IndividualSenderRequirement' => '1', 
    'PackagingReturn' => '1', 
    'ReturnImmediately' => '0', 
    'NoticeOfNonDeliverability' => '1', 
    'ShipmentHandling' => '0', 
    'Endorsement' => '0', 
    'VisualCheckOfAge' => '1', 
    'PreferredLocation' => '1', 
    'PreferredNeighbour' => '1', 
    'PreferredDay' => '1',
    'GoGreen' => '1', 
    'Perishables' => '0', 
    'Personally' => '1', 
    'NoNeighbourDelivery' => '1',
    'NamedPersonOnly' => '1', 
    'ReturnReceipt' => '0', 
    'Premium' => '0', 
    'CashOnDelivery' => '1', 
    'AdditionalInsurance' => '1', 
    'BulkyGoods' => '1', 
    'IdentCheck' => '1',
    'Return' => '1',
    'PrintOnlyIfCodeable' => '1',
    'Endorsement'=>'0'
);

$valid_services['V53WPAK']=array(
    'DayOfDelivery' => '0',
    'DeliveryTimeframe' => '0', 
    'PreferredTime' => '0',
    'IndividualSenderRequirement' => '0', 
    'PackagingReturn' => '0', 
    'ReturnImmediately' => '0', 
    'NoticeOfNonDeliverability' => '0', 
    'ShipmentHandling' => '0', 
    'Endorsement' => '1', 
    'VisualCheckOfAge' => '0', 
    'PreferredLocation' => '0', 
    'PreferredNeighbour' => '0', 
    'PreferredDay' => '0',
    'GoGreen' => '1', 
    'Perishables' => '0', 
    'Personally' => '0', 
    'NoNeighbourDelivery' => '0',
    'NamedPersonOnly' => '0', 
    'ReturnReceipt' => '1', 
    'Premium' => '1', 
    'CashOnDelivery' => '1', 
    'AdditionalInsurance' => '1', 
    'BulkyGoods' => '1', 
    'IdentCheck' => '0',
    'Return' => '0',
    'PrintOnlyIfCodeable' => '1',
    'Endorsement'=>'1'
);

$valid_services['V86PARCEL']=array(
    'DayOfDelivery' => '0',
    'DeliveryTimeframe' => '0', 
    'PreferredTime' => '0',
    'IndividualSenderRequirement' => '0', 
    'PackagingReturn' => '0', 
    'ReturnImmediately' => '0', 
    'NoticeOfNonDeliverability' => '0', 
    'ShipmentHandling' => '0', 
    'Endorsement' => '0', 
    'VisualCheckOfAge' => '0', 
    'PreferredLocation' => '0', 
    'PreferredNeighbour' => '0', 
    'PreferredDay' => '0',
    'GoGreen' => '0', 
    'Perishables' => '0', 
    'Personally' => '0', 
    'NoNeighbourDelivery' => '0',
    'NamedPersonOnly' => '0', 
    'ReturnReceipt' => '0', 
    'Premium' => '0', 
    'CashOnDelivery' => '1', 
    'AdditionalInsurance' => '1', 
    'BulkyGoods' => '1', 
    'IdentCheck' => '0',
    'Retoure' => '0',
    'PrintOnlyIfCodeable' => '1',
    'Endorsement'=>'0'
);

$valid_services['V87PARCEL']=array(
    'DayOfDelivery' => '0',
    'DeliveryTimeframe' => '0', 
    'PreferredTime' => '0',
    'IndividualSenderRequirement' => '0', 
    'PackagingReturn' => '0', 
    'ReturnImmediately' => '0', 
    'NoticeOfNonDeliverability' => '0', 
    'ShipmentHandling' => '0', 
    'Endorsement' => '0', 
    'VisualCheckOfAge' => '0', 
    'PreferredLocation' => '0', 
    'PreferredNeighbour' => '0', 
    'PreferredDay' => '0',
    'GoGreen' => '0', 
    'Perishables' => '0', 
    'Personally' => '0', 
    'NoNeighbourDelivery' => '0',
    'NamedPersonOnly' => '0', 
    'ReturnReceipt' => '0', 
    'Premium' => '0', 
    'CashOnDelivery' => '1', 
    'AdditionalInsurance' => '1', 
    'BulkyGoods' => '1', 
    'IdentCheck' => '0',
    'Return' => '0',
    'PrintOnlyIfCodeable' => '1',
    'Endorsement'=>'0'
);

$valid_services['V82PARCEL']=array(
    'DayOfDelivery' => '0',
    'DeliveryTimeframe' => '0', 
    'PreferredTime' => '0',
    'IndividualSenderRequirement' => '0', 
    'PackagingReturn' => '0', 
    'ReturnImmediately' => '0', 
    'NoticeOfNonDeliverability' => '0', 
    'ShipmentHandling' => '0', 
    'Endorsement' => '0', 
    'VisualCheckOfAge' => '0', 
    'PreferredLocation' => '0', 
    'PreferredNeighbour' => '0', 
    'PreferredDay' => '0',
    'GoGreen' => '0', 
    'Perishables' => '0', 
    'Personally' => '0', 
    'NoNeighbourDelivery' => '0',
    'NamedPersonOnly' => '0', 
    'ReturnReceipt' => '0', 
    'Premium' => '0', 
    'CashOnDelivery' => '0', 
    'AdditionalInsurance' => '1', 
    'BulkyGoods' => '1', 
    'IdentCheck' => '0',
    'Return' => '0',
    'PrintOnlyIfCodeable' => '1',
    'Endorsement'=>'1'
);

$valid_services['V62WP']=array(
    'DayOfDelivery' => '0',
    'DeliveryTimeframe' => '0', 
    'PreferredTime' => '0',
    'IndividualSenderRequirement' => '0', 
    'PackagingReturn' => '0', 
    'ReturnImmediately' => '0', 
    'NoticeOfNonDeliverability' => '0', 
    'ShipmentHandling' => '0', 
    'Endorsement' => '0', 
    'VisualCheckOfAge' => '0', 
    'PreferredLocation' => '1', 
    'PreferredNeighbour' => '1', 
    'PreferredDay' => '0',
    'GoGreen' => '1', 
    'Perishables' => '0', 
    'Personally' => '0', 
    'NoNeighbourDelivery' => '0',
    'NamedPersonOnly' => '0', 
    'ReturnReceipt' => '0', 
    'Premium' => '0', 
    'CashOnDelivery' => '0', 
    'AdditionalInsurance' => '0', 
    'BulkyGoods' => '0', 
    'IdentCheck' => '0',
    'Return' => '0',
    'PrintOnlyIfCodeable' => '0',
    'Endorsement'=>'0'
);

define('MODULE_SHIPPING_DHLGKAPI_VALID_SERVICES',serialize($valid_services));

define('MODULE_SHIPPING_DHLGKAPI_DISPLAY_SERVICES',serialize(array(
    'NoticeOfNonDeliverability', 
    'Personally',
    'NamedPersonOnly', 
    'NoNeighbourDelivery', 
    'Premium', 
    'CashOnDelivery', 
    'AdditionalInsurance', 
    'BulkyGoods',
    'VisualCheckOfAge',
    'IdentCheck',
    'Return',
    'PrintOnlyIfCodeable',
    'Endorsement'
)));

define('MODULE_SHIPPING_DHLGKAPI_RETOURE_PRODUCTS',serialize(array(
    'V01PAK' => '07',
    'V06PAK' => '07',
    'V86PARCEL' => '83',
    'V87PARCEL' => '85'
)));





$basics = new basics;
$smarty=new yesSmarty;
$smarty->assign([
    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf'
]);
$yes_dhl_api = new yes_dhl_api;
if(sizeOf($yes_dhl_api->getErrors())){
    die(implode('<br />',$yes_dhl_api->getErrors()));
}
require_once(DIR_WS_CLASSES.'DHL_Paket_DE_Versenden_REST_API.php');
if(isset($_GET['action'])){
    switch($_GET['action']){
        case 'recreate_label':
            $id = intval($_GET['id']??0);
            if($id < 1){
                die('Missing data');
            }
            $YS = new yes_shipping( $id );
            $object = DHL_Paket_DE_Versenden_REST_API::get_from_shipping_item($YS);
            printf('<form name="recreate_label"><fieldset><legend>%s</legend><label for="weight">%s (Gramm)<br /></label>%s<br /><button onclick="javascript:onpage_dhl_create_label_from_shippings_id_get_weight(%s)" type="button" class="ui-button ui-corner-all ui-state-default">%s</button></fieldset></form>',
                MODULE_SHIPPING_DHLGKAPI_BUTTON_GETLABEL,
                MODULE_SHIPPING_DHLGKAPI_WEIGHT,
                xtc_draw_input_field('weight',$object->details->weight->value,'id="weight"',true,'number'),
                $id,
                IMAGE_SAVE
            );
            exit;
            break;
        case 'confirm_delete':
            if(!isset($_GET['stnID']) or $_GET['stnID'] < 1){
                die('Invalid params');
            }
            $stnID = (int)xtc_db_input($_GET['stnID']);
            $query = xtc_db_query(sprintf(
                    "SELECT * FROM shippings_tracking_numbers WHERE shippings_tracking_numbers_id='%s' AND tracking_number != ''",
                    $stnID
            ));
            if(!xtc_db_num_rows($query)){
                die('Invalid item');
            }
            $record = xtc_db_fetch_array($query);
            $YS = new yes_shipping( $record['shippings_id'] );
            $function='deleteShipmentOrder';
            
            $DHL = new DHL_Paket_DE_Versenden_REST_API;
            $response_array = $DHL->deleteShipmentOrder($_GET['tracking_number']);
            $res = json_decode($response_array['RESPONSE']);
            if($res->status->title != 'OK'){
                    die('Trackingnummer konnte nicht geloescht werden');
            }else{
                    $com = sprintf(
                            MSG_SUCCESS_TRACKINGNUMBER_DELETED,
                            $YS->getVersender(),
                            $record['tracking_number']
                    );
                    $stop_recreate = (isset($_GET['stop_recreate']) and $_GET['stop_recreate'] == 1) ? true : false;
                    $sqn = (isset($_GET['sequence_number'])) ? (int)$_GET['sequence_number'] : 1;
                    $YS->delete_trackingnumber($record['tracking_number'],$stop_recreate,$sqn);
                    $secure_path = $YS->get_secure_path();
                    if($YS->getReclamations_id() > 0){
                        $inst= new reclamation($YS->getReclamations_id());
                        $inst_status = $inst->info['reclamations_status'];
                        $target_href = xtc_href_link('reclamations.php','action=edit&rID='.$YS->getReclamations_id());
                    }else{
                        $inst= new order($YS->getOrders_id());
                        $inst_status = $inst->info['orders_status'];
                        $target_href = xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$YS->getOrders_id());
                    }
                    $inst->add_history($inst_status,false,$com);
                    die(sprintf(
                             '<p>%s</p><a style="padding: 4px;" class="ui-state-default ui-corner-all ui-button" onclick="window.location.href=\'%s\';">%s</a>',
                            $com,$target_href,IMAGE_CLOSE
                    ));
            }
            exit;
            break;
        case 'validate':
            if(!isset($_GET['id'])){
                die(json_encode([
                    'ACK'=>'Error',
                    'MSG'=>'No orders/reclamations id'
                ]));
            }
            $id = xtc_db_input($_GET['id']);
            $id_parts = explode('_',$id);
            
            if($id_parts[0] == 'orders'){
                $srcObj = new order($id_parts[1]);
            }else{
                $srcObj = new reclamation($id_parts[1]);
            }
            $produkt = $_GET['versender_params']['DHL']['produkt'];
            
            try{
                $obj = DHL_Paket_DE_Versenden_REST_API::get_from_post( $produkt );
            }catch( Exception $e ){
                die(json_encode([
                    'ACK'=>'Error',
                    'MSG'=>$e->getMessage()
                ]));
            }
            $DHL = new DHL_Paket_DE_Versenden_REST_API;
            $res = $DHL->curl_call();

            $obj->shipper = $DHL->get_shipper();
            $obj->refNo = 'Auftrag 123';
            $obj->shipDate = date('Y-m-d');
            // in gramm
            if(isset($_GET['weight']) and $_GET['weight']>0){
                $dhl_weight = $_GET['weight'];
            }else{
                $dhl_weight = SHIPPING_BOX_WEIGHT;
                $dhl_weight += $srcObj->show_weight($sID);
            }
            $obj->details = new DHL_Details([
                /*
                'dim'=>new DHL_Dim([
                    'uom'=>'mm',
                    'height'=>100,
                    'length'=>200,
                    'width'=>150
                ]),*/
                'weight'=>new DHL_Weight([
                    'uom'=>'g',
                    'value'=>(int)$dhl_weight*1000
                ])
            ]);
            $obj->billingNumber = DHL_Paket_DE_Versenden_REST_API::get_billingNumber($produkt);
            $response_array = $DHL->createShipmentOrder([$obj],true);
            $res = json_decode($response_array['RESPONSE']);
            $msg = [];
            if($res->status->statusCode != 200){
                foreach($res->items as $it){
                    $vms = [];
                    foreach($it->validationMessages as $vm){
                        $vms[] = sprintf('[%s:%s] %s',
                            $vm->validationState,$vm->property,$vm->validationMessage
                        );
                    }
                    $msg[] = sprintf('%s<br />%s',$it->sstatus->title,
                            implode('<br />',$vms)
                    );
                }
                die(json_encode([
                    'ACK'=>'Error',
                    'TITLE'=>'DHL '.$res->status->title." ".$res->status->detail,
                    'MSG'=>implode('<br />',$msg),
                ]));
            }
            die(json_encode([
                'ACK'=>'Success',
                'MSG'=>''
            ]));
            break;
        case 'create_shipments':
            if(!isset($_GET['id']) or !is_countable($_GET['id']) or !sizeOf($_GET['id'])){
                die(json_encode([
                    'MSG'=>'DHL: No items submitted'
                ]));
            }
            $objects = [];
            $yes_shippings = [];
            foreach($_GET['id'] as $shID){
                $yes_shipping = new yes_shipping($shID);
                if($yes_shipping->getReclamations_id() > 0){
                    $redirect_link = xtc_href_link('reclamations.php','action=edit&rID='.$yes_shipping->getReclamations_id());
                }else{
                    $redirect_link = xtc_href_link('orders.php','action=edit&oID='.$yes_shipping->getOrders_id());
                }
                $yes_shippings[ $shID ] = $yes_shipping;
                $dhl_params_json = $yes_shipping->getAdditional_params();
                try{
                    $object = DHL_Paket_DE_Versenden_REST_API::get_from_shipping_item($yes_shipping);
                    if(isset($_GET['new_weight']) and intval($_GET['new_weight']) > 0){
                        $object->details->weight->value = intval($_GET['new_weight']);
                    }
                    // Wir packen die shippings_id in die refNo, damit wir den
                    //Datensatz beim Result identifizieren koennen
                    $new_refNo = current(explode('-',$object->refNo)).'-'.$shID;
                    if(strlen($new_refNo) < 8){
                        $new_refNo .= '-';
                    }
                    while( strlen($new_refNo) < 8 ){
                        $new_refNo .= '0';
                    }
                    $object->refNo = $new_refNo;
                    
                    $objects[] = $object;
                }catch( Exception $e ){
                    die(json_encode([
                        'MSG'=>$e->getMessage()
                    ]));
                }
            }
            
            // HIER WEGEN GEWICHT SCHAUEN
            $DHL = new DHL_Paket_DE_Versenden_REST_API;
            $response_array = $DHL->createShipmentOrder($objects);
            $res = json_decode($response_array['RESPONSE']);
            if($response_array['ACK']=='Error' or (!isset($response_array['ACK']) and isset($response_array['ERROR']) and $response_array['ERROR'] == '1') ){
                die(json_encode([
                    'MSG'=>$res->status->title."\n\n".$res->status->detail,
                ]));
            }
            foreach($res->items as $item){
                $shID_params = explode('-',$item->shipmentRefNo);
                $shID = (int)$shID_params[1];
                $yes_shipping = $yes_shippings[ $shID ];
                if($shID < 1){
                    yes_mail_debug('Ref: '.$item->shipmentRefNo."\n\n".print_r($response_array,true));
                }
                $insert_sql_array = [
                    'shipmentNo'=>$item->shipmentNo,
                ];
                if(isset($item->returnShipmentNo)){
                    $insert_sql_array['returnShipmentNo'] = $item->returnShipmentNo;
                }
                if(isset($item->returnShipmentNo)){
                    $insert_sql_array['shipmentRefNo'] = $item->shipmentRefNo;
                }
                $stnID = $yes_shipping->insert_tracking_number($item->shipmentNo);
                $pdf = file_put_contents(main::get_secure_path().'DHL_label/'.$shID.'_'.$item->shipmentNo.'.pdf',
                    base64_decode($item->label->b64)
                );
                if(isset($_GET['onpage']) and $_GET['onpage'] == 1){
                    die(json_encode([
                        'MSG'=>'',
                        'TRACKINGNUMBER'=>$item->shipmentNo,
                        'TNLINK'=>$yes_shipping->get_tracking_link($item->shipmentNo),
                        'TNDELETELINK'=>xtc_href_link(basename(__FILE__),'action=confirm_delete&stnID='.$stnID.'&tracking_number='.$item->shipmentNo)
                    ]));
                }
            }
            if(isset($_GET['quick_shipping']) and $_GET['quick_shipping'] == 1){
                xtc_redirect($redirect_link);
            }
            die(json_encode([
                'MSG'=>'',
            ]));
            exit;
            break;
        case 'update':
            $produkt = $_GET['produkt'];
            $id = (int)xtc_db_input($_GET['id']);
            try{
                $obj = DHL_Paket_DE_Versenden_REST_API::get_from_post($produkt);
            }catch( Exception $e ){
                die(json_encode([
                    'MSG'=>$e->getMessage()
                ]));
            }
            $update_sql_array = [
                'additional_params'=>json_encode($obj)
            ];
            xtc_db_perform('shippings',$update_sql_array, 'update', "id='".$id."'");
            die(json_encode([
                'MSG'=>''
            ]));
            break;
        case 'get_produkt_config':
            if(!isset($_GET['dhl_produkt'])){
                die('missing param dhl_produkt');
            }
            $use_produkt_id = '';
            if(isset($_GET['shipping_id'])){
                $sID = (int)xtc_db_input($_GET['shipping_id']);
                $yes_shipping = new yes_shipping($sID);
                $data = \DHL_Paket_DE_Versenden_REST_API::get_from_shipping_item($yes_shipping);
                $teilnahme_arr = (array)json_decode(MODULE_SHIPPING_DHLGKAPI_TEILNAHME);
                foreach($teilnahme_arr as $tn_id=>$tn){
                    if($tn == $_GET['dhl_produkt']){
                        $use_produkt_id = $tn_id;
                        break;
                    }
                }
            }elseif(isset($_GET['shipper_profile'])){
                // wird aufgerufen in der shipper_profiles Konfiguration
                $data = \DHL_Paket_DE_Versenden_REST_API::get_from_shipper_profile($_GET['shipper_profile']);
                $use_produkt_id = $_GET['dhl_produkt']; // zb EU oder NAT_NOSERV
            }else{
                $use_produkt_id = $_GET['dhl_produkt']; // zb EU oder NAT_NOSERV
                $data = \DHL_Paket_DE_Versenden_REST_API::get_empty($_GET['dhl_produkt'], \DHL_Paket_DE_Versenden_REST_API::get_billingNumber($_GET['dhl_produkt']));
            }
            if(isset($_GET['email']) and !empty($_GET['email'])){
                $allow = false;
                foreach(\DHL_Paket_DE_Versenden_REST_API::PRODUKTE as $p){
                    $str = $p['GKV_API'].$p['Verfahren'].$p['Teilnahme'];
                    if($_GET['dhl_produkt'] == $str){
                        if($p['Services']['parcelOutletRouting'] === true){
                            $allow = true;
                        }
                    }
                }
                if($allow){
                    $data->services['parcelOutletRouting'] = $_GET['email'];
                }
            }
            
            $smarty->assign([
                'DATA'=>$data,
                'FULL_OPTIONS'=>(isset($_GET['full_options']) and $_GET['full_options'] == 1) ? 1 : 0,
                'DHL'=>new DHL_Paket_DE_Versenden_REST_API,
                'action'=>$get_action,
                'produkt'=>$use_produkt_id,
                'parent_div_id'=>(isset($_GET['parent_div_id'])) ? $_GET['parent_div_id']: '',
                'BASE_URL_ACTION'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action','produkt','shipper_profile'])),
                'YES_CONF'=>[
                    'MODULE_SHIPPING_DHLGKAPI_PARCELOUTLETROUTING_ENABLED'=>(defined('MODULE_SHIPPING_DHLGKAPI_PARCELOUTLETROUTING_ENABLED')) ? constant('MODULE_SHIPPING_DHLGKAPI_PARCELOUTLETROUTING_ENABLED') : 'False'
                ]
            ]);
            $smarty->display('dhl_shipment_config.html');
            exit;
            break;
        case 'test':
            $yes_dhl_api->soap_request($dhl_xml, 'getVersion', 0, true);
            break;
        case 'print_pdf_select':
            if(!is_countable($_GET['file']) or !sizeOf($_GET['file'])){
                $messageStack->add_session('DHL Print::No Label selected','error');
                xtc_redirect(xtc_href_link(basename(__FILE__),'action=select_pdf_download'));
            }
            $path = $yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR;
            $base_dir = realpath($path);
            $label = array();
            
            if(!is_dir($base_dir)){
                mkdir($base_dir);
            }
            foreach($_GET['file'] as $file){
				$fn = basename($file);
				$fn_full = realpath($path.$fn);
				if ($fn_full && strpos($fn_full, $base_dir) === 0 && is_file($fn_full)) {
                    $label[] = $fn;
				}
            }
            if(!sizeOf($label)){
                $messageStack->add_session('DHL Print::No valid Label selected','error');
                xtc_redirect(xtc_href_link(basename(__FILE__),'action=select_pdf_download'));
            }

//require_once(DIR_WS_CLASSES.'PDFMerger/PDFMerger.php');
//$pdf = new PDFMerger;
            $tmp_names = array();
            foreach($label as $l){
               $tmp_names[] = $base_dir.DIRECTORY_SEPARATOR.$l;
            }
            $crypt_dir = yes_get_sha1_from_string( date('Y-m-d') );
            $crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
            if(!is_dir(\main::get_exportdata_path().$crypt_dir)){
            	mkdir(\main::get_exportdata_path().$crypt_dir);
            }
            $pdf_name = \main::get_exportdata_path().$crypt_dir.'/DHL_TRACKING_LABEL_'.$crypt_file.'.pdf';
            @unlink($pdf_name);
            touch($pdf_name);
            chmod($pdf_name,0777);
		$cmd = "gs -q -dNOPAUSE -dBATCH -sDEVICE=pdfwrite -sOutputFile=$pdf_name ";
		//Add each pdf file to the end of the command
		foreach($tmp_names as $file) {
			$cmd .= $file." ";
		}
		$result = shell_exec($cmd);            
            header('Content-type: application/pdf');
            header('Content-Disposition: inline; filename="'.basename($pdf_name).'"');
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($pdf_name));
            header('Accept-Ranges: bytes');
            @readfile($pdf_name);
            exit;
            break;
        case 'select_pdf_download':
            if(isset($_GET['date_from']) and isset($_GET['date_to'])){
                $date_range = array(
                    'from'=>strtotime($_GET['date_from'].' 00:00:00'),
                    'to'=>strtotime($_GET['date_to'].' 23:59:59')
                );
            }else{
                $date_range = array(
                    'from'=>strtotime(date('Y-m-d 00:00:00')),
                    'to'=>strtotime(date('Y-m-d 23:59:59'))
                );
            }
            $sec_path = $yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR;
            $label = array();
            $files = $basics->get_directory_content($sec_path);
            foreach($files as $file){
                $dat = filectime($sec_path.$file);
                if($dat >= $date_range['from'] and $dat <= $date_range['to'] ){
                    $label[] = array(
                        'file'=>$file,
                        'date_created'=>date('d.m.Y H:i:s',$dat)
                    );
                }
            }
            $buttons = array(array('text'=>IMAGE_BACK,
                    'link'=>xtc_href_link(basename(__FILE__),'action=list'),
                    'lbOn'=>false,
                    'auth'=>true
            ));
            $smarty->assign(array(
                'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
                'HEADING_TITLE'=>'DHL Versenden Labelprint',
                'PAGE_HEADING_MENU_BUTTONS'=>$buttons, 
                'LABEL'=>$label,
                'DATE_RANGE_FROM'=>date('Y-m-d',$date_range['from']),
                'DATE_RANGE_TO'=>date('Y-m-d',$date_range['to']),
            ));
            yes_draw_pre_header();
            yes_draw_header(TITLE);
            $smarty->display('dhl_print_label_pdf_select.tpl');
            require(DIR_WS_INCLUDES . 'footer.php');
            require(DIR_WS_INCLUDES . 'application_bottom.php');
            exit;
            break;
        case 'pdf_download':
            if(isset($_GET['id'])){
                $id = (int)xtc_db_input($_GET['id']);
                $tracking_number = xtc_db_input($_GET['tracking_number']);
                $file = $yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR.$id.'_'.$tracking_number.'.pdf';
                if(!is_file($file)){
                    // VERALTET, INZWISCHEN WIRD DIE TRACKINGNUMMER IM DATEINAMEN
                    // GESPEICHERT - 2021/01
                    $sequence_number = (int)xtc_db_input($_GET['sequence_number']);
                    $file = $yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR.$id.'_'.$sequence_number.'.pdf';
                }
            }elseif(isset($_GET['file'])){
                $file = $yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR.basename($_GET['file']);
            }
            if(!is_file($file)){
                $messageStack->add_session('Invalid DHL Label','error');
                xtc_redirect(xtc_href_link('start.php'));
            }
            header('Content-type: application/pdf');
            header('Content-Disposition: inline; filename="DHL_LABEL_' . basename($file) . '"');
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($file));
            header('Accept-Ranges: bytes');
            @readfile($file);
            exit;
            break;
    }
}

if(isset($_GET['action']) and $_GET['action'] == 'list'){
    $DHL = new DHL_Paket_DE_Versenden_REST_API;
    /*
    try{
        $result = $DHL->getManifests();
    }catch( Exception $e ){
        die($e->getMessage());
    }
    yes_debug($result);
     * LIEFERT PDF
     */
    $paging = '';
    // WEITERES LABEL DRUCKEN
    if(isset($_GET['id']) and is_countable($_GET['id']) and sizeOf($_GET['id'])){
        $dhl_trackings_missing = yes_shipping::get_dhl_items_from_shippings_id(current($_GET['id']));
    }else{
        // NORMALES HANDLING
        $dhl_trackings_missing = yes_shipping::get_dhl_items_with_missing_tracking_ids();
        if(sizeOf($dhl_trackings_missing) > 30){
		$paging = sprintf('Es werden 1-%d von insgesamt %d Datensätze verarbeitet',
			(sizeOf($dhl_trackings_missing)>30)?30:sizeOf($dhl_trackings_missing),
			sizeOf($dhl_trackings_missing)
		);
		$dhl_trackings_missing = array_slice($dhl_trackings_missing,0,30);
	}
    }
    if(!sizeOf($dhl_trackings_missing)){
        $messageStack->add_session(DHL_LISTING_ERROR_NO_ITEMS,'error');
        xtc_redirect(xtc_href_link('shipping.php'));
    }else{
        $validation_errors = [];
        foreach($dhl_trackings_missing as $dtmk=>$dtm){
            $sh = new yes_shipping( $dtm['id'] );
            $addp = null;
            $_err = false;
            if(!empty($sh->additional_params)){
                if(!DHL_Paket_DE_Versenden_REST_API::isJson($sh->additional_params)){
                    $ref_str = ($sh->getReclamations_id() > 0) ? TEXT_RECLAMATION.' '.$sh->getReclamations_id():TEXT_ORDER.' '.$sh->getOrders_id();
                    $validation_errors[] = sprintf(
                            'Versanddatensatz #%d (%s) hat ungültige DHL Parameter: %s',
                            $dtm['id'],
                            $ref_str,
                            $sh->additional_params
                    );
                    $_err = true;
                }
                $addp = json_decode($sh->additional_params);
            }
            if($_err){
                unset($dhl_trackings_missing[$dtmk]);
                continue;
            }
            $dhl_trackings_missing[$dtmk]['date_finished_formatted'] = xtc_date_short($dtm['date_finished']);
            $dhl_trackings_missing[$dtmk]['shipping_object'] = $sh;
            $produkt = '';
            
            $produkt = $addp->product.str_replace(DHL_Paket_DE_Versenden_REST_API::EKP,'',$addp->billingNumber);
            $dhl_trackings_missing[$dtmk]['shipping_configuration']['additional_params'] = $sh->additional_params;
            $dhl_trackings_missing[$dtmk]['shipping_configuration']['versender'] = 'DHL';
            $dhl_trackings_missing[$dtmk]['shipping_configuration']['produkt'] = $produkt;
        }
        $validate_objects = [];
        foreach($dhl_trackings_missing as $it){
            $vo = DHL_Paket_DE_Versenden_REST_API::get_from_shipping_item($it['shipping_object']);
            $validate_objects[] = $vo;
        }
        try{
            $result = $DHL->createShipmentOrder($validate_objects, true); // true = validate
        }catch( Exception $e ){
            die($e->getMessage());
        }
        $obj = json_decode($result['RESPONSE']);
        $errors = false;
        foreach($obj->items as $itm){
            if($itm->sstatus->statusCode != 200){
                foreach($itm->validationMessages as $vm){
                    if($vm->validationState == 'Error'){
                        $errors = true;
                    }
                }
            }
        }
        $smarty->assign(array(
            'PAGING'=>$paging,
           'ITEMS' => $dhl_trackings_missing,
           'ERRORS'=>$errors,
           'VALIDATION_ERRORS'=>implode('<br />',$validation_errors),
           'RESPONSE'=>$obj,
           'HEADING_TITLE'=>DHL_LISTING_HEADING_TITLE,
           'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
        ));
        yes_draw_pre_header();
        yes_draw_header(TITLE);
        $smarty->display('dhl_print_label_list.html');
        require(DIR_WS_INCLUDES . 'footer.php');
        require(DIR_WS_INCLUDES . 'application_bottom.php');
    }
    exit;
}
if(!isset($_GET['id']) or !is_array($_GET['id'])){
    if(!isset($_GET['action']) or $_GET['action'] != 'get_produkt_config'){
        $messageStack->add_session('Missing parameter for DHL Versenden','error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS));
    }
}
$sID = (int)xtc_db_input(current($_GET['id']));
$yes_shipping = new yes_shipping($sID);
$add_params_raw = $yes_shipping->getAdditional_params();
$add_params = json_decode($add_params_raw);

$dhl_weight = SHIPPING_BOX_WEIGHT;
if($yes_shipping->getReclamations_id() > 0){
    $reclamation = new reclamation($yes_shipping->getReclamations_id());
    $dhl_weight += $reclamation->show_weight($sID);
}else{
    $order = new order($yes_shipping->getOrders_id());
    $dhl_weight += $order->show_weight($sID);
}

$obj = DHL_Paket_DE_Versenden_REST_API::get_from_shipping_item($yes_shipping);
$act_orders_id = ($yes_shipping->getReclamations_id() > 0) ? 'R'.$yes_shipping->getReclamations_id() : $yes_shipping->getOrders_id();
//Label anfordern / stornieren
if (isset($_GET['getlabel']) && !isset($_GET['error'])) {
    $one_click = isset($_GET['one_click']);
    //SOAP Aktion festlegen
    $batch_processing = (isset($_GET['batch_processing']) and $_GET['batch_processing'] == '1') ? true : false;
    $one_click_result = array(
        'messages'=>array(),
        'error'=>0,
        'step_url'=>'',
        'sequence_number'=>$sequence_number,
        'packages'=>$yes_shipping->getPackages(),
        'label'=>''
    );
    $DHL = new DHL_Paket_DE_Versenden_REST_API;
    try{
        $result = $DHL->createShipmentOrder([$obj], true); // true = validate
    }catch( Exception $e ){
        if($one_click){
            $err_msg_arr = array();
            foreach($yes_dhl_api->getErrors() as $aperr){
                if(!in_array($aperr,$err_msg_arr)){
                    if(strtolower(CHARSET) != 'utf-8'){
                        $err_msg_arr[] = utf8_decode($aperr);
                    }else{
                        $err_msg_arr[] = $aperr;
                    }
                }
            }
            $one_click_result['messages'][] = implode('<br />',$err_msg_arr);
            $one_click_result['error'] = 1;
            if(strtolower(CHARSET) != 'utf-8'){
                    header('Content-Type: text/html; charset=UTF-8');
            }
            die(json_encode($one_click_result));
        }else{
            if(isset($_GET['redirect_to'])){
                die('<b>Error</b><br /><i>'.implode('<br />',$yes_dhl_api->getErrors()).'</i>');
            }
            $messageStack->add_session(implode('<br />',$yes_dhl_api->getErrors()));
            xtc_redirect(xtc_href_link(basename(__FILE__),'id[]='.implode('&id[]=',$_GET['id']).'&sequence_number='.$sequence_number));
        }
    }

    
    //Kommentar und Orderstatus festlegen
    $customer_notified = 0;
    //Email Versand, wenn erlaubt
    if (MODULE_SHIPPING_DHLGKAPI_EMAIL_ENABLED=='True') {
    }
    try {
        $label = file_get_contents($result->CreationState->LabelData->labelUrl);
        if ($label === false) {
            if($one_click){
                $one_click_result['messages'][] = 'Cant download Label';
                $one_click_result['error'] = 1;
                die(json_encode($one_click_result));
            }
            die('Cant download Label');
        }
    } catch (Exception $e) {
        if($one_click){
            $one_click_result['messages'][] = $e->getMessage();
            $one_click_result['error'] = 1;
            die(json_encode($one_click_result));
        }
        die($e->getMessage());
    }
    // BOF EXPORTDOC
    if(isset($result->CreationState->LabelData->exportLabelUrl) and $result->CreationState->LabelData->exportLabelUrl != ''){
        try {
            $ex_label = file_get_contents($result->CreationState->LabelData->exportLabelUrl);
            if ($ex_label === false) {
                if($one_click){
                    $one_click_result['messages'][] = 'Cant download Export Label';
                    $one_click_result['error'] = 1;
                    die(json_encode($one_click_result));
                }
                die('Cant download Export Label');
            }
        } catch (Exception $e) {
            if($one_click){
                $one_click_result['messages'][] = $e->getMessage();
                $one_click_result['error'] = 1;
                die(json_encode($one_click_result));
            }
            die($e->getMessage());
        }
    }
    // EOF EXPORTDOC
    
    
    if($yes_shipping->getReclamations_id() > 0){
        $reclamation->add_history($reclamation->info['reclamations_status'], $customer_notified, $comments.' TrackingID '.''.$result->CreationState->LabelData->shipmentNumber);
    }else{
        $order->add_history($order->info['orders_status'], $customer_notified, $comments.' TrackingID '.''.$result->CreationState->LabelData->shipmentNumber);
    }
    	$target_pdf_seq = $sequence_number;
        // ALT
        /*
	$target_pdf = $yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR.$sID.'_'.$target_pdf_seq.'.pdf';
	while(file_exists($target_pdf)){
	    $target_pdf_seq++;
	    $target_pdf = $yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR.$sID.'_'.$target_pdf_seq.'.pdf';
	}
        */
        // NEU - KEINE FORTLAUFENDE NR SONDERN DIE TRACKINGNUMMER IM FILENAME
        // 2021/01
	$target_pdf = $yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR.$sID.'_'.$result->CreationState->LabelData->shipmentNumber.'.pdf';
        
	file_put_contents($target_pdf,$label);
	// WENN EIN EXPORTLABEL VORHANDEN
    if(isset($ex_label) and $ex_label !== false){
        $target_pdf_seq = $result->CreationState->LabelData->shipmentNumber;
        $target_pdf = $yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR.$sID.'_'.$target_pdf_seq.'_EXPORTLABEL.pdf';
        /** $result->CreationState->LabelData->shipmentNumber SOLLTE UNIQUE SEIN, KEIN HOCHZAEHLEN NOTWENDIG
        while(file_exists($target_pdf)){
            $target_pdf_seq++;
            $target_pdf = $yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR.$sID.'_'.$target_pdf_seq.'_EXPORTLABEL.pdf';
        }
        */
        file_put_contents($target_pdf,$ex_label);
        
	$fileArray= array(
		$yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR.$sID.'_'.$target_pdf_seq.'.pdf',
		$yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR.$sID.'_'.$target_pdf_seq.'_EXPORTLABEL.pdf'
	);

	$datadir = $yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR;
	$outputName = $datadir.$sID.'_'.$target_pdf_seq.'_merged.pdf';

	$cmd = "gs -q -dNOPAUSE -dBATCH -sDEVICE=pdfwrite -sOutputFile=$outputName ";
	//Add each pdf file to the end of the command
	foreach($fileArray as $file) {
	    $cmd .= $file." ";
	}
	$shell_result = shell_exec($cmd);
        unlink($yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR.$sID.'_'.$target_pdf_seq.'_EXPORTLABEL.pdf');
        unlink($yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR.$sID.'_'.$target_pdf_seq.'.pdf');
        rename($datadir.$sID.'_'.$target_pdf_seq.'_merged.pdf',$outputName = $datadir.$sID.'_'.$target_pdf_seq.'.pdf');
        //unlink($yes_dhl_api->getSecure_label_path().DIRECTORY_SEPARATOR.$sID.'_'.$sequence_number.'.pdf');
        // EOF - WIR HAENGEN DAS EXPORT LABEL ANS NORMALE LABEL AN
    }
    // TRACKING ID WRITE
    if($function == 'createShipmentOrder'){
        $yes_shipping->insert_tracking_number(''.$result->CreationState->LabelData->shipmentNumber);
    }
    
    if($one_click){
        $one_click_result['messages'][] = 'DHL Label '.$sequence_number.'/'.$yes_shipping->getPackages().' created';
        if($function == 'createShipmentOrder'){
            // NEUERES HANDLING, shipmentNumber statt sequenceNumber
            $new_seq_number = $result->CreationState->LabelData->shipmentNumber;
            $one_click_result['label'] = $sID.'_'.$new_seq_number.'.pdf';
        }
    }else{
        $messageStack->add_session('Label created','success');
    }
    if($yes_shipping->getPackages() > (int)$sequence_number){
        if($one_click){
            xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('sequence_number')).'sequence_number='.($sequence_number+1)));
        }else{
            xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('sequence_number','getlabel')).'sequence_number='.($sequence_number+1)));
        }
    }else{
        
        if($one_click){
            $one_click_result['step_url'] = xtc_href_link('shipping.php','action=one_click_shipping&process_shipping_id_array='.$sID.'&after=2');
        }
                
        if(sizeOf($_GET['id']) > 1){
            array_shift($_GET['id']);
            $params = 'id[]='.implode('id[]=',$_GET['id']);
            xtc_redirect(xtc_href_link(basename(__FILE__),$params));
        }
        if(!$one_click){
            if(isset($_GET['redirect_to'])){
                xtc_redirect($_GET['redirect_to']);
            }
            if(substr($yes_dhl_api->getCustomerReference(),0,1) == 'R'){
                xtc_redirect(xtc_href_link('reclamations.php','rID='.$rID.'&action=edit'));
            }else{
                xtc_redirect(xtc_href_link(FILENAME_ORDERS,'oID='.$oID.'&action=edit'));
            }
        }
    }
    if($one_click){
        die(json_encode($one_click_result));
    }
    die;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
if (isset($_GET['error']) and $_GET['error']!='') {
    $messageStack->add_session(urldecode($_GET['error']),'error');
    xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))));
}
$menus = array();
$tn_array = array();
$trck_array = ($yes_shipping->getReclamations_id() > 0) ? $reclamation->get_shipping_tracking_id_array() : $order->get_shipping_tracking_id_array();
foreach($trck_array as $tn){
    $tn_array[] = $tn;
}
if(sizeOf($_GET['id'])>1){
    $shift = $_GET['id'];
    array_shift($shift);
    $link = 'id[]='.implode('&id[]=',$shift);
    $buttons[] = array(
        'text'=>TEXT_DROP_ENTRY_FROM_PROCESS_LIST,
        'link'=>xtc_href_link(basename(__FILE__),$link),
        'auth'=>true,
        'lbOn'=>false
    );
}
$smarty->assign(array(
    'VISUALCHECKOFAGE'=>$yes_dhl_api->getVisualCheckOfAge()
));
$smarty->display('dhl_print_label.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
