<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
$doID = intval($_GET['doID']??0);
if($doID < 1){
	die('unknown / missing order');
}
$shipping_date = yes_query(
	"SELECT estimated_date_receipt FROM distributor_orders WHERE distributor_orders_id=:doid",
	['doid'=>$doID],
	true
);
if($shipping_date === false){
	die('unknown order');
}

if($shipping_date['estimated_date_receipt'] != YES_SQL_EMPTY_DATE){
	$date_value = date('Y-m-d',strtotime($shipping_date['estimated_date_receipt']));
}else{
	$date_value = date('Y-m-d');
}

$shippings = yes_query(
	"select * from distributor_orders_total where orders_id =:doid and class = 'ot_shipping' ",
	['doid'=>$doID]
);

$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal frachtkosten_list" style="width: auto;"';
$contents = [[
    ['text'=>TEXT_FRACHTKOSTEN,'th'=>true],
    ['text'=>TEXT_FRACHTKOSTEN_VALUE,'th'=>true],
    ['text'=>'Action','th'=>true],
]];
if(is_countable($shippings) and sizeOf($shippings)){
	foreach($shippings as $shipping) {
		$contents[] = [
			['text'=>xtc_draw_input_field('title[]', $shipping['title'], 'size="50"')
				.xtc_draw_hidden_field('otID[]', $shipping['orders_total_id'])
			],
			['text'=>xtc_draw_input_field('value[]', $shipping["value"],'size="10" step="0.01"','','number')],
			['text'=>yes_draw_href_button(IMAGE_DELETE,
				xtc_href_link('distributor_orders_edit.php','action=shipping_del&dID='.$_GET['dID'].'&doID='.$_GET['doID'].'&otID='.$shipping['orders_total_id']),
				'','button','ui-button ui-corner-all ui-state-error'
			)]
		];
	}
}else{
	$contents[] = [
		'text'=>NO_ITEMS_FOUND,'params'=>'colspan="3"'
	];
}


$smarty->assign([
	'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
	'FORM'=>xtc_draw_form('new_product', 'distributor_orders_edit.php', 'action=shipping_edit_date', 'post'),
	'TEXT_ESTIMATED_DATE_RECEIPT'=>TEXT_ESTIMATED_DATE_RECEIPT,
	'INPUT_DID'=>xtc_draw_hidden_field('dID', $_GET['dID']??0),
	'INPUT_DOID'=>xtc_draw_hidden_field('doID', $_GET['doID']??0),
	'INPUT_DATEFROM'=>xtc_draw_input_field('datefrom',$date_value,'id="datefrom"','','date'),
	'INPUT_SAVE'=>yes_draw_href_button(IMAGE_SAVE,'','','submit'),
	'FORM_SHIPPING_EDIT'=>xtc_draw_form('frachtkosten_edit', 'distributor_orders_edit.php', 'action=shipping_edit', 'post'),
    'TABLE'=>$table->tableBlock_draw($contents),
	'FORM_SHIPPING_ADD'=>xtc_draw_form('shipping_ins', 'distributor_orders_edit.php', 'action=shipping_ins', 'post'),
	'ITEM_ADD'=>ITEM_ADD,
	'TEXT_FRACHTKOSTEN_TITLE'=>TEXT_FRACHTKOSTEN_TITLE,
	'TEXT_FRACHTKOSTEN'=>TEXT_FRACHTKOSTEN,
	'TEXT_FRACHTKOSTEN_VALUE'=>TEXT_FRACHTKOSTEN_VALUE,
	'NEW_INPUT_TITLE'=>xtc_draw_input_field('title', '', 'size="50" id="title"'),
	'NEW_INPUT_VALUE'=>xtc_draw_input_field('value', '0.00', 'size="10" id="value" step="0.01"',false,'number'),
	
]);
$smarty->display('distributor_orders_edit_shipping.html');
