<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     



   ---------------------------------------------------------------------------*/
require_once('includes/classes/class.csv.php');
    require_once(DIR_FS_CATALOG.'lang/german/admin/module_export.php');
$step = 1;
$target_path = \main::get_exportdata_path().'0000IMPORTEBAYPRODUCTS.csv';
$basics = new basics;

require_once(DIR_WS_CLASSES.'class.products_export.php');
require_once(DIR_WS_MODULES.'export/ebay_products.php');
$ebay_products = new ebay_products;
$filePath = \main::get_exportdata_path().'module_export_configs/ebay_products/';
if(!is_dir($filePath)){
    mkdir($filePath);
}
if(!is_writable($filePath)){
    die(json_encode(array(
	'MSG'=>$filePath . ' is not writable'
    )));
}
$ini_values = array(array('id'=>'','text'=>TEXT_SELECT));
foreach($basics->get_directory_content($filePath) as $file){
    $ini_values[] = array(
	'id'=>str_replace(array('ebay_products_','.ini'),'',$file),
	'text'=>str_replace(array('ebay_products_','.ini'),'',$file)
    );
}
$JAHRTAUSEND_START = substr(date('Y'),0,2);
function clean_csv_tag($str){
	if($str[0] == '"')
		$str = substr($str,1,strlen($str));
	if($str[ (strlen($str)-1) ] == '"')
		$str = substr($str,0,(strlen($str)-1));
	return str_replace('""','"',$str);
}

function display_import_field($key,$value) {
    $subtitle = ebay_item::get_db_field_title('ebay_products','subtitle');
    $title = ebay_item::get_db_field_title('ebay_products','title');
    $desc = ebay_item::get_db_field_title('ebay_products','description');
    switch($key){
	case $subtitle:
	case $title:
	case $desc:
	    $value = strip_tags($value);
	    if(strlen($value)>40){
		    $value = substr($value,0,40).'...';
	    }
	    break;
    }
    return $value;
}

$no_import_config = false;
$header = $ebay_products->get_header();
$export_config_file = '';
if(isset($_REQUEST['export_config_file']) and !empty($_REQUEST['export_config_file'])){
    $ini = $ebay_products->get_ini('ebay_products_'.basename($_REQUEST['export_config_file'].'.ini'));
    $importheader = $ebay_products->get_heading_row($header, $ini, array(), $no_import_config);
    $export_config_file = $_REQUEST['export_config_file'];
}else{
    $no_import_config = true;
    $importheader = $ebay_products->get_heading_row($header, array(), array(), $no_import_config);
}
$importheader = array_merge(
	$ebay_products->get_automatic_header(),
	$importheader
);
if(isset($_GET['mode'])){
    switch($_GET['mode']){
	case 'save':
	    $CSV = new CSVfile($target_path);
	    $CSV->delimiter = "\t";
	    $CSV->open('r');
	    $row = 0;
	    while($line = $CSV->readRow()){
		if($row < 1){
		    $row++;
		    continue;
		}
		$epID = $line[0];
		$variations_id = $line[1];
		$variation_sort_order = $line[2];
		$column = 3;
		foreach($header as $group=>$fields){
		    if(!$no_import_config and !isset($ini[$group])){
			continue;
		    }
		    $sql_update_array = array();
		    if(sizeOf($fields['items'])){
			foreach($fields['items'] as $field=>$field_title){
			    if(!$no_import_config and !isset($ini[$group][$field])){
				continue;
			    }
			    if($variations_id < 1){
				switch($field){
					case 'auctionprice':
					case 'buyitnowprice':
					case 'bestoffer_price':
					case 'BestOfferAutoAcceptPrice':
					case 'reserveprice':
						$sql_update_array[ ebay_product::get_db_field($field)] = number_format(str_replace(',','.',$line[$column]),4,'.','');
						break;
					default:
						$sql_update_array[ebay_product::get_db_field($field)] = $line[$column];
						break;
				}
			    }else{
				$sql_update_array['sort_order'] = $variation_sort_order;
				switch($field){
					case 'auctionprice':
						$sql_update_array['startprice'] = number_format(str_replace(',','.',$line[$column]),4,'.','');
						break;
					case 'quantity':
					case 'sku':
					case 'ean':
					case 'isbn':
						$sql_update_array[$field] = $line[$column];
						break;
				}
			    }
			    $column++;
			}
		    }else{
			if(!$no_import_config and !isset($ini[$group])){
			    continue;
			}
			switch($group){
			    case 'paymentmethods':
				if($variations_id < 1){
				    xtc_db_query(sprintf(
					    "DELETE FROM ebay_products_payments WHERE ebay_products_id='%s'",
					    $epID
				    ));
				    $pm_values = explode(',',$line[$column]);
				    foreach($pm_values as $pm){
					$insert_sql_array = array(
					    'ebay_products_id'=>$epID,
					    'payment'=>$pm
					);
					xtc_db_perform('ebay_products_payments',$insert_sql_array);
				    }
				}
				$column++;
				break;
			    case 'shippings':
				// ALTE LOESCHEN 
				if($variations_id < 1){
				    $existing_query = xtc_db_query(sprintf(
					    "SELECT ebay_products_shippings_id FROM ebay_products_shippings WHERE ebay_products_id='%s'",
					    $epID
				    ));
				    while($existing = xtc_db_fetch_array($existing_query)){
					xtc_db_query(sprintf(
						"DELETE FROM ebay_products_shippings_locations WHERE ebay_products_shippings_id='%s'",
						$existing['ebay_products_shippings_id']
					));
				    }
				    xtc_db_query(sprintf(
					    "DELETE FROM ebay_products_shippings WHERE ebay_products_id='%s'",
					    $epID
				    ));
				}
				// NEUE ANLEGEN
				for($i=0;$i<$ebay_products->max_domestic_shippings;$i++){
				    if($variations_id < 1){
					$parts = explode(';',$line[$column]);
					if(sizeOf($parts) > 1){
					    $insert_sql_array = array(
						'ebay_products_id'=>$epID,
						'shippingtype'=>'national',
						'ShippingService'=>$parts[0],
						'ShippingServiceCost'=>$ebay_products->prepare_float($parts[1]),
						'ShippingServiceAdditionalCost'=>$ebay_products->prepare_float($parts[2]),
						'ShippingServicePriority'=>$parts[3],
						'shipsWithinDays'=>$parts[4]
					    );
					    xtc_db_perform('ebay_products_shippings',$insert_sql_array);
					}
				    }
				    $column++;
				}
				// NEUE ANLEGEN
				for($i=0;$i<$ebay_products->max_international_shippings;$i++){
				    if($variations_id < 1){
					$parts = explode(';',$line[$column]);
					if(sizeOf($parts) > 1 and $parts[0] != ''){
					    $insert_sql_array = array(
						'ebay_products_id'=>$epID,
						'shippingtype'=>'international',
						'ShippingService'=>$parts[0],
						'ShippingServiceCost'=>$ebay_products->prepare_float($parts[1]),
						'ShippingServiceAdditionalCost'=>$ebay_products->prepare_float($parts[2]),
						'ShippingServicePriority'=>$parts[3],
						'shipsWithinDays'=>$parts[4]
					    );
					    xtc_db_perform('ebay_products_shippings',$insert_sql_array);
					    $epsID = xtc_db_insert_id();
					    $locations = explode('|',$parts[5]);
					    foreach($locations as $location){
						if(empty($location)) continue;
						$insert_sql_array = array(
						    'ebay_products_shippings_id'=>$epsID,
						    'location'=>$location
						);
						xtc_db_perform('ebay_products_shippings_locations',$insert_sql_array);
					    }
					}
				    }
				    $column++;
				}
				break;
			}
			//$column++;
		    }
		    if(!sizeOf($sql_update_array))
			continue;
		    switch($group){
			case 'main':
			    if($variations_id < 1){
				$table = 'ebay_products';
				$where = "id='".$epID."'";
			    }else{
				$table = 'ebay_variations';
				$where = "ebay_variations_id='".$variations_id."'";
			    }
			    xtc_db_perform($table,$sql_update_array,'update',$where);
			    break;
		    }
		}
		//xtc_db_query("INSERT INTO products_history SET products_id='".$pID."',editor_id='".$_SESSION['customer_id']."',date_saved=now(),comments='CSV IMPORT'");
	    } // end while line
	    unlink($target_path);
	    $messageStack->add_session(MSG_IMPORT_SUCCESS,'success');
	    xtc_redirect(xtc_href_link('module_export.php','module=ebay_products'));
	    break;
	default:
	    if(file_exists($target_path))
		    unlink($target_path);
	    $messageStack->add_session(MSG_IMPORT_CANCELLED,'error');
	    xtc_redirect(xtc_href_link('ebayapi_cart.php','action=import'));
	    break;
	}
}
if (isset($_FILES['importfile'])){
	if ($_FILES["importfile"]["error"] > 0){
	    $messageStack->add_session(MSG_ERROR_IMPORT_DEFECT,'error');
	    xtc_redirect(xtc_href_link('ebayapi_cart.php','action=import'));
	}
	if(file_exists($target_path))
		unlink($target_path);
	if (move_uploaded_file($_FILES['importfile']['tmp_name'], $target_path)) {
		$step = 2;
	}else{
		$messageStack->add_session(MSG_ERROR_IMPORT_NOT_WRITABLE,'error');
		xtc_redirect(xtc_href_link('ebayapi_cart.php','action=import'));
	}
} 

$smarty = new yesSmarty;
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript">
function importFileSelect(el){
    var fullPath = $(el).val();
    if (fullPath) {
	    var startIndex = (fullPath.indexOf('\\') >= 0 ? fullPath.lastIndexOf('\\') : fullPath.lastIndexOf('/'));
	    var filename = fullPath.substring(startIndex);
	    if (filename.indexOf('\\') === 0 || filename.indexOf('/') === 0) {
		    filename = filename.substring(1);
	    }
	    if(filename.indexOf('{') === 14){
		var ini_parts = filename.split('{');
		ini_parts = ini_parts[1].split('}');
		var ini = ini_parts[0];
		if($('select[name="export_config_file"] option[value="'+ini+'"]').length > 0){
		    $('select[name="export_config_file"]').val(ini);
		    alert('<?php echo TEXT_EXPORT_CONFIG_INI_DETECTED; ?>');
		}
	    }
    }    
}
</script>    


<?php
$buttons = array();
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE_EBAY_PRODUCTS_IMPORT,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'STEP'=>$step,
    'FORM_END'=>'</form>',
    'TEXT_IMPORT'=>BUTTON_IMPORT
));
switch($step){
	case 1:
	    $smarty->assign(array(
		'INTRO'=>TEXT_IMPORT_STEP1_INTRO,
		'FORM'=>  xtc_draw_form('import_csv_form', 'ebayapi_cart.php', 'action=import', 'POST', 'enctype="multipart/form-data"'),
		'TEXT_IMPORT_USE_CONFIG_INI'=>TEXT_IMPORT_USE_CONFIG_INI,
		'INPUT_CONFIG_INI'=>xtc_draw_pull_down_menu('export_config_file',$ini_values,$export_config_file),
	    ));
	    break;
	case 2:
	    $CSV = new CSVfile($target_path);
	    $CSV->delimiter = "\t";
	    $CSV->open('r');
	    $row = 0;
	    $csv_data = array();
	    while($line = $CSV->readRow()){
		    if($row == 0){
			$row++;
			continue;
		    }
		    foreach($line as $k=>$v){
			if(isset($importheader[$k]))
			    $line[$k] = display_import_field($importheader[$k],$v);
		    }
		    $csv_data[] = $line;
		    $row++;
	    }
	    $smarty->assign(array(
		'INTRO'=>sprintf(TEXT_IMPORT_STEP2_INTRO,sizeOf($csv_data)),
		'HINT'=>TEXT_IMPORT_STEP2_HINT,
		'IMAGE_CANCEL'=>IMAGE_CANCEL,
		'IMAGE_SAVE'=>IMAGE_SAVE,
		'SUBMIT_LINK'=>xtc_href_link('ebayapi_cart.php','action=import&mode=save'.((isset($_REQUEST['export_config_file'])) ? '&export_config_file='.basename($_REQUEST['export_config_file']) : '')),
		'importheader'=>$importheader,
		'CSV_DATA'=>$csv_data
	    ));
	    break;
}
$smarty->display('ebay_products_import.tpl');
require(DIR_WS_INCLUDES . 'footer.php'); 
require(DIR_WS_INCLUDES . 'application_bottom.php'); 
?>
