<?php
require_once(DIR_FS_INC.'xtc_get_manufacturers.inc.php');
if (version_compare(phpversion(), '8.0', '>=')) {
    require_once('includes/classes/UploadSiteHostedPictures.php');
}else{
    require_once('includes/classes/UploadSiteHostedPictures-php7.php');
}
$ini_conf = ebayApi::get_ebay_config_ini();
$config = [
    'production'=>[
        'credentials' => [
            'devId' => $ini_conf['ebay-config']['dev-key-prod'],
            'appId' => $ini_conf['ebay-config']['app-key-prod'],
            'certId' => $ini_conf['ebay-config']['cert-id-prod'],
        ],
        'ruName'=>YES_UNIQUE_RUNAME
    ],
    'sandbox'=>[
        'credentials' => [
            'devId' => $ini_conf['ebay-config']['dev-key-test'],
            'appId' => $ini_conf['ebay-config']['app-key-test'],
            'certId' => $ini_conf['ebay-config']['cert-id-test'],
        ],
        'ruName'=>'agri_consulting-agricons-dccb-4-dttjfcj'
    ],
    'sandbox-devlocal'=>[
        'credentials' => [
            'devId' => 'J73R2RS56Y8ZX5117F8445AI1I9US7',
            'appId' => "agricons-dccb-49b6-be03-a3f5d9cf923c",
            'certId' => "79ed4a03-9c83-4a54-9fdd-c07744ffca42",
        ],
        'ruName'=>'agri_consulting-agricons-dccb-4-dttjfcj'
    ],
];
if(defined('EBAY_TESTMODE') and EBAY_TESTMODE == '1'){
    if(main::isDev(true)){
        $env = 'sandbox-devlocal';
    }else{
        $env = 'sandbox';
    }
}else{
    $env = 'production';
}

switch($action) {
	case 'change':
		if(isset($_FILES['energy_efficiency_image']) and isset($_FILES['energy_efficiency_image']['tmp_name']) and !empty($_FILES['energy_efficiency_image']['tmp_name'])){
		    $epee = \YES4Trade\Model\ebay_products_energy_efficiency::get_by_ebay_products_id((int)$VARS["id"][0]);
		    if($epee != null){
		    	$epee->delete();
		    }
		    $site_name = (isset($_POST['ebay_site'][0]))?$_POST['ebay_site'][0]:EBAY_SITE;
		    $site_id = $EBAYAPI->get_site_id_from_name($site_name);
		    $live = ($env == 'production');
		    $seller = (isset($_POST['ebay_user'][0]) and !empty($_POST['ebay_user'][0]))?$_POST['ebay_user'][0]:EBAY_USER;
		    $ui_auth = [
			'app-name'=>$config[$env]['credentials']['appId'],
			'cert-name'=>$config[$env]['credentials']['certId'], 
			'dev-name'=>$config[$env]['credentials']['devId'], 
			'siteid'=>$site_id,
			'auth-token'=>$EBAYAPI->getToken($seller),
			'comp-level'=>'967',
		    ];
/*		    printf('<p><i>site_id: %d, live: %s, env: %s, seller: %s, php version: %s</i></p>',
			    $site_id, ($live)?'live':'sandbox', $env, $seller,
			    phpversion()
		    );*/
		    $ui = new upload_images($ui_auth,$live);
		    $upload = $ui->upload([
			    file_get_contents($_FILES['energy_efficiency_image']['tmp_name'])
		    ]);
		    $eeID = 0; // wenn label upload geklappt hat,ist das die ID des erzeugten ebay_products_energy_efficiency Eintrags
		    if(isset($upload['state']) and $upload['state'] == 1){
			$warning = '';
			foreach($upload['responses'] as $response){
		    	    $ee = new \YES4Trade\Model\ebay_products_energy_efficiency([
			    	'ebay_products_id'=>(int)$VARS["id"][0],
			    	'energy_efficiency_image_description'=>$_POST['energy_efficiency_image_description'],
			    	'energy_efficiency_image_url'=>$response['FullURL']
			    ]);
			    $eeID = $ee->create();
			    $ee->ebay_products_energy_efficiency_id = (int)$eeID;
			    if(!isset($response['Warning']) or !is_countable($response['Warning'])){
			        continue;
			    }
   			    if(empty($response['Warning']['ShortMessage'])){
				continue;
			    }
			    $warning = sprintf('%s %s #%s: %s<br /><i>%s</i>',
			            $response['Warning']['ErrorClassification'],
			            $response['Warning']['SeverityCode'],
			            $response['Warning']['ErrorCode'],
			            $response['Warning']['ShortMessage'],
			            $response['Warning']['LongMessage'],
			    );
			}
			if(!empty($warning)){
				$messageStack->add_session($warning,'warning');
			}
		    }else{
			$error = 'Upload Failed';
			foreach($upload['responses'] as $response){
			    if(!isset($response['error']) or !is_countable($response['error'])){
			        continue;
			    }
			    $error = sprintf('%s %s #%s: %s<br /><i>%s</i>',
			            $response['error']['ErrorClassification'],
			            $response['error']['SeverityCode'],
			            $response['error']['ErrorCode'],
			            $response['error']['ShortMessage'],
			            $response['error']['LongMessage'],
			    );
			}
			$messageStack->add_session($error,'error');
		    }
		}
		if($eeID > 0){
			if(isset($_FILES['energy_efficiency_ProductInformationsheet']) and isset($_FILES['energy_efficiency_ProductInformationsheet']['tmp_name']) and !empty($_FILES['energy_efficiency_ProductInformationsheet']['tmp_name'])){
				$ui = new upload_images($ui_auth,$live);
				$upload = $ui->upload([
					file_get_contents($_FILES['energy_efficiency_ProductInformationsheet']['tmp_name'])
				]);
				if(isset($upload['state']) and $upload['state'] == 1){
					$warning = '';
					foreach($upload['responses'] as $response){
						$ee->energy_efficiency_ProductInformationsheet = $response['FullURL'];
						$ee->update();
						if(!isset($response['Warning']) or !is_countable($response['Warning'])){
							continue;
						}
						if(empty($response['Warning']['ShortMessage'])){
							continue;
						}
						$warning = sprintf('%s %s #%s: %s<br /><i>%s</i>',
							$response['Warning']['ErrorClassification'],
							$response['Warning']['SeverityCode'],
							$response['Warning']['ErrorCode'],
							$response['Warning']['ShortMessage'],
							$response['Warning']['LongMessage'],
						);
					}
					if(!empty($warning)){
						$messageStack->add_session($warning,'warning');
					}
				}else{
					$error = 'Upload Failed';
					foreach($upload['responses'] as $response){
					    if(!isset($response['error']) or !is_countable($response['error'])){
						continue;
					    }
					    $error = sprintf('%s %s #%s: %s<br /><i>%s</i>',
						    $response['error']['ErrorClassification'],
						    $response['error']['SeverityCode'],
						    $response['error']['ErrorCode'],
						    $response['error']['ShortMessage'],
						    $response['error']['LongMessage'],
					    );
					}
					$messageStack->add_session($error,'error');
				}
			}
		}
		
		
		
		for($i=0;$i<count($VARS["products_id"]);$i++){
                    \YES4Trade\Model\ebay_products_regulatory_hazmats::delete_by_ebay_products_id($VARS["id"][$i]);
                    if(isset($_POST['signalWord']) and !empty($_POST['signalWord'])){
                        $new = new \YES4Trade\Model\ebay_products_regulatory_hazmats([
                            'signalword'=>$_POST['signalWord'],
                            'date_added'=>date('Y-m-d H:i:s'),
                            'ebay_products_id'=>(int)$VARS["id"][$i],
                            'statements'=>(isset($_POST['statements']))?implode(',',$_POST['statements']):'',
                            'pictograms'=>(isset($_POST['pictogram']))?implode(',',$_POST['pictogram']):''
                        ]);
                        $new->create();
                    }
                    $epm_address_fields_arr = [
                        'manufacturer_cityname',
                        'manufacturer_companyname',
                        'manufacturer_country',
                        'manufacturer_email',
                        'manufacturer_phone',
                        'manufacturer_postalcode',
                        'manufacturer_stateorprovince',
                        'manufacturer_street1',
                        'manufacturer_street2'
                    ];
                    $objData = [
                        'ebay_products_id'=>(int)$VARS["id"][$i]
                    ];
                    foreach($epm_address_fields_arr as $eaf){
                        if(isset($_POST[$eaf]) and !empty($_POST[$eaf])){
                            $objData[$eaf] = $_POST[$eaf];
                        }
                    }
                    $epm = new \YES4Trade\Model\ebay_products_manufacturer($objData);
                    $exist_epm = \YES4Trade\Model\ebay_products_manufacturer::get_by_ebay_products_id((int)$VARS["id"][$i]);
                    if($exist_epm === null){
                        if(sizeOf($objData) > 1){
                            $epm->create();
                        }
                    }else{
                        if(sizeOf($objData) > 1){
                      	    $epmid = $exist_epm->ebay_products_manufacturers_id;
                      	    $epm->ebay_products_manufacturers_id = $epmid;
                            $epm->update();
                        }else{
                            \YES4Trade\Model\ebay_products_manufacturer::delete($exist_epm->ebay_products_manufacturers_id);
                        }
                    }
                    
                    $epsaf = \YES4Trade\Model\ebay_products_productsafety::get_by_ebay_products_id((int)$VARS["id"][$i]);
                    if($epsaf != null){
                        \YES4Trade\Model\ebay_products_productsafety::delete($epsaf->ebay_products_productsafety_id);
                    }
                    $productsafety_statements = [];
                    if(isset($_POST['productsafety_statements']) and is_countable($_POST['productsafety_statements']) and sizeOf($_POST['productsafety_statements'])){
                        foreach($_POST['productsafety_statements'] as $pst){
                            $productsafety_statements[] = $pst;
                        }
                    }
                    $productsafety_pictograms = [];
                    if(isset($_POST['safety_pictogram']) and is_countable($_POST['safety_pictogram']) and sizeOf($_POST['safety_pictogram'])){
                        foreach($_POST['safety_pictogram'] as $spt){
                            $productsafety_pictograms[] = $spt;
                        }
                    }
                    if(sizeOf($productsafety_pictograms) or sizeOf($productsafety_statements)){
                        $new = new \YES4Trade\Model\ebay_products_productsafety([
                            'statements'=>implode(',',$productsafety_statements),
                            'pictograms'=>implode(',',$productsafety_pictograms),
                            'ebay_products_id'=>(int)$VARS["id"][$i],
                        ]);
                        $new->create();
                    }
                    
                    
			$orig_data = $EBAYAPI->getProductDetails($VARS["id"][$i]); // um aenderungen zu ermitteln
			$preis =  (float)str_replace(',','.',$VARS["ebay_preis"][$i]);
			$spreis = (float)str_replace(',','.',$VARS["ebay_sofortkauf_preis"][$i]);
			$bestofferpreis = (float)str_replace(',','.',$VARS["ebay_bestoffer_price"][$i]);
			$bestofferautoacceptprice = (float)str_replace(',','.',$VARS["ebay_bestofferautoacceptprice"][$i]);
			$reserveprice = (float)str_replace(',','.',$VARS["reserveprice"][$i]);
			
			$cID = xtc_get_site_country_id($VARS['ebay_site'][$i]);
                        
			$lID = xtc_is_language_installed($cID);
			if(!$lID){
                            $lang_exists = false;
                        }else{
                            $lang_exists = true;
                        }
                        // UM LOKAL ZB AUF ebay us EINZUSTELLEN
                        if(main::isDev(true)){ // lang select
                            $lang_exists = true;
                        }
			// UPDATE EXTRATEXT DES ORIG PRODUKTES
			if(isset($VARS['update_extratext'][$i]) and $VARS['update_extratext'][$i] == 1){
				$new_extratext = xtc_db_prepare_input($VARS["ebay_beschreibung_".$i]);
				$pID = $orig_data['products_id'];
				$P = new product($pID);
				$update_sql_array = array(
					'products_extra_text'=>$new_extratext
				);
				xtc_db_perform('products_description',$update_sql_array,'update',"products_id='".$pID."' and language_id='".$_SESSION['languages_id']."'");
				$P->add_history( sprintf( TEXT_SQ_UPDATE_EXTRATEXT, $VARS["id"][$i]) );
			}
			$gallery = (isset($VARS['gallery'][$i])) ? $VARS['gallery'][$i] : '';

			$sofortneu = (isset($VARS["zustand"][$i])) ? $VARS["zustand"][$i] : 0;

			$new = (isset($VARS["zustand"][$i]) and $VARS["zustand"][$i] == 'new') ? '1' : '0';
			// BUGFIX - SHOPKATEGORIEN SIND SELLERABHAENGIG
			$shop_categories_array = xtc_get_ebayshop_categorys($VARS['ebay_user'][$i]);
			$shopcat_name = '';
			$shopcat2_name = '';
			if(isset($VARS['shopcat1'][$i]) and $VARS['shopcat1'][$i] != ''){
				for($sci=0;$sci<sizeOf($shop_categories_array);$sci++){
					if($shop_categories_array[$sci]['id'] == $VARS['shopcat1'][$i])
						$shopcat_name = $shop_categories_array[$sci]['text'];
					if($shop_categories_array[$sci]['id'] == $VARS['shopcat2'][$i])
						$shopcat2_name = $shop_categories_array[$sci]['text'];
				}
			}
			$gallery = ($VARS["ebay_gallery"][$i] == 1) ? 1 : 0;
			$gallery_plus = ($VARS["ebay_gallery"][$i] == 2) ? 1 : 0;
                        $scheduletime = ($VARS['scheduletime'] != '' and $VARS['scheduletime'] != '0000-00-00') ? $VARS['scheduletime'].' '.$VARS['scheduletime_time'] : '';
                        // BOF - 2024-07 check scheduletime valide und in der
                        // zukunft. Ansonsten Wert loeschen und Messagestack
                        $schedule_time_error = false;
                        if($scheduletime != ''){
                            if($scheduletime != '0000-00-00 00:00:00'){
                                $dformat = 'Y-m-d H:i:s';
                                $d = DateTime::createFromFormat($dformat, $scheduletime);
                                // The Y ( 4 digits year ) returns TRUE for any integer with any number of digits so changing the comparison from == to === fixes the issue.
                                if($d && $d->format($dformat) === $scheduletime){
                                    $current_date = new DateTime();
                                    if ($d < $current_date){
                                        $schedule_time_error = true;
                                    }
                                }else{
                                    $schedule_time_error = true;
                                }
                            }else{
                                $schedule_time_error = true;
                            }
                        }
                        if($schedule_time_error){
                            $scheduletime = '';
                            $messageStack->add_session(sprintf(
                                MSG_ERROR_EBAY_PRODUCT_INVALID_SCHEDULE_DATE,
                                $VARS["ebay_titel"][$i],
                                $VARS['scheduletime'].' '.$VARS['scheduletime_time']
                                ),'error'
                            );
                        }
                        // EOF - 2024-07 check scheduletime valide und in Zukunft
			$update_sql_array = array(
				'ebay_angebotsformat'=>xtc_db_input( $VARS["ebay_angebotsformat"][$i] ),
				'ebay_titel'=>xtc_db_input($VARS["ebay_titel"][$i]),
				'ebay_bild'=>$VARS["ebay_bild"][$i],
				'ebay_untertitel'=>$VARS["ebay_untertitel"][$i],
				'ebay_preis'=>$preis,
				'ebay_sofortkauf_preis'=>$spreis,
				'ebay_auktionsdauer'=>xtc_db_input($VARS["ebay_auktionsdauer"][$i]),
				'ebay_counter'=>xtc_db_input($VARS["ebay_counter"][$i]),
				'ebay_gallery'=>$gallery,
				'ebay_gallery_plus'=>$gallery_plus,
				'ebay_galleryfeatured'=>((isset($VARS["ebay_galleryfeatured"][$i])) ? xtc_db_input($VARS["ebay_galleryfeatured"][$i]) : 0),
				'ebay_galleryfeaturedduration'=>xtc_db_input($VARS["ebay_galleryfeaturedduration"][$i]),
				'ebay_menge'=>xtc_db_input($VARS["ebay_menge"][$i]),
				'ebay_template'=>xtc_db_input($VARS['ebay_template'][$i]),
				'ebay_vat'=>xtc_db_input($VARS["ebay_vat"][$i]),
				'ebay_geldzurueck'=>xtc_db_input($VARS["ebay_geldzurueck"][$i]),
				'ebay_sofortneu'=>$sofortneu,
				'ebay_new'=>$new,
				'ebay_bestoffer'=>xtc_db_input($VARS["ebay_bestoffer"][$i]),
				'ebay_bestoffer_price'=>$bestofferpreis,
				'ebay_bestofferautoacceptprice'=>$bestofferautoacceptprice,
/*			    
				'select_set'=>((isset($VARS['select_set'][$i]))?$VARS['select_set'][$i]:0),
				'select_set_multiple'=>((isset($VARS['select_set'][$i]) and $VARS['select_set'][$i] == 1) ? $VARS['select_set_multiple'][$i] : 0),
 * 
 */
				'ebay_beschreibung'=>xtc_db_prepare_input($VARS["ebay_beschreibung_".$i]),
				'ebay_paymentinstructions'=>$VARS['paymentinstructions_'.$i],
				'ebay_ort'=>$VARS['ebay_ort'][$i],
				'ebay_land'=>strtoupper($VARS['ebay_land'][$i]),
				'ebay_user'=>$VARS['ebay_user'][$i],
				'ebay_revise'=>$VARS['ebay_revise'][$i],
				'ebay_revise_option'=>(($VARS['ebay_revise'][$i] != '') ? $VARS['ebay_revise_option'][$i] : '' ),
				'ebay_postalcode'=>(($VARS['ebay_postalcode'][$i] != '') ? $VARS['ebay_postalcode'][$i] : '' ),
				'ebay_dispatchtimemax'=>(($VARS['ebay_dispatchtimemax'][$i] != '') ? $VARS['ebay_dispatchtimemax'][$i] : '' ),
			    'isbn'=>$VARS['isbn'][$i],
			    'ean'=>$VARS['ean'][$i],
				'STATUS'=>2,
				'reserveprice'=>$reserveprice,
                            'returnswithincode'=>((isset( $VARS['configuration']['returnswithincode['.$i] ) )?$VARS['configuration']['returnswithincode['.$i]:''),
                            'shippingcostpaidby'=>((isset( $VARS['configuration']['shippingcostpaidby['.$i]))?$VARS['configuration']['shippingcostpaidby['.$i]:''),
			    'ebay_plus'=>$VARS['ebay_plus'][$i],
			    'seller_profile_payment_id' => $VARS['seller_profile_payment_id'][$i],
			    'seller_profile_return_policy_id' => $VARS['seller_profile_return_policy_id'][$i],
			    'seller_profile_shipping_id' => $VARS['seller_profile_shipping_id'][$i],
                            'ProductReferenceID'=>$VARS['ProductReferenceID'][$i],
                            'scheduletime'=>$scheduletime
			);
				
			if($lang_exists){
				$update_sql_array['ebay_site']=$VARS['ebay_site'][$i];
			}else{
				$update_sql_array['ebay_site']=EBAY_SITE;
				$wrong_site = $VARS['ebay_site'][$i];
				$VARS['ebay_site'][$i] = EBAY_SITE; // damit history geschrieben wird
				$messageStack->add_session(sprintf(TEXT_MESSAGE_LANGUAGE_PACK_ERROR,$wrong_site,EBAY_SITE),'error');
			}

			
			$where = "id=".xtc_db_input($VARS["id"][$i]);
			xtc_db_perform(TABLE_EBAY_PRODUCTS,$update_sql_array,'update',$where);

			// payments
			xtc_db_query("DELETE FROM ebay_products_payments WHERE ebay_products_id='".$VARS["id"][$i]."'");
			if(is_array($_POST['payment'][$i]) and sizeOf($_POST['payment'][$i]) > 0){
				foreach($_POST['payment'][$i] as $k=>$v){
					xtc_db_query("INSERT INTO ebay_products_payments SET payment='".$v."',ebay_products_id='".$VARS["id"][$i]."'");
				}
			}

			// itemspecifics
			xtc_db_query("DELETE FROM ebay_products_itemspecifics WHERE ebay_products_id='".$VARS["id"][$i]."'");
			for($ii=0;$ii<sizeOf($_POST);$ii++){
				if( isset($_POST['is_name_'.$ii][$i]) and isset($_POST['is_value_'.$ii][$i]) and xtc_not_null($_POST['is_name_'.$ii][$i]) and xtc_not_null($_POST['is_value_'.$ii][$i]) ){
					$insert_sql_array = array(
						'is_name'=>$_POST['is_name_'.$ii][$i],
						'is_value'=>$_POST['is_value_'.$ii][$i],
						'ebay_products_id'=>$VARS["id"][$i]
					);
					xtc_db_perform('ebay_products_itemspecifics',$insert_sql_array);
				}
			}

			xtc_db_query("DELETE FROM ebay_template_excludes WHERE ebay_products_id='".xtc_db_input($VARS["id"][$i])."'");
			if(isset($_POST['excludepic']) and is_array($_POST['excludepic'][$i])){
				for($ex = 0;$ex<count($_POST['excludepic'][$i]);$ex++){
					xtc_db_query("INSERT INTO ebay_template_excludes SET ebay_products_id='".xtc_db_input($VARS["id"][$i])."', pic='".xtc_db_input($_POST['excludepic'][$i][$ex])."'");
				}
			}
			if(EBAY_PRODUCTS_HISTORY == 1){
				// UPDATE EXTRATEXT DES ORIG PRODUKTES
				if(isset($VARS['update_extratext']) and $VARS['update_extratext'][$i] and $VARS['update_extratext'][$i] == 1){
					$EBAYAPI->save_history($VARS["id"][$i],TEXT_UPDATE_CART_EXTRATEXT,$_SESSION['customer_id']);
				}

				if($preis <> $orig_data['ebay_preis']){
					$EBAYAPI->save_history($VARS["id"][$i],sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_AUCTION_STARTPRICE,$orig_data['ebay_preis'],$preis),$_SESSION['customer_id']);
				}
				if($reserveprice <> $orig_data['reserveprice']){
					$EBAYAPI->save_history($VARS["id"][$i],sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_AUCTION_RESERVEPRICE,$orig_data['reserveprice'],$reserveprice),$_SESSION['customer_id']);
				}
				if($bestofferautoacceptprice <> $orig_data['ebay_bestofferautoacceptprice']){
					$EBAYAPI->save_history($VARS["id"][$i],sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_BESTOFFERAUTOACCEPTPRICE,$orig_data['ebay_bestofferautoacceptprice'],$bestofferautoacceptprice),$_SESSION['customer_id']);
				}
				/*
				if(isset($VARS['select_set']) and ((bool)$orig_data['select_set'] != (bool)$VARS['select_set'][$i])){
					$EBAYAPI->save_history($VARS["id"][$i],sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_SET_SELECT,$orig_data['select_set'],$VARS['select_set'][$i]),$_SESSION['customer_id']);
				}
				if(isset($VARS['select_set_multiple']) and ( (int)$orig_data['select_set_multiple'] != (int)$VARS['select_set_multiple'][$i])){
					$EBAYAPI->save_history($VARS["id"][$i],sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_SET_MULTIPLE_CHOICE,$orig_data['select_set_multiple'],$VARS['select_set_multiple'][$i]),$_SESSION['customer_id']);
				}
				 *
				 */
				
				if($spreis <> $orig_data['ebay_sofortkauf_preis']){
					$EBAYAPI->save_history($VARS["id"][$i],sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_BUYITNOWPRICE,$orig_data['ebay_sofortkauf_preis'],$spreis),$_SESSION['customer_id']);
				}
				if($bestofferpreis <> $orig_data['ebay_bestoffer_price']){
					$EBAYAPI->save_history($VARS["id"][$i],sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_AUCTION_ALLOW_BESTOFFER_FROM,$orig_data['ebay_bestoffer_price'],$bestofferpreis),$_SESSION['customer_id']);
				}

				if($orig_data['ebay_user'] != $VARS['ebay_user'][$i]){
					$EBAYAPI->save_history($VARS["id"][$i],sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_USER,$orig_data['ebay_user'],$VARS["ebay_user"][$i]),$_SESSION['customer_id']);
				}
				if($orig_data['ebay_ort'] != $VARS['ebay_ort'][$i]){
					$EBAYAPI->save_history($VARS["id"][$i],sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_SELLER_LOCATION,$orig_data['ebay_ort'],$VARS["ebay_ort"][$i]),$_SESSION['customer_id']);
				}
				if(strtoupper($orig_data['ebay_land']) != strtoupper($VARS['ebay_land'][$i])){
					$EBAYAPI->save_history($VARS["id"][$i],sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_SELLER_COUNTRY,$orig_data['ebay_land'],$VARS["ebay_land"][$i]),$_SESSION['customer_id']);
				}
				if($orig_data['ebay_angebotsformat'] != $VARS["ebay_angebotsformat"][$i]){
					$EBAYAPI->save_history($VARS["id"][$i],sprintf(TEXT_UPDATE_CART_FIELD_VALUE,'Auctionformat',$orig_data['ebay_angebotsformat'],$VARS["ebay_angebotsformat"][$i]),$_SESSION['customer_id']);
				}
				if($orig_data['ebay_titel'] != $VARS["ebay_titel"][$i]){
					$EBAYAPI->save_history($VARS["id"][$i],sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_AUCTION_TITLE,$orig_data['ebay_titel'],$VARS["ebay_titel"][$i]),$_SESSION['customer_id']);
				}
				if($orig_data['ebay_untertitel'] != $VARS["ebay_untertitel"][$i]){
					$EBAYAPI->save_history($VARS["id"][$i],sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_AUCTION_SUBTITLE,$orig_data['ebay_untertitel'],$VARS["ebay_untertitel"][$i]),$_SESSION['customer_id']);
				}
				if($orig_data['ebay_auktionsdauer'] != $VARS["ebay_auktionsdauer"][$i]){
					$EBAYAPI->save_history($VARS["id"][$i],sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TABLE_HEADING_DURATION,$orig_data['ebay_auktionsdauer'],$VARS["ebay_auktionsdauer"][$i]),$_SESSION['customer_id']);
				}
				if($orig_data['ebay_counter'] != $VARS["ebay_counter"][$i]){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_COUNTER,$orig_data['ebay_counter'],$VARS["ebay_counter"][$i]);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				/*
				if($orig_data['ebay_gallery'] != $VARS["ebay_gallery"][$i]){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_AUCTION_IMAGE_STYLE_GALLERY,$orig_data['ebay_gallery'],xtc_db_input($VARS["ebay_gallery"][$i]));
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if($orig_data['ebay_gallery_plus'] != $VARS["ebay_gallery_plus"][$i]){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_AUCTION_IMAGE_STYLE_GALLERYPLUS,$orig_data['ebay_gallery_plus'],xtc_db_input($VARS["ebay_gallery"][$i]));
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				 * 
				 */
                                $check_val = (isset($VARS["ebay_galleryfeatured"][$i])) ? (int)$VARS["ebay_galleryfeatured"][$i] : 0;
				if($orig_data['ebay_galleryfeatured'] != $check_val){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_AUCTION_IMAGE_STYLE_GALLERYFEATURED,$orig_data['ebay_galleryfeatured'],xtc_db_input($check_val));
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
                                $check_val = (isset($VARS["ebay_galleryfeaturedduration"][$i])) ? (int)$VARS["ebay_galleryfeaturedduration"][$i] : 0;
				if($orig_data['ebay_galleryfeaturedduration'] != $check_val){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_AUCTION_IMAGE_STYLE_GALLERYFEATURED_DURATION,$orig_data['ebay_galleryfeaturedduration'],xtc_db_input($check_val));
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if($orig_data['ebay_menge'] != $VARS["ebay_menge"][$i]){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_EBAY_QUANTITY,$orig_data['ebay_menge'],$VARS["ebay_menge"][$i]);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if($orig_data['ebay_template'] != $VARS['ebay_template'][$i]){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_EBAY_TEMPLATE,$orig_data['ebay_template'],$VARS["ebay_template"][$i]);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if($orig_data['ebay_vat'] != $VARS["ebay_vat"][$i]){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_EBAY_TAX,$orig_data['ebay_vat'],$VARS["ebay_vat"][$i]);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if($orig_data['ebay_geldzurueck'] != $VARS["ebay_geldzurueck"][$i]){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_GELDZURUECK,$orig_data['ebay_geldzurueck'],$VARS["ebay_geldzurueck"][$i]);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if((bool)$orig_data['ebay_sofortneu'] != (bool)$sofortneu){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_ZUSTAND_NOWNEW,$orig_data['ebay_sofortneu'],$sofortneu);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if($orig_data['ebay_new'] != $new){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_ZUSTAND_NEW,$orig_data['ebay_new'],$new);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if($orig_data['ebay_bestoffer'] != $VARS["ebay_bestoffer"][$i]){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_AUCTION_ALLOW_BESTOFFER,$orig_data['ebay_bestoffer'],$VARS["ebay_bestoffer"][$i]);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if($orig_data['ebay_site'] != $VARS["ebay_site"][$i]){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_EBAY_SITE,$orig_data['ebay_site'],$VARS["ebay_site"][$i]);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if($orig_data['ebay_paymentinstructions'] != $VARS["paymentinstructions_".$i]){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_AUCTION_PAYMENTINFO,$orig_data['ebay_paymentinstructions'],$VARS["paymentinstructions_".$i]);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if($orig_data['ebay_revise'] != $VARS["ebay_revise"][$i]){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_EBAY_REVISE,$orig_data['ebay_revise'],$VARS["ebay_revise"][$i]);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if($orig_data['ebay_revise_option'] != $VARS["ebay_revise_option"][$i]){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_EBAY_REVISE_OPTION,$orig_data['ebay_revise_option'],$VARS["ebay_revise_option"][$i]);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if($orig_data['ebay_postalcode'] != $VARS["ebay_postalcode"][$i]){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_EBAY_POSTALCODE,$orig_data['ebay_postalcode'],$VARS["ebay_postalcode"][$i]);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if($orig_data['ebay_dispatchtimemax'] != $VARS["ebay_dispatchtimemax"][$i]){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_EBAY_DISPATCHTIMEMAX,$orig_data['ebay_dispatchtimemax'],$VARS["ebay_dispatchtimemax"][$i]);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
				if($orig_data['scheduletime'] != $scheduletime){
					$comment = sprintf(TEXT_UPDATE_CART_FIELD_VALUE,TEXT_SCHEDULETIME,$orig_data['scheduletime'],$scheduletime);
					$EBAYAPI->save_history($VARS["id"][$i],$comment,$_SESSION['customer_id']);
				}
			}
                        
                        if($orig_data['products_id'] > 0 and isset($_REQUEST['update_to_all_products_id_cart_items']) and sizeOf($_REQUEST['update_to_all_products_id_cart_items'])){
                            $update_sql_array = array();
                            foreach($_REQUEST['update_to_all_products_id_cart_items'] as $part=>$use_part){
                                if($use_part != 1){
                                    continue;
                                }
                                switch($part){
                                    case 'images':
                                        $update_sql_array['ebay_bild']=$VARS["ebay_bild"][$i];
                                        $update_sql_array['ebay_gallery']=$gallery;
                                        $update_sql_array['ebay_gallery_plus']=$gallery_plus;
                                        $update_sql_array['ebay_galleryfeatured']= ((isset($VARS["ebay_galleryfeatured"][$i])) ? xtc_db_input($VARS["ebay_galleryfeatured"][$i]) : 0);
                                        $update_sql_array['ebay_galleryfeaturedduration']=xtc_db_input($VARS["ebay_galleryfeaturedduration"][$i]);
                                        if(isset($_POST['excludepic']) and is_array($_POST['excludepic'][$i])){
                                            $other_cart_items_with_same_products_id = array();
                                            $other_cart_items_with_same_products_id_query = xtc_db_query(sprintf(
                                                    "SELECT id FROM ebay_products WHERE products_id='%s' and id != '%s'",
                                                    $orig_data['products_id'],
                                                    xtc_db_input($VARS["id"][$i])
                                            ));
                                            while($other_cart_items_with_same_products_id_res = xtc_db_fetch_array($other_cart_items_with_same_products_id_query)){
                                                $other_cart_items_with_same_products_id[] = $other_cart_items_with_same_products_id_res['id'];
                                            }
                                            foreach($other_cart_items_with_same_products_id as $ocipID){
                                                xtc_db_query(sprintf(
                                                    "DELETE FROM ebay_template_excludes WHERE ebay_products_id='%s'",
                                                    $ocipID
                                                ));
                                                for($ex = 0;$ex<count($_POST['excludepic'][$i]);$ex++){
                                                    xtc_db_query(sprintf(
                                                        "INSERT INTO ebay_template_excludes SET ebay_products_id='%s', pic='%s'",
                                                        $ocipID,
                                                        xtc_db_input($_POST['excludepic'][$i][$ex])
                                                    ));
                                                }
                                            }
                                        }
                                        break;
                                    case 'description':
                                        $update_sql_array['ebay_beschreibung']=xtc_db_prepare_input($VARS["ebay_beschreibung_".$i]);
                                        break;
                                }
                            }
                            if(sizeOf($update_sql_array)){
                                xtc_db_perform('ebay_products', $update_sql_array, 'update',"products_id='".$orig_data['products_id']."' AND id != '".xtc_db_input($VARS["id"][$i])."'");
                            }
                        }
                        
                        $verify = true;
                        $site_id = $EBAYAPI->get_site_id_from_name($VARS['ebay_site'][$i]);
                        $seller = $VARS['ebay_user'][$i] ?? EBAY_USER;
                        $reqObj = $EBAYAPI->itemAddProcess($VARS['id'][$i],$mode = 'normal',false, $verify);
						if($reqObj !== false){
							$ebaycaller = new \YES4Trade\Model\ebaycalls();
							$result = json_decode(json_encode($reqObj),true);
							switch($VARS['ebay_angebotsformat'][$i]){
								case 'FixedPriceItem':
									$res = $ebaycaller->tradingQuery(
										$seller,
										'VerifyAddFixedPriceItem',
										$site_id,
										$result
									);
									break;
								default:
									$res = $ebaycaller->tradingQuery(
										$seller,
										'VerifyAddItem',
										$site_id,
										$result
									);
									break;
							}
						}

                        if(sizeOf($EBAYAPI->item_add_errors)){
                            foreach($EBAYAPI->item_add_errors as $iae){
                                $messageStack->add_session('Item '.$VARS["ebay_titel"][$i].': '.$iae,'error');
                            }
                        }else{
                            if(!$EBAYAPI->isGood($res)){
                                    $error = $EBAYAPI->getResponseErrors( $res );
									foreach($error as $erk=>$erv){
										$error[$erk] = htmlentities($erv);
									}
                                    $script = "<script type=\"text/javascript\">".
                                    '    $(function(){'.
                                    '       $(\'#modal_window\').dialog({'.
                                    '           title: \'eBay Fehler\','.
                                    '           width: \'auto\','.
                                    '           height: \'auto\','.
                                    '           modal: true'.
                                    '       }).html(\'<div class="main">'.implode('<div style="padding:5px;"></div>',$error).'</div>\');'.
                                    '   });'.
                                    "</script>";
                                    $messageStack->add_session('Produkt '.$VARS["ebay_titel"][$i].': '.$script,'error');
                            }else{
                                    $messageStack->add_session('Produkt '.$VARS["ebay_titel"][$i].' wurde gespeichert.','success');
                            }
                        } // EOF sizeOf(EBAYAPI->item_add_errors)
                }                
		xtc_redirect(xtc_href_link(FILENAME_EBAYAPI_CART, xtc_get_all_get_params(array('page_type','action','id')).'page_type=cart'));
		break;
}

$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$dispatch_values = array(array('id'=>'','text'=>TEXT_SELECT));
$ebay_dispatch_details = $EBAYAPI->get_ebay_details('DispatchTimeMaxDetails');
foreach($ebay_dispatch_details->DispatchTimeMaxDetails as $dtm){
    $dispatch_values[] = array(
	'id'=>$dtm->DispatchTimeMax,
	'text'=>str_replace(array('Days','Day'), array('Tage','Tag'),$dtm->Description)
    );
}
$smarty->assign('DISPATCH_VALUES',$dispatch_values);
// AUKTIONSDAUER
$auction_durations = array();
$durations_query = xtc_db_query("SELECT * FROM ebay_durations ORDER BY duration");
while($duration = xtc_db_fetch_array($durations_query)){
	if($duration['duration'] > 0)
		$auction_durations[ $duration['duration'] ] = $duration['duration'].' Tage';
	else
		$auction_durations[ $duration['duration'] ] = 'Bis auf Widerruf';
}

// EBAY-TEMPLATES
$auction_templates = array();
if ($dir= opendir(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/ebay_templates/')){
	while  (($file = readdir($dir)) !==false) {
		if (is_file( DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/ebay_templates/'.$file) and ($file !="index.html")){
			$auction_templates_array[] = $file;
		}
	} // while
	closedir($dir);
}
if(sizeOf($auction_templates_array)){
	sort($auction_templates_array);
	foreach($auction_templates_array as $template){
		$auction_templates[$template] = $template;
	}
}
// NEUE BESTOFFER MATRIX
if(isset($_GET['bestoffer_action']) and $_GET['bestoffer_action'] == 'add'){
	$smarty->assign('BESTOFFER_ADD_FORM',xtc_draw_form("besto", FILENAME_EBAYAPI_CART, xtc_get_all_get_params(array('bestoffer_action')).'bestoffer_action=save_new', 'post'));
	$smarty->assign('BESTOFFER_ERRORS',$bestoffer_errortext);
}

$bool_array = array('0'=>NO,'1'=>YES);
$smarty->assign('FORM',xtc_draw_form("ebayapi", FILENAME_EBAYAPI_CART, xtc_get_all_get_params(array('action')), 'post','enctype="multipart/form-data"'));

if(is_array($_REQUEST['id'])) {
    $_REQUEST['id'] = current($_REQUEST['id']);
}
$id = xtc_db_input($_REQUEST['id']);

$templates_array = array();
$lID = 2;
$template_link = 'categories.php?action=get_template_content&cgID=100&lID='.$lID.'&cID=';
$items = \YES4Trade\Model\content_manager::get_by_content_group(100);
foreach($items as $it){
    $template = $it->toArray();
    $templates_array[] = array(
        'title'=>xtc_db_prepare_input($template['content_title']),
        'description'=>xtc_db_prepare_input($template['content_heading']),
        'file'=>$template_link . $template['content_id']
    );
}

$ebay_users = xtc_get_ebay_users();
$auctions = array();
$zaehler = 0;
$data = $EBAYAPI->getProductDetails($id);
if(gettype($data) === 'boolean'){
    printf(
            ERROR_CART_ITEM_DOESNT_EXISTS,
            $id
    );
    echo '<br /><a href="ebayapi_cart.php">'.IMAGE_BACK.'</a>';
    require(DIR_WS_INCLUDES . 'footer.php');
    require(DIR_WS_INCLUDES . 'application_bottom.php');
    exit;
}
$auction = $data;
$auction['products_name'] = xtc_get_products_name($data['products_id']);
$cp = xtc_get_product_path($data['products_id']);
$auction['products_link'] = xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cp . '&pID=' . $data['products_id'].'&action=new_product');
if(EBAY_DESCRIPTION_SOURCE == '1'){
        $smarty->assign('extratext_update_confirm',1);
}
	
$buttons = array(
    array(
	'text'=>TEXT_PRODUCTS_LINK,
	'link'=>$auction['products_link'],
	'auth'=>true,
	'lbOn'=>false
    ),
    array(
	'text'=>TEXT_UPDATE_TITLE,
	'link'=>xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('products_update','title_update','extra_update','image_update','id')).'title_update=1&id='.$id ),
	'auth'=>true,
	'lbOn'=>false
    ),
    array(
	'text'=>TEXT_UPDATE_EXTRATEXT,
	'link'=>sprintf('javascript:void( update_desc_field(\'%s\') )',xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('products_update','title_update','extra_update','image_update','id')).'extra_update=1&id='.$id )),
	'auth'=>true,
	'lbOn'=>false
    ),
    array(
	'text'=>TEXT_UPDATE_DESCRIPTION,
	'link'=>sprintf('javascript:void( update_desc_field(\'%s\') )',xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('products_update','title_update','extra_update','image_update','id')).'products_update=1&id='.$id )),
	'auth'=>true,
	'lbOn'=>false
    ),
    array(
	'text'=>TEXT_UPDATE_IMAGE,
	'link'=>sprintf('javascript:void( update_images(\'%s\') )',xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('products_update','title_update','extra_update','image_update','id')).'image_update=1&id='.$id )),
	'auth'=>true,
	'lbOn'=>false
    )
);
$evs_query = xtc_db_query(sprintf(
	"SELECT ebay_variations_sets_id FROM ebay_variations_sets WHERE ebay_products_id='%s'",
	$id
));
if(xtc_db_num_rows($evs_query)){
    $evs = xtc_db_fetch_array($evs_query);
	$buttons[] =  array(
	    'text'=>TEXT_SET_VARIATIONSET_DETAILS,
	    'link'=>xtc_href_link('ebayapi_cart.php','page_type=multi_variations&evsID='.$evs['ebay_variations_sets_id']),
	    'auth'=>true,
	    'lbOn'=>false
	);
}
$add_title = $auction['products_name'].'&nbsp;(pID '.$auction['products_id'].')';
$heading_title = sprintf('%s ID %s',TEXT_CONFIGURE_CART_ITEM,$data['id']);
if($data['locked'] == 1){
    $heading_title .= sprintf(' (%s)',TEXT_LOCKED);
}
$dynamic_tooltip_link = '';
if($data['products_id'] > 0){
    $dynamic_tooltip_link = sprintf(
	    '<a title="Info pID %s" rel="products.php?action=ajax_view&pID=%s" class="yes_dynamic_tooltip">',
	    $data['products_id'],$data['products_id'],$data['products_id']
    );
}

$smarty->assign(array(
    'FORM_END'=>'</form>',
    'HEADING_TITLE'=>$heading_title,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'ADDITIONAL_TITLE'=>$add_title,
    'DYNAMIC_TOOLTIP_LINK'=>$dynamic_tooltip_link,
    'TEXT_EBAY_SELLER_PROFILE_INTRO'=>TEXT_EBAY_SELLER_PROFILE_INTRO
));
	
	
	$_SESSION["ebay_sammler"] = $data['ebay_sammler_id'];
	$shop_categories_array = xtc_get_ebayshop_categorys($data['ebay_user']);
	$auction['zaehler'] = $zaehler;
	$auction['input_title'] = xtc_draw_input_field('ebay_titel['.$zaehler.']',xtc_db_prepare_input($auction["ebay_titel"]),'maxlength="'.MAX_SIZE_EBAY_TITLE.'" size="'.MAX_SIZE_EBAY_TITLE.'"');
	$auction['input_subtitle'] = xtc_draw_input_field('ebay_untertitel['.$zaehler.']',xtc_db_prepare_input($auction["ebay_untertitel"]),'maxlength="'.MAX_SIZE_EBAY_TITLE.'" size="'.MAX_SIZE_EBAY_TITLE.'"');

	$auction['input_description'] = xtc_draw_textarea_field("ebay_beschreibung_$zaehler", 'virtual', 80, 30,xtc_db_prepare_input($auction["ebay_beschreibung"]),'class="tinymce"').
			xtc_wysiwyg($templates_array);

	// BILDER ZUR AUKTION
	$auction_pics = array();			
	$pic_query = xtc_db_query("SELECT products_image,products_model FROM products WHERE products_id='".$data['products_id']."'");
	$firstpic = xtc_db_fetch_array($pic_query);
	$auction['products_model'] = xtc_db_prepare_input($firstpic['products_model']);
	$exclude_query = xtc_db_query("SELECT * FROM ebay_template_excludes WHERE ebay_products_id='".$data['id']."' && pic='".$firstpic['products_image']."'");
	$excludes = xtc_db_num_rows($exclude_query);
	$excl = ($excludes > 0) ? 1 : 0;
	$auction_pics[] = array(
		'ebay_bild_radio'=>xtc_draw_radio_field("ebay_bild[$zaehler]",$firstpic['products_image'],(($data['ebay_bild'] == $firstpic['products_image']) ? true : false )),
		'text'=>$firstpic['products_image'],
		'src'=>EBAY_PICPATH_WEBSERVER.$firstpic['products_image'],
		'exclude'=>xtc_draw_checkbox_field('excludepic['.$zaehler.'][]',$firstpic['products_image'],$excl)
	);
	$pics = array();
	$pics_double = array();
	$pic_query = xtc_db_query("SELECT image_name FROM products_images WHERE products_id='".$data['products_id']."' order by image_nr");
	while($pic = xtc_db_fetch_array($pic_query)){
		if( !in_array( $pic['image_name'], $pics_double ) ){
			$pics[] = array('id'=>$pic['image_name'],'text'=>$pic['image_name']);
			$pics_double[] = $pic['image_name'];
		}
	}
	for($picc=0;$picc<count($pics);$picc++){
		$exclude_query = xtc_db_query("SELECT * FROM ebay_template_excludes WHERE ebay_products_id='".$data['id']."' && pic='".$pics[$picc]['text']."'");
		$excludes = xtc_db_num_rows($exclude_query);
		$excl = ($excludes > 0) ? 1 : 0;
		$auction_pics[] = array(
			'ebay_bild_radio'=>xtc_draw_radio_field("ebay_bild[$zaehler]",$pics[$picc]['text'],(($data['ebay_bild'] == $pics[$picc]['text'])? true : false )),
			'text'=>$pics[$picc]['text'],
			'src'=>EBAY_PICPATH_WEBSERVER.$pics[$picc]['text'],
			'exclude'=>xtc_draw_checkbox_field('excludepic['.$zaehler.'][]',$pics[$picc]['text'],$excl)
		);
		
	}
	$auction['pics'] = $auction_pics;

	// LINKS
	$auction['SELFLINK'] = xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('bestoffer_action','id')).'id='.$id);

	// SITE SELECT
	if($auction['ebay_site'] == '') 
		$auction['ebay_site'] = EBAY_SITE_ID;
	$auction['ebay_site_select'] = xtc_draw_pull_down_menu('ebay_site['.$zaehler.']',$ebay_sites,$auction['ebay_site']);

	$auction['pi'] = xtc_draw_input_field('paymentinstructions_'.$zaehler,$data['ebay_paymentinstructions'],'size="20" maxlength="500"');

	$auction['input_price'] = xtc_draw_input_field('ebay_preis['.$zaehler.']',number_format($auction["ebay_preis"],2,',',''));
	$auction['input_buyitnowprice'] = xtc_draw_input_field('ebay_sofortkauf_preis['.$zaehler.']',number_format($auction["ebay_sofortkauf_preis"],2,',',''));
	$auction['input_reserveprice'] = xtc_draw_input_field('reserveprice['.$zaehler.']',number_format($auction["reserveprice"],2,',',''));



	// KATEGORIEN
	$auction['input_category1'] = '<a style="padding:0px;" id="'.xtc_href_link('ebayapi_cart.php','action=quick_edit_category&nr=1&nolisting=1&id='.$id).'" href="javascript:;" class="lbOn" title="'.BUTTON_SELECT_CATEGORY.'"><div style="width:100px;font-size:12px;text-align:center;" class="ui-state-default ui-corner-all">'.BUTTON_SELECT_CATEGORY.'</div></a>';
	$auction['category1_name'] = $EBAYAPI->get_ebay_category_name_from_favorites($auction['ebay_kategorie'],$EBAYAPI->get_site_id_from_name($auction['ebay_site']));

	$auction['input_category2'] = '<a style="padding:0px;" id="'.xtc_href_link('ebayapi_cart.php','action=quick_edit_category&nr=2&nolisting=1&id='.$id).'" href="javascript:;" class="lbOn" title="'.BUTTON_SELECT_CATEGORY.'"><div style="width:100px;font-size:12px;text-align:center;" class="ui-state-default ui-corner-all">'.BUTTON_SELECT_CATEGORY.'</div></a>';
	$auction['category2_name'] = $EBAYAPI->get_ebay_category_name_from_favorites($auction['ebay_kategorie2'],$EBAYAPI->get_site_id_from_name($auction['ebay_site']));

	if(is_array($shop_categories_array) && sizeOf($shop_categories_array)>0){
		$auction['input_shopcat1'] = '<a style="padding:0px;" id="'.xtc_href_link('ebayapi_cart.php','action=quick_edit_shopcategory&nr=1&nolisting=1&id='.$id).'" href="javascript:;" class="lbOn" title="'.BUTTON_SELECT_CATEGORY.'"><div style="width:100px;font-size:12px;text-align:center;" class="ui-state-default ui-corner-all">'.BUTTON_SELECT_CATEGORY.'</div></a>';
		$auction['shopcat1_name'] = $auction['ebay_shopcat_name'];
		//$auction['input_shopcat1'] = xtc_draw_pull_down_menu('shopcat1['.$zaehler.']',$shop_categories_array,$auction['ebay_shopcat']);
	}else{
		$auction['input_shopcat1'] = $shop_categories_array; // IN DEM FALL DER ERRORSTRING
	}
	if(is_array($shop_categories_array) and sizeOf($shop_categories_array)>0){
		$auction['input_shopcat2'] = '<a style="padding:0px;" id="'.xtc_href_link('ebayapi_cart.php','action=quick_edit_shopcategory&nr=2&nolisting=1&id='.$id).'" href="javascript:;" class="lbOn" title="'.BUTTON_SELECT_CATEGORY.'"><div style="width:100px;font-size:12px;text-align:center;" class="ui-state-default ui-corner-all">'.BUTTON_SELECT_CATEGORY.'</div></a>';
		$auction['shopcat2_name'] = $auction['ebay_shopcat2_name'];
		//$auction['input_shopcat2'] = xtc_draw_pull_down_menu('shopcat2['.$zaehler.']',$shop_categories_array,$auction['ebay_shopcat2']);
	}else{
		$auction['input_shopcat2'] = $shop_categories_array; // IN DEM FALL DER ERRORSTRING
	}

	$auction['input_user'] = xtc_draw_pull_down_menu('ebay_user['.$zaehler.']',$ebay_users,$auction['ebay_user']);

	// BEZAHLARTEN
	$payments = array();
	$payment_methods = $EBAYAPI->get_payments('ebay_products_payments','ebay_products_id',$id);
        $payment_codes = xtc_get_available_ebay_payments($auction['ebay_kategorie']);

	foreach($payment_codes as $k=>$pc){
		$saved = false;
		for($pi=0;$pi<sizeOf($payment_methods);$pi++){
			if($payment_methods[$pi] == $pc['id'])
				$saved = true;
		}
		$payments[] = array('nr'=>$k,'input'=>xtc_draw_checkbox_field('payment['.$zaehler.'][]',$pc['id'],$saved),'text'=>$pc['id'],'checked'=>$saved);
	}
	$auction['payments'] = $payments;

	// ITEMSPECIFICS
	$auction['input_itemspecifics'] = $EBAYAPI->draw_itemspecifics_select('ebay_product', $id, $zaehler);

	// ITEMCONDITIONS
	$auction['itemcondition_link'] = xtc_href_link('ebayapi_cart.php','action=quick_edit_itemcondition&id='.$id);

/*
    $collies = xtc_get_product_collies($data['products_id']);
    
	if(sizeOf($collies)>0){
		$auction['set_select'] = xtc_draw_radio_field('select_set['.$zaehler.']','0',(($data['select_set']==1) ? false : true )).' nein '.xtc_draw_radio_field('select_set['.$zaehler.']','1',(($data['select_set']==0) ? false : true )).' ja ';
		foreach($collies as $k=>$collie){
			$auction['set_select_products'][] = array(
				'qty'=>$collie['quantity'],
				'pID'=>$collie['collie_products_id'],
				'name'=>xtc_get_products_name($collie['collie_products_id'])
			);
        	}
		$select_set_multiple_array = array(0=>array('id'=>'','text'=>TEXT_SET_MULTIPLE_CHOICE_NO_VALUE));
		for($i=0;$i<sizeOf($collies);$i++){
			if($i>=1)
				$select_set_multiple_array[] = array('id'=>($i+1),'text'=>($i+1));
		}
		$auction['set_select_multiple'] = xtc_draw_pull_down_menu('select_set_multiple['.$zaehler.']',$select_set_multiple_array,$data['select_set_multiple']);
	}
	*/
        $auction['input_returnswithincode'] = yes_cfg_pull_down_ebay_returnswithincodes($data['returnswithincode'],'returnswithincode['.$zaehler.']');
        $auction['input_shippingcostpaidby'] = yes_cfg_pull_down_ebay_shippingcostpaidbycodes($data['shippingcostpaidby'], 'shippingcostpaidby['.$zaehler.']');
	$auction['input_ean'] = xtc_draw_input_field('ean['.$zaehler.']',$data['ean'],'maxlength="16" size="16"');
	$auction['input_isbn'] = xtc_draw_input_field('isbn['.$zaehler.']',$data['isbn'],'maxlength="16" size="16"');
	$auction['input_ebay_plus'] = xtc_draw_pull_down_menu('ebay_plus['.$zaehler.']',array(0=>array('id'=>0,'text'=>NO),1=>array('id'=>1,'text'=>YES)),$data['ebay_plus']);
	$auction['input_seller_profile_shipping_id'] = $EBAYAPI->draw_seller_profile_select('shipping','seller_profile_shipping_id['.$zaehler.']',$data['seller_profile_shipping_id']);
	$auction['input_seller_profile_payment_id'] = $EBAYAPI->draw_seller_profile_select('payment','seller_profile_payment_id['.$zaehler.']',$data['seller_profile_payment_id']);
	$auction['input_seller_profile_return_policy_id'] = $EBAYAPI->draw_seller_profile_select('return_policy','seller_profile_return_policy_id['.$zaehler.']',$data['seller_profile_return_policy_id']);
        $auction['input_productreferenceid'] = xtc_draw_input_field('ProductReferenceID['.$zaehler.']',$data['ProductReferenceID'],'maxlength="64" size="42"');
        $default_date = ($auction['scheduletime'] != '' and $auction['scheduletime'] != '0000-00-00 00:00:00') ? date('Y-m-d',strtotime($auction['scheduletime'])) : '';
        $default_time = ($auction['scheduletime'] != '' and $auction['scheduletime'] != '0000-00-00 00:00:00') ? date('H:i:s',strtotime($auction['scheduletime'])) : '00:00:00';             
        $auction['input_scheduletime'] = xtc_draw_input_field('scheduletime', $default_date, 'size="19" maxlength="19"',false,'date').'&nbsp;<font size="4">&#128337</font>&nbsp;'.xtc_draw_input_field('scheduletime_time',$default_time,'maxlength="8" size="8"');
        
        $auction['regulatory_documents'] = \YES4Trade\Model\ebay_products_regulatory_documents::get_documents_with_ebay_media_details($id,$seller);
        
        $auction['videos'] = \YES4Trade\Model\ebay_products_videos::get_by_ebay_products_id($id);
        
        $MA = new eBayMediaApi($seller, $access_token, $env);
        $marketplace_id = $EBAYAPI->get_sdk_sitecode_from_site($auction['ebay_site']);
        $haz_data = $MA->get_hazardous_materials_labels($marketplace_id);
        
        $eprh = \YES4Trade\Model\ebay_products_regulatory_hazmats::get_by_ebay_products_id($id);
        $default_signalWord = '';
        $default_statements = [];
        $default_pictograms = [];
        if($eprh !== null){
            $default_signalWord = $eprh->signalword;
            $default_statements = explode(',',$eprh->statements);
            $default_pictograms = explode(',',$eprh->pictograms);
        }
        $signalWords = [[
            'id'=>'','text'=>TEXT_SELECT
        ]];
        foreach($haz_data['signalWords'] as $sw){
            $signalWords[] = [
                'id'=>$sw['signalWordId'],
                'text'=>$sw['signalWordDescription']
            ];
        }
        $statements = [];
        foreach($haz_data['statements'] as $sttm){
            $statements[] = [
                'id'=>$sttm['statementId'],
                'text'=>$sttm['statementDescription']
            ];
        }
        $pictograms = [];
        foreach($haz_data['pictograms'] as $pt){
            $pictograms[] = [
                'id'=>$pt['pictogramId'],
                'text'=>$pt['pictogramDescription'],
                'url'=>$pt['pictogramUrl']
            ];
        }
        
        $products_safety_data = $MA->getProductSafetyLabels($marketplace_id);
        $saved_safety = \YES4Trade\Model\ebay_products_productsafety::get_by_ebay_products_id($id);
        $saved_safety_pictograms = [];
        $saved_safety_statements = [];
        if($saved_safety != null){
            $saved_safety_pictograms = explode(',',$saved_safety->pictograms);
            $saved_safety_statements = explode(',',$saved_safety->statements);
        }
                
        
        $safety_pictograms = [];
        foreach($products_safety_data['pictograms'] as $pt){
            $safety_pictograms[] = [
                'id'=>$pt['pictogramId'],
                'text'=>$pt['pictogramDescription'],
                'url'=>$pt['pictogramUrl']
            ];
        }
        $auction['safety_pictograms'] = $safety_pictograms;
        
        $safety_statements = [];
        foreach($products_safety_data['statements'] as $sttm){
            $safety_statements[] = [
                'id'=>$sttm['statementId'],
                'text'=>$sttm['statementDescription']
            ];
        }
        $auction['safety_statements'] = $safety_statements;
        
        $adressf = [
            'manufacturer_companyname',
            'manufacturer_street1',
            'manufacturer_street2',
            'manufacturer_stateorprovince',
            'manufacturer_postalcode',
            'manufacturer_cityname',
            'manufacturer_country',
            'manufacturer_email',
            'manufacturer_phone',
        ];
        $epm = \YES4Trade\Model\ebay_products_manufacturer::get_by_ebay_products_id($id);
        foreach($adressf as $a){
            $epm_value = ($epm !== null)?$epm->$a : '';
            $auction['input'][$a] = xtc_draw_input_field($a, $epm_value);
        }
        
        $marr = xtc_array_merge([['id'=>'','text'=>TEXT_SELECT]],xtc_get_manufacturers());
        $auction['manufacturer_selectbox'] = xtc_draw_pull_down_menu(
                'manufacturer_address_select', $marr
        );
        
        
        $auction['input']['signalWords'] = xtc_draw_pull_down_menu('signalWord',$signalWords,$default_signalWord);
        $auction['statements'] = $statements;
        $auction['default_statements'] = $default_statements;

        $auction['saved_safety_pictograms'] = $saved_safety_pictograms;
        $auction['saved_safety_statements'] = $saved_safety_statements;

        
        $auction['pictograms'] = $pictograms;
        $auction['default_pictograms'] = $default_pictograms;
        if($auction['ebay_kategorie'] > 0){
            $cats = [$auction['ebay_kategorie']];
            if($auction['ebay_kategorie2']>0){
                $cats[] = $auction['ebay_kategorie2'];
            }
            $regulatory_policies = $MA->get_regulatory_policies($cats, $marketplace_id);
            $policy_usages = [
                'OPTIONAL'=>'Optional',
                'RECOMMENDED'=>'Empfohlen',
                'REQUIRED'=>'Pflichtfeld'
            ];
            $policy_types = [
                'HAZMAT'=>'Gefahrgut Kennzeichnen',
                'ENERGY_EFFICIENCY'=>'Energieeffizienz Angaben',
                'MANUFACTURER_CONTACT'=>'Hersteller Kontaktdaten für Rückfragen',
                'PRODUCT_SAFETY'=>'Produktsicherheit'
            ];
            $reg_info = '<span style="font-size: 1.1em;font-weight: bold;">Vorgaben für die Verwendung von Sicherheitshinweisen/Infos</span><br />';
            $show_reginfo = false;
            foreach($regulatory_policies['regulatoryPolicies'] as $rp){
                if(isset($rp['supportedAttributes']) and sizeOf($rp['supportedAttributes'])){
                    $show_reginfo = true;
                    $suppstr = [];
                    foreach($rp['supportedAttributes'] as $satt){
                        $suppstr[] = $policy_types[$satt['name']].': <span style="color: darkgreen;">'.$policy_usages[$satt['usage']].'</span>';
                    }
                    $reg_info .= sprintf('<b>%s eBay Kategorie:</b> %s<br />',
                            ($rp['categoryId']==$auction['ebay_kategorie'])?'1.':'2.',
                            implode(', ',$suppstr)
                    );
                }
            }
            if($show_reginfo){
                $auction['regulatory_policies_info'] = $reg_info;
            }
        }
        $epee = \YES4Trade\Model\ebay_products_energy_efficiency::get_by_ebay_products_id($id);
	$energy_efficiency_image_description = ($epee != null) ? $epee->energy_efficiency_image_description : '';
        $auction['input']['energy_efficiency_image_description'] = xtc_draw_input_field('energy_efficiency_image_description',$energy_efficiency_image_description,'size="60"');
	$auction['energy_efficiency_label'] = ($epee != null) ? xtc_image($epee->energy_efficiency_image_url,'Energie Effizienz Label',50) : '';
        $auction['input']['energy_efficiency_image_url'] = xtc_draw_file_field('energy_efficiency_image');
	$auction['energy_efficiency_ProductInformationsheet'] = ($epee != null) ? xtc_image($epee->energy_efficiency_ProductInformationsheet,'Info Dokument',50) : '';
        $auction['input']['energy_efficiency_ProductInformationsheet']  = xtc_draw_file_field('energy_efficiency_ProductInformationsheet');

        $rps = \YES4Trade\Model\ebay_products_responsible_persons::get_by_ebay_products_id($id);
        $auction['responsible_persons'] = $rps;
        foreach($adressf as $af){
            $inf = str_replace('manufacturer','rp',$af);
            $inf_value = '';
            $auction['input'][$inf] = xtc_draw_input_field($inf, $inf_value);
        }
        
	$zaehler++;
	$auctions[] = $auction;
$smarty->assign('auctions',$auctions);
$smarty->assign('EBAY_SITES_ARRAY',$ebay_sites);	
$smarty->assign('AUCTION_PAYMENTMETHODS_ARRAY',$payment_codes);
$smarty->assign('AUCTION_TYPES_ARRAY',$_YES_auction_types);	
$smarty->assign('AUCTION_DURATIONS_ARRAY',$auction_durations);	
$smarty->assign('AUCTION_COUNTER_ARRAY',$_YES_auction_counter);
$smarty->assign('AUCTION_TEMPLATES_ARRAY',$auction_templates);
$smarty->assign('AUCTION_BOOL_ARRAY',$bool_array);
$smarty->assign('TINYMCE_VERSION',TINYMCE_VERSION);


if(EBAY_PRODUCTS_HISTORY == 1){
	$history_sql_query = xtc_db_query("SELECT * FROM ebay_products_history WHERE ebay_products_id='".$data['id']."' ORDER BY date_saved DESC");
	while($history = xtc_db_fetch_array($history_sql_query)){
		$history['editor'] = xtc_get_editor_name($history['editor_id']);
		$hist[] = xtc_db_prepare_input($history);
	}
	$smarty->assign('HISTORY','1');
	$smarty->assign('history_array',$hist);
}

$html = $smarty->fetch('ebay_products_edit.html');
echo $html;
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
