<?php
include('includes/application_top.php');
require_once('includes/classes/class.csv.php');
require_once('includes/classes/class.ebay.php');
require_once('includes/classes/class.ebay_item.php');
require_once('includes/classes/class.storagequantity.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');

$EBAYAPI = new ebayApi;
$delimiter = "\t";

// BOF PROPERTIES
$sep_properties = '^';
$sep_property = '#';
$sep_property_lang = '-_-';
$sep_property_values = '_-_';
$sep_property_values_item = '|';
// EOF PROPERTIES

$line_end = "\r\n";
function msort($original,$field, $descending = false){
            $sortArr = array();
           
            foreach ( $original as $key => $value )
            {
		    $sortArr[ $key ] = $value[ $field ];
            }
   
            if ( $descending )
            {
                arsort( $sortArr );
            }
            else
            {
                asort( $sortArr );
            }
           
            $resultArr = array();
            foreach ( $sortArr as $key => $value )
            {
                $resultArr[ $key ] = $original[ $key ];
            }
       
            return $resultArr;
}            

function prepare_string($value){
	$value = str_replace("\t"," ",$value);
	$value = str_replace('"','""',$value);
	return '"'.xtc_db_prepare_input($value).'"';
}

function get_field_from_id($id){
	global $field_array;
	$c = 0;
	foreach($field_array as $k=>$v){
		if($c == $id)
			return $k;
		$c++;
	}
}
function display_import_field($key,$value) {
	switch($key){
		case 'ebay_titel':
		case 'ebay_untertitel':
		case 'ebay_beschreibung':
		case 'ebay_paymentinstructions':
		case 'ebay_kategorie_merkmale':
		case 'ebay_kategorie2_merkmale':
		case 'ebay_paymentinstructions':
			$value = strip_tags($value);
			if(strlen($value)>40){
				$value = substr($value,0,40).'...';
			}
			break;
		case 'properties':
		    if(strlen($value)>40){
			    $value = substr($value,0,40).'...';
		    }
		    break;
	}
	return $value;
}
$sort=0;
$field_array = array(
'id'=>array('text'=>'Sammlerprodukt-ID (nicht �ndern)','sort_order'=>$sort++),
'products_id'=>array('text'=>'pID (nicht �ndern)','sort_order'=>$sort++),
'ean'=>array('text'=>'EAN (nicht �ndern)','sort_order'=>$sort++),
'v1'=>array('text'=>'V1 (nicht �ndern)','sort_order'=>$sort++),
'in_auction'=>array('text'=>'In Auktion (nicht �ndern)','sort_order'=>$sort++),
'ebay_sammler_id'=>array('text'=>'Sammler-Nummer','sort_order'=>$sort++),
'ebay_user'=>array('text'=>'Ebay Seller','sort_order'=>$sort++),
'ebay_site'=>array('text'=>'Ebay Seite (zB Germany)','sort_order'=>$sort++),
'ebay_titel'=>array('text'=>'Auktionstitel (max 55 Zeichen)','sort_order'=>$sort++),
'ebay_untertitel'=>array('text'=>'Untertitel (max 55 Zeichen)','sort_order'=>$sort++),
'ebay_beschreibung'=>array('text'=>'Beschreibung','sort_order'=>$sort++),
'ebay_preis'=>array('text'=>'Startpreis Auktion/Festpreis (Format: 0,00)','sort_order'=>$sort++),
'ebay_sofortkauf_preis'=>array('text'=>'Sofortkaufpreis (Nur bei Auktion, Format: 0,00)','sort_order'=>$sort++),
'ebay_bestoffer'=>array('text'=>'Preisvorschlag akzeptieren (0 oder 1)','sort_order'=>$sort++),
'ebay_bestoffer_price'=>array('text'=>'Preisvorschlag ablehnen bis Preis (Format: 0,00)','sort_order'=>$sort++),
'ebay_bestofferautoacceptprice'=>array('text'=>'Preisvorschlaege autom. akzeptieren ab (Format: 0,00)','sort_order'=>$sort++),
'ebay_auktionsdauer'=>array('text'=>'Auktionsdauer in Tagen','sort_order'=>$sort++),
'ebay_menge'=>array('text'=>'Anzahl','sort_order'=>$sort++),
'ebay_kategorie'=>array('text'=>'1. Ebaykategorie','sort_order'=>$sort++),
'ebay_kategorie_merkmale'=>array('text'=>'1. Ebaykategorie Merkmale','sort_order'=>$sort++),
'ebay_kategorie2'=>array('text'=>'2. Ebaykategorie','sort_order'=>$sort++),
'ebay_kategorie2_merkmale'=>array('text'=>'2. Ebaykategorie Merkmale','sort_order'=>$sort++),
'ebay_shopcat'=>array('text'=>'Ebayshop Kategorienummer','sort_order'=>$sort++),
'ebay_shopcat_name'=>array('text'=>'Ebayshop Kategoriename','sort_order'=>$sort++),
'ebay_shopcat2'=>array('text'=>'2. Ebayshop Kategorienummer','sort_order'=>$sort++),
'ebay_shopcat2_name'=>array('text'=>'2. Ebayshop Kategoriename','sort_order'=>$sort++),
'ebay_angebotsformat'=>array('text'=>'Format (Chinese, Dutch, FixedPriceItem oder StoresFixedPrice)','sort_order'=>$sort++),
'ebay_bild'=>array('text'=>'Galeriebild','sort_order'=>$sort++),
'ebay_sofortneu'=>array('text'=>'Sofort+Neu (0 oder 1)','sort_order'=>$sort++),
'ebay_vat'=>array('text'=>'MwSt ausweisen (0 oder 1)','sort_order'=>$sort++),
'ebay_geldzurueck'=>array('text'=>'Geld Zur�ck (0 oder 1)','sort_order'=>$sort++),
'ebay_gallery'=>array('text'=>'Galerie','sort_order'=>$sort++),
'ebay_gallery_plus'=>array('text'=>'Galerie Plus','sort_order'=>$sort++),
'ebay_galleryfeatured'=>array('text'=>'Premium Angebot (0 oder 1)','sort_order'=>$sort++),
'ebay_galleryfeaturedduration'=>array('text'=>'Premium Angebot Dauer in Tagen','sort_order'=>$sort++),
'ebay_counter'=>array('text'=>'Counter Typ (zb HonestyStyle)','sort_order'=>$sort++),
'ebay_ort'=>array('text'=>'Verk�ufer Ort','sort_order'=>$sort++),
'ebay_land'=>array('text'=>'Verk�ufer Land','sort_order'=>$sort++),
'ebay_postalcode'=>array('text'=>'Verk�ufer Postleitzahl','sort_order'=>$sort++),
'ebay_dispatchtimemax'=>array('text'=>'Bearbeitungszeit in Tagen','sort_order'=>$sort++),
'ebay_template'=>array('text'=>'Template','sort_order'=>$sort++),
'select_set'=>array('text'=>'Auswahlset anbieten (nur bei Stklistenartikeln; 0 oder 1)','sort_order'=>$sort++),
'select_set_multiple'=>array('text'=>'Mehrfachauswahlset Anzahl (0 fuer keine Mehrfachauswahl)','sort_order'=>$sort++),
'ebay_paymentinstructions'=>array('text'=>'Zahl-/Versandhinweise','sort_order'=>$sort++),
'ebay_revise'=>array('text'=>'Autom. Erhoehen nach Abverkauf','sort_order'=>$sort++),
'ebay_revise_option'=>array('text'=>'Autom. Erhoehen bis Bestand','sort_order'=>$sort++),
'payments'=>array('text'=>'Bezahlarten getrennt durch Semikolon','sort_order'=>$sort++),
'shipping_national1'=>array('text'=>'Versandart 1 national (Format: DE_InsuredDispatch;4.00;2.00;2)','sort_order'=>$sort++),
'shipping_national2'=>array('text'=>'Versandart 2 national','sort_order'=>$sort++),
'shipping_national3'=>array('text'=>'Versandart 3 national','sort_order'=>$sort++),
'shipping_international1'=>array('text'=>'Versandart 1 international (Format: DE_VersicherterVersandInternational;4.00;2.00;EuropeanUnion,Africa,LatinAmerica)','sort_order'=>$sort++),
'shipping_international2'=>array('text'=>'Versandart 2 international','sort_order'=>$sort++),
'shipping_international3'=>array('text'=>'Versandart 3 international','sort_order'=>$sort++),
'ebay_template_excludes'=>array('text'=>'Nicht verwendete Bilder - getrennt durch Semikolon','sort_order'=>$sort++),
'itemspecifics'=>array('text'=>'Eigene Produktmerkmale','sort_order'=>$sort++),
'itemspecifics_recommendations'=>array('text'=>'eBay Produktmerkmale','sort_order'=>$sort++),
'properties'=>array('text'=>'Artikeleigenschaften','sort_order'=>$sort++),
'itemcondition'=>array('text'=>'Artikelzustand','sort_order'=>$sort++),
'ebay_external_product_id'=>array('text'=>'Externe Art-Nr: ISBN/ISBN 13','sort_order'=>$sort++),
'ebay_external_product_id_type'=>array('text'=>'Externe Art-Nr Typ','sort_order'=>$sort++),
'ShippingDiscountProfileID'=>array('text'=>'Inland Versand Profil-ID','sort_order'=>$sort++),
'InternationalShippingDiscountProfileID'=>array('text'=>'International Versand Profil-ID','sort_order'=>$sort++),
'reserveprice'=>array('text'=>'Mindestpreis Auktion','sort_order'=>$sort++),
'returnswithincode'=>array('text'=>TEXT_EBAY_RETURNSWITHINCODE,'sort_order'=>$sort++),
'shippingcostpaidby'=>array('text'=>TEXT_EBAY_SHIPPINGCOSTPAIDBY,'sort_order'=>$sort++),
'ebay_plus'=>array('text'=>'eBay Plus','sort_order'=>$sort++),
'seller_profile_payment_id'=>array('text'=>TEXT_EBAY_SELLER_PROFILE_PAYMENT_ID,'sort_order'=>$sort++),
'seller_profile_return_policy_id'=>array('text'=>TEXT_EBAY_SELLER_PROFILE_RETURN_POLICY_ID,'sort_order'=>$sort++),
'seller_profile_shipping_id'=>array('text'=>TEXT_EBAY_SELLER_PROFILE_SHIPPING_ID,'sort_order'=>$sort++),
);


$target_path = \main::get_exportdata_path().'0000IMPORTEBAYPRODUCTS.csv';

$price_format_array = array(
	'ebay_preis','ebay_sofortkauf_preis','ebay_bestoffer_price','ebay_bestofferautoacceptprice'
);
if (isset($_FILES['importfile'])){
	if ($_FILES["importfile"]["error"] > 0){
		$messageStack->add_session('Der Importvorgang war fehlerhaft.','error');
		xtc_redirect(xtc_href_link('export_ebay_products.php'));
	}
	if(file_exists($target_path))
		unlink($target_path);
	if (move_uploaded_file($_FILES['importfile']['tmp_name'], $target_path)) {
		$step = 2;
	}else{
		$messageStack->add_session('Importdatei konnte nicht gespeichert werden.','error');
		xtc_redirect(xtc_href_link('export_ebay_products.php'));
	}
} 
$e = new ebay_item;
if(isset($_GET['action']) and $_GET['action'] == 'import_process'){
	$CSV = new CSVfile($target_path);
	$CSV->delimiter = $delimiter;
	$CSV->open('r');
	$row = 0;
	$csv_data = array();
	while($line = $CSV->readRow()){
		if($row > 0)
			$csv_data[] = $line;
		$row++;
	}
	if(sizeOf($csv_data)>0){
		foreach($csv_data as $k=>$line){
			$epID = $line[0];
			xtc_db_query( "DELETE FROM ebay_products_payments WHERE ebay_products_id='".$epID."'" );
			xtc_db_query( "DELETE FROM ebay_products_itemspecifics WHERE ebay_products_id='".$epID."'" );
			xtc_db_query( "DELETE FROM ebay_products_itemspecifics_recommendations WHERE ebay_products_id='".$epID."'" );
			
			// bof properties
			$e->remove_properties('ebay_products', $epID);
			// eof properties
			
			$shiploc_query = xtc_db_query( "SELECT ebay_products_shippings_id FROM ebay_products_shippings WHERE ebay_products_id='".$epID."'" );
			while($shiploc = xtc_db_fetch_array($shiploc_query)){
				xtc_db_query("DELETE FROM ebay_products_shippings_locations WHERE ebay_products_shippings_id='".$shiploc['ebay_products_shippings_id']."'");
			}
			xtc_db_query("DELETE FROM ebay_products_shippings WHERE ebay_products_id='".$epID."'");
			xtc_db_query("DELETE FROM ebay_template_excludes WHERE ebay_products_id='".$epID."'");
			xtc_db_query("DELETE FROM ebay_products_characteristics WHERE ebay_products_id='".$epID."'");
			foreach($line as $key=>$data){
				$field = get_field_from_id($key);
				switch($field){
					case 'ebay_template_excludes':
						$excludes = explode(';',$data);
						for($exi=0;$exi<sizeOf($excludes);$exi++){
							$insert_sql_array = array(
								'ebay_products_id'=>$epID,
								'pic'=>$excludes[$exi]
							);
							xtc_db_perform('ebay_template_excludes',$insert_sql_array);
						}
						break;
					case 'ebay_kategorie_merkmale':
					case 'ebay_kategorie2_merkmale':
						$category_number = ($field == 'ebay_kategorie_merkmale') ? 1 : 2;
						$characteristics = array();
						$characteristics_data_array = explode('&',$data);
						if( sizeOf($characteristics_data_array)>1){
							foreach($characteristics_data_array as $ckey=>$cdata){
								$characteristics_array = explode('|',$cdata);
								$insert_sql_array = array(
									'ebay_products_id'=>$epID,
									'category_number'=>$category_number,
									'attribute_set_id'=>$characteristics_array[0],
									'attribute_type'=>$characteristics_array[1],
									'attribute_id'=>$characteristics_array[2],
									'attribute_value'=>$characteristics_array[3]
								);
								xtc_db_perform('ebay_products_characteristics',$insert_sql_array);
							}
						}
						break;
					case 'payments':
						$payments = array();
						$payments_array = explode(';',$data);
						for($p=0;$p<sizeOf($payments_array);$p++){ // doppelte killen
							$payments[ $payments_array[$p] ] = true;
						}
						if( sizeOf($payments)>0){
							foreach($payments as $payment=>$pv){
								$insert_sql_array = array(
									'payment'=>$payment,
									'ebay_products_id'=>$epID
								);
								xtc_db_perform('ebay_products_payments',$insert_sql_array);
							}
						}
						break;
					case 'itemspecifics':
						$item_specifics = array();
						$specifics_array = explode(';',$data);
						for($s=0;$s<sizeOf($specifics_array);$s++){ // doppelte killen
							$is_values = explode('=',$specifics_array[$s]);
							if(xtc_not_null($is_values[0]) and xtc_not_null($is_values[1])){
								$insert_sql_array = array(
									'is_name'=>$is_values[0],
									'is_value'=>$is_values[1],
									'ebay_products_id'=>$epID
								);
								xtc_db_perform('ebay_products_itemspecifics',$insert_sql_array);
							}
						}
						break;
					case 'itemspecifics_recommendations':
						$item_specifics_recommendations = array();
						$specifics_array = explode(';',$data);
						for($s=0;$s<sizeOf($specifics_array);$s++){ // doppelte killen
							$is_values = explode('=',$specifics_array[$s]);
							if(xtc_not_null($is_values[0]) and xtc_not_null($is_values[1])){
								$insert_sql_array = array(
									'is_name'=>$is_values[0],
									'is_value'=>$is_values[1],
									'ebay_products_id'=>$epID
								);
								xtc_db_perform('ebay_products_itemspecifics_recommendations',$insert_sql_array);
							}
						}
						break;
					case 'properties':
					    if($data != ''){
						$properties_lang_array = explode($sep_properties,$data);
						$sort_order = 0;
						$properties_id_array = array();
						$properties_values_id_array = array();
						foreach($properties_lang_array as $lang_properties){
						    $sort_order_property_value = 0;
						    $properties_array = explode($sep_property,$lang_properties);
						    foreach($properties_array as $pk=>$property){
							$property_array = explode($sep_property_lang,$property);
							$plang_id = $property_array[2];
							if(!isset($properties_id_array[$pk])){
							    $sql_insert_array = array(
								'ebay_products_id'=>$epID,
								'date_added'=>'now()',
								'sort_order'=>$sort_order
							    );
							    xtc_db_perform('ebay_products_properties',$sql_insert_array);
							    $properties_id_array[ $pk ] = xtc_db_insert_id();
							}
							$sort_order++;
							$sql_insert_array = array(
							    'ebay_products_properties_id'=>$properties_id_array[ $pk ],
							    'language_id'=>$plang_id,
							    'title'=>$property_array[0]
							);
							xtc_db_perform('ebay_products_properties_description',$sql_insert_array);
							$property_values_array = explode($sep_property_values,$property_array[1]);
							foreach($property_values_array as $pvk=>$property_value){
							    $property_value_array = explode($sep_property_values_item,$property_value);
							    $image = (isset($property_value_array[2]))? $property_value_array[2] : '';
							    $files_image = (isset($property_value_array[3]))? $property_value_array[3] : '';
							    if( !isset($properties_values_id_array[ $properties_id_array[ $pk ] ][$pvk] ) ){
								$sql_insert_array = array(
								    'ebay_products_properties_id'=>$properties_id_array[ $pk ],
								    'price'=>$property_value_array[0],
								    'image'=>$image,
								    'files_image'=>$files_image,
								    'sort_order'=>$sort_order_property_value
								);
								xtc_db_perform('ebay_products_properties_values',$sql_insert_array);
								$properties_values_id_array[ $properties_id_array[ $pk ] ][$pvk] = xtc_db_insert_id();
							    }
							    $sort_order_property_value++;
							    $sql_insert_array = array(
								'ebay_products_properties_values_id'=>$properties_values_id_array[ $properties_id_array[ $pk ] ][$pvk],
								'title'=>$property_value_array[1],
								'language_id'=>$plang_id
							    );
							    xtc_db_perform('ebay_products_properties_values_description',$sql_insert_array);
							} // end foreach properties_values
						    } // end foreach properties
						} // end foreach properties_lang
					    } // end if data != ''
					    break;
					case 'shipping_national1':
					case 'shipping_national2':
					case 'shipping_national3':
						$shipping_array = explode(';',$data);
						if(is_array($shipping_array) and $shipping_array[0] != ''){
							$insert_sql_array = array(
								'ebay_products_id'=>$epID,
								'shippingtype'=>'national',
								'ShippingService'=>$shipping_array[0],
								'ShippingServiceAdditionalCost'=>$shipping_array[2],
								'ShippingServiceCost'=>$shipping_array[1],
								'shipsWithinDays'=>$shipping_array[3]
							);
							xtc_db_perform('ebay_products_shippings',$insert_sql_array);
						}
						break;
					case 'shipping_international1':
					case 'shipping_international2':
					case 'shipping_international3':
						$shipping_array = explode(';',$data);
						if(is_array($shipping_array) and $shipping_array[0] != ''){
							$insert_sql_array = array(
								'ebay_products_id'=>$epID,
								'shippingtype'=>'international',
								'ShippingService'=>$shipping_array[0],
								'ShippingServiceAdditionalCost'=>$shipping_array[2],
								'ShippingServiceCost'=>$shipping_array[1],
							);
							xtc_db_perform('ebay_products_shippings',$insert_sql_array);
							$epsID = xtc_db_insert_id();
							$locations = array();
							$locations_array = explode(',',$shipping_array[3]);
							for($li=0;$li<sizeOf($locations_array);$li++){
								if($locations_array[$li] != '')
									$locations[$locations_array[$li]] = true;
							}
							if(sizeOf($locations)>0){
								foreach($locations as $location=>$lv){
									$insert_sql_array = array(
										'ebay_products_shippings_id'=>$epsID,
										'location'=>$location
									);
									xtc_db_perform('ebay_products_shippings_locations',$insert_sql_array);
								}
							}
						
						}
						break;
					case 'products_id':
					case 'ean':
					case 'id':
					case 'v1':
					case 'in_auction':
						// nix
						break;
					default:
						if($field != ''){
							if(in_array($field,$price_format_array))
								$data = str_replace(',','.',$data);
							$ebay_products_sql[$field] = $data;
						}
						break;
				}
			}
			xtc_db_perform('ebay_products',$ebay_products_sql,'update','id="'.$epID.'"');
			$insert_sql_array = array(
				'ebay_products_id'=>$epID,
				'date_saved'=>'now()',
				'comments'=>'CSV Import',
				'editor_id'=>$_SESSION['customer_id']
			);
			xtc_db_perform('ebay_products_history',$insert_sql_array);
		}
	}
	$messageStack->add_session('Sammlerprodukt Import fertiggestellt.','success');
	xtc_redirect(xtc_href_link('export_ebay_products.php'));
	exit;
}

if(isset($_GET['action']) and $_GET['action'] == 'export'){
    $languages = xtc_get_languages();
	$sammler_sql = '';
	if($_POST['sammler_id'] != ''){
		$sammler_sql = " WHERE ebay_sammler_id='".(int)$_POST['sammler_id']."' ";
	}
	$results_array = array();
	$cart_query = xtc_db_query("SELECT * FROM ebay_products $sammler_sql ORDER BY ebay_sammler_id");
	$results = xtc_db_num_rows($cart_query);
	while($cart = xtc_db_fetch_array($cart_query)){
		$result_array = array();
		$payment_str = '';
		$payment_query = xtc_db_query("SELECT payment FROM ebay_products_payments WHERE ebay_products_id='".$cart['id']."'");
		while($payment = xtc_db_fetch_array($payment_query)){
			$payment_str .= $payment['payment'].';';
		}
		$payment_str = substr($payment_str,0,(strlen($payment_str)-1));
		$result_array['payments'] = array('text'=>$payment_str,'sort_order'=>$field_array['payments']['sort_order']);

		$item_specifics = array();
		$EBAYAPI->get_itemspecifics('ebay_product',$cart['id'],$item_specifics,false);
		$item_specifics_string = '';
		if(is_array($item_specifics) and sizeOf($item_specifics)>0){
			foreach($item_specifics as $is=>$spec){
				// 16.05.10 -> utf8_encode
				$item_specifics_string .= implode('=',$spec).';';
			}
		}
		$item_specifics_string = substr($item_specifics_string,0,(strlen($item_specifics_string)-1));
		$result_array['itemspecifics'] = array('text'=>$item_specifics_string,'sort_order'=>$field_array['itemspecifics']['sort_order']);

		$item_specifics_recommendations = $EBAYAPI->get_itemspecifics_recommendations($cart['id']);
		$item_specifics_recommendations_string = '';
		if(is_array($item_specifics_recommendations) and sizeOf($item_specifics_recommendations)>0){
			foreach($item_specifics_recommendations as $is=>$spec){
				// 16.05.10 -> utf8_encode
				$item_specifics_recommendations_string .= implode('=',$spec).';';
			}
		}
		$item_specifics_recommendations_string = substr($item_specifics_recommendations_string,0,(strlen($item_specifics_recommendations_string)-1));
		$str = $item_specifics_recommendations_string;
		$result_array['itemspecifics_recommendations'] = array(
		    'text'=>prepare_string($str),
		    'sort_order'=>$field_array['itemspecifics_recommendations']['sort_order']
		);

		// BOF PROPERTIES
		$result_array['properties'] = array(
		    'text'=>'',
		    'sort_order'=>$field_array['properties']['sort_order']
		);
		$properties_array = array();
		foreach($languages as $lang){
		    $properties = $e->get_properties_from_id('ebay_products',$cart['id'],$lang['id']);
		    if(sizeOf($properties))
			$properties_array[ $lang['id'] ] = $properties;
		}
		if(sizeOf($properties_array)){
		    $properties_struct_array = array();
		    foreach($properties_array as $lang_id => $properties){
			$property_lang_struct_array = array();
			foreach($properties as $property){
			    $property['language_id'] = $lang_id;
			    unset($property['ebay_products_properties_id']);
			    $ppv = array();
			    foreach($property['properties_values'] as $ppv_data){
				unset($ppv_data['ebay_products_properties_values_id']);
				$ppv[] = implode($sep_property_values_item,$ppv_data);
			    }
			    $property['properties_values'] = implode($sep_property_values,$ppv);
			    $property_lang_struct_array[] = implode($sep_property_lang,$property);
			}
			$properties_struct_array[] = implode($sep_property,$property_lang_struct_array);
		    }
		    $result_array['properties'] = array('text'=>prepare_string(implode($sep_properties,$properties_struct_array)),'sort_order'=>$field_array['properties']['sort_order']);
		}
		// EOF PROPERTIES
		

		// TEMPLATE EXCLUDES
		$template_excludes = array();
		$exclude_query = xtc_db_query(sprintf("SELECT pic FROM ebay_template_excludes WHERE ebay_products_id='%s'",$cart['id']));
		while($exclude = xtc_db_fetch_array($exclude_query)){
			$template_excludes[] = $exclude['pic'];
		}
		$result_array['ebay_template_excludes'] = array('text'=>implode(';',$template_excludes),'sort_order'=>$field_array['ebay_template_excludes']['sort_order']);

		// CHARACTERISTICS
		$category_characteristics = '';
		$category2_characteristics = '';
		$characteristics = $EBAYAPI->get_characteristics($source = 'ebay_products_characteristics',$index = 'ebay_products_id',$source_id = $cart['id'] );
		if(sizeOf($characteristics)>0){
			foreach($characteristics as $ck=>$char){
				switch($char['category_number']){
					case '1':
						unset($char['category_number']);
						$category_characteristics .= implode('|',$char);
						$category_characteristics .= '&';
						break;
					case '2':
						unset($char['category_number']);
						$category2_characteristics .= implode('|',$char);
						$category2_characteristics .= '&';
						break;
				}
			}
			$category_characteristics = substr($category_characteristics,0,strlen($category_characteristics)-1);
			$category2_characteristics = substr($category2_characteristics,0,strlen($category2_characteristics)-1);
		}
		$result_array['ebay_kategorie_merkmale'] = array('text'=>$category_characteristics,'sort_order'=>$field_array['ebay_kategorie_merkmale']['sort_order']);
		$result_array['ebay_kategorie2_merkmale'] = array('text'=>$category2_characteristics,'sort_order'=>$field_array['ebay_kategorie2_merkmale']['sort_order']);

		$ship_national_ct = 1;
		$ship_national_query = xtc_db_query("SELECT ShippingService,ShippingServiceAdditionalCost,ShippingServiceCost,shipsWithinDays FROM ebay_products_shippings WHERE ebay_products_id='".$cart['id']."' and shippingtype='national' and ShippingService!=''");
		while($ship_national = xtc_db_fetch_array($ship_national_query)){
			$result_array['shipping_national'.$ship_national_ct] = array(
				'text'=>$ship_national['ShippingService'].';'.number_format($ship_national['ShippingServiceCost'],2,'.','').';'.number_format($ship_national['ShippingServiceAdditionalCost'],2,'.','').';'.$ship_national['shipsWithinDays'],
				'sort_order'=>$field_array['shipping_national'.$ship_national_ct]['sort_order']
			);
			$ship_national_ct++;
		}
		for($i=$ship_national_ct;$i<4;$i++){
			$result_array['shipping_national'.$i] = array(
				'text'=>'',
				'sort_order'=>$field_array['shipping_national'.$i]['sort_order']);
		}
		$ship_international_ct = 1;
		$ship_international_query = xtc_db_query("SELECT ebay_products_shippings_id,ShippingService,ShippingServiceAdditionalCost,ShippingServiceCost FROM ebay_products_shippings WHERE ebay_products_id='".$cart['id']."' and shippingtype='international' and ShippingService!=''");
		while($ship_international = xtc_db_fetch_array($ship_international_query)){
			$loc = '';
			$ship_loc_query = xtc_db_query("SELECT location FROM ebay_products_shippings_locations WHERE ebay_products_shippings_id='".$ship_international['ebay_products_shippings_id']."'");
			while($ship_loc = xtc_db_fetch_array($ship_loc_query)){
				$loc .= $ship_loc['location'].',';
			}
			$loc = substr($loc,0,(strlen($loc)-1));
			$result_array['shipping_international'.$ship_international_ct] = array(
				'text'=>$ship_international['ShippingService'].';'.number_format($ship_international['ShippingServiceCost'],2,'.','').';'.number_format($ship_international['ShippingServiceAdditionalCost'],2,'.','').';'.$loc,
				'sort_order'=>$field_array['shipping_international'.$ship_international_ct]['sort_order']
			);
			$ship_international_ct++;
		}
		for($i=$ship_international_ct;$i<4;$i++){
			$result_array['shipping_international'.$i] = array('text'=>'','sort_order'=>$field_array['shipping_international'.$i]['sort_order']);
		}
		foreach($cart as $k=>$v){
			if(isset($field_array[$k]) and xtc_not_null($field_array[$k])){
				if(in_array($k,$price_format_array))
					$v = prepare_string(number_format($v,2,',',''));
				else
					$v = prepare_string($v);
				$result_array[$k] = array('text'=>$v,'sort_order'=>$field_array[$k]['sort_order']);
			}
		}
		$product_record_query = xtc_db_query(sprintf(
			"SELECT products_ean FROM products WHERE products_id=%s",
			$cart['products_id']
		));
		$product_record = xtc_db_fetch_array($product_record_query);
		$result_array['ean'] = array('text'=>prepare_string($product_record['products_ean']),'sort_order'=>$field_array['ean']['sort_order']);
		$SQ = new products_quantity($cart['products_id']);
		$result_array['v1'] = array('text'=>$SQ->get_available1_qty(),'sort_order'=>$field_array['v1']['sort_order']);
		$result_array['in_auction'] = array('text'=>$SQ->get_auction_qty(),'sort_order'=>$field_array['in_auction']['sort_order']);
		
		$results_array[] = msort($result_array,'sort_order');
	}
	$CSV = '';
	foreach($field_array as $k=>$array){
		$CSV .= $array['text'].$delimiter;
	}
	$CSV .= $line_end;
	foreach($results_array as $k=>$array){
		foreach($array as $field=>$value) {
			$CSV .= $value['text'].$delimiter;
		}
		$CSV .= $line_end;
	}

	if($results){
		$basics = new basics;
		$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
		$filename = sprintf('sammlerprodukte_%s.csv',$crypt_file);
		$filepath = \main::get_exportdata_path();
		$basics->create_file($filepath.$filename,$CSV);
		$basics->zip_file($filepath,$filename,$filename.'.zip',true);

		$file_contents = $basics->read_file_content($filepath.$filename.'.zip',$mode='rb');
		unlink($filepath.$filename.'.zip');
		// send File to Browser
		$file = 'sammlerprodukte_'.date('Y-m-d_H_i_s').'.zip';
		header('Content-Type: application/octet-stream');
		header('Content-Transfer-Encoding: binary');
		header('Content-disposition: attachment; filename=' . $file);
		echo $file_contents;
		exit;
	}else{
		$messageStack->add_session('Es wurden keine Sammlerprodukte exportiert','error');
		xtc_redirect(xtc_href_link('export_ebay_products.php'));
	}
}
$smarty = new yesSmarty;
		
yes_draw_pre_header();
yes_draw_header(TITLE);
$buttons = array();
$smarty->assign(array(
	'HEADING_TITLE'=>HEADING_TITLE
));
$smarty->display('export_ebay_products.html');
?>
				<table border="0" width="100%" cellspacing="0" cellpadding="0">
				<tr>
					<td valign="top" width="100%" class="main">
<?php
if(!isset($step) or $step == 1){
	$sammler_array = array(0=>array('id'=>'','text'=>'Alle Sammler'));
	$sammler_array[] = array('id'=>'0','text'=>EBAY_SAMMLER_DEFAULT_TITEL);
	$sammler_query = xtc_db_query("SELECT id,titel FROM ebay_sammler ORDER BY titel");
	while($sammler = xtc_db_fetch_array($sammler_query)){
		$sammler_array[] = array('id'=>$sammler['id'],'text'=>xtc_db_prepare_input($sammler['titel']));
	}
?>
	<br /><br />
	<b>Exportieren Sie Ihre YES Sammlerprodukte als csv Datei.</b><br />
	Diese k&ouml;nnen Sie dann auf ihrem lokalem PC bearbeiten (zb Excel oder OpenOffice).<br>
	<form action="export_ebay_products.php?action=export" method="post">
	<?php echo xtc_draw_pull_down_menu('sammler_id',$sammler_array,@$_POST['sammler_id']);?>
	<input type="submit" class="ui-button ui-corner-all ui-state-default" value="<?php echo IMAGE_EXPORT; ?>" />
	</form><br />
	<br /><br /><br />
	<b>Importieren Sie die csv Datei von Ihrem lokalem PC</b><br />
	Die Sammlerprodukte in Ihrem YES System werden aktualisiert.<br />
	<form action="export_ebay_products.php?action=import" method="post" enctype="multipart/form-data">
	<input type="file" name="importfile" />
	<input type="submit" value="Importieren" class="ui-button ui-corner-all ui-state-default" />
	</form>
<?php
}else if($step == 2){
			$CSV = new CSVfile($target_path);
			$CSV->delimiter = $delimiter;
			$CSV->open('r');
			$row = 0;
			$csv_data = array();
			while($line = $CSV->readRow()){
				if($row > 0)
					$csv_data[] = $line;
				$row++;
			}
?>
					<p>Es wurden <?php echo sizeOf($csv_data);?> Datens&auml;tze importiert. Kontrollieren Sie nocheinmal die Daten.<br />Klicken Sie anschliessend auf "Speichern" um den Importvorgang abzuschliessen oder auf "Abbrechen" wenn Sie den Importvorgang abbrechen wollen.</p>
					<p><i>Hinweis: In der Historie zu den einzelnen Sammlerprodukten steht dann der Kommentar "CVS IMPORT", keine weiteren Details.<br><font color="red">Denken Sie daran, Falscheingaben in dieser Importdatei k&ouml;nnen zu Irritationen und Fehlern f&uuml;hren.</font></p>
					<table border="0" cellspacing="1" cellpadding="3">
					<tr>
						<td colspan="<?php echo sizeOf($field_array); ?>">
							<input type="button" value="<?php echo IMAGE_CANCEL; ?>" class="ui-button ui-corner-all ui-state-default" onclick="window.location.href='export_ebay_products.php';" />
							&nbsp;&nbsp;&nbsp;
							<input type="button" value="<?php echo IMAGE_SAVE; ?>" class="ui-button ui-corner-all ui-state-default" onclick="window.location.href='export_ebay_products.php?action=import_process';" />
						</td>
					</tr>
					<tr class="dataTableHeadingRow">
					<?php
					foreach($field_array as $k=>$v){
						echo '<td class="dataTableHeadingContent">'.$v['text'].'</td>';
					}
					?>
					</tr>
					<?php for($i=0;$i<sizeOf($csv_data);$i++){ ?>
					<tr class="dataTableRow">
					<?php
						foreach($csv_data[$i] as $k=>$v){
							echo '<td class="dataTableContent">'.display_import_field(get_field_from_id($k),$v).'&nbsp;</td>';
						}
					?>
					</tr>
					<?php } ?>
					<tr>
						<td colspan="<?php echo sizeOf($importheader); ?>">
							<input type="button" value="<?php echo IMAGE_CANCEL; ?>" class="ui-button ui-corner-all ui-state-default" onclick="window.location.href='export_ebay_products.php';" />
							&nbsp;&nbsp;&nbsp;
							<input type="button" value="<?php echo IMAGE_SAVE; ?>" class="ui-button ui-corner-all ui-state-default" onclick="window.location.href='export_ebay_products.php?action=import_process';" />
						</td>
					</tr>
					</table>



<?php
}
?>
					</td>
				</tr>
				</table>

<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
