<?php
namespace YES4Trade\Enums;

enum TUNNEL_CATEGORY: string
{

    case TUNNEL_CATEGORY_A = 'A';
    case TUNNEL_CATEGORY_B = 'B';
    case TUNNEL_CATEGORY_C = 'C';
    case TUNNEL_CATEGORY_D = 'D';
    case TUNNEL_CATEGORY_E = 'E';

    public function label(): string{
        return match($this) {
            self::TUNNEL_CATEGORY_A => constant('TUNNEL_CATEGORY_A'),
            self::TUNNEL_CATEGORY_B => constant('TUNNEL_CATEGORY_B'),
            self::TUNNEL_CATEGORY_C => constant('TUNNEL_CATEGORY_C'),
            self::TUNNEL_CATEGORY_D => constant('TUNNEL_CATEGORY_D'),
            self::TUNNEL_CATEGORY_E => constant('TUNNEL_CATEGORY_E'),
        };
    }
    
    public function title(): string{
        return match($this) {
            self::TUNNEL_CATEGORY_A => constant('TUNNEL_CATEGORY_A_TITLE'),
            self::TUNNEL_CATEGORY_B => constant('TUNNEL_CATEGORY_B_TITLE'),
            self::TUNNEL_CATEGORY_C => constant('TUNNEL_CATEGORY_C_TITLE'),
            self::TUNNEL_CATEGORY_D => constant('TUNNEL_CATEGORY_D_TITLE'),
            self::TUNNEL_CATEGORY_E => constant('TUNNEL_CATEGORY_E_TITLE'),
        };
    }
    
    public static function fromName(string $name): ?self
    {
        foreach (self::cases() as $case) {
            if ($case->name === $name) {
                return $case;
            }
        }
        return null;
    }

}
