<?php

namespace YES4Trade\Model;

class amazon_feeds_price_items extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'amazon_feeds_price_items';
    const TABLE_INDEX = 'amazon_feeds_price_items_id';

    private static $propertyTypes = [
        'amazon_feeds_price_items_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'amazon_feeds_price_items_id'
        ],
        'amazon_feeds_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'amazon_feeds_id'
        ],
        'price' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'price'
        ],
        'sku' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'sku'
        ],
        'processed' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'processed'
        ],
    ];


public function __construct(array $values = []) {
    list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
    parent::__construct($parentValues);
    if (!array_key_exists(__CLASS__, self::$properties)) {
        self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
    }
    if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
        self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
    }
    $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        yes_db_perform(self::TABLE_NAME, self::convert_values($data,self::$propertyTypes));
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        yes_db_perform(self::TABLE_NAME, self::convert_values($data,self::$propertyTypes),'update',[$index=>$this->$index]);
    }

    public static function delete(int $index) {
        yes_query(sprintf(
                "DELETE FROM %s WHERE %s=:id",
                self::TABLE_NAME,self::TABLE_INDEX
           ),['id'=>$index]
        );
    }


    public static function get_by_amazon_feeds_price_items_id(int $amazon_feeds_price_items_id) {
        $query = yes_query(sprintf(
                "SELECT * FROM %s WHERE %s=:id",
                   self::TABLE_NAME, self::TABLE_INDEX                ),['id'=>$amazon_feeds_price_items_id]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        return new self($record);
    }

    public static function get_by_amazon_feeds_id(int $amazon_feeds_id){
        $items = [];
        $query = yes_query(sprintf(
                "SELECT * FROM %s WHERE amazon_feeds_id=:id",
                    self::TABLE_NAME
                ),['id'=>$amazon_feeds_id]
        );
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }
    
    public static function get_by_amazon_feeds_id_and_sku(int $amazon_feeds_id, string $sku, array $select_fields = []){
        $items = [];
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
                "SELECT %s FROM %s WHERE amazon_feeds_id=:id AND sku=:sku",
                    $select_field_string,self::TABLE_NAME
                ),['id'=>$amazon_feeds_id,'sku'=>$sku]
        );
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }
    
    public static function get_by_sku_and_processed(string $sku, int $processed, array $select_fields = []){
        $items = [];
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
            "SELECT %s FROM %s WHERE sku=:sku AND processed=:processed",
                $select_field_string,self::TABLE_NAME
            ),['sku'=>$sku,'processed'=>$processed]
        );
        foreach($query as $record){
            $data = self::convert_values( $record,self::$propertyTypes );
            $items[] =  new self($data);
        }
        return $items;
    }
    
    public static function get_by_processed(int $processed, array $select_fields = []){
        $items = [];
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
            "SELECT %s FROM %s WHERE processed=:processed",
                $select_field_string,self::TABLE_NAME
            ),['processed'=>$processed]
        );
        foreach($query as $record){
            $data = self::convert_values( $record,self::$propertyTypes );
            $items[] =  new self($data);
        }
        return $items;
    }
}
