<?php
namespace YES4Trade\Model;

/**
 * Description of category
 *
 * @author mario
 */
class category  extends \YES4Trade\Model\BaseType {
    const TABLE_NAME = 'categories';
    const TABLE_INDEX = 'categories_id';
    
    private static $propertyTypes = [
        'categories_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_id'
        ],
        'categories_image' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_image'
        ],
        'parent_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'parent_id'
        ],
        'categories_status' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_status'
        ],
        'categories_template' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_template'
        ],
        'group_ids' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'group_ids'
        ],
        'listing_template' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'listing_template'
        ],
        'sort_order' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'sort_order'
        ],
        'products_sorting' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_sorting'
        ],
        'products_sorting2' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_sorting2'
        ],
        'date_added' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date_added'
        ],
        'last_modified' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'last_modified'
        ],
        'ebayapi_cart' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebayapi_cart'
        ],
        'link_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'link_id'
        ],
        'shopgate_block' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'shopgate_block'
        ],
        'categories_additional_image' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_additional_image'
        ],
        'ebay_category_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_category_id'
        ],
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);
        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }
        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }
        $this->setValues(__CLASS__, $childValues);
    }
    
    private static function cache_delete(){
        global $InstanceCache;
        \yescache_helper::cache_bump_generation($InstanceCache, 'categories');        
    }
    
    public function create(){
        $data = self::convert_values( $this->toArray(),self::$propertyTypes );
        xtc_db_perform(self::TABLE_NAME, $data);
        self::cache_delete();
        return xtc_db_insert_id();
    }
    
    
    public function update(){
        $data = self::convert_values( $this->toArray(),self::$propertyTypes );
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        yes_db_perform(self::TABLE_NAME, $data,'update',[
            self::TABLE_INDEX => $this->$index
        ]);
        self::cache_delete();
    }
    
    public static function delete( int $category_id ){
        xtc_db_query("delete from " . TABLE_CATEGORIES . " where categories_id = '" . $category_id . "'");
        \YES4Trade\Model\categories_description::delete($category_id);
        xtc_db_query("delete from " . TABLE_PRODUCTS_TO_CATEGORIES . " where categories_id = '" . $category_id . "'");
        self::cache_delete();
    }
    
    public static function get_by_categories_id( int $categories_id, array $select_fields = [] ){
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
            "SELECT %s FROM %s WHERE %s=:id",
                $select_field_string,self::TABLE_NAME, self::TABLE_INDEX
            ),['id'=>$categories_id]
        );
        if(sizeOf($query)){
            $record = current($query);
            $data = self::convert_values( $record,self::$propertyTypes );
            return new self($data);
        }
        return null;
    }
    
    public static function get_by_parent_id(int $parent_id, array $select_fields = [] ){
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
            "SELECT %s FROM %s WHERE parent_id=:id",
                $select_field_string,self::TABLE_NAME
            ),['id'=>$parent_id]
        );
        $items = [];
        foreach($query as $record){
            $data = self::convert_values( $record,self::$propertyTypes );
            $items[] = new self($data);
        }
        return $items;

    }
    
    public static function get_template_file( string $listing_template = '', string $module_path = 'product_listing' ){
        $base_path = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/';
        $files=array();
        if ($dir = opendir($base_path.$module_path)){
            while  (($file = readdir($dir)) !==false) {
                if($file =="index.html"){
                    continue;
                }
                if(is_file( $base_path.$module_path.'/'.$file)){
                    $files[$file] = true;
                }
            }
        }
        closedir($dir);
        if(!empty($listing_template) and $listing_template != 'default'){
            if (isset($files[$listing_template])){
                return $listing_template;
            }
        }
        // einfach den ersten gueltigen Eintrag zurueckgeben
        return array_key_first($files);
    }
    
    /**
     * Liefert ALLE Eintraege
     */
    public static function get(array $select_fields = []):array{
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
            "SELECT %s FROM %s",
                $select_field_string,self::TABLE_NAME
            )
        );
        $items = [];
        foreach($query as $record){
            $data = self::convert_values( $record,self::$propertyTypes );
            $items[] = new self($data);
        }
        return $items;
    }
    
    /**
     * Gibt ein Array id/text fuer alle Subkategorien von $parent_id zurueck
     * @param int $parent_id
     * @return array
     */
    public static function get_categories_id_text_values_by_categories_id(int $parent_id):array{
        $language_id = $_SESSION['languages_id']??2;
        $tree = self::get_categories_tree($language_id);
        $categories = self::findSubcategories($tree, $parent_id);
        $categories_id_text_values = self::extract_id_text_values_from_tree($categories);
        $catname = self::findCategoryNameById($tree,$parent_id);
        if($catname == null and $parent_id == 0){
            $catname = 'TOP';
        }
        return array_merge(
                [['id'=>$parent_id,'text'=>$catname]],
                $categories_id_text_values
        );
    }
    
    
    private static function findCategoryNameById($array, $id) {
        foreach ($array as $category) {
            if ($category['categories_id'] == $id) {
                return $category['categories_name'];
            }

            // Wenn Kinder vorhanden sind, rekursiv weiter durchsuchen
            if (!empty($category['children'])) {
                $result = self::findCategoryNameById($category['children'], $id);
                if ($result) {
                    return $result;
                }
            }
        }

        return null; // Rückgabe null, wenn keine Kategorie gefunden wurde
    }
    
    /**
     * ERMITTELT ALLE CATEGORIES_ID/NAME VOM TREE ARRAY.
     *  NUETZLICH UM ALLE UNTERKATEGORIEN EINER KATEGORIE ZU HOLEN
     * @param array $categories
     * @return array
     */
    private static function extract_id_text_values_from_tree(array $categories, int $level = 1):array {
        $categoryIds = [];

        foreach ($categories as $category) {
            // Füge die `categories_id` der aktuellen Kategorie zur Liste hinzu
            $spaces = '';
            for($i=0;$i<$level;$i++){
                $spaces .= '&nbsp;&nbsp;&nbsp;&nbsp;';
            }
            $categoryIds[] = ['id'=>$category['categories_id'],'text'=>$spaces.$category['categories_name']];
        
            // Wenn die Kategorie Kinder hat, rufe die Funktion rekursiv auf
            if (!empty($category['children'])) {
                $categoryIds = array_merge($categoryIds, self::extract_id_text_values_from_tree($category['children'], $level+1));
            }
        }
        return $categoryIds;
    }

    private static function findSubcategories(array $categories, int $parent_id) {
        $subcategories = [];
        foreach ($categories as $category) {
            if (intval($category['parent_id']) == $parent_id) {
                $subcategories[] = $category;
            }

            // Rekursiver Aufruf für die Kinder, um auch tiefere Unterkategorien zu finden
            if (is_countable($category['children']) and sizeOf($category['children'])) {
                $subcategories = array_merge($subcategories, self::findSubcategories($category['children'], $parent_id));
            }
        }
        return $subcategories;
    }

    // FUER KATEGORIESTRUKTUR ALS DROPDOWN
    public static function get_categories_pulldown_menu(string $input_field_name = 'categories_id', int $default_id = 0, $include_none = false):string{
        $language_id = $_SESSION['languages_id']??2;
        $tree = self::get_categories_tree($language_id);
        if($include_none === true){
            $text_select = (defined('TEXT_SELECT'))?TEXT_SELECT:'-- keine --';
            $tree = array_merge([['categories_id'=>'','categories_name'=>$text_select]],$tree);
        }
        return self::generateCategorySelect($tree,$input_field_name, $default_id);
    }

    public static function renderTree(array $nodes, int $depth = 0, bool $isRoot = false): void {
        echo '<ul class="cat-tree'.($isRoot ? ' cat-tree-root' : ' cat-tree-children hidden').'" data-depth="'.$depth.'" style="--d:'.$depth.'">';
        foreach ($nodes as $node) {
            $id   = (int)$node['categories_id'];
            $name = htmlspecialchars((string)$node['categories_name'], ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
            $children = $node['children'] ?? [];
            $hasChildren = !empty($children);

            echo '<li class="cat-node'.($hasChildren ? ' has-children' : ' is-leaf').'" aria-expanded="false" data-id="'.$id.'" style="--d:'.$depth.'"' . ($hasChildren ? ' data-has-children="1"' : ' data-leaf="1"') . '>';

            echo '<button type="button" class="cat-label'.($hasChildren ? ' cat-toggle' : ' cat-leaf').'"'.
                ($hasChildren ? ' aria-haspopup="true" aria-expanded="false"' : '').
                '>'.$name.'</button>';

            if ($hasChildren) {
                self::renderTree($children, $depth + 1, false);
            }
            echo '</li>';
        }
        echo '</ul>';
    }

    public static function get_categories_tree_select(array $parameters, \yesSmarty $smarty):string{
        $return_function = $parameters['return_function']??'';
        $ALL_ITEMS_SELECTABLE = $parameters['ALL_ITEMS_SELECTABLE']??'false';

        $tree = self::get_categories_tree();
        ob_start();
        self::renderTree($tree, 0, true);
        $tree_html = ob_get_contents();
		ob_end_clean();

        $smarty->assign([
            'CATEGORY_TREE'=>$tree_html,
            'RETURN_FUNCTION'=>$return_function,
            'ALL_ITEMS_SELECTABLE'=>$ALL_ITEMS_SELECTABLE
        ]);
        return $smarty->fetch('categories_tree_select.html');        
    }
    
    // FUER KATEGORIESTRUKTUR ALS DROPDOWN
    private static function get_categories_tree(int $language_id = 2):array{
        global $InstanceCache;
        $cache_key = 'categories.tree.admin_'.$language_id;
        $cache_group = 'categories';
        $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);
        $CachedString = $InstanceCache->getItem($key); // cache group
        if (!$CachedString->isHit()) {
            $items_list = [];
            // Erstelle ein leeres Array für die Kategorien
            $categoryTree = [];
            $query = xtc_db_query(sprintf(
                    "SELECT c.categories_id,cd.categories_name, c.parent_id FROM %s c LEFT JOIN %s cd USING(categories_id) WHERE cd.language_id='%d'",
                    TABLE_CATEGORIES, TABLE_CATEGORIES_DESCRIPTION, $language_id
            ));
            while($record = xtc_db_fetch_array($query)){
                $items_list[] = $record;
            }

            // Kategorie-Elemente nach id abbilden
            $categoriesById = [];
            foreach ($items_list as $category) {
                $categoriesById[$category['categories_id']] = $category;
                $categoriesById[$category['categories_id']]['children'] = [];
            }

            foreach ($items_list as $category) {
                if ($category['parent_id'] == 0) {
                    // Wenn es keine Eltern-Kategorie gibt, ist es ein Root-Element
                    $categoryTree[] = &$categoriesById[$category['categories_id']];
                } else {
                    // Sonst wird es als Kind der entsprechenden Eltern-Kategorie hinzugefügt
                    $categoriesById[$category['parent_id']]['children'][] = &$categoriesById[$category['categories_id']];
                }
            }
            $CachedString->set($categoryTree)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        } else {
            $categoryTree = $CachedString->get();
        }

        // Rückgabe der hierarchischen Struktur
        return $categoryTree;
    }
    
    // FUER KATEGORIESTRUKTUR ALS DROPDOWN
    private static function createCategorySelect(array $categories, int $level = 0, int $default_id=0):string {
        $html = '';
        foreach ($categories as $category) {
            // Erstelle die Option mit entsprechender Einrückung
            $indent = str_repeat('-', $level * 4); // 4 Leerzeichen pro Ebene
            $selected = '';
            if($default_id == intval($category['categories_id'])){
                $selected = ' selected="selected" ';
            }
            $html .= "<option {$selected} value='{$category['categories_id']}'>{$indent}{$category['categories_name']}</option>\n";

            // Rekursiv für Unterkategorien
            if (!empty($category['children'])) {
                $html .= self::createCategorySelect($category['children'], $level + 1, $default_id);
            }
        }

        return $html;
    }

    // FUER KATEGORIESTRUKTUR ALS DROPDOWN
    // Hauptfunktion zum Generieren des kompletten Select-Felds
    private static function generateCategorySelect(array $categories, string $input_field_name, int $default_id):string {
        $options = self::createCategorySelect($categories, 0, $default_id);
        return "
            <select name=\"{$input_field_name}\">
                {$options}
            </select>
        ";
    }
}
