<?php
namespace YES4Trade\Model\eBayPlatformNotifications;
use \YES4Trade\Model\PlatformNotificationInterface;
class ItemClosed implements PlatformNotificationInterface
{
    private bool $debug;
    private string $recipientUserId;
    private string $notificationEventName;
    private object $message;
    private const requirements = [
        'functions'=>[
            'yes_update_products_in_auction_quantity',
            'yes_products_calc_in_auction_quantity',
        ],
        'classes'=>[
            'ebay_auction'
        ]
    ];

    public static function dbg( string $debug_string ):void{
        printf("%s\n",$debug_string);
    }

    public function __construct(string $recipientUserId, string $notificationEventName, object $message, bool $debug = false)
    {
        $this->debug = $debug;
        \YES4Trade\Model\eBayPlattformNotification::checkRequirements(self::requirements);
        $this->recipientUserId = $recipientUserId;
        $this->notificationEventName = $notificationEventName;
        $this->message = $message;
    }

    public function getRecipientUserId(): string
    {
        return $this->recipientUserId;
    }

    public function getNotificationEventName(): string
    {
        return $this->notificationEventName;
    }

    /**
     * Verarbeitet die ItemClosed Nachricht
     * Als erstes wird geprueft ob die Auktion lokal existiert
     * Falls nicht return false
     * --
     * Dann wird geprueft ob der Status der Auktion in YES
     * bereits den Status 2 hat
     * Falls bereits 2 return false
     * --
     * Dann wird der Status der Auktion auf 2 gesetzt
     * Dann werden ggf die Varianten oder der Main Artikel
     * neu berechnet mit yes_update_products_in_auction_quantity(
     * und ein entsprechender Historieneintrag bei den
     * Artikeln geschrieben.
     * 
     * @return bool
     */
    public function process(): bool
    {
        if($this->debug){
            self::dbg(sprintf(
                "Processing %s for %s", $this->notificationEventName, $this->recipientUserId
            ));
        }
        $auction = \YES4Trade\Model\ebay_auctions::get_by_ebay_id(
        	(string)$this->message->Item->ItemID,
        	['id','status']
        );
        if($auction === null){
            if($this->debug){
                self::dbg("Unknown Auction");
            }
            return false;
        }else{
            if($this->debug){
                self::dbg(sprintf('Auction %s is yes ebay_auctions.id %d',
                    (string)$this->message->Item->ItemID,
                    $auction->id
                ));
            }
            if(\YES4Trade\Model\eBayPlattformNotification::TEST_MODUS === true){
                yes_mail_debug(sprintf('[ITEMCLOSED] Auction %s is yes ebay_auctions.id %d und hat Status %s. Wenn Status nicht 2 dann beenden.',
                    (string)$this->message->Item->ItemID,
                    $auction->id,
                    $auction->status,
                ));
                return true;
            }
            if($auction->status == 2){
                if($this->debug){
                    self::dbg('Auction Status is '.$auction->status.', no changes');
                }
                return false;
            }
            $EBAYAPI = new \ebayAPI;
            if(\YES4Trade\Model\eBayPlattformNotification::SEND_DEBUG_MAIL_WHEN_ACTION === true){
                yes_mail_debug(
                    sprintf(
                        'Auktion %s (ebay_auction.id %d) beenden',
                        (string)$this->message->Item->ItemID,
                        $auction->id
                    ),
                    false,
                    'ItemClosed Action'
                );
            }
            $EBAYAPI->set_end_auction($auction->id);
            $ea = new \ebay_auction($auction->id);
            $ebay_auctions_variations = \YES4Trade\Model\ebay_auctions_variations::get_by_ebay_auctions_id(
                $auction->id,[
                'products_id','sku','quantity'
            ]);
            if(sizeOf($ebay_auctions_variations)){
                foreach($ebay_auctions_variations as $ebay_auctions_variation){
                    // $variation_update_qty wird nur fuer historie verwendet.
                    // den eigentlichen Wert liefert yes_products_calc_in_auction_quantity
                    $variation_update_qty = $ebay_auctions_variation->quantity;
                    $staffel_comment = '';
                    if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
                        if($ea->has_staffelpreise()){
                            $variation_update_qty = $ebay_auctions_variation->quantity*$ea->get_staffelpreis_quantity_from_sku($ebay_auctions_variation->sku);
                            $staffel_comment = ' Staffelpreis Menge '.$ea->get_staffelpreis_quantity_from_sku($ebay_auctions_variation->sku);
                        }
                    }
                    $comm = sprintf('[eBay PlatformNotification] Auktion %s beendet, %d Stk.%s',
                        (string)$this->message->Item->ItemID,
                        $variation_update_qty,
                        $staffel_comment
                    );

                    yes_update_products_in_auction_quantity(intval($ebay_auctions_variation->products_id), 
                        yes_products_calc_in_auction_quantity(intval($ebay_auctions_variation->products_id)), 
                        $comm,
                        true // overwrite!
                    );
                }
            }else{                
                $comm = sprintf('[eBay PlatformNotification] Auktion %s beendet, %d Stk',
                    (string)$this->message->Item->ItemID,
                    $ea->getQuantity()
                );
                yes_update_products_in_auction_quantity(intval($ea->getProductsId()), 
                    yes_products_calc_in_auction_quantity(intval($ea->getProductsId())), 
                    $comm,
                    true // overwrite!
                );
            }
        }
        return true;
    }
}
