<?php

namespace YES4Trade\Model;

class geo_zones extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'geo_zones';
    const TABLE_INDEX = 'geo_zone_id';

    private static $propertyTypes = [
        'geo_zone_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'geo_zone_id'
        ],
        'geo_zone_name' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'geo_zone_name'
        ],
        'geo_zone_description' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'geo_zone_description'
        ],
        'last_modified' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'last_modified'
        ],
        'date_added' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date_added'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public function update() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
		$index = self::TABLE_INDEX;
		yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
	}


	public static function delete(int $index) {
            // verknuepfte zones_to_geo_zones loeschen
            $items = \YES4Trade\Model\zones_to_geo_zones::get_by_geo_zone_id($id, ['association_id']);
            foreach($items as $item){
                \YES4Trade\Model\zones_to_geo_zones::delete(intval($item->association_id));
            }
            yes_query(sprintf(
                "DELETE FROM %s WHERE %s=:id",
                        self::TABLE_NAME,self::TABLE_INDEX
                ),['id'=>$index]
            );
	}


	public static function get_by_geo_zone_id(int $geo_zone_id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$geo_zone_id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}

        public static function get_id_text_list( string $order_by = 'geo_zone_name'):array{
            $items = [];
            $query = yes_query(sprintf(
                "select geo_zone_id, geo_zone_name from %s order by %s",
                self::TABLE_NAME, $order_by
            ));
            foreach($query as $zones) {
                $items[] = ['id'=>$zones['geo_zone_id'],'text'=>$zones['geo_zone_name']];
            }
            return $items;
        }
        
        
        public static function get_by_geo_zone_name_like(string $prefix):array{
            $items = [];
            $query = yes_query(sprintf(
                "select * from %s WHERE geo_zone_name LIKE '%s%%'",
                self::TABLE_NAME, $prefix
            ));
            foreach($query as $record) {
                $items[] = new self(self::convert_values($record,self::$propertyTypes));
            }
            return $items;
        }
}
