<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

class branches_transfer {
    var $info, $products;

    function __construct($branches_transfer_id) {
      $this->info = array();
      $this->products = array();
      $this->products_collected = array();
      $this->branch = array();
      $this->query($branches_transfer_id);	
    }

    function query($branches_transfer_id) {
	$branches_transfer_query = xtc_db_query("select *
                                  from branches_transfer bt where
                                  branches_transfer_id = '" . xtc_db_input($branches_transfer_id) . "'");

	$branches_transfer = xtc_db_fetch_array($branches_transfer_query);

	$this->info = array('status' => $branches_transfer['transfer_status'],
                        'date_created' => $branches_transfer['date_created'],
			'branches_id' => $branches_transfer['branches_id'],
			'target_branches_id' => $branches_transfer['target_branches_id'],
                        'date_finished' => $branches_transfer['date_finished'],
                        'id' => $branches_transfer['branches_transfer_id'],
                        'last_modified' => $branches_transfer['last_modified'],
			'editor_id'=> $branches_transfer['editor_id']);

      
	$index = 0;
	$branches_transfer_products_query = xtc_db_query("select * from branches_transfer_products where branches_transfer_id ='" . xtc_db_input($branches_transfer_id) . "' ORDER BY stuecklistenartikel,quantity_transfer DESC");
	while ($branches_transfer_products = xtc_db_fetch_array($branches_transfer_products_query)) {
		$this->products[$index] = array('qty' => $branches_transfer_products['products_quantity'],
			'name' => $branches_transfer_products['products_name'],
			'link'=>xtc_href_link('categories.php','pID='.$branches_transfer_products['products_id'].'&cPath='.xtc_get_product_path($branches_transfer_products['products_id']).'&action=new_product'),
			'btpID'=>$branches_transfer_products['branches_transfer_products_id'],
			'id' => $branches_transfer_products['products_id'],
			'model' => $branches_transfer_products['products_model'],
			'stuecklistenartikel' => $branches_transfer_products['stuecklistenartikel'],
			'stuecklisten_id' => $branches_transfer_products['stuecklisten_id'],
			'collie_qty' => $branches_transfer_products['collie_qty'],
			'quantity_transfer' => $branches_transfer_products['quantity_transfer']
		);

		if( $branches_transfer_products['stuecklisten_id']>0 ){
			$this->products_collected['stk'][$branches_transfer_products['stuecklisten_id']][$branches_transfer_products['products_id']] += $branches_transfer_products['products_quantity'] / $branches_transfer_products['collie_qty'];
		}else{
			$this->products_collected['default'][$branches_transfer_products['products_id']] += $branches_transfer_products['products_quantity'];
		}
		$index++;
	}// end while

	$branch_info_query = xtc_db_query("SELECT * FROM branches WHERE branches_id='".$this->info['branches_id']."'");
	$branch_info = xtc_db_fetch_array($branch_info_query);
	$this->branch = array(
		'title'=>$branch_info['title'],
		'stammlager'=>$branch_info['stammlager'],
		'storekeeper_id'=>$branch_info['storekeeper_id'],
		'storekeeper_name'=>xtc_get_editor_name($branch_info['storekeeper_id'])
	);
    } // end function

	function add_product($pID,$qty){
		$products_query = xtc_db_query("SELECT pd.products_name,p.products_model FROM products p LEFT JOIN products_description pd USING(products_id) WHERE pd.language_id='".$_SESSION['languages_id']."' and p.products_id='".$pID."'");
		$products = xtc_db_fetch_array($products_query);
		$is_saved_query = xtc_db_query("SELECT branches_transfer_products_id FROM branches_transfer_products WHERE branches_transfer_id='".$this->info['id']."' and products_id='".$pID."'");
		if(!xtc_db_num_rows($is_saved_query)){
			$insert_sql_array = array(
				'branches_transfer_id'=>$this->info['id'],
				'products_id'=>$pID,
				'products_model'=>$products['products_model'],
				'products_name'=>$products['products_name'],
				'products_quantity'=>$qty,
				'quantity_transfer'=>0,
				'stuecklistenartikel'=>0,
				'stuecklisten_id'=>0,
				'collie_qty'=>0
			);
			xtc_db_perform('branches_transfer_products',$insert_sql_array);
		}else{
			xtc_db_query("UPDATE branches_transfer_products SET products_quantity=products_quantity+".$qty." WHERE branches_transfer_id='".$this->info['id']."' and products_id='".$pID."'");
		}
	}
	
	function update_status($status,&$msg,$usr=0){
		xtc_db_query("UPDATE branches_transfer SET transfer_status='".$status."' where branches_transfer_id = '" . $this->info['id'] . "'");
		switch($status){
			case 1:
				$msg = 'Filialentransfer wurde auf den Status Bestellt gesetzt. '.$msg;
				break;
			case 2:
				$msg = 'Filialentransfer wurde storniert. '.$msg;
				break;
			case 3:
				$msg = 'Filialentransfer wurde auf den Status Offen gesetzt. '.$msg;
				break;
			case 4:
				$msg = 'Filialentransfer wurde auf den Status Versendet gesetzt. '.$msg;
				break;
		}
		$this->insert_history($status,$msg,$usr);
	}
	
	
	function insert_history($status,$comments,$usr){
		$insert_sql_array = array('branches_transfer_id'=>$this->info['id'],
			'branches_transfer_status_id'=>$status,
			'date_added'=>'now()',
			'comments'=>$comments,
			'editor_id'=>$usr
		);
		xtc_db_perform('branches_transfer_status_history',$insert_sql_array);
		xtc_db_query("UPDATE branches_transfer SET last_modified=now() WHERE branches_transfer_id='".$this->info['id']."'");
	}
	
}
?>
