<?php
/* --------------------------------------------------------------
Copyright (c) 2010 Mario Aspeleiter <dazze@gmx.de>
--------------------------------------------------------------*/

/**
 * Handle attachments for yes emails
 *
 * @author mario aspeleiter
 */
class ebaymail_attachment {
	var $ebay_email_attachments_id;
	var $email_id;
	var $filename;
	var $filesize;
	var $filetype;
	var $errors = array();

	function  __construct( $id ) {
		if((int)$id < 1){
			$this->setError('Die ID des Attachments darf nicht null sein');
			return false;
		}
		$eat = \YES4Trade\Model\ebay_email_attachments::get_by_ebay_email_attachments_id(intval($id));
		if($eat === null){
			$this->setError(sprintf('Das Attachment mit ID %d existiert nicht.',
				$id
			));
		}
		$this->setEbay_email_attachments_id($id);
		$this->setEmail_id($eat->email_id);
		$this->setFilename($eat->filename);
		$this->setFilesize(intval($eat->filesize));
		$this->setFiletype($eat->filetype);
		return true;
	}

	public function getEbay_email_attachments_id() {
		return $this->ebay_email_attachments_id;
	}

	public function setEbay_email_attachments_id($ebay_email_attachments_id) {
		$this->ebay_email_attachments_id = $ebay_email_attachments_id;
	}

	public function getEmail_id() {
		return $this->email_id;
	}

	public function setEmail_id($email_id) {
		$this->email_id = $email_id;
	}

	public function getFilename() {
		return $this->filename;
	}

	public function setFilename($filename) {
		$this->filename = $filename;
	}

	public function getFilesize() {
		return $this->filesize;
	}

	public function setFilesize($filesize) {
		$this->filesize = $filesize;
	}

	public function getFiletype() {
		return $this->filetype;
	}

	public function setFiletype($filetype) {
		$this->filetype = $filetype;
	}

	public function getErrors() {
		return $this->errors;
	}

	public function setError($error) {
		$this->errors[] = $error;
	}

	/**
	 * Loescht die Attachmentdatei und entfernt den DB Eintrag
	 */
	public function delete(){
		$file = \main::get_importdata_path().'mail_attachments/'.$this->getEmail_id().'/'.yes_get_sha1_from_string($this->getFilename());
		unlink($file);
		\YES4Trade\Model\ebay_email_attachments::delete(intval($this->getEbay_email_attachments_id()));
	}

}
