<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
require_once(DIR_FS_CATALOG.'admin/includes/classes/class.colli.php');
require_once(DIR_FS_CATALOG.'admin/includes/classes/class.colliarray.php');

require_once(DIR_FS_CATALOG.'admin/includes/classes/product_set.php');

class products_quantity{
	var $products_id;
	var $products_total_qty;
	var $storage_id;
	var $storage_name;
	var $colli_array;
	var $default_storage;
	var $storages = array();
	var $ampel;
	// UEBERARBEITETE VARS
	var $hermes_qty = 0;
	var $gesamtbestand_qty = 0;
	var $stammlager_qty = 0;
	var $available1_qty = 0; // Verfuegbarer Gesamtbestand
	var $available2_qty = 0; // Verfuegbarer Gesamtbestand
	var $auction_qty = 0;
	var $amazon_qty = 0;
	var $block_reclamations_qty = 0;
	var $not_shipped_qty = 0;
	var $raw_qty = 0; // db bestand
	var $products_status; // um u.a. bei shopkaeufen auch den status zu pruefen
	var $meldebestand;
	var $editor_id;
	var $history_source;
	var $db_in_auction_qty; // der db wert fuer in_auction
        var $hitmeister_quantity = 0;
	var $external_stock = 0;
	function set_products_id( $value ) {
		$this->products_id = (int)$value;
	}

	function get_products_id( ) {
		return $this->products_id;
	}
	
	
	function get_colli_array(){
		return $this->colli_array;
	}
	
	function set_colli_array($value){
		$this->colli_array = $value;
	}
	
	
	function get_stammlager_qty(){
		return $this->stammlager_qty;
	}
	
	function set_stammlager_qty($value){
		$this->stammlager_qty = (int)$value;
	}
	
	function get_gesamtbestand_qty(){
		return $this->gesamtbestand_qty;
	}
	
	function set_gesamtbestand_qty($value){
		$this->gesamtbestand_qty = (int)$value;
	}
	
	function get_available1_qty(){
		return $this->available1_qty;
	}
	
	function set_available1_qty($value){
		$this->available1_qty = (int)$value;
	}
	
	function get_available2_qty(){
		return $this->available2_qty;
	}
	
	function set_available2_qty($value){
		$this->available2_qty = (int)$value;
	}

	function get_auction_qty(){
		return $this->auction_qty;
	}

	function set_auction_qty($value){
		$this->auction_qty = (int)$value;
	}

	function get_amazon_qty(){
		return $this->amazon_qty;
	}

	function set_amazon_qty($value){
		$this->amazon_qty = (int)$value;
	}
	
	function get_block_reclamations_qty(){
		return $this->block_reclamations_qty;
	}
	
	function set_block_reclamations_qty($value){
		$this->block_reclamations_qty = (int)$value;
	}
	
	function get_not_shipped_qty(){
		return $this->not_shipped_qty;
	}
	
	function set_not_shipped_qty($value){
		$this->not_shipped_qty = (int)$value;
	}
	
	function get_products_total_qty() {
		return (int)$this->products_total_qty;
	}
	
	function set_products_total_qty($value) {
		$this->products_total_qty = $value;
	}
	
	function get_raw_qty() {
		return (int)$this->raw_qty;
	}
	
	function set_raw_qty($value) {
		$this->raw_qty = $value;
	}

	function set_products_status($value){
		$this->products_status = (bool)$value;
	}

	function get_products_status(){
		return (bool)$this->products_status;
	}

	function set_default_storage($value){
		$this->default_storage = $value;
	}
	
	function get_default_storage(){
		return $this->default_storage;
	}

	public function get_meldebestand() {
		return $this->meldebestand;
	}

	public function set_meldebestand($meldebestand) {
		$this->meldebestand = $meldebestand;
	}
	
	public function get_db_in_auction_qty() {
	    return $this->db_in_auction_qty;
	}

	public function set_db_in_auction_qty($db_in_auction_qty) {
	    $this->db_in_auction_qty = $db_in_auction_qty;
	}
        

        function get_hitmeister_quantity() {
            return $this->hitmeister_quantity;
        }

        function set_hitmeister_quantity($hitmeister_quantity) {
            $this->hitmeister_quantity = $hitmeister_quantity;
        }

        
	public static function get_products_in_auction(int $products_id){
		if($products_id < 1){
			return 0;
		}
		$total = 0;
		
		if(!function_exists('xtc_get_product_collies')){
			require_once(DIR_FS_INC.'xtc_collies.inc.php');
		}
		$collies = xtc_get_product_collies($products_id);
		if(sizeOf($collies)){
			$total += \YES4Trade\Model\ebay_auctions::calc_running_auctions_quantity_for_products_id($products_id);
		}else{
			$record = yes_query(
				"SELECT in_auction FROM products WHERE products_id=:products_id",
				['products_id'=>$products_id],
				true
			);
			$total += (int)$record['in_auction'];
		}
		return $total;
	}
	
	function _init_db_values(){
		$product = yes_query(sprintf(
			"select p.products_quantity, p.default_storage,p.products_status,p.in_auction,p.products_meldebestand from %s p where p.products_id =:id",
				TABLE_PRODUCTS,
			),
			['id'=>intval($this->get_products_id())],
			true
		);
		if($product === false){
			throw new Exception('Invalid products_id #'.$this->get_products_id());
		}
		$this->set_products_total_qty($product['products_quantity']);
		$this->set_products_status($product['products_status']);
		$this->set_default_storage($product['default_storage']);
		$this->set_meldebestand($product['products_meldebestand']);
		// 09/2016 BOF - AUKTIONSBESTAND IMMER AUS FUNKTION HOLEN
		// STKLISTENARTIKEL KOENNEN AUCH EBAY VARIANTEN SEIN, DARUM GIBT
		// ES EIN SPEZIELLES HANDLING
		$this->set_auction_qty( self::get_products_in_auction( intval($this->get_products_id()) ) );
		$this->set_db_in_auction_qty($product['in_auction']);
		// 09/2016 EOF - AUKTIONSBESTAND IMMER AUS FUNKTION HOLEN
                

                if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
                    if(!class_exists('yes_hitmeister')){
                        require_once(realpath(__DIR__).'/yes_hitmeister.php');
                    }
                    // DER PARAMETER false INITIALISIERT DAS OBJECT OHNE
                    // DEN API ZUGRIFF ZU STARTEN
                    $YH = new yes_hitmeister(false);
                    $this->set_hitmeister_quantity( $YH->get_quantity($this->get_products_id(),true) );
                }
                $this->external_stock = $this->get_external_stock();
	}
	
	function __construct($pID=-1,$history_source = ''){
            $this->editor_id = (isset($_SESSION['customer_id'])) ? (int)$_SESSION['customer_id'] : 0;
            $this->history_source = $history_source;
            global $VERSENDER;
            if($pID < 1){
                return;
            }
			
            $this->set_products_id($pID);
            $SET = new product_set($this->products_id);
            if(sizeOf($SET->collies)){
                $product_query = xtc_db_query(sprintf(
                    "select products_status from %s p where products_id = '%d'",
                     TABLE_PRODUCTS,$this->get_products_id()
                ));
                $product = xtc_db_fetch_array($product_query);
                $this->set_products_status($product['products_status']);
                $this->set_products_total_qty( $SET->get_set_total_quantity() );

                $this->set_auction_qty( self::get_products_in_auction( intval($this->get_products_id()) ) );
                if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
                        if(!function_exists('xtc_get_products_at_amazon')){
                            require_once(DIR_FS_CATALOG.'inc/xtc_get_products_at_amazon.inc.php');
						}
                        $this->set_amazon_qty( xtc_get_products_at_amazon( $this->get_products_id() ) );
                }else{
                        $this->set_amazon_qty( 0 );
                }
                $this->set_not_shipped_qty( xtc_get_products_not_shipped( $this->get_products_id() ) );
                $this->set_block_reclamations_qty( xtc_get_products_in_reclamations( $this->get_products_id() ) );
                $this->set_stammlager_qty( $SET->get_set_total_quantity());
                $this->set_gesamtbestand_qty( $this->get_stammlager_qty() );
                $this->set_available1_qty( $SET->get_set_av1_quantity() );
                $this->set_available2_qty( $SET->get_set_av2_quantity() );
            }else{
                $this->_init_db_values(); // holt den DB wert aus products
                $this->set_raw_qty($this->get_products_total_qty()); // brauchen wir fuer wert fehlender SN


                if(!_is_test($this->get_products_id())){
                    $this->set_auction_qty( self::get_products_in_auction( intval($this->get_products_id()) ) );
                }
                if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
                    $this->set_amazon_qty( xtc_get_products_at_amazon( $this->get_products_id() ) );
                }else{
                    $this->set_amazon_qty( 0 );
                }
                $this->set_not_shipped_qty( xtc_get_products_not_shipped( $this->get_products_id() ) );
                $this->set_block_reclamations_qty( xtc_get_products_in_reclamations( $this->get_products_id() ) );

                $bewegungsdaten = $this->get_block_reclamations_qty();
                $this->set_stammlager_qty( $this->get_products_total_qty());
                $this->set_gesamtbestand_qty( $this->get_stammlager_qty() );
                $this->set_available1_qty( $this->get_gesamtbestand_qty() 
                    + $this->get_external_stock() 
                    - $this->get_not_shipped_qty() 
                );
                $this->set_available2_qty( $this->get_gesamtbestand_qty() 
                    + $this->get_external_stock() 
                    - $bewegungsdaten 
                    - $this->get_not_shipped_qty() 
                    - $this->get_auction_qty() 
                    - $this->get_amazon_qty() 
                    - $this->get_hitmeister_quantity() 
                );

            } // end if !collie
	}
	
	function get_branch_qty($bID) {
		$qty = 0;
		$branch_query = xtc_db_query("SELECT products_quantity FROM branches_products WHERE products_id='".$this->products_id."' and branches_id='".$bID."'");
		$branch = xtc_db_fetch_array($branch_query);
		return (int) $branch['products_quantity'];
	}
	
	function set_storage_id( $value ) {
		if(is_int((int)$value) && $value > 0) {
			$this->storage_id = $value;
			return true;
		}else{
			return false;
		}
	}

	function get_storage_id( ) {
		return $this->storage_id;
	}
	
	function set_storage_name( $value ) {
		if($value && $value != '') {
			$this->storage_name = $value;
			return true;
		}else{
			return false;
		}
	}

	function get_storage_name( ) {
		return $this->storage_name;
	}

	
	function get_default_storage_id( ) {
		$sID = '';
		$sid_query = xtc_db_query("SELECT id FROM storages WHERE default_storage='y'");
		$sid_result = xtc_db_fetch_array($sid_query);
		if($sid_result['id'] > 0){
			$sID = $sid_result['id'];
		}
		return $sID;
	}
	
	function update_qty( int $qty,$sID,$orig_qty,$comment = '',$storage_place_reason_class='',$storage_place_reason_id=0,$storage_place_reason_subclass='',$shipping_products_id = 0){
		global $_SESSION;
		if($comment == '') {
                    $comment = sprintf(
                        "Im Lagerinfo (%s) von %d korrigiert auf: %d",
                        xtc_get_storage_name($sID),
                        $orig_qty,
                        $qty
                    );
                }
			
		if( $_SESSION['customers_status']['customers_status_id']=='0'){
                    $editor_id = $_SESSION['customer_id'];
		}else{
                    $editor_id = 0; // system
		}
		
		$CA = new colliarray( $this->get_products_id() );
                $CA_collies = $CA->get_collies();
		if( is_countable($CA_collies) and sizeOf( $CA_collies ) > 0 ){
                    foreach($CA_collies as $k=>$collie){
			    // HIER DUERFTE DER FEHLER LIEGEN
			    // get_quantity ENTHAELT BEWEGUNGSDATEN
			    //	$cpqty = $collie->get_quantity();
			    // BUGFIX: echter gesamtbestand (also inkl bewegungsdaten)
				$cpqty = $collie->SQ_instance->gesamtbestand_qty;
				
				
				
				$new_cpqty = $cpqty + ( $qty * $collie->get_pack_quantity() );
				$change_cpqty = $new_cpqty - $cpqty;
				
				// -2 fuer Versand
				// BUGFIX - BEI process_storage NICHT new_qty sondern qty*get_pack_quantity()
                                $target_storage_products_id = -2;
				$collie->SQ_instance->process_storage_places_qty_add(
                                        $qty * $collie->get_pack_quantity(),
                                        $target_storage_products_id,
                                        $storage_place_reason_class,
                                        $storage_place_reason_id,
                                        $storage_place_reason_subclass,
                                        $shipping_products_id
                                );
				
				xtc_db_query("UPDATE products SET products_quantity='".$new_cpqty."' WHERE products_id='".$collie->get_products_id()."'");
				xtc_db_query("INSERT INTO history_bestand SET products_id='".$collie->get_products_id()."',quantity_change='".$change_cpqty."',title='SETBUCHUNG aus Produkt ".$this->get_products_id()." heraus (Orig: ".$cpqty." / Neu: ".$new_cpqty.") ".xtc_db_input($comment)."',storage_id='".$sID."',date_saved=now(), editor_id='".$this->editor_id."', source='".$this->history_source."'");
				// products_history
                                product::add_history_static(intval($collie->get_products_id()),
                                    "SETBUCHUNG aus Produkt ".$this->get_products_id()." heraus (Orig: ".$cpqty." / Neu: ".$new_cpqty.") ".$comment
                                );
			}
			// bestand history
			xtc_db_query("INSERT INTO history_bestand SET products_id='".$this->products_id."',quantity_change='".$qty."',title='(Orig: ".$this->get_products_total_qty()." / Neu: ".($this->get_products_total_qty()+$qty).")".xtc_db_input($comment)."',storage_id='".$sID."',date_saved=now(), editor_id='".$this->editor_id."', source='".$this->history_source."'");
			// products_history
                        product::add_history_static(intval($this->products_id), 
                            "(Orig: ".$this->get_products_total_qty()." / Neu: ".($this->get_products_total_qty()+$qty).") ".$comment
                        );
		}else{
                    $this->process_storage_places_qty_add(
                        (int)$qty,
                        -2,
                        $storage_place_reason_class,
                        $storage_place_reason_id,
                        $storage_place_reason_subclass,
                        $shipping_products_id
                    );
                    xtc_db_query("UPDATE products SET products_quantity=products_quantity+'".($qty)."' WHERE products_id='".$this->products_id."'");
                    // bestand history
                    xtc_db_query("INSERT INTO history_bestand SET products_id='".$this->products_id."',quantity_change='".$qty."',title='(Orig: ".$this->get_products_total_qty()." / Neu: ".($this->get_products_total_qty()+$qty).")".xtc_db_input($comment)."',storage_id='".$sID."',date_saved=now(), editor_id='".$this->editor_id."', source='".$this->history_source."'");
                    // products_history
                    product::add_history_static(intval($this->products_id), 
                        "(Orig: ".$this->get_products_total_qty()." / Neu: ".($this->get_products_total_qty()+$qty).") ".$comment
                    );
		}
	}
	
	function inventur_qty( $qty,$comment = '',$update_storage_quantity=false ){
	    $sID = 0; // nur dummy fuer error_reporting - auf 0 gesetzt, da '' 
		    // zu fehler bei mysql 7 fuehrt
		global $_SESSION;
		if( $_SESSION['customers_status']['customers_status_id']=='0'){
			$editor_id = $_SESSION['customer_id'];
		}else{
			$editor_id = 0; // system
		}
		
		if($update_storage_quantity){
			$remove_qty = $this->get_products_total_qty() - $qty;
			if($remove_qty > 0)
				$this->process_storage_places_qty_inventur($remove_qty);
		}
		
		xtc_db_query("UPDATE products SET products_quantity='".($qty)."' WHERE products_id='".$this->products_id."'");
		// bestand history
		xtc_db_query("INSERT INTO history_bestand SET products_id='".$this->products_id."',quantity_change='".$qty."',title='(Orig: ".$this->get_products_total_qty()." / Neu: ".($qty).")".xtc_db_input($comment)."',storage_id='".$sID."',date_saved=now(), editor_id='".$this->editor_id."', source='".$this->history_source."'");
		// products_history
                product::add_history_static(intval($this->products_id), 
                    "(Orig: ".$this->get_products_total_qty()." / Neu: ".($qty).") ".$comment
                );
	}
	
	/*
	 * Wird nur noch in der products.php verwendet bei input type normal
	 */
	function addition_qty( $qty,$comment = '',$update_storage_quantity=false,$storage_place_reason_class='bestandseingabe',$storage_place_reason_id=0,$storage_place_reason_subclass='' ){
	    $sID = 0; // muss eine gesetzt werden sonst mysql 7 error (09/2016)
		global $_SESSION;
		if( $_SESSION['customers_status']['customers_status_id']=='0'){
			$editor_id = $_SESSION['customer_id'];
		}else{
			$editor_id = 0; // system
		}
		
		if($update_storage_quantity){
			$this->process_storage_places_qty_add($qty,-1,$storage_place_reason_class,$storage_place_reason_id,$storage_place_reason_subclass);
		}
		
		xtc_db_query("UPDATE products SET products_quantity=products_quantity+'".($qty)."' WHERE products_id='".$this->products_id."'");
		// bestand history
		xtc_db_query("INSERT INTO history_bestand SET products_id='".$this->products_id."',quantity_change='".$qty."',title='(Orig: ".$this->get_products_total_qty()." / Neu: ".($this->get_products_total_qty()+$qty).")".xtc_db_input($comment)."',storage_id='".$sID."',date_saved=now(), editor_id='".$this->editor_id."', source='".$this->history_source."'");
		// products_history
                product::add_history_static(intval($this->products_id), 
                    "(Orig: ".$this->get_products_total_qty()." / Neu: ".($this->get_products_total_qty()+$qty).") [ADDITION] ".$comment
                );
	}

	function get_ampel(){
		if( $this->get_products_total_qty() > 5 or STOCK_ALLOW_CHECKOUT == 'true'){
			return '<img src="'.HTTP_SERVER.'images/icons/ampel_gruen.jpg" title="Artikel vorr&auml;tig" border="0">';
		}else if( $this->get_products_total_qty() and $this->get_products_total_qty() >= 1){
			return '<img src="'.HTTP_SERVER.'images/icons/ampel_gelb.jpg" title="Artikel noch vorr&auml;tig" border="0">';
		}else{
			return '<img src="'.HTTP_SERVER.'images/icons/ampel_rot.jpg" title="Artikel nicht vorr&auml;tig" border="0">';
		}
	}

	function update_log($log_class,$qty){
		switch($log_class){
			case 'in_auction':
				xtc_db_query(sprintf(
					"UPDATE products_quantity_log SET %s=%d+%d WHERE products_id='%d'",
					$log_class,$log_class,$qty,$this->products_id
				));
				break;
		}
	}
	
	function storage_place_transfer($source_spID,$target_spID,$qty){
		if($target_spID > 0){
			xtc_db_query(sprintf(
				"UPDATE storage_products SET quantity=quantity+%d WHERE id=%d",
				$qty,$target_spID
			));
		}
		if($source_spID > 0){
			xtc_db_query(sprintf(
				"UPDATE storage_products SET quantity=quantity-%d WHERE id=%d",
				$qty,$source_spID
			));
		}
	}
	
	/**
	 * Ermittelt die Anzahl Artikel die noch nicht auf Lagerpl�tze gebucht sind
	 */
	function get_untransferred(){
		$untransferred = 0;
                if($this->get_products_id() < 1){
                    return $untransferred;
                }
	
		$query = xtc_db_query(sprintf(
			"SELECT SUM(quantity) as anz FROM storage_products WHERE products_id=%d",
			$this->get_products_id()
		));
		if(xtc_db_num_rows($query)){
			$record = xtc_db_fetch_array($query);
			$untransferred = $this->get_products_total_qty()-$record['anz'];
		}
		
		return $untransferred;
	}
	
	/**
	 * Ermittelt die Anzahl Artikel die auf Lagerplaetze gebucht sind
	 */
	function get_transferred(){
		$transferred = 0;
                if($this->get_products_id() < 1){
                    return $transferred;
                }
	
		$query = xtc_db_query(sprintf(
			"SELECT SUM(quantity) as anz FROM storage_products WHERE products_id=%d",
			$this->get_products_id()
		));
		if(xtc_db_num_rows($query)){
			$record = xtc_db_fetch_array($query);
			$transferred = $record['anz'];
		}
		
		return $transferred;
	}
	
        /**
         * Lagerplatz Buchungen
         * 
         * Beim Versandabschluss wird zb ein negativer Wert uebergeben. Dieser
         * wird dann bei den verfuegbaren Lagerplaetzen abgebucht, sofern Bestand
         * drauf ist
         * 
         * @param int $qty
         * @param int $target_storage_products_id
         * @param string $reason_class
         * @param int $reason_id
         * @param text $storage_place_reason_subclass
         * @param int $shipping_products_id
         * @return boolean
         */
	public function process_storage_places_qty_add($qty,$target_storage_products_id=-1,$reason_class='',$reason_id=0,$storage_place_reason_subclass='',$shipping_products_id = 0){
//            printf("process_storage_places_qty_add(qty %d,target_storage_products_id %d,reason_class %s,reason_id %d,storage_place_reason_subclass %s,shipping_products_id %d)",
//                $qty,$target_storage_products_id,$reason_class,$reason_id,$storage_place_reason_subclass,$shipping_products_id
//            );
//            
            // WIEVIEL SIND INSGESAMT AUF LAGERPLAETZE GEBUCHT/VERFUEGBAR
            $transferred = $this->get_transferred();
            
            // WIEVIEL SIND INSGESAMT VERFUEGBAR
            $total = $this->get_products_total_qty();
            
            // BEI POSITIVEN BUCHUNGEN, ALSO ZB LB EINGANG
            // WARUM GENAU DAS SO PROGRAMMIERT IST WEISS ICH GRAD NICHT
            // 2021/02
            if( $qty > 0 and ($total+$qty > $transferred)){
		return true;
            }
		
            $to_remove = $total+$qty-$transferred;
            if($to_remove > $transferred) {
		$to_remove = $transferred;
            }
            if($to_remove == 0){
		return true;
            }
            
            /**
             *  array(
             *      array('id'=>int, 'quantity'=>int),
             *      [...]
             *  ) 
             */
            $availables = $this->get_transferred_array();
            $removed = 0;
            foreach($availables as $av){
		if($qty < 0){
                    $qty_book = ($av['quantity'] > -($to_remove-$removed)) ? $to_remove-$removed : -$av['quantity'];
                    if($qty_book != 0){
                        $insert_sql_array = array(
                            'source_storage_products_id'=>$av['id'],
                            'target_storage_products_id'=>$target_storage_products_id,
                            'quantity'=>$qty_book,
                            'editor'=>(int)$_SESSION['customer_id'],
                            'reason_class'=>$reason_class,
                            'reason_id'=>$reason_id,
                            'reason_subclass'=>$storage_place_reason_subclass,
                            'date_added'=>'now()'
                        );
                        // BEIM VERSAND MUESSEN WIR AUCH DIE
                        // shippings_products_id BERUECKSICHTIGEN
                        // DA SONST NICHT REPRODUZIERT WERDEN KANN,
                        // WELCHER ARTIKEL BEI WELCHEM VERSANDAB-
                        // SCHLUSS VERWENDET WURDE
                        // SIEHE TICKET 2641
                        if($storage_place_reason_subclass == 'Versand'){
                            $insert_sql_array['shipping_products_id'] = $shipping_products_id;
                        }
                                    
                                    
                        xtc_db_perform('storage_products_transfer',$insert_sql_array);
                        xtc_db_query(sprintf(
                            "UPDATE storage_products SET quantity=quantity+%d WHERE id=%d",
                            $qty_book,$av['id']
                        ));
                    }
                    $removed += $qty_book;
//printf('<li>to_remove: %s, removed: %s, qty: %s, qty_book',$to_remove,$removed,$qty_book);
                    if($removed <= $to_remove){
//printf('<li>ABBRUCH: removed &lt;= to_remove (%s,%s)',$removed,$to_remove);
//exit;
                        break;
                    }
		}else{
                    $qty_book = ($av['quantity'] > $to_remove) ? $to_remove : $qty;
                    $insert_sql_array = array(
                        'source_storage_products_id'=>$av['id'],
                        'target_storage_products_id'=>$target_storage_products_id,
                        'quantity'=>$qty_book,
                        'editor'=>(int)$_SESSION['customer_id'],
                        'reason_class'=>$reason_class,
                        'reason_id'=>$reason_id,
                        'reason_subclass'=>$storage_place_reason_subclass,
                        'date_added'=>'now()'
                    );
                    xtc_db_perform('storage_products_transfer',$insert_sql_array);
                    xtc_db_query(sprintf(
                        "UPDATE storage_products SET quantity=quantity-%s WHERE id=%d",
                        $qty_book,$av['id']
                    ));
                    $removed += $qty_book;
                    if($removed >= $to_remove){
                        break;
                    }
                }
            }
	}
	
	function process_storage_places_qty_inventur($qty){
		$transferred = $this->get_transferred();
		if($qty > $transferred)
			return true;
		
		$to_remove = $qty;
		if($to_remove > $transferred) 
			$to_remove = $transferred;
		if($to_remove == 0)
			return true;
		$availables = $this->get_transferred_array();
		$removed = 0;
		
		foreach($availables as $av){
			$qty = ((int)$av['quantity'] > (int)$to_remove) ? (int)$to_remove : (int)$av['quantity'];
			xtc_db_query(sprintf(
				"UPDATE storage_products SET quantity=quantity-%s WHERE id=%s",
				$qty,$av['id']
			));
			$insert_sql_array = array(
				'source_storage_products_id'=>$av['id'],
				'target_storage_products_id'=>-1,
				'quantity'=>$qty,
				'editor'=>(int)$_SESSION['customer_id'],
				'reason_class'=>'inventur',
				'date_added'=>'now()'
			);
			xtc_db_perform('storage_products_transfer',$insert_sql_array);
			$removed += $qty;
			if($removed >= $to_remove){
				break;
			}
		}
		
	}
	
	function get_transferred_array(){
		$array = array();
                if($this->get_products_id() < 1){
                    return $array;
                }
	
		$query = xtc_db_query(sprintf(
			"SELECT id,quantity FROM storage_products WHERE products_id=%s ORDER BY priority",
			$this->get_products_id()
		));
		if(xtc_db_num_rows($query)){
			while($record = xtc_db_fetch_array($query)){
				$array[] = $record;
			}
		}
		
		return $array;
	}
	
	public function get_set_auction_qty(){
		return \YES4Trade\Model\ebay_auctions::calc_running_auctions_quantity_for_products_id(intval($this->get_products_id()));
	}

        /**
         * Externer Stock
         * 
         * Wenn Lieferanten Informationen liefern wieviel Bestand (STOCK) sie
         * zu einem Artikel haben, koennen diese Werte in den Bestand mit
         * reingerechnet werden. Dieses funktioniert zb bei dem HTG Modul
         * Bei dieser Funktion wird die Summe aller externen Stock Anbieter
         * zurueckgegeben
         * Wird return_as_array mit true uebergeben, werden die einzelnen ext.
         * Stockanbieter als Array zurueckgegeben
         * Array(
         *   [products_distributors_stock_id] => 1
         *   [distributor_id] => 3
         *   [distributor] = Mario Testfirma
         *   [products_id] => 122
         *   [quantity] => 20
         *   [last_quantity_update] => 2020-08-17 00:00:00
         * )
         * 
         * @return int $external_stock
         */
        public function get_external_stock( bool $return_as_array = false){
            $return_array = array();
            if(!sizeOf(main::get_distributors_with_external_stock())){
                return ($return_as_array) ? $return_array : 0;
            }
            $external_stock = 0;
            $distributor_stock_array = array();
            $distributor_stock_query = xtc_db_query(sprintf(
                    "/*SQ::get_external_stock*/ SELECT * FROM products_distributors_stock WHERE products_id='%d'",
                    $this->get_products_id()
            ));
            while($distributor_stock = xtc_db_fetch_array($distributor_stock_query)){
                $distributor_stock_array[] = $distributor_stock;
            }
            foreach($distributor_stock_array as $dsa){
                if(main::hasDistributorExternalStock($dsa['distributor_id'])){
                    $external_stock += $dsa['quantity'];
                    if($return_as_array === true){
                        $dsa['distributor'] = xtc_get_distributor_name($dsa['distributor_id']);
                        $return_array[] = $dsa;
                    }
                }
            }
            if($return_as_array !== true){
                return $external_stock;
            }
            return $return_array;
        }
}
