<?php
class eBayMediaApi
{
	var $seller, $access_token, $env, $debug = false, $debug_array = array();
        
	public function __construct(string $seller, string $access_token, string $env){
            $this->setSeller($seller);
            $this->setAccess_token($access_token);
            $this->setEnv($env);
            $this->debug = false;
	}
        
	public function setSeller( string $seller ){
		$this->seller = $seller;
	}
	
	public function getSeller(){
		return $this->seller;
	}
	public function setAccess_token( string $access_token ){
		$this->access_token = $access_token;
	}
	
	public function getAccess_token(){
		return $this->access_token;
	}
	
	public function setEnv( string $env ){
		$this->env = $env;
	}
	
	public function getEnv(){
		return $this->env;
	}
	
	public function get_header( string $postFile, string $api_url ){
            if(!empty($postFile)){
                $ct = (strpos($api_url,'/video')>0)?"application/octet-stream":"multipart/form-data";
                if($ct == "multipart/form-data"){
                    $header = [
                            "Authorization: Bearer ".$this->getAccess_token(),
                            "Content-Type: ".$ct,
                    ];
                    if($this->debug){
                        $this->debug_array[] = sprintf('get_header returns<br />%s',print_r(['Authorization: Bearer: ?????','Content-Type: '.$ct],true));
                    }
                    return $header;
                }
                $header = [
                    "Authorization: Bearer ".$this->getAccess_token(),
                    "Content-Type: ".$ct,
                    "Content-Length: ".fileSize($postFile),
                ];
                if($this->debug){
                    $this->debug_array[] = sprintf('get_header returns<br />%s',print_r(['Authorization: Bearer: ?????','Content-Type: '.$ct,"Content-Length: ".fileSize($postFile)],true));
                }
                return $header;
            }
            $header = [
                "Authorization: Bearer ".$this->getAccess_token(),
                "Content-Type: application/json",
            ];
            if($this->debug){
                $this->debug_array[] = sprintf('get_header returns<br />%s',print_r(['Authorization: Bearer: ?????','Content-Type: application/json'],true));
            }
            return $header;
	}
	
	public function call( string $api_url, array $postData = [], string $postFile = '', $postFileTargetName = ''){
		$backtrace = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 2);
		$caller_function = end($backtrace)['function'];
                $dbg = [];
                if($this->debug){
                    $this->debug_array[] = sprintf('[call() wurde gestartet aus der Funktion %s heraus.<br />api_url: %s]', 
                        $caller_function, $api_url
                    );
                }
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $api_url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $this->get_header($postFile,$api_url));
		curl_setopt($ch, CURLOPT_HEADER, true);
		if(sizeOf($postData)){
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, 
				  json_encode($postData)
			);
                        if($this->debug){
                            $this->debug_array[] = 'postData:'.print_r($postData,true);
                        }
		}
		if($postFile != ''){
			curl_setopt($ch, CURLOPT_POST, true);
			if(strpos($api_url,'/video')>0){
                            $postContent = file_get_contents($postFile);
                            curl_setopt($ch, CURLOPT_POSTFIELDS,$postContent);
                            if($this->debug){
                                $this->debug_array[] = 'set CURLOPT_POSTFIELDS file_get_contents() from:'.$postFile;
                            }
			}else{
                            $postContent = [
                                    'file' => new \CurlFile($postFile,mime_content_type($postFile),$postFileTargetName)
                            ];
                            curl_setopt($ch, CURLOPT_POSTFIELDS,$postContent);
                            if($this->debug){
                                $this->debug_array[] = 'set CURLOPT_POSTFIELDS CurlFile('.$postFile.','.mime_content_type($postFile).', '.$postFileTargetName.')';
                            }
			}
		}
		$api_response = curl_exec($ch);
		if ($api_response === false) {
                        curl_close($ch);
			throw new Exception('API Request Error: "' . curl_error($ch) . '" - Code: ' . curl_errno($ch));
		}
                if($this->debug){
                    $this->debug_array[] = 'api_response:<pre><code>'. print_r($api_response,true).'</code></pre>';
                }
	    
		$headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$header = substr($api_response, 0, $headerSize);
		$header_rows = explode("\n", trim($header));
		$body = substr($api_response,$headerSize);
		$ok200 = false;
                $videolink = '';
		foreach($header_rows as $nr=>$hr){
                    if(strpos(trim($hr), 'HTTP/1.1 200') > -1 or strpos(trim($hr), 'HTTP/1.1 201') > -1){
                        $ok200 = true;
                        if($this->debug){
                            $this->debug_array[] = 'im header response ist Status 200 oder 201 vorhanden';
                        }
                    }
                    if(strpos($hr, 'location: ')>-1 and in_array($caller_function,['createVideo'])){
                            // VIDEO CREATE
                        $videolink = trim(str_replace('location: ','', $hr));
                        $body = json_encode(['videolink'=>$videolink]);
                        curl_close($ch);
                        if($this->debug){
                            $this->debug_array[] = 'createVideo: im header response ist location vorhanden: '.$videolink;
                        }
                    }
		}
		curl_close($ch);
                if(!$ok200 and in_array($caller_function,['createVideo','uploadVideo'])){
                    $err = sprintf('<pre>%s</pre>',$header);
                    throw new Exception('Error @'.$caller_function.'(): '.$err);
                }
		// echo "API Response: " . htmlspecialchars($api_response);
		return json_decode($body, true);
	}
	
	
	public function getSandboxProductionDomain(string $sub = 'video/'){
		$api_subdomain = ($sub == 'video/') ? 'apim':'api';
		if(strpos($this->getEnv(),'sandbox')>-1){
			return "https://$api_subdomain.sandbox.ebay.com/commerce/media/v1_beta/".$sub;
		}
		return "https://$api_subdomain.ebay.com/commerce/media/v1_beta/".$sub;
	}
        
        public function get_regulatory_policies( array $categoryIDs, string $marketplace_id ){
            switch($this->getEnv()){
                case 'production':
                    $api_url = 'https://api.ebay.com/sell/metadata/v1/marketplace/'.$marketplace_id.'/get_regulatory_policies?filter='.urlencode('categoryId:{'.implode('|',$categoryIDs).'}');
                    break;
                default:
                    $api_url = 'https://api.sandbox.ebay.com/sell/metadata/v1/marketplace/'.$marketplace_id.'/get_regulatory_policies?filter='.urlencode('categoryId:{'.implode('|',$categoryIDs).'}');
            }
            try{
                return $this->call($api_url);
            }catch(Exception $e){
                die(json_encode([
                    'MSG'=>$e->getMessage()
                ]));
            }
        }
        
        public function getProductSafetyLabels( string $marketplace_id ){
            switch($this->getEnv()){
                case 'production':
                    $api_url = 'https://api.ebay.com/sell/metadata/v1/marketplace/'.$marketplace_id.'/get_product_safety_labels';
                    break;
                default:
                    $api_url = 'https://api.sandbox.ebay.com/sell/metadata/v1/marketplace/'.$marketplace_id.'/get_product_safety_labels';
            }
            try{
                return $this->call($api_url);
            }catch(Exception $e){
                die(json_encode([
                    'MSG'=>$e->getMessage()
                ]));
            }
        }
	
        public function get_hazardous_materials_labels(string $marketplace_id){
            switch($this->getEnv()){
                case 'production':
                    $api_url = 'https://api.ebay.com/sell/metadata/v1/marketplace/'.$marketplace_id.'/get_hazardous_materials_labels';
                    break;
                default:
                    $api_url = 'https://api.sandbox.ebay.com/sell/metadata/v1/marketplace/'.$marketplace_id.'/get_hazardous_materials_labels';
            }
            try{
                return $this->call($api_url);
            }catch(Exception $e){
                die(json_encode([
                    'MSG'=>$e->getMessage()
                ]));
            }
        }
        
	public function getVideo( string $video_id ){
		$video_url = $this->getSandboxProductionDomain().$video_id;
		return $this->call($video_url);
	}
	
	public function uploadVideo(string $video_id, string $video_data ){
		$api_url = $this->getSandboxProductionDomain().$video_id.'/upload';
                try{
                    $this->call($api_url, [], $video_data);
                }catch(Exception $e){
                    die(json_encode([
                        'MSG'=>$e->getMessage()
                    ]));
                }
	}

	public function createVideo(array $video_data ){
		$api_url = $this->getSandboxProductionDomain();
		$res = $this->call($api_url, $video_data);
                if(!isset($res['videolink']) or empty($res['videolink'])){
                    throw new Exception('createVideo failed');
                }
                return $res['videolink'];
	}
	
	public function createDocument(array $document_data ){
		$api_url = $this->getSandboxProductionDomain('document');
		return $this->call($api_url, $document_data);
	}
	
	public function uploadDocument(string $document_id, string $document_data ){
		$api_url = $this->getSandboxProductionDomain('document/').$document_id.'/upload';
		return $this->call($api_url, [], $document_data, $_FILES['documentfile']['name']);
	}

	public function getDocument( string $document_id ){
		$document_url = $this->getSandboxProductionDomain('document/').$document_id;
		return $this->call($document_url);
	}
	
	
	public function get_document_types_values(){
		$types = ['CERTIFICATE_OF_ANALYSIS',
                    'CERTIFICATE_OF_CONFORMITY',
                    'DECLARATION_OF_CONFORMITY',
                    'INSTRUCTIONS_FOR_USE',
                    'OTHER_SAFETY_DOCUMENTS',
                    'SAFETY_DATA_SHEET',
                    'TROUBLE_SHOOTING_GUIDE',
                    'USER_GUIDE_OR_MANUAL',
                    'INSTALLATION_INSTRUCTIONS'];
		$array = [];
		foreach($types as $t){
			$array[] = ['id'=>$t,'title'=>constant($t),'text'=>self::get_documentType_name($t)];
		}
		return $array;
			
	}
	
	public function get_document_languages_values(){
		$langs = [
			'ENGLISH','SPANISH','ITALIAN','GERMAN','POLISH','DUTCH','PORTUGESE','FRENCH','OTHER'
		];
		$array = [];
		foreach($langs as $l){
			$array[] = ['id'=>$l,'text'=>$l];
		}
		return $array;
	}
        
        public function get_videos( ){
            return \YES4Trade\Model\ebay_media_videos::get_by_seller($this->getSeller());
        }
        public function get_documents( ){
            return \YES4Trade\Model\ebay_media_documents::get_by_seller($this->getSeller());
        }
        
        public function db_update_video($response){
            $emv = \YES4Trade\Model\ebay_media_videos::get_by_video_id($response['videoId'], $this->getSeller());
            $emv->video_status = $response['status'];
            $emv->expirationDate = new DateTime($response['expirationDate']);
            $emv->video_description = $response['description'];
            $emv->video_title = $response['title'];
            $emv->video_thumbnail = (isset($response['thumbnail']['imageUrl']))?$response['thumbnail']['imageUrl']:'';
            $emv->update();
        }
        
        public function db_update_document($response){
            $emd = \YES4Trade\Model\ebay_media_documents::get_by_documents_id($response['documentId'], $this->getSeller());
            $emd->documentStatus = $response['documentStatus'];
            $emd->documentType = $response['documentType'];
            $emd->fileName = $response['documentMetadata']['fileName'];
            $emd->fileSize = (int)$response['documentMetadata']['fileSize'];
            $emd->fileType = $response['documentMetadata']['fileType'];
            $emd->update();
        }
        public function delete(string $id, string $type, string $seller){
            switch($type){
                case 'video':
                    $video = \YES4Trade\Model\ebay_media_videos::get_by_video_id($id, $seller);
                    if($video !== null){
                        \YES4Trade\Model\ebay_media_videos::delete($video->ebay_media_videos_id);
                    }
                    break;
                default:
                    $doc = \YES4Trade\Model\ebay_media_documents::get_by_documents_id($id, $seller);
                    if($doc !== null){
                        \YES4Trade\Model\ebay_media_documents::delete($doc->ebay_media_documents_id);
                    }
                    break;
            }
        }
        
        public static function get_documentType_name( string $documentType ){
            return constant($documentType.'_TITLE');
        }
        
}
