<?php
class ebay_variation {
    var $ebay_variations_sets_id;
    var $ebay_variations_id;
    
    function getEbay_variations_sets_id() {
        return $this->ebay_variations_sets_id;
    }

    function setEbay_variations_sets_id($ebay_variations_sets_id) {
        $this->ebay_variations_sets_id = $ebay_variations_sets_id;
    }

    function getEbay_variations_id() {
        return $this->ebay_variations_id;
    }

    function setEbay_variations_id($ebay_variations_id) {
        $this->ebay_variations_id = $ebay_variations_id;
    }

    private function loadVariations_sets_id(){
        $query = xtc_db_query(sprintf(
                "SELECT ebay_variations_sets_id FROM ebay_variations WHERE ebay_variations_id='%s'",
                $this->getEbay_variations_id()
        ));
        $record = xtc_db_fetch_array($query);
        return $record['ebay_variations_sets_id'];
    }
    
    function __construct($ebay_variations_id,$ebay_variations_sets_id){
        $this->setEbay_variations_id($ebay_variations_id);
        if($ebay_variations_sets_id <= 0){
            $this->setEbay_variations_sets_id($this->loadVariations_sets_id());
        }else{
            $this->setEbay_variations_sets_id($ebay_variations_sets_id);
        }
    }
    
    private function getVariationNameAndValue(){
        $return = array();
        $query = xtc_db_query(sprintf(
                "SELECT evss.nvl_name,evvs.nvl_value FROM ebay_variations ev LEFT JOIN ebay_variationspecificssets evss USING(ebay_variations_sets_id), ebay_variations_variationspecifics evvs WHERE ev.ebay_variations_id='%s' AND evss.variations_pictures_base=1 AND evvs.ebay_variations_id=ev.ebay_variations_id AND evvs.nvl_name=evss.nvl_name",
                $this->getEbay_variations_id()
        ));
        if(xtc_db_num_rows($query)){
            $return = xtc_db_fetch_array($query);
        }
        return $return;
    }
    
    private function getEbayVariationsPicturesIdFromName($nvl_name){
        $query = xtc_db_query(sprintf(
                "SELECT ebay_variations_pictures_id FROM ebay_variations_pictures WHERE VariationSpecificName='%s' AND ebay_variations_sets_id='%s'",
                xtc_db_prepare_input($nvl_name),$this->getEbay_variations_sets_id()
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            return $record['ebay_variations_pictures_id'];
        }
        return 0;
    }
    
    private function getEbayVariationsPicturesSetsIdFromValue($evpID,$nvl_value){
        $query = xtc_db_query(sprintf(
                "SELECT ebay_variations_pictures_sets_id FROM ebay_variations_pictures_sets WHERE ebay_variations_pictures_id='%s' AND VariationSpecificValue='%s'",
                $evpID,xtc_db_prepare_input($nvl_value)
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            return $record['ebay_variations_pictures_sets_id'];
        }
        return 0;
    }
        
    
    public function deleteVariationsetPictureAllocation(){
        $variation_info = $this->getVariationNameAndValue();
        $evpID = $this->getEbayVariationsPicturesIdFromName($variation_info['nvl_name']);
        if($evpID === 0){
            return false;
        }
        $evpsID = $this->getEbayVariationsPicturesSetsIdFromValue($evpID, $variation_info['nvl_value']);
        if($evpsID === 0){
            return false;
        }
        xtc_db_query(sprintf(
               "DELETE FROM ebay_variations_pictures_sets_urls WHERE ebay_variations_pictures_sets_id='%s'",
               $evpsID 
        ));
        xtc_db_query(sprintf(
               "DELETE FROM ebay_variations_pictures_sets WHERE ebay_variations_pictures_sets_id='%s'",
               $evpsID 
        ));
    }
    
    public function saveVariationspecifics($evssID,$val){
        $query = xtc_db_query(sprintf(
                "SELECT nvl_name FROM ebay_variationspecificssets WHERE ebay_variationspecificssets_id='%s'",
                $evssID
        ));
        $record = xtc_db_fetch_array($query);
        $insert_sql_array = array(
            'ebay_variations_id'=>$this->getEbay_variations_id(),
            'nvl_name'=>$record['nvl_name'],
            'nvl_value'=>$val
        );
        xtc_db_perform('ebay_variations_variationspecifics',$insert_sql_array);
    }
    
    private function getVariation_pictures_id($VariationSpecificName){
        $return = 0;
        $query = xtc_db_query(sprintf(
                "SELECT ebay_variations_pictures_id FROM ebay_variations_pictures WHERE VariationSpecificName='%s' AND ebay_variations_sets_id='%s'",
                $VariationSpecificName,$this->getEbay_variations_sets_id()
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            $return = $record['ebay_variations_pictures_id'];
        }
        return $return;
    }
    
    private function getVariation_pictures_sets_id($evpID,$VariationSpecificValue){
        $return = 0;
        $query = xtc_db_query(sprintf(
                "SELECT ebay_variations_pictures_sets_id FROM ebay_variations_pictures_sets WHERE VariationSpecificValue='%s' AND ebay_variations_pictures_id='%s'",
                $VariationSpecificValue,$evpID
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            $return = $record['ebay_variations_pictures_sets_id'];
        }
        return $return;
    }
    
    /**
     * Prueft ob es bei einer Variante die hinzugefuegt wird einen Eintrag gibt,
     * der das Merkmal (zb Farbe) und die Auspraegung (zb Gruen) in den Bildzu-
     * weisungen gespeichert hat
     * Wenn das nicht der Fall ist, wird eine Zuweisung erzeugt
     * 
     * @param int $evssID
     * @param string $VariationSpecificValue
     * @return boolean
     */
    public function addVariations_pictures_sets($evssID,$VariationSpecificValue){
        if($VariationSpecificValue == '' or $evssID < 1){
            return false;
        }
        $VariationSpecificName = $this->getVariationSpecificName($evssID);
        $evpID = $this->getVariation_pictures_id($VariationSpecificName);
        if($evpID == 0){
            die('Es konnte kein ebay_variations_pictures Eintrag zum Merkmal '.$VariationSpecificName.' ermittelt werden');
        }
        $evpsID = $this->getVariation_pictures_sets_id($evpID,$VariationSpecificValue);
        if($evpsID > 0){
            // Es gibt bereits einen Eintrag zu dieser Auspraegung
            return false;
        }
        $insert_sql_array = array(
            'ebay_variations_pictures_id'=>$evpID,
            'VariationSpecificValue'=>$VariationSpecificValue
        );
        xtc_db_perform('ebay_variations_pictures_sets',$insert_sql_array);
        return true;
    }
    
    private static function getVariationSpecificName($evssID){
        if($evssID < 1){
            die('missing or invalid evssID for getVariationSpecificName()');
        }
        $return = '';
        $query = xtc_db_query(sprintf(
                "SELECT nvl_name FROM ebay_variationspecificssets WHERE ebay_variationspecificssets_id='%s'",
                $evssID
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            $return = $record['nvl_name'];
        }
        return $return;
    }
    
    private static function getVariationSpecificsSetsId($name){
        if($name == ''){
            die('no nvl_name found');
        }
        $return = '';
        $query = xtc_db_query(sprintf(
                "SELECT ebay_variationspecificssets_id FROM ebay_variationspecificssets WHERE nvl_name='%s'",
                $name
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            $return = $record['ebay_variationspecificssets_id'];
        }else{
            die('No ebay_variationspecificssets_id found for '.$name);
        }
        return $return;
    }
    
    private function getVariationVariationspecificsByName($name){
        $saved_value_query = xtc_db_query(sprintf(
                "SELECT * FROM ebay_variations_variationspecifics WHERE ebay_variations_id IN(%s) AND nvl_name='%s'",
                $this->getEbay_variations_id(),
                $name
        ));
        return xtc_db_fetch_array($saved_value_query);
    }
    
    public function updateVariationspecifics($name,$value){
        // ermitteln des gespeicherten nvl_value
        $saved_value = $this->getVariationVariationspecificsByName($name);
        if(!$this->hasSetVariationsWithSameValue($name,$saved_value['nvl_value'])){
            // kein weiterer Eintrag mit der selben Auspraegung vorhanden
            $evpID = $this->getEbayVariationsPicturesIdFromName($name);
            $query = xtc_db_query(sprintf(
                    "SELECT ebay_variations_pictures_sets_id FROM ebay_variations_pictures_sets WHERE ebay_variations_pictures_id='%s' AND VariationSpecificValue='%s'",
                    $evpID,$saved_value['nvl_value']
            ));
            while($record = xtc_db_fetch_array($query)){
                $delete_records[] = $record['ebay_variations_pictures_sets_id'];
            }
            foreach($delete_records as $evpsID){
                $this->deleteVariationsPicturesSet($evpsID);
            }
        }
        $evssID = $this->getVariationSpecificsSetsId($name);
        //$this->addVariations_pictures_sets($evssID,$value);
        xtc_db_query(sprintf(
                "UPDATE ebay_variations_variationspecifics SET nvl_value='%s' WHERE nvl_name='%s' AND ebay_variations_id='%s'",
                $value,$name,$this->getEbay_variations_id()
        ));
        
    }
    
    /**
     * gibt ein Array aller VariantenID zurueck die im  Variantenset enthalten
     * sind ausser der Variante selber
     */
    private function getEbay_variations_id_array_from_variationset(){
        $return = array();
        $query = xtc_db_query(sprintf(
                "SELECT ebay_variations_id FROM ebay_variations WHERE ebay_variations_sets_id='%s' AND ebay_variations_id != %s",
                $this->getEbay_variations_sets_id(),$this->getEbay_variations_id()
        ));
        while($record = xtc_db_fetch_array($query)){
            $return[] = $record['ebay_variations_id'];
        }
        return $return;
    }
    
    private function deleteVariationsPicturesSet($evpsID){
        xtc_db_query(sprintf(
            "DELETE FROM ebay_variations_pictures_sets WHERE ebay_variations_pictures_sets_id='%s'",
            $evpsID
        ));
        xtc_db_query(sprintf(
            "DELETE FROM ebay_variations_pictures_sets_urls WHERE ebay_variations_pictures_sets_id='%s'",
            $evpsID
        ));
    }
    
    private function hasSetVariationsWithSameValue($name,$value){
        // nachschauen ob noch weitere Varianten die selbe Auspraegung haben
        $other_variations = $this->getEbay_variations_id_array_from_variationset();
        $saved_values_query = xtc_db_query(sprintf(
                "SELECT * FROM ebay_variations_variationspecifics WHERE ebay_variations_id IN(%s) AND nvl_name='%s' AND nvl_value='%s'",
                implode(',',$other_variations),
                $name,$value
        ));
        return xtc_db_num_rows($saved_values_query);
    }
}
