<?php
class storage_product {
	var $id;
	var $storage_id;
	var $products_id;
	var $quantity;
	var $created;
	var $changed;
	var $storage_place;
	var $priority;
	var $editor;
        const DB_TABLE = 'storage_products';
        
	public function getId() {
		return $this->id;
	}

	public function setId($id) {
		$this->id = $id;
	}

	public function getStorage_id() {
		return $this->storage_id;
	}

	public function setStorage_id($storage_id) {
		$this->storage_id = $storage_id;
	}

	public function getProducts_id() {
		return $this->products_id;
	}

	public function setProducts_id($products_id) {
		$this->products_id = $products_id;
	}

	public function getQuantity() {
		return $this->quantity;
	}

	public function setQuantity($quantity) {
		$this->quantity = $quantity;
	}

	public function getCreated() {
		return $this->created;
	}

	public function setCreated($created) {
		$this->created = $created;
	}

	public function getChanged() {
		return $this->changed;
	}

	public function setChanged($changed) {
		$this->changed = $changed;
	}

	public function getStorage_place() {
		return $this->storage_place;
	}

	public function setStorage_place($storage_place) {
		$this->storage_place = $storage_place;
	}

	public function getPriority() {
		return $this->priority;
	}

	public function setPriority($priority) {
		$this->priority = $priority;
	}
	public function getEditor() {
		return $this->editor;
	}

	public function setEditor($editor) {
		$this->editor = $editor;
	}

		
	function __construct($id) {
		$this->setEditor(0);
		if(isset($_SESSION['customer_id']))
			$this->setEditor($_SESSION['customer_id']);
		if($id > 0){
			$this->setId($id);
			$query = xtc_db_query(sprintf(
				"SELECT storage_id,products_id,quantity,created,changed,storage_places_id,priority FROM storage_products WHERE id=%s",
				$this->getId()
			));
			$record = xtc_db_fetch_array($query);
			if($record['storage_places_id'] > 0){
			    $record['storage_place'] = yes_get_storage_place_title($record['storage_places_id']);
			}
			$this->setChanged($record['changed']);
			$this->setCreated($record['created']);
			$this->setPriority($record['priority']);
			$this->setProducts_id($record['products_id']);
			$this->setQuantity($record['quantity']);
			$this->setStorage_id($record['storage_id']);
			$this->setStorage_place($record['storage_place']);
		}
	}
	
	function delete(){
		xtc_db_query(sprintf(
			"DELETE FROM storage_numbers WHERE id=%s",
			$this->getId()
		));
	}
	
	public function add_quantity($quantity){
		if($quantity < 1 or $this->getId() < 1){
			return false;
                }
		xtc_db_query(sprintf(
			"UPDATE storage_products SET quantity=quantity+%s WHERE id='%s'",
			$quantity,$this->getId()
		));
		$this->setQuantity($this->getQuantity()+$quantity);
		$this->log($quantity,0);
		return true;
	}
	private function log($quantity,$source){
		$insert_sql_array = array(
			'source_storage_products_id'=>$source,
			'target_storage_products_id'=>$this->getId(),
			'quantity'=>$quantity,
			'editor'=>$this->getEditor()
		);
		xtc_db_perform('storage_products_transfer',$insert_sql_array);
	}
}
