<?php
class storage_products_transfer {
	var $source_storage_products_id;
	var $target_storage_products_id;
	var $quantity;
	var $editor;
	var $history_table = 'storage_products_transfer';
	
	public function getSource_storage_products_id() {
		return $this->source_storage_products_id;
	}

	public function setSource_storage_products_id($source_storage_products_id) {
		$this->source_storage_products_id = $source_storage_products_id;
	}

	public function getTarget_storage_products_id() {
		return $this->target_storage_products_id;
	}

	public function setTarget_storage_products_id($target_storage_products_id) {
		$this->target_storage_products_id = $target_storage_products_id;
	}

	public function getQuantity() {
		return $this->quantity;
	}

	public function setQuantity($quantity) {
		$this->quantity = $quantity;
	}

	public function getEditor() {
		return $this->editor;
	}

	public function setEditor($editor) {
		$this->editor = $editor;
	}

	
	function __construct($source_storage_products_id,$target_storage_products_id) {
		if(isset($_SESSION['customer_id']))
			$this->setEditor($_SESSION['customer_id']);
		else
			$this->setEditor(0);
		$this->setSource_storage_products_id($source_storage_products_id);
		$this->setTarget_storage_products_id($target_storage_products_id);
	}
	
	public function transfer($transfer_quantity,$source_storage_qty){
		if($transfer_quantity < 1 or $transfer_quantity > $source_storage_qty){
			return false;
		}
		// Ziellagerplatz zubuchen
		xtc_db_query(sprintf(
			"UPDATE storage_products SET quantity=quantity+%s WHERE id=%s",
			$transfer_quantity,$this->getTarget_storage_products_id()
		));
		
		// Quelllager abbuchen
		xtc_db_query(sprintf(
			"UPDATE storage_products SET quantity=quantity-%s WHERE id=%s",
			$transfer_quantity,$this->getSource_storage_products_id()
		));
		$this->log($transfer_quantity);
		return true;
	}
	private function log($quantity){
		$insert_sql_array = array(
			'source_storage_products_id'=>$this->getSource_storage_products_id(),
			'target_storage_products_id'=>$this->getTarget_storage_products_id(),
			'quantity'=>$quantity,
			'editor'=>$this->getEditor()
		);
		xtc_db_perform('storage_products_transfer',$insert_sql_array);
	}
	
}
