<?php
class wemalo{
	const API_URL = 'https://connect.wemalo.com/v1';
	
	public function call( string $uri = '', string $method = 'GET', array $post_body = [], string $response_format = 'json' ){
		$uri = self::API_URL.'/'.$uri;
		$headers = ["Authorization: JWT ".MODULE_SHIPPING_WEMALO_KEY];
		if(sizeOf($post_body)){
			$body = json_encode($post_body);
			$headers[] = 'Content-Type: application/json';
		}
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $uri);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		if($method == 'DELETE' or $method == 'PATCH'){
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
//                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		}
		if(sizeOf($post_body) or $method == 'DELETE'){
                    if($method != 'DELETE'){
			curl_setopt($ch, CURLOPT_POST, 1);
                    }
                    curl_setopt($ch, CURLOPT_POSTFIELDS,
                            $body
                    );
                    curl_setopt($ch, CURLOPT_HEADER, 1);
                    curl_setopt($ch, CURLINFO_HEADER_OUT, 1);
		}
		$response = curl_exec($ch);
		$info = curl_getinfo( $ch );
                /*
		switch($info['http_code']){
			case 200:
				if( $response_format == 'json'){
					return json_decode($response);
				}
		}*/
                if($r = json_decode($response)){
                    return $r;
                }
                $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
                $body = substr($response, $header_size);
                return json_decode($body);
	}
	
	public function goodsOrderProfiles(){
		$uri = 'goodsOrder/profiles';
		return $this->call( $uri );
	}
	
	public function goodsOrderAdd( $data ){
		$uri = 'goodsOrder/add';
		return $this->call( $uri, 'POST', $data );
	}
	
	public function goodsOrderGetStatus($id){
		$uri = 'goodsOrder/getStatus/'.$id;
		return $this->call( $uri );
	}
	
	public function goodsOrderGetOrdersStatus( $status_id ){
		$uri = 'goodsOrder/getOrdersStatus/'.$status_id;
		return $this->call( $uri );
	}
        
        public function dummyPAdd( $pID, $name, $desc, $sku ){
            $add_product_obj = [
                "externalId" => $pID,
                "name" => $name,
                "description" => $desc,
                "volume" => 5.3,
                "sku" => $sku,
                "productGroup"=>"0815Group",
            ];
            $uri = 'product/add';
            return $this->call( $uri, 'POST',$add_product_obj );
        }
        
        public function getAllProducts(){
            $uri = '/product/getAll?fromDate='.date('Y-m-d');
            return $this->call( $uri );
        }
        
        public function getGoodsOrders($statusId){
            $uri = '/goodsOrder/getOrdersStatus/'.$statusId;
            return $this->call( $uri );
        }
        
        public function getGoodsOrderStatus($id){
            $uri = '/goodsOrder/getStatus/'.$id;
            return $this->call( $uri );
        }
        
        public function getSentPackages( $date_from = ''){
            $uri = '/goodsOrder/sentPackages';
            if($date_from != '' ){
                $uri .= '?dateFrom='.urlencode($date_from).'&dateTo='.urlencode(date('d.m.Y H:i:s'));
            }
            return $this->call( $uri );
        }
        
        public static function get_submitted_items(){
            $return = [];
            $query = xtc_db_query("SELECT * FROM wemalo WHERE submitted=1 AND wemalo_status=0");
            while($record = xtc_db_fetch_array($query)){
                $return[] = $record;
            }
            return $return;
        }
        
        public function addGoodsOrderPosition( $id, $data ){
            $uri = '/goodsOrder/addPosition/'.$id;
            return $this->call( $uri, 'POST',$data,'' );
        }
        
        public function getOrderPackages($id){
            $uri = '/goodsOrder/packages/?externalOrderId='.$id;
            return $this->call( $uri );
        }
        
        public function getTrackingNumber( string $parcelID ){
            $uri = '/goodsOrder/package/'.$parcelID.'/trackingNumber';
            return $this->call( $uri );
        }
        
        public function getWebHooks(){
            $uri = '/webhook';
            return $this->call( $uri );
        }
        
        public function registerWebHook($event){
            $uri = '/webhook/'.$event;
            $dom = (defined('HTTP_SERVER')) ? HTTP_SERVER : HTTP_CATALOG_SERVER;
            $data = [
                'payload'=>$dom.'callback/wemalo.php?event='.$event,
                'event'=>$event,
                'token'=>MODULE_SHIPPING_WEMALO_KEY,
                'email'=>EMAIL_SUPPORT_ADDRESS,
            ];
            return $this->call( $uri, 'POST',$data,'' );
        }
        
        public function deleteWebHook($event){
            $uri = '/webhook/'.$event;
            $data = [
                'event'=>$event,
            ];
            return $this->call( $uri, 'DELETE',$data );
        }
        
        public static function is_wemalo_order( int $orders_id ){
            $query = xtc_db_query(sprintf(
                    "SELECT s.id FROM shippings s LEFT JOIN wemalo w ON w.shipping_id=s.id WHERE s.orders_id='%d'",
                    $orders_id
            ));
            return (xtc_db_num_rows($query)) ? true : false;
        }
}
/*
$wemalo = new wemalo;
$p = $wemalo->goodsOrderProfiles();
foreach($p->dispatcher as $dsp){
	printf("%s (%d Profile)\n", $dsp->name, sizeOf($dsp->profiles));
	foreach($dsp->profiles as $prf){
		printf("\t%s (#%s) %s\n", $prf->name,$prf->id, (($prf->product !='')?' '.$prf->product:''));
	}
}
//print_r($p);
exit;

$data = ['meta' => 
	[
	       "externalId" => "EXT-SN-2",
	       "shippingFee" => 33,
	       "discount" => 9,
	       "receiver" =>
	       [
		   [
		       "name1"=> "4e software solution GmbH",
		       "name2"=> "Hr. Testmann",
		       "name3"=> "",
		       "street"=> "Unter den Eichen 4",
		       "streetNumber"=> "",
		       "addressAddition"=> "",
		       "countryCode2Letter"=> "DE",
		       "city"=> "Wiesbaden",
		       "zip"=> "65195",
		       "stateProvinceCountry"=> "",
		       "phoneNumber"=> "",
		       "email"=> "v@x.de",
		       "customerNumber"=> "1121bD"
		   ]
	       ],
	],
       "positions" => [
		[
			"externalId"=> "0815",
			"quantity"=> 1,
			"externalPositionIdentifier"=> "0815"
		]
	]
];

print_r($wemalo->goodsOrderGetOrdersStatus(500));

exit;
$uri = 'goodsOrder/getStatus/EXT-SN-1';



$uri = 'goodsOrder/add';
//$uri = 'product/add';

$uri = 'goodsOrder/getStatus/EXT-SN-1';


$add_product_obj = [
    "externalId" => "0815",
    "name" => "sample product",
    "description" => "a 0815 sample product",
    "volume" => 5.3,
    "sku" => "SKU0815",
    "productGroup"=>"0815Group",
];
*/