<?php
//Enable WSDL Caching
ini_set('soap.wsdl_cache_enabled', '1'); //NB 1.01
//Set Cache Time to 1 Day 
ini_set('soap.wsdl_cache_ttl', '86400'); //NB 1.01

class yes_dhl_api {
    const STANDORTSUCHE_OPERATIONS = array(
        'getPackstationsByAddress',
        //Mit dieser Funktion werden Packstationen im Umkreis von 15 km um die angegebene Adresse gefunden.
        'getPackstationsByCoordinate',
        //Mit dieser Funktion werden Packstationen im Umkreis von 15 km um die angegebene Koordinate gefunden.
        'getPaketboxesByAddress',
        //Mit dieser Funktion werden Paketboxen im Umkreis von 15 km um die angegebene Adresse gefunden.
        'getPaketboxesByCoordinate',
        //Mit dieser Funktion werden Paketboxen im Umkreis von 15 km um die angegebene Koordinate gefunden.
        'getPackstationsPaketboxesByAddress',
        //Mit dieser Funktion werden Packstationen und Paketboxen im Umkreis von 15 km um die angegebene Adresse gefunden.
        'getPackstationsPaketboxesByCoordinate',
        //Mit dieser Funktion werden Packstationen und Paketboxen im Umkreis von 15 km um die angegebene Koordinate gefunden.
        'getPackstationsFilialeDirektByAddress',
        //Mit dieser Funktion werden Postfiliale Direkt-Filialen und Packstationen im Umkreis von 15 km um die angegebene Adresse gefunden.
        'getPackstationsFilialeDirektByCoordinate',
        //Mit dieser Funktion werden Postfiliale Direkt-Filialen und Packstationen im Umkreis von 15 km um die angegebene Koordinate gefunden.
        'getBranchesByAddress',
        //Mit dieser Funktion werden Filialen im Umkreis von 15 km um die angegebene Adresse gefunden.
        'getBranchesByCoordinate'
        //Mit dieser Funktion werden Filialen im Umkreis von 15 km um die angegebene Koordinate gefunden.
    );
    
    const STANDORTSUCHE_AUTOMATTYPE = array(
        '4'=>'Packstation'
    );
    
    var $secure_label_path;
    var $errors = array();
    var $dhl_product;
    var $accountNumber;
    var $customerReference;
    var $shipmentDate;
    var $weightInKG;
    var $recipientEmailAddress;
    var $rec_packstationNumber;
    var $rec_postNumber;
    var $rec_suburb;
    var $rec_street_address;
    var $rec_zip;
    var $rec_city;
    var $rec_countryISOCode;
    var $rec_postfilialNumber;
    var $rec_company;
    var $rec_name;
    var $rec_phone;
    var $paketklasse;
    var $nachnahme;
    var $sperrgut;
    var $order_payment_method;
    var $cod_amount;
    var $PreferredLocation;
    var $NoNeighbourDelivery;
    var $PreferredNeighbour;
    var $PreferredDay;
    var $PreferredTime;
    var $SameDayDelivery;
    var $VisualCheckOfAge;
    var $Endorsement;
    var $ParcelOutletRouting;
    
    function getParcelOutletRouting() {
        return $this->ParcelOutletRouting;
    }

    function setParcelOutletRouting($ParcelOutletRouting): void {
        $this->ParcelOutletRouting = $ParcelOutletRouting;
    }

    function getSameDayDelivery(){
        return $this->SameDayDelivery;
    }
    
    function setSameDayDelivery($value){
        $this->SameDayDelivery = $value;
    }
    
    function getPreferredTime(){
        return $this->PreferredTime;
    }
    
    function setPreferredTime($value){
        $this->PreferredTime = $value;
    }
    
    function getPreferredDay(){
        return $this->PreferredDay;
    }
    
    function setPreferredDay($value){
        $this->PreferredDay = $value;
    }
    
    function getPreferredNeighbour(){
        return $this->PreferredNeighbour;
    }
    
    function setPreferredNeighbour($value){
        $this->PreferredNeighbour = $value;
    }
    
    function getNoNeighbourDelivery(){
        return $this->NoNeighbourDelivery;
    }
    
    function setNoNeighbourDelivery($value){
        $this->NoNeighbourDelivery = $value;
    }
    
    function getPreferredLocation(){
        return $this->PreferredLocation;
    }
    
    function setPreferredLocation($value){
        $this->PreferredLocation = $value;
    }
    
    function getRec_phone() {
        return $this->rec_phone;
    }

    function setRec_phone($rec_phone) {
        $this->rec_phone = str_replace(array('/',' ','-','\.',':'),'',$rec_phone);
    }

    function getRec_company() {
        return $this->rec_company;
    }

    function getRec_name() {
        return $this->rec_name;
    }

    function setRec_company($rec_company) {
        $this->rec_company = $rec_company;
    }

    function setRec_name($rec_name) {
        $this->rec_name = $rec_name;
    }

    function getRec_street_address() {
        return $this->rec_street_address;
    }

    function setRec_street_address($rec_street_address) {
        $this->rec_street_address = str_replace(',','.',$rec_street_address);
    }

    function getRec_suburb() {
        return $this->rec_suburb;
    }

    function setRec_suburb($rec_suburb) {
        $this->rec_suburb = str_replace(',','.',$rec_suburb);
    }

    function getRec_packstationNumber() {
        return $this->rec_packstationNumber;
    }

    function getRec_postNumber() {
        return $this->rec_postNumber;
    }

    function getRec_zip() {
        return trim($this->rec_zip);
    }

    function getRec_city() {
        return $this->rec_city;
    }

    function getRec_countryISOCode() {
        return $this->rec_countryISOCode;
    }

    function getRec_postfilialNumber() {
        return $this->rec_postfilialNumber;
    }

    function setRec_packstationNumber($rec_packstationNumber) {
        $this->rec_packstationNumber = $rec_packstationNumber;
    }

    function setRec_postNumber($rec_postNumber) {
        $this->rec_postNumber = $rec_postNumber;
    }

    function setRec_zip($rec_zip) {
        $this->rec_zip = trim($rec_zip);
    }

    function setRec_city($rec_city) {
        $this->rec_city = $rec_city;
    }

    function setRec_countryISOCode($rec_countryISOCode) {
        $this->rec_countryISOCode = $rec_countryISOCode;
    }

    function setRec_postfilialNumber($rec_postfilialNumber) {
        $this->rec_postfilialNumber = $rec_postfilialNumber;
    }

    function getRecipientEmailAddress() {
        return $this->recipientEmailAddress;
    }

    function setRecipientEmailAddress($recipientEmailAddress) {
        $this->recipientEmailAddress = $recipientEmailAddress;
    }

    function getWeightInKG() {
        return $this->weightInKG;
    }

    function setWeightInKG($weightInKG) {
        $this->weightInKG = $weightInKG;
    }

    function getShipmentDate() {
        return $this->shipmentDate;
    }

    function setShipmentDate($shipmentDate) {
        $this->shipmentDate = $shipmentDate;
    }

    function getCustomerReference() {
        return $this->customerReference;
    }

    function setCustomerReference($customerReference) {
        $this->customerReference = $customerReference;
    }

    
    function getAccountNumber() {
        return $this->accountNumber;
    }

    function setAccountNumber($accountNumber) {
        $this->accountNumber = $accountNumber;
    }

    function getDhl_product() {
        return $this->dhl_product;
    }

    function setDhl_product($dhl_product) {
        $this->dhl_product = $dhl_product;
    }

    function getSecure_label_path() {
        return $this->secure_label_path;
    }

    function setSecure_label_path($secure_label_path) {
        $this->secure_label_path = $secure_label_path;
    }
    
    function getErrors() {
        return $this->errors;
    }

    function setErrors($errors) {
        $this->errors = $errors;
    }

    function add_error($str){
        $this->errors[] = $str;
    }
    function getPaketklasse() {
        return $this->paketklasse;
    }

    function getNachnahme() {
        return $this->nachnahme;
    }

    function getSperrgut() {
        return $this->sperrgut;
    }

    function setPaketklasse($paketklasse) {
        $this->paketklasse = $paketklasse;
    }

    function setNachnahme($nachnahme) {
        $this->nachnahme = $nachnahme;
    }

    function setSperrgut($sperrgut) {
        $this->sperrgut = $sperrgut;
    }
    function getOrder_payment_method() {
        return $this->order_payment_method;
    }

    function setOrder_payment_method($order_payment_method) {
        $this->order_payment_method = $order_payment_method;
    }
    
    function getCod_amount() {
        return $this->cod_amount;
    }

    function setCod_amount($cod_amount) {
        $this->cod_amount = $cod_amount;
    }

    function getVisualCheckOfAge() {
        return $this->VisualCheckOfAge;
    }

    function setVisualCheckOfAge($VisualCheckOfAge){
        $this->VisualCheckOfAge = $VisualCheckOfAge;
    }

    function getEndorsement() {
        return $this->Endorsement;
    }

    function setEndorsement($Endorsement){
        $this->Endorsement = $Endorsement;
    }

    function __construct(){
        global $secure_path;
        if(!$this->check_environment($secure_path)){
            return false;
        }
        $this->setSecure_label_path($this->get_label_secure_path($secure_path));
    }
    
    private function get_label_secure_path($secure_path){
        return $secure_path.DIRECTORY_SEPARATOR.'DHL_label';
    }
    
    public function get_street_parts($street_and_number){
        //Strassenname und Hausnummer trennen
        $receiver_street_raw = str_replace('.', '. ',trim(substr($street_and_number,0,40)));
        $look_for="0123456789";
        $nrpos = $this->find_first_of($receiver_street_raw,$look_for,0);

        //neue Hausnummernermittlung
        if (preg_match("/[0-9\,]+[a-zA-Z]*[-,\/]*[0-9]*[a-zA-Z]*/", $receiver_street_raw, $matches)) {
            $receiver_streetnumber=$matches[0];
            $receiver_streetname=trim(str_replace($receiver_streetnumber,'', $receiver_street_raw));
            $receiver_streetnumber=trim($receiver_streetnumber,'.-, ');
        }else {  
            //alte Variante als Fallback
            $receiver_streetname = trim(substr($receiver_street_raw, 0, $nrpos));
            $receiver_streetnumber = trim(substr($receiver_street_raw, $nrpos));   
        }
        return array(
            'street'=>$receiver_streetname,
            'number'=>$receiver_streetnumber
        );
    }
    
    public function activate_services_one_click(&$dhl_xml,$display_services,$orders_id = Null){
        foreach($display_services as $service) {
            switch($service) {
                    case 'AdditionalInsurance': //Transportversicherung
                        $cod_amount = $this->get_cod_amount($orders_id);
                        if ($cod_amount > 500) {
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']='1';
                            $insuranceAmount=preg_replace('/[^0-9.,]/','',$cod_amount);
                            $insuranceAmount=str_replace(',','.',$insuranceAmount);
                            $insuranceAmount=number_format($insuranceAmount,'2','.','');
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['insuranceAmount']=$insuranceAmount;
                        } else {
                            //$dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']='0';
                        }
                        break;

                    case 'CashOnDelivery': //Nachnahme
                        $cod_amount = $this->get_cod_amount($orders_id,true);
                        if ($cod_amount > 0) {
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']='1';
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->CashOnDelivery['codAmount']=$cod_amount;
                            //Bankdaten
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->BankData->accountOwner=MODULE_SHIPPING_DHLGKAPI_BANKDATA_ACCOUNTOWNER;
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->BankData->bankName=MODULE_SHIPPING_DHLGKAPI_BANKDATA_BANKNAME;
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->BankData->iban=MODULE_SHIPPING_DHLGKAPI_BANKDATA_IBAN;
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->BankData->bic=MODULE_SHIPPING_DHLGKAPI_BANKDATA_BIC; 
                        } else {
                            //$dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']='0'; 
                        }
                        break;

                    case 'VisualCheckOfAge':
                        if ($this->getVisualCheckOfAge() != '') {
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']='1';
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['type']=$this->getVisualCheckOfAge();
                        } else {
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']='0'; 
                        }
                        break;
                    case 'BulkyGoods':
                        if($this->getSperrgut() == $service){
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']='1';
                        }
                        break;
                    case 'Endorsement':
                        $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->Endorsement['active']='1';
                        $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->Endorsement['type']=$this->getEndorsement();
                        break;
            }
        }
    }
    public function activate_services(&$dhl_xml,$display_services,$orders_id = Null){
        //Services aktivieren
        foreach($display_services as $service) {
            if (isset($_GET[$service])){
                if($service!='PrintOnlyIfCodeable' && $service!='Return') {
                    $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']='1';
                }

                switch($service) {
                    case 'PrintOnlyIfCodeable':  //Nur Label, wenn leitcodierbar
                        $dhl_xml->ShipmentOrder->PrintOnlyIfCodeable['active']=isset($_GET['PrintOnlyIfCodeable'])?'1':'0';
                        break;

                    case 'AdditionalInsurance': //Transportversicherung
                        if (isset($_GET['insuranceAmount']) && $_GET['insuranceAmount']!='' && $_GET['insuranceAmount'] > 0){
                            $insuranceAmount=preg_replace('/[^0-9.,]/','',$_GET['insuranceAmount']);
                            $insuranceAmount=str_replace(',','.',$insuranceAmount);
                            $insuranceAmount=number_format($insuranceAmount,'2','.','');
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['insuranceAmount']=$insuranceAmount;
                        } else {
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']='0';
                        }
                        break;

                    case 'CashOnDelivery': //Nachnahme
                        $cod_amount = $this->get_cod_amount($orders_id);
                        if ($cod_amount > 0) {
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->CashOnDelivery['codAmount']=$cod_amount;
                            //Bankdaten
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->BankData->accountOwner=MODULE_SHIPPING_DHLGKAPI_BANKDATA_ACCOUNTOWNER;
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->BankData->bankName=MODULE_SHIPPING_DHLGKAPI_BANKDATA_BANKNAME;
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->BankData->iban=MODULE_SHIPPING_DHLGKAPI_BANKDATA_IBAN;
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->BankData->bic=MODULE_SHIPPING_DHLGKAPI_BANKDATA_BIC; 
                        } else {
                                $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']='0'; 
                        }
                        break;

                    case 'VisualCheckOfAge':
                        if (isset($_GET['VisualCheckOfAge']) && $_GET['VisualCheckOfAge']==1) {
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']='1';
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['type']=$_GET['VisualCheckOfAgeType'];
                        } else {
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']='0'; 
                        }
                        break;
                    case 'BulkyGoods':
                        if(isset($_GET['BulkyGoods']) and $_GET['BulkyGoods'] != ''){
                            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']='1';
                        }
                        break;
                    case 'Endorsement':
                        $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->Endorsement['active']='1';
                        $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->Endorsement['type']=$_GET['Endorsement'];
                        break;
                } 
            }
        }
    }
    
    public function activate_wunschpaket(&$dhl_xml,$wunschpaket_services){
        //Wunschpaket Services aktivieren
        foreach($wunschpaket_services as $id => $service) {
            if (isset($_GET[$service]) && $_GET[$service]!='' ) {
                $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']='1';
                if ($id=='PT') {
                   $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['type']=$_GET[$service]; 
                } else {
                   $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['details']=$_GET[$service]; 
                }
            }
        }
    }
    
    public function activate_packstation(&$dhl_xml){
        if (preg_match("/[0-9]{6}/", $this->getRec_suburb()) or preg_match("/Postfiliale/i", $this->getRec_street_address()) or preg_match("/Packstation/i", $this->getRec_street_address())) {
            //Packstation
            if (preg_match("/Packstation/i", $this->getRec_street_address())) {
                $dhl_xml->ShipmentOrder->Shipment->Receiver->Packstation->packstationNumber=preg_replace('/[^0-9]/','',$this->getRec_street_address());
                $dhl_xml->ShipmentOrder->Shipment->Receiver->Packstation->postNumber=preg_replace('/[^0-9]/','',$this->getRec_suburb());
                $dhl_xml->ShipmentOrder->Shipment->Receiver->Packstation->zip=$this->getRec_zip();
                $dhl_xml->ShipmentOrder->Shipment->Receiver->Packstation->city=$this->getRec_city();
                $dhl_xml->ShipmentOrder->Shipment->Receiver->Packstation->Origin->countryISOCode=$this->getRec_countryISOCode();
                if($dhl_xml->ShipmentOrder->Shipment->Receiver->Packstation->postNumber != ''){
                    $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Notification->recipientEmailAddress=$this->getRecipientEmailAddress();
                }
                unset($dhl_xml->ShipmentOrder->Shipment->Receiver->Address);
            }
            //Postfiliale
            if (preg_match("/Postfiliale/i", $this->getRec_street_address())) {
                $dhl_xml->ShipmentOrder->Shipment->Receiver->Postfiliale->postfilialNumber=preg_replace('/[^0-9]/','',$this->getRec_street_address());
		$postNumber = preg_replace('/[^0-9]/','',$this->getRec_suburb());
                $dhl_xml->ShipmentOrder->Shipment->Receiver->Postfiliale->postNumber=$postNumber;
                $dhl_xml->ShipmentOrder->Shipment->Receiver->Postfiliale->zip=$this->getRec_zip();
                $dhl_xml->ShipmentOrder->Shipment->Receiver->Postfiliale->city=$this->getRec_city();
                $dhl_xml->ShipmentOrder->Shipment->Receiver->Postfiliale->Origin->countryISOCode=$this->getRec_countryISOCode();
		// email immer uebergeben 07/2020
                //if($postNumber != ''){
                    $dhl_xml->ShipmentOrder->Shipment->Receiver->Communication->email=$this->getRecipientEmailAddress();
                //}
                unset($dhl_xml->ShipmentOrder->Shipment->Receiver->Address);
            }
        }
        //Parcelshop
        if (preg_match("/Paketshop|Parcelshop/i", $this->getRec_street_address())) {
            $dhl_xml->ShipmentOrder->Shipment->Receiver->ParcelShop->parcelShopNumber=preg_replace('/[^0-9]/','',$this->getRec_suburb());
            $street_parts = $this->get_street_parts($this->getRec_street_address());
            $dhl_xml->ShipmentOrder->Shipment->Receiver->ParcelShop->streetName=$street_parts['street'];
            $dhl_xml->ShipmentOrder->Shipment->Receiver->ParcelShop->streetNumber=$street_parts['number'];
            $dhl_xml->ShipmentOrder->Shipment->Receiver->ParcelShop->zip=$this->getRec_zip();
            $dhl_xml->ShipmentOrder->Shipment->Receiver->ParcelShop->city=$this->getRec_city();
            $dhl_xml->ShipmentOrder->Shipment->Receiver->ParcelShop->Origin->countryISOCode=$this->getRec_countryISOCode();
            // TICKET 3428
            // $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Notification->recipientEmailAddress=$this->getRecipientEmailAddress();
            $dhl_xml->ShipmentOrder->Shipment->Receiver->Communication->email = $this->getRecipientEmailAddress();
            unset($dhl_xml->ShipmentOrder->Shipment->Receiver->Address);
        }
    }
    
    public function activate_retoure(&$dhl_xml,$dhl_type){
        //Retourelabel
        if (MODULE_SHIPPING_DHLGKAPI_RETURN_ENABLED=='True' && isset($_GET['Return'])) {
            if (constant('MODULE_SHIPPING_DHLGKAPI_'.$dhl_type.'_RETOURE_ATTENDANCE')!='0') {
                $retoure_products=unserialize(MODULE_SHIPPING_DHLGKAPI_RETOURE_PRODUCTS);
                $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->returnShipmentAccountNumber=MODULE_SHIPPING_DHLGKAPI_EKP.$retoure_products[$dhl_type].constant('MODULE_SHIPPING_DHLGKAPI_'.$dhl_type.'_RETOURE_ATTENDANCE');

                $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->returnShipmentReference=$this->getCustomerReference();

                $dhl_xml->ShipmentOrder->Shipment->ReturnReceiver->Name->name1=MODULE_SHIPPING_DHLGKAPI_RETURN_NAME;
                $dhl_xml->ShipmentOrder->Shipment->ReturnReceiver->Address->streetName=MODULE_SHIPPING_DHLGKAPI_RETURN_STREETNAME;
                $dhl_xml->ShipmentOrder->Shipment->ReturnReceiver->Address->streetNumber=MODULE_SHIPPING_DHLGKAPI_RETURN_STREETNUMBER;
                $dhl_xml->ShipmentOrder->Shipment->ReturnReceiver->Address->zip=trim(MODULE_SHIPPING_DHLGKAPI_RETURN_ZIP);
                $dhl_xml->ShipmentOrder->Shipment->ReturnReceiver->Address->city=MODULE_SHIPPING_DHLGKAPI_RETURN_CITY;
                $dhl_xml->ShipmentOrder->Shipment->ReturnReceiver->Address->Origin->countryISOCode=MODULE_SHIPPING_DHLGKAPI_RETURN_COUNTRY;
                $dhl_xml->ShipmentOrder->Shipment->ReturnReceiver->Communication->phone=MODULE_SHIPPING_DHLGKAPI_CONTACT_PHONE;
                $dhl_xml->ShipmentOrder->Shipment->ReturnReceiver->Communication->contactPerson=MODULE_SHIPPING_DHLGKAPI_CONTACT_PERSON;
            }  
        } else {
            unset($dhl_xml->ShipmentOrder->Shipment->ReturnReceiver);
        }
    }

    public function activate_zolldaten(&$dhl_xml,$orders_id = Null, float $shipping_costs = 0){
        //Zolldaten
        if (!in_array($this->getRec_countryISOCode(),explode(',',MODULE_SHIPPING_DHLGKAPI_EU_COUNTRIES))) {
            $additionalFee = 0;
            if(isset($_GET['additionalFee'])){
                $additionalFee = str_replace(',','.',$_GET['additionalFee']);
            }
            $dhl_xml->ShipmentOrder->Shipment->ExportDocument=(object) array(
                'invoiceNumber' => ($orders_id !== Null) ? $orders_id : '',
                'exportType' => 'OTHER',
                'exportTypeDescription' => 'Permanent',
                'termsOfTrade' => 'DDU', // scheint standard zu sein?
                'placeOfCommital' => MODULE_SHIPPING_DHLGKAPI_SHIPPER_CITY,
                'additionalFee' => $additionalFee
            );

            $dhl_xml->ShipmentOrder->Shipment->ExportDocument->ExportDocPosition=(object) array(
                'description' => 'ExportPositionOne',
                'countryCodeOrigin' => MODULE_SHIPPING_DHLGKAPI_SHIPPER_COUNTRY,
                'customsTariffNumber' => $_GET['customsTariffNumber'],
                'amount' => '1',
                'netWeightInKG' => str_replace(',','.',$_GET['netWeightInKG']),
                'customsValue' => str_replace(',','.',$_GET['customsValue'])
            );
        }
    }

    public function activate_zolldaten_one_click(&$dhl_xml,$dhl_weight,$orders_id = Null, float $shipping_costs = 0){
        //Zolldaten
        if (!in_array($this->getRec_countryISOCode(),explode(',',MODULE_SHIPPING_DHLGKAPI_EU_COUNTRIES))) {
            $dhl_xml->ShipmentOrder->Shipment->ExportDocument=(object) array(
                'invoiceNumber' => ($orders_id !== Null) ? $orders_id : '',
                'exportType' => 'OTHER',
                'exportTypeDescription' => 'Permanent',
                'termsOfTrade' => 'DDU',
                'placeOfCommital' => MODULE_SHIPPING_DHLGKAPI_SHIPPER_CITY,
//                'additionalFee' => 0,
                // falls mal die Versandkosten als additionalFee uebergeben
                // werden sollen
                'additionalFee' => number_format($shipping_costs,2,'.','')
            );

            $dhl_xml->ShipmentOrder->Shipment->ExportDocument->ExportDocPosition=(object) array(
                'description' => 'ExportPositionOne',
                'countryCodeOrigin' => MODULE_SHIPPING_DHLGKAPI_SHIPPER_COUNTRY,
                'customsTariffNumber' => '',
                'amount' => '1',
                'netWeightInKG' => str_replace(',','.',($dhl_weight - SHIPPING_BOX_WEIGHT)),
                'customsValue' => str_replace(',','.',$this->get_cod_amount($orders_id))
            );
        }
    }
    
    private function check_environment($secure_path){
        if(!isset($secure_path)){
            $this->add_error('unknown secure_path');
            return false;
        }
        $secure_label_path = $this->get_label_secure_path($secure_path);
        if(!is_dir($secure_label_path)){
            mkdir($secure_label_path);
        }
        if(!strstr(HTTP_SERVER,'localhost') and !is_writable($secure_label_path)){
            $this->add_error('secure_path for labels is not writable');
            return false;
        }
        if(!defined('DHL_VERSENDEN_APPLICATION_ID') or DHL_VERSENDEN_APPLICATION_ID == ''){
            $this->add_error('DHL Versenden is not configured');
            return false;
        }
        $needed_classes = array('order','reclamation');
        foreach($needed_classes as $nc){
            if(!class_exists($nc)){
                $this->add_error('Missing class '.$nc);
                return false;
            }
        }
        $needed_functions = array(
            'yes_get_sha1_from_string'
        );
        foreach($needed_functions as $nf){
            if(!function_exists($nf)){
                $this->add_error('Missing function '.$nf);
                return false;
            }
        }
        return true;
    }
    
    public static function find_first_of($haystack, $needlesAsString, $offset=0){
        $max = strlen($needlesAsString);
        $index = strlen($haystack)+1;
        for($ii=0; $ii<$max;$ii++){
            $result = strpos($haystack,$needlesAsString[$ii], $offset);
            if( $result !== FALSE  && $result < $index)
                $index = $result;
        }
        return ( $index > strlen($haystack)? FALSE: $index);
    }
    public function build_xml($sequence_number){
        $obj_def_addr = [
            'Name'=>[
                'name1'=>'',
                'name2'=>'',// geraten
                'name3'=>'',// geraten
            ],
            'Address'=>[
                'streetName'=>'',
                'streetNumber'=>'',
                'zip'=>'',
                'city'=>'',
                'Origin'=>[
                    'countryISOCode'=>'',
                ],
                'addressAddition'=>''
            ],
            'Communication'=>[
                'phone'=>'',
                'contactPerson'=>'',
                'email'=>''
            ]
        ];

        $obj_def = [
            'Version'=>['majorRelease'=>0,'minorRelease'=>0],
            'ShipmentOrder' => [
                'Shipment' => [
                    'ShipmentDetails'=>[
                        'product'=>'',
                        'ShipmentItem'=>[
                            'weightInKg'=>0
                        ],
                        'returnShipmentReference'=>'',
                        'returnShipmentAccountNumber'=>'',
                        'Service'=>[
                            'ParcelOutletRouting'=>[]
                        ]
                    ],
                    'Shipper'=>$obj_def_addr,
                    'Receiver'=>$obj_def_addr,
                ]
            ]
        ];
        $dhl_xml = json_decode(json_encode($obj_def),false);
        $dhl_xml->Version->majorRelease=2;
        $dhl_xml->Version->minorRelease=0;
        $dhl_xml->ShipmentOrder->sequenceNumber=$sequence_number;
        $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->product=$this->getDhl_product();
        $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->accountNumber=$this->getAccountNumber();
        $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->customerReference=$this->getCustomerReference();
        $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->shipmentDate=$this->getShipmentDate();
        $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->ShipmentItem->weightInKG=$this->getWeightInKG();
// BOF - TICKET 3428        
//        if (MODULE_SHIPPING_DHLGKAPI_DHL_EMAIL_ENABLED=='True') {
//            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Notification->recipientEmailAddress = $this->getRecipientEmailAddress();
//        }
        if(STORE_OWNER_EMAIL_ADDRESS != $this->getRecipientEmailAddress()){
            $dhl_xml->ShipmentOrder->Shipment->Shipper->Communication->email = STORE_OWNER_EMAIL_ADDRESS;
        }
        if(empty($this->getRecipientEmailAddress())){
            unset($dhl_xml->ShipmentOrder->Shipment->Receiver->Communication->email);
        }else{
            $dhl_xml->ShipmentOrder->Shipment->Receiver->Communication->email = $this->getRecipientEmailAddress();
        }
// EOF - TICKET 3428        
// 
        //Absenderadresse
        $dhl_xml->ShipmentOrder->Shipment->Shipper->Name->name1=MODULE_SHIPPING_DHLGKAPI_SHIPPER_NAME;
        $dhl_xml->ShipmentOrder->Shipment->Shipper->Address->streetName=MODULE_SHIPPING_DHLGKAPI_SHIPPER_STREETNAME;
        $dhl_xml->ShipmentOrder->Shipment->Shipper->Address->streetNumber=MODULE_SHIPPING_DHLGKAPI_SHIPPER_STREETNUMBER;
        $dhl_xml->ShipmentOrder->Shipment->Shipper->Address->zip=trim(MODULE_SHIPPING_DHLGKAPI_SHIPPER_ZIP);
        $dhl_xml->ShipmentOrder->Shipment->Shipper->Address->city=MODULE_SHIPPING_DHLGKAPI_SHIPPER_CITY;
        $dhl_xml->ShipmentOrder->Shipment->Shipper->Address->Origin->countryISOCode=MODULE_SHIPPING_DHLGKAPI_SHIPPER_COUNTRY;

        $dhl_xml->ShipmentOrder->Shipment->Shipper->Communication->phone=MODULE_SHIPPING_DHLGKAPI_CONTACT_PHONE;
        $dhl_xml->ShipmentOrder->Shipment->Shipper->Communication->contactPerson=MODULE_SHIPPING_DHLGKAPI_CONTACT_PERSON;
        
        if ($this->getRec_company() != '') {
            $dhl_xml->ShipmentOrder->Shipment->Receiver->name1=$this->getRec_company();
            $dhl_xml->ShipmentOrder->Shipment->Receiver->Communication->contactPerson=$this->getRec_name();
        } else {
            $dhl_xml->ShipmentOrder->Shipment->Receiver->name1=$this->getRec_name();
        }
        $dhl_xml->ShipmentOrder->Shipment->Receiver->Address->addressAddition=$this->getRec_suburb();
        $street_parts = $this->get_street_parts($this->getRec_street_address());
        $dhl_xml->ShipmentOrder->Shipment->Receiver->Address->streetName=$street_parts['street'];
        $dhl_xml->ShipmentOrder->Shipment->Receiver->Address->streetNumber=$street_parts['number'];
        // WENN DIE SUBURB KEINE PACKSTATION IST, DANN EINFUEGEN
        if ($this->getRec_suburb() != '' and !preg_match("/[0-9]{6}/", $this->getRec_suburb())) {
            $dhl_xml->ShipmentOrder->Shipment->Receiver->name3=$this->getRec_suburb();
        }
        $dhl_xml->ShipmentOrder->Shipment->Receiver->Address->zip=$this->getRec_zip();
        $dhl_xml->ShipmentOrder->Shipment->Receiver->Address->city=$this->getRec_city();
        $dhl_xml->ShipmentOrder->Shipment->Receiver->Address->Origin->countryISOCode=$this->getRec_countryISOCode();
        $dhl_xml->ShipmentOrder->Shipment->Receiver->Communication->phone=$this->getRec_phone();
        
        if($this->getNoNeighbourDelivery() == 1){
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->NoNeighbourDelivery['active']=1;
        }
        if($this->getPreferredTime() != ''){
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->PreferredTime['active']=1;
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->PreferredTime['details']=$this->getPreferredTime();
        }
        if($this->getPreferredDay() != ''){
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->PreferredDay['active']=1;
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->PreferredDay['details']=$this->getPreferredDay();
        }
        if($this->getPreferredLocation() != ''){
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->PreferredLocation['active']=1;
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->PreferredLocation['details']=$this->getPreferredLocation();
        }
        if($this->getPreferredNeighbour() != ''){
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->PreferredNeighbour['active']=1;
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->PreferredNeighbour['details']=$this->getPreferredNeighbour();
        }
        if($this->getSameDayDelivery() != ''){
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->SameDayDelivery['active']=1;
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->SameDayDelivery['details']=$this->getSameDayDelivery();
        }
        if ($this->getVisualCheckOfAge() != '') {
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->VisualCheckOfAge['active']='1';
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->VisualCheckOfAge['type']='A18';
        }
        // INSERT INTO configuration SET configuration_key='MODULE_SHIPPING_DHLGKAPI_PARCELOUTLETROUTING_ENABLED',configuration_value='False',configuration_group_id='6',date_added='now()',set_function='xtc_cfg_select_option(array(\'True\', \'False\'), ';
        if($this->getParcelOutletRouting() === True){
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->ParcelOutletRouting['active']=1;
            $dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->ParcelOutletRouting['details']=$this->getRecipientEmailAddress();
        }
        return $dhl_xml;
    }
    
    public function soap_request($dhl_xml,$function, $sID = 0, $testmode = false) {
//Webservice URL
        $testmode = main::isDev();
        if($testmode){
            $dhlwsdlurl='https://cig.dhl.de/cig-wsdls/com/dpdhl/wsdl/geschaeftskundenversand-api/2.0/geschaeftskundenversand-api-2.0.wsdl';
            $location='https://cig.dhl.de/services/sandbox/soap';
            $application_id='yes4trade.de';
            $application_token='Filu-1605!';
            //Test-EKP: 2222222222
            $sh_param = array(
                'user' => '2222222222_01',
                'signature' => 'pass',
                'type' => '0'
            );
        }else{
            $dhlwsdlurl='https://cig.dhl.de/cig-wsdls/com/dpdhl/wsdl/geschaeftskundenversand-api/2.0/geschaeftskundenversand-api-2.0.wsdl';
            // 18.10.2021 geaenderte WSDL
	    $dhlwsdlurl='http://agri.abcde.biz/geschaeftskundenversand-api-2.2.wsdl';
            
            $location='https://cig.dhl.de/services/production/soap';
            $application_id=DHL_VERSENDEN_APPLICATION_ID;
            $application_token=DHL_VERSENDEN_APPLICATION_TOKEN;
            $sh_param = array(
                'user' => MODULE_SHIPPING_DHLGKAPI_USER, //$config_data['USER'],  
                'signature' => MODULE_SHIPPING_DHLGKAPI_PASSWORD, //$config_data['PASSWORD'],
                'type' => '0'
            );
        }
        if($function == 'checkout'){
            $location = $testmode ? 'https://cig.dhl.de/services/sandbox/soap' : 'https://cig.dhl.de/services/production/soap';
            $dhlwsdlurl='';
            // evtl yes4trade_1
            $application_id = $testmode ? 'yes4trade.de' : DHL_VERSENDEN_APPLICATION_ID;
            $application_token = $testmode ? 'Filu-1605!' : DHL_VERSENDEN_APPLICATION_TOKEN;
            $sh_param = array();
        }elseif(in_array($function,self::STANDORTSUCHE_OPERATIONS)){
            $dhlwsdlurl = 'https://cig.dhl.de/cig-wsdls/com/dpdhl/wsdl/standortsuche-api/1.1/standortsuche-api-1.1.wsdl';
        }


        //Optionsarray
        //Optionen f�r SSL php 5.6
        $ssl_opts = array(
            'ssl' => array('verify_peer'=>false, 'verify_peer_name'=>false)
        );

        $options = array(
            'location' => $location,
            'trace' => 1,
            'soap_version' => (defined('SOAP_1_1'))?SOAP_1_1:'SOAP_1_1',
            'encoding' => CHARSET,
            'login' => $application_id,//MODULE_SHIPPING_DHLGKAPI_CIG_LOGIN, //$config_data['CIG_LOGIN'],
            'password' => $application_token, //MODULE_SHIPPING_DHLGKAPI_CIG_PASSWORD, //$config_data['CIG_PASSWORD'],
            'authentication' => (defined('SOAP_AUTHENTICATION_BASIC'))?SOAP_AUTHENTICATION_BASIC:'SOAP_AUTHENTICATION_BASIC',
            'connection_timeout' => 60,
            'cache_wsdl' => (defined('WSDL_CACHE_DISK')) ? WSDL_CACHE_DISK : 'WSDL_CACHE_DISK', //NB 1.01 Cache the WSDL to Disk
            'stream_context' => stream_context_create($ssl_opts)
        );
        $soapClient = new SoapClient($dhlwsdlurl, $options);
        $headers = new SoapHeader('http://dhl.de/webservice/cisbase','Authentification', $sh_param);
        //SOAPClient
        $soapClient->__setSoapHeaders(array($headers));
        //SOAP Anfrage
        try {
            //yes_debug($soapClient->__getFunctions());
            if(in_array($function,self::STANDORTSUCHE_OPERATIONS)){
                $result = $soapClient->{$function}($dhl_xml->$function);
            }else{
                $result = $soapClient->{$function}($dhl_xml);
            }
            //Fehlermeldung pruefen
            switch($function){
               case 'checkout':
                   return $result;
                   break;
               case 'getVersion':
                   yes_debug($result);
                   exit;
                   break;
               case 'getManifest':
                   return $result;
                   break;
               case 'doManifest':
                   $status=$result->Status;
                   break;
               default:
                    if(in_array($function,self::STANDORTSUCHE_OPERATIONS)){
                        $status = new \stdClass();
                        $status->statusCode = '0';
                    }else{
                        if (isset($result->CreationState->LabelData->Status)) {
                            $status=$result->CreationState->LabelData->Status;
                        } else {                                                                                          
                                $status=$result->Status;
                        }
                    }
                   break;
            }
            //Fehlerausgabe zusammenstellen
            if ($status->statusCode != '0'){
                $msg = array(
                    'DHL ('.$status->statusCode.' '.$status->statusText.')'
                );
		if(sizeOf($result->ManifestState)){
			$msg_t = '';
			foreach($result->ManifestState as $ms){
				if($ms->Status->statusCode != '0'){
					$msg_t .= $ms->shipmentNumber.': '.$ms->Status->statusText.'<br />';
				}
			}
			$msg[] = 'DHL '.$msg_t;
		}
                if(is_array($status->statusMessage)){
                    foreach($status->statusMessage as $smsg){
                        $msg[] = 'DHL '.$smsg;
                    }
                }else{
                    $msg[] = $status->statusMessage;
                }
                $this->setErrors($msg);
            }
        } catch (SoapFault $fault) {
            //Fehlermeldung schon bei der SOAP-Anfrage
            //echo "Request Error\r\n<br />";
            //print_r(nl2br(htmlspecialchars($soapClient->__getLastRequest())));
            //echo "<br />Request Header\r\n<br />";
            //print_r(nl2br(htmlspecialchars($soapClient->__getLastRequestHeaders())));
            $msg = array($fault->getMessage());
            $this->setErrors($msg);
        }
        if(main::isDev()){
            yes_mail_debug($soapClient->__getLastRequest());
        }
        unset($soapClient);

        return $result;
    }

    public function get_cod_amount($oID = Null,$one_click = false){
        $cod_amount = 0;
        if($one_click and $this->getNachnahme() != 'CashOnDelivery'){
            return $cod_amount;
        }
        if($this->getNachnahme() == 'CashOnDelivery'){
            $cod_fee_val=preg_replace('/[^0-9.,]/','',MODULE_SHIPPING_DHLGKAPI_COD_DHL_FEE);
            $cod_fee=str_replace(',','.',$cod_fee_val);
        }else{
            $cod_fee = 0;
        }
        if($oID !== Null and $oID[0] != 'R' ){
//            $cod_amount_query=xtc_db_query("select value from ".TABLE_ORDERS_TOTAL." where orders_id='".$oID."' AND class='ot_cod_fee'");
            $cod_amount_query=xtc_db_query("select value from ".TABLE_ORDERS_TOTAL." where orders_id='".$oID."' AND class='ot_total'");
            if(xtc_db_num_rows($cod_amount_query)){
                $cod_amount_array=xtc_db_fetch_array($cod_amount_query);
                $cod_amount=$cod_amount_array['value']+$cod_fee;
            }
        }
        if (isset($_GET['CODAmount'])) {
            $cod_amount = preg_replace('/[^0-9.,]/','',$_GET['CODAmount']);
            $cod_amount = str_replace(',','.',$cod_amount);
        }
        return number_format($cod_amount,'2','.','');
        
    }
    
    public function get_default_services($dhl_product,$dhl_xml,$sequence_number){
        $display_services=unserialize(MODULE_SHIPPING_DHLGKAPI_DISPLAY_SERVICES);
        $valid_services=unserialize(MODULE_SHIPPING_DHLGKAPI_VALID_SERVICES);
        $ages=array('A16','A18');
        $age_array=array();
        foreach($ages as $age) {
            $age_array[]=array('id' => $age, 'text' => $age); 
        }
        $one_click = (isset($_GET['one_click']) and $_GET['one_click'] == 1) ? true : false;
        $default_services = array();
        foreach ($display_services as $service) {
            if ($valid_services[$dhl_product][$service]=='1') {
                $extra_input='';
                $has_srvc = isset($dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service);
                if(!$has_srvc){
                    $checked = false;
                }else{
                    if(!$one_click and $sequence_number > 1){
                        $checked = (isset($_GET[$service]) and $_GET[$service] == 'on') ? true : false;
                    }else{
                        $checked=$dhl_xml->ShipmentOrder->Shipment->ShipmentDetails->Service->{$service}['active']=='1'?true:false;
                    }
                }
                $disabled=false;
                $display='';
                switch($service) {
                    case 'BulkyGoods':
                        if ($this->getSperrgut() == $service) {
                            if(!$one_click and $sequence_number > 1){
                                $checked = (isset($_GET[$service]) and $_GET[$service] == 'on') ? true : false;
                            }else{
                                $checked=true; 
                            }
                        } else {
                            $disabled=true;
                        }
                        break;
                    case 'CashOnDelivery':
                        if ((MODULE_SHIPPING_DHLGKAPI_COD_ENABLED=='True') && (MODULE_SHIPPING_DHLGKAPI_COD_PAYMENT_MODULE==$this->getOrder_payment_method() or $this->getNachnahme() == $service) ) {
                            if(!$one_click and $sequence_number > 1){
                                $checked = (isset($_GET[$service]) and $_GET[$service] == 'on') ? true : false;
                            }else{
                                $checked=true; 
                            }
                            if($this->getCod_amount() > 0){
                                if(!isset($_GET[$service])){
                                    $checked = true;
                                }
                            }
                            $extra_input= '<input size="10" type="text" name="CODAmount" value="'.$this->getCod_amount().'"/> EUR';
                        } else {
                            $disabled=true;
                        }
                        break;

                    case 'GoGreen':
                        if (constant('MODULE_SHIPPING_DHLGKAPI_'.strtoupper($service).'_ENABLED')=='True') {
                            if(!$one_click and $sequence_number > 1){
                                $checked = (isset($_GET[$service]) and $_GET[$service] == 'on') ? true : false;
                            }else{
                                $checked=true;
                            }
                        }
                        break;

                    case 'PrintOnlyIfCodeable':
                        if(!$one_click and $sequence_number > 1){
                            $checked = (isset($_GET[$service]) and $_GET[$service] == 'on') ? true : false;
                        }else{
                            $checked=true;
                        }
                        break;

                    case 'AdditionalInsurance':
                        if ($this->getCod_amount() > 500) {
                            $extra_input = '<input size="10" type="text" name="insuranceAmount" value="'.$this->getCod_amount().'"/> EUR';
                        } else {
                            $disabled=true; 
                        }
                        break;

                    case 'Return':
                        if (constant('MODULE_SHIPPING_DHLGKAPI_'.strtoupper($service).'_ENABLED')=='True') {
                            if(!$one_click and $sequence_number > 1){
                                $checked = (isset($_GET[$service]) and $_GET[$service] == 'on') ? true : false;
                            }else{
                                $checked=true;
                            }
                        }
                        break;

                    case 'VisualCheckOfAge':
                        $extra_input = xtc_draw_pull_down_menu('VisualCheckOfAgeType',  $age_array, 'A18');
                        break;

                    case 'IdentCheck':
                        $name_parts = explode(' ',$this->getRec_name());
                        $first_name = '';
                        $last_name = '';
                        foreach($name_parts as $nr => $prt){
                            if($nr == sizeOf($name_parts)-1){
                                $last_name = $prt;
                            }else{
                                $first_name .= $prt.' ';
                            }
                        }
                        $first_name = trim($first_name);

                        $extra_input = '<p>'.ENTRY_LAST_NAME.'<br /><input size="10" type="text" name="surname" value="'.$last_name.'"></p>';
                        $extra_input .= '<p>'.ENTRY_FIRST_NAME.'<br /><input size="10" type="text" name="givenName" value="'.$first_name.'"></p>';
                        $extra_input .= '<p>'.MODULE_SHIPPING_DHLGKAPI_MINIMUMAGE.'<br /><input size="10" type="text" name="minimumAge" value="18"></p>';
                        $extra_input .= '<p>'.ENTRY_DATE_OF_BIRTH.'<br />'.xtc_draw_date_selector('IdentCheck').'</p>';
                        break; 
                }
                $default_services[$service] = array(
                    'checked'=>$checked,
                    'extra_input'=>$extra_input,
                    'disabled'=>$disabled,
                );
            }       
        }
        return $default_services;
    }
    
}

