<?php
require realpath(__DIR__) . DIRECTORY_SEPARATOR.'hitmeister_api/autoload.php';
use Hitmeister\Component\Api\ClientBuilder;
use Hitmeister\Component\Api\Transfers\ProductDataTransfer;
require_once(DIR_FS_CATALOG.DIRECTORY_SEPARATOR.'lang/german/modules/order_total/ot_shipping.php');

if( !defined('USE_DOMPDF') or USE_DOMPDF != 'True'){
    if(!class_exists('HTML2FPDF')){
        require_once("includes/classes/class.html2pdf.php");
    }
}
if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
    if(!function_exists('xtc_generate_packingslip_barcode')){
	    require_once(DIR_FS_INC . 'xtc_generate_packingslip_barcode.inc.php');
    }
}
$needed_functions = ['xtc_oe_get_price_o_tax','yes_get_country_id_from_iso2','yes_end_auction_add'];
foreach($needed_functions as $nf){
    if(!function_exists($nf)){
        if(is_file(DIR_FS_INC.$nf.'.inc.php')){
            require_once(DIR_FS_INC.$nf.'.inc.php');
        }
    }
}
$exportdata_path = \main::get_exportdata_path();
define('HITMEISTER_SAVE_DIR',$exportdata_path.'HITMEISTER_FILES');
$select_categories = array();
class yes_hitmeister{
    var $client;
    const SAVE_DIR = HITMEISTER_SAVE_DIR;
    const CATEGORIES_HTML_FILE = HITMEISTER_SAVE_DIR.DIRECTORY_SEPARATOR.'hitmeister_categories.html';
    const PRODUCTS_CSV_FILE = HITMEISTER_SAVE_DIR.DIRECTORY_SEPARATOR.'hitmeister_products.csv';
    const CATEGORY_ATTRIBUTE_JSON_FILE = HITMEISTER_SAVE_DIR.DIRECTORY_SEPARATOR.'hitmeister_category_attributes_%s.json';
    const PRODUCT_IMPORT_DELIMITER = ';';
    const PRODUCT_IMPORT_NEWLINE = "\r\n";
    const ORDER_IMPORT_STATUS_LOGFILE_NAME = 'hitmeister_order_import_status.log';
    
    function __construct( $buildClient = true ){
        if(!is_dir(self::SAVE_DIR)){
            mkdir(self::SAVE_DIR);
        }
        $needed_functions = array(
            'xtc_oe_get_price_o_tax','yes_get_country_id_from_iso2',
            'yes_end_auction_add','xtc_oe_customer_infos'
        );
        foreach($needed_functions as $f){
            if(!function_exists($f)){
                if(is_file(DIR_FS_INC.$f.'.inc.php')){
                    require_once(DIR_FS_INC.$f.'.inc.php');
                }else{
                    throw new Exception('class yes_hitmeister.php: Missing Implementation of function '.$f);
                }
            }
        }
        $needed_classes = array(
            'yesSmarty'
        );
        foreach($needed_classes as $c){
            if(!class_exists($c)){
                throw new Exception('class yes_hitmeister.php: Missing Implementation of class '.$c);
            }
        }
        if($buildClient === true){
            $this->client = ClientBuilder::create()
                    ->setClientKey(MODULE_OTHER_YES_HITMEISTER_API_KEY)
                    ->setClientSecret(MODULE_OTHER_YES_HITMEISTER_API_SECRET)
                    ->build();
        }
    }
    
    private function request( string $uri, array $params, $json_decode = true, $post_body = array(), string $method = 'GET' ){
            $baseUrl = 'https://sellerapi.kaufland.com/v2';

            $uri = $baseUrl.$uri;
            $body = '';
            if(sizeOf($post_body)){
                $body = json_encode($post_body);
                if($method != 'PATCH'){
                    $method = 'POST';
                }
            }
            // Credentials for the API
            $clientKey = MODULE_OTHER_YES_HITMEISTER_API_KEY;
            $secretKey = MODULE_OTHER_YES_HITMEISTER_API_SECRET;

            if(sizeOf($params)){
                $uri .= '?' . http_build_query($params);
            }
            // Current Unix timestamp in seconds
            $timestamp = time();
            // Name of your partner solution
            $userAgent = 'YES4trade';
            // Define all the mandatory headers
            $headers = [
                    'Accept: application/json',
                    'Shop-Client-Key: ' . $clientKey,
                    'Shop-Timestamp: ' . $timestamp,
                    'Shop-Signature: ' . $this->signRequest($method, $uri, $body, $timestamp, $secretKey),
                    'User-Agent: ' . $userAgent,
            ];
            if(sizeOf($post_body)){
                $headers[] = 'Content-Type: application/json';
            }
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $uri);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            if($method == 'DELETE' or $method == 'PATCH'){
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
            }
            if(sizeOf($post_body)){
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS,
                    $body
                );
                //curl_setopt($ch, CURLOPT_HEADER, 1);
                //curl_setopt($ch, CURLINFO_HEADER_OUT, 1);
            }
            if($json_decode === true){
                $response = json_decode(curl_exec($ch), true);
            }else{
                $response = curl_exec($ch);
            }
            return $response;
    }

    public function signRequest($method, $uri, $body, $timestamp, $secretKey){
            $string = implode("\n", [
                    $method,
                    $uri,
                    $body,
                    $timestamp,
            ]);

            return hash_hmac('sha256', $string, $secretKey);
    }
    
   
	public static function hitmeister_refund_reasons(){
		return array(array(
			'id'=>'delivery_damage','text'=>'The order unit was damaged during delivery',
			),array(
			'id'=>'delivery_delay','text'=>'There was a delay in delivery',
			),array(
			'id'=>'incomplete_delivery','text'=>'The delivery was incomplete',
			),array(
			'id'=>'incorrect_delivery','text'=>'The delivery was incorrect',
			),array(
			'id'=>'refund_postage_fee','text'=>'The refund is for postage fee',
			),array(
			'id'=>'other_refund','text'=>'Some other refund reason'
			)
		);
	}
        
        public static function hitmeister_orders_statuses(){
            return array(
                array('id'=>'open','text'=>'open'),
                array('id'=>'need_to_be_sent','text'=>'need_to_be_sent'),
                array('id'=>'sent','text'=>'sent'),
                array('id'=>'received','text'=>'received'),
                array('id'=>'cancelled','text'=>'cancelled'),
                array('id'=>'sent_and_autopaid','text'=>'sent_and_autopaid'),
                array('id'=>'returned','text'=>'returned'),
                array('id'=>'returned_paid','text'=>'returned_paid')
            );
        }

	public static function hitmeister_cancellation_reasons(){
		return array(
			array('id'=>'BuyerCancelled', 'text'=>'the buyer cancelled the order'),
			array('id'=>'CustomerExchange','text'=>'the customer would like to exchange the ordered item for a different one'),
			array('id'=>'ShippingAddressUndeliverable','text'=>'could not deliver to the address given by the customer'),
			array('id'=>'WrongCatalogData','text'=>'the description on the Kaufland Onlineshop site did not match the item in your inventory'),
			array('id'=>'MerchandiseNotReceived','text'=>'the customer says that the item did not arrive due to problems during shipping'),
			array('id'=>'NoInventory','text'=>'the item is not currently in your inventory, for example because you are temporarily or permenantly sold out'),
			array('id'=>'DelayedInventory','text'=>'the item is not in your inventory and there is a delay in delivery by the supplier'),
			array('id'=>'WrongPrice','text'=>'the price on the Kaufland Onlineshop site was incorrect'),
			array('id'=>'UndeliverableRegion','text'=>'if you do not ship to the customers location'),
			array('id'=>'NoReactionBuyer','text'=>'if there is no response by the customer to complete the order'),
			array('id'=>'GeneralAdjustment','text'=>'general adjustment')
		);
	}

	public static function hitmeister_carrier(){
		$array = array(
			'Other',
			'Other Hauler',
			'Bursped',
			'Cargoline',
			'Dachser',
			'Deutsche Post',
			'DHL',
			'DHL 2 MH',
			'DHL Express',
			'DHL Freight',
			'DPD',
			'dtl',
			'Emons',
			'Fedex',
			'GEL',
			'GLS',
			'Hermes',
			'Hermes 2 MH',
			'Hellmann',
			'IDS Logistik',
			'Iloxx',
			'Iloxx Spedition',
			'Kuehne & Nagel',
			'Marktanlieferung',
			'Post Italiane',
			'Rhenus',
			'Schenker',
			'Spedition Guettler',
			'TNT',
			'Trans FM',
			'trans-o-flex',
			'UPS',
			'Zufall'
		);
		$return = array();
		foreach($array as $k){
			$return[] = array(
				'id'=>$k,
				'text'=>$k
			);
		}
		return $return;
	}
	public static function hitmeister_conditions(){
		return array(array(
			'id'=>'new',
			'text'=>'new'
		),array(
			'id'=>'used - as new',
			'text'=>'used - as new'
		),array(
			'id'=>'used - very good',
			'text'=>'used - very good'
		),array(
			'id'=>'used - good',
			'text'=>'used - good'
		),array(
			'id'=>'used - acceptable',
			'text'=>'used - acceptable'
		));
	}
	public static function hitmeister_delivery_times(){
		return array(array(
			'id'=>'a',
			'text'=>'On Stock.'
		),array(
			'id'=>'b',
		 	'text'=>'Ships in 1-3 days.'
		),array(
			'id'=>'c',
		 	'text'=>'Ships in 4-6 days.'
		),array(
			'id'=>'d',
		 	'text'=>'Ships in 7-10 days.'
		),array(
			'id'=>'e',
		 	'text'=>'Ships in 11-14 days.'
		),array(
			'id'=>'f',
		 	'text'=>'Ships in 3-4 weeks.'
		),array(
			'id'=>'g',
		 	'text'=>'Ships in 5-7 weeks.'
		),array(
			'id'=>'h',
		 	'text'=>"When it's available or no shipping estimate possible.",
		),array(
			'id'=>'i',
		 	'text'=>'Ships in 8-10 weeks.'
		));
	}
	public static function hitmeister_categories_select($array){
		if(isset($array['data']) and is_array($array['data'])){
			$tabs = '';
			for($i=0;$i<$array['data']['level'];$i++){
				$tabs .= "\t";
			}
			printf("%s<li %s id=\"%s\"><div>%s</div>\r\n",
				$tabs,
				((!sizeOf($array['children']))? 'class="clickable"' : ''),
				$array['data']['id_category'],
				$array['data']['title_singular']
			);
			if(sizeOf($array['children'])){
				echo $tabs."<ul>\r\n";
				self::hitmeister_categories_select($array['children']);
				echo $tabs."</ul></li>\r\n";
			}else{
				echo $tabs."</li>\r\n";
			}
		}else{
			foreach($array as $sub){
				self::hitmeister_categories_select($sub);
			}
		}
	}

	public static function hitmeister_catsort($id_parent_category, &$sort_array){
		global $hitmeister_select_categories;
		foreach($hitmeister_select_categories as $cat){
			if($cat['id_parent_category'] == $id_parent_category){
				if(!isset($sort_array[ $id_parent_category ])){
					$sort_array[ $id_parent_category ] = array();
				}
				$sort_array[ $id_parent_category ][$cat['id_category']]  = array(
					'data'=>$cat,
					'children'=>array()
				);
				self::hitmeister_catsort($cat['id_category'], $sort_array[ $id_parent_category ][$cat['id_category']]['children']);
			}
		}
	}

	public static function hitmeister_get_attribute_input($att){
		if($att['is_multiple_allowed'] == 1){
			$input_name = $att['name'].'[]';
		}else{
			$input_name = $att['name'];
		}
		switch($att['type']){
			case 'Text':
			case 'ShortText':
			case 'SmallText':
				$maxl = '';
				if($att['type'] == 'ShortText') {
					$maxl = 'maxlength="'.HITMEISTER_ATTRIBUTES_SHORTTEXT_MAXLENGTH.'"';
				}elseif($att['type'] == 'SmallText'){
					$maxl = 'maxlength="'.HITMEISTER_ATTRIBUTES_SMALLTEXT_MAXLENGTH.'"';
				}
				$input = sprintf(
					'<textarea class="input_field" name="%s" rows="%s" cols="%s" %s></textarea>',
					$input_name,
					HITMEISTER_ATTRIBUTES_TEXTAREA_ROWS,
					HITMEISTER_ATTRIBUTES_TEXTAREA_COLS,
					$maxl
				);
				break;
			case 'Date': //d.m.Y
			case 'Ean':
			case 'Int':
			case 'Float': // 1.000,00
				$input = sprintf(
					'<input class="input_field" name="%s" value="" size="%s" maxlength="%s">',
					$input_name,
					HITMEISTER_ATTRIBUTES_TEXT_INPUT_SIZE,
					HITMEISTER_ATTRIBUTES_TEXT_INPUT_MAXLENGTH
				);
				
				break;
                        case 'Category':
                        case 'Company':
			case 'TinyText':
				$input = sprintf(
					'<input class="input_field" name="%s" value="" size="%s" maxlength="%s">',
					$input_name,
					HITMEISTER_ATTRIBUTES_TINYTEXT_SIZE,
					HITMEISTER_ATTRIBUTES_TINYTEXT_MAXLENGTH
				);
				
				break;
			case 'Picture':
				$input = sprintf(
					'<input class="input_field" name="%s" value="" size="%s">',
					$input_name,
					HITMEISTER_ATTRIBUTES_PICTURE_INPUT_SIZE
				);
				break;
			case 'Bool':
				$input = sprintf(
					'<select class="input_field" name="%s"><option value="yes">%s</option><option value="no">%s</option></select>',
					$input_name,HITMEISTER_YES,HITMEISTER_NO
				);
				break;
			default:
				// Si_* Any attribute type that starts with "Si_" is a numeric value 
				// in the International System of Units. When you submit a value for 
				// these attributes, it must contain a number and a unit suffix 
				// (e.g. Si_Meter could have any of the following values: 
				// 1m; 2,5m; 200.432,43m; 250mm; 7km.
				if(substr($att['type'],0,3) == 'Si_'){
					$input = sprintf(
						'<input name="%s" value="" size="%s" maxlength="%s" class="input_field" />',
						$input_name,
						HITMEISTER_ATTRIBUTES_SI_SIZE,
						HITMEISTER_ATTRIBUTES_SI_MAXLENGTH
					);
				}else{
					die(json_encode(array(
						'ERROR'=>'unknown Attribute Type '.$att['type']
					)));
				}
		}
		return array(
			'title'=>$att['title'],
			'input'=>$input,
			'multiple'=>$att['is_multiple_allowed']
		);
	}

	public function hitmeister_get_category_name($id){
            $uri = '/categories/'.$id;
            $params = [
                'storefront'=>'de'
            ];
            $decode_json = false;
            $res = json_decode($this->request($uri, $params, $decode_json));
            $category = $res->data;
            return $category->title_singular;
	}
        
        public static function hitmeister_zone_id($country_id){
            // bastel zone-id
            $zone_query = xtc_db_query("SELECT zone_id FROM ".TABLE_ZONES." WHERE zone_country_id='".$country_id."'");
            $zone = xtc_db_fetch_array($zone_query);
            return $zone["zone_id"];
        }
        
        public static function get_products_id_from_id_item($id_item){
            $query = xtc_db_query(sprintf(
                    "SELECT products_id FROM hitmeister_products WHERE hitmeister_id_item='%s'",
                    $id_item
            ));
            if(xtc_db_num_rows($query)){
                $record = xtc_db_fetch_array($query);
                return $record['products_id'];
            }
            return -1;
        }
        
        public static function get_products_id_from_id_unit($id_unit){
            $query = xtc_db_query(sprintf(
                    "SELECT products_id FROM hitmeister_products WHERE id_unit='%s'",
                    $id_unit
            ));
            if(xtc_db_num_rows($query)){
                $record = xtc_db_fetch_array($query);
                return $record['products_id'];
            }
            return -1;
        }
        
        /**
         * Speichert die Zuweisung YES orders_id / Hitmeister id_order in der
         * Tabelle hitmeister_orders
         * 
         * @param int $orders_id
         * @param string $hitmeister_id_order
         * @return int hitmeister_orders_id
         */
        public static function hitmeister_allocate_imported_order( $orders_id, $hitmeister_id_order){
            $insert_sql_array = array(
                'orders_id'=>$orders_id,
                'hitmeister_id_order'=>$hitmeister_id_order
            );
            xtc_db_perform('hitmeister_orders',$insert_sql_array);
            return xtc_db_insert_id();
        }
        
        /**
         * Ermittelt die orders_id aus der Tabelle hitmeister_orders basierend
         * auf der hitmeister id_order
         * Gibt -1 zurueck wenn es keinen passenden Eintrag gibt (dann ist der
         * Auftrag noch nicht importiert oder unbekannt)
         * 
         * @param string $hitmeister_id_order
         * @return int orders_id
         */
        public static function hitmeister_get_yes_orders_id_from_id_order($hitmeister_id_order){
            $query = xtc_db_query(sprintf(
                    "SELECT orders_id FROM hitmeister_orders WHERE hitmeister_id_order='%s'",
                    $hitmeister_id_order
            ));
            if(!xtc_db_num_rows($query)){
                return -1;
            }
            $record = xtc_db_fetch_array($query);
            return $record['orders_id'];
        }
        
        public static function is_hitmeister_order( $orders_id ){
            $query = xtc_db_query(sprintf(
                    "SELECT hitmeister_id_order FROM hitmeister_orders WHERE orders_id='%s'",
                    $orders_id
            ));
            return xtc_db_num_rows($query);
        }
        
        public static function get_hitmeister_id_order_from_orders_id($orders_id){
            $query = xtc_db_query(sprintf(
                    "SELECT hitmeister_id_order FROM hitmeister_orders WHERE orders_id='%s'",
                    $orders_id
            ));
            $record = xtc_db_fetch_array($query);
            return $record['hitmeister_id_order']??'';
        }
        
        public static function is_cli(){
            if ( defined('STDIN') ) {
                return true;
            }

            if ( php_sapi_name() === 'cli' ) {
                return true;
            }

            if ( array_key_exists('SHELL', $_ENV) ) {
                return true;
            }

            if ( empty($_SERVER['REMOTE_ADDR']) and !isset($_SERVER['HTTP_USER_AGENT']) and count($_SERVER['argv']) > 0) {
                return true;
            } 

            if ( !array_key_exists('REQUEST_METHOD', $_SERVER) ){
                return true;
            }
            return false;
        }
        
        public static function import_order_error($msg, $orders_id = 0){
            if(self::is_cli()){
                return array(
                    'error'=>$msg,
                    'orders_id'=>$orders_id
                );
            }
            die(json_encode(array(
                'MSG'=>$msg,
                'orders_id'=>$orders_id
            )));
        }

        /**
         * Legt einen Hitmeister Auftrag als YES Bestellung an
         * 
         * @param String $id_order
         * @return int orders_id
         */
        public function import_order($id_order){
            if(!class_exists('customer')){
                throw new Exception('Hitmeister::need customer class');
            //    require_once(DIR_WS_CLASSES.'customer.php');
            }
            if(!class_exists('order')){
                throw new Exception('Hitmeister::need order class');
            //    require_once(DIR_WS_CLASSES.'order.php');
            }
/*
            if(!class_exists('PHPMailer')){
                throw new Exception('Hitmeister::need PHPMailer class');
            //    require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
            }
*/
            if(!class_exists('DBmail')){
                throw new Exception('Hitmeister::need DBmail class');
            //    require_once('includes/classes/class.ebaymail.php');
            }
            if(!function_exists('xtc_oe_get_price_o_tax')){
                throw new Exception('Hitmeister::need function xtc_oe_get_price_o_tax');
                //require_once(DIR_FS_INC.'xtc_oe_get_price_o_tax.inc.php');
            }
            if(!function_exists('xtc_oe_customer_infos')){
                throw new Exception('Hitmeister::need function xtc_oe_customer_infos');
                //require_once(DIR_FS_INC.'xtc_oe_customer_infos.inc.php');
            }
            if(!function_exists('yes_end_auction_add')){
                throw new Exception('Hitmeister::need function yes_end_auction_add');
                //require_once(DIR_FS_INC.'yes_end_auction_add.inc.php');
            }
            if(!class_exists('currencies')){
                throw new Exception('Hitmeister::need currencies class');
            //    require_once(DIR_WS_CLASSES . 'currencies.php');
            }

            if(!function_exists('yes_get_sha1_from_string')){
            //    throw new Exception('Hitmeister::need function yes_get_sha1_from_string');
                require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
            }
            
            $language_id = 2; // pauschal in deutsch
            if(empty($id_order) or $id_order == ''){
                return self::import_order_error(sprintf(
                    'Kaufland Order #%s has no id_order.',
                     $id_order
                ));
            }
            
            if(self::hitmeister_get_yes_orders_id_from_id_order($id_order) > 0){
                return self::import_order_error(sprintf(
                    'Kaufland Order #%s always imported.',
                     $id_order
                ));
            }
            
            try{
                $res = json_decode($this->get_order($id_order,array('billing_address','buyer','seller_units','shipping_address')), false, 512, JSON_BIGINT_AS_STRING );
                $o = $res->data;
                //$o = $this->client->orders()->get($id_order,array('billing_address','buyer','seller_units','shipping_address'));
            }catch(Exception $ex){
                return self::import_order_error(sprintf(
                    'Kaufland Error: %s',
                     $ex->getMessage()
                ));
            }
            if( !isset($o->billing_address->last_name) or $o->billing_address->last_name == '' or strlen($o->billing_address->last_name) <1 ){
	        $err = sprintf(
                    'Kaufland Error: Keine Adressdaten im Result #%s',
                    $id_order
                );
                //yes_mail_debug($err);
                return self::import_order_error($err);
            }
          
            // WIR IMPORTIEREN NUR ARTIKEL DES AUFTRAGS DIE NICHT DEN STATUS
            // cancelled HABEN - $order_units ENTHAELT DANN ALLE IMPORTIERBAREN
            // ARTIKEL
            $order_units = array();
            foreach($o->order_units as $ou){
                switch($ou->status){
                    case 'cancelled':
                        //die('Order Status: '.$ou->status);
                        break;
                    default:
                        $order_units[] = $ou;
                        break;
                }
                $orders_status = ($ou->status != 'sent') ? ORDERS_STATUS_BEZAHLT : ORDERS_STATUS_VERSENDET;
                if(self::get_products_id_from_id_item($ou->product->id_product) < 1){
                    return self::import_order_error(sprintf(
                        'Kaufland order #%s Import Error: Unknown Item (id_product) %s',
                         $o->id_order,$ou->product->id_product
                    ));
                }
            }
            if(!sizeOf($order_units)){
                return self::import_order_error('No products to import');
            }
            if(!isset($o->buyer->email) or empty($o->buyer->email)){
                return self::import_order_error('No buyer Email available');
            }
            $cID = customer::get_customers_id_by_email($o->buyer->email);
            $c_added = false;
            if($cID === -1){
                // PASSWORD UND DATE_ADDED WIRD IN DER add FUNKTION GESETZT
                $cID = customer::add(array(
                    'customers_status'=>MODULE_OTHER_YES_HITMEISTER_API_CUSTOMERS_STATUS,
                    'customers_gender'=>($o->billing_address->gender == 'male') ? 'm' : 'f',
                    'customers_firstname'=>$o->billing_address->first_name,
                    'customers_lastname'=>$o->billing_address->last_name,
                    'customers_dob'=>'',
                    'customers_email_address'=>$o->buyer->email,
                    'customers_default_address_id'=>0,
                    'customers_telephone'=>$o->billing_address->phone,
                    'customers_fax'=>'',
                    'account_type'=>0,
                ));
                $c = new customer($cID,true);
                $country_id = yes_get_country_id_from_iso2($o->billing_address->country);
                $default_address_id = $c->add_address_book_entry(array(
                    'entry_gender'=>($o->billing_address->gender == 'male') ? 'm' : 'f',
                    'entry_company'=>$o->billing_address->company_name,
                    'entry_firstname'=>$o->billing_address->first_name,
                    'entry_lastname'=>$o->billing_address->last_name,
                    'entry_street_address'=>$o->billing_address->street.' '.$o->billing_address->house_number,
                    'entry_suburb'=>$o->billing_address->additional_field,
                    'entry_postcode'=>$o->billing_address->postcode,
                    'entry_city'=>$o->billing_address->city,
                    'entry_state'=>'',
                    'entry_country_id'=> $country_id,
                    'entry_zone_id'=>self::hitmeister_zone_id($country_id),
                    'address_class'=>'customer',
                ));
                $c->update_default_address_book_id($default_address_id);
                $c->add_memo('created','Kaufland: Order #'.$o->id_order);
                $c_added = true;
            }else{
                $c = new customer($cID,true);
            }
            // payment- und shippingmethod/class nachtraeglich setzen!
            $orders_id = $c->add_order($orders_status,'hitmeister');
            $order = new order($orders_id);
            
            $xtPrice = new xtcPrice(DEFAULT_CURRENCY, $c->customers_status);
            $country_id = yes_get_country_id_from_iso2($o->billing_address->country);
            $country = xtc_get_country_name($country_id);
            
            $d_country_id = yes_get_country_id_from_iso2($o->shipping_address->country);
            $d_country = xtc_get_country_name($d_country_id);
            
            $update_sql_array = array(
                'payment_method'=>'hitmeister',
                'payment_class'=>'hitmeister',
                'shipping_method'=>MODULE_OTHER_YES_HITMEISTER_API_SHIPPING_CLASS,
                'shipping_class'=>MODULE_ORDER_TOTAL_SHIPPING_TITLE,
                'customers_name' => $o->billing_address->first_name.' '.$o->billing_address->last_name,
                'customers_company' => $o->billing_address->company_name,
                'customers_street_address' => $o->billing_address->street.' '.$o->billing_address->house_number,
                'customers_suburb' => $o->billing_address->additional_field,
                'customers_city' => $o->billing_address->city,
                'customers_postcode' => $o->billing_address->postcode,
                'customers_state' => '',
                'customers_country' => $country,
                'customers_telephone' => $o->billing_address->phone,
                'customers_mobile' => '',
                'customers_email_address' => $o->buyer->email,
                'billing_name' => $o->billing_address->first_name.' '.$o->billing_address->last_name,
                'billing_company' => $o->billing_address->company_name,
                'billing_street_address' => $o->billing_address->street.' '.$o->billing_address->house_number,
                'billing_suburb' => $o->billing_address->additional_field,
                'billing_city' => $o->billing_address->city,
                'billing_postcode' => $o->billing_address->postcode,
                'billing_state' => '',
                'billing_country' => $country,
                'delivery_name' => $o->shipping_address->first_name.' '.$o->shipping_address->last_name,
                'delivery_company' => $o->shipping_address->company_name,
                'delivery_street_address' => $o->shipping_address->street.' '.$o->shipping_address->house_number,
                'delivery_suburb' => $o->shipping_address->additional_field,
                'delivery_city' => $o->shipping_address->city,
                'delivery_postcode' => $o->shipping_address->postcode,
                'delivery_state' => '',
                'delivery_country' => $d_country,
                'delivery_telephone' => $o->shipping_address->phone,
                'delivery_email_address' => $o->buyer->email,
            );
            xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$orders_id."'");
            
            $tax = array();
            $orders_products = array();
            $number_of_products = 0;
            $first_products_id = 0;
            foreach($order_units as $ou){
                $pID = self::get_products_id_from_id_item($ou->product->id_product);
                if($first_products_id === 0){
                    $first_products_id = $pID;
                }
                $number_of_products++;
                $tax_country_id = STORE_COUNTRY;
                $tax_class_id = yes_eu_oss_get_products_tax_class_id($pID, $tax_country_id);
                $tax_rate = xtc_get_tax_rate($tax_class_id, $tax_country_id);       
                // ALT
                //$tax_rate = number_format($ou->vat,0);
                if(!isset($tax[ $tax_rate ])){
                    $tax[ $tax_rate ] = 0;
                }
                if($ou->shipping_rate > 0){
                    $insert_sql_array = array(
                        'orders_id'=>$orders_id,
                        'title'=>MODULE_ORDER_TOTAL_SHIPPING_TITLE,
                        'text'=> $xtPrice->xtcFormat( $ou->shipping_rate / 100, true ),
                        'value'=>$ou->shipping_rate / 100,
                        'class'=>'ot_shipping',
                        'sort_order'=>MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER,
                        'tax_rate_percent'=> $tax_rate,
                    );
                    xtc_db_perform(TABLE_ORDERS_TOTAL,$insert_sql_array);
                    $tax[ $tax_rate ] += $insert_sql_array['value']-xtc_oe_get_price_o_tax($insert_sql_array['value'], $tax_rate);
                }else{
                    $insert_sql_array = array(
                        'orders_id'=>$orders_id,
                        'title'=>MODULE_ORDER_TOTAL_SHIPPING_TITLE,
                        'text'=> '0,00 '.DEFAULT_CURRENCY,
                        'value'=>0,
                        'class'=>'ot_shipping',
                        'sort_order'=>MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER,
                        'tax_rate_percent'=> $tax_rate,
                    );
                    xtc_db_perform(TABLE_ORDERS_TOTAL,$insert_sql_array);
                }
                // neu 05/2023
                $this->sync_quantity($pID);
//                $this->sync_quantity($ou->product->id_product);
                
                
                // WENN DIESER HASH GLEICH IST, KOENNEN MEHRERE GLEICHE ITEMS
                // ALS EIN ARTIKEL ZUSAMMENGEFASST WERDEN
                $unique_hash = sprintf('%s:%s:%s',
                    $ou->product->id_product,$ou->id_offer,$ou->price
                );
                if(!isset($orders_products[ $unique_hash ])){
                    $p = new product($pID, $language_id);
                    $ptitle = $ou->product->title;
                    if(defined('MODULE_OTHER_YES_HITMEISTER_API_USE_YES_PRODUCTS_NAME_IN_ORDERS') and MODULE_OTHER_YES_HITMEISTER_API_USE_YES_PRODUCTS_NAME_IN_ORDERS == 'True'){
                        $ptitle = xtc_get_products_name($pID);
                    }
                    $orders_products[ $unique_hash ] = array(
                        'products_id'=>$pID,
                        'product'=>$p,
                        'price'=>$ou->price/100,
                        'quantity'=>1,
                        'tax_rate'=>$tax_rate,
                        'title'=>$ptitle,
                    );
                }else{
                    $orders_products[ $unique_hash ]['quantity']++;
                }
            } // end foreach order units
            if($number_of_products === 1 and $first_products_id > 0){
                $default_shipper = \YES4Trade\Model\shipper_profiles::get_products_id_value($first_products_id);
                if(!empty($default_shipper)){
                    $order->update_default_shipper($default_shipper);
                }
            }
            
            foreach($orders_products as $op){
                $price_netto = xtc_oe_get_price_o_tax($op['price'], $op['tax_rate']);
                $tax[$op['tax_rate']] += ($op['price'] - $price_netto)*$op['quantity'];
                $discount = 0;
                $order->insert_product($op['products_id'], 
                        $op['product']->info['products_model'], 
                        $op['title'], 
                        $op['price'], 
                        $discount, 
                        $op['price']*$op['quantity'], 
                        $op['tax_rate'], 
                        $op['quantity'], 
                        ($op['tax_rate'] > 0) ? 1 : 0
                );
		// Update products_ordered (for bestsellers list)
		xtc_db_query(sprintf(
                    "update %s set products_ordered = products_ordered + %d where products_id = '%d'",
                    TABLE_PRODUCTS,
                    $op['quantity'],
                    $op['products_id']
                ));
                
                
		if(defined('EBAY_END_AUCTION_AT_SHOPORDER') and EBAY_END_AUCTION_AT_SHOPORDER == 'True'){
                    yes_end_auction_add($op['products_id'],$op['quantity']);
		}
                $p = new product($op['products_id'], $language_id);
                $p->add_history(sprintf('Kaufland Order %s / oID %d / %d Stk.',
                        $id_order, $orders_id, $op['quantity']
                ));
            } // end foreach order units
            $customer_notification = (SEND_EMAILS == 'true') ? '1' : '0';
            $comm_text = 'Kaufland Order #'.$o->id_order;
            $sql_data_array = array('orders_id' => $orders_id,
                    'orders_status_id' => $orders_status,
                    'date_added' => 'now()',
                    'customer_notified' => $customer_notification,
                    'comments' => $comm_text
            );
            xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);
            $hitmeister_orders_id = self::hitmeister_allocate_imported_order($orders_id, $o->id_order);
            foreach($order_units as $ou){
                $insert_sql_array = array(
                    'hitmeister_orders_id'=>$hitmeister_orders_id,
                    'id_order_unit'=>$ou->id_order_unit,
                    'price'=>$ou->price / 100,
                    'id_offer'=>$ou->id_offer,
                    'id_item'=>$ou->product->id_product,
                    'delivery_time'=>$ou->delivery_time,
                    'delivery_time_expires'=>$ou->delivery_time_expires_iso
                );
                xtc_db_perform('hitmeister_orders_units',$insert_sql_array);
            }
            // bof - realkosten
            $order = new order($orders_id);
            $order->recalc();
            $order->save_real_shipping_cost();
            // eof - realkosten
            
            $smarty = new yesSmarty();
            try{
                $subject = '';
                if(defined('MODULE_OTHER_YES_HITMEISTER_API_EMAIL_SUBJECT') and MODULE_OTHER_YES_HITMEISTER_API_EMAIL_SUBJECT != ''){
                    $subject = str_replace('{$orders_id}', $orders_id, MODULE_OTHER_YES_HITMEISTER_API_EMAIL_SUBJECT);
                    $subject = str_replace('{$real_order_id}', $o->id_order, $subject);
                }
                // subject, send_products_file_content, use_html
                $order->email([$o->buyer->email], 2, $smarty, $subject,false, false);
            }catch(Exception $ex){
                return self::import_order_error(sprintf(
                    'Kaufland Order #%s: %s',
                     $id_order,$ex->getMessage()
                ));
            }
            if(self::is_cli()){
                return array(
                    'error'=>'',
                    'orders_id'=>$orders_id
                );
            }
            return $orders_id;
        }
        
        public static function create_categories_html( array $cats, int $level = 0 ){
            foreach($cats as $cat){
                $tabs = '';
                for($i=0;$i<$level;$i++){
                    $tabs .= "\t";
                }
                echo $tabs;
                if(is_array($cat['children']) and sizeOf($cat['children'])){
                    printf("<li id=\"%d\"><div>%s</div>\n",
                        $cat['id_category'],
                        $cat['title_singular']
                    );
                }else{
                    printf("<li class=\"clickable\" id=\"%d\"><div>%s</div>\n",
                        $cat['id_category'],
                        $cat['title_singular']
                    );
                }
                if(is_array($cat['children']) and sizeOf($cat['children'])){
                    echo $tabs."<ul>\n";
                    self::create_categories_html($cat['children'], $level+1);
                }else{
                    echo $tabs."</li>\n";
                }
            }
            echo $tabs."</ul></li>\n";
        }
        
        
    public function save_category_tree_as_html(){
        $params = [
            'storefront'=>'de',
        ];
        $uri = '/categories/tree';
        $categories = $this->request($uri, $params);
        ob_start();
        self::create_categories_html($categories['data']['children']);
        $content = ob_get_contents();
        ob_end_clean();
        file_put_contents(self::CATEGORIES_HTML_FILE, gzcompress($content,9));
        return 1;
    }
    
    public function items_find_by_ean(string $ean){
        $json_decode = false;
        $params = [
            'storefront'=>'de',
            'ean'=>$ean,
            'embedded'=>'units',
        ];
        $uri = '/products/ean/'.$ean;
        return $this->request($uri, $params,$json_decode);
    }
    
    public function items_find(string $term){
        $json_decode = false;
        $params = [
            'storefront'=>'de',
            'q'=>$term
        ];
        $uri = '/products/search';
        return $this->request($uri, $params,$json_decode);
    }
    
    public function get_seller_units(int $offset=0, int $limit = 30, $id_item = Null){
        $json_decode = false;
        $params = [
            'storefront'=>'de',
            'embedded'=>['products'],
        ];
        $uri = '/units';
        if($id_item !== Null){
            $uri .= '/'.$id_item;
        }else{
            $params['offset'] = $offset;
            $params['limit'] = $limit;
        }
        return $this->request($uri, $params,$json_decode);
    }
    
    public function get_products( string $id_item = '', array $embedded = [] ){
        $json_decode = false;
        $params = [
            'storefront'=>'de',
        ];
        if(sizeOf($embedded)){
            $params['embedded'] = $embedded;
        }
        
        $uri = '/products';
        if($id_item != ''){
            $uri .= '/'.$id_item;
        }
        return $this->request($uri, $params,$json_decode);
    }
    
    public function get_unit($id=null, array $embedded = []){
        $json_decode = false;
        $params = [
            'storefront'=>'de',
        ];
        if(sizeOf($embedded)){
            $params['embedded'] = $embedded;
        }
        
        $uri = '/units';
        if($id !== Null){
            $uri .= '/'.$id;
        }
        return $this->request($uri, $params,$json_decode);
    }
    
    public function delete_product( string $ean ){
        $json_decode = false;
        $params = [
            'locale'=>'de_DE',
        ];
        $uri = '/product-data/'.$ean;
        return $this->request($uri, $params,$json_decode,[],'DELETE');
    }
    
    public function delete_unit( int $id ){
        $json_decode = false;
        $params = [
            'storefront'=>'de',
        ];
        $uri = '/units/'.$id.'/';
        return $this->request($uri, $params,$json_decode,[],'DELETE');
    }
    
    public function get_categories( string $categoryID, array $embedded_params = [] ){
        $json_decode = false;
        $params = [
            'storefront' => 'de',
            'id_category'=> $categoryID,
            'embedded'=>$embedded_params,
        ];
        $uri = '/categories/'.$categoryID;
        return $this->request($uri, $params,$json_decode);
    }
    
    public function post_unit( $body = [] ){
        $json_decode = false;
        $params = [
            'storefront'=>'de',
        ];
        $uri = '/units';
        return $this->request( $uri, $params,$json_decode,$body );
    }
    
    public function units_update($id_unit, $body ){
        $json_decode = false;
        $params = [];
        $params['storefront'] = 'de';
        $uri = '/units/'.$id_unit;
        return $this->request( $uri, $params,$json_decode,$body,'PATCH');
    }
    
    public function import_file( string $url ){
        if(main::isDev(true)){
            $url = 'http://agri.abcde.biz/yes/admin/exportdata/HITMEISTER_FILES/hitmeister_csv_import_131.csv';
        }
        $json_decode = false;
        $params = [];
        $uri = '/product-data/import-files';
        return $this->request( $uri, $params,$json_decode,['url'=>$url]);
    }
    
    public function get_import_files_from_hitmeister(array $statii, array $types, string $createdFrom, string $updatedFrom, string $sort, int $limit, int $offset){
        $json_decode = false;
        $params = [
            //'status'=>implode(',',$statii),
            'ts_created'=>$createdFrom,
            'ts_updated'=>$updatedFrom,
            'sort'=>$sort,
            'limit'=>$limit,
            'offset'=>$offset
        ];
        $uri = '/product-data/import-files';
        return $this->request( $uri, $params,$json_decode);
    }
    
    public function get_orderUnit( string $id_order_unit ){
        $json_decode = false;
        $params = [
            'storefront'=>'de',
        ];
        $uri = '/order-units/'.$id_order_unit;
        return $this->request( $uri, $params,$json_decode);
    }
    
    public function get_orderUnits(string $hitmeister_order_status,int $idOffer = Null,$createdFrom='',$updatedFrom='',$sort = '',$limit = 30, $apiOffset = 0){
        $json_decode = false;
        $params = [
            'storefront'=>'de',
            'status'=>$hitmeister_order_status,
            'ts_created_from_iso'=>$createdFrom,
            //'fulfillment_type'=>'',
            'sort'=>$sort,
            'limit'=>$limit,
            'offset'=>$apiOffset,
        ];
        if(main::isDev(true)){
            $params = [
                'storefront'=>'de',
            ];
        }
        if($idOffer != Null){
            $params['id_offer'] = $idOffer;
        }
        if($updatedFrom != ''){
            $params['ts_updated_from_iso'] = $updatedFrom;
        }
        $uri = '/order-units';
        return $this->request( $uri, $params,$json_decode);
    }
    
    public function get_orders(string $createdFrom, int $limit=5, int $offset=0){
        $json_decode = false;
        $params = [
            'ts_created_from_iso' => $createdFrom,
            'limit'=>$limit,
            'offset'=>$offset,
        ];
        $uri = '/orders';
        return $this->request( $uri, $params,$json_decode);
    }
    
    public function get_order( string $id_order = '', array $embedded = []){
        $json_decode = false;
        $params = [
            
        ];
        if($id_order != ''){
            $uri = '/orders/'.$id_order;
        }else{
            $uri = '/orders';
        }
        return $this->request( $uri, $params,$json_decode);
    }
    
    public function get_tickets( $id = Null, string $status = ''){
        $json_decode = false;
        $params = [];
        if($status != ''){
            $params['status'] = $status;
        }
        if($id === Null){
            $uri = '/tickets';
        }else{
            $params['id_ticket'] = $id;
            $params['embedded'] = ['product','buyer','messages'];
            $uri = '/tickets/'.$id;
        }
        return $this->request( $uri, $params,$json_decode);
    }
    
    public function ticket_post(string $id_ticket='', string $message='' ){
        $json_decode = false;
        $params = [];
        $uri = '/tickets';
        // WENN KEINE id_ticket DANN WIRD NEUES TICKET ERZEUGT
        if($id_ticket != ''){
            $params['id_ticket'] = $id_ticket;
            $uri .= '/'.$id_ticket.'/messages';
        }
        $post_body = ['text'=>$message];
        return $this->request( $uri, $params,$json_decode,$post_body);
    }
    
    public function ticket_close($id){
        $json_decode = false;
        $params = [];
        $uri = '/tickets/'.$id.'/close';
        return $this->request( $uri, $params,$json_decode,[],'PATCH');
    }
    
    public function order_invoice_upload(string $id_order,string $filename,string $binary_content){
        $json_decode = false;
        $params = [];
        $post_data = [
            "original_name" => $filename,
            "mime_type" => "application/pdf",
            "data" => $binary_content
        ];
        $uri = '/order-invoices/'.$id_order;
        return $this->request( $uri, $params,$json_decode,$post_data);
    }
    
    public function get_categories_decide(array $post_data){
        $json_decode = false;
        $params = [
            'storefront'=>'de',
        ];
        $uri = '/categories/decide/';
        return $this->request( $uri, $params,$json_decode,$post_data);
    }
    
    public function get_importFiles(string $id_file = ''){
        $json_decode = false;
        $params = [
            'storefront'=>'de',
            'id_import_file'=>$id_file
        ];
        $uri = '/import-files/inventory-feed';
        if($id_file != ''){
            $uri .= '/'.$id_file;
        }
        return $this->request( $uri, $params,$json_decode);
    }
    
        
    public function get_category_config_files(){
        $files = array();
        $d = dir(self::SAVE_DIR);
        while (false !== ($entry = $d->read())) {
                if(!is_file(self::SAVE_DIR.DIRECTORY_SEPARATOR.$entry)){
                        continue;
                }
                if(substr($entry,-5) == '.json' and strpos($entry,'hitmeister_category_attributes_') > -1){
                        $files[] = array(
                                'id'=>$entry,
                                'text'=>$this->hitmeister_get_category_name(str_replace(array('hitmeister_category_attributes_','.json'),'',$entry ))
                        );
                }
        }
        $d->close();
        return $files;
    }

    /**
     * 
     * @param String $categoryID - die HITMEISTER Kategorie ID
     * @param array $json_scheme
     * @return boolean
     */
    public static function save_attribute_json_file($categoryID, $json_scheme){
        if(!sizeOf($json_scheme) or empty($categoryID)){
            return false;
        }
        $category_attributes_json_file = sprintf(self::CATEGORY_ATTRIBUTE_JSON_FILE, $categoryID);
        if(is_file($category_attributes_json_file)){
                unlink($category_attributes_json_file);
        }
        file_put_contents($category_attributes_json_file, json_encode($json_scheme));
        return true;
    }
    
    public static function get_csv_header_from_export_config_json($file){
        $file_full_path = sprintf('%s/%s',yes_hitmeister::SAVE_DIR,$file);
        if(substr($file,-5) != '.json' or !is_file($file_full_path)){
                throw new Exception('Invalid File "'.$file.'"');
        }
        $scheme = json_decode(file_get_contents($file_full_path));
        $header = array('offer_id');
        foreach($scheme as $field){
                $header[] = $field->name;
        }
        return $header;
    }
    
    public static function download_export_config_csv($file){
        $header = self::get_csv_header_from_export_config_json($file);
        header('Content-Type: application/csv');
        header('Content-Disposition: attachment; filename="'.str_replace('.json','.csv',$file).'";');
        $f = fopen('php://output', 'w');
        fputcsv($f, $header, self::PRODUCT_IMPORT_DELIMITER);
        rewind($f);
        exit;
    }
    
    /**
     * Prueft ob eine products_id in der Tabelle hitmeister_products 
     * gespeichert ist
     * 
     * @param int $products_id
     * @return bool
     */
    public static function is_hitmeister_product($products_id){
        $query = xtc_db_query(sprintf(
                "SELECT hitmeister_products_id FROM hitmeister_products WHERE products_id='%s'",
                $products_id
        ));
        return (xtc_db_num_rows($query))?true:false;
    }

    /**
     * Ermittelt hitmeister_id_item aus der Tabelle hitmeister_products zu einer
     * products_id
     * 
     * @param int $products_id
     * @return int
     */
    public static function get_id_item_from_products_id($products_id){
        $query = xtc_db_query(sprintf(
                "SELECT hitmeister_id_item FROM hitmeister_products WHERE products_id='%d'",
                $products_id
        ));
        $record = xtc_db_fetch_array($query);
        return $record['hitmeister_id_item'];
    }
    
    /**
     * id_unit einer pID holen
     * 
     * Ermittelt aus der Tabelle hitmeister_products die id_unit eines Artikels
     * basierend auf der products_id
     * 
     * @param int $products_id
     * @return string
     */
    public static function get_id_unit_from_products_id($products_id){
        $query = xtc_db_query(sprintf(
                "SELECT id_unit FROM hitmeister_products WHERE products_id='%d'",
                $products_id
        ));
        if(!xtc_db_num_rows($query)){
            return '';
        }
        $record = xtc_db_fetch_array($query);
        return $record['id_unit'];
    }
    
    /**
     * Speichert die Zuweisung hitmeister id_item und YES products_id in der
     * Tabelle hitmeister_products
     * @param String $hitmeister_id_item
     * @param int $products_id
     * @return int
     * @throws Exception
     */
    public function allocate_hitmeister_product($hitmeister_id_item, int $products_id, int $quantity ){
        if(strlen($hitmeister_id_item) < 1 or $products_id < 1){
            throw new Exception('allocate_hitmeister_product() Missing Param(s)');
        }
	// FUNKTION NEU, BASIEREND AUF YH->request - 05/2023
	
	$uri = '/products/'.$hitmeister_id_item;
	$params = [
		'storefront'=>'de',
		'embedded'=>['units']
	];
	$decode_json = false;
	$res = json_decode($this->request($uri, $params, $decode_json));
	
        foreach($res->data->units as $u){
            if($u->id_product == $hitmeister_id_item){
                $id_unit = $u->id_unit;
            }
        }
        $insert_sql_array = array(
            'products_id'=>$products_id,
            'hitmeister_id_item'=>$hitmeister_id_item,
            'id_unit'=>$id_unit,
            'quantity'=>$quantity
        );
        xtc_db_perform('hitmeister_products',$insert_sql_array);
        return xtc_db_insert_id();
    }
    
    /**
     * Loescht eine Zuweisung in der Tabelle hitmeister_products zu einer 
     * Hitmeister id_item
     * 
     * @param String $hitmeister_id_item
     * @throws Exception
     */
    public static function delete_hitmeister_product_allocation($hitmeister_id_item){
        if(strlen($hitmeister_id_item) < 1){
            throw new Exception('delete_hitmeister_product_allocation() Missing Param(s)');
        }
        xtc_db_query(sprintf(
                "DELETE FROM hitmeister_products WHERE hitmeister_id_item='%s'",
                $hitmeister_id_item
        ));
    }
    
    /**
     * FUER DAS HINZUFUEGEN VON ARTIKELN IN DEN REAL ONLINEKATALOG STELLEN WIR
     * CSV DATEIEN BEREIT. WENN DIE FILES VON HITMEISTER KONTROLLIERT WORDEN SIND
     * UND DIE ARTIKELDATEN VALIDE WAREN, KOENNEN WIR DIE DATEI AUSLESEN UND DIE
     * GEMELDETEN ARTIKEL IN YES SPEICHERN.
     * 
     * BEIM HINZUFUEGEN VON ARTIKELN IN DEN REAL KATALOG WERDEN LEDIGLICH DIE 
     * ROHDATEN GESPEICHERT - ARTIKELZUWEISUNGEN FINDEN DANN MIT PREIS USW STATT
     * 
     * WIR LESEN ALSO DIE URL MIT DEN ARTIKELDATEN AUS (1. Spalte = EAN) UND 
     * GEBEN MIT DIESER FUNKTION EIN ARRAY DER CSV DATEN ZURUECK
     * 
     * @param String $uri
     * @return Array
     * @throws Exception
     */
    public static function get_import_file_content($uri){
        $content = file_get_contents($uri);
        if($content === false){
            throw new Exception('Cant read '.$uri);
        }
        if(!is_file(self::SAVE_DIR.'/'.basename($uri))){
            file_put_contents(self::SAVE_DIR.'/'.basename($uri), $content) 
                    or die('Cant create '.self::SAVE_DIR.'/'.basename($uri));
        }
        return self::parse_import_file_csv(self::SAVE_DIR.'/'.basename($uri));
    }
    
    /**
     * WANDELT DAS CSV IMPORTFILE IN EIN ARRAY UM
     * 
     * @param String $file
     * @return Array
     */
    public static function parse_import_file_csv($file){
        $csv = array();
        if (($handle = fopen($file, "r")) !== FALSE) {
            $row = 0;
            while (($data = fgetcsv($handle, 10000, self::PRODUCT_IMPORT_DELIMITER)) !== FALSE) {
                if($row == 0 or sizeOf($data) < 2){
                    $row++;
                    continue;
                }
                $csv[] = $data;
                $row++;
            }
            fclose($handle);
        }        
        return $csv;
    }
    
    public static function add_line_to_export($file,$products_id){
        //global $_POST;
        $f = str_replace('.json','.csv',$file);
        $f = str_replace('hitmeister_category_attributes_','hitmeister_csv_import_', $f);
        $target_file = self::SAVE_DIR.DIRECTORY_SEPARATOR.$f;
        $header = self::get_csv_header_from_export_config_json($file);
        if(!is_file($target_file)){
            file_put_contents($target_file, implode(self::PRODUCT_IMPORT_DELIMITER,$header).self::PRODUCT_IMPORT_NEWLINE) or die('Cant create '.$target_file);
        }
        $str_arr=array();
        if(!isset($_POST['offer_id'])){
            $_POST['offer_id'] = $products_id;
        }
        foreach($header as $k=>$v){
            if(is_array($_POST[$v])){
                $val = current($_POST[$v]);
            }else{
                $val = $_POST[$v];
            }
            $val = str_replace("\r\n",'<br />',$val);
            $str_arr[] = html_entity_decode($val,ENT_NOQUOTES,'UTF-8');
        }
        file_put_contents($target_file, implode(self::PRODUCT_IMPORT_DELIMITER,$str_arr).self::PRODUCT_IMPORT_NEWLINE, FILE_APPEND);
        return $target_file;
    }
    
    public static function is_product_saved_in_csv_import_file($products_id,$product_csv_file){
        if(!is_file($product_csv_file)){
            return false;
        }
        if (($handle = fopen($product_csv_file, "r")) !== FALSE) {
            while (($data = fgetcsv($handle, 1000, self::PRODUCT_IMPORT_DELIMITER)) !== FALSE) {
                if($data[0] == $products_id)
                    return true;
            }
            fclose($handle);
        }
        return false;
    }
    
    public function get_hitmeister_category_name_from_id($id){
    	$uri = '/categories/'.$id;
	$params = [
		'storefront'=>'de',
	];
	$decode_json = false;
	$res = json_decode($this->request($uri, $params, $decode_json));
        if($res->data->title_plural !== Null){
            return $res->data->title_plural;
        }
        return 'Unknown/Invalid';
    }
    
    public static function update_local_quantity(int $products_id, int $quantity){
        $update_sql_array = array(
            'quantity'=>$quantity
        );
        xtc_db_perform('hitmeister_products',$update_sql_array,'update',
                "products_id='".$products_id."'"
        );
    }
    
    public function get_quantity( $products_id, $local = false ){
        if($local === true){
            $query = xtc_db_query(sprintf(
                    "SELECT quantity FROM hitmeister_products WHERE products_id='%d'",
                    $products_id
            ));
            if(!xtc_db_num_rows($query)){
                return 0;
            }
            $record = xtc_db_fetch_array($query);
            return $record['quantity'];
        }
    }
    
    /**
     * eine valide id_unit ist zb   385415367663
     * eine valid id_product ist zb 390077036
    */
    public function sync_quantity($products_id){
	$sender = 0;
	$recipient_array = main::get_notice_recipients('hitmeister');
    
	$id_unit = $this->get_id_unit_from_products_id($products_id);
        if($id_unit < 1){
		require_once(DIR_FS_INC.'yes_write_notice.inc.php');
	        yes_write_notice('Kaufland: Fehlende Artikelzuweisung', sprintf('Es wurde festgestellt, dass zur pID %d keine Kaufland-Zuweisung (id_unit) gespeichert ist. Durch diese fehlerhafte Zuweisung konnte ein lokaler Bestandsabgleich nicht gespeichert werden. Bitte den entsprechenden Artikel im Kaufland Sellerkonto prüfen und ggf die lokale Zuweisung in YES aktualisieren.',
	        	$products_id
	        ), $sender, $recipient_array);
		return false;
        }
	$uri = '/units/'.$id_unit;
	$params = [
		'storefront'=>'de'
	];
	$decode_json = false;
	$res = json_decode($this->request($uri, $params, $decode_json));
	$quantity = $res->data->amount;
        
	if( (int)$quantity < 1 and $res->message != ''){
		require_once(DIR_FS_INC.'yes_write_notice.inc.php');
	        yes_write_notice('Kaufland: Unbekannte SKU', sprintf('Es wurde festgestellt, dass zur pID %d eine ungültige Kaufland-Zuweisung (id_unit=%s) gespeichert ist. Durch diese fehlerhafte Zuweisung konnte ein lokaler Bestandsabgleich nicht gespeichert werden. Bitte den entsprechenden Artikel im Kaufland Sellerkonto prüfen und ggf die lokale Zuweisung in YES aktualisieren.',
	        	$products_id, $id_unit
	        ), $sender, $recipient_array);
		return false;
	}
	$this->update_local_quantity(
		$products_id, 
		$quantity
	);
    }
    
    public function get_order_invoices($id_order) {
        $json_decode = false;
        $params = [
            'storefront'=>'de',
        ];
        $uri = '/order-invoices/';
        return $this->request($uri, $params,$json_decode);
    }
    
    public function delete_order_invoice(string $id_order, string $id_invoice) {
        $params = [
            'storefront'=>'de',
        ];
        $uri = '/order-invoices/'.$id_order.'/'.$id_invoice;
        $post_body = array();
        return $this->request( $uri, $params, false, $post_body, 'DELETE' );
    }
    
    public function get_subscriptions(){
        $params = [
            'storefront'=>'de',
        ];
        $uri = '/subscriptions';
        return $this->request( $uri, $params, false );
    }
      
    public function subscribe( string $event_name ){
        $uri = '/subscriptions';
	$callback_url = (main::isDev(true)) ? 'http://agri.abcde.biz/yes/admin/hitmeister_callback.php' : HTTPS_CATALOG_SERVER.'/admin/hitmeister_callback.php';
	$fallback_email = (main::isDev(true)) ? 'm.aspeleiter@yes-websolutions.de' : EMAIL_SUPPORT_ADDRESS;
        $params = ['storefront'=>'de'];
        $post_body = [
            'callback_url' => $callback_url,
            'fallback_email'=> $fallback_email,
            'event_name'=>$event_name,
        ];
        return $this->request( $uri, $params, false, $post_body,'POST');
    }
    
    public function unsubscribe( string $event_id ){
        $uri = '/subscriptions/'.$event_id;
        $params = ['storefront'=>'de'];
        $post_body = [];
        return $this->request( $uri, $params, false, $post_body,'DELETE');
    }
    
    public function set_sendOrderUnits(string $id_order_unit, string $carrier_code, string $trackingnumbers){
    	$uri = '/order-units/'.$id_order_unit.'/send';
	$params = [
		'storefront'=>'de',
	];
        $post_data = [
            "tracking_numbers" => $trackingnumbers,
            "carrier_code" => $carrier_code
        ];
	$decode_json = false;
	$res = json_decode($this->request($uri, $params, $decode_json,$post_data,'PATCH'));
        if($res->data->message !== Null){
            return false;
        }
        return true;
    }
}
