<?php
class yes_versandabschluss {
    private static function get_dompdf_ship_parts_path():string{
        return \main::get_exportdata_path().'DOMPDF_SHIP_PARTS/';
    }
    public function check_step($step){
        switch($step){
            case 1:
                global $basics;
                if(!is_object($basics)){
                    die('error: basics not initialized');
                }
                $files = $basics->get_directory_content(self::get_dompdf_ship_parts_path());
                $youngest_file_seconds = 0;
                $pdf_files_in_queue = false;
                foreach($files as $file){
                    if( substr($file,strlen($file)-3, strlen($file)) == 'pdf'){
                        $pdf_files_in_queue = true;
                        $file_date = filemtime(self::get_dompdf_ship_parts_path().$file);
                        $diff = time()-$file_date;
                        if($youngest_file_seconds == 0){
                            $youngest_file_seconds = $diff;
                        }else{
                            if($diff < $youngest_file_seconds){
                                $youngest_file_seconds = $diff;
                            }
                        }
                    }
                }
                return array(
                    'youngest_file_seconds'=>$youngest_file_seconds,
                    'success'=>!$pdf_files_in_queue
                );
        }
    }
    
    public function check_shipable($shipping, $check_storno = false){
        $message = '';
        $success = true;
        $delete = false;
        if($shipping['reclamations_id'] > 0){
            return array(
                'success'=>$success,
                'message'=>$message,
                'delete'=>$delete
            );
        }
        if($check_storno){
            // PRUEFEN OB ORDER STORNIERT
            $status_query = xtc_db_query(sprintf(
                    "SELECT orders_status FROM orders WHERE orders_id='%s'",
                    $shipping['orders_id']
            ));
            $record = xtc_db_fetch_array($status_query);
            if($record['orders_status'] == ORDERS_STATUS_STORNIERT){
                $success = false;
                $delete = true;
                $message = sprintf(MSG_AUTOREMOVE_STORNO_ORDER_FROM_SHIPPING,$shipping['orders_id']);
            }
        }
        if($success and yes_count_shippable_order_products($shipping['orders_id'])<1){
            $success = false;
        }
        return array(
            'success'=>$success,
            'message'=>$message,
            'delete'=>$delete
        );
    }
    
    public static function check_requirements(){
        $needed_functions = array(
            'yes_count_shippable_order_products',
            'xtc_get_product_collies',
            'yes_add_products_history',
            'xtc_is_shipping_before_payment',
        );

        foreach($needed_functions as $check_func){
            if(!function_exists($check_func)){
                die('missing function '.$check_func.'()');
            }
        }
        $needed_classes = array(
            'products_quantity',
        );
        if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
            $needed_classes[] = 'amazon_helper';
        }

        foreach($needed_classes as $check_class){
            if(!class_exists($check_class)){
                die('missing class '.$check_class);
            }
        }

        $needed_constants = array(
            'HISTORY_ORDER_SEND',
            'TEXT_PART_DELIVERY',
            'HISTORY_SEND_COLLIES',
            'HISTORY_ORDER_SHIPPED_SENDER',
            'HISTORY_RECLAMATION_SEND',
            'HISTORY_SEND_NO_QTY_CHANGE_RECLAMATION',
            'HISTORY_RECLAMATION_SHIPPED_SENDER',
        );
        foreach($needed_constants as $check_const){
            if(!defined($check_const)){
                die('missing constant '.$check_const);
            }
        }
        $needed_auth = array(
            'orders',
        );
        if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
            $needed_auth[] = 'amazon';
        }
        if(defined('DHL_VERSENDEN_APPLICATION_ID') and DHL_VERSENDEN_APPLICATION_ID != ''){
            $needed_auth[] = 'dhl_print_label';
        }
        $auth_where_sql = '';
        foreach($needed_auth as $check_auth){
            $auth_where_sql .= sprintf(" AND %s=1 ",$check_auth);
        }
        $query = xtc_db_query(sprintf(
                "SELECT customers_id FROM admin_access WHERE customers_id='%s' %s",
                $_SESSION['customer_id'],$auth_where_sql
        ));
        if(!xtc_db_num_rows($query)){
            die('missing auth (user must have: '.implode(', ',$needed_auth).')');
        }
    }
    
    function __construct(){
        $this->check_requirements();
    }
    
    public function get_packagelist(&$messages, array $process_shipping_id_array){
        $packagelist = array();
	if(!sizeOf($process_shipping_id_array)){
            $query = xtc_db_query("select * from shippings where status='0' and csv_status=0 order by name1,customers_id");
	}else{
	    $query = xtc_db_query("select * from shippings where status='0' and csv_status=0 AND id IN(".implode(',',$process_shipping_id_array).") order by name1,customers_id");
	}
        $_shippings = array();
	while ($shipping = xtc_db_fetch_array($query)) {
            $_shippings[] = $shipping;
        }
        
        // BOF - TEILLIEFERUNG CHECK
        // ES WIRD DAS ARRAY packagelist GEFUELLT UND DER COUNTER packagelist_num
        foreach($_shippings as $shipping){
            $check = $this->check_shipable($shipping,true);
            if($check['message'] != ''){
                $messages[] = $check['message'];
            }
            if($check['success']){
                $packagelist[$shipping['versender']][] = $shipping;
                continue;
            }
            if($check['delete']){
                xtc_db_query(sprintf(
                        "DELETE FROM shippings WHERE orders_id='%s' AND status='0' and csv_status=0",
                        $shipping['orders_id']
                ));
            }
	}
        // EOF - TEILLIEFERUNG CHECK
    }
}
