<?php
require_once(DIR_FS_INC.'yes_export_order_stats.inc.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'xtc_get_customer_status_value.inc.php');
require_once(DIR_WS_CLASSES.'order.php');

define('MODULE_EXPORT_ORDER_STATS_TEXT_DESCRIPTION', 'Hier k&ouml;nnen Sie sich f&uuml;r den gew&uuml;nschten Zeitraum eine CSV Datei aller Auftr&auml;ge exportieren. Um den Export generieren zu k&ouml;nnen, ben&ouml;tigt das Userkonto die Berechtigung "f_export_order_stats".');
define('MODULE_EXPORT_ORDER_STATS_TEXT_TITLE', 'Auftragshistorie Export - CSV');
define('MODULE_EXPORT_ORDER_STATS_STATUS_DESC','Modulstatus');
define('MODULE_EXPORT_ORDER_STATS_STATUS_TITLE','Status');
define('MODULE_EXPORT_ORDER_STATS_FIBU_SEARCH','FiBu Nummern');
define('MODULE_EXPORT_ORDER_STATS_EXPORTTEXT','<br />Es wird im CSV Format exportiert, der Texttrenner ist Semikolon.');
@define('DATE_FORMAT_EXPORT', '%d.%m.%Y');  // this is used for strftime()
@define('CSV_SEPARATOR',";");
define('MODULE_EXPORT_ORDER_STATS_STARTDATE','Export Startdatum');
define('MODULE_EXPORT_ORDER_STATS_ENDDATE','Export Enddatum');
define('MODULE_EXPORT_ORDER_STATS_DATE_ERROR','Keine Auftragsdaten f&uuml;r gew&auml;hlten Zeitraum oder Fehler in der Datumsangabe');
define('MODULE_EXPORT_ORDER_STATS_BRANCHES','Rechnungen / Filialen:');
define('TEXT_ALL_BRANCHES','Alle Rechnungen');
// include needed functions

class export_order_stats{
    var $code, $title, $description, $enabled,$sort_order,$_check;


    function __construct() {
      $this->code = 'export_order_stats';
      $this->title = MODULE_EXPORT_ORDER_STATS_TEXT_TITLE;
      $this->description = MODULE_EXPORT_ORDER_STATS_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_EXPORT_ORDER_STATS_SORT_ORDER'))? MODULE_EXPORT_ORDER_STATS_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_EXPORT_ORDER_STATS_STATUS') and MODULE_EXPORT_ORDER_STATS_STATUS == 'True') ? true : false);
    }


    function process() {
        global $messageStack;
        @xtc_set_time_limit(0);
		if(!$_REQUEST['date_from'] or !$_REQUEST['date_to']){
			die('Missing Parameters.');
		}
		if(isset($_REQUEST['fibu_search']) and $_REQUEST['fibu_search'] == 1){
			if(!isset($_REQUEST['date_from_fibu']) or !isset($_REQUEST['date_to_fibu'])){
				die('Missing Parameters.');
			}
			$from = xtc_db_input($_REQUEST['date_from_fibu']);
			$to = xtc_db_input($_REQUEST['date_to_fibu']);
			$fibu = true;
		}else{
			$from = xtc_db_input($_REQUEST['date_from']);
			$to = xtc_db_input($_REQUEST['date_to']);
			$fibu = false;
		}
		$tax_export = true;
		$file = 'export_order_stats.csv';
		$branches_id = (isset($_REQUEST['branches_id'])) ? (int)xtc_db_input($_REQUEST['branches_id']) : 0;
		$data = yes_export_order_stats($from,$to.' 23:59:59',$tax_export,false,$fibu,$branches_id);
		if($data){
			header("Content-type: application/octet-stream");
			header("Content-Disposition: attachment; filename=\"$file\"");
			echo $data;
			exit;
		}else{
			$messageStack->add_session(MODULE_EXPORT_ORDER_STATS_DATE_ERROR,'error');
			xtc_redirect(xtc_href_link('module_export.php','module=export_order_stats&action=edit'));
		}
		exit;
    }


    function display() {
		if(!xtc_check_permission('f_export_order_stats')){
				return array(0=>array('text'=>MODULE_ACCESS_ERROR));
		}
		$from = yes_strftime('%Y-%m-%d',time()-60*60*24*2);
		$to = date('Y-m-d');
		
		$branches_array = array(array(
			'id'=>'',
			'text'=>TEXT_ALL_BRANCHES
		));
		$branches_query = xtc_db_query("SELECT branches_id,title FROM branches ORDER BY title");
		while($branch = xtc_db_fetch_array($branches_query)){
			$branches_array[] = array(
				'id'=>$branch['branches_id'],
				'text'=>$branch['title']
			);
		}
		$branch_select = '';
		if(sizeOf($branches_array)>1){
			$branch_select = '<p>'.MODULE_EXPORT_ORDER_STATS_BRANCHES.'<br />'.xtc_draw_pull_down_menu('branches_id',$branches_array).'</p>';
		}

		$array = array(
			'text' => MODULE_EXPORT_ORDER_STATS_EXPORTTEXT.'<br /><br />'.
			$branch_select.
			(
				(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True') ?
			xtc_draw_radio_field('fibu_search',0,true)
					: ''
			).
			MODULE_EXPORT_ORDER_STATS_STARTDATE.'<br />'.xtc_draw_input_field('date_from',$from,'max="'.$from.'"',false,'date').'<br />'.
			MODULE_EXPORT_ORDER_STATS_ENDDATE.'<br />'.xtc_draw_input_field('date_to',$to,'max="'.$to.'"',false,'date').'<br />'.
			(
				(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True') ?
			'<hr noshade="noshade" />'.xtc_draw_radio_field('fibu_search',1).
			MODULE_EXPORT_ORDER_STATS_STARTDATE.' (FiBu Nr)<br />'.xtc_draw_input_field('date_from_fibu',$from,'max="'.$from.'"',false,'date').'<br />'.
			MODULE_EXPORT_ORDER_STATS_ENDDATE.' (FiBu Nr)<br />'.xtc_draw_input_field('date_to_fibu',$to,'max="'.$to.'"',false,'date').'<br />'
					: ''
			).
                    
                                ((defined('PAY_MODULE_MARGE') and PAY_MODULE_MARGE == 'True') ?
			'<hr noshade="noshade" />'.xtc_draw_checkbox_field('marge',1).
			'Export '.TEXT_MARGE_DIFF.'<br />'
                                : ''
                        ).
                    
			'<br />'.yes_draw_href_button(IMAGE_EXPORT,'','width:120px;','submit') . '&nbsp;' .
			yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=export_order_stats'),'width:120px;')
		);
		return $array;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_EXPORT_ORDER_STATS_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_EXPORT_ORDER_STATS_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
      xtc_db_query("ALTER TABLE " . TABLE_ADMIN_ACCESS . " ADD COLUMN `f_export_order_stats` INT(1) NOT NULL");
	  xtc_db_query("UPDATE admin_access SET f_export_order_stats=1 WHERE customers_id='1'");
	}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
      xtc_db_query("ALTER TABLE " . TABLE_ADMIN_ACCESS . " DROP COLUMN `f_export_order_stats`");
    }

    function keys() {
      return array('MODULE_EXPORT_ORDER_STATS_STATUS');
    }
  }
