<?php
class yes_export_module_products_name_amazon extends yes_export_module {
    function __construct($module_name){
	$this->id = $module_name;
	$this->text = 'Artikelname Amazon: "[Herst.] [Art-Nr] [Titel]"';
	$this->type = 'large_text';
	/*
	$this->database_table = 'products';
	$this->database_table_field = 'products_weight';
	$this->function_name = 'xtc_get_ext_products_weight';
	$this->function_file = DIR_FS_INC.'xtc_collis.inc.php';
	$this->function_class = '';
	 */
    }
    
    public function get_value_from_array($array){
	 if(isset($array[$this->id])) return $array[$this->id];
	 if(!isset($array['products_id'])) return 'Missing products_id in '.basename(__FILE__).': '.$this->id;
	 return $this->get_value_from_db($array['products_id']);
     }

    public function get_value_from_product_instance($product,$slave_title = false){
	if($product->info['amazon_title'] != ''){
	    return $product->info['amazon_title'];
	}
	$manufacturers_data = $product->get_manufacturers_data();
	$str = '';
	if(sizeOf($manufacturers_data)){
	    $str .= $manufacturers_data['manufacturers_name'].' ';
	}
	if($product->info['products_model'] != '')
	    $str .= $product->info['products_model'].' ';
	if($slave_title){
	    $str .= $product->info['slave_title'];
	}else{
	    $str .= $product->info['products_name'];
	}
	return $str;
    }
}
