<?php
/*
 * DB PROCESS FOR KASSE
 * @author: mario aspeleiter <dazze@gmx.de>
 * UPDATE order as versendet
*/
if(isset($_REQUEST['orders_id'])){
	$orders_id = (int)xtc_db_input($_REQUEST['orders_id']);
	$order = new order($orders_id);
	$cID = $order->customer['ID'];

	$paymode_id = xtc_db_input($_REQUEST['paymode']);
	$paymode_data_query = xtc_db_query(sprintf("SELECT payment_code,payment_title FROM kasse_payments WHERE kasse_payments_id='%s'",$paymode_id));
	$paymode_data = xtc_db_fetch_array($paymode_data_query);
	$paymode_title = xtc_db_prepare_input($paymode_data['payment_title']);
	$paymode_code = $paymode_data['payment_code'];

	$delete_shippingcosts = false;
	$save_in_wrapping_counter = true;
	if($order->info['orders_status'] == ORDERS_STATUS_VERSENDET){
		$status = ORDERS_STATUS_ABGESCHLOSSEN;
	}else{
		$status = ORDERS_STATUS_BEZAHLT;
	}

	// VERSENDER VORSCHLAGEN
	if(isset($_REQUEST['shipper']) and $_REQUEST['shipper'] != ''){
		$versender = xtc_db_input($_REQUEST['shipper']);
		$versender_query = xtc_db_query("SELECT versender,orders_status FROM orders WHERE orders_id='".$orders_id."'");
		$saved_versender = xtc_db_fetch_array($versender_query);
		if($saved_versender['versender'] != $versender) {
			if(!in_array($_REQUEST['shipper'],$VERSENDER)){
                            $order->add_history(intval($saved_versender['orders_status']),
                                0,'Vorgeschlagener Versender wurde in Kassenabwicklung entfernt.'
                            );
                            xtc_db_query("UPDATE orders SET versender='',last_modified=now() WHERE orders_id='".$orders_id."'");
			}else{
                            $order->add_history(intval($saved_versender['orders_status']),
                                0,"Versender ".$versender." wurde in Kassenabwicklung vorgeschlagen."
                            );
                            xtc_db_query("UPDATE orders SET versender='".$versender."',last_modified=now() WHERE orders_id='".$orders_id."'");
			}
		}


		xtc_db_query("UPDATE orders SET versender='".$versender."' WHERE orders_id=".$orders_id);
	}
		
	$send_string = sprintf('Bestellung wurde an der Kasse bezahlt (%s) und auf Bezahlt gesetzt sowie fuer die (Filial-)Warenausgabe gespeichert.',$paymode_title);
	xtc_db_query("UPDATE orders SET orders_status='".$status."',last_modified=now(),date_payment=now(),payment_method='bar_kasse', payment_class='bar_kasse' WHERE orders_id=".$orders_id);

	$insert_sql_array = array(
		'orders_id'=>$orders_id,
		'branches_id'=>$_SESSION['allocated_branches_id'],
		'date_added'=>'now()'
	);
	xtc_db_perform('wrapping_counter',$insert_sql_array);

        if(isset($_REQUEST['given']) and $_REQUEST['given'] != ''){
            $send_string .= ' / Bar erhalten: '.number_format((float)$_REQUEST['given'],2,',','.');
        }
        $order->add_history(intval($status),0,$send_string);
		// FIBUNUMBER ADDON
		if($status == ORDERS_STATUS_ABGESCHLOSSEN){
		    if(MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
			    if( strlen($order->get_fibunumber($check_all = true)) < 2
				    &&	MODULE_OTHER_FIBUNUMBERS_AUTOMATIC == 'True'){
				    $fibu_number = $order->add_fibunumber();
				    $order->add_history($status,false,sprintf(HISTORY_FIBUNUMBER_AUTOMATIC_ADD,$fibu_number));
			    }
		    }
		}
		
		// BOF TEILLIEFERUNG
		if($status == ORDERS_STATUS_ABGESCHLOSSEN){
			foreach($order->products as $product){
				$order->add_quantity_shipped($product['opID'], $product['qty']-$product['quantity_shipped']);
			}
		}
		// EOF TEILLIEFERUNG
    $order->save_real_shipping_cost();
    
    // in Kassenhistorie speichern
    require_once(DIR_WS_CLASSES.'counter_history.php');
    $total = 0;
    foreach($order->totals as $ot){
        switch($ot['class']){
            case 'ot_total':
                $total = $ot['value'];
                break;
        }
    }
    $CH = new counter_history($cbID);
    $CH->insert_entry(
        $order,
        $smarty,
        array(
            'orders_id'=>$orders_id,
            'customers_id'=>$cID,
            'date_purchased'=>date("Y-m-d H:i:s"),
            'total'=>$total,
            'send'=>((isset($_REQUEST['shipper']) and $_REQUEST['shipper'] != '') ? 1 : 0),
            'paymode'=>xtc_db_input($paymode_code),
            'branches_id'=>$cbID
    ));
    
    $customer = new customer($cID);
    $customer->update_current_account_value();
}
