<?php
require_once('includes/application_top.php');
@set_time_limit(0);

require_once('includes/classes/class.ebay.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
$EBAYAPI = new ebayAPI;
$smarty = new yesSmarty;
$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
switch($action){
	case 'test':
		$mID = intval($_GET['mID']??0);
		$imap_account = yes_query(
			"SELECT mailserver, email_user, email_password FROM mailaccounts WHERE mailaccounts_id=:id",[
				'id'=>$mID
			],true
		);
		if($imap_account === false){
			die('Invalid Mailaccount');
		}
		$imap = new \YES4Trade\Model\imap([
			'hostname'=>$imap_account['mailserver'],
			'username'=>$imap_account['email_user'],
			'password'=>$imap_account['email_password']
		]);
		try{
			$imap->connect(); // setzt imap->inbox
		}catch(\Exception $e){
			printf('Mailaccount %s kann sich nicht zum Server verbinden.<div class="ui-state-error" style="margin-top:10px; padding: 3px;">&#128078; Das hat leider nicht geklappt.</div><div style="font-family: system, fixed;font-size: 0.7em;color:#777;">%s</div>',
				$imap_account['email_user'],
				$e->getMessage()
			);
			exit;
		}
		$status = imap_mailboxmsginfo($imap->inbox);
		$bytes = (floatval($status->Size)>0) ? \basics::formatBytes($status->Size,2) : '0 Bytes';
		printf('Mailaccount %s hat %d Nachrichten im Posteingang mit insgesamt %s Speicherverbrauch.<div class="ui-state-default" style="margin-top:10px; padding: 3px;">&#128077;  Die %s Verbindung klappt perfekt.</div>',
			$imap_account['email_user'], $status->Unread, $bytes,$status->Driver

		);
		exit;
		break;
	case 'delete':
		xtc_db_query("DELETE FROM mailaccounts WHERE mailaccounts_id='".xtc_db_input($_GET['mID'])."'");
		$messageStack->add_session('Emailkonto wurde entfernt.','success');
		xtc_redirect(xtc_href_link('mailaccounts.php',xtc_get_all_get_params(array('action','mID'))));
		break;
	case 'save_new':
		$insert_sql_array = array(
			'email_address'=>$_POST['email_address'],
			'email_password'=>$_POST['email_password'],
			'mailserver'=>$_POST['mailserver'],
			'ebay_user'=>$_POST['ebay_user'],
			'email_user'=>$_POST['email_user'],
			'protocol'=>$_POST['protocol']
		);
		xtc_db_perform('mailaccounts',$insert_sql_array);
		$messageStack->add_session('Neues Emailkonto wurde gespeichert..','success');
		xtc_redirect(xtc_href_link('mailaccounts.php',xtc_get_all_get_params(array('action'))));
		break;
	case 'save':
		$update_sql_array = array(
			'email_address'=>$_POST['email_address'],
			'mailserver'=>$_POST['mailserver'],
			'ebay_user'=>$_POST['ebay_user'],
			'email_user'=>$_POST['email_user'],
			'protocol'=>$_POST['protocol']
		);
		xtc_db_perform('mailaccounts',$update_sql_array,'update',"mailaccounts_id='".xtc_db_input($_GET['mID'])."'");
		$messageStack->add_session('Emailkonto wurde aktualisiert.','success');
		xtc_redirect(xtc_href_link('mailaccounts.php',xtc_get_all_get_params(array('action','mID'))));
		break;
	case 'delete':
		$id = xtc_db_input($_GET['id']);
		xtc_db_query("DELETE FROM ebay_auth WHERE id='".$id."'");
		$messageStack->add_session('Token wurde gel&ouml;scht.','success');
		xtc_redirect(xtc_href_link('token.php',xtc_get_all_get_params(array('action','id'))));
		break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
$buttons = array();
if(!isset($_REQUEST['action']) or $_REQUEST['action'] != 'new'){
    $buttons[] = array('text'=>TEXT_ADD_NEW_MAILACCOUNT, 
	'link'=>xtc_href_link('mailaccounts.php','action=new'),
	'lbOn'=>false,
	'auth'=>true
    );
}

$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
$smarty->display('mailaccounts.html');
?>

<script type="text/javascript">
<!--
function really_delete(id,email){
	yes = confirm('Die Daten des Emailkontos '+email+' wirklich l�schen?');
	if(yes){
		window.location.href='<?php echo xtc_href_link('mailaccounts.php',xtc_get_all_get_params(array('action','id')).'action=delete'); ?>&id='+id;
	}
}
//-->
</script>

<table border="0" width="100%" cellpadding="0" cellspacing='2'>
<tr>
	<td class="main">Hier k&ouml;nnen Sie E-Mail Konten hinterlegen die Sie mit Ihrem YES-System abrufen wollen.</td>
</tr>
<tr>
	<td valign="top" width="75%" class="ui-widget-content">
		<table class="yes-ui-table">
			<thead>
				<tr class="ui-widget-header">
					<th>ID</th>
					<th>E-Mail Adresse</th>
					<th>Username</th>
					<th>Mailserver</th>
					<th>Protokoll</th>
					<th>Ebayuser</th>
					<th>&nbsp;</th>
				</tr>
			</thead>
			<tbody>
<?php
$accounts_query =  xtc_db_query("SELECT * FROM mailaccounts ORDER BY email_address");
while($account = xtc_db_fetch_array($accounts_query)){
	$selected = false;
	if ( ((!isset($_GET['mID'])) && (!isset($_GET['mID'])) || (@$_GET['mID'] == $account['mailaccounts_id'])) && (!isset($mInfo)) && (substr($action, 0, 3) != 'new') ) {
		$mInfo = new objectInfo($account);
		$selected = true;
	}
	if($selected){
?>
		<tr onmouseover="this.style.cursor='hand'" onclick="document.location.href='<?php echo xtc_href_link('mailaccounts.php',xtc_get_all_get_params(array('mID','action')).'mID='.$account['mailaccounts_id'].'&action=edit');?>';" class="ui-state-highlight">
<?php
	}else{
?>
		<tr onmouseover="this.style.cursor='hand';" onclick="document.location.href='<?php echo xtc_href_link('mailaccounts.php',xtc_get_all_get_params(array('mID','action')).'mID='.$account['mailaccounts_id']);?>';">
<?php
	}
?>
			<td><?php echo $account['mailaccounts_id']; ?></td>
			<td><?php echo $account['email_address']; ?></td>
			<td><?php echo $account['email_user']; ?></td>
			<td><?php echo $account['mailserver']; ?></td>
			<td><?php echo $account['protocol']; ?></td>
			<td><?php echo $account['ebay_user']; ?></td>
			<td align="right"><?php if(!$selected){?><a href="<?php echo xtc_href_link('mailaccounts.php',xtc_get_all_get_params(array('mID','action')).'mID='.$account['mailaccounts_id']);?>"><?php echo xtc_image('images/icon_info.gif','Auswahl'); ?><?php }else{ ?><?php echo xtc_image('images/icon_arrow_right.gif','Konto bearbeiten'); ?><?php } ?></td>
		</tr>

<?php
}
?>
			</tbody>
		</table>
	</td>

<?php
    $heading = array();
    $contents = array();
    switch ($action) {
      case 'delete_confirm':
		$heading[] = array('text' => '<b>Email-Konto ' . $mInfo->email_address . ' l&ouml;schen</b>');
		$contents[] = array('align' => 'center', 'text' => 'Soll dieses Emailkonto wirklich aus dem YES System gel&ouml;scht werden?');
		$contents[] = array('text' => '<a href="'.xtc_href_link('mailaccounts.php',xtc_get_all_get_params(array('action'))).'">'.xtc_image_button('button_cancel.gif',IMAGE_CANCEL).'</a>&nbsp;&nbsp;<a href="'.xtc_href_link('mailaccounts.php',xtc_get_all_get_params(array('action')).'action=delete').'">'.xtc_image_button('button_delete.gif',IMAGE_DELETE).'</a>');
		break;
      case 'new':
		$heading[] = array('text' => '<b>Neues Email-Konto hinzuf&uuml;gen</b>');
		$contents = array('form' => xtc_draw_form('new', 'mailaccounts.php?'.xtc_get_all_get_params(array('action','mID')).'action=save_new'));
		$contents[] = array('text' => '<b>E-Mail Adresse:</b>');
		$contents[] = array('text' => xtc_draw_input_field('email_address','','maxlength="255" size="30"'));
		$contents[] = array('text' => '<b>Konto Username:</b>');
		$contents[] = array('text' => xtc_draw_input_field('email_user','','maxlength="255" size="30"'));
		$contents[] = array('text' => '<b>Konto Passwort:</b>');
		$contents[] = array('text' => xtc_draw_password_field('email_password','','maxlength="255" size="30"'));
		$contents[] = array('text' => '<b>Mailserver:</b>');
		$contents[] = array('text' => xtc_draw_input_field('mailserver','','maxlength="255" size="30"'));
		$contents[] = array('text' => '<b>Protokoll:</b>');
		$contents[] = array('text' => xtc_draw_pull_down_menu('protocol',array(0=>array('id'=>'pop3','text'=>'POP3'),1=>array('id'=>'imap','text'=>'IMAP'))));
		$contents[] = array('text' => '<b>Ebay-User:</b>');
		$contents[] = array('text' => xtc_draw_pull_down_menu('ebay_user',xtc_get_ebay_users(),EBAY_USER));
		$contents[] = array('text' => '<input type="button" value="Abbrechen" onClick="window.location.href=\''.xtc_href_link('mailaccounts.php',xtc_get_all_get_params(array('action'))).'\';">&nbsp;&nbsp;<input type="submit" value="Speichern">');
		break;
      case 'edit':
		$heading[] = array('text' => '<b>Email-Konto ' . $mInfo->email_address . ' bearbeiten</b>');
		$contents = array('form' => xtc_draw_form('edit', 'mailaccounts.php?'.xtc_get_all_get_params(array('action','mID')).'action=save&mID='.$mInfo->mailaccounts_id));
		$contents[] = array('text' => '<b>E-Mail Adresse:</b>');
		$contents[] = array('text' => xtc_draw_input_field('email_address',$mInfo->email_address,'maxlength="255" size="30"'));
		$contents[] = array('text' => '<b>Konto Username:</b>');
		$contents[] = array('text' => xtc_draw_input_field('email_user',$mInfo->email_user,'maxlength="255" size="30"'));
		$contents[] = array('text' => '<b>Konto Passwort:</b>');
		$contents[] = array('text' => '*** wird nicht angezeigt ***');
		$contents[] = array('text' => '<b>Mailserver:</b>');
		$contents[] = array('text' => xtc_draw_input_field('mailserver',$mInfo->mailserver,'maxlength="255" size="30"'));
		$contents[] = array('text' => '<b>Protokoll:</b>');
		$contents[] = array('text' => xtc_draw_pull_down_menu('protocol',array(0=>array('id'=>'pop3','text'=>'POP3'),1=>array('id'=>'imap','text'=>'IMAP')),$mInfo->protocol));
		$contents[] = array('text' => '<b>Ebay-User:</b>');
		$contents[] = array('text' => xtc_draw_pull_down_menu('ebay_user',xtc_get_ebay_users(),$mInfo->ebay_user));
		$contents[] = array('text' => '<input type="button" value="Abbrechen" onClick="window.location.href=\''.xtc_href_link('mailaccounts.php',xtc_get_all_get_params(array('action'))).'\';">&nbsp;&nbsp;<input type="submit" value="Speichern">');
		break;
      default:
		if (isset($mInfo)) { // category info box contents
			$heading[] = array('text' => '<b>E-Mail Konto ' . $mInfo->email_address . '</b>');
			$contents[] = array(
			    'align' => 'center',
			    'text' => yes_draw_href_button(IMAGE_EDIT, xtc_href_link('mailaccounts.php', xtc_get_all_get_params(array('mID','action')).'mID=' . $mInfo->mailaccounts_id . '&action=edit'),'width:180px;')
			);
			$contents[] = array(
			    'align' => 'center',
			    'text' => yes_draw_href_button(IMAGE_DELETE, xtc_href_link('mailaccounts.php', xtc_get_all_get_params(array('mID','action')).'mID=' . $mInfo->mailaccounts_id . '&action=delete_confirm'),'width:180px;')
			);
			$contents[] = array(
			    'align' => 'center',
			    'text' => yes_draw_href_button('E-Mail Test', xtc_href_link(basename(__FILE__), xtc_get_all_get_params(array('mID','action')).'mID=' . $mInfo->mailaccounts_id . '&action=test'),'width:180px;','button','lbOn')
			);
		}
		break;
    }

    if ((xtc_not_null($heading)) && (xtc_not_null($contents))) {
      echo '            <td width="25%" valign="top" class="ui-widget-content">' . "\n";

      $box = new box;
      echo $box->infoBox($heading, $contents);

      echo '            </td>' . "\n";
    }
?>
</tr>
</table>
<?php
require(DIR_WS_INCLUDES . 'application_bottom.php'); 
require(DIR_WS_INCLUDES . 'footer.php'); 
