<?php
/* --------------------------------------------------------------
   $Id: orders_edit.php,v 1.1

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(orders.php,v 1.27 2003/02/16); www.oscommerce.com
   (c) 2003	 nextcommerce (orders.php,v 1.7 2003/08/14); www.nextcommerce.org

   Released under the GNU General Public License

   To do: Rabatte ber�cksichtigen
   --------------------------------------------------------------*/
require('includes/application_top.php');  
require_once(DIR_WS_CLASSES.'class.help.php');
require_once(DIR_FS_INC . 'xtc_get_serial_number.inc.php');
  
require_once(DIR_FS_INC . 'xtc_oe_get_tax_rate.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_customers_status.inc.php');
  
require_once(DIR_FS_INC . 'xtc_get_customer_status_value.inc.php');
  
require_once(DIR_FS_INC . 'xtc_get_tax_class_id.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_allow_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_i_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_options_name.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_options_values_name.inc.php');
require_once(DIR_FS_INC . 'yes_end_auction_add.inc.php');
require_once(DIR_FS_INC . 'xtc_get_country_data_from_name.inc.php');
require_once(DIR_FS_ADMIN . 'includes/classes/order.php');
// yes accounting  
$admin_access = main::get_admin_access();
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$smarty->assign('FORM_END','</form>');

// load all enabled shipping modules
require (DIR_FS_CATALOG.'includes/classes/shipping.php');
require (DIR_FS_CATALOG.'inc/xtc_count_shipping_modules.inc.php');
if(isset($_REQUEST['oID']) and (int)$_REQUEST['oID'] > 0){
    $order = new order((int)xtc_db_input($_REQUEST['oID']));
    if($order->info['orders_status'] == ORDERS_STATUS_UPSELLING){
        $messageStack->add_session(MSG_ORDER_IN_UPSELLING,'error');
        xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
    }
}
if(isset($_GET['edit_action']) and $_GET['edit_action'] == 'shipping'){
    $_SESSION['delivery_zone'] = $order->delivery['iso_code_2'];
}
$shipping_modules = new shipping;
$allow_edit_actions = true;

$action = (isset($_GET['action']))?$_GET['action']:'';
if($order->has_current_tax_failure()){
    $allow_edit_actions = false;
}

if(!isset($_REQUEST['oID'])){
    xtc_redirect(xtc_href_link(FILENAME_ORDERS));
}

// Errechne neue Gesamtsumme fuer die Bestellung Ende
if($action == 'ajax_address_edit'){
    require_once(DIR_FS_CATALOG.'includes/smarty_plugins/function.icon.php');
?>
<style type="text/css">
.address_book_entries{
    border: 1px solid #000;
    padding: 4px;
    clear: both;
    display: block;
}
.ab_entry:hover{
    color: #000;
}
.ab_entry{
    color: #444;
    cursor: pointer;
    padding-bottom: 2px;
}
.ab_entry::before{
    content:url(images/arrow_down.gif);
    padding-right: 10px;
}

</style>
<script type="text/javascript">
var AB_ARRAY = [];
var ADDRESS_TYPE = '<?php echo $_GET['address_type']; ?>';
$().ready(function(){
    var _url = window.location.pathname;
    var _filename = _url.substring(_url.lastIndexOf('/')+1);
	$('#address_update_button').click(function(){
		$.ajax({
			url: $('form#ajax_address_edit').attr('action'),
			dataType: 'json',
			data: $('form#ajax_address_edit').serialize(),
			success: function(json){
			
			    if(_filename == 'shipping.php'){
                                
                                
<?php
                                if(isset($_GET['shipping_v2']) and $_GET['shipping_v2'] == '1'){
?>
                            // ADRESSE IN LISTING AUF shipping.php AENDERN
                            // <a data-orders_id="13462" href="javascript:;" id="shipping_address_edit" title="Bearbeiten Versandadresse">SE-12345</a>
                            // sowie
                            // <div class="full_address" style="display: none;">
                            //            Der Europaer <br>Der-Europaer<br>12345 Oslo<br>Sweden
                            //            <br>☎ 040-123456
                            //            <br>📧 der-euro@yes4trade.de
                            //        </div>
                            $('a[data-orders_id="<?php echo $_GET['oID']; ?>"]').each(function(){
                                $(this).text(json.UPDATE_ARRAY.delivery_country_code+'-'+json.UPDATE_ARRAY.delivery_postcode);
                                $(this).parent().parent().find('div.full_address').html(json.UPDATE_ARRAY.delivery_address_for_shipping);
                            });
                            // WIRD AUCH IN DER shipping.php BEIM ERZEUGEN AUF-
                            // GERUFEN
                            $( document ).tooltip({
                              items: ".short_address",
                              content: function() {
                                var element = $( this );
                                return element.next('.full_address').html();
                              }
                            });    
                                                        
<?php
                                }else{
?>                                
                                // KANN NACH V2 Umstellung weg - 2021/03
				// SHIPPING HANDLING
				var _NAME = (json.UPDATE_ARRAY.delivery_company != '') ? json.UPDATE_ARRAY.delivery_company : json.UPDATE_ARRAY.delivery_name;
				var _LOCATION = '';
				markitred = false;
				if(json.UPDATE_ARRAY.delivery_suburb.toLowerCase().indexOf("packstation") > -1 || json.UPDATE_ARRAY.delivery_street_address.toLowerCase().indexOf("packstation") > -1){
				    markitred = true;
				}
				if(markitred){
				    _LOCATION = '<font color="#FF0000">';
				}
				if(json.UPDATE_ARRAY.delivery_suburb != ''){
				    _LOCATION += json.UPDATE_ARRAY.delivery_suburb+'<br />';
				}
				_LOCATION += json.UPDATE_ARRAY.delivery_street_address;
				if(markitred){
				    _LOCATION += '</font>';
				}
				_LOCATION += '<br />'+json.UPDATE_ARRAY.delivery_postcode+'&nbsp;'+json.UPDATE_ARRAY.delivery_city+'<br />'+json.UPDATE_ARRAY.delivery_country;
				$('table#shippingstable tbody tr .address_name[id="<?php echo $_REQUEST['oID']; ?>"]').html(_NAME);
				$('table#shippingstable tbody tr .address_location[id="<?php echo $_REQUEST['oID']; ?>"]').html(_LOCATION);
<?php
                                } // end if not shipping_v2
?>                                
			    }else{
				// ORDER HANDLING
				for(var element in json.UPDATE_ARRAY){
					switch(element){
						case 'customers_telephone':
						case 'customers_mobile':
						case 'customers_vat_id':
							$('td#'+element).html(json.UPDATE_ARRAY[element]);
							break;
						default:
							$('table#address_table td#'+element).html(json.UPDATE_ARRAY[element]);
							break;
					}
				}
				oe_help_key = json.ADDRESS_TYPE;
				switch(json.ADDRESS_TYPE){
				    case 'shipping':
					oe_help_key = 'delivery';
					break;
				    case 'invoice':
					oe_help_key = 'billing';
					break;
				    case 'customer':
					oe_help_key = 'customers';
					break;
				}
				$('table#address_table td#'+oe_help_key+'_postcode_city').html(json.UPDATE_ARRAY[oe_help_key+'_postcode']+' '+json.UPDATE_ARRAY[oe_help_key+'_city']);
			    }
			    $('#modal_window').dialog('destroy');
			},
			error: function(xhr, ajaxOptions, thrownError){
				alert(xhr+' '+thrownError);
			}
		});
	});
        $('.address_book_entries').hide();
        $('a#select_from_addressbook').on('click',function(){
            $('.address_book_entries').toggle();
        });
        $('.ab_entry').each(function(){
            $(this).on('click',function(){
                ab = AB_ARRAY[ $(this).attr('id').replace('ab','') ];
                var INPUT_ID_PREFIX = 'customers';
                switch(ADDRESS_TYPE){
                    case 'shipping':
                        INPUT_ID_PREFIX = 'delivery';
                        break;
                    case 'invoice':
                        INPUT_ID_PREFIX = 'billing';
                        break;
                }
                $('input#'+INPUT_ID_PREFIX+'_company').val(ab.entry_company);
                $('input#'+INPUT_ID_PREFIX+'_name').val(ab.entry_firstname+' '+ab.entry_lastname);
                $('input#'+INPUT_ID_PREFIX+'_street_address').val(ab.entry_street_address);
                $('input#'+INPUT_ID_PREFIX+'_suburb').val(ab.entry_suburb);
                $('input#'+INPUT_ID_PREFIX+'_postcode').val(ab.entry_postcode);
                $('input#'+INPUT_ID_PREFIX+'_city').val(ab.entry_city);
                $('select#'+INPUT_ID_PREFIX+'_country').val(ab.entry_country_id);
                $('.address_book_entries').toggle();
            });
        });
});
</script>
<?php
    $copy_list = array(
            'customer'=>TEXT_ADDRESS_BOOK_CLASS_CUSTOMER,
            'shipping'=>TEXT_ADDRESS_BOOK_CLASS_DELIVERY,
            'invoice'=>TEXT_ADDRESS_BOOK_CLASS_BILLING
    );
    $items = \YES4Trade\Model\address_book::get_by_customers_id( (int)$order->customer['ID'] );
    echo '<div class="main">';
    echo '  <div class="address_book_entries">';
    foreach($items as $it){
        $ab_entry = $it->toArray();
        if($_GET['address_type'] == 'shipping' && $ab_entry['entry_country_id'] != $order->delivery['country_id']){
            continue;
        }
        printf('<script>AB_ARRAY[%s] = %s;</script>',
                $ab_entry['address_book_id'],
                json_encode($ab_entry)
        );
        printf('<div class="ab_entry" id="ab%s">%s</div>',
            $ab_entry['address_book_id'],
            xtc_address_format($order->customer['format_id'], 
            array(
                'company'=>$ab_entry['entry_company'],
                'firstname'=>$ab_entry['entry_firstname'],
                'lastname'=>$ab_entry['entry_lastname'],
                'street_address'=>$ab_entry['entry_street_address'],
                'suburb'=>$ab_entry['entry_suburb'],
                'city'=>$ab_entry['entry_city'],
                'state'=>$ab_entry['entry_state'],
                'zone_id'=>$ab_entry['entry_zone_id'],
                'postcode'=>$ab_entry['entry_postcode'],
                'country_id'=>$ab_entry['entry_country_id'],
            ), 
            true, ', ', '')
        );
    }
    echo '  </div>';

    echo xtc_draw_form('ajax_address_edit',FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=ajax_address_save','POST','onsubmit="return false;" id="ajax_address_edit"');
    echo '<fieldset>';
    printf('<legend>%s</legend>',TEXT_EDIT_ADDRESS);
    //if(sizeOf($order->products) and $_REQUEST['address_type'] != 'shipping'){
        printf('<a href="javascript:;" id="select_from_addressbook">%s</a><br />',
                TEXT_SELECT_ADDRESS_BOOK_ENTRY
        );
    //}
    switch($_REQUEST['address_type']){
            case 'customer':
                    $sql_prefix = 'customers_';
                    break;
            case 'shipping':
                    $sql_prefix = 'delivery_';
                    break;
            case 'invoice':
                    $sql_prefix = 'billing_';
                    break;
    }
    $fields = array(
            $sql_prefix.'company',
            $sql_prefix.'name',
            $sql_prefix.'street_address',
            $sql_prefix.'suburb',
            $sql_prefix.'postcode',
            $sql_prefix.'city',
            $sql_prefix.'state',
            $sql_prefix.'country'
    );
    switch($_REQUEST['address_type']){
            case 'customer':
                    $fields[] = $sql_prefix.'vat_id';
                    $fields[] = $sql_prefix.'telephone';
                    $fields[] = $sql_prefix.'mobile';
                    break;
    }


    $query = xtc_db_query(sprintf("SELECT %s FROM %s WHERE orders_id='%s'",
        implode(',',$fields),TABLE_ORDERS,xtc_db_input($_REQUEST['oID'])
    ));
    $record = xtc_db_prepare_input(xtc_db_fetch_array($query));
    $countries = xtc_get_countries( $default='',$utf8=true );
    $db_ini = yes_get_database_table_ini();
    foreach($record as $key=>$value){
            $label = constant('TEXT_FIELD_'.strtoupper( substr($key,strlen($sql_prefix),strlen($key)) ));
            $size = 32;
            switch($key){
                    case 'customers_country':
                    case 'delivery_country':
                    case 'billing_country':
                        $country_data = xtc_get_country_data_from_name($value);
                        $allow_shipping_edit = true;
                        if(sizeOf($order->products) and $_REQUEST['address_type'] == 'shipping'){
                            $allow_shipping_edit = false;
                        }
                        if($allow_shipping_edit){
                            $field = xtc_draw_pull_down_menu($key, $countries, $country_data['countries_id'], 'id="'.$key.'"');
                        }else{
                            $field = xtc_draw_hidden_field($key, $country_data['countries_id']).xtc_get_country_name($country_data['countries_id']);
                            $field .= '&nbsp;<span title="Auftrag enthält bereits Artikel. Versandland kann nicht mehr ge&auml;ndert werden">&#x26A0;</span>';
                        }
                        break;
                    case 'customers_postcode':
                    case 'shipping_postcode':
                    case 'billing_postcode':
                            $size = 6;
                            $field = xtc_draw_input_field($key,yes_encode_string($value),'id="'.$key.'" size="'.$size.'"');
                            break;
                    default:
                        $current_size = $size;
                        $max_length = $current_size;
                        if(yes_get_database_table_field_length($db_ini, TABLE_ORDERS, $key) > $size){
                            $current_size = yes_get_database_table_field_length($db_ini, TABLE_ORDERS, $key);
                            $max_length = $current_size;
                            if($current_size > 64){
                                $current_size = 64;
                                $max_length = $current_size;
                            }
                        }
                        
                        $placeholder = '';
                        switch($key){
                            case 'customers_street_address':
                            case 'delivery_street_address':
                            case 'billing_street_address':
                                $placeholder = sprintf(' placeholder="%s"',HINT_INTRO_STREET_SPECIAL_VALUE);
                                break;
                            case 'customers_suburb':
                            case 'delivery_suburb':
                            case 'billing_suburb':
                                $placeholder = sprintf(' placeholder="%s"',HINT_INTRO_SUBURB_SPECIAL_VALUE);
                                break;
                        }                        
                        $field = xtc_draw_input_field($key,$value,'id="'.$key.'" size="'.$current_size.'" maxlength="'.$max_length.'"'.$placeholder);
                        
                        $label_icon = '';
                        switch($key){
                            case 'customers_street_address':
                            case 'delivery_street_address':
                            case 'billing_street_address':
                                $label_icon = smarty_function_icon([
                                    'title'=>HINT_INTRO_STREET_SPECIAL,
                                    'type'=>'info'
                                    ],$smarty
                                );
                                break;
                            case 'customers_suburb':
                            case 'delivery_suburb':
                            case 'billing_suburb':
                                $label_icon = smarty_function_icon([
                                    'title'=>HINT_INTRO_SUBURB_SPECIAL,
                                    'type'=>'info'
                                    ],$smarty
                                );
                                break;
                        }                        
                        break;
            }
            printf('<label for="%s"><b>%s:</b> %s</label><br />%s<br />',$key,$label,$label_icon,$field);
    }
    printf('<hr noshade="noshade" /><p>%s<br />',TEXT_COPY_ADDRESSTYPES_INTRO);
    foreach($copy_list as $copy=>$copy_text){
        if($copy != $_REQUEST['address_type']){
            if(sizeOf($order->products) and $copy != 'shipping'){
                printf('<input type="checkbox" name="copy_%s" value="1" />%s<br />',$copy,$copy_text);
            }
        }
    }
    echo '</p>';
    $query = xtc_db_query(sprintf(
        "SELECT customers_default_address_id FROM %s WHERE customers_id='%s'",
        TABLE_CUSTOMERS,
        $order->customer['ID']
    ));
    $record = xtc_db_fetch_array($query);
    $customers_default_address_id = $record['customers_default_address_id'];
    $ab_entries = array();
    $ab_classes = array(
        array('id'=>'','text'=>yes_decode_string(TEXT_NONE)),
        array('id'=>'customer','text'=>TEXT_ADDRESS_BOOK_CLASS_CUSTOMER),
        array('id'=>'delivery','text'=>TEXT_ADDRESS_BOOK_CLASS_DELIVERY),
        array('id'=>'billing','text'=>TEXT_ADDRESS_BOOK_CLASS_BILLING)
    );
    foreach($items as $it){
        $text = yes_encode_string($it->entry_firstname.' '.$it->entry_lastname.', '.$it->entry_city);
        if(!empty($it->address_class)){
            switch($it->address_class){
                case 'customer':
                    $aclass = TEXT_ADDRESS_BOOK_CLASS_CUSTOMER;
                    break;
                case 'delivery':
                    $aclass = TEXT_ADDRESS_BOOK_CLASS_DELIVERY;
                    break;
                case 'delivery':
                    $aclass = TEXT_ADDRESS_BOOK_CLASS_BILLING;
                    break;
            }
            $text = $aclass.': '.$text;
        }
        if($customers_default_address_id == $it->address_book_id){
            $text .= ' (Default)';
        }
        $ab_entries[] = array(
            'id'=>$it->address_book_id,
            'text'=>$text
        );
    }

    printf('<hr noshade="noshade" /><p>%s<br />',TEXT_COPY_ADDRESSBOOK_INTRO);
    echo xtc_draw_radio_field('ab_action','',true).' '.TEXT_COPY_ADDRESSBOOK_NO_ACTION.'<br />';
    $default_ab_address_class = '';
    switch($_REQUEST['address_type']){
        default:
            $default_ab_address_class = $_REQUEST['address_type'];
            break;
        case 'shipping':
            $default_ab_address_class = 'delivery';
            break;
        case 'invoice':
            $default_ab_address_class = 'billing';
            break;
    }

    if(KASSE_USER != $order->customer['ID']){
        $select = xtc_draw_pull_down_menu('ab_address_class', $ab_classes, $default_ab_address_class);
        if($order->customer['ID'] != KASSE_USER){
            echo xtc_draw_radio_field('ab_action','copy_as',false).' '.TEXT_COPY_ADDRESSBOOK_COPY_AS.' '.$select.'<br />';
            $select = xtc_draw_pull_down_menu('ab_address_book_id', $ab_entries,$customers_default_address_id);
            echo xtc_draw_radio_field('ab_action','update',false).' '.TEXT_COPY_ADDRESSBOOK_REPLACE.' '.$select.'<br />';
        }
        echo '</p>';
        echo '<hr noshade="noshade" />';
        echo xtc_draw_checkbox_field('update_customers_name', 1, false).' '.TEXT_UPDATE_CUSTOMERS_NAME.'<br />';
    }
    echo '<hr noshade="noshade" />';
    echo '<input type="button" class="ui-button ui-corner-all ui-state-default" value="'.IMAGE_SAVE.'" id="address_update_button" />';
    echo '</fieldset>';
    echo '</form>';
    echo '</div>';
    exit;
} // end ajax_address_edit

if($action == 'delete_paymentfee'){
    if(!$allow_edit_actions){
        $messageStack->add_session('MwSt. Abweichungen','error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
    }
    $order = new order((int)xtc_db_input($_GET['oID']));
    for($i=0;$i<sizeOf($order->totals);$i++){
        if($order->totals[$i]['class'] == 'ot_cod_fee'){
            xtc_db_query(sprintf(
                "DELETE FROM orders_total WHERE orders_id='%s' and class='ot_cod_fee' LIMIT 1",
                (int)xtc_db_input($_GET['oID'])
            ));
            $comments = sprintf(HISTORY_COD_FEE_DELETED,$order->totals[$i]['text']);
            $order->add_history($order->info['orders_status'], false, $comments);
            $order->recalc();
            $messageStack->add_session($comments,'success');
        }
        if($order->totals[$i]['class'] == 'ot_payment_fee'){
            xtc_db_query(sprintf(
                "DELETE FROM orders_total WHERE orders_id='%s' and class='ot_payment_fee' LIMIT 1",
                (int)xtc_db_input($_GET['oID'])
            ));
            $comments = sprintf(HISTORY_PAYMENT_FEE_DELETED,$order->totals[$i]['text']);
            $order->add_history($order->info['orders_status'], false, $comments);
            $order->recalc();
            $messageStack->add_session($comments,'success');
        }
    }
    xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action','edit_action')).'action=edit'));
}

if ($action == "set_versender") {
    $order = new order(xtc_db_input($_POST['oID']));
    $order->update_default_shipper($_POST['versender']);
    $comments = sprintf(TEXT_VERSENDER_PROPOSAL_SAVED,xtc_db_input($_POST['versender'])); 
    $messageStack->add_session($comments,'success');
    xtc_redirect(xtc_href_link('orders_edit.php','oID='.$order->info['id'].'&cID='.$order->customer['ID'].'&edit_action=shipping'));
}

// Adressbearbeitung Anfang
if (isset($_GET['import']) and $_GET['import'] == "1") {
    $oID = xtc_db_input($_GET['oID']);
    $cID = xtc_db_input($_GET['cID']);
    $aID = xtc_db_input($_POST['aID']);
    if($oID > 0 and $cID > 0 and $aID > 0){
        $order = new order($oID);
        $item = \YES4Trade\Model\address_book::get_by_customers_id_and_address_book_id((int)$cID, (int)$aID);
        if($item != null){
            $stamm = $item->toArray();
        }else{
            $stamm = [];
        }
        $vat_id_query = xtc_db_query("SELECT customers_vat_id,customers_telephone,mobile FROM customers WHERE customers_id='".$cID."'");
        $vat_id_res = xtc_db_fetch_array($vat_id_query);
        $vat_id = $vat_id_res['customers_vat_id'];
        $sql_array = array(
            'customers_name'=> xtc_db_input($stamm['entry_firstname']).' '.xtc_db_input($stamm['entry_lastname']),
            'customers_company'=> xtc_db_input($stamm['entry_company']),
            'customers_street_address'=> xtc_db_input($stamm['entry_street_address']),
            'customers_suburb'=> xtc_db_input($stamm['entry_suburb']),
            'customers_city'=> xtc_db_input($stamm['entry_city']),
            'customers_postcode'=> xtc_db_input($stamm['entry_postcode']),
            'customers_state'=> xtc_db_input($stamm['entry_state']),
            'customers_country'=> xtc_get_country_name($stamm['entry_country_id']),
            'customers_vat_id'=> $vat_id,
            'customers_telephone'=> xtc_db_input($vat_id_res['customers_telephone']),
            'customers_mobile'=> xtc_db_input($vat_id_res['mobile']),
            'delivery_name'=> xtc_db_input($stamm['entry_firstname']).' '.xtc_db_input($stamm['entry_lastname']),
            'delivery_company'=> xtc_db_input($stamm['entry_company']),
            'delivery_street_address'=> xtc_db_input($stamm['entry_street_address']),
            'delivery_suburb'=> xtc_db_input($stamm['entry_suburb']),
            'delivery_city'=> xtc_db_input($stamm['entry_city']),
            'delivery_postcode'=> xtc_db_input($stamm['entry_postcode']),
            'delivery_state'=> xtc_db_input($stamm['entry_state']),
            'delivery_country'=> xtc_get_country_name($stamm['entry_country_id']),
            'billing_name'=> xtc_db_input($stamm['entry_firstname']).' '.xtc_db_input($stamm['entry_lastname']),
            'billing_company'=> xtc_db_input($stamm['entry_company']),
            'billing_street_address'=> xtc_db_input($stamm['entry_street_address']),
            'billing_suburb'=> xtc_db_input($stamm['entry_suburb']),
            'billing_city'=> xtc_db_input($stamm['entry_city']),
            'billing_postcode'=> xtc_db_input($stamm['entry_postcode']),
            'billing_state'=> xtc_db_input($stamm['entry_state']),
            'billing_country'=> xtc_get_country_name($stamm['entry_country_id'])
        );
        xtc_db_perform(TABLE_ORDERS,$sql_array,'update',"orders_id='".$order->info['id']."'");
        $comments = TEXT_ORDER_DATA_IMPORTED;
        $order->add_history($order->info['orders_status'],$notified=0,$comments);
        $messageStack->add_session($comments,'success');
    }else{
        $messageStack->add_session(MSG_ERROR_ORDER_DATA_IMPORT,'error');
    }
    xtc_redirect(xtc_href_link('orders_edit.php',xtc_get_all_get_params(array('import'))));
}

if ($action == "address_edit") {
    // yes accounting
    if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_edit_address'] == '1')) {
    }else{
        $messageStack->add_session(sprintf(JS_MISSING_PERMISSION,$action),'error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('action'))));
    }
    $customers_country = xtc_get_country_name(xtc_db_prepare_input($_POST['customers_country_id']));
    $delivery_country = xtc_get_country_name(xtc_db_prepare_input($_POST['delivery_country_id']));
    $billing_country = xtc_get_country_name(xtc_db_prepare_input($_POST['billing_country_id']));

    $sql_data_array = array('customers_id' => xtc_db_prepare_input($_POST['cID']),
        'customers_company' => $_POST['customers_company'],
        'customers_name' => $_POST['customers_name'],
        'customers_street_address' => $_POST['customers_street_address'],
                                                               'customers_suburb' => xtc_db_prepare_input($_POST['customers_suburb']),
        'customers_city' => $_POST['customers_city'],
        'customers_postcode' => $_POST['customers_postcode'],
        'customers_country' => $customers_country,
        'customers_vat_id' => $_POST['vat_id'],
        'customers_telephone' => $_POST['customers_telephone'],
        'customers_mobile' => $_POST['customers_mobile'],
        'delivery_company' => $_POST['delivery_company'],
        'delivery_name' => $_POST['delivery_name'],
        'delivery_street_address' => $_POST['delivery_street_address'],
        'delivery_suburb' => $_POST['delivery_suburb'],
        'delivery_city' => $_POST['delivery_city'],
        'delivery_postcode' => $_POST['delivery_postcode'],
        'delivery_country' => $delivery_country,
        'billing_company' => $_POST['billing_company'],
        'billing_name' => $_POST['billing_name'],
        'billing_street_address' => $_POST['billing_street_address'],
        'billing_suburb' => $_POST['billing_suburb'],
        'billing_city' => $_POST['billing_city'],
        'billing_postcode' => $_POST['billing_postcode'],
        'billing_country' => $billing_country
    );

    $update_sql_data = array('last_modified' => 'now()');
    $sql_data_array = xtc_array_merge($sql_data_array, $update_sql_data);
    xtc_db_perform(TABLE_ORDERS, $sql_data_array, 'update', 'orders_id = \'' . (int)xtc_db_input($_POST['oID']) . '\'');
    $msgstr = TEXT_ORDERS_ADDRESS_UPDATED;
    $order = new order((int)xtc_db_input($_POST['oID']));
    $order->add_history($order->info['orders_status'],$notified=0,$msgstr);
    if($_POST['update_addressbook'] == '1'){
        $fullname_array = explode(" ",$_POST['customers_name']);
        $fullname[0] = $fullname_array[0];
        for($i=1;$i<count($fullname_array);$i++) {
            $fullname[1] .= ' '.$fullname_array[$i];
        }

        // addressbook updaten
        $items = \YES4Trade\Model\address_book::get_by_customers_id((int)xtc_db_input($_POST['cID']));
        $item = current($items);
        $orig_string =  sprintf('[%s] Firma: %s,'.
            'Vorname: %s,'.
            'Nachname: %s,'.
            'Strasse: %s,'.
            'Zusatz: %s,'.
            'PLZ: %s,'.
            'Stadt: %s,'.
            'Land: %s',
            TEXT_CUSTOMER_ADDRESS_UPDATED,
            $item->entry_company,
            $item->entry_firstname,
            $item->entry_lastname,
            $item->entry_street_address,
            $item->entry_suburb,
            $item->entry_postcode,
            $item->entry_city,
            $item->entry_country_id
        );

        $upd = new \YES4Trade\Model\address_book([
            'address_book_id'=>(int)xtc_db_input($_POST['cID']),
            'entry_company'=>$_POST['customers_company'],
            'entry_firstname'=>$fullname[0],
            'entry_lastname'=>$fullname[1],
            'entry_street_address'=>$_POST['customers_street_address'],
            'entry_postcode'=>$_POST['customers_postcode'],
            'entry_city'=>$_POST['customers_city'],
            'entry_country_id'=>(int)$_POST['customers_country_id']
        ]);
        $upd->update();
        $order->add_history($order->info['orders_status'],false,$orig_string);

        // customers updaten		
        $orig_query = xtc_db_query("SELECT customers_firstname,customers_lastname,customers_telephone,mobile FROM customers WHERE customers_id='".xtc_db_input($_POST['cID'])."'");
        $orig = xtc_db_fetch_array($orig_query);
        $orig_string = sprintf(TEXT_ORIGINAL_CUSTOMER_DATA_UPDATED,
            xtc_db_prepare_input($orig['customers_firstname']),
            xtc_db_prepare_input($orig['customers_lastname']),
            xtc_db_prepare_input($orig['customers_telephone']),
            xtc_db_prepare_input($orig['mobile'])
        );
        $customer_array = array(
            'customers_firstname'=>$fullname[0],
            'customers_lastname'=>$fullname[1],
            'customers_telephone'=>$_POST['customers_telephone'],
            'mobile'=>$_POST['customers_mobile']
        );
        xtc_db_perform(TABLE_CUSTOMERS, $customer_array, 'update', 'customers_id = \'' . (int)xtc_db_input($_POST['cID']) . '\'');
        $order->add_history($order->info['orders_status'],false,$orig_string);		
    }
    $messageStack->add_session(MSG_SUCCESS_ADDRESS_UPDATED, 'success');
    xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, xtc_db_input('text=address&cID='.$_POST['cID'].'&oID=' . $_POST['oID'])));
}
// Adressbearbeitung Ende

// ******************* Artikel bearbeiten Anfang
if ($action == "product_edit") {
    
    if(!$allow_edit_actions){
        $messageStack->add_session('MwSt. Abweichungen','error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
    }
    // yes accounting
    if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_edit_products'] == '1')) {
    }else{
        $messageStack->add_session(sprintf(JS_MISSING_PERMISSION,$action),'error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('action'))));
    }
    // ************* BESTANDSPRUEFUNG ***************
    $oID  = (int)xtc_db_input($_POST['oID']);
    $pID  = xtc_db_input($_POST['products_id']);
    $qty  = (int)xtc_db_input($_POST['products_quantity']);
    if($qty < 1){
        $messageStack->add_session(MSG_ERROR_PRODUCTS_EDIT_QTY_GT_ZERO,'error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=products&cID='.$_POST['cID'].'&oID=' . $oID));
    }
    if(isset($_POST['products_price'])){
        $price_chk = str_replace(',','.',$_POST['products_price']);
        if(!is_numeric($price_chk)){
            $messageStack->add_session('Invalid Price '.$_POST['products_price'].' - Only numbers allowed eg 29,99','error');
            xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=products&cID='.$_POST['cID'].'&oID=' . $oID));
        }
    }
    $opID = (int)xtc_db_input($_POST['opID']);

    $order = new order($oID);

    // ORIGINALDATEN ERMITTELN
    $original_data = array();
    for($i=0;$i<sizeOf($order->products);$i++){
        if( $order->products[$i]['opID'] == $_POST['opID'] ){
            $original_data = $order->products[$i];
        }
    }

    if($original_data['qty'] != $qty){
        // BESTANDSPRUEFUNG
        $SQ = new products_quantity($pID);
        //$qty_total = $SQ->get_available2_qty();

        // ANZAHL IN BESTELLUNG ABZIEHEN
        $qty_total = (defined('STOCK_CHECK_AVAILABLE_METHOD') and STOCK_CHECK_AVAILABLE_METHOD == 'True') ? $SQ->get_available1_qty() : $SQ->get_available2_qty();
        $qty_total_check = $qty_total;
        foreach($order->products as $op){
            if($op['opID'] == $opID){
                $qty_total_check += $op['qty'];
            }
        }

        $new_qty = $original_data['qty'] - $qty;
        if (STOCK_CHECK == "true" and $order->info['orders_status'] != ORDERS_STATUS_OFFER) {
            if( ( $qty_total_check < (int)$qty ) or ( $qty_total_check< 1 ) ){
                $messageStack->add_session(sprintf(MSG_ERROR_PRODUCTS_EDIT_QTY_STOCK,$qty_total_check),'error');
                xtc_redirect( xtc_href_link('orders_edit.php',xtc_get_all_get_params(array('action')).'edit_action=products&oID='.$oID ) );
            }
        }

		
        $collies = xtc_get_product_collies($pID);
        if( sizeOf($collies)>0 and STOCK_ALLOW_CHECKOUT != 'true' ){
            $rest = $qty-$original_data['qty'];
            if($rest > 0){
            }else if($rest < 0){
                $remove = -$rest;
		foreach($collies as $k=>$collie){
                    for($si=0;$si<($remove*$collie['quantity']);$si++){
                    }
                }
            }
	}
        $comments = sprintf(TEXT_PRODUCTS_EDIT_SUCCESS,$pID,$original_data['qty'],$qty);
        $order->add_history($order->info['orders_status'],false,$comments);
        if($order->info['orders_status'] == ORDERS_STATUS_VERSENDET or $order->info['orders_status'] == ORDERS_STATUS_ABGESCHLOSSEN){
            $SQ->update_qty($new_qty, $SQ->get_default_storage_id(), $original_data['qty'], 
                sprintf(TEXT_PRODUCTS_EDIT_SUCCESS_HISTORY,$order->info['id'],$original_data['qty'],$qty),
                'order',$order->info['id'],'Bearbeitung'
            );
	}else{
            product::add_history_static(intval($pID), sprintf(
                TEXT_PRODUCTS_EDIT_SUCCESS_HISTORY,
                $order->info['id'],$original_data['qty'],$qty
            ));
        }
		
        if(defined('EBAY_END_AUCTION_AT_SHOPORDER') and EBAY_END_AUCTION_AT_SHOPORDER == 'True'){
            $remove = $qty - $original_data['qty'];
            if(!sizeOf($collies)){
                if($remove > 0){
                    yes_end_auction_add($pID,$remove);
                }
            }else{
                if($remove > 0){
                    foreach($collies as $k=>$collie){
                        yes_end_auction_add($collie['collie_products_id'],$remove*$collie['quantity']);
                    }
                }
            }
        }

    }
    // ************* BESTANDSPRUEFUNG ***************
    $status = main::get_customers_status($order->info['status'], $_SESSION['languages_id']);

    // VORGANG LOGGEN
    if($_POST['products_price'] <> $original_data['price']){
        $comments = sprintf(TEXT_PRODUCTS_EDIT_UPDATE_PRICE,
            number_format($original_data['price'],2,',','.'),
            number_format(xtc_db_input(str_replace(',','.',$_POST['products_price'])),2,',','.')
        );
        $order->add_history($order->info['orders_status'],false,$comments);
    }
	
    if($_POST['products_name'] != $original_data['name']){
        $comments = sprintf(TEXT_PRODUCTS_EDIT_UPDATE_TITLE,
            xtc_db_prepare_input($original_data['name']),
            xtc_db_prepare_input($_POST['products_name'])
        );
        $order->add_history($order->info['orders_status'],false,$comments);
    }
	
    if($_POST['products_tax'] <> $original_data['tax']){
        $comments = sprintf(TEXT_PRODUCTS_EDIT_UPDATE_TAX,
            $original_data['tax'],
            xtc_db_input($_POST['products_tax'])
        );
        $order->add_history($order->info['orders_status'],false,$comments);
    }

    $final_price = xtc_db_input(str_replace(',','.',$_POST['products_price'])) * (int)xtc_db_input($_POST['products_quantity']);
    $sql_data_array = array( 
        'products_id' => $_POST['products_id'],
        'products_name' => $_POST['products_name'],
        'products_model' => $_POST['products_model'],
        'products_price' => str_replace(',','.',$_POST['products_price']),
        'products_discount_made' => '',
        'final_price' => $final_price,
        'products_tax' => $_POST['products_tax'],
        'products_quantity' => (int)$_POST['products_quantity'],
        'allow_tax' => $status['customers_status_show_price_tax']
    );
    xtc_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array, 'update', 'orders_products_id = \'' . (int)xtc_db_input($_POST['opID']) . '\' and orders_id=\''.$oID.'\'');
    $order = new order($oID);
    $order->recalc();
    $messageStack->add_session(sprintf(TEXT_PRODUCTS_EDIT_HISTORY_SUCCESS,
        $_POST['products_name']),
        'success'
    );
    xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=products&cID='.(int)xtc_db_input($_POST['cID']).'&oID=' . $oID));
} // end product_edit
// ********************************* Artikel bearbeiten Ende

// Artikel einfuegen Anfang

if ($action == "product_ins") {
    if(!$allow_edit_actions){
        $messageStack->add_session('MwSt. Abweichungen','error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
    }
    $json = (isset($_GET['from_cart']) and $_GET['from_cart'] == 1) ? true : false;
    $json_errors = array();
    // yes accounting
    if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_edit_products'] == '1')) {
    }else{
        if($json){
            $err = MSG_ERROR_PRODUCT_INS_AUTH;
            if(!stristr(CHARSET,'utf-8')){
                $err = utf8_encode($err);
            }
            die(json_encode(array(
                'ERROR'=>$err
            )));
        }
        $messageStack->add_session(MSG_ERROR_PRODUCT_INS_AUTH,'error');
        $oID = $_REQUEST['oID'];
        xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit&oID='.$oID));
    }
    $oID = (int)xtc_db_prepare_input($_POST['oID']);
    if(!is_array($_REQUEST['products_quantity']) or !sizeOf($_REQUEST['products_quantity'])){
        if($json){
            $err = MSG_ERROR_PRODUCT_INS_NO_PRODUCTS;
            if(!stristr(CHARSET,'utf-8')){
                $err = json_encode($err);
            }
            die(json_encode(array(
                'ERROR'=>$err
            )));
        }
        $messageStack->add_session($err,'error');
        xtc_redirect( xtc_href_link('orders_edit.php',xtc_get_all_get_params(array('action')).'edit_action=products&oID='.$oID ) );
    }
    $order = new order($oID);
    $products_quantity_array = $_REQUEST['products_quantity'];
    
    $insert_counter = 0;
    $status = main::get_customers_status($order->info['status'],$_SESSION['languages_id']);
    // PRUEFUNG UM DOPPELPRODUKTE ZU VERHINDERN	
    $lang_id = $_SESSION['languages_id'];
    if($order->info['language'] != ''){
	    $languages = xtc_get_languages();
	    foreach($languages as $lang){
		    if($lang['directory'] == $order->info['language']){
			    $lang_id = $lang['id'];
		    }
	    }
    }
    require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
    $xtPrice = $order->get_price_instance();
    // NEU
    $c_info = xtc_oe_customer_infos($order->customer['ID']);
    
    foreach($products_quantity_array as $pID => $qt){
	if($qt == '0') continue;
	$qt = (int)xtc_db_input($qt);
	$pID = (int)xtc_db_input($pID);
    }
    foreach($products_quantity_array as $pID => $qt){
        $cartpID = $pID;
	if($qt == '0') {
            continue;
        }
	$qt = (int)xtc_db_input($qt);
	$pID = (int)xtc_db_input($pID);
        
	$product_query = xtc_db_query("select p.products_model, pd.products_name from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_id = '" . $pID . "' and pd.products_id = p.products_id and pd.language_id = '2'");
        if(!xtc_db_num_rows($product_query)){
            if($json){
                $err = sprintf(TEXT_ADD_ITEMS_FROM_CART_ERROR_PRODUCT_NOT_EXISTS,$pID);
                if(!stristr(CHARSET,'utf-8')){
                    $err = utf8_encode($err);
                }
                $json_errors[] = $err;
                unset($products_quantity_array[$pID]);
                continue;
            }
        }
	$product = xtc_db_fetch_array($product_query);
	$collies = xtc_get_product_collies($pID);
		
	// BESTANDSPRUEFUNG
	$SQ = new products_quantity($pID);
	//$qty_total = $SQ->get_available2_qty();
	$qty_total = (defined('STOCK_CHECK_AVAILABLE_METHOD') and STOCK_CHECK_AVAILABLE_METHOD == 'True') ? $SQ->get_available1_qty() : $SQ->get_available2_qty();
	$new_qty = $qt;
	if (STOCK_CHECK == "true" and $order->info['orders_status'] != ORDERS_STATUS_OFFER) {
		if( ( $qty_total < (int)$new_qty ) or ( $qty_total< 1 ) ){
                    if($json){
                        $err = sprintf(MSG_ERROR_PRODUCT_INS_QTY,$pID,$qty_total);
                        if(!stristr(CHARSET,'utf-8')){
                            $err = utf8_encode($err);
                        }
                        $json_errors[] = $err;
                    }else{
			$messageStack->add_session(sprintf(MSG_ERROR_PRODUCT_INS_QTY,$pID,$qty_total),'error');
                    }
                    continue;
		}
	}
	
	$price_properties_netto = 0;
	if(isset($_REQUEST['property_values'][$cartpID])){
            foreach($_REQUEST['property_values'][$cartpID] as $pvID){
		$pv = new product_properties_values( xtc_db_input($pvID));
		$price_properties_netto += $pv->getPrice();
	    }
	}
        
	$product_in_order = false;
	for($i=0;$i<sizeOf($order->products);$i++){
            if( $order->products[$i]['id'] != $pID ){
                continue;
            }

            // BOF - CHECK PROPERTIES
            $check = true;
            if(isset($_REQUEST['property_values'][$cartpID])){
                    $check = false;
                    $request_properties = array();
                    $order_properties = $order->get_properties($order->products[$i]['opID']);
                    $properties = yes_get_products_properties_id_array($order->products[$i]['id']);
                    foreach($properties as $properties_id){
                            $p = new product_properties($properties_id);
                            $pd = $p->getDescription($lang_id);
                            //echo $pd->getTitle();
                            $pv = $p->getValues($lang_id);
                            foreach($pv as $pvalue){
                                    $pvID = $pvalue['description']->getProducts_properties_values_id();
                                    if(in_array($pvID,$_REQUEST['property_values'][$cartpID])){
                                            $request_properties[] = array(
                                                    'title'=>$pd->getTitle(),
                                                    'value'=>$pvalue['description']->getTitle(),
                                                    'price_netto'=>$pvalue['price'],
                                                    'property_value_id'=>$pvID,
                                                    'properties_id'=>$properties_id,
                                            );
                                    }
                            }
                    }
                    if(sizeOf($order_properties)){
                            $qty_properties_check = sizeOf($order_properties);
                            $qty_properties_counter = 0;
                            foreach($order_properties as $prop){
                                    foreach($request_properties as $rprop){
                                            if($prop['property_title'] == $rprop['title'] and $prop['property_value'] == $rprop['value']){
                                            	if(isset($_POST['user_input_span'][$pID]) and $_POST['user_input_span'][$pID][$rprop['properties_id']] == $prop['input_span']){
                                                    $qty_properties_counter++;
                                                }
                                            }
                                    }
                            }
                            if($qty_properties_counter == $qty_properties_check){
                                    // $pID exists
                                    $check = true;
                            }
                    }else{
                            $check = true;
                    }
                    if($check === true){
                        $product_in_order = true;
                        $err = sprintf(MSG_ERROR_PRODUCT_INS_EXISTS,$pID);
                        if($json){
                            if(!stristr(CHARSET,'utf-8')){
                                $err = utf8_encode($err);
                            }
                            $json_errors[] = $err;
                        }else{
                            $messageStack->add_session($err,'error');
                        }
                    }
            }
	}
	if($product_in_order){
            continue;
	}
        
        // BUGF_CH_OSS
        $country_id = $order->delivery['country_id'];
        $zone_id = $order->delivery['zone_id'];
        
        
        
        $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($pID, $country_id, $zone_id);
	if( sizeOf($collies)>0){
            $tax_rate = xtc_get_product_collies_tax_value($collies,$country_id, $zone_id);
	}else{
            $tax_rate = xtc_get_tax_rate($products_tax_class_id, $country_id, $zone_id);
	}
	$price = $xtPrice->xtcGetPrice($pID, $format = false, $qt, $products_tax_class_id, $pPrice = '', $order->customer['ID']);
	if($price_properties_netto != 0){
		$price_properties_brutto = $xtPrice->xtcFormat($price_properties_netto, false, $products_tax_class_id, $order->info['currency']);
		$price += $price_properties_brutto;
	}
	$final_price = $price * $qt;
	// /NEU

	$sql_data_array = array (
		'orders_id' => $oID, 
		'products_id' => $pID, 
		'products_name' => $product['products_name'], 
		'products_model' => $product['products_model'],
		'products_price' => $price, 
		'products_discount_made' => '', 
		'final_price' => $final_price, 
		'products_tax' => $tax_rate,
		'products_quantity' => $qt, 
		'allow_tax' => $status['customers_status_show_price_tax'],
		'date_added'=>'now()'
	);
	xtc_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array);
	$opID = xtc_db_insert_id();
	$insert_counter++;

	$comments = sprintf(TEXT_PRODUCT_INS_ORDER_HISTORY,$pID,$qt);
	$order->add_history($order->info['orders_status'],$notified=0,$comments);
	if($order->info['orders_status'] == ORDERS_STATUS_VERSENDET or $order->info['orders_status'] == ORDERS_STATUS_ABGESCHLOSSEN){
		$SQ->update_qty( -$new_qty,$SQ->get_default_storage_id(),$qty_total,
				sprintf(TEXT_PRODUCT_INS_HISTORY,$oID,$new_qty),
				'order',$oID,'Bearbeitung'
		);
	}else{
            product::add_history_static($pID, sprintf(
                TEXT_PRODUCT_INS_HISTORY,$oID,$new_qty
            ));
	}
	//$SQ->update_qty( -$new_qty,$SQ->get_default_storage_id(),$qty_total,'Zur Re-Nr. '.$oID.' wurde Produkt '.$new_qty.'x hinzugef&uuml;gt.');

	if(defined('EBAY_END_AUCTION_AT_SHOPORDER') and EBAY_END_AUCTION_AT_SHOPORDER == 'True'){
            $remove = $new_qty;
            if(!sizeOf($collies)){
                if($remove > 0){
                    yes_end_auction_add($pID,$remove);
                }
            }else{
                if($remove > 0){
                    foreach($collies as $k=>$collie){
                        yes_end_auction_add($collie['collie_products_id'],$remove*$collie['quantity']);
                    }
                }
            }
	}
	// BOF PROPERTIES
	if(isset($_REQUEST['property_values'][$cartpID])){
	    foreach($_REQUEST['property_values'][$cartpID] as $nrkey=>$pvID){
		$pv = new product_properties_values($pvID);
		$p = new product_properties($pv->getProducts_properties_id());
		$pd = $p->getDescription($_SESSION['languages_id']);
		$pvd = $pv->getDescription($_SESSION['languages_id']);
                
                // BOF - SPEICHERN input_span 2023/06
            $input_span = (isset($_REQUEST['user_input_span'][$cartpID][$nrkey]) and $_REQUEST['user_input_span'][$cartpID][$nrkey] != '') ? $_REQUEST['user_input_span'][$cartpID][$nrkey] : '';
                
		$insert_sql_array = array(
			'orders_products_id'=>$opID,
			'property_title'=>$pd->getTitle(),
			'property_value'=>$pvd->getTitle(),
			'price_netto'=>$pv->getPrice(),
                    'input_span'=>$input_span,
		);
                // EOF - SPEICHERN input_span 2023/06
		xtc_db_perform('orders_products_properties',$insert_sql_array);
	    }
	}
	// EOF PROPERTIES
        
    } // end foreach products to insert
    if($json){
        if($insert_counter < 1){
            die(json_encode(array(
                'ERROR'=>implode("\r\n",$json_errors)
            )));
        }
    }
    $order = new order($oID);
    $order->recalc();
    $msg = sprintf(MSG_SUCCESS_PRODUCT_INS,$insert_counter);
    if($json){
        // CART LOESCHEN
        xtc_db_query(sprintf(
                "DELETE FROM customers_basket WHERE customers_id='%s'",
                $order->customer['ID']
        ));
        if(!stristr(CHARSET,'utf-8')){
            $msg = utf8_encode($msg);
        }
        $json_errors[] = $msg;
        die(json_encode(array(
            'ERROR'=>'',
            'MSG'=>implode("\r\n",$json_errors),
            'SUCCESS'=>true,
            'LINK'=>xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$oID)
        )));
    }
    $messageStack->add_session($msg,'success');
    xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=products&cID='.$_POST['cID'].'&oID=' . $_POST['oID']));
}
// Artikel einf�gen Ende

// BEZAHLART 
if ($action == "ot_payment_fee_edit") {
        if(!$allow_edit_actions){
            $messageStack->add_session('MwSt. Abweichungen','error');
            xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
        }
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_edit_shipping'] == '1')) {
	}else{
		$messageStack->add_session('Keine Berechtigung f&uuml;r &auml;ndern der Bezahlart-Geb&uuml;hren von Rechnungen.','error');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('action'))));
	}
	$order = new order((int)xtc_db_input($_POST['oID']));
	$ot_payment_text = xtc_db_input($_POST['ot_payment_text']);
	$ot_payment_fee = (float)xtc_db_input(str_replace(',','.',$_POST['ot_payment_fee']));
	
	
	$customers_status = xtc_oe_get_customers_status(xtc_db_input($_POST['cID']));
	$allow_tax = xtc_oe_get_allow_tax($_POST['cID']);

	$curr_query=xtc_db_query("SELECT currency FROM ".TABLE_ORDERS." WHERE orders_id='".(int)xtc_db_input($_POST['oID'])."'");
	$curr_data=xtc_db_fetch_array($curr_query);

	require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
	$xtPrice = new xtcPrice($curr_data['currency'],$customers_status);

	$text = $xtPrice->xtcFormat($ot_payment_fee,true);
	$sort = MODULE_ORDER_TOTAL_PAYMENT_SORT_ORDER;

	$orig_ot_payment_value = false;
	for($a=0;$a<sizeOf($order->totals);$a++){
		if($order->totals[$a]['class'] == 'ot_payment_fee'){
			$orig_ot_payment_title = $order->totals[$a]['title'];
			$orig_ot_payment_text = $order->totals[$a]['text'];
			$orig_ot_payment_value = $order->totals[$a]['value'];
		}
	}
	if($orig_ot_payment_value){
		// VORHANDEN, ALSO AENDERN ODER LOESCHEN
		if($ot_payment_fee <> 0){
			$update_sql_array = array(
				'title'=>$ot_payment_text,
				'text'=>$text,
				'value'=>$ot_payment_fee
			);
			xtc_db_perform('orders_total',$update_sql_array,'update',"orders_id='".$order->info['id']."' AND class='ot_payment_fee'");
			$comments = sprintf(TEXT_PAYMENT_FEE_CHANGED, 
				$orig_ot_payment_title.' '.$orig_ot_payment_text,
				$ot_payment_text.' '.$text
			);
			$order->add_history($order->info['orders_status'],false,$comments);
		}else{
			xtc_db_query("DELETE FROM orders_total WHERE orders_id='".$order->info['id']."' and class='ot_payment_fee'");
			$comments = sprintf(TEXT_PAYMENT_FEE_DELETED,$orig_ot_payment_title.' '.$orig_ot_payment_text);
			$order->add_history($order->info['orders_status'],false,$comments);
		}
		$order->recalc();
	}else{
		// NEU ANLEGEN
            $country_id = $order->delivery['country_id'];
            $zone_id = $order->delivery['zone_id'];
            // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
            /*if(!yes_eu_oss_use_country_handling($country_id)){
                $country_id = STORE_COUNTRY;
                $zone_id = 0;
            }*/
            // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
            
            if($ot_payment_fee > 0){
                    $insert_sql_array = array(
                            'orders_id'=>$order->info['id'],
                            'title'=>$ot_payment_text,
                            'text'=>$text,
                            'value'=>$ot_payment_fee,
                            'class'=>'ot_payment_fee',
                            'sort_order'=>$sort,
                            'tax_rate_percent'=>xtc_get_tax_rate($order->get_shipping_tax_class(),$country_id, $zone_id)
                    );
                    xtc_db_perform('orders_total',$insert_sql_array);
                    $comments = sprintf(TEXT_PAYMENT_FEE_ADDED,$ot_payment_text.' '.$text);
                    $order->add_history($order->info['orders_status'],false,$comments);
                    $order->recalc();
            }else{
                    $messageStack->add_session(MSG_ERROR_PAYMENT_FEE_ADD_ZERO,'error');
            }
	}
	xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('action','oID','cID','edit_action')).xtc_db_input('edit_action=payment&oID='.$_POST['oID'].'&cID='.$_POST['cID'])));
	exit;
}

if ($action == "payment_edit") {
        if(!$allow_edit_actions){
            $messageStack->add_session('MwSt. Abweichungen','error');
            xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
        }
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_edit_shipping'] == '1')) {
	}else{
		$messageStack->add_session(sprintf(JS_MISSING_PERMISSION,$action),'error');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('action'))));
	}
	$order = new order((int)xtc_db_input($_POST['oID']));
	if($_POST['new_payment_method'] != 'cod'){
		$update_sql_array = array(
			'payment_method'=>xtc_db_input($_POST['new_payment_method']),
			'payment_class'=>xtc_db_input($_POST['new_payment_method']),
			'last_modified'=>"now()"
		);
		xtc_db_perform('orders',$update_sql_array,'update','orders_id='.$_POST['oID']);
		$comments = sprintf(TEXT_PAYMENT_METHOD_CHANGED,
			$order->info['payment_method'],
			xtc_db_input($_POST['new_payment_method'])
		);
		$order->add_history($order->info['orders_status'],false,$comments);
	}else{
		$update_sql_array = array(
			'payment_method'=>$_POST['new_payment_method'],
			'payment_class'=>$_POST['new_payment_method'],
			'shipping_class'=>'cod_cod',
			'shipping_method'=>'Nachnahme',
			'last_modified'=>"now()"
		);
		xtc_db_perform('orders',$update_sql_array,'update','orders_id='.$_POST['oID']);
		$comments = sprintf(TEXT_PAYMENT_METHOD_COD_USED,
			$order->info['payment_method'],
			xtc_db_input($_POST['new_payment_method']),
			$order->info['shipping_method']
		);
		$order->add_history($order->info['orders_status'],false,$comments);
	}
	xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, xtc_db_input('edit_action=payment&cID='.$_POST['cID'].'&oID=' . $_POST['oID'])));
}
// Bezahlart bearbeiten Ende

// Versandkosten bearbeiten Anfang
if ($action == "shipping_edit") {
        if(!$allow_edit_actions){
            $messageStack->add_session('MwSt. Abweichungen','error');
            xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
        }
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_edit_shipping'] == '1')) {
	}else{
		$messageStack->add_session(sprintf(JS_MISSING_PERMISSION,$action),'error');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('action'))));
	}

	//------------------------------------------
	// durch order->update_shipping() ersetzen
	//------------------------------------------
	
	$customers_status = xtc_oe_get_customers_status((int)xtc_db_input($_POST['cID']));
	$allow_tax = xtc_oe_get_allow_tax(xtc_db_input((int)$_POST['cID']));

	$curr_query=xtc_db_query("SELECT currency FROM ".TABLE_ORDERS." WHERE orders_id='".(int)xtc_db_input($_POST['oID'])."'");
	$curr_data=xtc_db_fetch_array($curr_query);

	require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
	$xtPrice = new xtcPrice($curr_data['currency'],$customers_status);

	$text = $xtPrice->xtcFormat($inp_price,false);
	
	$counter = 0;
	$order = new order((int)xtc_db_input($_POST['oID']));
	$error = false;
	if(is_array($_POST['otID'])){
		foreach( $_POST['otID'] as $k => $otID ) {
			if(!isset($_POST['title'][$counter]) or $_POST['title'][$counter] == ''){
				$messageStack->add_session(MSG_ERROR_NO_SHIPPINGCOSTS_TITLE,'error');
				$error = true;
			}
		}
	}
	if(!$error and is_array($_POST['otID'])){
		foreach( $_POST['otID'] as $k => $otID ) {
		    $otID = (int)xtc_db_input($otID);
			$value = xtc_db_input(str_replace(',','.',$_POST['value'][$counter]));
			$title = xtc_db_input($_POST['title'][$counter]);
			$order->update_shippingcosts($otID,$value,$title);
			$counter++;
		}
	}
	$order = new order((int)xtc_db_input($_POST['oID']));
	$order->recalc();
	xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, xtc_db_input('edit_action=shipping&cID='.$_POST['cID'].'&oID=' . $_POST['oID'])));
}
// Versandkosten bearbeiten Ende

// Versandkosten Einf�gen Anfang
if ($action == "shipping_ins") {
        if(!$allow_edit_actions){
            $messageStack->add_session('MwSt. Abweichungen','error');
            xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
        }
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_edit_shipping'] == '1')) {
	}else{
		$messageStack->add_session(sprintf(JS_MISSING_PERMISSION,$action),'error');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('action'))));
	}
	if(!isset($_POST['title']) or $_POST['title'] == ''){
		$messageStack->add_session(MSG_ERROR_NO_SHIPPINGCOSTS_TITLE,'error');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, xtc_db_input('edit_action=shipping&cID='.$_POST['cID'].'&oID=' . $_POST['oID'])));
	}
	
	require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
	$order = new order((int)xtc_db_input($_POST['oID']));

	// geaendert MARIO
	//if ($allow_tax == '1'){
	$inp_price = xtc_db_input(str_replace(',','.',$_POST['value']));
	//}else{
	//	$inp_price = xtc_oe_get_price_o_tax($_POST['value'], $_POST['tax'], 0);
	//}
	$order->insert_shippingcosts($inp_price,xtc_db_prepare_input($_POST['title']));
	if(!xtc_not_null($_POST['shipping_class'])){
		$module = current(split(';',MODULE_SHIPPING_INSTALLED));
		$module = current(split('.php',$module));
		$shipping_class = strtolower($module);
		$shipping_class = $shipping_class.'_'.$shipping_class;
	}else{
		$shipping_class = xtc_db_input($_POST['shipping_class']);
	}
	xtc_db_query(sprintf("UPDATE orders SET shipping_class='%s' WHERE orders_id='%s'",$shipping_class,xtc_db_input($_POST['oID']) ));
	$comments = TEXT_SHIPPINGCOSTS_ADDED; 
	$order->add_history($order->info['orders_status'],false,$comments);
	$order = new order((int)xtc_db_input($_POST['oID']));
	$order->recalc();
	$messageStack->add_session(TEXT_SHIPPINGCOSTS_ADDED,'success');
	xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, xtc_db_input('edit_action=shipping&cID='.$_POST['cID'].'&oID=' . $_POST['oID'])));
}
// Versandkosten Einf�gen Ende

// Nachnahmegeb�hr bearbeiten Anfang
if ($action == "cod_edit") {
        if(!$allow_edit_actions){
            $messageStack->add_session('MwSt. Abweichungen','error');
            xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
        }
	$customers_status = xtc_oe_get_customers_status(xtc_db_input($_POST['cID']));
	$allow_tax = xtc_oe_get_allow_tax(xtc_db_input($_POST['cID']));
	
	if(!isset($_POST['title']) or $_POST['title'] == ''){
		$messageStack->add_session(MSG_ERROR_NO_SHIPPINGCOSTS_TITLE,'error');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, xtc_db_input('edit_action=shipping&cID='.xtc_db_input($_POST['cID']).'&oID=' . xtc_db_input($_POST['oID']))));
	}

	$curr_query=xtc_db_query("SELECT currency FROM ".TABLE_ORDERS." WHERE orders_id='".(int)xtc_db_input($_POST['oID'])."'");
	$curr_data=xtc_db_fetch_array($curr_query);

	require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
	$xtPrice = new xtcPrice($curr_data['currency'],$customers_status);

	//if ($allow_tax == '1'){
		$inp_price = xtc_db_input(str_replace(',','.',$_POST['value']));
	//}else{
	//	$inp_price = xtc_oe_get_price_o_tax($_POST['value'], $_POST['tax'], 0);
	//}

	$text = $xtPrice->xtcFormat($inp_price,true);

	$sql_data_array = array(
	    'orders_id' => (int)xtc_db_input($_POST['oID']),
	    'title' => $_POST['title'],
	    'value' => $inp_price
	);

	$update_sql_data = array('text' => $text);
	$sql_data_array = xtc_array_merge($sql_data_array, $update_sql_data);
	xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array, 'update', 'orders_total_id = \'' . xtc_db_input($_POST['otID']) . '\'');
	$order = new order((int)xtc_db_input($_POST['oID']));
        $order->add_history($order->info['orders_status'], 0, TEXT_SHIPPING_COD_FEE_UPDATED);
	$order->recalc();
	$messageStack->add_session(TEXT_SHIPPING_COD_FEE_UPDATED,'success');
	xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, xtc_db_input('edit_action=shipping&cID='.$_POST['cID'].'&oID=' . $_POST['oID'])));
}
// Nachnahmegeb�hr bearbeiten Ende

// Nachnahmegeb�hr Einf�gen Anfang
if ($action == "cod_ins") {
        if(!$allow_edit_actions){
            $messageStack->add_session('MwSt. Abweichungen','error');
            xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
        }
	$customers_status = xtc_oe_get_customers_status(xtc_db_input($_POST['cID']));
	$allow_tax = xtc_oe_get_allow_tax(xtc_db_input($_POST['cID']));
	if(!isset($_POST['title']) or $_POST['title'] == ''){
		$messageStack->add_session(MSG_ERROR_NO_SHIPPINGCOSTS_TITLE,'error');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=shipping&cID='.xtc_db_input($_POST['cID']).'&oID=' . xtc_db_input($_POST['oID'])));
	}

	$curr_query=xtc_db_query("SELECT currency FROM ".TABLE_ORDERS." WHERE orders_id='".(int)xtc_db_input($_POST['oID'])."'");
	$curr_data=xtc_db_fetch_array($curr_query);

	require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
	$xtPrice = new xtcPrice($curr_data['currency'],$customers_status);

	//if ($allow_tax == '1'){
	$inp_price = (float)xtc_db_input(str_replace(',','.',$_POST['value']));
	//}else{
	//	$inp_price = xtc_oe_get_price_o_tax($_POST['value'], $_POST['tax'], 0);
	//}

	$text = $xtPrice->xtcFormat($inp_price,true);
	$sort = MODULE_ORDER_TOTAL_COD_SORT_ORDER;


	$sql_data_array = array('orders_id' => (int)xtc_db_input($_POST['oID']),
	    'title' => $_POST['title'],
	    'text' => $text,
	    'value' => $inp_price,
	    'class' => 'ot_cod_fee'
	);
	$insert_sql_data = array('sort_order' => $sort);
	$sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
	xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
	
	$order = new order((int)xtc_db_input($_POST['oID']));
        $order->add_history($order->info['orders_status'], 0, TEXT_SHIPPING_COD_FEE_ADDED);
	$order->recalc();
	$messageStack->add_session(TEXT_SHIPPING_COD_FEE_ADDED,'success');
	xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=shipping&cID='.xtc_db_input($_POST['cID']).'&oID=' . xtc_db_input($_POST['oID'])));
}
// Nachnahmegeb�hr Einf�gen Ende


// L�schfunktionen Anfang

if ($action == "product_delete") {
        if(!$allow_edit_actions){
            $messageStack->add_session('MwSt. Abweichungen','error');
            xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
        }
	// yes accounting
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_edit_products'] == '1')) {
	}else{
		$messageStack->add_session(sprintf(JS_MISSING_PERMISSION,$action),'error');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('action'))));
	}
	
	
	// ************* BESTANDSPRUEFUNG ***************
	$oID  = xtc_db_input($_POST['oID']);
	$pID  = xtc_db_input($_POST['pID']);
	$opID = xtc_db_input($_POST['opID']);
	
	$order = new order($oID);
	
	$orig_query = xtc_db_query("SELECT products_quantity,products_price,products_name FROM orders_products WHERE orders_products_id='".$opID."'");
	$orig = xtc_db_fetch_array($orig_query);
	$qty_orig = $orig['products_quantity'];
	
	$SQ = new products_quantity($pID);
	$qty_total = $SQ->get_available2_qty();
	$new_qty = $qty_orig;
        
	if($order->info['orders_status'] == ORDERS_STATUS_VERSENDET or $order->info['orders_status'] == ORDERS_STATUS_ABGESCHLOSSEN){
            $SQ->update_qty( $new_qty,$SQ->get_default_storage_id(),$qty_total,
                sprintf(TEXT_ORDER_PRODUCT_DELETED,$oID,$new_qty),
                'order',$oID,'Bearbeitung'
            );
	}else{
            product::add_history_static(intval($pID), sprintf(
                TEXT_ORDER_PRODUCT_DELETED,
                $oID,$new_qty
            ));
	}
        $order->add_history(intval($order->info['orders_status']),0,sprintf(
                TEXT_ORDER_PRODUCT_DELETED_HISTORY,$pID
        ));
	// ************* BESTANDSPRUEFUNG ***************
	

        xtc_db_query("delete from orders_products_properties where orders_products_id = '" . xtc_db_input($_POST['opID']) . "'");
        xtc_db_query("delete from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . xtc_db_input($_POST['oID']) . "' and orders_products_id = '" . xtc_db_input($_POST['opID']) . "'");
	$order = new order($oID);
	$order->recalc();

        $messageStack->add_session(sprintf(TEXT_ORDER_PRODUCT_DELETED_HISTORY,$pID),'success');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, 'edit_action=products&cID='.xtc_db_input($_POST['cID']).'&oID=' . xtc_db_input($_POST['oID'])));
}

if ($action == "shipping_del") {
    if(!$allow_edit_actions){
        $messageStack->add_session('MwSt. Abweichungen','error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
    }
    // yes accounting
    if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_edit_shipping'] == '1')) {
    }else{
        $messageStack->add_session(sprintf(JS_MISSING_PERMISSION,$action),'error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('action'))));
    }

    xtc_db_query("delete from " . TABLE_ORDERS_TOTAL . " where orders_total_id = '" . xtc_db_input($_GET['otID']) . "'");
    $order = new order((int)xtc_db_input($_GET['oID']));
    $order->recalc();
    $order->add_history(intval($order->info['orders_status']),0,TEXT_ORDERS_SHIPPINGCOSTS_DELETED);
    $messageStack->add_session(TEXT_ORDERS_SHIPPINGCOSTS_DELETED,'success');
    xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, xtc_db_input('edit_action=shipping&cID='.$_GET['cID'].'&oID=' . $_GET['oID'])));
}

if ($action == "cod_del") {
    $order = new order((int)xtc_db_input($_POST['oID']));
    $order->delete_orders_total_entry((int)xtc_db_input($_POST['otID']));
    $comments = HISTORY_COD_DELETED;
    $order->add_history($order->info['orders_status'],$notified=0,$comments);
    $order = new order((int)xtc_db_input($_POST['oID']));
    $order->recalc();
    $messageStack->add_session($comments,'success');
    xtc_redirect(xtc_href_link(FILENAME_ORDERS_EDIT, xtc_db_input('edit_action=shipping&cID='.$_POST['cID'].'&oID=' . $_POST['oID'])));
}

// L�schfunktionen Ende
if(!$allow_edit_actions){
    $messageStack->add_session('MwSt. Abweichungen','error');
    xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
}


$additional_title = ''; 
if(isset($_REQUEST['oID']) and $_REQUEST['oID'] > 0){
    $order = new order((int)xtc_db_input($_REQUEST['oID']));
    $additional_title = $order->get_title($order->get_fibunumber()).' '.$_REQUEST['oID'];
}

$buttons = array(
    array(
	'text'=>BUTTON_BACK_WITHOUT_SAVE, 
	'link'=>xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'),
	'lbOn'=>false,
	'auth'=>true,
    ),
    array(
	'text'=>TEXT_EDIT_PAYMENT, 
	'link'=>xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('edit_action')).'edit_action=payment'),
	'lbOn'=>false,
	'auth'=>( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_edit_payment'] == '1')) ? true : false,
    ),
    array(
	'text'=>TEXT_EDIT_PRODUCTS, 
	'link'=>xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('edit_action')).'edit_action=products'),
	'lbOn'=>false,
	'auth'=>( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_edit_products'] == '1')) ? true : false,
    ),
    array(
	'text'=>TEXT_EDIT_SHIPPING, 
	'link'=>xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('edit_action')).'edit_action=shipping'),
	'lbOn'=>false,
	'auth'=>( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_edit_shipping'] == '1')) ? true : false,
    )/*,
    array(
	'text'=>IMAGE_SAVE, 
	'link'=>xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('action','orders_id')).'action=save_order&orders_id='.$order->info['id']),
	'lbOn'=>false,
	'auth'=>( ($_SESSION['customers_status']['customers_status_id'] == '0') && ( $admin_access['f_orders_edit_products'] == '1' or $admin_access['f_orders_edit_shipping'] == '1' )) ? true : false,
	'title'=>TEXT_SAVE_ORDER,
	'add_css_class'=>'ui-state-highlight'
    ),*/
);
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'ADDITIONAL_HEADING_TITLE'=>$additional_title,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'SHOW_HEADER'=>1
));
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<?php
$smarty->display('orders_edit.html');
$smarty->assign('SHOW_HEADER',0);
$smarty->assign('ORDERS_EDIT_MODE',((isset($_REQUEST['edit_action']))?$_REQUEST['edit_action']:'show_header'));
?>
<br clear="all" />
<div class="oe_addresses">
    <div class="ui-widget oe_address">
	<div class="ui-widget-header"><?php echo TEXT_INVOICE_ADDRESS; ?></div>
 	<div class="ui-widget-content"><?php echo xtc_address_format($order->customer['format_id'], xtc_db_prepare_input($order->customer), true, '', '<br />'); ?></div>
    </div>
    <div class="ui-widget oe_address">
	<div class="ui-widget-header"><?php echo TEXT_SHIPPING_ADDRESS; ?></div>
	<div class="ui-widget-content"><?php echo xtc_address_format($order->delivery['format_id'], xtc_db_prepare_input($order->delivery), true, '', '<br />'); ?></div>
    </div>
    <div class="ui-widget oe_address">
	<div class="ui-widget-header"><?php echo TEXT_BILLING_ADDRESS; ?></div>
	<div class="ui-widget-content"><?php echo xtc_address_format($order->billing['format_id'], xtc_db_prepare_input($order->billing), true, '', '<br />'); ?></div>
    </div>
</div>
<br clear="all" />


		<!-- Meldungen Anfang //-->
		<?php
		if(isset($_GET['text']) and $_GET['text']=='address'){
		?>
		<br /><br />
		<table border="0" width="100%" cellspacing="0" cellpadding="2">
		<tr>
			<td class="main">
			<b>
			<?php
			echo TEXT_EDIT_ADDRESS_SUCCESS;
			?>
			</b>
			</td>
		</tr>
		</table>
		<!-- Meldungen Ende //-->
		<?php
		}

		if (isset($_GET['edit_action']) and $_GET['edit_action']=='address'){

		  $helpID = '40';

		  // yes accounting
		  if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ( $admin_access['f_orders_edit_address'] == '1' )) {
			include('orders_edit_address.php');
		  }else{
		      echo TEXT_AUTH_ERROR_BASE.TEXT_AUTH_ERROR_PART_ADDRESS;
		  }
		} elseif (isset($_GET['edit_action']) and $_GET['edit_action']=='products'){

		  $helpID = '41';
		  // yes accounting
		  if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ( $admin_access['f_orders_edit_products'] == '1' )) {
			  include('orders_edit_products.php');
		  }else{
		      echo TEXT_AUTH_ERROR_BASE.TEXT_AUTH_ERROR_PART_PRODUCTS;
		  }
		} elseif (isset($_GET['edit_action']) and $_GET['edit_action']=='shipping'){

		  $helpID = '42';

		  // yes accounting
		  if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ( $admin_access['f_orders_edit_shipping'] == '1' )) {
			  include('orders_edit_shipping.php');
		  }else{
		      echo TEXT_AUTH_ERROR_BASE.TEXT_AUTH_ERROR_PART_SHIPPING;
		  }
		} elseif (isset($_GET['edit_action']) and $_GET['edit_action']=='payment'){

		  // yes accounting
		  if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ( $admin_access['f_orders_edit_shipping'] == '1' )) {
			  include('orders_edit_payment.php');
		  }else{
		      echo TEXT_AUTH_ERROR_BASE.TEXT_AUTH_ERROR_PART_PAYMENT;
		  }
		} elseif (isset($_GET['edit_action']) and $_GET['edit_action']=='select_set'){

		  // yes accounting
		  if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ( $admin_access['f_orders_edit_products'] == '1' )) {
			  include('orders_edit_select_set.php');
		  }else{
		      echo TEXT_AUTH_ERROR_BASE.TEXT_AUTH_ERROR_PART_SETS;
		  }
		} elseif (isset($_GET['edit_action']) and $_GET['edit_action']=='options'){
		  include('orders_edit_options.php');
		}
		?>

				</form>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
