<?php
die('NICHT AKTIV');
/* admin/paypal_ppp.php
.---------------------------------------------------------------------------.
|    Software: PayPal-PPP                                                   |
|     Version: 0.1beta                                                      |
|        Date: 2015-06-20                                                   |
| Description: show paypal-payments                                         |
|     Contact: info@andreas-guder.de                                        |
| ------------------------------------------------------------------------- |
|      Author: Andreas Guder                                                |
|     Contact: info@andreas-guder.de                                        |
| Copyright (c) 2015, Andreas Guder.                                        |
| ------------------------------------------------------------------------- |
|     License:  GNU Public License V2.0                                     |
|               http://www.gnu.org/licenses/gpl-2.0.html                    |
'--------------------------------------------------------------------------'
*/
  define('FILENAME_PAYPAL_PPP', 'paypal_ppp.php');

  require ('includes/application_top.php');
  
  require_once DIR_WS_CLASSES.'class.paypal_ppp_admin.php';
  $paypal_ppp = new PAYPAL_PPP_ADMIN();

/* EOF AGI PAYPAL-PPP www.andreas-guder.de 1/2 */

  function agi_parse_date($date_string)
  {
    if (!empty($date_string))
    {
      $t = explode('.',$date_string);
      $ct= count($t);
      if ( $ct > 1 && $ct < 4)
      {
        if (!empty($t[0]))
        {
          (int)$t[0];
          if ($t[0] <= 0 || $t[0] > 31)
            $t[0] = date('d');
        }
        else
          $t[0] = '01';
        
        if (!empty($t[1]))
        {
          (int)$t[1];
          if ($t[1] <= 0 || $t[1] > 12)
            $t[1] = date('m');
        }
        else
          $t[1] = '01';
        
        if (!empty($t[2]))
        {
          if (strlen($t[2]) == 2)
            $t[2] = $t[2]+2000;
          (int)$t[2];
          if ($t[2] <= 0 || $t[2] > date('Y'))
            $t[2] = date('Y');
        }
        else
          $t[2] = date('Y');
        return array('en'=>$t[2].'-'.$t[1].'-'.$t[0],'de'=>$t[0].'.'.$t[1].'.'.$t[2]);
      }
    }
    
    return '';
  }

  $action = (isset($_GET['action']) ? $_GET['action'] : '');
  $search_pams = array();

  switch ($action)
  {
    case 'search':
      $search = '';
      if (!empty($_GET['ppp_search']))
        $search = xtc_db_input($_GET['ppp_search']);
      if (!empty($_POST['ppp_search']))
        $search = xtc_db_input($_POST['ppp_search']);
      
      $date_from = '';
      if (!empty($_GET['ppp_date_from']))
        $date_from = xtc_db_input($_GET['ppp_date_from']);
      if (!empty($_POST['ppp_date_to']))
        $date_from = xtc_db_input($_POST['ppp_date_from']);
        
      $date_to = '';
      if (!empty($_GET['ppp_date_to']))
        $date_to = xtc_db_input($_GET['ppp_date_to']);
      if (!empty($_POST['ppp_date_to']))
        $date_to = xtc_db_input($_POST['ppp_date_to']);
      
      if (!empty($date_from))
        $date_from = agi_parse_date($date_from);
      if (!empty($date_to))
        $date_to = agi_parse_date($date_to);
      
      $a_query_where = array();
      if (!empty($search))
      {
        $a_query_where[] = "(`ppp_sale_id` LIKE '%".xtc_db_input($search)."%' OR `payer_email` LIKE '%".xtc_db_input($search)."%' OR `payer_last_name` LIKE '%".xtc_db_input($search)."%')";
        $search_pams[] = 'ppp_search='.$search;
      }
      if (!empty($date_from))
      {
        $a_query_where[] = "DATE(`created_at`)>='".$date_from['en']."'";
        $search_pams[] = 'ppp_date_from='.$date_from['de'];
      }
      if (!empty($date_to))
      {
        $a_query_where[] = "DATE(`created_at`)<='".$date_to['en']."'";
        $search_pams[] = 'ppp_date_to='.$date_to['de'];
      }
      if (!empty($search_pams))
        $search_pams[] = 'action=search';
      
      if (!empty($a_query_where))
        $query_raw = "SELECT * FROM  `".TABLE_PAYPAL_PPP."` WHERE ".implode(' AND ', $a_query_where)." ORDER BY `created_at` DESC";
      else
        $query_raw = "SELECT * FROM  `".TABLE_PAYPAL_PPP."` ORDER BY `created_at` DESC";
      
      break;
    default:
      $query_raw = "SELECT * FROM  `".TABLE_PAYPAL_PPP."` ORDER BY `created_at` DESC";
      break;
  }
  
  $query_split = new splitPageResults($_GET['page'], 64, $query_raw, $query_raw_numrows);
  $paypal_ppp_data = array();
  $query_ref = xtc_db_query($query_raw);
  while($data_row = xtc_db_fetch_array($query_ref)) 
    $paypal_ppp_data[$data_row['id']] = $data_row;
  xtc_db_free_result($query_ref);
  if (isset($_GET['cID']) && !empty($_GET['cID']) && array_key_exists($_GET['cID'], $paypal_ppp_data))
    $preload_data = (int)$_GET['cID'];
  else
    $preload_data = key($paypal_ppp_data);
  
  if (!empty($preload_data))
  {
    $q = xtc_db_query("SELECT * FROM `".TABLE_PAYPAL_PPP."` WHERE `id`=$preload_data");
    $q_data = xtc_db_fetch_array($q);
    if ($q_data)
      $cInfo = new objectInfo($q_data);
  }

  require (DIR_WS_INCLUDES.'head.php');
?>
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
<!-- header //-->
<?php
require (DIR_WS_INCLUDES.'header.php');
?>
<!-- header_eof //-->

<!-- body //-->
    <table border="0" width="100%" cellspacing="2" cellpadding="2">
      <tr>
        <td class="columnLeft2" width="<?php echo BOX_WIDTH; ?>" valign="top">
          <table border="0" width="<?php echo BOX_WIDTH; ?>" cellspacing="1" cellpadding="1" class="columnLeft">
            <!-- left_navigation //-->
            <?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
            <!-- left_navigation_eof //-->
          </table>
        </td>
        <!-- body_text //-->
        <td class="boxCenter" width="100%" valign="top">
          <table border="0" width="100%" cellspacing="0" cellpadding="2">
            <tr>
              <td>
                <table border="0" width="100%" cellspacing="0" cellpadding="0">
                  <tr>
                    <td class="pageHeading"><?php echo HEADING_TITLE; ?></td>
                    <td class="pageHeading" align="right">
                      <?php echo xtc_draw_separator('pixel_trans.gif', HEADING_IMAGE_WIDTH, HEADING_IMAGE_HEIGHT); ?>
                    </td>
                  </tr>
                  <tr>
                    <td class="main" valign="top"><a href="http://www.andreas-guder.de" onClick="window.open(this.href,'_blank',''); return false;">AGI - Internetagentur Andreas Guder</a></td>
                  </tr>
                </table><br /><br />
              </td>
            </tr>
            <tr>
              <td>
<?php echo xtc_draw_form('transaction_search', FILENAME_PAYPAL_PPP, xtc_get_all_get_params(array('action','ppp_search','ppp_date_from','ppp_date_to','page','cID')) . 'action=search', 'get'); ?>
  <div class="highlightbox main">
    <label for="ppp_search"><?php echo PAYPAL_PPP_LABEL_SEARCH; ?></label>
    <?php echo xtc_draw_input_field('ppp_search', '', 'id="ppp_search" size="15" maxlength="64"'); ?>
    <label for="ppp_date_from"><?php echo PAYPAL_PPP_LABEL_DATE_FROM; ?></label>
    <?php echo xtc_draw_input_field('ppp_date_from', '', 'id="ppp_date_from" size="10" maxlength="10"'); ?>
    <label for="ppp_date_to"><?php echo PAYPAL_PPP_LABEL_DATE_TO; ?></label>
    <?php echo xtc_draw_input_field('ppp_date_to', date('d.m.Y'), 'id="ppp_date_to" size="10" maxlength="10"'); ?>
    <input type="submit" class="button" value="<?php echo BUTTON_SEARCH; ?>" />
    <input type="hidden" name="action" value="search" />
    <a href="<?php echo xtc_href_link(FILENAME_PAYPAL_PPP); ?>" class="button"><?php echo BUTTON_BACK; ?></a>
  </div>
</form>
<br />
                <table border="0" width="100%" cellspacing="0" cellpadding="0">
                  <tr>
                    <td valign="top">

                <table border="0" width="100%" cellspacing="0" cellpadding="2">
                  <tr class="dataTableHeadingRow">
                    <td class="dataTableHeadingContent"><?php echo TABLE_HEADING_TRANSACTION_ID; ?></td>
                    <td class="dataTableHeadingContent"><?php echo TABLE_HEADING_TRANSACTION_DATE; ?></td>
                    <td class="dataTableHeadingContent"><?php echo TABLE_HEADING_TRANSACTION_EMAIL; ?></td>
                    <td class="dataTableHeadingContent"><?php echo TABLE_HEADING_TRANSACTION_NAME; ?></td>
                    <td class="dataTableHeadingContent"><?php echo TABLE_HEADING_TRANSACTION_TOTAL; ?></td>
                    <td class="dataTableHeadingContent"><?php echo TABLE_HEADING_TRANSACTION_FEE; ?></td>
                    <td class="dataTableHeadingContent"><?php echo TABLE_HEADING_TRANSACTION_STATUS; ?></td>
                  </tr>
                  <?php 
                    foreach ($paypal_ppp_data as $data_row)
                    {
                      $t_name = array();
                      $t_name[] = $data_row['first_name'];
                      $t_name[] = $data_row['last_name'];
                      $data_row['name'] = implode(' ', $t_name);
                      
                      $orders_state = false;
                      $q = "SELECT * FROM `".TABLE_PAYPAL_PPP_STATUS_HISTORY."` WHERE `paypal_ppp_id`=".$data_row['id']." ORDER BY `date` DESC LIMIT 0,1";
                      $q_hist = xtc_db_fetch_array(xtc_db_query($q));
                      if ($q_hist)
                        $orders_state = $q_hist;
                      
                      if (isset($cInfo) && is_object($cInfo) && ($data_row['id'] == $cInfo->id) ) {
                        echo '<tr class="dataTableRowSelected" onmouseover="this.style.cursor=\'pointer\'" onclick="document.location.href=\'' . xtc_href_link(FILENAME_PAYPAL_PPP, xtc_get_all_get_params(array('cID')). 'cID=' . $data_row['id']) . '\'">' . "\n";
                      } else {
                        echo '<tr class="dataTableRow" onmouseover="this.className=\'dataTableRowOver\';this.style.cursor=\'pointer\'" onmouseout="this.className=\'dataTableRow\'" onclick="document.location.href=\'' . xtc_href_link(FILENAME_PAYPAL_PPP, xtc_get_all_get_params(array('cID')). 'cID=' . $data_row['id']) . '\'">' . "\n";
                      }
                      ?>
                      <td class="dataTableContent"><?php echo $data_row['ppp_sale_id']; ?></td>
                      <td class="dataTableContent"><?php echo date('d.m.Y H:i', strtotime($data_row['created_at'])); ?></td>
                      <td class="dataTableContent"><?php echo htmlentities($data_row['payer_email'],ENT_COMPAT, $_SESSION['language_charset']); ?></td>
                      <td class="dataTableContent"><?php echo htmlentities($data_row['name'],ENT_COMPAT, $_SESSION['language_charset']); ?></td>
                      <td class="dataTableContent"><?php echo number_format($data_row['payment_total'],2,',',''),' ',$data_row['payment_total_currency']; ?></td>
                      <td class="dataTableContent"><?php echo number_format($data_row['payment_fee'],2,',',''),' ',$data_row['payment_fee_currency']; ?></td>
                      
                      <td class="dataTableContent"><?php echo $orders_state ? $orders_state['status'].': '.$orders_state['summary'] : ''; ?></td>
                    </tr>
                  <?php } ?>
                  <tr>
                    <td colspan="6">
                      <table border="0" width="100%" cellspacing="0" cellpadding="2">
                        <tr>
                          <td class="smallText" valign="top"><?php echo $query_split->display_count($query_raw_numrows, 64, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_PAYPAL_TRANSACTIONS); ?></td>
                          <td class="smallText" align="right"><?php echo $query_split->display_links($query_raw_numrows, 64, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], !empty($search_pams) ? implode('&', $search_pams) : ''); ?></td>
                        </tr>
                      </table>
                    </td>
                  </tr>
                </table>
                    </td>
                    <?php
                      if (isset($cInfo) && is_object($cInfo)) 
                      {
                        $heading = array();
                        $contents = array();
                        
                        $heading[] = array('text' => '<b>'.TABLE_HEADING_TRANSACTION_ID.': ' . $cInfo->ppp_sale_id . ' / '.TABLE_HEADING_TRANSACTION_TO_ORDER.': ' . $cInfo->orders_id .'</b>');
                        
                        $contents[] = array('align' => 'center', 'text' => '<a href="orders.php?oID='.$cInfo->orders_id.'&action=edit" class="button">'.TABLE_HEADING_TRANSACTION_TO_ORDER.' '.$cInfo->orders_id.'</a><br /><br />');
                        
                        $histrory_string = $paypal_ppp->get_status_history_table($cInfo->id, $cInfo->payment_total_currency);
                        $contents[] = array('align' => 'center', 'text' => $histrory_string);
                      }
                      if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
                        echo '<td width="25%" valign="top">' . "\n";
                        $box = new box;
                        echo $box->infoBox($heading, $contents);
                        echo '</td>' . "\n";
                      }
                    ?>
                  </tr>
                </table>
              </td>
            </tr>
          </table>
        </td>
        <!-- body_text_eof //-->
      </tr>
    </table>
    <!-- body_eof //-->
    <!-- footer //-->
    <?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
    <!-- footer_eof //-->
    <br />
  </body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>