<?php
/* -----------------------------------------------------------------------------------------
   $Id: print_order.php,v 1.93 2020/03/11 09:05:16 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2003	 nextcommerce (print_order.php,v 1.1 2003/08/19); www.nextcommerce.org
   
   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

require('includes/application_top.php');
// include needed functions
require_once(DIR_FS_INC .'xtc_get_orders_ebay_seller.inc.php');
require_once(DIR_FS_INC .'xtc_get_payment_method_title.inc.php');
require_once(DIR_FS_INC.'xtc_get_customers_status_export_note.inc.php');			
require_once(DIR_FS_INC .'xtc_get_ebay_seller_data.inc.php');
require_once(DIR_FS_INC .'xtc_get_order_data.inc.php');
require_once(DIR_FS_INC .'xtc_serials.inc.php');
require_once(DIR_FS_INC .'xtc_collis.inc.php');
require_once(DIR_FS_INC .'xtc_not_null.inc.php');
require_once(DIR_FS_INC .'xtc_format_price_order.inc.php');
require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
require_once(DIR_FS_INC.'xtc_get_short_description.inc.php');

require_once(DIR_FS_INC.'xtc_productgroups.inc.php');


$smarty = new yesSmarty;
$smarty->assign('tpl_path',HTTP_SERVER.'templates/'.CURRENT_TEMPLATE.'/');
if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
    require_once(DIR_FS_INC .'xtc_generate_packingslip_barcode.inc.php');
}
if(!isset($_GET['oID']) or $_GET['oID'] < 1){
    die('Missing params');
}
$order_query_check = xtc_db_query(sprintf(
    "SELECT orders_id,customers_id FROM %s WHERE orders_id='%d'",
    TABLE_ORDERS,xtc_db_input($_GET['oID'])
));
if(!xtc_db_num_rows($order_query_check)){
    die('Invalid orders_id '.xtc_db_input($_GET['oID']));
}
$order_check = xtc_db_fetch_array($order_query_check);

include(DIR_WS_CLASSES . 'order.php');
$order = new order($order_check['orders_id']);
$payi = $order->get_paymentinstructions();
if(sizeOf($order->get_paymentinstructions())){
    $smarty->assign('PAYMENTINSTRUCTIONS',xtc_db_prepare_input(current($payi)));
}
$xtPrice = $order->get_price_instance();
$smarty->assign('YESORDER',xtc_db_prepare_input($order->get_order_positions()));
$kasseuser = KASSE_USER;
$smarty->assign('address_label_shipping',xtc_address_format($order->delivery['format_id'], $order->delivery, 1, '', '<br />'));
$smarty->assign('address_label_customer',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br />'));
$smarty->assign('CUSTOMERS_EMAIL_ADDRESS',$order->customer['email_address']);
$smarty->assign('address_label_payment',xtc_address_format($order->billing['format_id'], $order->billing, 1, '', '<br />'));
$smarty->assign('csID',$order->customer['csID']);
	
if($order->info['source_editor_id'] > 0){
    $editor_data_query = xtc_db_query(sprintf(
        "SELECT customers_firstname, customers_lastname,customers_telephone,customers_fax,mobile,customers_email_address FROM customers c WHERE customers_id='%s'",
        $order->info['source_editor_id']
    ));
    $smarty->assign('EDITOR_DATA',xtc_db_fetch_array($editor_data_query));
}
	
$smarty->assign(array(
    'cID'=>$order->customer['ID'],
    'cgroup'=>  xtc_get_customers_status_name($order->info['status']),
    'SOURCE'=>$order->get_source()
));
$smarty->assign('COMMENTS_VISIBLE',xtc_db_prepare_input($order->info['comments_visible']));
$smarty->assign('vatID',$order->customer['vat_id']);
	// ALLE TELEFONDATEN

$tel_query = xtc_db_query("SELECT c.mobile,c.customers_telephone,c.customers_fax FROM customers c, orders o WHERE c.customers_id='".$order->customer['ID']."'");
$tel = xtc_db_fetch_array($tel_query);
if($tel['mobile'] != '')
	$smarty->assign('C_MOBILE',$tel['mobile']);
if($tel['customers_telephone'] != '')
	$smarty->assign('C_TEL',$tel['customers_telephone']);
if($tel['customers_fax'] != '')
	$smarty->assign('C_FAX',$tel['customers_fax']);
if($order->customer['telephone'] != '')
	$smarty->assign('O_TEL',$order->customer['telephone']);
if($order->customer['mobile'] != '')
	$smarty->assign('O_MOBILE',$order->customer['mobile']);

$ot_shipping = 0;
$ot_tax = 0;
$ot_total = 0;
$products_netto = 0;
$products_tax = 0;
$plus = ($order->info['orders_status'] != ORDERS_STATUS_STORNIERT) ? true : false;

$customer_group = $order->info['status'];
$add_tax_array = array();
if(!isset($add_tax_array[$customer_group])){
    $add_tax_res = main::get_customers_status($customer_group,$_SESSION['languages_id']);
    $add_tax_array[$customer_group] = $add_tax_res['customers_status_add_tax_ot'];
}
$order->products = xtc_db_prepare_input($order->products);
$gh = new \YES4Trade\Model\group_handler($_SESSION['languages_id']);
for($i=0;$i<sizeOf($order->products);$i++){
    $products_characteristics_data = array();
    $tax = $order->products[$i]['tax'];
    if($tax  > 0 and $add_tax_array[$customer_group] > 0){
        $products_netto = $order->products[$i]['final_price'] / ((100+$tax)/100);
        $products_tax += $order->products[$i]['final_price'] - $products_netto;
    }

    $collies = xtc_get_product_collies($order->products[$i]['id']);
    $collies_array = array();

    if(sizeOf($collies)>0){
        foreach($collies as $ck=>$collie){
            $collie_title_query = xtc_db_query(sprintf(
                "SELECT slave_title,products_name FROM products_description WHERE products_id=%s AND language_id=%s",
                $collie['collie_products_id'],$_SESSION['languages_id']
	    ));
            $collie_title = xtc_db_prepare_input(xtc_db_fetch_array($collie_title_query));
            $collies_array[] = array(
                'products_id'=>$collie['collie_products_id'],
                'slave_title'=>$collie_title['slave_title'],
                'products_name'=>$collie_title['products_name'],
                'PRODUCTS_WEIGHT'=>xtc_get_ext_products_weight($collie['collie_products_id'])
            );
            $allocs = $gh->get_allocated_product_group_characteristic_values($collie['collie_products_id']);
            if(is_countable($allocs) and sizeOf($allocs)){
                $products_characteristics_data[$collie['collie_products_id']] = $allocs;
            }
        }
    }else{ // end if collies
        $allocs = $gh->get_allocated_product_group_characteristic_values($order->products[$i]['id']);
        if(is_countable($allocs) and sizeOf($allocs)){
            $products_characteristics_data = $allocs;
        }
    }

    // LAGERPLAETZE
    $storage_str = '';
    if(in_array($order->info['orders_status'],array(ORDERS_STATUS_VERSENDET, ORDERS_STATUS_ABGESCHLOSSEN))){
        $transfer_places = $order->get_transferred_places($order->products[$i]['id'],'Versand');
    }else{
	$transfer_places = array();
    }
    if(sizeOf($transfer_places)){
        foreach($transfer_places as $tp){
            $tp = xtc_db_prepare_input($tp);
            $storage_str .= sprintf('<br />Lager &raquo;%s&laquo; / Lagerplatz &raquo;%s&laquo;: %s Stk.',
                $tp['name'],$tp['storage_place'],$tp['quantity']
            );
        }
    }else{
        $storages = array();
        if(sizeOf($collies)>0){
            foreach($collies as $ck=>$collie){
                $storage_query = xtc_db_query("SELECT s.name,sp.storage_places_id,sn.nummer FROM storage_products sp LEFT JOIN storage_numbers sn USING(storage_id,products_id),storages s WHERE sp.products_id='".$collie['collie_products_id']."' and sp.storage_id=s.id");
                while($storage = xtc_db_fetch_array($storage_query)){
                    if($storage['storage_places_id'] > 0){
                        $storage['storage_place'] = yes_get_storage_place_title($storage['storage_places_id']);
                    }
                    $storage['name'] = '(Colli aus pID '.$collie['collie_products_id'].') '.$storage['name'];
                    $storages[] = xtc_db_prepare_input($storage);
                }
            }
        }else{
            $storage_query = xtc_db_query("SELECT s.name,sp.storage_places_id,sn.nummer FROM storage_products sp LEFT JOIN storage_numbers sn USING(storage_id,products_id),storages s WHERE sp.products_id='".$order->products[$i]['id']."' and sp.storage_id=s.id");
            while($storage = xtc_db_fetch_array($storage_query)){
                if($storage['storage_places_id'] > 0){
                    $storage['storage_place'] = yes_get_storage_place_title($storage['storage_places_id']);
                }
                $storages[] = xtc_db_prepare_input($storage);
            }
        }
    }
    if(is_countable($storages) and sizeOf($storages)>0){
        $storage_str = '<table border="0" cellpadding="2" cellspacing="2">';
        foreach($storages as $sk=>$storage){
            $storage_str .= '<tr>';
            $storage_str .= '	<td colspan="2" class="smallText"><font size="1" face="Verdana, Arial, Helvetica, sans-serif"><b>'.TEXT_STORAGE.' '.$storage['name'].'</b></font></td>';
            $storage_str .= '</tr><tr>';
            $storage_str .= '	<td class="smallText"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">'.$storage['storage_place'].'</font></td>';
            $storage_str .= '	<td class="smallText"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">'.$storage['nummer'].'</font></td>';
            $storage_str .= '</tr>';
        }
        $storage_str .= '</table>';
    }

    // EAN AUSLESEN
    $ean = '';
    $ean_query = yes_db_query(sprintf(
        "SELECT products_ean FROM products WHERE products_id='%d'",
        $order->products[$i]['id']),true
    );
    if($ean_query){
        $result = current($ean_query);
        $ean = $result['products_ean'];
    }
    $order_data[]=array(
        'COLLIS'=>$collies_array,
        'PRODUCTS_STORAGES'=>$storage_str,
        'PRODUCTS_MODEL' => $order->products[$i]['model'],
        'PRODUCTS_EAN' => $ean,
        'PRODUCTS_NAME' => $order->products[$i]['name'],
        'PRODUCTS_SHORT_DESCRIPTION' => xtc_get_short_description($order->products[$i]['id'], $_SESSION['languages_id']),
        'PRODUCTS_PRICE' => $xtPrice->xtcFormat($order->products[$i]['final_price'], true),
        'PRODUCTS_SINGLE_PRICE'=>$xtPrice->xtcFormat($order->products[$i]['final_price']/$order->products[$i]['qty'], true),
        'ALLOW_TAX' => (($tax  > 0 and $add_tax_array[$customer_group] > 0)?'1':'0') ,
        'PRODUCTS_QTY' => $order->products[$i]['qty'],
        'CHARACTERISTICS'=>$products_characteristics_data,
        'PROPERTIES'=>$order->products[$i]['properties'],  
        'PRODUCTS_WEIGHT'=>xtc_get_ext_products_weight($order->products[$i]['id'])*$order->products[$i]['qty']
    );
}

// get order_total data
$oder_total_query=xtc_db_query(sprintf("SELECT title,text,class,value,sort_order FROM %s WHERE orders_id='%d' ORDER BY sort_order ASC",
    TABLE_ORDERS_TOTAL,$order->info['id']
));

$order_total=array();
$notax = 0;

while ($oder_total_values = xtc_db_prepare_input(xtc_db_fetch_array($oder_total_query))) {
    $order_total[]=array(
        'TITLE' => $oder_total_values['title'],
        'CLASS'=> $oder_total_values['class'],
        'VALUE'=> $oder_total_values['value'],
        'TEXT' => $oder_total_values['text']
    );
    if ($oder_total_values['class']=='ot_total') {
        $total=$oder_total_values['value'];
    }
    if($oder_total_values['class']=='ot_subtotal_no_tax'){
        $notax = 1; // RE OHNE MWST
    }
}
$smarty->assign('NOTAX', $notax);

// assign language to template for caching
$smarty->assign('STORE', nl2br(STORE_NAME_ADDRESS));
$smarty->assign('BANK', MODULE_PAYMENT_MONEYORDER_PAYTO);

// NEUE VARIABLEN
$smarty->assign('STORE_WRAP',STORE_WRAP);

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('logo_path',HTTP_SERVER.'templates/'.CURRENT_TEMPLATE.'/img/');

$ebay_id_array = array();
$o_ebayid = '';
if($order->info['is_parent'] == 'y'){
    $all_ebay_query = xtc_db_query("SELECT ebay_id FROM orders WHERE parent_orders_id='".(int)xtc_db_input($_GET['oID'])."'");
    while($all_ebay = xtc_db_fetch_array($all_ebay_query)){
        $o_ebayid .= $all_ebay['ebay_id'].', ';
        $ebay_id_array[] = $all_ebay['ebay_id'];
    }
    $o_ebayid = substr($o_ebayid,0,(strlen($o_ebayid)-2));
}else{
    $o_ebayid .= $order->info['ebay_id'];
    $ebay_id_array = $order->ebay_id_array;
}

// UM AUKTIONEN SEPARAT ANZUZEIGEN
if(is_countable($ebay_id_array) and sizeOf($ebay_id_array)>0){
    $smarty->assign(array(
        'auctions'=>$ebay_id_array,
        'EBAY_ID_ARRAY'=>$ebay_id_array,
        'EBAY_PLUS'=>$order->info['ebay_plus'],
        'EBAY_BUYERID'=>$order->get_ebay_buyer()
    ));
}
$smarty->assign('orders_id',$_GET['oID']);

if($o_ebayid!=''){
    $o_ebayid = '<p><b>'.ENTRY_EBAY_ID.'</b> '.$o_ebayid.'</p>';
}
if($order->info['orders_status'] == ORDERS_STATUS_STORNIERT){
    $storno = ' <font color="red">'.TEXT_ORDERS_STATUS_STORNIERT.'</font> ';
    $smarty->assign('IS_STORNO','1');
}else{
    $storno = '';
}

// FIBUNUMBER ADDON
$fibu_number = $order->get_fibunumber();
if(!empty($fibu_number) and strlen($fibu_number)>1){
    $smarty->assign('FIBU_NUMBER',$fibu_number);
}
$smarty->assign('ORDER_TYPE',$order->get_title($fibu_number));


// AMAZON VALUES
if($order->has_amazon_items()){
    $smarty->assign('amazon_info', $order->get_amazon_items());
}

if(isset($_GET['oc'])){
    $smarty->assign('ORDER_TYPE',TEXT_ORDER_CONFIRMATION);
}

$smarty->assign('oID',$order->info['id'].$storno.$o_ebayid);
$smarty->assign('ORDERS_ID_STRING',$order->info['id'].$storno);

$ebay_seller = xtc_get_orders_ebay_seller($order->info['id']);
if($ebay_seller != ''){
    $smarty->assign('EBAY_SELLER_DATA',xtc_get_ebay_seller_data($ebay_seller));
}

$payment_array = array();
$payments_query = xtc_db_query("SELECT ip.betrag,ip.buchungstag FROM payment_orders po LEFT JOIN incoming_payments ip ON po.payment_id=ip.id WHERE po.orders_id='".$order->info['id']."'");
while($payments = xtc_db_fetch_array($payments_query)){
    $payment_array[] = $payments;
}
$smarty->assign('payments',$payment_array);

if(isset($_GET['adminprint']) and $_GET['adminprint'] == '1'){
    $smarty->assign('show_payments',1);
}


$bez_kasse_query = xtc_db_query("SELECT paymode FROM kasse WHERE orders_id='".$order->info['id']."'");
$bez_kasse = xtc_db_fetch_array($bez_kasse_query);
if($bez_kasse['paymode'] and $bez_kasse['paymode'] != ''){
    $smarty->assign('PAYMENT_METHOD',TEXT_KASSE.', '.$bez_kasse['paymode']);
}else{
    $smarty->assign('PAYMENT_METHOD',xtc_get_payment_method_title($order->info['payment_method']));
    $smarty->assign('PAYMENT_CLASS',xtc_get_payment_method_title($order->info['payment_class']));
    $smarty->assign('PAYMENT_CLASS_RAW',$order->info['payment_class_db']);
    $smarty->assign('PAYMENT_METHOD_RAW',$order->info['payment_method_db']);
}


$smarty->assign('DATE',xtc_date_short($order->info['date_purchased']));
if($order->info['date_shipping'] > 0){
    $smarty->assign('DATE_SHIPPING',xtc_date_short($order->info['date_shipping']));
}
if($order->info['date_payment'] > 0){
    $smarty->assign('DATE_PAYMENT',xtc_date_short($order->info['date_payment']));
}
$smarty->assign(array(
    'order_data'=>$order_data,
    'order_total'=>$order_total,
    'skonto_values'=>$order->get_skonto(),
    'status_name'=>$order->info['orders_status_name'],
    'CURRENCY'=>$order->info['currency'],
    'cID'=>$order->customer['ID'],
    'split_id'=>$order->info['orders_split_id']
));

$cspt = main::get_customers_status($customer_group, $_SESSION['languages_id']);
$smarty->assign('CUSTOMERS_STATUS_PAYMENT_TARGET',$cspt['customers_status_payment_target']);
// EOF ZAHLUNGSZIEL


$delivery_conditions = xtc_get_customers_status_delivery_conditions($order->info['status']);
if(xtc_not_null($delivery_conditions)){
    $smarty->assign('DELIVERY_CONDITIONS', xtc_db_prepare_input($delivery_conditions));
}

// das muss kundengruppenabh. sein
$export_note = xtc_get_customers_status_export_note($order->info['status'],$_SESSION['languages_id']);
if($export_note != ''){
    $smarty->assign('export_note',xtc_db_prepare_input($export_note));
}

if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
    $error_reporting = yes_getErrorReporting();
    error_reporting(E_ERROR);
    $smarty->assign('BARCODE',xtc_generate_packingslip_barcode($order->info['id']));
    error_reporting($error_reporting);
}
if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
    $fibu_date_query = yes_db_query(sprintf(
        "SELECT date_added FROM orders_fibunumbers WHERE orders_id=%s",
        $order->info['id']
    ));
    if(yes_db_num_rows($fibu_date_query)){
        $date = current($fibu_date_query);
        $smarty->assign('fibu_date',$date['date_added']);
    }else{
        $fibu_date_query = yes_db_query(sprintf(
            "SELECT date_added FROM branches_orders_fibunumbers WHERE orders_id=%s",
            $order->info['id']
        ));
        if(yes_db_num_rows($fibu_date_query)){
            $date = current($fibu_date_query);
            $smarty->assign('fibu_date',$date['date_added']);
        }
    }
}


$template = $order->get_template('print');
if(isset($_REQUEST['kasse_payment_code']) and is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE . '/admin/kasse_success.html')){
	$smarty->display(CURRENT_TEMPLATE . '/admin/kasse_success.html');
}else{
	$smarty->display(CURRENT_TEMPLATE . '/admin/'.$template);
}
