<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_WS_CLASSES.'class.yes_lister.php');    
require_once(DIR_WS_CLASSES.'product.php');    
require_once(DIR_FS_CATALOG.'includes/classes/class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
$admin_access = main::get_admin_access();
  
// yes accounting
if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['customers'] == '1')) {
}else{
  	$messageStack->add_session('Keine Berechtigung f&uuml;r Artikel Benachrichtigungen.','error');
  	xtc_redirect(xtc_href_link('start.php',xtc_get_all_get_params(array('action'))));
}
// initiate template engine for mail
$smarty = new yesSmarty;
 $action = isset($_GET['action']) ? $_GET['action'] : '';
switch ($action) {
	case 'send':
	    $mail_sent_counter = 0;
	    $query = xtc_db_query(
		    "SELECT DISTINCT(products_id) FROM products_email_notifications WHERE notification_confirmed='1'"
	    );
	    while($record = xtc_db_fetch_array($query)){
		$SQ = new products_quantity($record['products_id']);
		$qty_total = (defined('STOCK_CHECK_AVAILABLE_METHOD') and STOCK_CHECK_AVAILABLE_METHOD == 'True') ? $SQ->get_available1_qty() : $SQ->get_available2_qty();
		if($qty_total > 0 and $SQ->products_status == 1){
		    $product = new product($record['products_id']);
		    $smarty->assign(array(
			'INFO'=>$product->info,
			'URL'=>$product->get_shop_link(),
			'STORE_NAME'=>STORE_NAME,
			'STORE_NAME_ADDRESS'=>STORE_NAME_ADDRESS,
		    ));
		    $message_body_html = $smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/mail/'.$_SESSION['language'].'/products_email_notification.html');
		    $message_body_plain = $smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/mail/'.$_SESSION['language'].'/products_email_notification.txt');
		    $query = xtc_db_query(sprintf(
			"SELECT products_email_notifications_id,email_address,customers_id FROM products_email_notifications WHERE notification_confirmed='1' AND products_id='%s'",
			    $record['products_id']
		    ));
		    while($rec_record = xtc_db_fetch_array($query)){
			$reply_address = EMAIL_SUPPORT_ADDRESS;
			$reply_address_name = EMAIL_FROM;
			$forwarding_to = '';
			$path_to_attachement = '';
			$path_to_more_attachements = '';
			$email_subject = sprintf(PRODUCTS_EMAIL_NOTIFICATION_SUBJECT,$product->info['products_name']);
			$to_name = $record['email_address'];
			if($rec_record['customers_id'] > 0){
			    $to_name = xtc_get_editor_name($rec_record['customers_id']);
			}
			xtc_php_mail(EMAIL_SUPPORT_ADDRESS, EMAIL_FROM, $rec_record['email_address'], $to_name, $forwarding_to, $reply_address, $reply_address_name, $path_to_attachement, $path_to_more_attachements, $email_subject, $message_body_html, $message_body_plain);
			$mail_sent_counter++;
			xtc_db_query(sprintf(
				"DELETE FROM products_email_notifications WHERE products_email_notifications_id='%s'",
				$rec_record['products_email_notifications_id']
			));
		    }
		    $messageStack->add_session(sprintf(MSG_PEN_SENT,$mail_sent_counter),'success');
		}
		xtc_redirect(xtc_href_link(basename($_SERVER['PHP_SELF'])));
		exit;
	    }
	    break;
  	case 'delete':
		$penID = xtc_db_input($_REQUEST['penID']);
		if($penID > 0){ // BAR SPERREN
			xtc_db_query(sprintf("DELETE FROM products_email_notifications WHERE products_email_notifications_id='%s'",$penID));
			$messageStack->add_session(MSG_PEN_DELETED,'success');
		}
		xtc_redirect( xtc_href_link(basename($_SERVER['PHP_SELF']),xtc_get_all_get_params(array('action','penID'))) );
		break;
  	case 'save':
		$error = false;
		$pID = (int)xtc_db_input($_REQUEST['pID']);
		$email_address = xtc_db_input($_REQUEST['email_address']);
		if(!$error && $pID < 1){
		    $error = true;
		    $errorMsg = PEM_ADD_ERROR_NO_PRODUCTS_ID;
		}
		if(!$error){
		    $query = xtc_db_query(sprintf(
			    "SELECT products_id FROM %s WHERE products_id='%s' AND products_status='1'",
			    TABLE_PRODUCTS,$pID
		    ));
		    if(!xtc_db_num_rows($query)){
			$error = true;
			$errorMsg = PEM_ADD_ERROR_INVALID_PRODUCTS_ID;
		    }
		    $record = xtc_db_fetch_array($query);
		    $SQ = new products_quantity($record['products_id']);
		    $qty_total = (defined('STOCK_CHECK_AVAILABLE_METHOD') and STOCK_CHECK_AVAILABLE_METHOD == 'True') ? $SQ->get_available1_qty() : $SQ->get_available2_qty();
		    if($qty_total > 0){
			$error = true;
			$errorMsg = PEM_ADD_ERROR_INVALID_PRODUCTS_ID;
		    }
		}
		if(!$error && !xtc_validate_email($email_address)){
		    $error = true;
		    $errorMsg = PEM_ADD_ERROR_INVALID_EMAIL_ADDRESS;
		}
		if(!$error){
		    $query = xtc_db_query(sprintf(
			    "SELECT products_email_notifications_id FROM products_email_notifications WHERE email_address='%s' AND products_id='%s'",
			    $email_address,$pID
		    ));
		    if(xtc_db_num_rows($query)){
			$error = true;
			$errorMsg = PEM_ADD_ERROR_ALLOCATION_EXISTS;
		    }
		}
		$customers_id = 0;
		$query = xtc_db_query(sprintf(
			"SELECT customers_id FROM %s WHERE customers_email_address='%s'",
			TABLE_CUSTOMERS,$email_address
		));
		if(xtc_db_num_rows($query)){
		    $record = xtc_db_fetch_array($query);
		    $customers_id = $record['customers_id'];
		}
		if(!$error){
		    $insert_sql_array = array(
			'date_added'=>'now()',
			'products_id'=>$pID,
			'email_address'=>$email_address,
			'customers_id'=>$customers_id,
			'notification_confirmed'=>1,
			'date_confirmation'=>'now()'
		    );
		    xtc_db_perform('products_email_notifications',$insert_sql_array);
		    $messageStack->add_session(MSG_SUCCESS_PEN_ADDED,'success');
		}else{
		    $messageStack->add_session($errorMsg,'error');
		}
		xtc_redirect( xtc_href_link(basename($_SERVER['PHP_SELF']),xtc_get_all_get_params(array('action')) ) );
		break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
$listing_smarty = $smarty;

$products_to_sent = 0;
$query = xtc_db_query(
	"SELECT DISTINCT(products_id) FROM products_email_notifications WHERE notification_confirmed='1'"
);
while($record = xtc_db_fetch_array($query)){
    $SQ = new products_quantity($record['products_id']);
    $qty_total = (defined('STOCK_CHECK_AVAILABLE_METHOD') and STOCK_CHECK_AVAILABLE_METHOD == 'True') ? $SQ->get_available1_qty() : $SQ->get_available2_qty();
    if($qty_total > 0){
	$products_to_sent++;
    }
}
$buttons = array(
    array('text'=>LINK_ADD,
	'link'=>xtc_href_link(basename($_SERVER['PHP_SELF']),xtc_get_all_get_params(array('action','penID','order_by','page','email_address','pID','date_added')).'action=new'),
	'lbOn'=>false,
	'auth'=>true
    )
);
if($products_to_sent > 0){
    $buttons[] = array(
	'text'=>sprintf(TEXT_PEN_PRODUCTS_TO_SEND,$products_to_sent),
	'link'=>xtc_href_link(basename($_SERVER['PHP_SELF']),'action=send'),
	'lbOn'=>false,
	'auth'=>true
    );
}

$smarty->assign(array(
    'HEADING_TITLE'=>PAGE_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));

$order_by = isset($_GET['order_by']) ? xtc_db_input($_GET['order_by']) : 'date_added';
$query_raw = "select * from products_email_notifications ORDER BY ".$order_by;
$split = new splitPageResults($_GET['page'], $view_limit = MAX_DISPLAY_SEARCH_RESULTS, $query_raw, $query_numrows);
function _getProductsIDStr($value){
    //return $value;
    return sprintf('<a title="Info pID %s" rel="%s" class="yes_dynamic_tooltip"><u>%s</u></a>',
	    $value,xtc_href_link('products.php','action=ajax_view&pID='.$value),$value );
}
	$select_field_array = array(
		0=>array(
			'field'=>'products_email_notifications_id',
			'heading'=>'ID',
			'format'=>'int',
			'get_param'=>'penID',
			'index'=>true,
			'sortable'=>1,
			'column'=>0
		),
		1=>array(
			'field'=>'email_address',
			'heading'=>TEXT_EMAIL,
			'format'=>'string',
			'get_param'=>'email_address',
			'sortable'=>1,
			'column'=>1
		),
		2=>array(
			'field'=>'products_id',
			'heading'=>TEXT_PRODUCTS_ID,
			'format'=>'string',
			'get_param'=>'pID',
			'sortable'=>1,
			'column'=>2,
			'function'=>'_getProductsIDStr'
		),
		3=>array(
			'field'=>'date_added',
			'heading'=>TABLE_HEADING_DATE_ADDED,
			'format'=>'date',
			'get_param'=>'date_added',
			'sortable'=>1,
			'column'=>3
		),
		4=>array(
			'field'=>'date_confirmation',
			'heading'=>TABLE_HEADING_DATE_CONFIRMED,
			'format'=>'date',
			'get_param'=>'date_confirmation',
			'sortable'=>1,
			'column'=>4
		)
	);
	//		   $listing_sql,$listing_table,                $page_link,                    $select_field_array, $where_field_array = array(), $ajax_box = 0,$ajax_get_param='',$ajax_link = '',$template_file='yes_lister_item_table.html',$list_actions=array(),$edit_link_param='edit'
	$YL = new yes_lister($query_raw,'products_email_notifications',basename($_SERVER['PHP_SELF']),$select_field_array, array(),                      0,            '',                '',             'yes_lister_item_table.html',               array(),              'delete_confirm');
	$YL->setSmarty($listing_smarty);
	$Info = $YL->active_row;
	$smarty->assign('LISTING',$YL->display($split,$query_numrows,$view_limit));



	$heading = array();
	$contents = array();
	switch ($action) {
		case 'delete_confirm':
			$heading[] = array('text' => '<b>' . TEXT_PEN_DELETE . '</b>');
			$contents = array('form' => xtc_draw_form('pen_delete', basename($_SERVER['PHP_SELF']), xtc_get_all_get_params(array('action','penID')).'action=delete&penID='.$Info->products_email_notifications_id) );
			$contents[] = array('align' => 'left', 'text' => TEXT_PEN_DELETE_INTRO);
			$contents[] = array('align' => 'left', 'text' => '<b>'.TEXT_PRODUCTS_ID.':</b> '.$Info->products_id);
			$contents[] = array('align' => 'left', 'text' => '<b>'.TEXT_EMAIL.':</b> '.$Info->email_address );
			$contents[] = array('align' => 'center', 'text' => '<br />'.yes_draw_href_button(IMAGE_DELETE,'','width:110px;','submit').'&nbsp;'.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(basename($_SERVER['PHP_SELF']), xtc_get_all_get_params(array('action'))),'width:110px;'));
			break;
		case 'new':
			$heading[] = array('text' => '<b>' . TEXT_ADD_NEW_PEN . '</b>');
			$contents = array('form' => xtc_draw_form('products_email_notifications',  basename($_SERVER['PHP_SELF']), xtc_get_all_get_params(array('action')).'action=save') );
			$contents[] = array('align' => 'left', 'text' => TEXT_ADD_INTRO);
			$contents[] = array('align' => 'left', 'text' => TEXT_EMAIL.':<br />'.xtc_draw_input_field('email_address','','size="20" maxlength="64"') );
			$contents[] = array('align' => 'left', 'text' => TEXT_PEN_PRODUCTS_ID.':<br />'.xtc_draw_input_field('pID','','size="8" maxlength="8"') );
			$contents[] = array('align' => 'center', 'text' => '<br />'.yes_draw_href_button(IMAGE_SAVE,'','width:110px;','submit').'&nbsp;'.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(basename($_SERVER['PHP_SELF']), xtc_get_all_get_params(array('action'))),'width:110px;'));
			break;
		default:
			if (is_object($Info)) {
				$heading[] = array('text' => '<b>' . xtc_db_prepare_input($Info->email_address).'</b>');
				$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_DELETE,xtc_href_link(basename($_SERVER['PHP_SELF']), xtc_get_all_get_params(array('action')) . 'action=delete_confirm'),'width:180px;'));
				$contents[] = array('align' => 'left', 'text' => '<b>'.TEXT_PRODUCTS_ID.':</b> '.$Info->products_id);
				$contents[] = array('align' => 'left', 'text' => '<b>'.TABLE_HEADING_DATE_ADDED.':</b> '.xtc_date_long($Info->date_added) );
				if($Info->notification_confirmed == 1){
				    $contents[] = array('align' => 'left', 'text' => '<b>'.TABLE_HEADING_DATE_CONFIRMED.':</b> '.xtc_date_long($Info->date_confirmation) );
				}
				if($Info->delete_flag == 1){
				    $contents[] = array('align' => 'left', 'text' => '<b>'.TEXT_DELETE_MODE.'</b>');
				}
			}
			break;
	}

if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
	$box = new box;
	$smarty->assign('BOX', $box->infoBox($heading, $contents));
}
if(defined('STOCK_ALLOW_CHECKOUT') and STOCK_ALLOW_CHECKOUT == 'true'){
    printf('<h3>%s</h3>',TEXT_ERROR_STOCK_ALLOW_CHECKOUT);
    if( defined('STOCK_ALLOW_CHECKOUT_TITLE')){
        echo STOCK_ALLOW_CHECKOUT_TITLE;
    }
}else{
    $smarty->display('products_email_notifications.html');
}
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');

