<?php
use \Secuconnect\Client\Configuration;
use \Secuconnect\Client\Authentication\Authenticator;
use Secuconnect\Client\ObjectSerializer;
include('includes/application_top.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/payment/yes_secupay.php');
require_once(DIR_FS_CATALOG.'includes/modules/payment/yes_secupay.php');
// === Konfiguration ===
$debug = false;
$error_msg = '';

$secupay = new \yes_secupay();

$host = $secupay->mode == 'Live' ? $secupay::API_URL_LIVE : $secupay::API_URL_TEST;
$auth_host = $secupay->mode == 'Live' ? $secupay::AUTH_URL_LIVE : $secupay::AUTH_URL_TEST;
try{
    Configuration::getDefaultConfiguration()
            ->setDebug($debug)
        ->setHost($host)
        ->setAuthHost($auth_host);

    // === Authentifizierung ===
    Authenticator::authenticateByClientCredentials(
        constant('MODULE_PAYMENT_YES_SECUPAY_USERID'),
        constant('MODULE_PAYMENT_YES_SECUPAY_SECRET')
    );
}catch(Exception $e){
    $error_msg = $e->getMessage();
}

$count = 0;
$page = intval($_GET['page']??0);
$listing = $_GET['listing']??'transactions';
$smarty = new yesSmarty;
$smarty->assign([
    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
]);

$transaction = $_GET['transaction']??null;
if($transaction !== null){
    try{
        $transaction = $secupay->getSmartTransaction($transaction);
        $smarty->assign('TRANSACTION',ObjectSerializer::sanitizeForSerialization($transaction));
        $smarty->display('secupay.html');
        exit;
    }catch(Exception $e){
        echo $e->getMessage();
        exit;
    }   
}

if(isset($_GET['action']) and $_GET['action'] == 'set_delivery'){
    if(isset($_POST['orders_id']) and is_countable($_POST['orders_id'])){
        require_once(DIR_WS_CLASSES.'order.php');
        foreach($_POST['orders_id'] as $oID){
            $trackings = $_POST['trackings'][$oID] ?? '';
            $shipper = $_POST['shipper'][$oID];
            $order = new \order(intval($oID));
            try{
                $response = $secupay->setSmartTransactionDelivery(
                    $order->info['payment_transaction_id'],
                    $oID,
                    $shipper,
                    $trackings
                );
            }catch(Exception $e){
                $messageStack->add_session('Secupay Error: '.$e->getMessage(),'error');
                xtc_redirect(xtc_href_link(FILENAME_ORDERS));
            }
            yes_db_perform('shippings',[
                    'secupay_send_status'=>1
                ],
                'update',
                ['orders_id'=>intval($oID)]
            );
            $order->add_history($order->info['orders_status'],false,'Secupay Send Shipping Informations');
        }
    }
    require_once(DIR_WS_CLASSES.'yes_shipping.php');
    $query = xtc_db_query(sprintf(
        "SELECT s.id FROM shippings s LEFT JOIN %s o USING ( orders_id ) WHERE o.payment_method='yes_secupay' AND s.status=1 AND s.secupay_send_status=0",
        TABLE_ORDERS
    ));
    $shippings = [];
    while($record = xtc_db_fetch_array($query)){
        $shippings[] = new \yes_shipping($record['id']);
    }
    $table = new tableBlock();
    $table->table_parameters = 'class="yes_secupay_shippings yesListTable_minimal" style="width: auto;"';
    $contents = [[
        ['text'=>'&nbsp;','th'=>true],
        ['text'=>TEXT_ORDER_SHORT,'th'=>true],
        ['text'=>TEXT_YES_EXPORT_MODULES_TYPE_DATE.' '.TEXT_HEADER_MENU_STATS_SHIPPINGS,'th'=>true],
        ['text'=>TEXT_SHIPPER,'th'=>true],
        ['text'=>TEXT_QUANTITY,'th'=>true],
        ['text'=>'Tracking','th'=>true]
    ]];
    foreach($shippings as $sh){
        $checked = (is_countable($sh->tracking_id_array) and sizeOf($sh->tracking_id_array));
        $contents[] = [
            ['text'=>xtc_draw_checkbox_field('orders_id[]',$sh->orders_id,$checked)],
            ['text'=>sprintf('<a href="%s"><button class="ui-button ui-corner-all ui-state-default" type="button">%s</button></a>',
                xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$sh->orders_id),
                $sh->orders_id
            )],
            ['text'=>yes_date_short($sh->date_finished)],
            ['text'=>$sh->versender.xtc_draw_hidden_field('shipper['.$sh->orders_id.']',$sh->versender)],
            ['text'=>$sh->packages],
            ['text'=>implode(',',$sh->tracking_id_array).xtc_draw_hidden_field('trackings['.$sh->orders_id.']',implode(',',$sh->tracking_id_array))]
        ];
    }
    $smarty->assign('SHIPPINGS',$table->tableBlock_draw($contents));
    $smarty->display('secupay.html');
    exit;
}

if(empty($error_msg)){
    try{
        if($listing == 'transactions'){
            $transactions = $secupay->findSmartTransactions($page*\yes_secupay::RESPONSE_LIST_SIZE);
            $count += $transactions->getCount();
        }else{
            $payments = $secupay->findPaymentTransactions($page*\yes_secupay::RESPONSE_LIST_SIZE);
            $count += $payments->getCount();
        }
    }catch(Exception $e){
        $error_msg = $e->getMessage();
    }   
}



$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
if($transactions !== null){
    $contents = [[
        ['text'=>'ID','th'=>true],
        ['text'=>'Status','th'=>true],
        ['text'=>TEXT_YES_EXPORT_MODULES_TYPE_DATE,'th'=>true],
        ['text'=>'Total','th'=>true],
        ['text'=>'YES Order','th'=>true],
    ]];
    foreach($transactions->getData() as $t){

        $query = yes_query(sprintf(
            "SELECT orders_id FROM %s WHERE payment_transaction_id=:trans AND payment_class='yes_secupay'",
            TABLE_ORDERS
        ),['trans'=>$t->getId()],
            true
        );
        
        $contents[] = [
            ['text'=>$t->getId()],
            ['text'=>$t->getStatus()],
            ['text'=>yes_date_short($t->getCreated(),true)],
            ['text'=>($t->getBasketInfo()->getSum()/100).' '.$t->getBasketInfo()->getCurrency()],
            ['text'=>($query !== false)?sprintf('<a href="%s"><button class="ui-button ui-corner-all ui-state-default" type="button">%d</button></a>',
                xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$query['orders_id']),
                $query['orders_id']
            ):'-']
        ];
    }
    $smarty->assign('DATA',$table->tableBlock_draw($contents));
}elseif($payments !== null){
    $contents = [[
        ['text'=>'ID','th'=>true],
        ['text'=>'Status','th'=>true],
        ['text'=>TEXT_YES_EXPORT_MODULES_TYPE_DATE,'th'=>true],
        ['text'=>'Info','th'=>true],
        ['text'=>TEXT_PRODUCT,'th'=>true],
        ['text'=>'YES Order','th'=>true],
    ]];
    foreach($payments->getData() as $p){
        $date = yes_date_short($p->getCreated(),true);
        if($p->getUpdated() !== null){
            $date .= '<br />'.yes_date_short($p->getUpdated(),true);
        }
        $alloc = $secupay->getAllocationFromPaymentTransactionId($p->getId());
        $allocation_string = '';
        if($alloc['orders_id']>0){
            $allocation_string = sprintf(
                '<a href="%s"><button type="button" class="ui-button ui-corner-all ui-state-default">%s</button></a>',
                xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$alloc['orders_id']),
                TEXT_ORDER_SHORT.': '.$alloc['orders_id']
            );
        }

        $contents[] = [
            ['text'=>$p->getId()],
            ['text'=>$p->getStatusText()],
            ['text'=>$date],
            ['text'=>$p->getDescription()],
            ['text'=>number_format($p->getAmount()/100,2,',','')],
            ['text'=>$allocation_string],
        ];
    }
    $smarty->assign('DATA',$table->tableBlock_draw($contents));
}

if($listing == 'transactions'){
    $buttons = array(
        array('text'=>'Payments',
        'link'=>xtc_href_link(basename(__FILE__), xtc_get_all_get_params(array('listing','page')).'listing=payments'),
        'lbOn'=>false,
        'auth'=>true
        )
    );
}else{
    $buttons = array(
        array('text'=>'Transactions',
        'link'=>xtc_href_link(basename(__FILE__), xtc_get_all_get_params(array('listing','page')).'listing=transactions'),
        'lbOn'=>false,
        'auth'=>true
        )
    );
}
yes_draw_pre_header();
yes_draw_header(TITLE);

$modulo = ($count > 0) ? $count % \yes_secupay::RESPONSE_LIST_SIZE : 0;
$total_pages = ($count > 0) ? ($count-$modulo) / \yes_secupay::RESPONSE_LIST_SIZE : 0;

$back_link = '';
$next_link = '';

if($page > 0){
    $back_link = xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['page']).'page='.$page-1);
}
if($page < $total_pages){
    $next_link = xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['page']).'page='.$page+1);
}

$smarty->assign([
    'HEADING_TITLE'=>'Secupay Admin',
    'ADDITIONAL_HEADING_TITLE'=>mb_ucfirst($listing),
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'ERROR_MSG'=>$error_msg,
    'PAGING'=>[
        'back'=>$back_link,
        'next'=>$next_link,
        'page'=>($page+1),
        'total_pages'=>$total_pages+1,
        'total_items'=>$count
    ]
]);
$smarty->display('secupay.html');
require_once('includes/footer.php');
require_once('includes/application_bottom.php');
exit;
