<?php
/*
 * @author: mario aspeleiter <dazze@gmx.de>
 * @date 20/01/2005
 * VERSAND SCHNITTSTELLE
*/

/**
 * AMAZON ADDON 07.09.2010
 */
require_once(DIR_FS_INC.'xtc_get_short_description.inc.php');
if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
	include('includes/classes/amz_Helper.php');
	$AmazonHelper = new amazon_helper();
}

$action = $_REQUEST['action'];
	
$mode = $_REQUEST['mode'];
$written_csv = array();

$crypt_dir = yes_get_sha1_from_string( date('Y-m-d') );
$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );

$ship_pdf_name = \main::get_exportdata_path().$crypt_dir.'/DRUCKLISTE_GESAMT_'.$crypt_file.'.pdf';


if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
    $ship_pdf = new yes_pdf();
    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
	$ship_pdf->set_landscape();
    }
    $yes_pdf_content = array();
}else{
    $ship_pdf=new HTML2FPDF();
}
$pdf_smarty = new yesSmarty;

$ship_pdf_pages = 0;

switch($mode){
	case 'write':
		
		
		/**
		 * BEI paketliste_csv() WIRD csv_status=1 IN DIE TABELLE shippings GESCHRIEBEN
		 * DAS MUESSTE BEIM DURCHLAUF VON write WIEDER AUFGEHOBEN WERDEN, WENN
		 * NOCH VERSENDBARE ITEMS IN DER BESTELLUNG SIND
		 */
		
		
		
		if( isset($_GET['ship_step']) and $_GET['ship_step']!='' ){
			$ship_step = xtc_db_input($_GET['ship_step']);
		}else{
			$ship_step = 0;
			$process_shipping_id_array = array();
			if(isset($_REQUEST['quickshipping']) and $_REQUEST['quickshipping'] == '1'){
				$errors = array();
				foreach($_REQUEST['orders_id'] as $nr => $orders_id){
					if($_REQUEST['reclamations_id'][$nr] > 0){
						$item = new reclamation($_REQUEST['reclamations_id'][$nr]);
						$shipping_type = 'reclamations_id';
					}else{
						$item = new order($_REQUEST['orders_id'][$nr]);
						$shipping_type = 'orders_id';
					}
					if(!$item->allow_shipping()){
						$errors[] = sprintf(TEXT_ERROR_QUICKSHIPPING_NOT_SHIPPABLE,$shipping_type,$id);
					}
					$ship_query = xtc_db_query(sprintf(
						"SELECT id,status,%s FROM shippings WHERE %s=%s",
						$shipping_type,$shipping_type,$item->info['id']
					));
					$ship_record = xtc_db_fetch_array($ship_query);
					if($ship_record['status'] == 1){
						$errors[] = sprintf(TEXT_ERROR_QUICKSHIPPING_ALWAYS_SHIPPED,$shipping_type,$id);
					}
					if($item->has_unallocated_ebay_items()){
						$errors[] = sprintf(TEXT_ERROR_QUICKSHIPPING_UNALLOCATED_EBAY_ITEMS,$shipping_type,$id);
					}
					if($item->has_unallocated_amazon_items()){
						$errors[] = sprintf(TEXT_ERROR_QUICKSHIPPING_UNALLOCATED_AMAZON_ITEMS,$shipping_type,$id);
					}
					if(sizeOf($errors)){
						foreach($errors as $err){
							$messageStack->add_session($err,'error');
						}
						xtc_redirect(xtc_href_link($_REQUEST['from']));
					}
					
					$insert_sql_array = array(
						'orders_id'=>$orders_id,
						'reclamations_id'=>$_REQUEST['reclamations_id'][$nr],
						'customers_id'=>$_REQUEST['customers_id'][$nr],
						'weight'=>$_REQUEST['weight'][$nr],
						'packages'=>$_REQUEST['packages'][$nr],
						'versender'=>$_REQUEST['versender'][$nr],
						'name1'=>$_REQUEST['name1'][$nr],
						'name2'=>'',
						'company'=>$_REQUEST['company'][$nr],
						'street1'=>$_REQUEST['street1'][$nr],
						'street2'=>$_REQUEST['street2'][$nr],
						'postcode'=>$_REQUEST['postcode'][$nr],
						'city'=>$_REQUEST['city'][$nr],
						'country_id'=>$_REQUEST['countries_id'][$nr],
						'country_name'=>  xtc_get_country_name($_REQUEST['countries_id'][$nr]),
						'country_special'=>'',
						'ebay_id'=>$_REQUEST['ebay_id'][$nr],
						'email'=>$_REQUEST['email'][$nr],
						'status'=>0
					);
					if(isset($_REQUEST['id']) and isset($_REQUEST['id'][$nr])) {
						xtc_db_perform('shippings',$insert_sql_array,'update','id='.(int)xtc_db_input($_REQUEST['id'][$nr]));
						$process_shipping_id_array[] = (int)xtc_db_input($_REQUEST['id'][$nr]);
					}else{
						$insert_sql_array['date_added'] = 'now()';
						xtc_db_perform('shippings',$insert_sql_array);
						$process_shipping_id_array[] = xtc_db_insert_id();
					}
				}
			}
			
			
			

			if(defined('EXPORT_PRE_SHIPPING_PDF_AT_SHIPPING_ACTION_WRITE') and EXPORT_PRE_SHIPPING_PDF_AT_SHIPPING_ACTION_WRITE == 'True'){
				
				$export_dir = \main::get_exportdata_path().$crypt_dir.'/';
				if(!is_dir($export_dir)){
					mkdir($export_dir);
				}
				$ship_pdf_name = $export_dir.'VORVERSANDLISTE_GESAMT_'.$crypt_file.'.pdf';
				if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
				    $ship_pdf = new yes_pdf();
				}else{
				    $ship_pdf=new HTML2FPDF();
				}
				$ship_pdf_pages = 0;
				$packagelist = array();
				
				if(sizeOf($process_shipping_id_array)){
					$query = xtc_db_query("SELECT * FROM shippings WHERE status='0' and csv_status=0 and id IN(".implode(',',$process_shipping_id_array).")");
				}else{
					$query = xtc_db_query("SELECT * FROM shippings WHERE status='0' and csv_status=0 ORDER BY customers_id");
				}
				while($shipping = xtc_db_fetch_array($query)){
					
					// BOF - TEILLIEFERUNG CHECK
					if($shipping['reclamations_id'] == 0){
						if(yes_count_shippable_order_products($shipping['orders_id'])>0){
							$packagelist[] = $shipping;
						}
					}else{
						$packagelist[] = $shipping;
					}
					// EOF - TEILLIEFERUNG CHECK
					
				}
				if(sizeOf($packagelist)>0){
				    $barcodes_generated = array();
					foreach($packagelist as $k => $row) {
						$saved_orders_id = array();
						// email
						$oID = $row['orders_id'];
						$rID = $row['reclamations_id'];
						if($oID>0){
							$order = new order($oID);
							$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);

							// GENERIERE RECHNUNG-PDF
							$pdf_smarty->clear_all_assign();
							$pdf_html=xtc_get_order_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_order.html');

							$pdf_name = '';

							if(PDF_ORDER_EXPORT_AT_SHIPPING_ACTION == 'True'){
							    if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
								$yes_pdf_content[] = $pdf_html;
							    }else{
								// FUEGE RECHNUNG AN GESAMTPDF AN
								$ship_pdf->AddPage();
								$ship_pdf->WriteHTML($pdf_html);
							    }
							    $ship_pdf_pages++;
							}

							// FUER VORVERSANDLISTE

							if(PDF_PACKINGSLIP_EXPORT_AT_SHIPPING_ACTION == 'True'){
								// GENERIERE LIEFERSCHEIN-PDF
								$pdf_smarty->clear_all_assign();
								$pdf_packingslip_html=xtc_get_packingslip_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_packingslip.html',$lagerplaetze=true,$comments=true,$row['id']);

								// FUEGE LIEFERSCHEIN AN GESAMTPDF AN
								if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
								    $yes_pdf_content[] = $pdf_packingslip_html;
								}else{
								    $ship_pdf->AddPage();
								    $ship_pdf->WriteHTML($pdf_packingslip_html);
								}

								if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
								    $barcodes_generated[] = 'BARCODE_'.$order->info['id'];
								}

								$ship_pdf_pages++;
							}

						}else if($rID > 0) { // end if $oID
							$reclamation = new reclamation($rID);
							if(PDF_RECLAMATION_EXPORT_AT_SHIPPING_ACTION == 'True'){
								// GENERIERE RECLA-PDF
								$pdf_smarty->clear_all_assign();
								$pdf_rekla_html=xtc_get_reclamation_packingslip_html_for_pdf($reclamation,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_rekla.html',$lagerplaetze=true);

								// FUEGE RECLA AN GESAMTPDF AN
								if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
								    $yes_pdf_content[] = $pdf_rekla_html;
								}else{
								    $ship_pdf->AddPage();
								    $ship_pdf->WriteHTML($pdf_rekla_html);
								}

								if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
								    $barcodes_generated[] = 'BARCODE_R'.$rID;
								}

								$ship_pdf_pages++;
							}
						}
					}
					if($ship_pdf_pages > 0){
                                            // ----------------
                                            // VORVERSANDLISTE GENERIEREN
                                            // ----------------
                                            
						if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
						    /*$ship_pdf->set_html($yes_pdf_content);
						    $ship_pdf->save($ship_pdf_name);*/
						    $landscape = false;
						    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
							$landscape = true;
						    }
						    $ship_pdf->save_large_file($ship_pdf_name,$yes_pdf_content,$landscape);
						}else{
						    $ship_pdf->Output($ship_pdf_name,$dest='F');
						}
                                                // HIER WEITERE SPEICHERORTE
                                                if(defined('SHIPPING_ACTION_GESAMTLISTE_SAVE_IN_TEMPLATE_DIRECTORY') and SHIPPING_ACTION_GESAMTLISTE_SAVE_IN_TEMPLATE_DIRECTORY == 'True'){
                                                    if(!is_dir(DIR_FS_DOCUMENT_ROOT."templates/".CURRENT_TEMPLATE."/DRUCKLISTEN/")){
                                                        mkdir(DIR_FS_DOCUMENT_ROOT."templates/".CURRENT_TEMPLATE."/DRUCKLISTEN/");
                                                    }
                                                    $extra_ship_pdf_name = DIR_FS_DOCUMENT_ROOT."templates/".CURRENT_TEMPLATE."/DRUCKLISTEN/DRUCKLISTE_GESAMT_".$crypt_file.'.pdf';
						    if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
							$landscape = false;
							if(DOMPDF_ORDER_LANDSCAPE == 'True'){
							    $landscape = true;
							}
							$ship_pdf->save_large_file($extra_ship_pdf_name,$yes_pdf_content,$landscape);
						    }else{
							$ship_pdf->Output($extra_ship_pdf_name,$dest='F');
						    }
                                                }
                                        }
					if(sizeOf($barcodes_generated)){
					    foreach($barcodes_generated as $bc){
						@unlink(\main::get_exportdata_path().$bc.'.jpg');
						@unlink(\main::get_exportdata_path().$bc.'.png');
					    }
					}
				
				} // END IF SIZE OF PACKAGELIST
				unset($packagelist);
			} // END IF EXPORT_PRE_SHIPPING_PDF_AT_SHIPPING_ACTION_WRITE
			
			
			// im ersten durchlauf die dateien schreiben
			if(sizeOf($process_shipping_id_array)){
				$query = xtc_db_query("select * from shippings where status='0' and csv_status=0 and id IN(".implode(',',$process_shipping_id_array).") order by name1,customers_id");
			}else{
				$query = xtc_db_query("select * from shippings where status='0' and csv_status=0 order by name1,customers_id");
			}
			
			$now_num = xtc_db_num_rows($query);
			while ($shipping = xtc_db_fetch_array($query)) {
				// BOF - TEILLIEFERUNG CHECK
				if($shipping['reclamations_id'] == 0){
					if(yes_count_shippable_order_products($shipping['orders_id'])>0){
						$packagelist[$shipping['versender']][] = $shipping;
					}
				}else{
					$packagelist[$shipping['versender']][] = $shipping;
				}
				// EOF - TEILLIEFERUNG CHECK
			}
			if(isset($packagelist) and is_array($packagelist)){
				paketliste_csv('',false,$process_shipping_id_array); // schreibe KOMPLETTPAKETLISTE
				$messageStack->add_session(sprintf(MSG_SUCCESS_COMPLETELIST_PACKAGES,sizeOf($packagelist)),'success');
				foreach($packagelist as $versender => $packages) {
					if(!in_array($versender,$written_csv)){
						paketliste_csv($versender,false,$process_shipping_id_array);
						require('shipping_action_'.$versender.'.php');				
						$written_csv[] = $versender;
						$messageStack->add_session(sprintf(MSG_SUCCESS_SENDER_PACKAGES,$versender,sizeOf($packages)),'success');
					}
				}
			}
		} // ende 1. durchlauf ($ship_step == 0)
                
                
		$ship_pdf_name = \main::get_exportdata_path().$crypt_dir.'/DRUCKLISTE_GESAMT_'.$crypt_file.'.pdf';
		if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
		    $ship_pdf = new yes_pdf();
		    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
			$ship_pdf->set_landscape();
		    }
		    $yes_pdf_content = array();
		}else{
		    $ship_pdf=new HTML2FPDF();
		}
		$ship_pdf_pages = 0;
		
		if(sizeOf($process_shipping_id_array)){
			$total_num = sizeOf($process_shipping_id_array);
			$now_num = $total_num;
			$query = xtc_db_query("select * from shippings where status='0' and csv_status='1' and id IN(".implode(',',$process_shipping_id_array).") order by name1,customers_id");
		}else{
			$query = xtc_db_query("select id from shippings where status='0' and csv_status='1' order by name1,customers_id");
			$total_num = xtc_db_num_rows($query);

			$query = xtc_db_query("select * from shippings where status='0' and csv_status='1' order by name1,customers_id limit ".SHIPPING_LIST_SIZE);
			$now_num = xtc_db_num_rows($query);
		}
		
		$packagelist = array(); // nochmal l�schen, wurde oben  bereits verwendet
		
		while ($shipping = xtc_db_fetch_array($query)) {
			if($shipping['reclamations_id'] < 1){
				if(yes_count_shippable_order_products($shipping['orders_id']) > 0){
					$packagelist[ $shipping['versender'] ][] = $shipping;
				}
			}else{
				$packagelist[ $shipping['versender'] ][] = $shipping;
			}
		}
		if( is_array($packagelist) ){
		    $barcodes_generated = array();
			foreach($packagelist as $versender => $packages) {
				$saved_orders_id = array();
				foreach($packages as $k=>$row) {
					// email
					$oID = $row['orders_id'];
					$rID = $row['reclamations_id'];
					if($oID>0){
						// VERSANDDATUM SETZEN - ORDERS_STATUS SET
						// NEUE BEZAHLARTEN BERUECKSICHTIGEN
						$order = new order($oID);
						
						
						/**
						 * ARTIKEL DURCHLAUFEN
						 * quantity_shipped bei jeder opID setzen
						 * mit $op_shipped_status pruefen ob alle Artikel
						 * versendet sind. (true = alle versendet)
						 */
						
						$op_shipped_status = true; // sind alle op versendet?
						
						foreach ($order->products as $k=>$products) {
							$qty_to_send = $products['qty']-$products['quantity_shipped']-$products['not_ship'];
							if($qty_to_send > 0){
                                                            
                                                            
								// KOMMENTAR IN HISTORY
								$collies = xtc_get_product_collies($products['id']);
								if(sizeOf($collies)>0){
                                                                    foreach($collies as $ck=>$colli){
                                                                        $SQ = new products_quantity($colli['collie_products_id']);
                                                                        $qty_total = $SQ->get_products_total_qty();
                                                                        $new_qty = $qty_to_send*$colli['quantity'];
                                                                        $comment = sprintf(HISTORY_ORDER_SEND,$oID,$new_qty);
                                                                        if($qty_to_send != $products['qty']){
                                                                            $comment .= ' '.TEXT_PART_DELIVERY;
                                                                        }
                                                                        $collie_comment = sprintf(HISTORY_SEND_COLLIES,$products['id'],$qty_total,$qty_total);
                                                                        $SQ->update_qty(-$new_qty, $SQ->get_default_storage_id(), $qty_total, $collie_comment,
                                                                                        'order',$oID,'Versand'
                                                                        );
                                                                    }
                                                                    $comment = sprintf(HISTORY_ORDER_SEND,$oID,$products['qty']);
                                                                    product::add_history_static(intval($products['id']), $comment);
								}else{
									$SQ = new products_quantity($products['id']);
									$qty_total = $SQ->get_products_total_qty();
									$new_qty = $qty_to_send;
									$comment = sprintf(HISTORY_ORDER_SEND,$oID,$new_qty);
									if($qty_to_send != $products['qty']){
									    $comment .= ' '.TEXT_PART_DELIVERY;
									}
									$SQ->update_qty(-$new_qty, $SQ->get_default_storage_id(), $qty_total,$comment,
                                                                            'order',$oID,'Versand'
									);
								}
							}
							
							// BOF - TEILLIEFERUNG HANDLING
							xtc_db_query(sprintf(
                                                            "UPDATE orders_products SET not_ship=0 WHERE orders_products_id='%s'",
                                                            $products['opID']
							));
							$order->add_quantity_shipped($products['opID'],$qty_to_send,$row['id']);
							if( $products['qty'] != ($products['quantity_shipped'] + $qty_to_send) ){
                                                            $op_shipped_status = false;
							}
							// EOF - TEILLIEFERUNG HANDLING
						} // ENDE ARTIKEL
                                                
					
						$set_date_shipping_sql = ($op_shipped_status) ? ', date_shipping = now()' : '';
						if(xtc_is_shipping_before_payment($order->info['payment_method'])){
							if($order->info['orders_status'] == ORDERS_STATUS_BEZAHLT){
								$new_status = ($op_shipped_status) ? ORDERS_STATUS_ABGESCHLOSSEN : $order->info['orders_status'];
								xtc_db_query("UPDATE orders SET orders_status='".$new_status."',last_modified=now() ".$set_date_shipping_sql." WHERE orders_id='".$oID."'");
								$comments = sprintf(HISTORY_ORDER_SHIPPED_SENDER,$row['versender']);
								if(!$op_shipped_status)
								    $comments .= ' '.TEXT_PART_DELIVERY;
								$order->add_history($new_status, true, $comments);
							}else{
								$new_status = ($op_shipped_status) ? ORDERS_STATUS_VERSENDET : $order->info['orders_status'];
								xtc_db_query("UPDATE orders SET orders_status='".$new_status."',last_modified=now()".$set_date_shipping_sql." WHERE orders_id='".$oID."'");
								$comments = sprintf(HISTORY_ORDER_SHIPPED_SENDER,$row['versender']);
								if(!$op_shipped_status)
								    $comments .= ' '.TEXT_PART_DELIVERY;
								$order->add_history($new_status, true, $comments);
							}
						}else{
							$new_status = ($op_shipped_status) ? ORDERS_STATUS_ABGESCHLOSSEN : $order->info['orders_status'];
							xtc_db_query("UPDATE orders SET orders_status='".$new_status."',last_modified=now()".$set_date_shipping_sql." WHERE orders_id='".$oID."'");
							$comments = sprintf(HISTORY_ORDER_SHIPPED_SENDER,$row['versender']);
							if(!$op_shipped_status)
							    $comments .= ' '.TEXT_PART_DELIVERY;
							$order->add_history($new_status, true, $comments);
						}
						
						$order = new order($oID);
						$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
						$pID = $row['id'];
						
						$name = $row['name1'];
						if($row['name2'] != '')
							$name .= '<br>'.$row['name2'];
						$firma = $row['company'];
						$strasse = $row['street1'];
						$suburb = $row['street2'];
						$plz = $row['postcode'];
						$ort = $row['city'];
						$land = $row['country_name'];
						$cID = $row['customers_id'];
						$customers_email = $row['email'];
			
						$products_string = '';
						$products_array = array();
						
						$shipping_products = yes_get_shippings_products($row['id']);
						foreach ($order->products as $k=>$products) {
							foreach($shipping_products as $sp){
								if($sp['source_products_id'] == $products['opID']){
									$products_string .= $sp['quantity'] . " x " . $products['model'] . "- " . $products['name']."<br />\n";
									$products['PRODUCTS_SHORT_DESCRIPTION'] = xtc_get_short_description($products['id'], $_SESSION['languages_id']);
									$products_array[] = $products;
								}
							}
						}
						$name_string = (empty($firma)) ? $name : $name . " / " . $firma;
			
						$adresse  = $name."<br />";
						$adresse .= (!empty($firma)) ? $firma."<br />" : '';
						$adresse .= $strasse."<br />";
						if($suburb != '')
							$adresse .= $suburb."<br>";
						$adresse .= "<br />";
						$adresse .= $plz . " " . $ort . "<br />";
						$adresse .= $land."<br />";
			
			
						// total
						$total_query = xtc_db_query("select value from orders_total WHERE orders_id = '".$oID."' AND class ='ot_total'");
						$total = xtc_db_fetch_array($total_query);
						$betrag = number_format($total['value'],2,',','.'). " ".$order->info['currency'];
			
						// shippingcosts
						$shippingcost_query = xtc_db_query("select value from orders_total WHERE orders_id = '".$oID."' AND class ='ot_shipping'");
						$shippingcost = xtc_db_fetch_array($shippingcost_query);
						$betrag_versand = number_format($shippingcost['value'],2,',','.')." ".$order->info['currency'];
			
						// mwst
						$tax_query = xtc_db_query("select value from orders_total WHERE orders_id = '".$oID."' AND class ='ot_tax'");
						$tax = xtc_db_fetch_array($tax_query);
						$mwst = $tax;
						// assign language to template for caching
						$smarty->assign('language', $_SESSION['language']);
		
						$smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
						$smarty->assign('logo_path',HTTP_SERVER  . DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
		
						$smarty->assign('PRODUCTS',$products_string);
						$smarty->assign('PRODUCTS_ARRAY',$products_array);
						$smarty->assign('ORDERS_ID',$oID);
						$smarty->assign('NAME',$name_string);
						$smarty->assign('BETRAG',$betrag);
						$smarty->assign('BETRAG_VERSAND',$betrag_versand);
						$smarty->assign('MWST',$mwst);
						$smarty->assign('ADDRESS',$adresse);
						$smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);
						$smarty->assign('YESORDER',$order->get_order_positions() );
						$smarty->assign('PAYMENT_METHOD',$order->info['payment_method']);#
						if($order->has_part_delivery()){
							$smarty->assign('PART_ORDER',1);
						}
						$notified=0;

						if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') && MODULE_OTHER_FIBUNUMBERS_STATUS == 'True' && MODULE_OTHER_FIBUNUMBERS_AUTOMATIC == 'True'){
							$number = $order->get_fibunumber();
							if(empty($number) or strlen($number)==1){
								$number = $order->add_fibunumber();
								$comments = sprintf(HISTORY_ORDER_FIBUNUMBER,$number);
								$order->add_history($order->info['orders_status'], false, $comments);
							}
						}

						// GENERIERE RECHNUNG-PDF
						$pdf_smarty->clear_all_assign();
						$pdf_html=xtc_get_order_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_order.html');

						$pdf_name = '';
						if(PDF_EMAILS == 'True'){
							$pdf_name=\main::get_exportdata_path().sprintf(ORDER_PDF_NAME,$order->info['id']);
							if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
							    $pdf = new yes_pdf();
							    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
								$pdf->set_landscape();
							    }
							    $pdf->set_html($pdf_html);
							    $pdf->save($pdf_name);
							}else{
							    $pdf=new HTML2FPDF();
							    $pdf->AddPage();
							    $pdf->WriteHTML($pdf_html);
							    $pdf->Output($pdf_name,$dest='F'); //Read the FPDF.org manual to know the other options
							}
						}

						if(PDF_ORDER_EXPORT_AT_SHIPPING_ACTION == 'True'){
							// FUEGE RECHNUNG AN GESAMTPDF AN
							if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
							    $yes_pdf_content[] = $pdf_html;
							}else{
							    $ship_pdf->AddPage();
							    $ship_pdf->WriteHTML($pdf_html);
							}
							$ship_pdf_pages++;
						}

						// FUER DRUCKLISTE GESAMT
						if(PDF_PACKINGSLIP_EXPORT_AT_SHIPPING_ACTION == 'True'){
							// GENERIERE LIEFERSCHEIN-PDF
							$pdf_smarty->clear_all_assign();
							if(defined('EXPORT_STORAGENUMBERS_PACKINGSLIP_IN_SHIPPING_PROCESS') and EXPORT_STORAGENUMBERS_PACKINGSLIP_IN_SHIPPING_PROCESS == 'True'){
								$pdf_packingslip_html=xtc_get_packingslip_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_packingslip.html',true,true,$row['id']);
							}else{
								$pdf_packingslip_html=xtc_get_packingslip_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_packingslip.html',false,true,$row['id']);
							}	
							// FUEGE LIEFERSCHEIN AN GESAMTPDF AN
							if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
								$yes_pdf_content[] = $pdf_packingslip_html;
							}else{
								$ship_pdf->AddPage();
								$ship_pdf->WriteHTML($pdf_packingslip_html);
							}
							if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
							    $barcodes_generated[] = 'BARCODE_'.$order->info['id'];
							}
							$ship_pdf_pages++;
						}
						
						if( NO_SHIPPING_EMAIL == 0 && !$order->has_amazon_items() and !stristr($customers_email,'marketplace.amazon')){
							$html_mail=$smarty->fetch(DIR_FS_CATALOG."templates/".CURRENT_TEMPLATE."/admin/mail/".$_SESSION['language']."/send_shipping.html");

							$order_subject=SEND_SHIPPING_EMAIL_SUBJECT;
							// send mail to customer
							xtc_php_mail(EMAIL_BILLING_ADDRESS,
								EMAIL_BILLING_NAME,
								$customers_email,
								$name_string,
								'',
								EMAIL_BILLING_REPLY_ADDRESS,
								EMAIL_BILLING_REPLY_ADDRESS_NAME,
								$pdf_name,
								'',
								$order_subject,
								$html_mail,
								'');
							$notified = 1;
							$emailID = \YES4Trade\Model\ebay_emails::create_ebay_emails([
								'subject'=>$order_subject,
								'mailto'=>$customers_email,
								'from_name'=>EMAIL_BILLING_NAME,
								'from_email'=>EMAIL_BILLING_ADDRESS,
								'date'=>date('Y-m-d H:i:s'),
								'customers_id'=>intval($cID),
								'orders_id'=>intval($oID),
								'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1,
								'ownmail'=>\YES4Trade\Model\ebay_emails::OWNMAIL1,
								'format'=>'text/html'
							],$html_mail);
						}

						if(PDF_EMAILS == 'True'){
							unlink($pdf_name);
						}
						
						
						// ORIGINAL PLACE FORM ORDERS STATUS SET - 01.02.13, mario

						/**
						 * AMAZON ADDON - AMAZON MELDEN, DASS DIE ARTIKEL VERSENDET WURDEN
						 */
						if($order->has_amazon_items()){
							$amazon_items = $order->get_amazon_items();
							foreach($amazon_items as $amazon_item){
								$amazon_carrier = $AmazonHelper->get_amazon_carrier_from_yes_shipping($row['versender']);
								
								// BUGFIX MARIO - shippings_id MUSS UNIQUE SEIN
								// DARUM BERECHNEN DER NAECHSTEN
								$next_shipping_query = xtc_db_query(
									"SELECT MAX(shippings_id) as mxvalue FROM amazon_orders_products"
								);
								$next_shipping = xtc_db_fetch_array($next_shipping_query);
								$next_shipping_id = $next_shipping['mxvalue']+1;
								$update_sql_array = array(
									'yes_shipping_status'=>1,
									'carrier_code'=>$amazon_carrier['carrier_code'],
									'shipping_method'=>$AmazonHelper->get_amazon_shipping_method_name($amazon_item['shipping_method_service_level']),
									'carrier_name'=>$amazon_carrier['carrier_name'],
									'shippings_id'=>$next_shipping_id
								);
								$where = sprintf("amazon_orders_products_id='%s'",
									$amazon_item['amazon_orders_products_id']
								);
								xtc_db_perform('amazon_orders_products',$update_sql_array,'update',$where);
							}
						}
						/**
						 * EBAY ADDON - COMPLETE SALE SENDEN
						 * WIR SETZEN EIN FLAG UM DIE COMPLETE-SALE MELDUNGEN
						 * ABARBEITEN ZU KOENNEN
						 */
						$auctions = $order->get_auction_array(true); // incl orders_id
						for($ai=0;$ai<sizeOf($auctions);$ai++){
							$update_sql_array = array(
								'shipped'=>1
							);
							xtc_db_perform('ebay_transactions',$update_sql_array,'update',sprintf(
								"orders_id='%s' and ebayid='%s'",
								$auctions[$ai]['orders_id'],
								$auctions[$ai]['ebay_id']
							));
						}
						
					}else if($rID > 0) { // end if $oID
						$reclamation = new reclamation($rID);
						foreach ($reclamation->products as $k=>$products) {
							// KOMMENTAR IN HISTORY
							$collies = xtc_get_product_collies($products['id']);
							if(sizeOf($collies)>0){
                                                            foreach($collies as $ck=>$colli){
                                                                if($reclamation->info['reclamations_type'] == 3){
                                                                    $SQ = new products_quantity($colli['collie_products_id']);
                                                                    $qty_total = $SQ->get_products_total_qty();
                                                                    $new_qty = $products['qty']*$colli['quantity'];
                                                                    $comment = sprintf(HISTORY_RECLAMATION_SEND,$rID,$new_qty);
                                                                    $collie_comment = sprintf(HISTORY_SEND_COLLIES,$products['id'],$qty_total,$qty_total);
                                                                    $SQ->update_qty(-$new_qty,$SQ->get_default_storage_id(),$qty_total,$collie_comment,
                                                                            'reklamation',$rID, 'Versand'
                                                                    );
                                                                }else{
                                                                    product::add_history_static(intval($colli['collie_products_id']), 
                                                                        sprintf(HISTORY_SEND_NO_QTY_CHANGE_RECLAMATION,$rID)
                                                                    );
                                                                }
                                                            }
							}
							if($reclamation->info['reclamations_type'] == 3){
								$SQ = new products_quantity($products['id']);
								$qty_total = $SQ->get_products_total_qty();
								$new_qty = $products['qty'];
								$comment = sprintf(HISTORY_RECLAMATION_SEND,$rID,$new_qty);
								$SQ->update_qty(-$new_qty,$SQ->get_default_storage_id(),$qty_total,$comment,
									'reklamation',$rID,'Versand'
								);
							}else{
                                                            product::add_history_static(intval($products['id']), 
                                                                sprintf(HISTORY_SEND_NO_QTY_CHANGE_RECLAMATION,$rID)
                                                            );
							}
						}
						if(PDF_RECLAMATION_EXPORT_AT_SHIPPING_ACTION == 'True'){
							// GENERIERE RECLA-PDF
							$pdf_smarty->clear_all_assign();
							$pdf_rekla_html=xtc_get_reclamation_packingslip_html_for_pdf($reclamation,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_rekla.html');
							
							// FUEGE RECLA AN GESAMTPDF AN
							if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
							    $yes_pdf_content[] = $pdf_rekla_html;
							}else{
							    $ship_pdf->AddPage();
							    $ship_pdf->WriteHTML($pdf_rekla_html);
							}
							if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
							    $barcodes_generated[] = 'BARCODE_R'.$rID;
							}
							$ship_pdf_pages++;
						}

						// NEU
						xtc_db_query("UPDATE reclamations SET send_status='2', last_modified=now() WHERE reclamations_id='".$rID."'");
						$comments = sprintf(HISTORY_RECLAMATION_SHIPPED_SENDER,$row['versender']);
                                                $new = new \YES4Trade\Model\reclamations_status_history([
                                                    'reclamations_id'=>(int)$rID,
                                                    'reclamations_status_id'=>$reclamation->info['reclamations_status'],
                                                    'date_added'=>date('Y-m-d H:i:s'),
                                                    'customer_notified'=>0,
                                                    'comments'=>$comments,
                                                    'editor_id'=>(int)$_SESSION['customer_id']
                                                ]);
                                                $new->create();
					}
					xtc_db_query("UPDATE shippings SET status='1', date_finished=now() WHERE id='".$row['id']."'");
				}
			}
			if(sizeOf($barcodes_generated)){
			    foreach($barcodes_generated as $bc){
				@unlink(\main::get_exportdata_path().$bc.'.jpg');
				@unlink(\main::get_exportdata_path().$bc.'.png');
			    }
			}
			$messageStack->add_session(sprintf(MSG_SUCCESS_SHIPPING_EXPORT_PARTIAL,$now_num,$total_num),'success');
		}else{
			$messageStack->add_session(MSG_ERROR_SHIPPING_EXPORT,'error');
		}
		if($ship_pdf_pages > 0){
                    // -------------------
                    // DRUCKLISTE_GESAMT
                    // -------------------
                    
		    if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
			/*$ship_pdf->set_html($yes_pdf_content);
			$ship_pdf->save($ship_pdf_name);*/
			$landscape = false;
			if(DOMPDF_ORDER_LANDSCAPE == 'True'){
			    $landscape = true;
			}
			$ship_pdf->save_large_file($ship_pdf_name,$yes_pdf_content,$landscape);
		    }else{
			$ship_pdf->Output($ship_pdf_name,$dest='F');
		    }
		}
		
		// weiterspringen oder beenden
		if($total_num <= $now_num) {
			if(PDF_PRODUCTS_EXPORT_AT_SHIPPING_ACTION == 'True'){
				paketliste_pdf(false,$process_shipping_id_array); // schreibe KOMPLETTPAKETLISTE PDF
			}
			paketliste_csv_grouped($process_shipping_id_array); // GREIFLISTE GENERIEREN
			if(sizeOf($process_shipping_id_array)){
				xtc_db_query("UPDATE shippings SET pdf_status=1 WHERE status='1' and pdf_status=0 and id IN(".implode(',',$process_shipping_id_array).")");
				xtc_redirect($_REQUEST['from']);
			}else{
				xtc_db_query("UPDATE shippings SET pdf_status=1 WHERE status='1' and pdf_status=0");
				xtc_redirect(xtc_href_link('shipping.php?action=lagerliste'));
			}
		}else{
			xtc_redirect(xtc_href_link('shipping.php',xtc_get_all_get_params(array('ship_step','mode')).'mode=view&ship_step='.($ship_step+1) ));
		}
		break;
}
yes_draw_pre_header();
if(isset($_GET['ship_step']) and $_GET['ship_step'] > 0){
?>
<meta http-equiv="refresh" content="10; URL=<?php echo xtc_href_link('shipping.php',xtc_get_all_get_params(array('mode')).'mode=write'); ?>" />
<?php	
}
yes_draw_header(TITLE);
?>
<script type="text/javascript">
<!--
function exportfunc(){
	yes = confirm('<?php echo JS_CONFIRM_PACKAGES_TO_GEPARD; ?>');
	if(yes){
		document.forms['shipping'].submit();
	}
}
//-->
</script>
<div class="yesPageHeading"><?php echo HEADING_TITLE_WRITE; ?></div>

<table border="0" width="100%" cellspacing="0" cellpadding="0">
<tr>
	<td class="main">

<?php
if(isset($_GET['mode']) and $_GET['mode'] == 'view' and isset($_GET['ship_step']) and $_GET['ship_step'] > 0){
	$query = xtc_db_query("select id from shippings where status='0' and csv_status='1' order by customers_id");
	$total_num = xtc_db_num_rows($query);
	echo '<font size="4">WORKING ...</font>';
	echo '<br /><br /><b>'.sprintf(TEXT_WORKING_STATUS_MESSAGE,$total_num)
		.'</b><br /><br /><br /><font size="1">'
		.sprintf(TEXT_WORKING_STATUS_LINK,
			'<a href="'.xtc_href_link('shipping.php',xtc_get_all_get_params(array('mode')).'mode=write').'">Link</a>',
		)
		.'</font>';
}
?>

	</td>
</tr>
</table>


<?php 
require(DIR_WS_INCLUDES . 'footer.php'); 
require(DIR_WS_INCLUDES . 'application_bottom.php'); 

