<?php
// WEIGHT_FROM_ORDER wird beruecksichtigt
// 
// 
// 
// WRITES UPS CSV
if(sizeOf($packages) > 0 && $versender == 'UPS'){
    $anzahl_sammelsendg = 1;
    $csv_header = array(
        'Name',
        'Ansprechpartner',
        'Strasse',
        'Adresszusatz2',
        'Ort',
        'Plz',
        'Land',
        'Telefon',
        'UPSKundennummer',
        'UPSService',// DEFAULT = ST
        'Frankatur', // DEFAULT = PP
        'Verpackung', // DEFAULT = CP
        'Paketanzahl', // DEFAULT = 1
        'Sendungsgewicht', // DEFAULT = 5
        'Warenbeschreibung',
        'Referenz1', // (Auftragsnummer)
        'Referenz2', // (Rekla-Nummer)
        'Emailadresse',
    );
    if(defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'){
        $csv_header[] = 'Realgewicht';
    }

    $counter_sort = 0;
    foreach( $packages as $k=>$loop_element ){
        // NEUES VERSANDMODUL (v2) - 2021/02
        // WENN UMGESTELLT KOENNEN ALLE !v2 BLOECKE ENTFERNT WERDEN
        $v2 = (gettype($loop_element) == 'object');
        $row = $v2 ? $loop_element->shipping_configuration : $loop_element;

        $country_query = xtc_db_query("SELECT countries_iso_code_2 FROM countries WHERE countries_name='".$row['country_name']."'");
        $country_res = xtc_db_fetch_array($country_query);
        $country_iso_code_2 = $country_res['countries_iso_code_2'];

        $weight = $row['weight'];
        if(!WEIGHT_ACTIVE)
            $weight = $WEIGHT_NOWEIGHT;
        $real_weight = 0;
        if($row['reclamations_id'] > 0){
            $reclamation = new reclamation($row['reclamations_id']);
            $order = new order($reclamation->info['orders_id']);
            if($v2){
                $products_num = $loop_element->products_to_ship[0]->quantity;
                $products_model = $loop_element->products_to_ship[0]->model;
                $products_name = $loop_element->products_to_ship[0]->source_product['name'];
                $diff_items_num = sizeOf($loop_element->products_to_ship);
            }else{
                $products_num = $reclamation->products[0]['qty'];
                $products_model = $reclamation->products[0]['model'];
                $products_name = $reclamation->products[0]['name'];
                $diff_items_num = sizeOf($reclamation->products);
            }
            $ebay_id = 'R'.$row['reclamations_id'];
            if( $diff_items_num > 1 ){
                $referenz2 = 'Diverse Artikel';
            }else{
                $referenz2 = $products_model;
            }
            if(defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'){
                if($v2){
                    $real_weight = $loop_element->get_calculated_shipping_weight(true);
                }else{
                    $real_weight = $reclamation->show_weight( $row['id'] );
                }
            }
	}else{
            $order = new order($row['orders_id']);
            if($v2){
                $products_num = $loop_element->products_to_ship[0]->quantity;
                $products_model = $loop_element->products_to_ship[0]->model;
                $products_name = $loop_element->products_to_ship[0]->source_product['name'];
                $diff_items_num = sizeOf($loop_element->products_to_ship);
            }else{
                $products_num = $order->products[0]['qty'];
                $products_model = $order->products[0]['model'];
                $products_name = $order->products[0]['name'];
                $diff_items_num = sizeOf($order->products);
            }

            if($row['ebay_id'] == ''){
                $ebay_id = $row['orders_id'];
            }else{
                $ebay_id = $row['ebay_id'].' '.$row['orders_id'];
            }
            if( $diff_items_num > 1 ){
                $referenz2 = 'Diverse Artikel';
            }else{
                $referenz2 = $products_model;
            }
            if(defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'){
                if($v2){
                    $real_weight = $loop_element->get_calculated_shipping_weight(true);
                }else{
                    $real_weight = $order->show_weight($row['id']);
                }
            }
        }

        if(defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'){
            $real_weight = (int) $real_weight;
        }
// teppichmafia
        if(PRODUCTS_VIEW == 'model'){
            if($row['orders_id']>0){
                $versandtitel = $ebay_id.' ' .$products_num. ' x ' .$products_model;
            }else{
                $versandtitel = 'R'.$rID.' ' .$products_num. ' x ' .$products_model;
            }
        }else{
        // outleter
            if($row['orders_id']>0){
                $versandtitel = $ebay_id.' ' .$products_num. ' x ' .$products_name;
            }else{
                $versandtitel = 'R'.$rID.' ' .$products_num. ' x ' .$products_name;
            }
        }

        if(xtc_not_null($row['company'])){
            $sql_name = $row['company'];
            $name = (xtc_not_null($row['name2'])) ? $row['name1'].' '.$row['name2'] : $row['name1'];
            $sql_ap = $name;
        }else{
            $sql_name = $row['name1'];
            $sql_ap = $row['name2'];
        }

        $referenz1 = ($row['reclamations_id']>0) ? 'R'.$row['reclamations_id'] : $row['orders_id'];
        if($row['packages'] == 0){
            $sql_insert_array = array(
                'name'=>$sql_name,
                'ansprechpartner'=>$sql_ap,
                'strasse'=>$row['street1'],
                'adresszusatz2'=>$row['street2'],
                'ort'=>$row['city'],
                'plz'=>$row['postcode'],
                'land'=>$country_iso_code_2,
//					'telefon'=>$order->customer['telephone'],
                'telefon'=>'', // DATENSCHUTZ TEL RAUS
                'ups_kunden_nummer'=>UPS_CUSTOMER_ID,
                'upsservice'=>'ST',// DEFAULT = ST
                'frankatur'=>'PP', // DEFAULT = PP
                'verpackung'=>'CP', // DEFAULT = CP
                'paketanzahl'=>1, // DEFAULT = 1
                'sendungsgewicht'=>$weight, // DEFAULT = 5
                'warenbeschreibung'=>$versandtitel,
                'referenz1'=>$referenz1, // (Auftragsnummer)
                'referenz2'=>$referenz2, // artikel
                'sort_order'=>$counter_sort,
                'status'=>'1'
            );
            if(DSGVO_ALLOW_SEND_CUSTOMER_EMAIL_ADDRESS_TO_SHIPPER == 'True'){
                $sql_insert_array['emailadresse'] = $order->customer['email_address'];
            }
            xtc_db_perform('packages_calc_UPS',$sql_insert_array);
        }
        for($j=0;$j < $row['packages']; $j++){
            if($row['packages']>1){
                $versandtitel = 'SamS. '.$anzahl_sammelsendg.' / '.date("d.m.y");
                if(xtc_not_null($row['ebay_id'])){
                    $versandtitel = $row['ebay_id'] . ' SamS. '.$anzahl_sammelsendg.' / '.date("d.m.y").' '.($j+1).'/'.$row['packages'];
                }else{
                    if(xtc_not_null($row['orders_id'])){
                        $versandtitel = $row['orders_id'] . ' SamS. '.$anzahl_sammelsendg.' / '.date("d.m.y").' '.($j+1).'/'.$row['packages'];
                    }else{
                        $versandtitel = $row['reclamations_id'] . ' SamR. '.$anzahl_sammelsendg.' / '.date("d.m.y").' '.($j+1).'/'.$row['packages'];
                    }
                }
            }
            $sql_insert_array = array(
                'name'=>$sql_name,
                'ansprechpartner'=>$sql_ap,
                'strasse'=>$row['street1'],
                'adresszusatz2'=>$row['street2'],
                'ort'=>$row['city'],
                'plz'=>$row['postcode'],
                'land'=>$country_iso_code_2,
    //					'telefon'=>$order->customer['telephone'],
                'telefon'=>'', // DATENSCHUTZ TEL RAUS
                'ups_kunden_nummer'=>UPS_CUSTOMER_ID,
                'upsservice'=>'ST',// DEFAULT = ST
                'frankatur'=>'PP', // DEFAULT = PP
                'verpackung'=>'CP', // DEFAULT = CP
                'paketanzahl'=>1, // DEFAULT = 1
                'sendungsgewicht'=>$weight, // DEFAULT = 5
                'warenbeschreibung'=>$versandtitel,
                'referenz1'=>$referenz1, // (Auftragsnummer)
                'referenz2'=>$referenz2, // (Rekla-Nummer)
                'sort_order'=>$counter_sort,
                'status'=>'1',
                'real_weight'=>$real_weight
            );
            if(DSGVO_ALLOW_SEND_CUSTOMER_EMAIL_ADDRESS_TO_SHIPPER == 'True'){
                $sql_insert_array['emailadresse'] = $order->customer['email_address'];
            }
            xtc_db_perform('packages_calc_UPS',$sql_insert_array);
	}
			
	$counter_sort++;
    }
		
    // write csv
    $save_as_name = 'UPS_'.yes_get_sha1_from_string(date('Y_m_d-H_i_s')).'.csv';
    $path = \main::get_exportdata_path().yes_get_sha1_from_string(date('Y-m-d'));
    if(!is_dir($path)){
        mkdir($path);
    }
		
    $filename = $path.'/'.$save_as_name;
    $fh = fopen($filename,'a+') or die("Kann ".$filename." nicht anlegen.");
    fclose($fh);
    $csv = new CSVfile($filename);
    $csv->open("w");
    $csv->addRow($csv_header);
    $csvquery = xtc_db_query("select pc.* from packages_calc_UPS pc WHERE pc.status='1' ORDER BY pc.sort_order ASC");
    while ($csvrow = xtc_db_fetch_array($csvquery)) {
        $data = array(
            $csvrow['name'],
            $csvrow['ansprechpartner'],
            $csvrow['strasse'],
            $csvrow['adresszusatz2'],
            $csvrow['ort'],
            $csvrow['plz'],
            $csvrow['land'],
            $csvrow['telefon'],
            $csvrow['ups_kunden_nummer'],
            $csvrow['upsservice'],
            $csvrow['frankatur'],
            $csvrow['verpackung'],
            $csvrow['paketanzahl'],
            $csvrow['sendungsgewicht'],
            $csvrow['warenbeschreibung'],
            $csvrow['referenz1'],
            $csvrow['referenz2'],
            $csvrow['emailadresse']
        );
        if(defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'){
            $data[] = $csvrow['real_weight'];
        }
        $csv->addRow($data);
        xtc_db_query("UPDATE packages_calc_UPS SET status='2' WHERE packages_calc_ups_id='".$csvrow['packages_calc_ups_id']."'");
    }
    $csv->close();
}

