<?php
require_once(DIR_FS_INC.'xtc_get_short_description.inc.php');
require_once(DIR_WS_CLASSES.'yes_versandabschluss.php');
ini_set('memory_limit','1200M');
ini_set('time_limit',0);
set_time_limit(0);
if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
	include('includes/classes/amz_Helper.php');
	$AmazonHelper = new amazon_helper();
}

function quick_shipping_ajax_prepare_string($string){
    return yes_decode_string($string);
}

require_once(DIR_WS_CLASSES.'PDFMerger/PDFMerger.php');
if(isset($_REQUEST['mode']) and $_REQUEST['mode'] == 'dompdf_process'){
    include('shipping_action_ajax.DOMPDF.php');
    exit;
}
if(!is_dir(\main::get_exportdata_path().'DOMPDF_SHIP_PARTS')) {
    mkdir(\main::get_exportdata_path().'DOMPDF_SHIP_PARTS');
}
$process_shipping_id_array = (isset($_REQUEST['process_shipping_id_array'])) ? explode(',',$_REQUEST['process_shipping_id_array']) : array();

//if(defined('YES_VERSANDABSCHLUSS_V2_TEST') and YES_VERSANDABSCHLUSS_V2_TEST == 'True'){
    if(sizeOf($process_shipping_id_array)){
        $id_array = $process_shipping_id_array;
    }else{
        $id_array = yes_shipping::get_shippings_id_list();
    }
    $VERSANDABSCHLUSS = new YESShippingItems([
        'is_versandabschluss'=>true,
        'id_array'=>$id_array
    ]);
//}else{
//    $VERSANDABSCHLUSS = new yes_versandabschluss();
//}




/**
 * BOF - AUFTRAG MIT EINEM KLICK IM VERSANDMODUL SPEICHERN
 * ----
 * das ist kein Versandabschluss
 */
if(isset($_REQUEST['mode']) and $_REQUEST['mode'] == 'quick_shipping_process'){
	$errors = array();
	foreach($_REQUEST['orders_id'] as $nr => $orders_id){
		if($_REQUEST['reclamations_id'][$nr] > 0){
			$item = new reclamation($_REQUEST['reclamations_id'][$nr]);
			$shipping_type = 'reclamations_id';
		}else{
			$item = new order($_REQUEST['orders_id'][$nr]);
			$shipping_type = 'orders_id';
		}
		if(!$item->allow_shipping()){
			$errors[] = sprintf(TEXT_ERROR_QUICKSHIPPING_NOT_SHIPPABLE,$shipping_type,$id);
		}
		$ship_query = xtc_db_query(sprintf(
			"SELECT id,status,%s FROM shippings WHERE %s=%s",
			$shipping_type,$shipping_type,$item->info['id']
		));
		$ship_record = xtc_db_fetch_array($ship_query);
		if($ship_record['status'] == 1){
			$errors[] = sprintf(TEXT_ERROR_QUICKSHIPPING_ALWAYS_SHIPPED,$shipping_type,$id);
		}
		if($item->has_unallocated_ebay_items()){
			$errors[] = sprintf(TEXT_ERROR_QUICKSHIPPING_UNALLOCATED_EBAY_ITEMS,$shipping_type,$id);
		}
		if($item->has_unallocated_amazon_items()){
			$errors[] = sprintf(TEXT_ERROR_QUICKSHIPPING_UNALLOCATED_AMAZON_ITEMS,$shipping_type,$id);
		}
		if(sizeOf($errors)){
		    echo '<p><b>Fehler: Der Vorgang kann nicht durchgef&uuml;hrt werden.</b></p>';
		    foreach($errors as $err){
			    echo '<li>'.$err.'</li>';
		    }
		    exit;
		}
		$additional_params_str = '';
		if(in_array($_REQUEST['versender'][$nr],$VERSENDER)){
		    if(is_file(DIR_WS_MODULES.'shipping.versender_'.$_REQUEST['versender'][$nr].'.php')){
			include(DIR_WS_MODULES.'shipping.versender_'.$_REQUEST['versender'][$nr].'.php');
			$additional_params = array();
			foreach($shipping_versender_extra_fields as $sk=>$sv){
				if(isset($_REQUEST[$sv['name']])){
				    $additional_params[] = sprintf('%s::%s',$sv['name'],$_REQUEST[$sv['name']]);
				}
			}
			$additional_params_str = implode('|',$additional_params);
		    }
		}
		
		
		$insert_sql_array = array(
			'orders_id'=>$orders_id,
			'reclamations_id'=>$_REQUEST['reclamations_id'][$nr],
			'customers_id'=>$_REQUEST['customers_id'][$nr],
			'weight'=>$_REQUEST['weight'][$nr],
			'packages'=>$_REQUEST['packages'][$nr],
			'versender'=>$_REQUEST['versender'][$nr],
			'name1'=>quick_shipping_ajax_prepare_string($_REQUEST['name1'][$nr]),
			'name2'=>'',
			'company'=>quick_shipping_ajax_prepare_string($_REQUEST['company'][$nr]),
			'street1'=>quick_shipping_ajax_prepare_string($_REQUEST['street1'][$nr]),
			'street2'=>quick_shipping_ajax_prepare_string($_REQUEST['street2'][$nr]),
			'postcode'=>quick_shipping_ajax_prepare_string($_REQUEST['postcode'][$nr]),
			'city'=>quick_shipping_ajax_prepare_string($_REQUEST['city'][$nr]),
			'country_id'=>$_REQUEST['countries_id'][$nr],
			'country_name'=>  xtc_get_country_name($_REQUEST['countries_id'][$nr]),
			'country_special'=>'',
			'ebay_id'=>quick_shipping_ajax_prepare_string($_REQUEST['ebay_id'][$nr]),
			'email'=>quick_shipping_ajax_prepare_string($_REQUEST['email'][$nr]),
			'status'=>0,
		    'additional_params'=>$additional_params_str
		);
		if(isset($_REQUEST['id']) and isset($_REQUEST['id'][$nr])) {
			xtc_db_perform('shippings',$insert_sql_array,'update','id='.(int)xtc_db_input($_REQUEST['id'][$nr]));
                        $shID = xtc_db_insert_id();
			$process_shipping_id_array[] = (int)xtc_db_input($_REQUEST['id'][$nr]);
		}else{
			$insert_sql_array['date_added'] = 'now()';
			xtc_db_perform('shippings',$insert_sql_array);
                        $shID = xtc_db_insert_id();
			$process_shipping_id_array[] = xtc_db_insert_id();
		}
                //if(defined('YES_VERSANDABSCHLUSS_V2_TEST') and YES_VERSANDABSCHLUSS_V2_TEST == 'True'){
                    // BEI V2 VERSANDMODUL SPEICHERN WIR IMMER AUCH shippings_products
                    $src_product_field = ($shipping_type == 'orders_id') ? 'opID' : 'rpID';
                    foreach($item->products as $ip){
                        $insert_sql_array = array(
                            'shippings_id'=>$shID,
                            'products_id'=>$ip['id'],
                            'quantity'=>$ip['qty'],
                            'source_products_id'=>$ip[$src_product_field]
                        );
                        xtc_db_perform('shippings_products',$insert_sql_array);
                    }
                //}
	}
}
/**
 * EOF - AUFTRAG MIT EINEM KLICK IM VERSANDMODUL SPEICHERN
*/


$written_csv = array();
$crypt_dir = yes_get_sha1_from_string( date('Y-m-d') );
$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
$ship_pdf_name = \main::get_exportdata_path().$crypt_dir.'/DRUCKLISTE_GESAMT_'.$crypt_file.'.pdf';
if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
    $ship_pdf = new yes_pdf();
    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
	$ship_pdf->set_landscape();
    }
    $yes_pdf_content = array();
}else{
    $ship_pdf=new HTML2FPDF();
}
$pdf_smarty = new yesSmarty;
$ship_pdf_pages = 0;

$step_limit = MAX_ITEMS_SHIPPING_ACTION;
$step = (isset($_REQUEST['step'])) ? (int)xtc_db_input($_REQUEST['step']) : 0;
$basics = new basics;
switch($step){
    default:
        $check = $VERSANDABSCHLUSS->check_step(1);
        if($check['success'] !== true){
            $str = TEXT_ERROR_PDF_FILES_IN_QUEUE;
            // GIBT ES DATEIEN AELTER ALS 10 MIN
            if($check['youngest_file_seconds'] > 600){
                $str .= '<p><i>'.TEXT_ERROR_PDF_FILES_IN_QUEUE_DELETE.'</i></p><a href="'.xtc_href_link('shipping.php','action=delete_shipping_parts').'" style="text-decoration:none; padding: 3px;" class="ui-corner-all ui-state-highlight">'.IMAGE_DELETE.'</a>';
            }
            die($str);
        }

	if(!sizeOf($process_shipping_id_array)){
            if(get_class($VERSANDABSCHLUSS) == 'YESShippingItems'){
                // V2 Handling
                $anzahl_step1 = sizeOf($VERSANDABSCHLUSS->id_array);
            }else{
                // ALTES HANDLING
                $query = xtc_db_query("select * from shippings where status='0' and csv_status=0");
                $anzahl_step1 = xtc_db_num_rows($query);
            }
	    $smarty->assign(array('STEP1_NUM'=>$anzahl_step1,
		'TEXT_MAX_ITEMS_SHIPPING_ACTION'=>sprintf(TITLE_MAX_ITEMS_SHIPPING_ACTION,MAX_ITEMS_SHIPPING_ACTION)
	    ));
	    
    	}else{
	    $smarty->assign('STEP1_NUM',sizeOf($process_shipping_id_array));
	    $smarty->assign('INPUT_PROCESS_SHIPPING_ID_ARRAY',implode(',',$process_shipping_id_array));
	}
	$smarty->assign(array(
	    'HEADING_TITLE_WRITE'=>HEADING_TITLE_WRITE,
	    'TEXT_STEP'=>TEXT_STEP,
	    'INTRO_STEP1'=>INTRO_STEP1,
	    'INTRO_STEP2'=>INTRO_STEP2,
	    'INTRO_STEP3'=>INTRO_STEP3,
	    'TEXT_SHIPPING_HISTORY'=>TEXT_SHIPPING_HISTORY,
	    'BUTTON_START'=>BUTTON_START,
	    'TEXT_SHIPPING_ACTION_FINISHED'=>TEXT_SHIPPING_ACTION_FINISHED,
	    'USE_DOMPDF'=>USE_DOMPDF,
	    'PDF_PRODUCTS_EXPORT_AT_SHIPPING_ACTION'=>PDF_PRODUCTS_EXPORT_AT_SHIPPING_ACTION,
	    'INTRO_STEP4'=>INTRO_STEP4,
	    'BUTTON_SEND_SHIPPINGS_AFTER_WRITE'=>BUTTON_SEND_SHIPPINGS_AFTER_WRITE
	));
	break;
    case '1':
        //
        // CSV KOMPLETTPAKETLISTE und CSV PAKETLISTE der einzelnen Versender erzeugen.
	// csv_status WIRD AUF 1 GESETZT
        //
        $messages = array();
        
        // IN V2 IST $VERSANDABSCHLUSS eine Instanz von YESShippingItems
        // false heisst: nicht gruppiert nach shipper ausgeben
	$packagelist = $VERSANDABSCHLUSS->get_packagelist($messages,false);
	$packagelist_num = 0;
	$basics->parseTime();
	$written_csv = array();
	if(isset($packagelist) and is_array($packagelist) and sizeOf($packagelist)){
            // BOF - ERWEITERUNG FAKE SETS
	    if(defined('YES_PAYMODULE_PRODUCTS_FAKE_SETS') and YES_PAYMODULE_PRODUCTS_FAKE_SETS == 'True'){
                // was soll das? nur den ersten/letzten whatever shipping 
                // datensatz pruefen? raus
                //if($VERSANDABSCHLUSS->allow_export_fakeset($shipping)){
                    require_once(DIR_FS_INC.'YES_PAYMODULE_products_fake_sets_csv_export.inc.php');
                    $ship_pdf_name = \main::get_exportdata_path().$crypt_dir.'/FAKE_SETS_EXPORT_'.date('Y-m-d_His').'_'.$crypt_file.'.csv';
                    //if(defined('YES_VERSANDABSCHLUSS_V2_TEST') and YES_VERSANDABSCHLUSS_V2_TEST == 'True'){
                        // NEU
                        $YES_PAYMODULE_products_fake_sets_file = YES_PAYMODULE_products_fake_sets_csv_export_v2($packagelist,$ship_pdf_name);
                    //}else{
                        // ALT
                    //    $YES_PAYMODULE_products_fake_sets_file = YES_PAYMODULE_products_fake_sets_csv_export($packagelist,$ship_pdf_name);
                    //}
                    if($YES_PAYMODULE_products_fake_sets_file != ''){
                        $messages[] = 'FAKE SETS Export wurde generiert.';
                    }
                //}
	    }
            // EOF - ERWEITERUNG FAKE SETS
            //if(defined('YES_VERSANDABSCHLUSS_V2_TEST') and YES_VERSANDABSCHLUSS_V2_TEST == 'True'){
                $html = $VERSANDABSCHLUSS->yes_get_shipping_lagerliste_html('lagerliste_pdf',$smarty);
            //}else{
                // ALT
            //    $html = yes_get_shipping_lagerliste_html('lagerliste_pdf',$smarty);
            //}

	    // BOF - PAKETLISTE PDF - wie lagerliste_pdf in shippings - TICKET 1335
            $paketliste_pdf_file = \main::get_exportdata_path().$crypt_dir.'/PAKETLISTE_ALLE_VERSENDER_'.$crypt_file.'.pdf';
            if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
                $pdf_lagerliste = new yes_pdf();
                if(DOMPDF_ORDER_LANDSCAPE == 'True'){
                    $pdf_lagerliste->set_landscape();
                }
                $pdf_lagerliste->set_html($html);
                $pdf_lagerliste->save($paketliste_pdf_file);
            }else{
                $pdf_lagerliste = new HTML2FPDF();
                $pdf_lagerliste->AddPage();
                $pdf_lagerliste->WriteHTML($html);
                $pdf_lagerliste->Output($paketliste_pdf_file,'F'); //Read the FPDF.org manual to know the other options
            }
            $messages[] = 'Paketliste PDF wurde generiert.';
	    // EOF - PAKETLISTE PDF - wie lagerliste_pdf in shippings - TICKET 1335
	    
            //if(defined('YES_VERSANDABSCHLUSS_V2_TEST') and YES_VERSANDABSCHLUSS_V2_TEST == 'True'){
                $VERSANDABSCHLUSS->versandabschluss_paketliste_csv(false);
                $diff_shipper = $VERSANDABSCHLUSS->get_different_shippers_from_items();
                foreach($diff_shipper as $versender){
                    $VERSANDABSCHLUSS->versandabschluss_paketliste_csv(false, $versender);
                    $packages = array();
                    foreach($packagelist as $YESShippingItem){
                        if($YESShippingItem->shipping_configuration['versender'] != $versender){
                            continue;
                        }
                        $packages[] = $YESShippingItem;
                    }
                    require('shipping_action_'.$versender.'.php');
                    $messages[] = sprintf(MSG_SUCCESS_SENDER_PACKAGES,$versender,sizeOf($packages));
                }
                $messages[] = sprintf(MSG_SUCCESS_COMPLETELIST_PACKAGES,$packagelist_num);
            //}else{
            //    // KANN NACH v2 UMSTELLUNG WEG
            //    paketliste_csv('',false,$process_shipping_id_array); 
            //    $messages[] = sprintf(MSG_SUCCESS_COMPLETELIST_PACKAGES,$packagelist_num);
            //    //
            //    // schreibe Paketliste der einzelnen Versender
            //    foreach($packagelist as $versender => $packages) {
            //        if(!in_array($versender,$written_csv)){
            //            // if $versender != '' cvs geschrieben status setzen (csv_status = 1
            //            // RAUS - 11/2017 TICKET 2703
            //            paketliste_csv($versender,false,$process_shipping_id_array);
            //            //
//
            //            require('shipping_action_'.$versender.'.php');				
            //            $written_csv[] = $versender;
            //            $messages[] = sprintf(MSG_SUCCESS_SENDER_PACKAGES,$versender,sizeOf($packages));
            //        }
            //    }
            //}
	}else{
	    $messages[] = 'Keine Versanddatens&auml;tze zum Verarbeiten';
	}
	die(json_encode(array(
	    'messages'=>$messages,
	    'time'=>$basics->parseTime('end')
	)));
        break;
    case '2':
	// AUFTRAEGE ABARBEITE?, BESTAENDE UND EMAILS
        // Auftraege und Reklamationen aktualisieren, 
        // Lagerplaetze + Bestaende buchen
	// IN shippings WIRD status AUF 1 GESETZT
	$page_step = (isset($_REQUEST['page_step'])) ? (int)xtc_db_input($_REQUEST['page_step']) : 0;

        if(isset($_GET['one_click']) and $_GET['one_click'] == '1'){
            // BEI one_click Shipping werden keine CSV Listen geschrieben
            // hier den CSV Status setzen
            xtc_db_query("UPDATE shippings SET csv_status='1' WHERE id='".(int)xtc_db_input(current($process_shipping_id_array))."'");
        }
        
        
	$basics->parseTime();
	$packagelist = array();
	$packagelist_num = 0;
	// BOF - DARF NICHT GENULLT WERDEN - TICKET 1580
	//$process_shipping_id_array = array(); // FUER QUICKSHIPPING
	// EOF - DARF NICHT GENULLT WERDEN - TICKET 1580
	$sql_status = 0;
	$sql_csv_status = 1;
	$sql_pdf_status = 0;
        $messages = array();
        if(sizeOf($process_shipping_id_array)){
            $id_array = $process_shipping_id_array;
        }else{
            $id_array = yes_shipping::get_shippings_id_list(Null,[
                'status' => $sql_status,
                'csv_status'=>$sql_csv_status,
                'pdf_status'=>$sql_pdf_status
            ]);
        }
        $VERSANDABSCHLUSS = new YESShippingItems([
            'is_versandabschluss'=>true,
            'id_array'=>$id_array
        ]);
        // true = gruppiert nach versender
        $packagelist_full = $VERSANDABSCHLUSS->get_packagelist($messages,true);
        $total_num = sizeOf($packagelist_full);
        $packagelist = array_slice($packagelist_full, 0, $step_limit);
        $now_num = sizeOf($packagelist);
	if( !sizeOf($packagelist) ){
	    $messages = array(
		array('Keine Versanddatens&auml;tze zum Verarbeiten')
	    );
	    die(json_encode(array(
		'messages'=>$messages,
		'continue'=>0,
		'time'=>$basics->parseTime('end'),
                'error'=>1
	    )));
	}
	$barcodes_generated = array();
	foreach($packagelist as $versender => $packages) {
            $saved_orders_id = array();
            foreach($packages as $k=>$row) {
                // email_send_status 0 = Keinen Mailversand erlauben
                // email_send_status 1 = Mailversand erlauben
                // email_send_status 2 = Mailversand fand bereits statt
                $notified=0;
                $email_send_status = (defined('NO_SHIPPING_EMAIL') and NO_SHIPPING_EMAIL == 1) ? 0 : 1; // kein mailversand veranlassen
                //
                // V2 HANDLING
                if(gettype($row) == 'object'){
                    if(get_class($row->source_obj->class_obj) == 'order'){
                        $oID = $row->source_obj->getId();
                        $rID = 0;
                        $order = $row->source_obj->class_obj;
                    }else{
                        $oID = 0;
                        $rID = $row->source_obj->getId();
                        $reclamation = $row->source_obj->class_obj;
                    }
                    $YESShippingItem = $row;
                    $YESShippingItem->versandabschluss_update_class_obj($versender, $messages);
                    // VORBEREITUNGEN FUER NACHGELAGERTEN MAILVERSAND 16.09.14
                    // email_send_status wird auf 0 gesetzt, wenn eine Mail NICHT versendet werden SOLL
                    // email_send_status wird auf 1 gesetzt, wenn eine Mail versendet werden SOLL
                    // email_send_status wird auf 2 gesetzt, wenn eine Mail versendet WURDE
                    xtc_db_query(sprintf(
                        "UPDATE shippings SET status='1',email_send_status='%d', date_finished=now() WHERE id='%d'",
                        $email_send_status,
                        $YESShippingItem->shipping_configuration['id']
                    ));
                    continue;
                }else{
                    $oID = $row['orders_id'];
                    $rID = $row['reclamations_id'];
                    if($oID>0){
                        // VERSANDDATUM SETZEN - ORDERS_STATUS SET
                        // NEUE BEZAHLARTEN BERUECKSICHTIGEN
                        $order = new order($oID);
                    }
                }
                if($oID > 0){
                    $shipping_status = $order->process_shipping($row, $versender);
                    $op_shipped_status = $shipping_status['op_shipped_status'];


                    // FIBU NUMMER VERGEBEN
                    $order = new order($oID);
                    $xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
                    if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') && MODULE_OTHER_FIBUNUMBERS_STATUS == 'True' && MODULE_OTHER_FIBUNUMBERS_AUTOMATIC == 'True'){
                            $number = $order->get_fibunumber();
                            if(empty($number) or strlen($number)==1){
                                    $number = $order->add_fibunumber();
                                    $comments = sprintf(HISTORY_ORDER_FIBUNUMBER,$number);
                                    $order->add_history($order->info['orders_status'], false, $comments);
                            }
                    }
                    // MARGE BERECHNEN
                    if($op_shipped_status){
                        if(defined('PAY_MODULE_MARGE') and PAY_MODULE_MARGE == 'True'){
                            $order->save_marge();
                        }
                    }



                    // BOF - AMAZON WIEDER VOLLSTAENDIG INTEGRIEREN - TICKET 2173 - 07/2016
                    //if( NO_SHIPPING_EMAIL == 0 && !$order->has_amazon_items() and !stristr($row['email'],'marketplace.amazon')){
                    if( NO_SHIPPING_EMAIL == 0){
                    // EOF - AMAZON WIEDER VOLLSTAENDIG INTEGRIEREN - TICKET 2173 - 07/2016
                        $email_send_status = 1;
                    }
                    // 16.09.2014


                    //
                    // AMAZON ADDON - AMAZON MELDEN, DASS DIE ARTIKEL VERSENDET WURDEN
                    //
                    if($order->has_amazon_items()){
                        // WIRD HIER ZWAR NICHT VERWENDET, ABER DER VOLLSTAENDIGKEIT
                        // HALBER HIER DER AUFRUF DER FUNKTION MIT shippings_id 
                        // PARAMETER 06/2023
                        // $order->process_shipping_amazon($row['versender'],$AmazonHelper);
                        $order->process_shipping_amazon($row['versender'],$AmazonHelper,$YESShippingItem->shipping_configuration['id']);
                    }
                }else if($rID > 0) { // end if $oID
                    $reclamation = new reclamation($rID);
                    $reclamation->process_shipping($versender);
                }

                // VORBEREITUNGEN FUER NACHGELAGERTEN MAILVERSAND 16.09.14
                // email_send_status wird auf 0 gesetzt, wenn eine Mail NICHT versendet werden SOLL
                // email_send_status wird auf 1 gesetzt, wenn eine Mail versendet werden SOLL
                // email_send_status wird auf 2 gesetzt, wenn eine Mail versendet WURDE
                xtc_db_query("UPDATE shippings SET status='1',email_send_status='".$email_send_status."', date_finished=now() WHERE id='".$row['id']."'");
                if($oID>0){
                    $customer = new customer( $order->customer['ID'] );
                    $customer->update_current_account_value();
                }
            } // foreach packages as row
	} // eof foreach packagelist
	if(sizeOf($barcodes_generated)){
	    foreach($barcodes_generated as $bc){
            @unlink(\main::get_exportdata_path().$bc.'.jpg');
            @unlink(\main::get_exportdata_path().$bc.'.png');
	    }
	}
        
	if($page_step == 0){
		$modulo = $total_num % $step_limit;
		$total_steps = ($total_num - $modulo ) / $step_limit;
		if($modulo > 0){
			$total_steps++;
		}
		if($total_steps > 1){
			$messages[] = sprintf("<p><b>Durchlaufe insgesamt %s Versandmeldungen in %s Schritten.</b></p>",$total_num,$total_steps);
		}
	}
	$messages[] = sprintf('Es wurden %s Versandmeldungen durchlaufen.',$now_num);

	$rest_num = 0;
	if(!sizeOf($process_shipping_id_array)){
            //if(defined('YES_VERSANDABSCHLUSS_V2_TEST') and YES_VERSANDABSCHLUSS_V2_TEST == 'True'){
                $rest_num = $total_num-$now_num;
            //}else{
	    //	$sql_status = 0;
	//	$sql_csv_status = 1;
	//	$sql_pdf_status = 0;
	//	$query = xtc_db_query(sprintf(
	//		"select id from shippings where status='%d' and csv_status='%d' and pdf_status='%d' order by name1,customers_id",
	//		$sql_status,$sql_csv_status,$sql_pdf_status
	//	));
	//	$rest_num = xtc_db_num_rows($query);
        //  }
	}
	if($rest_num > 0){
		$messages[] = sprintf('Klicken Sie erneut auf "Start" um die %s verbleibenden Versandmeldungen zu verarbeiten.',$rest_num);
		die(json_encode(array(
		    'messages'=>$messages,
		    'time'=>$basics->parseTime('end'),
		    'continue'=>1,
                    'error'=>0
		)));
	}else{
		die(json_encode(array(
		    'messages'=>$messages,
		    'time'=>$basics->parseTime('end'),
		    'continue'=>0,
                    'error'=>0
		)));
	}
	break;
    case '3':
	// ERZEUGT PRODUKTLISTE VOM  + GREIFLISTEN_.zip UND SETZT pdf_status=1
        // 
        // 2020-04-28, mario:
        // AUSSERDEM WERDEN DIE TRACKINGNUMMERN AUS shippings_tracking_numbers_temp
        // IN DIE TABELLE shippings_tracking_numbers UEBERTRAGEN
        
        // Komplettpaketliste PDF sowie Greiflisten erzeugen.
	$basics->parseTime();
	$packagelist = array();
	// BOF - DARF NICHT GENULLT WERDEN - TICKET 1580
	//$process_shipping_id_array = array(); // FUER QUICKSHIPPING
	// EOF - DARF NICHT GENULLT WERDEN - TICKET 1580
	$sql_status = 1;
	$sql_csv_status = 1;
	$sql_pdf_status = 0;
	$messages = array();
        
        $one_click = (isset($_GET['one_click']) and $_GET['one_click'] == '1') ? true : false;
        
        $messages = array();
        if(sizeOf($process_shipping_id_array)){
            $id_array = $process_shipping_id_array;
        }else{
            $id_array = yes_shipping::get_shippings_id_list(Null,[
                'status' => $sql_status,
                'csv_status'=>$sql_csv_status,
                'pdf_status'=>$sql_pdf_status
            ]);
        }
        $VERSANDABSCHLUSS = new YESShippingItems([
            'is_versandabschluss'=>true,
            'id_array'=>$id_array
        ]);
        // true = gruppiert nach versender
        $packagelist_full = $VERSANDABSCHLUSS->get_packagelist($messages,true);
        $total_num = sizeOf($packagelist_full);
        $packagelist = array_slice($packagelist_full, 0, $step_limit);
        $now_num = sizeOf($packagelist);
        
        
	if( !sizeOf($packagelist) ){
	    $messages = array(
		array('Keine Versanddatens&auml;tze zum Verarbeiten')
	    );
	    die(json_encode(array(
		'messages'=>$messages,
		'time'=>$basics->parseTime('end'),
                'error'=>1
	    )));
	}
	$barcodes_generated = array();
	$basics->parseTime('start','fe1');
	foreach($packagelist as $versender => $packages) {
            $saved_orders_id = array();
            foreach($packages as $k=>$row) {
                
                // V2 HANDLING
                if(gettype($row) == 'object'){
                    if(get_class($row->source_obj->class_obj) == 'order'){
                        $oID = $row->source_obj->getId();
                        $rID = 0;
                        $order = $row->source_obj->class_obj;
                    }else{
                        $oID = 0;
                        $rID = $row->source_obj->getId();
                        $reclamation = $row->source_obj->class_obj;
                    }
                    $YS = $row;
                    $shippings_id = $YS->shipping_configuration['id'];
                }else{
                    $YS = new yes_shipping($row['id']);
                    $oID = $row['orders_id'];
                    $rID = $row['reclamations_id'];
                    $shippings_id = $row['id'];
                    if($rID > 0){
                        $reclamation = new reclamation($rID);
                    }else{
                        $order = new order($oID);
                    }
                }
                // BOF 2020-04-28 - Ticket 3048
                $YS->convert_temp_tracking_number_to_shipment();
                // EOF 2020-04-28 - Ticket 3048
                
                
                // ERZEUGE RECHNUNGEN/REKLAMATIONEN PDF
                if($oID>0){
                    $xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
                    if(PDF_ORDER_EXPORT_AT_SHIPPING_ACTION == 'True'){
                        // GENERIERE RECHNUNG-PDF
                        $pdf_smarty->clear_all_assign();
                        $pdf_html=xtc_get_order_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_order.html');

                        // FUEGE RECHNUNG AN GESAMTPDF AN
                        if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
                            $yes_pdf_content[] = $pdf_html;
                        }else{
                            $ship_pdf->AddPage();
                            $ship_pdf->WriteHTML($pdf_html);
                        }
                        $ship_pdf_pages++;
                    }

                    // FUER DRUCKLISTE GESAMT
                    if(PDF_PACKINGSLIP_EXPORT_AT_SHIPPING_ACTION == 'True'){
                        // GENERIERE LIEFERSCHEIN-PDF
                        $pdf_smarty->clear_all_assign();
                        if(defined('EXPORT_STORAGENUMBERS_PACKINGSLIP_IN_SHIPPING_PROCESS') and EXPORT_STORAGENUMBERS_PACKINGSLIP_IN_SHIPPING_PROCESS == 'True'){
                            $pdf_packingslip_html=xtc_get_packingslip_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_packingslip.html',true,true,$shippings_id);
                        }else{
                            $pdf_packingslip_html=xtc_get_packingslip_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_packingslip.html',false,true,$shippings_id);
                        }	
                        // FUEGE LIEFERSCHEIN AN GESAMTPDF AN
                        if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
                            $yes_pdf_content[] = $pdf_packingslip_html;
                        }else{
                            $ship_pdf->AddPage();
                            $ship_pdf->WriteHTML($pdf_packingslip_html);
                        }
                        if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
                            $barcodes_generated[] = 'BARCODE_'.$order->info['id'];
                        }
                        $ship_pdf_pages++;
                    }
                }else if($rID > 0) { // end if $oID
                    if(PDF_RECLAMATION_EXPORT_AT_SHIPPING_ACTION == 'True'){
                        // GENERIERE RECLA-PDF
                        $pdf_smarty->clear_all_assign();
                        $pdf_rekla_html=xtc_get_reclamation_packingslip_html_for_pdf($reclamation,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_rekla.html');

                        // FUEGE RECLA AN GESAMTPDF AN
                        if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
                            $yes_pdf_content[] = $pdf_rekla_html;
                        }else{
                            $ship_pdf->AddPage();
                            $ship_pdf->WriteHTML($pdf_rekla_html);
                        }
                        if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
                            $barcodes_generated[] = 'BARCODE_R'.$rID;
                        }
                        $ship_pdf_pages++;
                    }
                } // end if rid > 0
            } // end foreach oackages
	} // end foreach packagelist
        
	$fe1 = $basics->parseTime('end','fe1');
	$basics->parseTime('start','fe2');
	if($ship_pdf_pages > 0){
	    if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
		$landscape = false;
		if(DOMPDF_ORDER_LANDSCAPE == 'True'){
		    $landscape = true;
		}
		$ship_pdf->save_large_file($ship_pdf_name,$yes_pdf_content,$landscape);
	    }else{
		$ship_pdf->Output($ship_pdf_name,$dest='F');
	    }
	    $messages[] = basename($ship_pdf_name).' erzeugt';
	}
	$fe2 = $basics->parseTime('end','fe2');
	$basics->parseTime('start','fe3');
	if(sizeOf($barcodes_generated)){
	    foreach($barcodes_generated as $bc){
		@unlink(\main::get_exportdata_path().$bc.'.jpg');
		@unlink(\main::get_exportdata_path().$bc.'.png');
	    }
	}
// @TODO: an V2 anpassen
	if(!defined('PDF_PRODUCTS_EXPORT_AT_SHIPPING_ACTION') or PDF_PRODUCTS_EXPORT_AT_SHIPPING_ACTION != 'True'){
	    // KEINE PAKETLISTE - ENDE
	    if(sizeOf($process_shipping_id_array)){
		    xtc_db_query("UPDATE shippings SET pdf_status='1' WHERE status='1' and pdf_status=0 and id IN(".implode(',',$process_shipping_id_array).")");
		    //xtc_redirect($_REQUEST['from']);
	    }else{
		    xtc_db_query("UPDATE shippings SET pdf_status='1' WHERE status='1' and pdf_status=0");
		    //xtc_redirect(xtc_href_link('shipping.php?action=lagerliste'));
	    }
	}
	die(json_encode(array(
	    'messages'=>$messages,
	    'time'=>$basics->parseTime('end'),
            'error'=>0
	)));
	break;
    case '4':
        // PDF PRODUKTLISTE ERZEUGEN UND ANSCHLIESSEND pdf_status='1' SETZEN
        $messages = array();
	$basics->parseTime('start','fe4');
        $one_click = (isset($_GET['one_click']) and $_GET['one_click'] == '1') ? true : false;
	if(defined('PDF_PRODUCTS_EXPORT_AT_SHIPPING_ACTION') and constant('PDF_PRODUCTS_EXPORT_AT_SHIPPING_ACTION') == 'True'){
	    // ERZEUGT "PRODUKTLISTE VOM "
            //if(defined('YES_VERSANDABSCHLUSS_V2_TEST') and YES_VERSANDABSCHLUSS_V2_TEST == 'True'){
                $sql_status = 1;
                $sql_csv_status = 1;
                $sql_pdf_status = 0;
                if(sizeOf($process_shipping_id_array)){
                    $id_array = $process_shipping_id_array;
                }else{
                    $id_array = yes_shipping::get_shippings_id_list(Null,[
                        'status' => $sql_status,
                        'csv_status'=>$sql_csv_status,
                        'pdf_status'=>$sql_pdf_status
                    ]);
                }
                $VERSANDABSCHLUSS = new YESShippingItems([
                    'is_versandabschluss'=>true,
                    'id_array'=>$id_array
                ]);
                $ppdf = new yes_paketliste_pdf();
                if(isset($_REQUEST['debug']) and $_REQUEST['debug'] == 1){
                    $ppdf->setDebug_html(true);
                }
                $ppdf->V2 = true;
                $ppdf->setPre_write_mode(false);
                $paketliste_pdf_name = $ppdf->process_v2('', $VERSANDABSCHLUSS->get_items());
            //}else{
            //    $paketliste_pdf_name = paketliste_pdf(false,$process_shipping_id_array);
            //}
            if($paketliste_pdf_name != ''){
        	    $messages[] = basename($paketliste_pdf_name).' erzeugt';
            }else{
                $messages[] = MSG_ERROR_VERSANDABSCHLUSS_STEP4_NO_PDF_DATA_WRITTEN;
            }
	}

	if(sizeOf($process_shipping_id_array)){
		xtc_db_query("UPDATE shippings SET pdf_status='1' WHERE status='1' and pdf_status=0 and id IN(".implode(',',$process_shipping_id_array).")");
		//xtc_redirect($_REQUEST['from']);
	}else{
		xtc_db_query("UPDATE shippings SET pdf_status='1' WHERE status='1' and pdf_status=0");
		//xtc_redirect(xtc_href_link('shipping.php?action=lagerliste'));
	}
	$fe4 = $basics->parseTime('end','fe4');
	//$messages[] = sprintf('1: %s<br />2: %s<br />3: %s<br />4: %s',$fe1,$fe2,$fe3,$fe4);
	die(json_encode(array(
	    'messages'=>$messages,
	    'time'=>$basics->parseTime('end'),
            'error'=>0
	)));
	break;
}
header('Content-Type: text/html; charset='.CHARSET);
$smarty->display('shipping_action_write.html');
exit;
