<?php
/* --------------------------------------------------------------
   $Id: shipping_status.php,v 1.9 2017/01/21 07:15:30 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(orders_status.php,v 1.19 2003/02/06); www.oscommerce.com
   (c) 2003	 nextcommerce (orders_status.php,v 1.9 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

require('includes/application_top.php');
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
$languages = xtc_get_languages();
switch ($action) {
    case 'get_json_data':
        $id = (int)xtc_db_input($_GET['id']);
        die(json_encode(
            \YES4Trade\Model\shipping_status::get_by_id( $id )
        ));
        break;
    case 'insert':
    case 'save':
        $shipping_status_id = xtc_db_prepare_input($_GET['id']);
        for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
            $shipping_status_name_array = $_POST['shipping_status_name'];
            $language_id = $languages[$i]['id'];
            if(!isset($grafik)){
                $grafik = '';
                if(isset($_FILES['shipping_status_image']['name']) and !empty($_FILES['shipping_status_image']['name'])){
                    $file = $_FILES['shipping_status_image']['name'];
                    $ftype = array_pop( explode( ".", strtolower( $file ) ) );
                    if($ftype == 'gif' or $ftype == 'jpg' or $ftype == 'jpeg' or $ftype == 'png'){
                        $shipping_status_image = &xtc_try_upload('shipping_status_image',DIR_WS_ICONS);
                        if ($shipping_status_image !== false) {
                            $grafik = $shipping_status_image->filename;
                        }
                    }else{
                        $messageStack->add_session('Upload abgebrochen, erlaubt sind nur Grafiken','error');
                        xtc_redirect(xtc_href_link(basename(__FILE__)));
                    }
                }
            }

            if ($_GET['action'] == 'insert') {
                if(!isset($shipping_status_id)){
                    $next_id_query = xtc_db_query("select max(shipping_status_id) as shipping_status_id from " . TABLE_SHIPPING_STATUS . "");
                    $next_id = xtc_db_fetch_array($next_id_query);
                    $shipping_status_id = $next_id['shipping_status_id'] + 1;
                }

                $insert_sql_data = array(
                    'shipping_status_id' => (int)$shipping_status_id,
                    'language_id' => (int)$language_id,
                    'shipping_status_image'=>$grafik,
                    'shipping_status_name'=>$shipping_status_name_array[$language_id],
                );
                $new_shipping_status = new \YES4Trade\Model\shipping_status($insert_sql_data);
                $new_shipping_status->create();
            } elseif ($_GET['action'] == 'save') {
                $sql_data_array['shipping_status_id'] = (int)xtc_db_input($shipping_status_id);
                $sql_data_array['language_id'] = (int)$language_id;
                $sql_data_array['shipping_status_name'] = $shipping_status_name_array[$language_id];
                if(!empty($grafik)){
                    $sql_data_array['shipping_status_image'] = $grafik;
                }
                $upd_shipping_status = new \YES4Trade\Model\shipping_status($sql_data_array);
                $upd_shipping_status->update();
            }
        }
        if ($_POST['default'] == 'on') {
            main::update_configuration_value('DEFAULT_SHIPPING_STATUS_ID', xtc_db_input($shipping_status_id));
        }
        xtc_redirect(xtc_href_link(FILENAME_SHIPPING_STATUS, 'page=' . $_GET['page'] . '&oID=' . $shipping_status_id));
        break;
    case 'deleteconfirm':
        $oID = xtc_db_prepare_input($_GET['oID']);
        $ssID = main::get_configuration_value('DEFAULT_SHIPPING_STATUS_ID');
        if ($ssID == $oID) {
            main::update_configuration_value(DEFAULT_SHIPPING_STATUS_ID, '');
        }
        \YES4Trade\Model\shipping_status::delete((int) $oID);
        xtc_redirect(xtc_href_link(FILENAME_SHIPPING_STATUS, 'page=' . $_GET['page']));
        break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$buttons = array();
if (!isset($_GET['action']) or substr($_GET['action'], 0, 3) != 'new') {
    $buttons[] = array('text'=>IMAGE_INSERT,
	'link'=>'javascript:add_shipping_status()',
	'lbOn'=>false,
	'auth'=>true
    );
}
$smarty->assign(array(
    'HEADING_TITLE'=>BOX_SHIPPING_STATUS,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'SHIPPING_STATUS'=> \YES4Trade\Model\shipping_status::get_list($_SESSION['languages_id']),
    'LANGUAGES'=>$languages,
    'DELETE'=>IMAGE_DELETE,
    'CANCEL'=>IMAGE_CANCEL,
    'YES'=>YES
));
$smarty->display('shipping_status.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
