<?php
/* --------------------------------------------------------------
   $Id: stats_customers.php,v 1.25 2019/03/20 09:13:36 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(stats_customers.php,v 1.29 2002/05/16); www.oscommerce.com 
   (c) 2003	 nextcommerce (stats_customers.php,v 1.9 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

require('includes/application_top.php');
require(DIR_WS_CLASSES . 'currencies.php');
$currencies = new currencies();

$page = intval($_GET['page'] ?? 1);
$pds = $_GET['products_date_start'] ?? false;
$pde = $_GET['products_date_end'] ?? false;
$date_start = ($pds !== false) ? $pds : (new DateTime())->modify('-1 week')->format('Y-m-d');
$date_end = ($pde !== false) ? $pde : date('Y-m-d');
$orders_status = $_GET['orders_status'] ?? [];
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
if ($page > 1) {
    $rows = $page * MAX_DISPLAY_SEARCH_RESULTS_ADMIN - MAX_DISPLAY_SEARCH_RESULTS_ADMIN;
}
if(sizeOf($orders_status) > 0){
    $choosen_status = ' (';
    for($i=0;$i<sizeOf($orders_status);$i++){
            $choosen_status .= " o.orders_status='".$orders_status[$i]."' or";
    }
    $choosen_status = substr($choosen_status,0,(strlen($choosen_status)-2));
    $choosen_status .= ' )';
}else{
    $choosen_status = " o.orders_status != '".ORDERS_STATUS_STORNIERT."'";
}

$choosen_customers_status = '';
$customers_status = $_GET['customers_status'] ?? '';
if($customers_status != ''){
    $customers_status = intval($customers_status);
    $choosen_customers_status = sprintf(" AND c.customers_status='%d' ",
        $customers_status
    );
}

$buttons = array();
$status_input = array(
    xtc_draw_checkbox_field('orders_status[]','1',(in_array('1',$orders_status) or !$_POST)?true:false).  xtc_get_order_status_name(1),
    xtc_draw_checkbox_field('orders_status[]','2',(in_array('2',$orders_status) or !$_POST)?true:false).  xtc_get_order_status_name(2),
    xtc_draw_checkbox_field('orders_status[]',ORDERS_STATUS_UPSELLING,(in_array(ORDERS_STATUS_UPSELLING,$orders_status) or !$_POST)?true:false).  xtc_get_order_status_name(ORDERS_STATUS_UPSELLING),
    xtc_draw_checkbox_field('orders_status[]',ORDERS_STATUS_BEZAHLT,(in_array(ORDERS_STATUS_BEZAHLT,$orders_status) or !$_POST)?true:false).  xtc_get_order_status_name(ORDERS_STATUS_BEZAHLT),
    xtc_draw_checkbox_field('orders_status[]',ORDERS_STATUS_ABGESCHLOSSEN,(in_array(ORDERS_STATUS_ABGESCHLOSSEN,$orders_status) or !$_POST)?true:false).  xtc_get_order_status_name(ORDERS_STATUS_ABGESCHLOSSEN),
    xtc_draw_checkbox_field('orders_status[]',ORDERS_STATUS_VERSENDET,(in_array(ORDERS_STATUS_VERSENDET,$orders_status) or !$_POST)?true:false).  xtc_get_order_status_name(ORDERS_STATUS_VERSENDET),
    xtc_draw_checkbox_field('orders_status[]',ORDERS_STATUS_OFFER,(in_array(ORDERS_STATUS_OFFER,$orders_status))?true:false).  xtc_get_order_status_name(ORDERS_STATUS_OFFER)
);    

$smarty->assign(array(
    'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'FORM'=>xtc_draw_form('search','stats_customers.php','','GET','class="yesForm"'),
    'TEXT_FILTER_STATS'=>TEXT_FILTER_STATS,
    'TEXT_STATS_STARTDATE'=>TEXT_STATS_STARTDATE,
    'TEXT_STATS_ENDDATE'=>TEXT_STATS_ENDDATE,
    'TEXT_STATS_STATUS_FILTER'=>TEXT_STATS_STATUS_FILTER,
    'STATUS_FILTER'=>$status_input,
    'DATE_START'=>$date_start,
    'DATE_END'=>$date_end,
));
$customers_statuses = array_merge(array(array('id'=>'','text'=>TEXT_SELECT)),xtc_get_customers_statuses());
$customers_query_raw = sprintf(
	"select c.customers_id,c.customers_firstname, c.customers_lastname, o.customers_company,c.customers_status,sum(op.final_price) as ordersum from %s c, %s op, %s o where o.date_purchased>'%s' and o.date_purchased<'%s 23:59:59' and c.customers_id = o.customers_id and o.orders_id = op.orders_id and %s %s group by c.customers_id order by ordersum DESC",
	TABLE_CUSTOMERS, TABLE_ORDERS_PRODUCTS, TABLE_ORDERS, 
	$date_start,$date_end,$choosen_status,$choosen_customers_status
);
$customers_split = new splitPageResults($page, MAX_DISPLAY_SEARCH_RESULTS_ADMIN, $customers_query_raw, $customers_query_numrows);
// fix counted customers
$customers_query_count = xtc_db_query(sprintf(
    "select o.customers_id from %s o LEFT JOIN %s c USING(customers_id) WHERE %s %s and o.date_purchased>'%s' and o.date_purchased<'%s' group by o.customers_id",
    TABLE_ORDERS, TABLE_CUSTOMERS, $choosen_status, $choosen_customers_status, $date_start, $date_end
));
$customers_query_numrows = xtc_db_num_rows($customers_query_count);
$customers_query = xtc_db_query($customers_query_raw);
$total = 0;
$rows = ($page > 1)?($page*MAX_DISPLAY_SEARCH_RESULTS_ADMIN)-MAX_DISPLAY_SEARCH_RESULTS_ADMIN:0;
$data = array();
$_customers = array();
while ($record = xtc_db_fetch_array($customers_query)) {
    $_customers[] = $record;
}
foreach($_customers as $customers){
    $rows++;
    $total += $customers['ordersum'];
    if (strlen($rows) < 2) {
	$rows_str = '0' . $rows;
    }else{
        $rows_str = "$rows";
    }
    foreach($customers_statuses as $cs){
        if($cs['id'] == $customers['customers_status']){
            $customers['customers_status_name'] = xtc_db_prepare_input($cs['text']);
        }
    }
    $customers['rows'] = $rows_str;
    $customers['link'] = xtc_href_link(FILENAME_CUSTOMERS, 'action=crm&cID=' . $customers['customers_id'], 'NONSSL');
    $customers['ordersum_formatted'] = $currencies->format($customers['ordersum']);
    
    $cid_where = ($choosen_status != '') ? ' and ' : '';
    $cid_where .= sprintf(" o.customers_id='%s' ",$customers['customers_id']);
    $co_query_raw = sprintf(
            "select op.products_id,op.final_price from %s op, %s o where o.date_purchased>'%s' and o.date_purchased<'%s 23:59:59' and o.orders_id = op.orders_id and %s %s ",
            TABLE_ORDERS_PRODUCTS, TABLE_ORDERS, 
            $date_start,$date_end,$choosen_status,$cid_where
    );
    $co_query = xtc_db_query($co_query_raw);
    $_co = array();
    while($record = xtc_db_fetch_array($co_query)){
        $_co[] = $record;
    }
    $customers['distributors'] = array();
    foreach($_co as $co){
        $query = xtc_db_query(sprintf(
            "SELECT pdi.distributor_id,pdi.is_default, d.name FROM products_distributors pdi LEFT JOIN distributors d ON pdi.distributor_id=d.id WHERE pdi.products_id='%d' ORDER BY is_default LIMIT 1",
            $co['products_id']
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            if(!isset($customers['distributors'][$record['distributor_id']])){
                $customers['distributors'][$record['distributor_id']] = array(
                    'is_default'=>$record['is_default'],
                    'sum'=>0,
                    'name'=> xtc_db_prepare_input($record['name'])
                );
            }
            $customers['distributors'][$record['distributor_id']]['sum'] += $co['final_price'];
        }
// urspruenglich hier (03/19) - ticket 2944
//        $data[] = $customers;
        
    }
// nun hier (03/19) - ticket 2944
        $data[] = $customers;
}
$wiederkaeufer = 0;
foreach($data as $k=>$dat){
    $query = xtc_db_query(sprintf(
            "SELECT COUNT(orders_id) as ordernum FROM %s WHERE customers_id='%d'",
            TABLE_ORDERS,$dat['customers_id']
    ));
    $record = xtc_db_fetch_array($query);
    if($record['ordernum'] > 1){
        $wiederkaeufer++;
    }
}

$smarty->assign(array(
    'TABLE_HEADING_NUMBER'=>TABLE_HEADING_NUMBER,
    'TABLE_HEADING_CUSTOMERS'=>TABLE_HEADING_CUSTOMERS,
    'TABLE_HEADING_COMPANIES'=>TABLE_HEADING_COMPANIES,
    'TABLE_HEADING_TOTAL_PURCHASED'=>TABLE_HEADING_TOTAL_PURCHASED,
    'TOTAL'=>$currencies->format($total),
    'LISTING_COUNT'=>$customers_split->display_count($customers_query_numrows, MAX_DISPLAY_SEARCH_RESULTS_ADMIN, $page, TEXT_DISPLAY_NUMBER_OF_CUSTOMERS),
    'LISTING_LINKS'=>$customers_split->display_links($customers_query_numrows, MAX_DISPLAY_SEARCH_RESULTS_ADMIN, MAX_DISPLAY_PAGE_LINKS, $page,'products_date_start='.$date_start.'&products_date_end='.$date_end),
    'CUSTOMERS'=>$data,
    'INPUT_CUSTOMERS_STATUS'=>xtc_draw_pull_down_menu('customers_status',$customers_statuses,$customers_status)
));
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty->display('stats_customers.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
