<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_WS_CLASSES.'split_page_results_array.php');
require_once(DIR_WS_CLASSES.'product.php');
require(DIR_FS_CATALOG.'inc/xtc_get_parent_categories.inc.php');
require(DIR_FS_CATALOG.'inc/xtc_get_product_path.inc.php');
require(DIR_FS_CATALOG.'inc/xtc_mysql_timestamp_convert.inc.php');
if(is_file(DIR_WS_CLASSES.'storage.php')) require_once(DIR_WS_CLASSES.'storage.php');
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

if( !isset($_GET['stID'])){
	$default_query = xtc_db_query('SELECT id FROM storages ORDER BY id DESC LIMIT 1');
	$default = xtc_db_fetch_array($default_query);
	$stID = $default['id'];
}else{
	$stID = (int)xtc_db_prepare_input($_GET['stID']);
}

if( !isset($_GET['pID'] )){
	$pID = false;
}else{
	$pID = (int)xtc_db_prepare_input($_GET['pID']);
}
if( !isset($_GET['psID']) ){
	$psID = false;
}else{
	$psID = (int)xtc_db_prepare_input($_GET['psID']);
}

if( !isset($_GET['spID']) ){
	$spID = false;
}else{
	$spID = (int)xtc_db_prepare_input($_GET['spID']);
}
if (isset($_GET['action'])) {
    switch ($_GET['action']) {
        case 'get_unallocated_storage_places_total':
            $SQ = new products_quantity($pID);
            die(json_encode(array(
                'QUANTITY'=>$SQ->get_untransferred()
            )));
            break;
        case 'get_storage_place_quantity':
            $query = xtc_db_query(sprintf(
                    "SELECT quantity FROM storage_products WHERE id='%d'",
                    $spID
            ));
            $record = xtc_db_fetch_array($query);
            die(json_encode(array(
                'QUANTITY'=>(int)$record['quantity']
            )));
            break;
        case 'ajax_delete_place_process':
            $error = array();
            if(!isset($_REQUEST['stpID']) or !sizeOf($_REQUEST['stpID'])){
                $error[] = TEXT_DELETE_STORAGE_PLACES_ALLOCATIONS_NO_SUBMIT_DATA;
            }
            foreach($_REQUEST['stpID'] as $stpID){
                $stpID = (int)xtc_db_input($stpID);
                $query = xtc_db_query(sprintf(
                        "SELECT * FROM storage_products WHERE id='%s'",
                        $stpID
                ));
                if(!xtc_db_num_rows($query)){
                    $error[] = sprintf(TEXT_DELETE_STORAGE_PLACES_ALLOCATIONS_STP_NOT_EXISTS,$stpID);
                }else{
                    $record = xtc_db_fetch_array($query);
                    if($record['quantity']>0){
                        $error = sprintf(TEXT_DELETE_STORAGE_PLACES_ALLOCATIONS_STP_HAS_QUANTITY,$stpID);
                    }else{
                        $delete[] = $record;
                    }
                }
            }
            $messages = array();
            $stp_array = array();
            if(!sizeOf($error)){
                foreach($delete as $del){
                    $stpID = $del['id'];
                    $product = new product($del['products_id']);
                    $stp = yes_get_storage_place_title($del['storage_places_id']);
                    $comments = sprintf(TEXT_HISTORY_STORAGE_PLACE_ALLOCATION_REMOVE,
                            $stp, xtc_get_storage_name($del['storage_id'])
                    );
                    xtc_db_query(sprintf(
                            "DELETE FROM storage_products WHERE id='%s'",
                            $stpID
                    ));
                    $product->add_history($comments);
                    $messages[] = $comments;
                    $stp_array[] = $stpID;
                }
            }
            die(json_encode(array(
                'ERROR'=>implode("\r\n",$error),
                'MSG'=>implode("\r\n",$messages),
                'STPARRAY'=>$stp_array
            )));
            break;
        case 'ajax_delete_place':
            $stnID = (int)xtc_db_input($_REQUEST['snID']);
            $query = xtc_db_query(sprintf(
                    "SELECT * FROM storage_numbers WHERE id='%s'",
                    $stnID
            ));
            $record = xtc_db_fetch_array($query);
            $query = xtc_db_query(sprintf(
                    "SELECT * FROM storage_products WHERE storage_id='%s' AND products_id='%s'",
                    $record['storage_id'],$record['products_id']
            ));
            $items = array();
            $valid_items = 0;
            while($storage_product = xtc_db_fetch_array($query)){
                $stptitle = yes_get_storage_place_title($storage_product['storage_places_id']);
                if($storage_product['quantity'] > 0){
                    $items[] = '<input type="checkbox" disabled="disabled" /><span style="color: #FF0000;">'.sprintf(TEXT_ERROR_STORAGE_ALLOCATION_HAS_QUANTITY,$stptitle,$storage_product['quantity']).'</span>';
                }else{
                    $valid_items++;
                    $items[] = sprintf('<input name="stpID[]" value="%s" type="checkbox" />%s', $storage_product['id'],$stptitle);
                }
            }
            echo '<div class="main">';
            echo xtc_draw_form('delete_storage_place_allocation',basename(__FILE__),xtc_get_all_get_params(array('action')).'action=ajax_delete_place_process');
            printf('<p>%s</p>',sprintf(TEXT_DELETE_STORAGE_PLACES_ALLOCATIONS_INTRO,
                    $record['nummer']));
            echo implode('<br />',$items);
            if($valid_items > 0){
                echo '<br />'.yes_draw_href_button(IMAGE_DELETE, 'javascript:;', '', 'button','delete_stp ui-button ui-corner-all ui-state-error');
            }
            echo '</form>';
            echo '</div>';
            exit;
            break;
        case 'ajax_delete_storage_allocation_process':
            $product = new product((int)xtc_db_input($_REQUEST['products_id']));
            $stnID = (int)xtc_db_input($_REQUEST['storage_numbers_id']);
            $query = xtc_db_query(sprintf(
                    "SELECT * FROM storage_numbers WHERE id='%s' AND products_id='%s'",
                    $stnID,
                    $product->info['products_id']
            ));
            $error = array();
            if(!xtc_db_num_rows($query)){
                $error[] = TEXT_ERROR_STORAGE_NUMBER_ALLOCATION_DOESNT_EXISTS;
            }
            // storage_id und nummer
            $record = xtc_db_fetch_array($query);
            $stID = $record['storage_id'];
            $nummer = xtc_db_prepare_input($record['nummer']);
            $storage_products = array();
            $query = xtc_db_query(sprintf(
                    "SELECT * FROM storage_products WHERE storage_id='%s' AND products_id='%s'",
                    $stID,
                    $product->info['products_id']
            ));
            while($record = xtc_db_fetch_array($query)){
                $storage_products[] = $record;
            }
            foreach($storage_products as $record){
                if($record['quantity'] > 0){
                    $error[] = sprintf(TEXT_ERROR_STORAGE_ALLOCATION_HAS_QUANTITY,
                        yes_get_storage_place_title($record['storage_places_id']),
                        $record['quantity']
                    );
                }
            }
            $success_msg = '';
            if(!sizeOf($error)){
                $deleted_places = array();
                foreach($storage_products as $stp){
                    $deleted_places[] = yes_get_storage_place_title($stp['storage_places_id']);
                    xtc_db_query(sprintf(
                            "DELETE FROM storage_products WHERE id='%s'",
                            $stp['id']
                    ));
                }
                xtc_db_query(sprintf(
                        "DELETE FROM storage_numbers WHERE id='%s'",
                        $stnID
                ));
                $success_msg = sprintf(MSG_SUCCESS_STORAGE_ALLOCATION_DELETED, xtc_get_storage_name($stID), $nummer,implode(', ',$deleted_places));
                $product->add_history($success_msg);
            }
            $error_msg = (sizeOf($error)) ? implode("\r\n",$error) : '';
            die(json_encode(array(
                'ERROR'=>yes_encode_string($error_msg),
                'MESSAGE'=>yes_encode_string($success_msg),
                'STNID'=>$stnID
            )));
            die('T'.time());
            exit;
            break;
        case 'ajax_delete_storage_allocation':
            $product = new product((int)xtc_db_input($_REQUEST['products_id']));
            $stnID = (int)xtc_db_input($_REQUEST['storage_numbers_id']);
            $query = xtc_db_query(sprintf(
                    "SELECT * FROM storage_numbers WHERE id='%s' AND products_id='%s'",
                    $stnID,
                    $product->info['products_id']
            ));
            $error = array();
            if(!xtc_db_num_rows($query)){
                $error[] = TEXT_ERROR_STORAGE_NUMBER_ALLOCATION_DOESNT_EXISTS;
            }
            // storage_id und nummer
            $record = xtc_db_fetch_array($query);
            $stID = $record['storage_id'];
            $nummer = xtc_db_prepare_input($record['nummer']);
            $storage_products = array();
            $query = xtc_db_query(sprintf(
                    "SELECT * FROM storage_products WHERE storage_id='%s' AND products_id='%s'",
                    $stID,
                    $product->info['products_id']
            ));
            while($record = xtc_db_fetch_array($query)){
                $storage_products[] = $record;
            }
            foreach($storage_products as $record){
                if($record['quantity'] > 0){
                    $error[] = sprintf(TEXT_ERROR_STORAGE_ALLOCATION_HAS_QUANTITY,
                        yes_get_storage_place_title($record['storage_places_id']),
                        $record['quantity']
                    );
                }
            }
            $smarty->assign(array(
                'ERROR'=>$error,
                'INTRO'=>sprintf(TEXT_STORAGE_ALLOCATION_DELETE_INTRO,sizeOf($storage_products),$nummer),
                'DELETE_LINK'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=ajax_delete_storage_allocation_process'),
                'IMAGE_DELETE'=>IMAGE_DELETE
            ));
	    header('Content-Type: text/html; charset='.CHARSET);
            $smarty->display('product_storage_allocation_delete.tpl');
            exit;
            break;
	case 'ajax_add_new_storage_place':
	    $stID = (int)xtc_db_input($_REQUEST['stID']);
	    $title = yes_decode_string($_REQUEST['title']);
	    $description = yes_decode_string($_REQUEST['description']);
	    if(trim(xtc_db_input($title)) == ''){
		die(json_encode(array(
		    'MSG'=>TEXT_NO_STORAGE_PLACE_SUBMITTED
		)));
	    }
	    $query = xtc_db_query(sprintf(
		    "SELECT storage_places_id FROM storage_places WHERE storage_id='%s' AND title='%s'",
		    $stID,
		    $title
	    ));
	    if(xtc_db_num_rows($query)){
		header('Content-Type: text/html; charset='.CHARSET);
		die(json_encode(array(
		    'MSG'=>sprintf(TEXT_NEW_STORAGE_PLACE_EXISTS,xtc_db_input(yes_encode_string($title)))
		)));
	    }
	    $insert_sql_array = array(
		'storage_id'=>$stID,
		'title'=>$title,
		'description'=>$description
	    );
	    xtc_db_perform('storage_places',$insert_sql_array);
	    $stpID = xtc_db_insert_id();
	    header('Content-Type: text/html; charset='.CHARSET);
	    die(json_encode(array(
		'MSG'=>'',
		'STPID'=>$stpID
	    )));
	    break;
	case 'ajax_add_place_process':
	    $msg = '';
	    $stID = (int)xtc_db_input($_REQUEST['stID']);
	    $snID = (int)xtc_db_input($_REQUEST['snID']);
	    $spID = (int)xtc_db_input($_REQUEST['spID']);
	    $pID = (int)xtc_db_input($_REQUEST['pID']);
	    if($spID == 0){
		$msg = TEXT_JS_ERROR_NO_STORAGE_PLACE;
	    }else{
		$query = xtc_db_query(sprintf(
			"SELECT id FROM storage_products WHERE storage_id='%s' AND products_id='%s' AND storage_places_id='%s'",
			$stID,$pID,$spID
		));
		if(xtc_db_num_rows($query)){
		    $msg = sprintf(MSG_ERROR_STORAGE_PLACE_EXISTS,xtc_get_products_name($pID));
		}else{
		    $insert_sql_array = array(
			'storage_id'=>$stID,
			'products_id'=>$pID,
			'created'=>'now()',
			'storage_places_id'=>$spID
		    );
		    xtc_db_perform('storage_products',$insert_sql_array);
		    $spID = xtc_db_insert_id();
		}
	    }
	    die(json_encode(array(
		'MSG'=>yes_decode_string($msg),
		'SPID'=>$spID
	    )));
	    break;
	case 'ajax_add_place':
	    $stID = (int)xtc_db_input($_REQUEST['stID']);
	    $snID = (isset($_REQUEST['snID'])) ? (int)xtc_db_input($_REQUEST['snID']) : 0;
	    $pID = (int)xtc_db_input($_REQUEST['pID']);
	    $hide_title = (isset($_REQUEST['hide_title'])) ? true : false;
	    $source = (isset($_REQUEST['source'])) ? xtc_db_input($_REQUEST['source']) : '';
	    $storage = new storage($stID);
	    $storage_places_array = array_merge(array(
		    array('id'=>'','text'=>TEXT_SELECT),
		    array('id'=>'__new__','text'=>IMAGE_ADD_STORAGE_PLACE)
		),
		$storage->get_storage_places_for_product($pID, true));
	    $smarty->assign(array(
		'PRODUCTS_ID'=>$pID,
		'STID'=>$stID,
		'SNID'=>$snID,
		'IMAGE_ADD_STORAGE_PLACE'=>IMAGE_ADD_STORAGE_PLACE,
		'TEXT_AVAILABLE_STORAGE_PLACES'=>TEXT_AVAILABLE_STORAGE_PLACES,
		'INPUT_STORAGE_PLACES'=>xtc_draw_pull_down_menu('storage_places_id',$storage_places_array),
		'HIDE_TITLE'=>$hide_title,
		'SOURCE'=>$source,
		'BUTTON_ADD_STORAGE_PLACE'=>BUTTON_ADD_STORAGE_PLACE,
		'TEXT_ALLOCATE_PRODUCT_STORAGE_PLACES'=>TEXT_ALLOCATE_PRODUCT_STORAGE_PLACES,
		'TEXT_STORAGE_DESCRIPTION'=>TEXT_STORAGE_DESCRIPTION,
	    ));
	    header('Content-Type: text/html; charset='.CHARSET);
	    $smarty->display('storage_places_ajax_add.tpl');
	    exit;
	    break;
	case 'add_multiple_confirm':
	    $products = array();
	    $storage_info = array();
	    $stID = (isset($_REQUEST['stID'])) ? $_REQUEST['stID'] : 0;
	    if($stID > 0){
		$storage = new storage($stID);
		$storage_info = array(
		    'id' => $storage->getId(),
		    'name'=> $storage->getName(),
		    'beschreibung' => $storage->getBeschreibung(),
		    'schema_key' => $storage->getSchema_key(),
		    'schema_start' => $storage->getSchema_start(),
		    'default_storage' => $storage->getDefault_storage(),
                    'places'=>array_merge(array(array('id'=>'','text'=>TEXT_SELECT)),$storage->get_storage_places())
		);
		
		if(isset($_REQUEST['storage_places_id']) and $_REQUEST['storage_places_id'] > 0 and isset($_REQUEST['savepid']) and sizeOf($_REQUEST['savepid'])){
		    $storage_places_id = (int)xtc_db_input($_REQUEST['storage_places_id']);
		    foreach($_REQUEST['savepid'] as $savepid){
			$savepid = (int)xtc_db_input($savepid);
			$schema_key = xtc_db_prepare_input($storage_info['schema_key']);
			$schema_start = xtc_db_prepare_input($storage_info['schema_start']);
			if($schema_start >= 0){
				$max = 0;
				$key_query = xtc_db_query("SELECT nummer FROM storage_numbers WHERE nummer LIKE '".$schema_key."%' AND storage_id='".$stID."'");
				while($key = xtc_db_fetch_array($key_query)){
					$value = explode($schema_key,$key['nummer']);
					if((int)$value[1] > $max) $max = (int)$value[1];
				}

				if($max >= $schema_start)
				    $new_key = $schema_key.($max+1);
				else
				    $new_key = $schema_key.$schema_start;
			}else{
				$new_key = $schema_key.$savepid;
			}
			$storage_number = $new_key;
			
			$insert_sql_array = array(
			    'products_id'=>$savepid,
			    'storage_id'=>$stID,
			    'nummer'=>$storage_number,
			);
			xtc_db_perform('storage_numbers',$insert_sql_array);
			
                        // bugfix: storage_places_id muss gespeichert werden
                        //         und nicht storage_place
			$insert_sql_array = array(
			    'products_id'=>$savepid,
			    'storage_id'=>$stID,
			    'quantity'=>0,
			    'storage_places_id'=>$storage_places_id
			);
			xtc_db_perform('storage_products',$insert_sql_array);
		    }
		    die(json_encode(array(
			'MSG'=>''
		    )));
		}
		
		foreach($_REQUEST['pID'] as $pID){
		    $product = new product($pID);
		    $products[] = array(
			'products_id'=>$pID,
			'products_ean'=>$product->info['products_ean'],
			'products_model'=>$product->info['products_ean'],
			'storage'=>$product->get_storage_allocation( $stID )
		    );
		}
	    }
	    $storages = array_merge(array(array('id'=>'','text'=>TEXT_SELECT)),xtc_get_storages());
	    $smarty->assign(array(
		'PRODUCTS'=>$products,
		'BASEURL'=>xtc_href_link(basename($_SERVER['PHP_SELF']),xtc_get_all_get_params(array('stID'))),
		'INPUT_STORAGE'=> xtc_draw_pull_down_menu('stID',$storages,$stID),
		'STORAGE_INFO'=>$storage_info,
		'TEXT_JS_ERROR_NO_PRODUCTS' => TEXT_JS_ERROR_NO_PRODUCTS,
		'TEXT_JS_ERROR_NO_STORAGE_PLACE' => TEXT_JS_ERROR_NO_STORAGE_PLACE,
		'TEXT_MULTIPLE_PRODUCTS_STORAGE_SAVE_SUCCESS' => TEXT_MULTIPLE_PRODUCTS_STORAGE_SAVE_SUCCESS,
		'TABLE_HEADING_STORAGE_ALLOCATION'=>TABLE_HEADING_STORAGE_ALLOCATION,
		'TABLE_HEADING_STORAGE_PLACE'=>TABLE_HEADING_STORAGE_PLACE,
		'TABLE_HEADING_STORAGE_NUMBER'=>TABLE_HEADING_STORAGE_NUMBER,
		'TEXT_STORAGE_NUMBER_AUTOMATIC'=>TEXT_STORAGE_NUMBER_AUTOMATIC,
		'TEXT_STORAGE'=>TEXT_STORAGE,
		'TEXT_INPUT_STORAGE_PLACE'=>TEXT_INPUT_STORAGE_PLACE,
		'TEXT_TOGGLE_ALL_PRODUCTS'=>TEXT_TOGGLE_ALL_PRODUCTS,
		'TABLE_HEADING_PRODUCTS_MODEL'=>TABLE_HEADING_PRODUCTS_MODEL,
		'TEXT_INPUT_SAVE'=>TEXT_INPUT_SAVE,
                'INPUT_STORAGE_PLACES_ID'=>(is_countable($storage_info['places']))?xtc_draw_pull_down_menu('storage_places_id',$storage_info['places']):TEXT_NO_STORAGE_PLACES_AVAILABLE,
		'TEXT_NO_STORAGE_PLACES_AVAILABLE'=>TEXT_NO_STORAGE_PLACES_AVAILABLE,
                'BASELINK_STORAGE_PLACES_ADD'=>xtc_href_link('storage.php','action=storage_places&id='),
                'BUTTON_ADD_STORAGE_PLACE'=>BUTTON_ADD_STORAGE_PLACE,
	    ));
	    header('Content-Type: text/html; charset='.CHARSET);
	    $smarty->display('storage_admin_add_multiple.html');
	    exit;
	    break;
		case 'add':
			$pquery = xtc_db_query("SELECT p.*,pd.* FROM products p, products_description pd WHERE pd.products_id=p.products_id && p.products_id='".$spInfo->products_id."' && pd.language_id='".$_SESSION['languages_id']."'");
			$product = xtc_db_fetch_array($pquery);
			$pInfo = new objectInfo($product);

			$dquery = xtc_db_query("SELECT d.name FROM distributors d,products_distributors pd WHERE d.id=pd.distributor_id && pd.products_id='".$spInfo->products_id."'");
			$products_distributors = '';
			while($distributor = xtc_db_fetch_array($dquery)){
				$products_distributors .= $distributor['name']."<br>";
			}
			if($products_distributors == '') $products_distributors = sprintf('<i>%s</i>',TEXT_NO_DISTRIBUTOR_ALLOCATED);

			$squery = xtc_db_query("SELECT nummer FROM storage_numbers WHERE products_id='".$spInfo->products_id."' && storage_id='".$spInfo->storage_id."'");
			$storagenr = xtc_db_fetch_array($squery);
			if($storagenr['nummer']!=''){
				$storage_number = $storagenr['nummer'];
			}else{
				$storage_number = false;
			}

			$smarty->clear_all_assign();

			$smarty->assign('PRODUCTS_NAME',$pInfo->products_name);
			$smarty->assign('PRODUCTS_IMAGE',DIR_WS_CATALOG.'images/product_images/thumbnail_images/'.$pInfo->products_image);
			$smarty->assign('PRODUCTS_STORAGE_NUMBER',$storage_number);
			$smarty->assign('PRODUCTS_DISTRIBUTORS',$products_distributors);
			$smarty->assign('PRODUCTS_QUANTITY',$pInfo->products_quantity);
			$smarty->assign('PRODUCTS_DESCRIPTION',substr(strip_tags($pInfo->products_description),0,120).'...');
			$main_content= $smarty->fetch(DIR_FS_ADMIN.'templates/products_short_desc.html');

			$heading[] = array('text' => sprintf('<b>%s</b>',sprintf(TEXT_EDIT_STORAGE_PLACE,$spInfo->storage_place)));
			$contents = array('form' => xtc_draw_form('storage_place', 'storage_admin.php', 'spID=' . $spInfo->id . '&stID='.$spInfo->storage_id.'&pID='.$spInfo->products_id.'&action=update'));
			$contents[] = array('text' => TEXT_INTRO_STORAGE_PLACE_EDIT);

			$contents[] = array('text' => '<b>'.TEXT_CREATED.'</b> '.yes_strftime('%d.%m.%Y',strtotime($spInfo->created)));
			$contents[] = array('text' => '<b>'.TEXT_MODIFIED.'</b> '.yes_strftime("%d.%m.%Y",strtotime(xtc_mysql_timestamp_convert($spInfo->changed))));

			$contents[] = array('text' => $main_content);
			$contents[] = array('text' => '<br><b>'.LABEL_STORAGE_PLACE.'</b><br>' . xtc_draw_input_field('storage_place',$spInfo->storage_place));
			$contents[] = array('align' => 'center', 'text' => '<br>' . xtc_image_submit('button_update.gif', IMAGE_UPDATE) . '&nbsp;<a href="' . xtc_href_link('storage_admin.php', 'spID=' . $spInfo->id.'&stID='.$stID) . '">' . xtc_image_button('button_cancel.gif', IMAGE_CANCEL) . '</a>');
			exit;
			break;
		case 'history':
			$spID = (int)xtc_db_input($_REQUEST['spID']);
			$query = xtc_db_query(sprintf(
				"SELECT * FROM storage_products_transfer WHERE source_storage_products_id=%s OR target_storage_products_id=%s ORDER BY date_added DESC LIMIT 100",
				$spID,$spID
			));
			$transfers = array(
				'from','into'
			);
			$data = array();
			$sp_array = array(); // objektarray
			while($record = xtc_db_fetch_array($query)){
				if($record['source_storage_products_id'] > 0){
					if(!in_array($record['source_storage_products_id'],$sp_array))
						$sp_array[ $record['source_storage_products_id'] ] = new storage_product($record['source_storage_products_id']);
					$ssp = $sp_array[ $record['source_storage_products_id'] ]->getStorage_place();
				}else if($record['source_storage_products_id'] == 0){
					$ssp = 'ZUWEISUNG';
				}else if($record['source_storage_products_id'] == -2){
					$ssp = 'VERSAND';
				}else if($record['source_storage_products_id'] == -1){
					$ssp = 'BESTANDSEINGABE';
				}
				if($record['target_storage_products_id'] > 0){
					if(!in_array($record['target_storage_products_id'],$sp_array))
						$sp_array[ $record['target_storage_products_id'] ] = new storage_product($record['target_storage_products_id']);
					$tsp = $sp_array[ $record['target_storage_products_id'] ]->getStorage_place();
				}else if($record['target_storage_products_id'] == 0){
					$tsp = 'ZUWEISUNG';
				}else if($record['target_storage_products_id'] == -2){
					$tsp = 'VERSAND';
				}else if($record['target_storage_products_id'] == -1){
					$tsp = 'BESTANDSEINGABE';
				}
				$reason = '';
				if(!empty($record['reason_class'])){
					$reason = $record['reason_class'].': '.$record['reason_id'];
					if($record['reason_subclass'] != ''){
						$reason .= ' ('.$record['reason_subclass'].')';
					}
				}
				$data[] = array(
					'date_added'=>xtc_date_short($record['date_added']),
					'quantity'=>$record['quantity'],
/*					'quantity'=>(($record['source_storage_products_id']==$spID or $record['source_storage_products_id'] == 0)?$record['quantity']:-$record['quantity']),*/
					'source_storage_place'=>$ssp,
					'target_storage_place'=>$tsp,
					'editor'=>xtc_get_editor_name($record['editor']),
					'reason'=>$reason
				);
			}
			$smarty->assign(array(
				'data'=>$data,
				'TABLE_HEADING_DATE_ADDED'=>TABLE_HEADING_DATE_ADDED,
				'TABLE_HEADING_QUANTITY'=>TABLE_HEADING_QUANTITY,
				'TABLE_HEADING_SOURCE_STORAGE_PLACE'=>TABLE_HEADING_SOURCE_STORAGE_PLACE,
				'TABLE_HEADING_TARGET_STORAGE_PLACE'=>TABLE_HEADING_TARGET_STORAGE_PLACE,
				'TABLE_HEADING_EDITOR'=>TABLE_HEADING_EDITOR,
				'TABLE_HEADING_REASON'=>TABLE_HEADING_REASON
			));
			$smarty->display('storage_products_transfer.html');
			exit;
			break;
		case 'addproductsplace':
			$storage_places_id = xtc_db_prepare_input($_POST['storage_places_id']);
			if($storage_places_id > 0 && $stID > 0 && $pID > 0){
				$check_query = xtc_db_query("SELECT id FROM storage_products WHERE storage_places_id='".$storage_places_id."' and products_id='".$pID."' and storage_id='".$stID."'");
				if(xtc_db_num_rows($check_query) > 0){
					$messageStack->add_session(sprintf(MSG_ERROR_STORAGE_PLACE_EXISTS,$pID), 'error');
					xtc_redirect(xtc_href_link('storage_admin.php', 'stID=' . $stID.'&spID='.$spID));
				}else{
					xtc_db_query("INSERT INTO storage_products SET storage_places_id='".$storage_places_id."',storage_id='".$stID."',products_id='".$pID."',created=now()");
					$messageStack->add_session(MSG_SUCCESS_STORAGE_PLACE_ADDED, 'success');
					xtc_redirect(xtc_href_link('storage_admin.php', 'stID=' . $stID));
				}
			}else{
				$messageStack->add_session(MSG_ERROR_NO_STORAGE_PLACE_CREATED, 'error');
				xtc_redirect(xtc_href_link('storage_admin.php', 'stID=' . $stID));
			}
			break;
		case 'update':
			$storage_place = xtc_db_prepare_input($_POST['storage_place']);
			if(!empty($storage_place) && $stID > 0 && $pID > 0){
				$check_query = xtc_db_query("SELECT id FROM storage_products WHERE storage_place='".$storage_place."' and products_id='".$pID."' and storage_id='".$stID."'");
				if(xtc_db_num_rows($check_query) > 0){
					$messageStack->add_session(sprintf(MSG_ERROR_STORAGE_PLACE_EXISTS,$storage_place,$pID), 'error');
					xtc_redirect(xtc_href_link('storage_admin.php', 'stID=' . $stID.'&spID='.$spID));
				}else{
					xtc_db_query("UPDATE storage_products SET storage_place='".$storage_place."' WHERE id='".$spID."'");
					$messageStack->add_session(sprintf(MSG_SUCCESS_STORAGE_PLACE_UPDATED,$storage_place), 'success');
				}
				xtc_redirect(xtc_href_link('storage_admin.php', 'stID=' . $stID));
			}else{
				$messageStack->add_session(MSG_ERROR_NO_STORAGE_PLACE_UPDATE, 'error');
				xtc_redirect(xtc_href_link('storage_admin.php', 'stID=' . $stID));
			}
			break;
	case 'delete':
		if(is_int($spID) && $spID > 0){
			xtc_db_query("DELETE FROM storage_products WHERE id=".(int)$spID);
			$messageStack->add_session(MSG_SUCCESS_STORAGE_PLACE_DELETE, 'success');
		}else{
			$messageStack->add_session(MSG_ERROR_STORAGE_PLACE_DELETE, 'error');
		}
		xtc_redirect(xtc_href_link('storage_admin.php','stID='.$stID));
		break;
	case 'allocate_untransferred_process':
		$pID = (int)xtc_db_input($_REQUEST['products_id']);
		$query_raw = sprintf(
			"SELECT products_quantity-SUM(sp.quantity) as untransferred, products_quantity, SUM(sp.quantity) as transferred, sp.products_id FROM storage_products sp LEFT JOIN products p USING(products_id) LEFT JOIN products_collies pc USING(products_id) WHERE p.products_id=%s",
			$pID
		);
		$query = xtc_db_query($query_raw);
		$record = xtc_db_fetch_array($query);
		$untransferred = $record['untransferred'];
		$transferred = $record['transferred'];
		
		$total_submitted = 0;
		foreach($_REQUEST as $key=>$value){
			if(strstr($key,'qty_')){
				$total_submitted += $value;
			}
		}
		if($total_submitted > $untransferred){
			$messageStack->add_session(sprintf(JS_ERROR_QTY_ALL_ALLOCATE,$untransferred),'error');
		}else{
			foreach($_REQUEST as $key=>$value){
				if(strstr($key,'qty_')){
					$spID = substr($key,4,strlen($key));
					$update_sql_query_raw = sprintf("UPDATE storage_products SET quantity=quantity+%s WHERE id=%s",
						$value,$spID
					);
					xtc_db_query($update_sql_query_raw);
					$sql_insert_array = array(
						'source_storage_products_id'=>0,
						'target_storage_products_id'=>$spID,
						'quantity'=>$value,
						'editor'=>$_SESSION['customer_id'],
						'date_added'=>'now()'
					);
					xtc_db_perform('storage_products_transfer',$sql_insert_array);
				}
			}
			$messageStack->add_session(sprintf(MSG_SUCCESS_ALLOCATION,$total_submitted),'success');
		}
		
		xtc_redirect(xtc_href_link('storage_admin.php',xtc_get_all_get_params(array('action','products_id')).'action=untransferred'));
		exit;
		break;
	case 'allocate_untransferred':
		$pID = (int)xtc_db_input($_REQUEST['products_id']);
		$query_raw = sprintf(
			"SELECT products_quantity-SUM(sp.quantity) as untransferred, products_quantity, SUM(sp.quantity) as transferred, sp.products_id FROM storage_products sp LEFT JOIN products p USING(products_id) LEFT JOIN products_collies pc USING(products_id) WHERE p.products_id=%s",
			$pID
		);
		$query = xtc_db_query($query_raw);
		$record = xtc_db_fetch_array($query);
		$untransferred = $record['untransferred'];
		$transferred = $record['transferred'];
		$phys = $record['products_quantity'];
		$query = xtc_db_query(sprintf(
			"SELECT * FROM storage_products WHERE products_id=%s ORDER BY priority",
			$pID
		));
		while($record = xtc_db_fetch_array($query)){
			$data[] = $record;
		}
		$items = array();
		if(sizeOf($data)){
			foreach($data as $sp){
				$storage_query = xtc_db_query(sprintf(
					"SELECT name FROM storages WHERE id=%s",
					$sp['storage_id']
				));
				$storage = xtc_db_fetch_array($storage_query);
				$sp['storage_name'] = $storage['name'];
				if($sp['storage_places_id']>0){
				    $sp['storage_place'] = yes_get_storage_place_title($sp['storage_places_id']);
				}
				$items[] = $sp;
			}
		}
		$smarty->assign(array(
			'items'=>$items,
			'transferred'=>$transferred,
			'untransferred'=>$untransferred,
			'products_quantity'=>$phys,
			'JS_PROMPT_QTY_TO_ALLOCATE'=>JS_PROMPT_QTY_TO_ALLOCATE,
			'JS_ERROR_QTY_ALLOCATE'=>JS_ERROR_QTY_ALLOCATE,
			'JS_ERROR_QTY_ALL_ALLOCATE'=>JS_ERROR_QTY_ALL_ALLOCATE,
			'FORM_END'=>'</form>',
			'FORM'=>xtc_draw_form('allct','storage_admin.php',xtc_get_all_get_params(array('action')).'action=allocate_untransferred_process','POST','id="allocation_form"')
		));
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display('storage_admin_allocate_untransferred.html');
		exit;
		break;
	}
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script type="text/javascript">
$(function(){
    $('a.available_storage_places').click(function(){
	$('#modal_window').dialog({
	   title: $(this).text(),
	   width: 'auto',
	   height: 'auto',
	   modal: true
	}).load('storage.php?action=get_available_storage_places&stID=<?php echo $_REQUEST['stID']; ?>&pID=<?php echo $_REQUEST['pID']; ?>');
    });
});
</script>

	<div class="yesPageHeading"><?php echo PAGE_HEADING; ?> &raquo;<?php echo xtc_get_storage_name($stID); ?>&laquo;</div>
	
<?php
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch($action){
	case 'addproduct':
?>

		<br />
		<b><?php echo TEXT_ADD_PRODUCT; ?></b>
		<br />
<?php
		if($pID > 0) {
			$pquery = xtc_db_query("SELECT p.*,pd.* FROM products p, products_description pd WHERE pd.products_id=p.products_id && p.products_id='".$pID."' && pd.language_id='".$_SESSION['languages_id']."'");
			$product = xtc_db_fetch_array($pquery);
			$pInfo = new objectInfo($product);

			$squery = xtc_db_query("SELECT nummer FROM storage_numbers WHERE products_id='".$pID."' && storage_id='".$stID."'");
			$storagenr = xtc_db_fetch_array($squery);
			if($storagenr['nummer']!=''){
				$storage_number = $storagenr['nummer'];
			}else{
				$storage_number = false;
			}
			$s_p = array(); // vorhandene lagerorte des produkts
			$spquery = xtc_db_query("SELECT *,DATE_FORMAT(created,'%d.%m.%Y %H:%i') as datum FROM storage_products WHERE products_id='".$pID."' && storage_id='".$stID."'");
			while($storageproducts = xtc_db_fetch_array($spquery)){
				$s_p[] = array(
					'INPUT_STORAGE_PLACE_ID'=>'',
					'INPUT_STORAGE_PLACE'=>$storageproducts['storage_place'],
					'CREATED'=>$storageproducts['datum'],
					'CHANGED'=>($storageproducts['changed']>0)?yes_strftime('%d.%m.%Y %H:%M',strtotime($storageproducts['changed'])):''
				);

			}
			if(count($s_p)>0){
				echo "\t",'<br /><span class="main">'.TEXT_EXISTING_STORAGE_PLACES.'</span>',"\n";
				$smarty->assign('places',$s_p);
				$main_content= $smarty->fetch(DIR_FS_ADMIN.'templates/storage_places.html');
				echo $main_content;
				echo "<br>";
			}

			$dquery = xtc_db_query("SELECT d.name FROM distributors d,products_distributors pd WHERE d.id=pd.distributor_id && pd.products_id='".$pID."'");
			$products_distributors = '';
			while($distributor = xtc_db_fetch_array($dquery)){
				$products_distributors .= $distributor['name']."<br>";
			}
			if($products_distributors == '') $products_distributors = '<i>Kein Lieferant angegeben</i>';

			$smarty->clear_all_assign();

			$smarty->assign(array(
			    'PRODUCTS_NAME'=>$pInfo->products_name,
			    'TABLE_HEADING_STORAGE_ALLOCATION'=>TABLE_HEADING_STORAGE_ALLOCATION,
			    'TABLE_HEADING_STORAGE_PLACE'=>TABLE_HEADING_STORAGE_PLACE,
			    'TABLE_HEADING_STORAGE_NUMBER'=>TABLE_HEADING_STORAGE_NUMBER,
			    'TEXT_STORAGE_NUMBER_AUTOMATIC'=>TEXT_STORAGE_NUMBER_AUTOMATIC,
			    'TEXT_STORAGE'=>TEXT_STORAGE,
			    'TEXT_INPUT_STORAGE_PLACE'=>TEXT_INPUT_STORAGE_PLACE,
			    'TEXT_TOGGLE_ALL_PRODUCTS'=>TEXT_TOGGLE_ALL_PRODUCTS,
			    'TABLE_HEADING_PRODUCTS_MODEL'=>TABLE_HEADING_PRODUCTS_MODEL,
			    'TABLE_HEADING_PRODUCT'=>TABLE_HEADING_PRODUCT,
			));
			if($pInfo->products_image != '' and is_file(DIR_WS_CATALOG.'images/product_images/thumbnail_images/'.$pInfo->products_image))
				$smarty->assign('PRODUCTS_IMAGE',DIR_WS_CATALOG.'images/product_images/thumbnail_images/'.$pInfo->products_image);
			$smarty->assign('PRODUCTS_STORAGE_NUMBER',$storage_number);
			$smarty->assign('PRODUCTS_DISTRIBUTORS',$products_distributors);
			$smarty->assign('PRODUCTS_QUANTITY',$pInfo->products_quantity);
			$smarty->assign('PRODUCTS_DESCRIPTION',substr(strip_tags($pInfo->products_description),0,120).'...');
			$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
			$main_content= $smarty->fetch(DIR_FS_ADMIN.'templates/products_short_desc.html');

			echo "<table border='0' width=\"400\" class=\"formArea\"><tr><td>";
			echo $main_content;
			echo "</td></tr></table>";
			echo xtc_draw_form('newstorage','storage_admin.php','action=addproductsplace&stID='.$stID.'&pID='.$pID,'post');
?>
		<br />
		<table border="0" cellpadding="3" cellspacing="4" class="formArea">
		<tr>
			<td class="main" width="170"><?php echo LABEL_STORAGE_PLACE; ?></td>
			<td>
			    <?php 
			    $storage = new storage($stID);
			    $storage_places = $storage->get_storage_places_for_product($pID,true);
			    $storage_places = array_merge(array(array(
				'id'=>'','text'=>TEXT_SELECT
			    )),$storage_places);
			    echo xtc_draw_pull_down_menu('storage_places_id',$storage_places,$_REQUEST['storage_places_id']);
			    ?>
			</td>
			<td>&nbsp;<?php echo xtc_draw_input_field('speichern',BUTTON_ADD_STORAGE_PLACE,'class="ui-button ui-corner-all ui-state-default"','','submit');?></td><td><input value="<?php echo IMAGE_CANCEL; ?>" class="ui-button ui-corner-all ui-state-default" type="button" onclick="window.location.href='storage_admin.php?stID=<?php echo $stID; ?>';"></td>
		</tr>
		</table>
		</form>


<?php
		}else{
?>
				<table border="0" cellpadding="0">
				<tr>
<?php
			$form_action = "ebayapi";
			echo xtc_draw_form($form_action, 'storage_admin','action=addproduct&stID='.$stID, 'post');
?>
<script type="text/javascript">
<!--
function move_cat(iframe) {
    var msieTruth = (navigator.appVersion.indexOf("MSIE")!=-1 && navigator.userAgent.indexOf("Opera") ==-1);

    if(!msieTruth) {
        cat = document.getElementById('catlevel'+(iframe-1)).contentDocument.ebayapi.category.value;
        document.getElementById('catlevel'+(iframe)).contentDocument.location.href="ebayapi_shopcatshow.php?level="+iframe+"&one=1&category="+cat+"&stID=<?php echo $stID; ?>";
    }else{
        cat = frames["catlevel"+(iframe-1)].ebayapi.category.value;
        frames["catlevel"+(iframe)].location.href="ebayapi_shopcatshow.php?level="+iframe+"&one=1&category="+cat+"&stID=<?php echo $stID; ?>";
    }
}
function iframe_submit(){
    var msieTruth = (navigator.appVersion.indexOf("MSIE")!=-1 && navigator.userAgent.indexOf("Opera") ==-1);

    if(!msieTruth) {
        prod = document.getElementById('catlevel2').contentDocument.ebayapi.products_id.value;
        document.location.href='storage_admin.php?action=addproduct&stID=<?php echo $stID; ?>&pID='+prod
    }else{
        prod = frames["catlevel2"].ebayapi.products_id.value;
        document.location.href='storage_admin.php?action=addproduct&stID=<?php echo $stID; ?>&pID='+prod
    }
}
//-->
</script>
				</tr>
				<tr>
					<td><br>
					<table border="0">
					<tr>
						<td><iframe width="350" height="265" id="catlevel1" name="catlevel1" src="ebayapi_shopcatshow.php?level=1"></iframe></td>
						<td><input type="button" name="setlevel2" value=">>" onclick="move_cat('2');" /></td>
						<td><iframe width="350" height="265" id="catlevel2" name="catlevel2" src="ebayapi_shopcatshow.php"></iframe></td>
					</tr>
					<tr>
						<td colspan="5" align=right class=main><input type="button" onclick="iframe_submit();" value="<?php IMAGE_SAVE; ?>"></td>
					</tr>
					</table>
					</td>
				</tr>
				</form>
				</table>
<?php

		}
?>

		</form>
<?php
		break;
	case 'untransferred':
		$data = array();
		$query_raw = "SELECT products_quantity-SUM(sp.quantity) as untransferred, products_quantity, SUM(sp.quantity) as transferred, sp.products_id,sp.storage_id,sp.id FROM storage_products sp LEFT JOIN products p USING(products_id) LEFT JOIN products_collies pc USING(products_id) WHERE pc.products_id IS NULL ";
		if(isset($_REQUEST['products_id'])){
			$pID = (int)xtc_db_input($_REQUEST['products_id']);
			$query_raw .= ' AND p.products_id='.$pID;
		}
		$query_raw .= " GROUP BY sp.products_id ORDER BY untransferred DESC";
		$query = xtc_db_query($query_raw);
		while($record = xtc_db_fetch_array($query)){
			$record['products_name'] = xtc_get_products_name($record['products_id']);
			if($record['untransferred']>0){
				$record['untransferred_link'] = xtc_href_link('storage_admin.php',xtc_get_all_get_params(array('action','products_id')).'action=allocate_untransferred&products_id='.$record['products_id']);
			}
			$record['storage_link'] = xtc_href_link('storage_admin.php',xtc_get_all_get_params(array('action','products_id','spID','stID','pID')).'pID='.$record['products_id'].'&stID='.$record['storage_id'].'&spID='.$record['id']);
			$data[] = $record;
		}
		$page = (isset($_REQUEST['page']))?$_REQUEST['page']:0;
		$split = new splitPageResultsArray($page, MAX_DISPLAY_SEARCH_RESULTS_ADMIN, $data, $query_num_rows);
		$smarty->assign(array(
			'STORAGE_ADMIN_UNTRANSFERRED_PRODUCTS'=>STORAGE_ADMIN_UNTRANSFERRED_PRODUCTS,
			'TEXT_PRODUCTS_UNALLOCATED'=>TEXT_PRODUCTS_UNALLOCATED,
			'TEXT_PRODUCTS_ALLOCATED'=>TEXT_PRODUCTS_ALLOCATED,
			'items'=>$data,
			'SPLIT1' => $split->display_links($query_num_rows, MAX_DISPLAY_SEARCH_RESULTS_ADMIN, MAX_DISPLAY_SEARCH_RESULTS_ADMIN, $page, xtc_get_all_get_params(array('page'))),
			'SPLIT2' => $split->display_count($query_num_rows, MAX_DISPLAY_SEARCH_RESULTS_ADMIN, $page, TEXT_DISPLAY_NUMBER_OF_ITEMS)
		));
		$smarty->display('storage_admin_untransferred.html');
		break;
	default:
		$storage_places = array();
		$storages_query = xtc_db_query('SELECT name,id FROM storages ORDER BY name');
		$storages_array = array();
		while($storage = xtc_db_fetch_array($storages_query)){
			$storages_array[] = array('id'=>$storage['id'],'text'=>$storage['name']);
		}
		echo xtc_draw_form('storage_choose','storage_admin.php','','GET');
		echo xtc_draw_hidden_field('action','switch_storage');
		echo xtc_draw_pull_down_menu('stID',$storages_array, $stID,'onChange=document.forms["storage_choose"].submit();');

		echo yes_draw_href_button(IMAGE_STORAGE_EDIT, xtc_href_link('storage.php','sID='.$stID), 'width:160px;');
?>
		</form>
		<?php
		echo xtc_draw_form('storage_search','storage_admin.php',xtc_get_all_get_params(array('search','search_mode')),'POST');
		echo IMAGE_SEARCH.'&nbsp;';
		echo xtc_draw_input_field('search', ((isset($_REQUEST['search']))?$_REQUEST['search']:''), 'size="12" maxlength="64" id="storage_search"');
		echo xtc_draw_pull_down_menu('search_mode',array(
			array('id'=>'products_id','text'=>INPUT_SEARCH_MODE_PID),
			array('id'=>'storage_number','text'=>INPUT_SEARCH_MODE_STORAGE_NUMBER),
			array('id'=>'ean_model','text'=>INPUT_SEARCH_MODE_EAN_MODEL)
		),((isset($_REQUEST['search_mode']))?$_REQUEST['search_mode']:''));
		printf('<input type="submit" value="%s" class="ui-button ui-corner-all ui-state-default" />',IMAGE_SEARCH);
		echo '</form>';

?>
		<input type="button" onclick="window.location.href='<?php echo xtc_href_link('storage_admin.php','action=untransferred'); ?>';" class="ui-button ui-corner-all ui-state-default" value="<?php echo TEXT_BUTTON_UNTRANSFERRED; ?>" />
<?php
		// direct link
		if(isset($_GET['pID']) and $_GET['pID'] != '' and isset($_GET['spID']) and $_GET['spID'] != '' and !isset($_GET['page']) and (!isset($_GET['action']) or $_GET['action'] == 'delete_confirm' or (isset($_GET['action']) and $_GET['action'] == 'edit') )){
?>
		<br><p>
		<span class="main"><?php TEXT_VIEW_STORAGE_PLACE; ?> <a href="<?php echo xtc_href_link('storage_admin.php','stID='.$_GET['stID']); ?>"><u><?php echo TEXT_VIEW_ALL_STORAGE_PLACES; ?></u></a></span>
		</p>
<?php
		}else{
?>
		<br /><p>
		<span class="main"><?php TEXT_ALLOCATED_PLACES_FOR_STORAGE; ?></span>
		</p>
<?php
		}
		$search_order_by = ' products_id desc ';
		if(isset($_REQUEST['order_by'])){
			$sort_asc = true;
			$order_by = $_REQUEST['order_by'];
			$parts = explode(' ',$_REQUEST['order_by']);
			if(sizeOf($parts)>1){
				list($order_by,$direction) = $parts;
				if(strtolower($direction) == 'desc')
					$sort_asc = false;
			}
			$search_order_by = sprintf(' %s %s ',$order_by,(($sort_asc == true) ? 'asc' : 'desc'));
			$smarty->assign('SUBMITTED_ORDER_BY',$order_by);
			$smarty->assign('SUBMITTED_ORDER_DIRECTION',(($sort_asc)?'asc':'desc'));
		}
		$search_where = '';
		if(isset($_REQUEST['search'])){
			switch($_REQUEST['search_mode']){
				case 'products_id':
					$search_where = sprintf(' and p.products_id=%s ',(int)xtc_db_input($_REQUEST['search']));
					break;
				case 'storage_number':
					$search_where = sprintf(' and sn.nummer LIKE \'%%%s%%\' ',xtc_db_input($_REQUEST['search']));
					break;
				case 'ean_model':
					$search_where = sprintf(' and (p.products_ean LIKE \'%%%s%%\' or p.products_model LIKE \'%%%s%%\') ',xtc_db_input($_REQUEST['search']),xtc_db_input($_REQUEST['search']));
					break;
			}
		}
		if(isset($_GET['pID']) and $_GET['pID'] != '' and isset($_GET['spID']) and $_GET['spID'] != '' and !isset($_GET['page']) and (!isset($_GET['action']) or $_GET['action'] == 'delete_confirm' or $_GET['action'] == 'edit' )){
			$storages_query_raw = sprintf(
				"select sp.*,sp.id as spit,sn.nummer,pd.products_name,sp.products_id from storage_products sp, products_description pd, products p, storage_numbers sn where sp.id=%s and sn.storage_id=%s && pd.products_id=sp.products_id && pd.language_id=%s && sp.products_id=sn.products_id && sn.storage_id=sp.storage_id and p.products_id=pd.products_id %s order by %s",
				(int)xtc_db_input($_GET['spID']),$stID,$_SESSION['languages_id'],$search_where,$search_order_by
			);
		}else{
			$filter_pID_sql = (isset($_REQUEST['pID']) and $_REQUEST['pID'] > 0) ? " and sp.products_id='".(int)xtc_db_input($_REQUEST['pID'])."'" : '';
			$storages_query_raw = sprintf(
				"select sp.*,sp.id as spit,sn.nummer,pd.products_name,sp.products_id from storage_products sp left join storage_numbers sn using(products_id,storage_id) left join products_description pd using(products_id) left join products p using(products_id) where sp.storage_id=%s && pd.language_id=%s %s %s order by %s",
				$stID,$_SESSION['languages_id'],$search_where,$filter_pID_sql,$search_order_by
			);
		}
		$storages_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $storages_query_raw, $storages_query_numrows);
		$smarty->assign(array(
		    'TABLE_HEADING_PRODUCT'=>TABLE_HEADING_PRODUCT,
		    'TABLE_HEADING_STORAGE_NUMBER'=>TABLE_HEADING_STORAGE_NUMBER,
		    'TABLE_HEADING_STORAGE_PLACE'=>TABLE_HEADING_STORAGE_PLACE,
		    'SPLIT1'=>$storages_split->display_count($storages_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_ITEMS,xtc_get_all_get_params(array('page','spID'))),
		    'SPLIT2'=>$storages_split->display_links($storages_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], xtc_get_all_get_params(array('page','spID'))),
		    'SORT_BASE_URL'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('order_by')))
		));
		$products = array();
		$storages_query = xtc_db_query($storages_query_raw);
		$storage_places_array = array();
		while ($storage = xtc_db_fetch_array($storages_query)) {
		    $storage_places_array[] = $storage;
		}
		foreach($storage_places_array as $storage){
		    $product = array();
		    if($storage['storage_places_id']>0){
			$storage_place_query = xtc_db_query("select stp.title from storage_places stp where storage_places_id = '" . $storage['storage_places_id'] . "'");
			$storage_place_title = xtc_db_prepare_input(xtc_db_fetch_array($storage_place_query));
			$place = $storage_place_title['title'];
		    }else{
			$place = sprintf('<i>%s</i>',$storage['storage_place']);
		    }
		    if (((!isset($_GET['spID'])) || (@$_GET['spID'] == $storage['spit'])) && (!isset($spInfo)) && (!isset($_GET['action']) or substr($_GET['action'], 0, 3) != 'new')) {
		      $storage_extra_query = xtc_db_query("select sp.* from storage_products sp where id = '" . $storage['spit'] . "'");
		      $storage_extra = xtc_db_prepare_input(xtc_db_fetch_array($storage_extra_query));
		      $spInfo_array = xtc_array_merge($storage, $storage_extra);
		      $spInfo = new objectInfo($spInfo_array);
		      $spInfo->storage_place = $place;
		    }
			$product = $storage;
			$product['storage_place'] = $place;
			if ( (isset($spInfo) and is_object($spInfo)) && ($storage['id'] == $spInfo->id) ) {
			    $product['selected'] = true;
			    $product['link'] = xtc_href_link('storage_admin.php', 'pID=' . $spInfo->products_id . '&spID=' . $spInfo->id . '&action=edit&stID='.$stID);
			} else {
			    $product['link'] = xtc_href_link('storage_admin.php', 'spID=' . $storage['id'].'&stID='.$stID);
			}
			if ( (isset($spInfo) and is_object($spInfo)) && ($storage['id'] == $spInfo->id) ) { 
			    $product['icon'] = xtc_image(DIR_WS_IMAGES . 'icon_arrow_right.gif', ''); 
			} else {
			    $product['icon'] = '<a href="' . xtc_href_link('storage_admin.php', 'spID=' . $storage['id'].'&stID='.$stID.'&pID='.$storage['products_id']) . '">' . xtc_image(DIR_WS_IMAGES . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>'; 
			}
			$products[] = $product;
			$storage_places[] = $storage['id'];
		}
		$smarty->assign('products',$products);
		break;
}
?>
<table border="0" width="100%" cellspacing="0" cellpadding="2">
    <tr>
	<td valign="top" class="main">
	    <?php 
	    $smarty->display('storage_admin.html'); 
	    ?>
	</td>
<?php
$heading = array();
$contents = array();
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch ($action) {
	case 'delete_confirm':
		$heading[] = array('text' => sprintf('<b>%s</b>',sprintf(TEXT_DELETE_STORAGE_PLACE,$spInfo->storage_place)));
		$contents = array('form' => xtc_draw_form('storage_place', 'storage_admin.php', 'spID=' . $spInfo->id . '&stID='.$spInfo->storage_id.'&pID='.$spInfo->products_id.'&action=delete'));
		$contents[] = array('text' => TEXT_REALLY_DELETE_STORAGE_PLACE);
		$contents[] = array('text' => '<b>'.LABEL_STORAGE_PLACE.'</b> '.$spInfo->storage_place);
		$contents[] = array('text' => '<b>'.TABLE_HEADING_PRODUCT.':</b> [pID '.$spInfo->products_id.'] '.xtc_get_products_name($spInfo->products_id));
		$contents[] = array('align' => 'center', 'text' => '<br />' . xtc_image_submit('button_delete.gif', IMAGE_DELETE) . '&nbsp;<a href="' . xtc_href_link('storage_numbers.php', 'spID=' . $spInfo->id . '&stID='.$spInfo->storage_id.'&pID='.$spInfo->products_id) . '">' . xtc_image_button('button_cancel.gif', IMAGE_CANCEL) . '</a>');
		break;
	case 'edit':
		$pquery = xtc_db_query("SELECT p.*,pd.* FROM products p, products_description pd WHERE pd.products_id=p.products_id && p.products_id='".$spInfo->products_id."' && pd.language_id='".$_SESSION['languages_id']."'");
		$product = xtc_db_fetch_array($pquery);
		$pInfo = new objectInfo($product);
		

		$dquery = xtc_db_query("SELECT d.name FROM distributors d,products_distributors pd WHERE d.id=pd.distributor_id && pd.products_id='".$spInfo->products_id."'");
		$products_distributors = '';
		while($distributor = xtc_db_fetch_array($dquery)){
			$products_distributors .= $distributor['name']."<br>";
		}
		if($products_distributors == '') $products_distributors = sprintf('<i>%s</i>',TEXT_NO_DISTRIBUTOR_ALLOCATED);

		$squery = xtc_db_query("SELECT nummer FROM storage_numbers WHERE products_id='".$spInfo->products_id."' && storage_id='".$spInfo->storage_id."'");
		$storagenr = xtc_db_fetch_array($squery);
		if($storagenr['nummer']!=''){
			$storage_number = $storagenr['nummer'];
		}else{
			$storage_number = false;
		}

		$smarty->clear_all_assign();
			$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

		$smarty->assign('PRODUCTS_NAME',$pInfo->products_name);
		if( !empty($pInfo->products_image) and is_file(DIR_WS_CATALOG.'images/product_images/thumbnail_images/'.$pInfo->products_image)){
		    $smarty->assign('PRODUCTS_IMAGE',DIR_WS_CATALOG.'images/product_images/thumbnail_images/'.$pInfo->products_image);
		}
		$smarty->assign('PRODUCTS_STORAGE_NUMBER',$storage_number);
		$smarty->assign('PRODUCTS_DISTRIBUTORS',$products_distributors);
		$smarty->assign('PRODUCTS_QUANTITY',$pInfo->products_quantity);
		$smarty->assign('PRODUCTS_DESCRIPTION',substr(strip_tags($pInfo->products_description),0,120).'...');
		$main_content= $smarty->fetch(DIR_FS_ADMIN.'templates/products_short_desc.html');

		$heading[] = array('text' => sprintf('<b>%s</b>',sprintf(TEXT_EDIT_STORAGE_PLACE,$spInfo->storage_place)));
		$contents = array('form' => xtc_draw_form('storage_place', 'storage_admin.php', 'spID=' . $spInfo->id . '&stID='.$spInfo->storage_id.'&pID='.$spInfo->products_id.'&action=update'));
		$contents[] = array('text' => TEXT_INTRO_STORAGE_PLACE_EDIT);
		$contents[] = array('text' => '<b>'.TEXT_CREATED.'</b> '.xtc_date_short($spInfo->created));
		if($spInfo->changed > 0 and strpos($spInfo->changed,'0000-00')<0 ){
		    $contents[] = array('text' => '<b>'.TEXT_MODIFIED.'</b> '.xtc_date_short($spInfo->changed));
                }

		$storage = new storage($stID);
		$storage_places = $storage->get_storage_places_for_product($pID);
		$storage_places = array_merge(array(array(
		    'id'=>'','text'=>TEXT_SELECT
		)),$storage_places);
		$contents[] = array('text' => $main_content);
		$contents[] = array('text' => '<br><b>'.LABEL_STORAGE_PLACE.'</b><br>' . xtc_draw_pull_down_menu('storage_places_id',$storage_places,$spInfo->storage_places_id));
		
		$contents[] = array('align' => 'center', 'text' => '<br>' . xtc_image_submit('button_update.gif', IMAGE_UPDATE) . '&nbsp;<a href="' . xtc_href_link('storage_admin.php', 'spID=' . $spInfo->id.'&stID='.$stID) . '">' . xtc_image_button('button_cancel.gif', IMAGE_CANCEL) . '</a>');
		break;
    default:
      if (isset($spInfo) and is_object($spInfo)) {
		$product = new product($spInfo->products_id,$_SESSION['languages_id'],true);

		$dquery = xtc_db_query("SELECT d.name FROM distributors d,products_distributors pd WHERE d.id=pd.distributor_id && pd.products_id='".$spInfo->products_id."'");
		$products_distributors = '';
		while($distributor = xtc_db_fetch_array($dquery)){
			$products_distributors .= $distributor['name']."<br>";
		}
		if($products_distributors == '') $products_distributors = '<i>'.TEXT_NO_DISTRIBUTOR_ALLOCATED.'</i>';

		$squery = xtc_db_query("SELECT nummer FROM storage_numbers WHERE products_id='".$spInfo->products_id."' && storage_id='".$spInfo->storage_id."'");
		$storagenr = xtc_db_fetch_array($squery);
		if($storagenr['nummer']!=''){
			$storage_number = $storagenr['nummer'];
		}else{
			$storage_number = false;
		}

		$smarty->clear_all_assign();
		$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
		$unallocated = $product->get_unallocated_storage_products_quantity();
		if($unallocated > 0){
			$contents[] = array('align'=>'center','text'=>  yes_draw_href_button(TEXT_BUTTON_UNALLOCATED_TRANSFER, xtc_href_link('storage_admin.php',xtc_get_all_get_params(array('action','spID','products_id')).'products_id='.$spInfo->products_id.'&spID=' . $spInfo->id.'&action=allocate_untransferred'), 'width:160px;','button','lbOn ui-button ui-corner-all ui-state-default'));
		}
		$contents[] = array('align'=>'center','text'=>  yes_draw_href_button(IMAGE_VIEW_HISTORY, xtc_href_link('storage_admin.php',xtc_get_all_get_params(array('action','spID')).'spID=' . $spInfo->id.'&action=history'), 'width:160px;','button','lbOn ui-button ui-corner-all ui-state-default'));
		//$contents[] = array('align'=>'center','text'=>  yes_draw_href_button(IMAGE_EDIT, xtc_href_link('storage_admin.php','stID='.$spInfo->storage_id.'&pID='.$spInfo->products_id.'&spID=' . $spInfo->id . '&action=edit'), 'width:160px;'));
		$contents[] = array('align'=>'center','text'=>  yes_draw_href_button(IMAGE_PRODUCTS_EDIT, xtc_href_link('categories.php','pID='.$spInfo->products_id.'&action=new_product&cPath='.xtc_get_product_path($spInfo->products_id)), 'width:160px;'));
		$contents[] = array('align'=>'center','text'=>  yes_draw_href_button(IMAGE_DELETE, xtc_href_link('storage_admin.php','stID='.$spInfo->storage_id.'&pID='.$spInfo->products_id.'&spID=' . $spInfo->id . '&action=delete_confirm'), 'width:160px;'));
		$contents[] = array('align'=>'left','text'=> '<b>'.TEXT_PRODUCTS_UNALLOCATED.':</b> '.$unallocated);
		$contents[] = array('align'=>'left','text'=> '<b>'.TEXT_PRODUCTS_PHYSICAL_QUANTITY.':</b> '.$product->info['products_quantity']);
		$contents[] = array('align'=>'left','text'=> '<b>'.TEXT_PRODUCTS_STORAGE_PLACE_QUANTITY.':</b> '.$spInfo->quantity);
		
		

		$smarty->assign('PRODUCTS_NAME',$product->info['products_name']);
		if(!empty($product->info['products_image']) and is_file(DIR_WS_CATALOG.'images/product_images/thumbnail_images/'.$product->info['products_image'])){
		    $smarty->assign('PRODUCTS_IMAGE',DIR_WS_CATALOG.'images/product_images/thumbnail_images/'.$product->info['products_image']);
		}
		$smarty->assign('PRODUCTS_STORAGE_NUMBER',$storage_number);
		$smarty->assign('PRODUCTS_DISTRIBUTORS',$products_distributors);
		$smarty->assign('PRODUCTS_QUANTITY',$product->info['products_quantity']);
		$smarty->assign('PRODUCTS_DESCRIPTION',substr(strip_tags($product->info['products_description']),0,120).'...');
		$main_content= $smarty->fetch(DIR_FS_ADMIN.'templates/products_short_desc.html');
	        $heading[] = array('text' => '<table width="100%" border=0 cellpadding=0 cellspacing=0>
				<tr>
					<td class=main><b>'.sprintf(TEXT_EDIT_STORAGE_PLACE,$spInfo->storage_place).'</b></td>
					<td align="right"><a href="'.xtc_href_link('storage_admin.php', 'stID=' . $spInfo->storage_id.'&pID=' . $spInfo->products_id .'&action=addproduct').'"><image src="images/plus.gif" alt="'.TEXT_ADD_ANOTHER_STORAGE_PLACE.'"  title="'.TEXT_ADD_ANOTHER_STORAGE_PLACE.'"></a></td>
				</tr>
				</table>');
		$contents[] = array('text' => $main_content);
      }
      break;
  }

  if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
    echo '            <td width="25%" valign="top">' . "\n";

    $box = new box;
    echo $box->infoBox($heading, $contents);

    echo '            </td>' . "\n";
  }
?>
			  
		</tr>
		</table>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
