<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="/">
		<xsl:apply-templates/></xsl:template>
		<xsl:template match="summary">
		<div class="epo_summary">
		<xsl:value-of select="seller"/>
		<ul>
		<xsl:for-each select="items/item">
			<xsl:sort select="order" order="ascending"></xsl:sort>
			<xsl:choose>
				<xsl:when test="number(order) = 0">
					<li class="epo_first" />
				</xsl:when>
				<xsl:when test="number(order) > 0">
					<li class="epo_other" />
				</xsl:when>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="number(count) = 0">
					<xsl:value-of select="type" disable-output-escaping="yes"/>: <xsl:value-of select="count"/>
				</xsl:when>
				<xsl:when test="number(count) &gt; 0">
					<b>
						<xsl:value-of select="type" disable-output-escaping="yes"/>: <xsl:value-of select="count"/>
					</b>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		</ul>
		</div>
	</xsl:template>
</xsl:stylesheet>
