<?php
/* -----------------------------------------------------------------------------------------
$Id: xsell_products.php,v 1.22 2018/02/20 15:25:22 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommercebased on original files from OSCommerce CVS 2.2 2002/08/28 02:14:35 www.oscommerce.com
   (c) 2003	 nextcommerce (xsell_products.php,v 1.5 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License

   -----------------------------------------------------------------------------------------
   Third Party contribution:
   Cross-Sell (X-Sell) Admin 1				Autor: Joshua Dechant (dreamscape)

   and has little changed ( Filter categories & manufactures ) Medreces medreces@yandex.ru
   -----------------------------------------------------------------------------------------
   Also converted for XT-Commerce Witalij Olejnik(xaoc,xaoc2) xaoc@o2.pl
---------------------------------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_WS_CLASSES . 'currencies.php');
require_once(DIR_WS_CLASSES . 'product.php');
$currencies = new currencies();

//Medreces insert Filter categories & manufactures !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$manufacturers_array = array(array('id' => '', 'text' => TEXT_NONE));
$manufacturers_query = xtc_db_query("select manufacturers_id, manufacturers_name from " . TABLE_MANUFACTURERS . " order by manufacturers_name");
while ($manufacturers = xtc_db_fetch_array($manufacturers_query)) {
  $manufacturers_array[] = array('id' => $manufacturers['manufacturers_id'],
                                 'text' => $manufacturers['manufacturers_name']);
}

$categories_id = 0;
if ( isset($_REQUEST['categories_id']) ) {
  $categories_id = $_REQUEST['categories_id'];
}
$manufacturers_id = 0;
if ( isset($_REQUEST['manufacturers_id']) ) {
  $manufacturers_id = $_REQUEST['manufacturers_id'];
}
if(isset($_REQUEST['add_related_product_ID']) and xtc_not_null($_REQUEST['add_related_product_ID'])){
	$add_related_product_ID = xtc_db_input($_REQUEST['add_related_product_ID']);
}
if(isset($_REQUEST['search_string']) and xtc_not_null($_REQUEST['search_string'])){
	$search_string = $_REQUEST['search_string'];
}
$LANGUAGE_id = $_SESSION['languages_id'];
if(isset($_GET['action']) and $_GET['action'] == 'copy_process'){
    $pID = (int)xtc_db_input($_GET['products_id']);
    $target_pid = (int)xtc_db_input($_POST['copy_to']);
    if($pID < 1 or $target_pid < 1){
        $messageStack->add_session(JS_ERROR_COPY_XSELL_PID,'error');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
    }
    $tp = new product($target_pid);
    $tp->xsell_cleanup();
    $copied = $tp->xsell_copy($pID);
    $messageStack->add_session(sprintf(MSG_SUCCESS_XSELL_COPY,
        $copied, $pID, $target_pid),
        'success'
    );
    xtc_redirect(xtc_href_link(basename(__FILE__)));
}
if(isset($_GET['action']) and $_GET['action'] == 'copy'){
    $pID = (int)xtc_db_input($_GET['products_id']);
    if($pID < 1){
        die('<p>missing params</p>');
    }
    $p = new product($pID, $_SESSION['languages_id'], true);
    $xsells = $p->get_xsells();
    if(!sizeOf($xsells)){
        die('<p>'.TEXT_COPY_XSELL_ERROR.'</p>');
    }
    echo xtc_draw_form('xsell_copy',basename(__FILE__), xtc_get_all_get_params(array('action')).'action=copy_process','POST','onsubmit="return xsell_copy_form_check()"');
    printf('<p>%s</p>',TEXT_COPY_XSELL_INTRO);
    echo 'pID: '.xtc_draw_input_field('copy_to','','size="7" maxlength="7"');
    echo '<input type="submit" id="xsell_copy_to_save" value="'.TEXT_COPY_XSELL_BUTTON.'" class="ui-button ui-corner-all ui-state-default" />';
    echo '</form>';
    exit;
}
//Medreces insert Filter categories & manufactures !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//////////////////////////////////////////////////////////////////////////////////
// This bit does the 'EDIT' page (previously Add/Remove)
if( isset($_GET['action']) and $_GET['action'] == 'save') {
	$saved = 0;
	$sorted = 0;
	$reverse = 0;
	$deleted = 0;
	if(isset($_REQUEST['delete_xsell_id']) and sizeOf($_REQUEST['delete_xsell_id'])){
		foreach ($_REQUEST['delete_xsell_id'] as $xsell_id) {
		    if(isset($_REQUEST['reverse_cross_selling'][$xsell_id])){
			unset($_REQUEST['reverse_cross_selling'][$xsell_id]);
		    }
			xtc_db_query("DELETE FROM ".TABLE_PRODUCTS_XSELL." WHERE products_id='".xtc_db_input($_REQUEST['add_related_product_ID'])."' and xsell_id='".xtc_db_input($xsell_id)."'");
			$deleted++;
		}
	}
	if(isset($_REQUEST['sort_order'])){
		foreach($_REQUEST['sort_order'] as $xsell_id=>$sort_order){
			$update_reverse_cross_selling = false;
			$reverse_cross_selling_flag = 0;
	  		$check_query = xtc_db_query(sprintf(
				"SELECT sort_order,reverse_cross_selling FROM %s WHERE products_id='%s' and xsell_id='%s'",
				TABLE_PRODUCTS_XSELL,
				$add_related_product_ID,
				xtc_db_input($xsell_id)
			));
			if(xtc_db_num_rows($check_query)){
                                $reverse_cross_selling = (isset($_REQUEST['reverse_cross_selling']))?$_REQUEST['reverse_cross_selling']:[];
				$check = xtc_db_fetch_array($check_query);
				if($check['reverse_cross_selling'] == 0 and in_array($xsell_id,$reverse_cross_selling)){
				    $update_reverse_cross_selling = true;
				    $reverse_cross_selling_flag = 1;
				}elseif($check['reverse_cross_selling'] == 1 and !in_array($xsell_id,$reverse_cross_selling)){
				    $update_reverse_cross_selling = true;
				    $reverse_cross_selling_flag = 0;
				}
				if($sort_order != $check['sort_order']){
					xtc_db_query("UPDATE ".TABLE_PRODUCTS_XSELL." SET sort_order='".xtc_db_input($_REQUEST['sort_order'][$xsell_id])."' WHERE products_id='".$add_related_product_ID."' AND xsell_id='".xtc_db_input($xsell_id)."'");
					$sorted++;
				}
				if($update_reverse_cross_selling){
				    xtc_db_query("UPDATE ".TABLE_PRODUCTS_XSELL." SET reverse_cross_selling='".$reverse_cross_selling_flag."' WHERE products_id='".$add_related_product_ID."' AND xsell_id='".xtc_db_input($xsell_id)."'");
				    $reverse++;
				}
			}
		}
	}
  	if (isset($_POST['xsell_id']) and is_array($_POST['xsell_id'])){
		foreach ($_POST['xsell_id'] as $xsell_id) {
			if($xsell_id == $_POST['add_related_product_ID'])
				continue;

	  		$check_query = xtc_db_query(sprintf(
				"SELECT * FROM %s WHERE products_id='%d' and xsell_id='%d'",
				TABLE_PRODUCTS_XSELL,
				$_POST['add_related_product_ID'],
				xtc_db_input($xsell_id)
			));
			if(xtc_db_num_rows($check_query)){
				continue;
			}
                        $insert_sql_array = [
                            'products_id'=>$_POST['add_related_product_ID'],
                            'xsell_id'=>xtc_db_input($xsell_id),
                            'sort_order'=>$_POST['sort_order['.xtc_db_input($xsell_id).']'],
                            'reverse_cross_selling'=>(isset($_REQUEST['reverse_cross_selling']))?(int)$_REQUEST['reverse_cross_selling']:0,
                        ];
                        xtc_db_perform(TABLE_PRODUCTS_XSELL,$insert_sql_array);
			$saved++;
		}
	}
	$additional_get = array(0=>'add_related_product_ID='.$_POST['add_related_product_ID']);
	if ( isset($_POST['categories_id']) ) {
		$additional_get[] = 'categories_id='.$_POST['categories_id'];
	}
	if ( isset($_POST['manufacturers_id']) ) {
		$additional_get[] = 'manufacturers_id='.$_POST['manufacturers_id'];
	}
	if ( isset($_POST['search_string']) ) {
		$additional_get[] = 'search_string='.$_POST['search_string'];
	}
	$messageStack->add_session(sprintf(MSG_SUCCESS_XSELL_SAVE,$saved,$sorted,$deleted),'success');
	xtc_redirect(xtc_href_link('xsell_products.php',xtc_get_all_get_params(array('action','add_related_product_ID')).implode('&',$additional_get)));
}
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

$smarty->assign('HEADING_TITLE',HEADING_TITLE);
$smarty->assign('TEXT_FILTER',TEXT_FILTER);
$smarty->assign('TEXT_SEARCH_RESULTS',TEXT_SEARCH_RESULTS);
$smarty->assign('TEXT_FILTER_FROM_CATEGORY',TEXT_FILTER_FROM_CATEGORY);
$smarty->assign('TEXT_FILTER_FROM_MANUFACTURER',TEXT_FILTER_FROM_MANUFACTURER);
$smarty->assign('TEXT_FILTER_SEARCH_STRING',TEXT_FILTER_SEARCH_STRING);
$smarty->assign('TEXT_FILTER_SEARCH_STRING_INTRO',TEXT_FILTER_SEARCH_STRING_INTRO);
$smarty->assign('TEXT_FILTER',TEXT_FILTER);
$smarty->assign('TEXT_PRODUCT_IN_XSELL',TEXT_PRODUCT_IN_XSELL);
$smarty->assign('TEXT_SORT_ORDER',TEXT_SORT_ORDER);
$smarty->assign('FILTER_FORM',xtc_draw_form('filter_xsell_products', FILENAME_XSELL_PRODUCTS, xtc_get_all_get_params(array('page','categories_id','manufacturers_id','search_string'))));
$smarty->assign('FILTER_INPUT_MANUFACTURERS_ID',xtc_draw_pull_down_menu('manufacturers_id', $manufacturers_array, $manufacturers_id,'onchange="filter_view(this);"'));
$categories_array = \YES4Trade\Model\category::get_categories_id_text_values_by_categories_id(0);
$smarty->assign('FILTER_INPUT_CATEGORIES_ID',xtc_draw_pull_down_menu('categories_id', $categories_array, $categories_id,'onchange="filter_view(this);"'));
$smarty->assign('FILTER_INPUT_SEARCH_STRING',xtc_draw_input_field('search_string', @$_REQUEST['search_string'], 'size="35" maxlength="50"'));
$smarty->assign('FORM_END','</form>');

if(!isset($add_related_product_ID)){
	/* Multiple Language fix --- mail@michaelding.net <mailto:mail@michaelding.net> */
	$smarty->assign('view','list');
	$where = '';
	$parameters = '';
	if($categories_id){
		$where .= " p2c.categories_id ='" . $categories_id . "'";
		$parameters .= 'categories_id='.$categories_id;
	}
	if($manufacturers_id){
		if(!empty($where)){
			$parameters .= '&';
			$where .= " AND ";
		}
		$where .= " m.manufacturers_id ='" . $manufacturers_id . "'";
		$parameters .= 'manufacturers_id='.$manufacturers_id;
	}
	if(isset($search_string) and $search_string != ''){
		if($where != ''){
		    $parameters .= '&';
		    $where .= ' AND ';
		}
		$where .= " (a.products_model LIKE '%" . $search_string . "%' or a.products_ean LIKE '%".$search_string."%' or (pd.products_name LIKE '%".$search_string."%' AND pd.language_id='".$_SESSION['languages_id']."') ";
                if(((int)$search_string > 0)){
                    $where .= " or a.products_id='".((int)$search_string)."' ";
                }
		if($manufacturers_id){
		    $where .= " or m.manufacturers_name LIKE '%".$search_string."%'";
		}
		$where .= ') ';
		$parameters .= 'search_string='.urlencode($search_string);
	}
	/*
	if($categories_id){
		$query_raw = "select a.products_id from products a left join products_to_categories p2c USING(products_id),manufacturers m WHERE m.manufacturers_id=a.manufacturers_id ".$where." ORDER BY a.products_id";
	}else{
		$query_raw = "select a.products_id from products a, manufacturers m WHERE a.manufacturers_id=m.manufacturers_id ".$where." ORDER BY a.products_id";
	}*/
	$select_sql = "a.products_id";
	$from_sql = " products a ";
        if(isset($search_string) and $search_string != ''){
            $from_sql .= " LEFT JOIN products_description pd USING(products_id) ";
        }
	$where_sql = $where;
	$order_sql = " a.products_id ";
	if($categories_id){
	    $from_sql .= " left join products_to_categories p2c USING(products_id) ";
	}
	if($manufacturers_id){
	    $from_sql .= ", manufacturers m ";
	    if(!empty($where_sql))
		$where_sql .= ' and ';
	    $where_sql .= " a.manufacturers_id=m.manufacturers_id ";
	}
	$query_raw = sprintf("select %s from %s where %s group by a.products_id order by %s",
		$select_sql,
		$from_sql,
		(($where_sql != '')?$where_sql:1),
		$order_sql
	);
	$xsell_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $query_raw, $xsell_query_numrows);
	$smarty->assign('split_count',$xsell_split->display_count($xsell_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_ITEMS,xtc_get_all_get_params(array('page'))));
	$smarty->assign('split_links',$split = $xsell_split->display_links($xsell_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], xtc_get_all_get_params(array('page')).$parameters));
	$query = xtc_db_query($query_raw);
	$products = array();
	$cached_manufacturers = array(); // simple 1shot cache
	while($row = xtc_db_fetch_array($query) ){
		$product = new product($row['products_id'],$LANGUAGE_id,true);
		$manufacturers_name = '';
		if($product->info['manufacturers_id']){
			if(!isset($cached_manufacturers[$product->info['manufacturers_id']])){
				$manufacturers_query = sprintf("SELECT manufacturers_name FROM manufacturers WHERE manufacturers_id='%s'",
					$product->info['manufacturers_id']
				);
				$manufacturers_query = xtc_db_query($manufacturers_query);
				$manufacturers = xtc_db_fetch_array($manufacturers_query);
				$cached_manufacturers[$product->info['manufacturers_id']] = $manufacturers['manufacturers_name'];
				$manufacturers_name = $manufacturers['manufacturers_name'];
			}else{
				$manufacturers_name = $cached_manufacturers[$product->info['manufacturers_id']];
			}
		}
		/* now we will query the DB for existing related items */
		$related_items = array();
		$related_query_raw = sprintf(
			"select b.products_name, a.xsell_id, c.products_model from %s a,%s b,%s c WHERE b.products_id = a.xsell_id and a.products_id ='%s' and b.products_id = c.products_id and b.language_id='%s' ORDER BY sort_order",
			TABLE_PRODUCTS_XSELL,TABLE_PRODUCTS_DESCRIPTION,TABLE_PRODUCTS,
			$row['products_id'],
			$LANGUAGE_id
		);
		$related_query = xtc_db_query($related_query_raw);
		while($related = xtc_db_fetch_array($related_query)){
			$related_items[] = $related;
		}
		$products[] = array(
			'products_id'=>$row['products_id'],
			'products_name'=>$product->info['products_name'],
			'products_model'=>$product->info['products_model'],
			'manufacturers_name'=>$manufacturers_name,
			'related_items'=>$related_items,
			'edit_link'=>xtc_href_link(FILENAME_XSELL_PRODUCTS, 'add_related_product_ID=' . $row['products_id'] . '&categories_id=' . $categories_id . '&manufacturers_id=' . $manufacturers_id , 'NONSSL')
		);
	}
	$smarty->assign('products',$products);
}else{
	$smarty->assign('view','edit');
	$product = new product($add_related_product_ID,$LANGUAGE_id,true);
	if($product->info['products_image']){
		$smarty->assign('PRODUCT_IMAGE',xtc_image(DIR_WS_CATALOG_THUMBNAIL_IMAGES . $product->info['products_image'], $product->info['products_id']));
	}
	$smarty->assign('PRODUCT_NAME',$product->info['products_name']);
        
        $smarty->assign('ADDITIONAL_HEADING_TITLE',
            sprintf(HEADING_TITLE_ADDITIONAL, 
                    $product->info['products_name'], 
                    $add_related_product_ID
            )
        );
                
	$smarty->assign('PRODUCT_MODEL',$product->info['products_model']);
	$smarty->assign('PRODUCT_ID',$add_related_product_ID);
	$parameters = '';
	$where = '';
	if($categories_id){
		$where .= " and p2c.categories_id='" . $categories_id . "' ";
		$parameters .= 'categories_id='.$categories_id;
	}
	if($manufacturers_id){
		$where .= " and a.manufacturers_id='" . $manufacturers_id . "' ";
		if($parameters != '')
			$parameters .= '&';
		$parameters .= 'manufacturers_id='.$manufacturers_id;
	}
	$smarty->assign('EDIT_FORM',xtc_draw_form('edit_form', FILENAME_XSELL_PRODUCTS, 'action=save','post'));
	$smarty->assign('CATEGORIES_ID',$categories_id);
	$smarty->assign('MANUFACTURERS_ID',$manufacturers_id);

	$products_in_sell = array();
	$products = array();
	$in_xsell_query_raw = "select * from " . TABLE_PRODUCTS_XSELL . " WHERE products_id = '" . $add_related_product_ID . "' ORDER BY sort_order";
	$in_xsell_query = xtc_db_query($in_xsell_query_raw);
	$num_of_products = xtc_db_num_rows($in_xsell_query);
	$sort_order_values = array();
	for($i=1;$i<=$num_of_products;$i++){
		$sort_order_values[] = array('id'=>''.$i,'text'=>''.$i);
	}
	while($in_xsell = xtc_db_fetch_array($in_xsell_query)){
		// FEHLENDE SORT_ORDER_NR - WENN ANZAHL GELOESCHT WURDE ZB
		$sort_exists = false;
		foreach($sort_order_values as $so){
			if(!$sort_exists and $so['id'] == $in_xsell['sort_order']){
				$sort_exists = true;
			}
		}
		if(!$sort_exists)
			$sort_order_values[] = array('id'=>''.$in_xsell['sort_order'],'text'=>''.$in_xsell['sort_order']);

		$xsell_id_PR[] = $in_xsell['xsell_id'];
		$saveds = array();
		$in_xsell_data_query_raw = sprintf(
			"select a.products_id, b.products_name, a.products_model, a.manufacturers_id
				from products a, products_description b
				where b.products_id=a.products_id and b.language_id='%s' and b.products_id='%s' ORDER BY b.products_name",
			$_SESSION['languages_id'],$in_xsell['xsell_id']
		);
		$in_xsell_data_query = xtc_db_query($in_xsell_data_query_raw);
		$in_xsell_data = xtc_db_fetch_array($in_xsell_data_query);

		$manufacturers_name = '';
		if($in_xsell_data['manufacturers_id']){
			if(!isset($cached_manufacturers[$in_xsell_data['manufacturers_id']])){
				$manufacturers_query = sprintf("SELECT manufacturers_name FROM manufacturers WHERE manufacturers_id='%s'",
					$in_xsell_data['manufacturers_id']
				);
				$manufacturers_query = xtc_db_query($manufacturers_query);
				$manufacturers = xtc_db_fetch_array($manufacturers_query);
				$cached_manufacturers[$in_xsell_data['manufacturers_id']] = $manufacturers['manufacturers_name'];
				$manufacturers_name = $manufacturers['manufacturers_name'];
			}else{
				$manufacturers_name = $cached_manufacturers[$in_xsell_data['manufacturers_id']];
			}
		}

		$products_in_xsell[] = array(
			'checked'=>true,
			'input_sort_order'=>xtc_draw_pull_down_menu('sort_order['.$in_xsell['xsell_id'].']',$sort_order_values,$in_xsell['sort_order']),
			'xsell_id'=>$in_xsell['xsell_id'],
			'manufacturers_name'=>$manufacturers_name,
			'products_model'=>$in_xsell_data['products_model'],
			'products_name'=>$in_xsell_data['products_name'],
		    'reverse_cross_selling'=>$in_xsell['reverse_cross_selling'],
		);
	}
	$select_sql = "a.products_id, b.products_name, a.products_model,a.manufacturers_id";
	$from_sql = "products a, products_description b, products_to_categories p2c";
	$where_sql = sprintf("a.products_id=b.products_id and b.language_id = '%s' and a.products_id=p2c.products_id and a.products_id != '%s'",
		$_SESSION['languages_id'],$add_related_product_ID
	);
	if(isset($search_string) and $search_string != ''){
		if($where_sql != ''){
			$parameters .= '&';
			$where_sql .= " AND ";
		}
		$where_sql .= " (a.products_model LIKE '%" . $search_string . "%' or a.products_ean LIKE '%".$search_string."%' or b.products_name LIKE '%".$search_string."%'";
                if((int)$search_string > 0){
                    $where_sql .= " or a.products_id='".$search_string."' ";
                }
		$where_sql .= ")";
		$parameters .= 'search_string='.urlencode($search_string);
	}
	// SELBE KATEGORIE/HERSTELLER
	if($manufacturers_id){
	    $from_sql .= ", manufacturers m ";
	    $where_sql .= " and a.manufacturers_id=m.manufacturers_id and m.manufacturers_id='".$manufacturers_id."'";
	}
	
/*	$possible_query = sprintf("select a.products_id, b.products_name, a.products_model,a.manufacturers_id from products a, products_description b, products_to_categories p2c,manufacturers m where m.manufacturers_id=a.manufacturers_id and a.products_id=b.products_id and b.language_id = '%s' and a.products_id=p2c.products_id %s and a.products_id != '%s'",
		$_SESSION['languages_id'],
		((!empty($where))?' AND '.$where:''),
		$add_related_product_ID
	);*/
	$possible_query = sprintf("select %s from %s where %s",
		$select_sql,$from_sql,$where_sql
	);
	$possible_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $possible_query, $possible_query_numrows);
	$possible_query = xtc_db_query($possible_query);
	while($possible = xtc_db_fetch_array($possible_query)){
		if(is_countable($xsell_id_PR) and sizeOf($xsell_id_PR)){
			foreach ($xsell_id_PR as $compare_checked){
				if ($possible['products_id'] === $compare_checked) {
					continue 2;
				}
			}
		}
		$manufacturers_name = '';
		if($possible['manufacturers_id']){
			if(!isset($cached_manufacturers[$possible['manufacturers_id']])){
				$manufacturers_query = sprintf("SELECT manufacturers_name FROM manufacturers WHERE manufacturers_id='%s'",
					$possible['manufacturers_id']
				);
				$manufacturers_query = xtc_db_query($manufacturers_query);
				$manufacturers = xtc_db_fetch_array($manufacturers_query);
				$cached_manufacturers[$possible['manufacturers_id']] = $manufacturers['manufacturers_name'];
				$manufacturers_name = $manufacturers['manufacturers_name'];
			}else{
				$manufacturers_name = $cached_manufacturers[$possible['manufacturers_id']];
			}
		}
		$products[] = array(
			'xsell_id'=>$possible['products_id'],
			'products_model'=>$possible['products_model'],
			'manufacturers_name'=>$manufacturers_name,
			'products_name'=>$possible['products_name'],
		);
	}
	$smarty->assign('products_in_xsell',$products_in_xsell);
	$smarty->assign('products',$products);

	// DIE BEIDEN OBEREN QUERIES ZUSAMMENFASSEN UM EINEN SPLITPAGE
	// ZU KRIEGEN - ODER BEIDE EINZELN DARSTELLEN
	$smarty->assign('split_count',$possible_split->display_count($possible_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], SPLIT_PAGE_COUNT_TEXT,xtc_get_all_get_params(array('page'))));
	$smarty->assign('split_links',$possible_split->display_links($possible_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], xtc_get_all_get_params(array('page','categories_id','manufacturers_id')).$parameters));
}
$buttons = [];
if(isset($_GET['add_related_product_ID'])){
	$buttons[] = [
			'text'=>'Cross Sellings',
		    'link'=>xtc_href_link(basename(__FILE__)),
		    'lbOn'=>false,
		    'auth'=>true
	];
	$buttons[] = [
			'text'=>TEXT_PRODUCT.' '.IMAGE_EDIT,
		    'link'=>xtc_href_link(FILENAME_CATEGORIES,'action=new_product&pID='.$_GET['add_related_product_ID']),
		    'lbOn'=>false,
		    'auth'=>true
	];
}
$smarty->assign(array(
	'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'TEXT_SEARCH_RESULTS'=>TEXT_SEARCH_RESULTS,
    'TEXT_CROSS_SELLING'=>TEXT_CROSS_SELLING,
    'TEXT_REVERSE_CROSS_SELLING_INTRO'=>TEXT_REVERSE_CROSS_SELLING_INTRO,
    'TEXT_REVERSE_CROSS_SELLING'=>TEXT_REVERSE_CROSS_SELLING,
    'TEXT_COPY_XSELL_BUTTON'=>TEXT_COPY_XSELL_BUTTON,
    'TEXT_COPY_XSELL_BUTTON_ALT'=>TEXT_COPY_XSELL_BUTTON_ALT,
    'JS_ERROR_COPY_XSELL_PID'=>JS_ERROR_COPY_XSELL_PID
));
/*
$smarty->assign('',);
$smarty->assign('',);
$smarty->assign('',);
$smarty->assign('',);
 *
 */
$smarty->display('xsell_products.html');
include(DIR_WS_INCLUDES . 'footer.php');
include(DIR_WS_INCLUDES . 'application_bottom.php');
