<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     



   ---------------------------------------------------------------------------*/
require_once('includes/classes/class.csv.php');
require_once(DIR_FS_CATALOG.'includes/classes/yes_tags.php');
require_once(DIR_FS_CATALOG.'lang/german/admin/module_export.php');
define('TABLE_PERSONAL_OFFERS_BY','personal_offers_by_customers_status_');
$step = 1;
$target_path = \main::get_exportdata_path().'0000IMPORTYES.csv';
$basics = new basics;

require_once(DIR_WS_CLASSES.'class.products_export.php');
require_once(DIR_WS_MODULES.'export/yes2.php');
$yes2 = new yes2;
$filePath = \main::get_exportdata_path().'module_export_configs/';
if(!is_dir($filePath)){
    mkdir($filePath);
}
if(!is_writable($filePath)){
    die(json_encode(array(
		'MSG'=>$filePath . ' is not writable'
    )));
}
$ini_values = array(array('id'=>'','text'=>TEXT_SELECT),array('id'=>'__TOTAL__','text'=>TEXT_YES2_IMPORT_TOTAL));
foreach($basics->get_directory_content($filePath) as $file){
    $ini_values[] = array(
		'id'=>str_replace(array('yes2_','.ini'),'',$file),
		'text'=>str_replace(array('yes2_','.ini'),'',$file)
    );
}
$languages = xtc_get_languages();
$JAHRTAUSEND_START = substr(date('Y'),0,2);
function clean_csv_tag($str){
	if($str[0] == '"')
		$str = substr($str,1,strlen($str));
	if($str[ (strlen($str)-1) ] == '"')
		$str = substr($str,0,(strlen($str)-1));
	return str_replace('""','"',$str);
}

function display_import_field($key,$value) {
	switch($key){
		case 'products_name':
		case 'products_extratext':
		case 'products_description':
		case 'products_description_incl_characteristics':
		case 'products_short_description':
		case 'products_meta_title':
		case 'products_meta_description':
		case 'products_meta_keywords':
		case 'products_url':
		case 'ebay_title':
		case 'amazon_title':
		case 'slave_title':
		case 'products_condition':
		case 'amazon_generic_keywords1':
		case 'amazon_generic_keywords2':
		case 'amazon_generic_keywords3':
		case 'amazon_generic_keywords4':
		case 'amazon_generic_keywords5':
		case 'amazon_flatfile':
		case 'amazon_browse_node_id':
		case 'products_description_amazon':
			$value = strip_tags($value);
			if(strlen($value)>40){
				$value = substr($value,0,40).'...';
			}
			break;
	}
	return $value;
}

$no_import_config = false;
if(isset($_REQUEST['export_config_file']) and !empty($_REQUEST['export_config_file']) and $_REQUEST['export_config_file'] != '__TOTAL__'){
    $ini = $yes2->get_ini('yes2_'.basename($_REQUEST['export_config_file'].'.ini'));
}else{
    $ini = array();
}
$header = $yes2->get_header($ini);
$export_config_file = '';
if(isset($_REQUEST['export_config_file']) and !empty($_REQUEST['export_config_file']) and $_REQUEST['export_config_file'] != '__TOTAL__'){
    $ini = $yes2->get_ini('yes2_'.basename($_REQUEST['export_config_file'].'.ini'));
    $importheader = $yes2->get_heading_row($header, $ini, $languages, $no_import_config);
    $export_config_file = $_REQUEST['export_config_file'];
}else{
    $no_import_config = true;
    $importheader = $yes2->get_heading_row($header, array(), $languages, $no_import_config);
}
$Groups = xtc_get_customers_statuses();
if(isset($_GET['mode'])){
    switch($_GET['mode']){
	case 'save':
	    $CSV = new CSVfile($target_path);
	    $CSV->delimiter = "\t";
	    $CSV->open('r');
	    $row = 0;
	    while($line = $CSV->readRow()){
			if($row < 1){
				$row++;
				continue;
			}
			$pID = (int)$line[0];
			$column = 1;

			foreach($header as $group=>$fields){
				if(!$no_import_config and !isset($ini[$group])){
					continue;
				}
				$sql_update_array = array();
				if(sizeOf($fields['items'])){
					foreach($fields['items'] as $field=>$field_title){
						if(!$no_import_config and !isset($ini[$group][$field])){
							continue;
						}
						if(isset($fields['languages']) and $fields['languages'] == 1){
							foreach($languages as $lang){
								if($field != 'products_description_incl_characteristics'){
									$sql_update_array[ $lang['id'] ][$field] = $line[$column];
								}
								$column++;
							}
						}else{
							switch($field){
								// EXCLUDE
								case 'products_url':
									break;
												
							case 'size_width':
							case 'size_height':
							case 'size_depth':
							case 'packaging_costs':
							case 'products_price':
							case 'products_weight':
							case 'shipping_extra_charge':
							case 'products_weight_netto':
							case 'uvp':
							case 'products_vpe_value':
							case 'products_vpe_base_measure':
								$sql_update_array[$field] = number_format(str_replace(',','.',$line[$column]),4,'.','');
								break;
							default:
								$sql_update_array[$field] = $line[$column];
								break;
						}
						$column++;
						}
					}
				}else{
					if(!$no_import_config and !isset($ini[$group])){
						continue;
					}
					switch($group){
						case 'cs_prices':
							// Insert Group Prices.
							foreach($Groups as $_group) {
								$po_groups_id = $_group['id'];
								if($po_groups_id == 0){
									continue;
								}
								$prices = $line[$column];
								$prices = explode('::', $prices);

								\YES4Trade\Model\group_prices::delete_by_products_id($po_groups_id, $pID);
								for ($ii = 0; $ii < count($prices); $ii ++) {
									if($prices[$ii] == ''){
											continue;
									}
									$values = explode(':', $prices[$ii]);
									if(sizeOf($values) < 2){
											continue;
									}
									$create_qty = (int)$values[0];
									$create_personal_offer = ((isset($values[1]))?$values[1]:0);
									$gpi = new \YES4Trade\Model\group_prices_item(
										[
											'products_id'=>$pID, 
											'quantity'=>$create_qty,
											'personal_offer'=>(float)$create_personal_offer
										]
									);
									$gpi->create( $po_groups_id );
								}
								$column++;
								\YES4Trade\Model\group_prices::delete_cache_by_products_id($po_groups_id, $pID);
							}
							break;
						case 'pics':
							for($mi=1;$mi<=MO_PICS;$mi++){
								xtc_db_query(sprintf("UPDATE products_images SET noshop='%s' WHERE products_id='%s' and image_nr='%s'",$line[$column],$pID,$mi));
								$column++;
							}
							break;
						case 'images':
							for($mi=0;$mi<=MO_PICS;$mi++){
								//xtc_db_query(sprintf("UPDATE products_images SET noshop='%s' WHERE products_id='%s' and image_nr='%s'",$line[$column],$pID,$mi));
								//$column++;
							}
							break;
						case 'shipping_extra_charges':
							xtc_db_query(sprintf(
									"DELETE FROM products_shipping_extra_charge WHERE products_id='%s'",
									$pID
							));
							foreach(main::get_shipping_graduation_groups() as $sgg){
								$insert_sql_array = array(
									'products_id'=>$pID,
									'shipping_graduation_groups_id'=>$sgg['id'],
									'date_added'=>'now()',
									'shipping_extra_charge'=>$line[$column]
								);
								xtc_db_perform('products_shipping_extra_charge',$insert_sql_array);
								$column++;
							}
							break;
						case 'default_shipper':
							\YES4Trade\Model\shipper_profiles::allocate_to_products_id($line[$column],$pID);
							$column++;
							break;
						case 'tags':
							$tags = explode(',',$line[$column]);
							$tags_id_array = array();
							foreach($tags as $tag){
								$ytg = new yes_tags('product');
								$tags_id = $ytg->get_tags_id($tag);
								if($tags_id > 0){
									$tags_id_array[] = $tags_id;
								}
							}

							// ENTFERNTE TAGS LOESCHEN FALLS BEI KEINEM ANDEREN ARTIKEL VERWENDET
							$tq = xtc_db_query(sprintf(
								"SELECT tags_id FROM tags_products WHERE products_id='%s'",
								$pID
							));
							while($tr = xtc_db_fetch_array($tq)){
								if(!in_array($tr['tags_id'],$tags_id_array)){
								$tc_query = xtc_db_query(sprintf(
									"SELECT COUNT(products_id) as anz FROM tags_products WHERE tags_id='%s' AND products_id != '%s'",
									$tr['tags_id'],$pID
								));
								$rtc = xtc_db_fetch_array($tc_query);
								if($rtc['anz']==0){
									xtc_db_query(sprintf(
										"DELETE FROM tags WHERE tags_id='%s'",
										$tr['tags_id']
									));
								}
								}
							}

							// PID ZUWEISUNG EINMAL KOMPLETT LOESCHEN
							xtc_db_query(sprintf(
								"DELETE FROM tags_products WHERE products_id='%s'",
								$pID
							));
							foreach($tags as $tag){
								$ytg = new yes_tags('product');
								$tags_id = $ytg->get_tags_id($tag);
								if($tags_id < 1){
								$tags_id = $ytg->create_tag(yes_encode_string($tag));
								}
								$ytg->allocate($tags_id, $pID);
							}
							$column++;
							break;
						case 'meldebestand_user':
							$pmc_list = \YES4Trade\Model\products_meldebestand_customers::get_by_products_id(intval($pID));
							foreach($pmc_list as $pmc){
								\YES4Trade\Model\products_meldebestand_customers::delete($pmc->products_meldebestand_customers_id);
							}
							if(!empty($line[$column])){
								$user = explode(',',$line[$column]);
								foreach($user as $cID){
													$new = new \YES4Trade\Model\products_meldebestand_customers([
														'products_id'=>intval($pID),
														'customers_id'=>intval($cID)
													]);
													$new->create();
								}
							}
							$column++;
							break;
					}
				//$column++;
				} // end keine items eintraege


				if(!sizeOf($sql_update_array)){
					continue;
				}

				switch($group){
					case 'main':
						xtc_db_perform('products',$sql_update_array,'update',"products_id='".$pID."'");
						break;
				case 'description':
					foreach($sql_update_array as $lang_id=>$sql_array){
						xtc_db_perform('products_description',$sql_array,'update',"products_id='".$pID."' and language_id='".$lang_id."'");
					}
					break;
				case 'google_product_feed':
					xtc_db_query(sprintf(
						"DELETE FROM products_google_feed_data WHERE products_id='%s'",
						$pID
					));
					$sql_update_array['products_id'] = $pID;
					xtc_db_perform('products_google_feed_data',$sql_update_array);
					break;
				case 'google_product_feed_languages':
					xtc_db_query(sprintf(
						"DELETE FROM products_google_feed_apparel WHERE products_id='%s'",
						$pID
					));
					foreach($sql_update_array as $lang_id=>$sql_array){
					$sql_array['products_id'] = $pID;
					$sql_array['language_id'] = $lang_id;
					xtc_db_perform('products_google_feed_apparel',$sql_array);
					}
					break;
				} // end switch group
			} // end foreach header
            product::add_history_static(intval($pID), 'CSV IMPORT');
	    } // end while line
	    unlink($target_path);
		\yescache_helper::cache_bump_generation($InstanceCache, 'categories');
	    $messageStack->add_session(MSG_IMPORT_SUCCESS,'success');
	    xtc_redirect(xtc_href_link('categories.php'));
	    break;
	default:
	    if(file_exists($target_path))
		    unlink($target_path);
	    $messageStack->add_session(MSG_IMPORT_CANCELLED,'error');
	    xtc_redirect(xtc_href_link('categories.php?action=yes_import2'));
	    break;
	}
}
if (isset($_FILES['importfile'])){
	if ($_FILES["importfile"]["error"] > 0){
		$messageStack->add_session(MSG_ERROR_IMPORT_DEFECT,'error');
		xtc_redirect(xtc_href_link('categories.php?action=yes_import2'));
	}
	if(file_exists($target_path))
		unlink($target_path);
	if (move_uploaded_file($_FILES['importfile']['tmp_name'], $target_path)) {
		$step = 2;
	}else{
		$messageStack->add_session(MSG_ERROR_IMPORT_NOT_WRITABLE,'error');
		xtc_redirect(xtc_href_link('categories.php?action=yes_import2'));
	}
} 

$smarty = new yesSmarty;
yes_draw_pre_header();
yes_draw_header(TITLE);
$buttons = array();
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE_YES2_IMPORT,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'STEP'=>$step,
    'FORM_END'=>'</form>',
    'TEXT_IMPORT'=>BUTTON_IMPORT,
    'TEXT_EXPORT_CONFIG_INI_DETECTED'=>TEXT_EXPORT_CONFIG_INI_DETECTED,
    'TEXT_YES2_IMPORT_SELECT_CONFIG_FILE'=>TEXT_YES2_IMPORT_SELECT_CONFIG_FILE
));
switch($step){
	case 1:
	    $smarty->assign(array(
			'INTRO'=>TEXT_IMPORT_STEP1_INTRO,
			'FORM'=>  xtc_draw_form('import_csv_form', FILENAME_CATEGORIES, 'action=yes_import2', 'POST', 'enctype="multipart/form-data"'),
			'TEXT_IMPORT_USE_CONFIG_INI'=>TEXT_IMPORT_USE_CONFIG_INI,
			'INPUT_CONFIG_INI'=>xtc_draw_pull_down_menu('export_config_file',$ini_values,$export_config_file),
	    ));
	    break;
	case 2:
	    $CSV = new CSVfile($target_path);
	    $CSV->delimiter = "\t";
	    $CSV->open('r');
	    $row = 0;
	    $csv_data = array();
	    while($line = $CSV->readRow()){
		    if($row == 0){
				$row++;
				continue;
		    }
			/*
		    $row_cols = array();
		    foreach($line as $k=>$v){
				if(isset($importheader[$k][0])){
					// row cols hat doch gar keine funktion???
					$row_cols[] = display_import_field($importheader[$k],$v);
                }
                        
		    }*/
		    $csv_data[] = $line;
		    $row++;
	    }
	    $smarty->assign(array(
			'INTRO'=>sprintf(TEXT_IMPORT_STEP2_INTRO,sizeOf($csv_data)),
			'HINT'=>TEXT_IMPORT_STEP2_HINT,
			'IMAGE_CANCEL'=>IMAGE_CANCEL,
			'IMAGE_SAVE'=>IMAGE_SAVE,
			'SUBMIT_LINK'=>xtc_href_link(FILENAME_CATEGORIES,'action=yes_import2&mode=save'.((isset($_REQUEST['export_config_file'])) ? '&export_config_file='.basename($_REQUEST['export_config_file']) : '')),
			'importheader'=>$importheader,
			'CSV_DATA'=>$csv_data
	    ));
	    break;
}
$smarty->display('yes2_import.tpl');
require(DIR_WS_INCLUDES . 'footer.php'); 
require(DIR_WS_INCLUDES . 'application_bottom.php'); 
?>
