<?php
include('includes/application_top.php');
require_once('includes/classes/image_manipulator_GD2.php');
require_once('includes/classes/upload.php');
require_once(DIR_FS_INC.'xtc_get_manufacturers.inc.php');
require_once(DIR_FS_INC.'yes_xmlrpc.inc.php');
// BOF FUNCTIONS
function makeTree($parent, $array){
  if (!is_array($array) OR empty($array)) return FALSE;
  $output = '<ul class="directory">';

  foreach($array as $key => $value):
      if(isset($value['relation_data']['categories_description'][0])){
	$name = $value['relation_data']['categories_description'][0]['categories_name'];
      }else{
	  $name = '<i>Kein Name vergeben</i>';
      }
    if ($value['parent_id'] == $parent):
        $output .= '<li id="'.$value['categories_id'].'">';

        if ($value['parent_id'] == 0):
            $output .= $name;

            $matches = array();

            foreach($array as $subkey => $subvalue):
                if ($subvalue['parent_id'] == $value['categories_id']):
                    $matches[$subkey] = $subvalue;
                endif;
            endforeach;

            $output .= makeTree($value['categories_id'], $matches);

        else:
            $output .= $name;
            $output .= '</li>';
        endif;
    endif;

  endforeach;

  $output .= '</ul>';

  return $output;
}
// EOF FUNCTIONS

if(!main::get_admin_access('module_export')){
    die('Keine Berechtigung.');
}
yes_xmlrpc_check();
include(DIR_FS_CATALOG."xmlrpc/lib/xmlrpc.inc");
include(DIR_FS_CATALOG.'xmlrpc/yes_client/yesParser.php');

$remote_server_max_items = 100; // artikel je seite maxwert
define('TEXT_YES_XMLRPC_FORM_LEGEND','XML RPC Parameter');
define('PAGE_TITLE','YES XMLRPC Schnittstelle');
$smarty = new yesSmarty;
$smarty->assign(array(
    'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/'.$_SESSION['language'].'.conf',
    'action'=>(isset($_REQUEST['action']))?$_REQUEST['action']:''
));

$html = '';

if(isset($_REQUEST['use_token_id'])){
    $_SESSION['yes_xmlrpc_remote_token_id'] = (int)xtc_db_input($_REQUEST['use_token_id']);
}
$remote_token = array();
if(isset($_SESSION['yes_xmlrpc_remote_token_id'])){
    $query = xtc_db_query("SELECT * FROM yes_xmlrpc_remote_token WHERE yes_xmlrpc_remote_token_id='".$_SESSION['yes_xmlrpc_remote_token_id']."'");
    $remote_token = xtc_db_fetch_array($query);
}
if(isset($_REQUEST['action'])){
    switch($_REQUEST['action']){
	case 'search_mask':
	    $search = (isset($_REQUEST['search'])) ? $_REQUEST['search'] : '';
	    $search_mode = (isset($_REQUEST['search_mode'])) ? $_REQUEST['search_mode'] : '';
	    echo xtc_draw_form('search','yes_xmlrpc.php','action=search','post');
	    echo 'Suchbegriff: '.xtc_draw_input_field('search',$search);
	    echo '<br />Suchmodus: ';
	    echo xtc_draw_pull_down_menu('search_mode',array(
		array('id'=>'products_name','text'=>'Artikelname'),
		array('id'=>'products_ean','text'=>'EAN'),
		array('id'=>'products_model','text'=>'Artikelnummer'),
		array('id'=>'products_id','text'=>'pID')
	    ),$search_mode);
	    echo '<br /><input type="submit" value="'.IMAGE_SEARCH.'" /></form>';
	    exit;
	    break;
	case 'search':
	    $debug = (isset($_REQUEST['debug'])) ? 3 : 0;
	    $page = (isset($_REQUEST['page'])) ? $_REQUEST['page'] : 0;
	    $search = xtc_db_input($_REQUEST['search']);
	    switch($_REQUEST['search_mode']){
		case 'products_id':
		    $search_mode = 'products_id';
		    break;
		case 'products_model':
		    $search_mode = 'products_model';
		    break;
		case 'products_ean':
		    $search_mode = 'products_ean';
		    break;
		default:
		    $search_mode = 'products_name';
		    break;
	    }
	    $data = yes_xml_request('yes.searchProducts',array(
		'page'=>$page,
		'token'=>$remote_token['token'],
		'search_mode'=>$search_mode,
		'search'=>$search
	    ),$debug);
	    if(isset($data['error']) and $data['error'] == 1){
		$errors[] = 'Serverantwort: '.$data['error_string'];
	    }
	    if($data['error']){
		$errors[] = $data['error_string'];
	    }
	    if(sizeOf($errors)){
		foreach($errors as $k=>$err){
		    $errors[$k] = yes_encode_string($err);
		}
	    }
	    $num_current = sizeOf($data['data']['products'])+($remote_server_max_items*$page);
	    if($num_current < $data['data']['total']){
		$smarty->assign('NEXT_LINK',xtc_href_link('yes_xmlrpc.php',xtc_get_all_get_params(array('page')).'page='.($page+1)) );
	    }
	    if($page > 0){
		$smarty->assign('BACK_LINK',xtc_href_link('yes_xmlrpc.php',xtc_get_all_get_params(array('page')).'page='.($page-1) ) );
	    }
	    foreach($data['data']['products'] as $k=>$dp){
		$query = xtc_db_query(sprintf(
			"SELECT products_id FROM yes_xmlrpc_products WHERE imported='1' AND yes_xmlrpc_remote_token_id='%s' AND remote_products_id='%s'",
			$_SESSION['yes_xmlrpc_remote_token_id'],$dp['products_id']
		));
		if(xtc_db_num_rows($query)){
		    $record = xtc_db_fetch_array($query);
		    $data['data']['products'][$k]['exists'] = $record['products_id'];
		}
	    }
	    if($data['data']['total'] > $remote_server_max_items){
		$max_pages = ($data['data']['total']-($data['data']['total']%$remote_server_max_items))/$remote_server_max_items;
	    }else{
		$max_pages = 0;
	    }
	    $smarty->assign(array(
		'SEARCH'=>$search,
		'ERROR'=>implode('<br />',$errors),
		'DATA'=>$data['data']['products'],
		'NUM_TOTAL'=>$data['data']['total'],
		'NUM_CURRENT'=>$num_current,
		'NUM_START'=>$page*$remote_server_max_items,
		'PAGE'=>(int)$page,
		'MAX_PAGES'=>$max_pages,
		'SERVER_IMAGE_PATH'=>$remote_token['server_image_path'],
		'PAGE_LINK'=>xtc_href_link('yes_xmlrpc.php',  html_entity_decode(xtc_get_all_get_params(array('page'))))
	    ));
	    header('Content-Type: text/html; charset='.CHARSET);
	    $html = $smarty->fetch(DIR_FS_CATALOG.'admin/templates/yes_xmlrpc.tpl');
	    break;
	case 'allocate_collies':
	    $allocations = 0;
	    $records = array();
	    $query = xtc_db_query(sprintf(
		    "SELECT yes_xmlrpc_products_id,products_id,remote_set_id FROM yes_xmlrpc_products WHERE imported=1 AND products_id>0 AND remote_set_id != '' and yes_xmlrpc_remote_token_id='%s'",
		    $_SESSION['yes_xmlrpc_remote_token_id']
	    ));
	    while($record = xtc_db_fetch_array($query) ){
		$rset_parts = explode(':',$record['remote_set_id']);
		$record['remote_set_id'] = (int)$rset_parts[0];
		$record['quantity'] = (int)$rset_parts[1];
		$record['sort_order'] = (int)$rset_parts[2];
		$records[] = $record;
	    }
	    foreach($records as $record){
		$stk_listen_id_query = xtc_db_query(sprintf(
			"SELECT products_id FROM yes_xmlrpc_products WHERE remote_products_id='%s' and yes_xmlrpc_remote_token_id='%s'",
			$record['remote_set_id'],$_SESSION['yes_xmlrpc_remote_token_id']
		));
		if(!xtc_db_num_rows($stk_listen_id_query)){
		    $messageStack->add_session('Fehler: Die Stk-Listen Remote pID '.$record['remote_set_id'].' wurde noch nicht importiert','error');
		    continue;
		}
		$stk_listen_id_rec = xtc_db_fetch_array($stk_listen_id_query);
		$stk_listen_id = $stk_listen_id_rec['products_id'];
		xtc_db_query(sprintf(
			"DELETE FROM products_collies WHERE products_id='%s' AND collie_products_id='%s'",
			$stk_listen_id,$record['products_id']
		));
		$insert_sql_array = array(
		    'products_id'=>$stk_listen_id,
		    'collie_products_id'=>$record['products_id'],
		    'quantity'=>$record['quantity'],
		    'sort_order'=>$record['sort_order']
		);
		xtc_db_perform('products_collies',$insert_sql_array);
		xtc_db_query(sprintf(
			"UPDATE yes_xmlrpc_products SET remote_set_id='' WHERE yes_xmlrpc_products_id='%s'",
			$record['yes_xmlrpc_products_id']
		));
		$allocations++;
	    }
	    $messageStack->add_session($allocations.' St&uuml;cklistenartikel-Zuweisungen wurden erzeugt.','success');
	    xtc_redirect(xtc_href_link('yes_xmlrpc.php'));
	    break;
	case 'save_import_config':
	    if(!isset($_REQUEST['import']) or !is_array($_REQUEST['import']) or !sizeOf($_REQUEST['import'])){
		$messageStack->add_session('error','Keine Sprachpakete zugewiesen.','error');
		xtc_redirect(xtc_href_link('yes_xmlrpc.php?action=import_config'));
	    }
	    xtc_db_query(sprintf(
		    "DELETE FROM yes_xmlrpc_import_config WHERE yes_xmlrpc_remote_token_id='%s'",
		    $_SESSION['yes_xmlrpc_remote_token_id']
	    ));
	    $lang_values = array();
	    foreach($_REQUEST['import']['language'] as $remote_lang_id => $stat){
		$lang_values[] = $_REQUEST['import_language'][$remote_lang_id].':'.$remote_lang_id;
	    }
	    $man_values = array();
	    foreach($_REQUEST['import_manufacturer'] as $remote_man_id => $local_man_id){
		$man_values[] = $local_man_id.':'.$remote_man_id;
	    }
	    $ss_values = array();
	    foreach($_REQUEST['import_shipping_status'] as $remote_ss_id => $local_ss_id){
		$ss_values[] = $local_ss_id.':'.$remote_ss_id;
	    }
	    $units_values = array();
	    foreach($_REQUEST['import_units'] as $remote_units_id => $local_units_id){
		$units_values[] = $local_units_id.':'.$remote_units_id;
	    }
	    $vpe_values = array();
	    foreach($_REQUEST['import_vpe'] as $remote_vpe_id => $local_vpe_id){
		$vpe_values[] = $local_vpe_id.':'.$remote_vpe_id;
	    }
	    $insert_sql_array = array(
		'languages'=>implode(',',$lang_values),
		'manufacturers'=>implode(',',$man_values),
		'import_categories_id'=>(int)xtc_db_input($_REQUEST['import_categories_id']),
		'shipping_statuses'=>implode(',',$ss_values),
		'units'=>implode(',',$units_values),
		'products_vpe'=>implode(',',$vpe_values),
		'yes_xmlrpc_remote_token_id'=>$_SESSION['yes_xmlrpc_remote_token_id']
	    );
	    xtc_db_perform('yes_xmlrpc_import_config',$insert_sql_array);
	    $messageStack->add_session('success','Konfiguration gespeichert','success');
	    xtc_redirect(xtc_href_link('yes_xmlrpc.php'));
	    break;
	case 'remote_server_select':
	    $token = array();
	    $query = xtc_db_query("SELECT * FROM yes_xmlrpc_remote_token ORDER BY date_added");
	    while($record = xtc_db_fetch_array($query)){
		$token[] = $record;
	    }
	    $token_array = array();
	    if(isset($_SESSION['yes_xmlrpc_remote_token_id'])){
		$token_id = (int)xtc_db_input($_SESSION['yes_xmlrpc_remote_token_id']);
	    }
	    foreach($token as $tok){
		if(!isset($token_id))
		    $token_id = $tok['yes_xmlrpc_remote_token_id'];
		$token_array[] = array(
		    'id'=>$tok['yes_xmlrpc_remote_token_id'],
		    'text'=>$tok['token_alias']
		);
	    }
	    $smarty->assign(array(
		'INPUT_TOKEN'=>xtc_draw_pull_down_menu('use_token_id', $token_array,$token_id)
	    ));
	    header('Content-Type: text/html; charset='.CHARSET);
	    $smarty->display(DIR_FS_CATALOG.'admin/templates/yes_xmlrpc.tpl');
	    exit;
	    break;
	case 'import_product':
	    $config = array();
	    $errors = array();
	    $msg = '';
	    $rpID = (int)xtc_db_input($_REQUEST['id']);
	    // evtl doch schon importiert?
	    $query = xtc_db_query(sprintf(
		    "SELECT products_id FROM yes_xmlrpc_products WHERE imported='1' AND yes_xmlrpc_remote_token_id='%s' AND remote_products_id='%s'",
		    $_SESSION['yes_xmlrpc_remote_token_id'],$rpID
	    ));
	    if(xtc_db_num_rows($query)){
		$record = xtc_db_fetch_array($query);
		$errors[] = 'Lokaler Artikel '.$record['products_id'].' existiert bereits.';
	    }
	    $config_query = xtc_db_query(sprintf(
		    "SELECT * FROM yes_xmlrpc_import_config WHERE yes_xmlrpc_remote_token_id='%s'",
		    $_SESSION['yes_xmlrpc_remote_token_id']
	    ));
	    if(xtc_db_num_rows($config_query)){
		$config_array = xtc_db_fetch_array($config_query);
		$config = array();
		if($config_array['languages'] != ''){
		    $config['languages'] = array();
		    $p = explode(',',$config_array['languages']);
		    foreach($p as $v){
			$parts = explode(':',$v);
			$local = $parts[0];
			$remote = $parts[1];
			$config['languages'][$remote] = $local;
		    }
		}
		if($config_array['manufacturers'] != ''){
		    $config['manufacturers'] = array();
		    $p = explode(',',$config_array['manufacturers']);
		    foreach($p as $v){
			$parts = explode(':',$v);
			$local = $parts[0];
			$remote = $parts
				[1];
			$config['manufacturers'][$remote] = $local;
		    }
		}
		if($config_array['shipping_statuses'] != ''){
		    $config['shipping_statuses'] = array();
		    $p = explode(',',$config_array['shipping_statuses']);
		    foreach($p as $v){
			$parts = explode(':',$v);
			$local = $parts[0];
			$remote = $parts[1];
			$config['shipping_statuses'][$remote] = $local;
		    }
		}
		if($config_array['units'] != ''){
		    $config['units'] = array();
		    $p = explode(',',$config_array['units']);
		    foreach($p as $v){
			$parts = explode(':',$v);
			$local = $parts[0];
			$remote = $parts[1];
			$config['units'][$remote] = $local;
		    }
		}
		if($config_array['products_vpe'] != ''){
		    $config['vpe'] = array();
		    $p = explode(',',$config_array['products_vpe']);
		    foreach($p as $v){
			$parts = explode(':',$v);
			$local = $parts[0];
			$remote = $parts[1];
			$config['vpe'][$remote] = $local;
		    }
		}
		$config['import_categories_id'] = (int)$config_array['import_categories_id'];
	    }
	    $debug = (isset($_REQUEST['debug'])) ? 3 : 0;
	    $response = false;
	    $data = yes_xml_request('yes.getProduct',array(
		'token'=>$remote_token['token'],
		'id'=>$rpID
	    ),$debug);
	    if(isset($data['error']) and $data['error'] == 1){
		$errors[] = 'Serverantwort: '.$data['error_string'];
	    }
	    if(isset($data['data']) and sizeOf($data['data'])){
		$yesParser = new yesParser('yes.getProduct', $data['data']);
		if(sizeOf($yesParser->errors)){
		    $errors[] = $yesParser->getErrorsToString();
		}else{
		    $response = true;
		    $yci = $yesParser->getCallInstance();
		    if(isset($yci->errors) and sizeOf($yci->errors)){
			$errors[] = $yci->getErrorsToString();
		    }
		}
	    }
	    if($data['error']){
		$errors[] = $data['error_string'];
	    }
	    if(sizeOf($errors)){
		foreach($errors as $k=>$err){
		    $errors[$k] = yes_encode_string($err);
		}
	    }
	    header('Content-Type: text/html; charset='.CHARSET);
	    $new_products_id = 0;
	    if($response){
		$yci->import_config = $config;
		$new_products_id = $yci->import($remote_token['server_image_path']);
		$update_sql_array = array(
		    'products_id'=>$new_products_id,
		    'imported'=>1
		);
		xtc_db_perform('yes_xmlrpc_products',$update_sql_array,'update',"remote_products_id='".$rpID."'");
	    }
	    if($new_products_id > 0){
		$msg = $rpID.' wurde importiert als pID '.$new_products_id;
	    }else{
		$errors[] = 'pID '.$rpID.' konnte nicht importiert werden.';
	    }
		
	    die(json_encode(array(
		'ERROR'=>implode("\r\n",$errors),
		'MSG'=>$msg,
		'SUCCESS'=>(sizeOf($errors)) ? 0 : 1
	    )));
	    break;
	case 'import_config':
	    $errors = array();
	    $debug = (isset($_REQUEST['debug'])) ? 3 : 0;
	    $data = yes_xml_request('yes.getConfig',array(
		'token'=>$remote_token['token'],
		'detail'=>'lang'
	    ),$debug);
	    if(isset($data['data']) and sizeOf($data['data'])){
		$yesParser = new yesParser('yes.getConfig', $data['data']);
		if(sizeOf($yesParser->errors)){
		    $errors[] = $yesParser->getErrorsToString();
		}else{
		    $yci = $yesParser->getCallInstance();
		    if(sizeOf($yci->errors)){
			$errors[] = $yci->getErrorsToString();
		    }
		}
	    }
	    if($data['error']){
		$errors[] = $data['error_string'];
	    }
	    
	    $local_languages = array();
	    $query = xtc_db_query("SELECT languages_id,name,code FROM languages");
	    while($record = xtc_db_fetch_array($query)){
		$local_languages[] = array('id'=>$record['languages_id'],
		    'text'=>$record['name'].' ('.$record['code'].')'
		);
	    }
	    if(sizeOf($local_languages) > sizeOf($data['data']['languages'])){
		$errors[] = 'Sie haben mehr Sprachpakete installiert als der Remote Server, dass kann zu Problemen beim Import f&uuml;hren da keine Beschreibungstexte zur zus&auml;tzlichen Sprache ermittelt werden k&ouml;nnen. In dem Fall werden die Beschreibungstexte der zus&auml;tzlichen lokalen Sprachpakete mit dem ersten Remote-Sprachpaket gespeichert.';
	    }
	    
	    $no_config = false;
	    $config_languages = array();
	    $config_manufacturers = array();
	    $config_shipping_statuses = array();
	    $config_units = array();
	    $config_vpe = array();
	    $config_query = xtc_db_query(sprintf(
		    "SELECT * FROM yes_xmlrpc_import_config WHERE yes_xmlrpc_remote_token_id='%s'",
		    $_SESSION['yes_xmlrpc_remote_token_id']
	    ));
	    if(xtc_db_num_rows($config_query)){
		$config = xtc_db_fetch_array($config_query);
		if($config['languages'] != ''){
		    $config_languages_array = explode(',',$config['languages']);
		    foreach($config_languages_array as $cf){
			$parts = explode(':',$cf);
			$local = $parts[0];
			$remote = $parts[1];
			$config_languages[$remote] = $local;
		    }
		}
		
		if($config['manufacturers'] != ''){
		    $config_manufacturers_array = explode(',',$config['manufacturers']);
		    foreach($config_manufacturers_array as $cf){
			$parts = explode(':',$cf);
			$local = $parts[0];
			$remote = $parts[1];
			$config_manufacturers[$remote] = $local;
		    }
		}
		if($config['shipping_statuses'] != ''){
		    $config_shipping_statuses_array = explode(',',$config['shipping_statuses']);
		    foreach($config_shipping_statuses_array as $cf){
			$parts = explode(':',$cf);
			$local = $parts[0];
			$remote = $parts[1];
			$config_shipping_statuses[$remote] = $local;
		    }
		}
		if($config['units'] != ''){
		    $config_units_array = explode(',',$config['units']);
		    foreach($config_units_array as $cu){
			$parts = explode(':',$cu);
			$local = $parts[0];
			$remote = $parts[1];
			$config_units[$remote] = $local;
		    }
		}
		if($config['products_vpe'] != ''){
		    $config_vpe_array = explode(',',$config['products_vpe']);
		    foreach($config_vpe_array as $vpe){
			$parts = explode(':',$vpe);
			$local = $parts[0];
			$remote = $parts[1];
			$config_vpe[$remote] = $local;
		    }
		}
	    }else{
		$no_config = true;
	    }
	    $languages_data = array();
	    foreach($data['data']['languages'] as $lang){
		$default_language_id = $lang['languages_id'];
		$exists = ($no_config or isset($config_languages[ $lang['languages_id'] ])) ? true : false;
		if($exists){
		    $default_language_id = $config_languages[ $lang['languages_id'] ];
		}
		$languages_data[] = array(
		    'id'=>$lang['languages_id'],
		    'text'=>$lang['name'].' ('.$lang['code'].')',
		    'input'=>xtc_draw_pull_down_menu('import_language['.$lang['languages_id'].']',$local_languages,$default_language_id,'class="language"'),
		    'checked'=>$exists
		);
	    }
	    
	    $data = yes_xml_request('yes.getConfig',array(
		'token'=>$remote_token['token'],
		'detail'=>'manufacturer'
	    ),$debug);
	    $manufacturers_data = array();
	    $local_manufacturers = xtc_get_manufacturers();
	    foreach($data['data']['manufacturers'] as $man){
		$default_man_id = false;
		$exists = ($no_config or isset($config_manufacturers[ $man['manufacturers_id'] ])) ? true : false;
		if($exists){
		    $default_man_id = $config_manufacturers[ $man['manufacturers_id'] ];
		}
		$manufacturers_data[] = array(
		    'id'=>$man['manufacturers_id'],
		    'text'=>$man['manufacturers_name'],
		    'input'=>xtc_draw_pull_down_menu('import_manufacturer['.$man['manufacturers_id'].']',$local_manufacturers,$default_man_id,'class="manufacturer"'),
		);
	    }
	    if($data['error']){
		$errors[] = $data['error_string'];
	    }
	    
	    
	    $data = yes_xml_request('yes.getConfig',array(
		'token'=>$remote_token['token'],
		'detail'=>'shipping_status'
	    ),$debug);
	    $shipping_statuses_data = array();
	    $local_shipping_statuses = xtc_get_shipping_status();
	    foreach($data['data']['shipping_status'] as $ss){
		$default_ss_id = false;
		$exists = ($no_config or isset($config_shipping_statuses[ $ss['shipping_status_id'] ])) ? true : false;
		if($exists){
		    $default_ss_id = $config_shipping_statuses[ $ss['shipping_status_id'] ];
		}
		$shipping_statuses_data[] = array(
		    'id'=>$ss['shipping_status_id'],
		    'text'=>$ss['shipping_status_name'],
		    'input'=>xtc_draw_pull_down_menu('import_shipping_status['.$ss['shipping_status_id'].']',$local_shipping_statuses,$default_ss_id,'class="shipping_status"')
		);
	    }
	    if($data['error']){
		$errors[] = $data['error_string'];
	    }

	    
	    $data = yes_xml_request('yes.getConfig',array(
		'token'=>$remote_token['token'],
		'detail'=>'units'
	    ),$debug);
	    $units_data = array();
	    $local_units = array();
	    $query = xtc_db_query("SELECT * FROM units");
	    while($record = xtc_db_fetch_array($query)){
		$local_units[] = array(
		    'id'=>$record['units_id'],
		    'text'=>$record['units_title']
		);
	    }
	    foreach($data['data']['units'] as $unit){
		$default_units_id = false;
		$exists = ($no_config or isset($config_units[ $unit['units_id'] ])) ? true : false;
		if($exists){
		    $default_units_id = $config_units[ $unit['units_id'] ];
		}
		$units_data[] = array(
		    'id'=>$unit['units_id'],
		    'text'=>$unit['units_title'],
		    'input'=>xtc_draw_pull_down_menu('import_units['.$unit['units_id'].']',$local_units,$default_units_id,'class="units"')
		);
	    }
	    if($data['error']){
		$errors[] = $data['error_string'];
	    }
	    
	    
	    $data = yes_xml_request('yes.getConfig',array(
		'token'=>$remote_token['token'],
		'detail'=>'products_vpe'
	    ),$debug);
	    $vpe_data = array();
	    $local_vpe = array();
	    $query = xtc_db_query(sprintf(
		    "SELECT * FROM products_vpe WHERE language_id='%s'",
		    $_SESSION['languages_id']
	    ));
	    while($record = xtc_db_fetch_array($query)){
		$local_vpe[] = array(
		    'id'=>$record['products_vpe_id'],
		    'text'=>$record['products_vpe_name']
		);
	    }
	    foreach($data['data']['products_vpe'] as $vpe){
		$default_vpe_id = false;
		$exists = ($no_config or isset($config_vpe[ $vpe['products_vpe_id'] ])) ? true : false;
		if($exists){
		    $default_vpe_id = $config_vpe[ $vpe['products_vpe_id'] ];
		}
		$vpe_data[] = array(
		    'id'=>$vpe['products_vpe_id'],
		    'text'=>$vpe['products_vpe_name'],
		    'input'=>xtc_draw_pull_down_menu('import_vpe['.$vpe['products_vpe_id'].']',$local_vpe,$default_vpe_id,'class="vpe"')
		);
	    }
	    if($data['error']){
		$errors[] = $data['error_string'];
	    }

	    if(sizeOf($errors)){
		foreach($errors as $k=>$err){
		    $errors[$k] = yes_encode_string($err);
		}
		$smarty->assign('ERROR',implode('<br />',$errors));
	    }
	    
	    $default_import_categories_id = (isset($config['import_categories_id']) and $config['import_categories_id'] != '') ? $config['import_categories_id'] : 0;
            $categories_array = \YES4Trade\Model\category::get_categories_id_text_values_by_categories_id(0);
	    $smarty->assign(array(
		'DATA'=>$languages_data,
		'MAN_DATA'=>$manufacturers_data,
		'SHIP_DATA'=>$shipping_statuses_data,
		'UNITS_DATA'=>$units_data,
		'VPE_DATA'=>$vpe_data,
		'INPUT_SHOPCATEGORIES'=>  xtc_draw_pull_down_menu('import_categories_id', $categories_array,$default_import_categories_id)
	    ));
	    $html = $smarty->fetch(DIR_FS_CATALOG.'admin/templates/yes_xmlrpc.tpl');
	    break;
	case 'import':
	    $errors = array();
	    $import_array = array();
	    $query = xtc_db_query(sprintf(
		    "SELECT remote_products_id FROM yes_xmlrpc_products WHERE imported='0' AND yes_xmlrpc_remote_token_id='%s'",
		    $_SESSION['yes_xmlrpc_remote_token_id']
	    ));
	    while($record = xtc_db_fetch_array($query)){
		$import_array[] = $record['remote_products_id'];
	    }
	    if(!sizeOf($import_array)){
		$errors[] = 'Keine Artikel zum Importieren verf&uuml;gbar.';
	    }
	    if(sizeOf($errors)){
		$smarty->assign('ERROR',implode('<br />',$errors));
	    }
	    $smarty->assign('DATA',$import_array);
	    $html = $smarty->fetch(DIR_FS_CATALOG.'admin/templates/yes_xmlrpc.tpl');
	    break;
	case 'import_products':
	    $errors = array();
	    $import = array();
	    if(!isset($_REQUEST['id']) or !sizeOf($_REQUEST['id'])){
		$smarty->assign('ERROR','Keine Datens&auml;tze zum Importieren');
	    }else{
		$id_array = $_REQUEST['id'];
		$unique_collies = array();
		if(isset($_REQUEST['collies']) and is_array($_REQUEST['collies']) and sizeOf($_REQUEST['collies'])){
		    foreach($_REQUEST['collies'] as $products_id=>$collies){
			if(!in_array($products_id,$id_array)){
			    continue; // nicht fuer import uebergeben (hidden fields werden immer uebergeben)
			}
			foreach($collies as $collie){
			    $cparts = explode(':',$collie);
			    $collie_id = (int)$cparts[0];
			    if(isset($unique_collies[$collie_id])){
				continue;
			    }
			    $unique_collies[$collie_id] = array(
				'products_id'=>$products_id,
				'quantity'=>$cparts[1],
				'sort_order'=>$cparts[2]
			    );
			    $id_array[] = $collie_id;
			}
		    }
		}
		foreach($id_array as $products_id){
		    $query = xtc_db_query(sprintf(
			"SELECT products_id,imported FROM yes_xmlrpc_products WHERE products_id='%s' AND yes_xmlrpc_remote_token_id='%s'",
			$products_id,$_SESSION['yes_xmlrpc_remote_token_id']
		    ));
		    if(xtc_db_num_rows($query)){
			$record = xtc_db_fetch_array($query);
			if($record['imported'] == 1){
			    $errors[] = sprintf('Die remote products_id %s existiert bereits lokal als pID %s',
				    $products_id,$record['products_id']
			    );
			}else{
			    $import[] = $products_id;
			}
		    }else{
			$rs_data = array();
			if(isset($unique_collies[$products_id])){
			    $rs_data = $unique_collies[$products_id]['products_id'].':'.$unique_collies[$products_id]['quantity'].':'.$unique_collies[$products_id]['sort_order'];
			}
			$insert_sql_array = array(
			    'remote_products_id'=>$products_id,
			    'yes_xmlrpc_remote_token_id'=>$_SESSION['yes_xmlrpc_remote_token_id'],
			    'imported'=>'0',
			    'remote_set_id'=>$rs_data,
			    'date_added'=>'now()'
			);
			xtc_db_perform('yes_xmlrpc_products',$insert_sql_array);
			$import[] = $products_id;
		    }
		}
		if(!sizeOf($import)){
		    $errors[] = 'Es k&ouml;nnen keine Artikel importiert werden.';
		}
		if(sizeOf($errors)){
		    $smarty->assign('ERROR',implode('<br />',$errors));
		}else{
		    xtc_redirect(xtc_href_link('yes_xmlrpc.php','action=import'));
		}
	    }
	    
	    $html = $smarty->fetch(DIR_FS_CATALOG.'admin/templates/yes_xmlrpc.tpl');
	    break;
	case 'import_category':
	    $errors = array();
	    $debug = (isset($_REQUEST['debug'])) ? 3 : 0;
	    $page = (isset($_REQUEST['page'])) ? $_REQUEST['page'] : 0;
	    $data = yes_xml_request('yes.getProductsInCategory',array(
		'token'=>$remote_token['token'],
		'id'=>$_REQUEST['id'],
		'page'=>$page
	    ),$debug);
	    if(isset($data['data']) and sizeOf($data['data'])){
		$yesParser = new yesParser('yes.getProductsInCategory', $data['data']);
		if(sizeOf($yesParser->errors)){
		    $errors[] = $yesParser->getErrorsToString();
		}else{
		    $yci = $yesParser->getCallInstance();
		    if(sizeOf($yci->errors)){
			$errors[] = $yci->getErrorsToString();
		    }
		}
	    }
	    if($data['error']){
		$errors[] = $data['error_string'];
	    }
	    if(sizeOf($errors)){
		foreach($errors as $k=>$err){
		    $errors[$k] = yes_encode_string($err);
		}
		$smarty->assign('ERROR',implode('<br />',$errors));
	    }
	    $num_current = sizeOf($data['data']['products'])+($remote_server_max_items*$page);
	    if($num_current < $data['data']['total']){
		$smarty->assign('NEXT_LINK',xtc_href_link('yes_xmlrpc.php',xtc_get_all_get_params(array('page')).'page='.($page+1)) );
	    }
	    if($page > 0){
		$smarty->assign('BACK_LINK',xtc_href_link('yes_xmlrpc.php',xtc_get_all_get_params(array('page')).'page='.($page-1) ) );
	    }
	    foreach($data['data']['products'] as $k=>$dp){
		$query = xtc_db_query(sprintf(
			"SELECT products_id FROM yes_xmlrpc_products WHERE imported='1' AND yes_xmlrpc_remote_token_id='%s' AND remote_products_id='%s'",
			$_SESSION['yes_xmlrpc_remote_token_id'],$dp['products_id']
		));
		if(xtc_db_num_rows($query)){
		    $record = xtc_db_fetch_array($query);
		    $data['data']['products'][$k]['exists'] = $record['products_id'];
		}
	    }
	    if($data['data']['total'] > $remote_server_max_items){
		$max_pages = ($data['data']['total']-($data['data']['total']%$remote_server_max_items))/$remote_server_max_items;
	    }else{
		$max_pages = 0;
	    }
	    $smarty->assign(array(
		'DATA'=>$data['data']['products'],
		'NUM_TOTAL'=>$data['data']['total'],
		'NUM_CURRENT'=>$num_current,
		'NUM_START'=>$page*$remote_server_max_items,
		'PAGE'=>(int)$page,
		'MAX_PAGES'=>$max_pages,
		'SERVER_IMAGE_PATH'=>$remote_token['server_image_path'],
		'CATEGORY'=>$data['data']['category_info']['categories_name'],
		'PAGE_LINK'=>xtc_href_link('yes_xmlrpc.php',  html_entity_decode(xtc_get_all_get_params(array('page'))))
	    ));
	    $html = $smarty->fetch(DIR_FS_CATALOG.'admin/templates/yes_xmlrpc.tpl');
	    break;
	case 'get_categories':
	    $errors = array();
	    $debug = (isset($_REQUEST['debug'])) ? 3 : 0;
	    $data = yes_xml_request('yes.getCategories',array(
		'token'=>$remote_token['token']
	    ),$debug);
	    if(isset($data['data']) and sizeOf($data['data'])){
		$yesParser = new yesParser('yes.getCategories', $data['data']);
		if(sizeOf($yesParser->errors)){
		    $errors[] = $yesParser->getErrorsToString();
		}else{
		    $yci = $yesParser->getCallInstance();
		    if(sizeOf($yci->errors)){
			$errors[] = $yci->getErrorsToString();
		    }
		}
	    }
	    if($data['error']){
		$errors[] = $data['error_string'];
	    }
	    if(sizeOf($errors)){
		foreach($errors as $k=>$err){
		    $errors[$k] = yes_encode_string($err);
		}
	    }
	    $tree = makeTree(0,$data['data']['categories']);
	    $smarty->assign(array(
		'SUCCESS'=>(sizeOf($errors)) ? false : true,
		'ERROR'=>implode('<br />',$errors),
		'TREE'=>$tree,
		'REMOTE_SERVER'=>$remote_token['server']
	    ));
	    $html = $smarty->fetch(DIR_FS_CATALOG.'admin/templates/yes_xmlrpc.tpl');
	    break;
	case 'get_remote_token_json_data':
	    $query = xtc_db_query("SELECT * FROM yes_xmlrpc_remote_token WHERE yes_xmlrpc_remote_token_id='".(int)xtc_db_input($_REQUEST['id'])."'");
	    $record = xtc_db_fetch_array($query);
	    foreach($record as $k=>$rec){
		$record[ $k ] = yes_encode_string($rec);
	    }
	    die(json_encode($record));
	    break;
	case 'tkn_delete':
	    xtc_db_query("DELETE FROM yes_xmlrpc_remote_token WHERE yes_xmlrpc_remote_token_id='".(int)xtc_db_input($_REQUEST['id'])."'");
	    xtc_redirect(xtc_href_link('yes_xmlrpc.php'));
	    break;
	case 'add':
	    $insert_sql_array = array(
		'server' => $_REQUEST['server'],
		'token_alias' => $_REQUEST['token_alias'],
		'server_path' => $_REQUEST['server_path'], 
		'server_image_path'=> $_REQUEST['server_image_path'],
		'token'=>$_REQUEST['token']
	    );
	    if(isset($_REQUEST['yes_xmlrpc_remote_token_id']) and $_REQUEST['yes_xmlrpc_remote_token_id'] > 0){
		$update_id = (int)xtc_db_input($_REQUEST['yes_xmlrpc_remote_token_id']);
		xtc_db_perform('yes_xmlrpc_remote_token',$insert_sql_array,'update',"yes_xmlrpc_remote_token_id='".$update_id."'");
	    }else{
		$insert_sql_array['date_added'] = 'now()';
		xtc_db_perform('yes_xmlrpc_remote_token',$insert_sql_array);
	    }
	    xtc_redirect(xtc_href_link('yes_xmlrpc.php'));
	    exit;
	    break;
	case 'check':
	    $errors = array();
	    if(isset($_REQUEST['detail'])){
		$detail = $_REQUEST['detail'];
		$data = yes_xml_request('yes.getConfig',array(
		    'token'=>$remote_token['token'],
		    'detail'=>$detail
		));
		if(isset($data['data']) and sizeOf($data['data'])){
		    $yesParser = new yesParser('yes.getConfig', $data['data']);
		    if(sizeOf($yesParser->errors)){
			$errors[] = $yesParser->getErrorsToString();
		    }else{
			$yci = $yesParser->getCallInstance();
			if(sizeOf($yci->errors)){
			    $errors[] = $yci->getErrorsToString();
			}
			if(!$yci->compare_with_local($detail)){
			    if(sizeOf($yci->errors)){
				foreach($yci->errors as $err){
				    $errors[] = $err;
				}
			    }
			}
		    }
		}
		foreach($errors as $k=>$err){
		    $errors[$k] = yes_encode_string($err);
		}
		die(json_encode(array(
		    'SUCCESS'=>(sizeOf($errors)) ? false : true,
		    'ERRORS'=>$errors
		)));
	    }else{
		$smarty->display(DIR_FS_CATALOG.'admin/templates/yes_xmlrpc.tpl');
	    }
	    exit;
	    break;
	case 'remote_server':
	    $token = array();
	    $query = xtc_db_query("SELECT * FROM yes_xmlrpc_remote_token ORDER BY date_added");
	    while($record = xtc_db_fetch_array($query)){
		$token[] = $record;
	    }
	    $smarty->assign(array(
		    'NUM'=>sizeOf($token),
		'token'=>$token,
		'SESSION_TOKEN'=>(isset($_SESSION['yes_xmlrpc_remote_token_id']))?$_SESSION['yes_xmlrpc_remote_token_id']:0
	    ));
	    $html = $smarty->fetch(DIR_FS_CATALOG.'admin/templates/yes_xmlrpc.tpl');
	    break;
    }
}
?>
<html>
    <head>
	<title><?php echo PAGE_TITLE; ?></title>
	<link rel="stylesheet" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.11.1/themes/redmond/jquery-ui.css" />
	<link rel="stylesheet" href="css/yes_xmlrpc.css" />
	<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
	<script src="//ajax.googleapis.com/ajax/libs/jqueryui/1.11.1/jquery-ui.min.js"></script>
    </head>
    <body>
<?php
if(isset($messageStack->messages) and sizeOf($messageStack->messages)){
    foreach($messageStack->messages as $msg){
	echo '<div class="message_stack_'.$msg['class'].'">'.strip_tags($msg['text']).'</div>';
    }
}
?>

	<div style="display: none;" id="dialog"></div>
	<div style="display: none;" id="dialog_preloading"><div align="center"><img src="admin/images/loading.gif" height="40" width="40" border="0"></div></div>
	<div class="topmenu ui-widget">
	    <div class="menus">
		<a class="ui-state-focus ui-corner-all" href="start.php">Zur&uuml;ck zu YES4Trade</a>
		<a class="ui-state-default ui-corner-all" href="yes_xmlrpc.php">&Uuml;bersicht</a>
		<a class="ui-state-default ui-corner-all" href="yes_xmlrpc.php?action=remote_server">Remote Serververwaltung</a>
		<a href="javascript:;" class="ui-state-default ui-corner-all remote_server_select">Remote Serverauswahl</a>
	    </div>
		    <?php if(isset($_SESSION['yes_xmlrpc_remote_token_id'])){ ?>
	    <div class="status ui-state-highlight ui-corner-all">
		    <b>Remote Server:</b> <?php echo $remote_token['token_alias']; ?>
		    <?php }else{ ?>
	    <div class="status ui-state-error ui-corner-all">
		    <i>Kein Server ausgew&auml;hlt</i>
		    <?php } ?>
	    </div>
	    
	</div>
	
	<h1><?php echo PAGE_TITLE; ?></h1>

	<div class="ui-widget-content contentarea">
	    
<?php	
if(isset($_SESSION['yes_xmlrpc_remote_token_id'])){
?>    
	<a class="ui-state-default ui-corner-all" href="yes_xmlrpc.php?action=import_config">Import Konfiguration</a>
	<!--<a href="javascript:;" class="compare_check ui-state-default ui-corner-all">Kompatibilit&auml;t pr&uuml;fen</a>//-->
	<a href="javascript:;" class="search ui-state-default ui-corner-all">Artikelsuche / Import Remoteserver</a>
	<a href="yes_xmlrpc.php?action=get_categories" class="ui-state-default ui-corner-all">Shopkategorien / Import Remote Server</a>
	<br /><br />
<?php
    if(!isset($_REQUEST['action'])){
	echo '<h3>&Uuml;bersicht</h3>';
	$query = xtc_db_query(sprintf(
		"SELECT COUNT(remote_products_id) as anz,imported FROM yes_xmlrpc_products WHERE yes_xmlrpc_remote_token_id='%s' GROUP BY imported",
		$_SESSION['yes_xmlrpc_remote_token_id']
	));
	$num_imported = 0;
	$num_not_imported = 0;
	while($record = xtc_db_fetch_array($query)){
	    switch($record['imported']){
		case 1:
		    $num_imported+=$record['anz'];
		    break;
		case 0:
		    $num_not_imported+=$record['anz'];
		    break;
	    }
	}
	printf('<p>Es wurden f&uuml;r den gew&auml;hlten Remote Server bereits %s Artikel importiert.</p>',$num_imported);
	if($num_not_imported){
	    printf('<br />Es befinden sich f&uuml;r den gew&auml;hlten Remote Server noch %s Artikel im <a href="yes_xmlrpc.php?action=import" class="ui-state-error ui-corner-all">Importvorgang</a>.',$num_not_imported);
	}else{
	    $query = xtc_db_query(
		    "SELECT COUNT(yes_xmlrpc_products_id) as anz FROM yes_xmlrpc_products WHERE imported=1 AND products_id>0 AND remote_set_id != ''"
	    );
	    $record = xtc_db_fetch_array($query);
	    if($record['anz'] > 0){
		printf('<div style="padding: 10px;" class="ui-state-error ui-corner-all">Es wurden Remote St&uuml;cklistenartikel inkl. der Kollis importiert. Diese %s Kollis m&uuml;ssen Sie nun <a href="yes_xmlrpc.php?action=allocate_collies" class="ui-state-error ui-corner-all">zuweisen</a></div>',$record['anz']);
		
	    }
	}
    }
    
}else{
    if(!isset($_REQUEST['action'])){
	echo '<h4>Kein Remote Server gew&auml;hlt</h4>';
	echo '<a href="javascript:;" class="remote_server_select ui-state-default ui-corner-all">Remote Serverauswahl</a>';
    }
}
echo $html;
?>
	
	</div>
	<script type="text/javascript">
$(function() {
    $('form#callform fieldset input#additional_param_input, form#callform fieldset label#additional_param').hide();
    $('select#call').change(function(){
	switch($(this).val()){
	    case 'yes.getProduct':
	    case 'yes.getProductQuantity':
		$('form#callform fieldset input#additional_param_input').prop('name','products_id').val('34392');
		$('form#callform fieldset label#additional_param').html('pID');
		$('form#callform fieldset input#additional_param_input, form#callform fieldset label#additional_param').show();
		break;
	    case 'yes.getConfig':
		$('form#callform fieldset input#additional_param_input').prop('name','detail').val('lang');
		$('form#callform fieldset label#additional_param').html('Detail (lang, manufacturer,shipping_status)');
		$('form#callform fieldset input#additional_param_input, form#callform fieldset label#additional_param').show();
		break;
	}
    });
    $('a.compare_check').click(function(){
	$('#dialog_preloading').dialog({
	    title: $(this).html(),
	    modal: true,
	    width: 800
	}).load('yes_xmlrpc.php?action=check');
    });
    $('a.search').click(function(){
	$('#dialog_preloading').dialog({
	    title: $(this).html(),
	    modal: true,
	    width: 800
	}).load('yes_xmlrpc.php?action=search_mask<?php 
	    echo (isset($_REQUEST['search'])) ? '&search='.$_REQUEST['search'] : ''; 
	    echo (isset($_REQUEST['search_mode'])) ? '&search_mode='.$_REQUEST['search_mode'] : ''; 
	?>');
    });
    $('a.add_remote_token').click(function(){
	$(this).hide();
	$('form#remote_server_form').show();
	$('#remote_token_dialog').dialog({
	    width: 900,
	    title: 'Neuer Remote Server',
	    modal: true,
	    close: function(){
		$('a.add_remote_token').show();
	    }
	});
    });
    $('a.tkn_delete').each(function(){
	$(this).click(function(){
	    yes = confirm('Remote Token wirklich entfernen?');
	    if(yes){
		window.location.href='?action=tkn_delete&id='+$(this).attr('id');
	    }
	});
    });
    $('a.tkn_edit').each(function(){
	$(this).click(function(){
	    $('a.add_remote_token').hide();
	    $('form#remote_server_form input[name="yes_xmlrpc_remote_token_id"]').val($(this).attr('id'));
	    $.ajax({
		url: 'yes_xmlrpc.php?action=get_remote_token_json_data&id='+$(this).attr('id'),
		dataType: 'json',
		success: function(json){
		    $('form#remote_server_form input[name="token"]').val(json.token);
		    $('form#remote_server_form input[name="token_alias"]').val(json.token_alias);
		    $('form#remote_server_form input[name="server"]').val(json.server);
		    $('form#remote_server_form input[name="server_path"]').val(json.server_path);
		    $('form#remote_server_form input[name="server_image_path"]').val(json.server_image_path);
		    $('form#remote_server_form').show();
		    $('#remote_token_dialog').dialog({
			width: 900,
			title: 'Remote Server bearbeiten',
			modal: true,
			close: function(){
			    $('a.add_remote_token').show();
			}
		    });
		}
	    });
	    
	});
    });
    $('a.remote_server_select').click(function(){
	$('#dialog').dialog({
	    modal: true,
	    title: 'Remote Server Auswahl'
	}).load('yes_xmlrpc.php?action=remote_server_select');
    });
    
    
});
	</script>
    </body>
</html>