<?php
/* callback/paypal_ppp/paypal_ppp.php
.---------------------------------------------------------------------------.
|    Software: PayPal-PPP                                                   |
|     Version: 0.2beta                                                      |
|        Date: 2016-02-09                                                   |
| Description: handle paypal-plus webhooks                                  |
|     Contact: info@andreas-guder.de                                        |
| ------------------------------------------------------------------------- |
|      Author: Andreas Guder                                                |
|     Contact: info@andreas-guder.de                                        |
| Copyright (c) 2015, Andreas Guder.                                        |
| ------------------------------------------------------------------------- |
|     License:  GNU Public License V2.0                                     |
|               http://www.gnu.org/licenses/gpl-2.0.html                    |
'--------------------------------------------------------------------------�'
*/
$postdata = file_get_contents("php://input");
if (empty($postdata))
{
  header("HTTP/1.0 400 Bad Request");
  echo 'No Content';
  exit;
}
$body = json_decode($postdata);
if (!is_object($body))
{
  header("HTTP/1.0 500 Internal Server Error");
  echo 'JSON-Object Required';
  exit;
}

if ($body->resource_type == 'sale')
{
    chdir('../../');
    require 'includes/application_top_callback.php';
  if (empty($body->resource->parent_payment))
  {
    header("HTTP/1.0 510 IDs required");
    header("Content-Length: 0");
    header("Connection: Close");
    exit;
  }
  
  $send_error = true;
  $paypal_hint= '';
  switch($body->event_type)
  {
    case 'PAYMENT.SALE.COMPLETED':
      if (!empty($body->resource->id))
      {
        $query_where = " AND `ppp_sale_id`='".xtc_db_input($body->resource->id)."'";
        $send_error = false;
      }
      break;
    case 'PAYMENT.SALE.PENDING':
      $query_where = '';
      $send_error = false;
      if (!empty($body->resource->reason_code))
        $paypal_hint = $body->resource->reason_code;
      break;
    case 'PAYMENT.SALE.REFUNDED':
      if (!empty($body->resource->sale_id))
      {
        $query_where = " AND `ppp_sale_id`='".xtc_db_input($body->resource->sale_id)."'";
        $send_error = false;
      }
      break;
    case 'PAYMENT.SALE.REVERSED':
      $query_where = '';
      $send_error = false;
      break;
  }
  if ($send_error)
  {
    header("HTTP/1.0 510 More IDs required");
    header("Content-Length: 0");
    header("Connection: Close");
    exit;
  }
  
  // try to find order_id in database
  $q = "SELECT `id`,`orders_id` FROM `".TABLE_PAYPAL_PPP."` WHERE `ppp_payment_id`='".xtc_db_input($body->resource->parent_payment)."'".$query_where;
  $result = xtc_db_query($q);
  $response = xtc_db_fetch_array($result);
  xtc_db_free_result($result);
  
  if (empty($response))
  {
    header("HTTP/1.0 404 Not Found");
    header("Content-Length: 0");
    header("Connection: Close");
    exit;
  }
  $oid = $response['orders_id'];
  
  $sql_data = array(
    'orders_id'     => $response['orders_id'],
    'paypal_ppp_id' => $response['id'],
    'amount'        => $body->resource->amount->total,
    'summary'       => $body->summary,
    'pending_reason'=> $paypal_hint,
    'status'        => $body->resource->state
  );
  $update_order_status = false;
  switch($body->event_type)
  {
    case 'PAYMENT.SALE.COMPLETED':
      if (MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_COMPLETED_USE == 'True')
      {
        if ($body->resource->state == 'pending')
          $set_order_status = MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_PENDING;
        else
          $set_order_status = MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_COMPLETED;
        $update_order_status = true;
      }
      break;
    case 'PAYMENT.SALE.PENDING':
      if (MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_PENDING_USE == 'True')
      {
        $set_order_status = MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_PENDING;
        $update_order_status = true;
      }
      break;
    case 'PAYMENT.SALE.REFUNDED':
      if (MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_REFUNDET_USE == 'True')
      {
        $set_order_status = MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_REFUNDET;
        $update_order_status = true;
      }
      break;
    case 'PAYMENT.SALE.REVERSED':
      if (MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_REVERSED_USE == 'True')
      {
        $set_order_status = MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_REVERSED;
        $update_order_status = true;
      }
      break;
    default:
      header("HTTP/1.0 501 Not Implemented");
      header("Content-Length: 0");
      header("Connection: Close");
      exit;
      break;
  }
  xtc_db_perform(TABLE_PAYPAL_PPP_STATUS_HISTORY, $sql_data);
  if ($update_order_status)
  {
    $sql_order = array(
      'orders_status' => $set_order_status,
      'last_modified' => 'now()'
    );
    $sql_order_status = array(
      'orders_id'         => $oid,
      'orders_status_id'  => $set_order_status,
      'date_added'        => 'now()',
      'customer_notified' => 0
    );
    /* BOF FIX check if column exists */
    $query_result = xtc_db_query("SHOW COLUMNS FROM `" . TABLE_ORDERS_STATUS_HISTORY . "`");
    $db_table_rows = array();
    while ($row = xtc_db_fetch_array($query_result))
      $db_table_rows[] = $row['Field']; 
    if (in_array('comments_sent', $db_table_rows))
      $sql_order_status['comments_sent'] = 0;
    /* EOF FIX check if column exists */
    xtc_db_perform(TABLE_ORDERS, $sql_order, 'update', "`orders_id`=".$oid);
    xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_order_status);
  }
  header("HTTP/1.0 200 OK");
  header("Content-Length: 0");
  header("Connection: Close");
}
else
{
  header("HTTP/1.0 500 Internal Server Error");
  header("Content-Length: 0");
  header("Connection: Close");
  exit;
}
?>