<?php
/**
 * XTC - EBAY API
 * ADD EBAYTRANSACTION AS CHECKOUT PROCESS
 *
 * @version $Id: ebay_namehelper.php,v 1.3 2010/08/16 09:21:56 cvs Exp $
 * @copyright 2004
 * @author: mario aspeleiter <dazze@gmx.de>
 **/
ini_set('memory_limit','1200M');
define("EBAY_SHIPPING_TITLE","Versandkosten Ebay");
define("EBAY_CUSTOMERS_STATUS",'4'); // neuen userstatus 'Ebay - Upselling' anlegen
define("EBAY_WORKAROUND_ORDERS_STATUS",4); // neuen orderstatus 'Ebay - Upselling' anlegen
define("EBAY_DEFAULT_GENDER","m");
define("EBAY_WORKAROUND_PAYMENTCLASS",'moneyorder'); // weiss nicht 100% was da evtl bei scheck eingetragen wird
define("EBAY_WORKAROUND_SHIPPINGMETHOD",'Versandkosten (Ebay)');
define("EBAY_WORKAROUND_SHIPPINGCLASS",'flat_flat');

define("EBAY_WORKAROUND_TAX_ZONE",'5'); // "Steuerzone EU" aus der Tabelle "geo_zones"

define("TABLE_EBAY_TRANSACTIONS",'ebay_transactions');
define("TABLE_EBAY_PRODUCTS",'ebay_products');
define("TABLE_EBAY_AUCTIONS",'ebay_auctions');
define('TABLE_EBAY_CALLS','ebay_calls');
define('TABLE_EBAY_EMAILS','ebay_emails');
define("EBAYAPI",true);

require('includes/application_top.php');
require('admin/includes/config.ebayapi.inc.php');

//require_once(DIR_FS_DOCUMENT_ROOT.'admin/ebayphpat/Ebay_Item.php');
//require_once(DIR_FS_DOCUMENT_ROOT.'admin/ebayphpat/Ebay_ItemSellerQuery.php');

require_once(DIR_FS_DOCUMENT_ROOT.'admin/ebayphpat/sample/QuickSeller/checkLogin.php');
require_once(DIR_FS_DOCUMENT_ROOT.'admin/ebayphpat/Ebay_TransactionByItemQuery.php');
require_once(DIR_FS_DOCUMENT_ROOT.'admin/ebayphpat/Ebay_DateHelper.php');
require_once(DIR_FS_DOCUMENT_ROOT.'admin/includes/classes/class.ebay.php');

require_once(DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_DOCUMENT_ROOT.'inc/xtc_php_mail.inc.php');
require_once(DIR_FS_DOCUMENT_ROOT.'inc/xtc_encrypt_password.inc.php');
require_once(DIR_FS_DOCUMENT_ROOT.'inc/xtc_calculate_tax.inc.php');

$smarty = new yesSmarty;
$EBAYAPI = new ebayAPI;

set_time_limit(0);
$mySession = new Ebay_Session();

$mySession->setTokenUsePickupFile( false );
$mySession->setRequestToken( $EBAYAPI->getToken() );
$mySession->setErrorLanguage(77);

adaptSession($mySession);

$item = $_GET['ebay_id'];
$transaction_id = ($_GET['transaction_id'] != '') ? $_GET['transaction_id'] : '0';
$oID = $_GET['oID'];
$cID = $_GET['cID'];

// set the detailLevel according to docs to maximum data
$detailLevel = 30;

if ($item != "" && $cID != '' && $oID != '') {
	$transQueryItem = new Ebay_TransactionByItemQuery($mySession);

	$dateHelper = new Ebay_DateHelper();
	// the last 29 days
	$span = $dateHelper->getTimeSpanDays(29);
	
	$transQueryItem->setLastModifiedFrom($span[0]);
	$transQueryItem->setLastModifiedTo($span[1]);		

	$transQueryItem->setItemId($item);
	$res = $transQueryItem->Query(126);
}else{
	die('missing params');	
}

/*
$dateHelper = new Ebay_DateHelper();

// the last 29 days
$span = $dateHelper->getTimeSpanDays(2);
$transQuery->setLastModifiedFrom($span[0]);
$transQuery->setLastModifiedTo($span[1]);
$res = $transQuery->Query(94);
*/

$errors = count($res->_errors);
if($errors > 0) {
	echo "<font color=red face=arial,helvetica size=2><b>";
	echo $errors . " Fehler sind aufgetreten.</b></font><br><pre>";
		for($err=0;$err<$errors;$err++) {
			echo $res->getErrorMessage( $err );
		}
	echo "</pre>";
	exit;
}
if ($res->isGood()) {
	$resultList = $transQueryItem->getResultList();
} else {
	$resultList = array();
}

if($_GET['debug']) {
	print_r($resultList);
	exit;
}

foreach ($resultList as $trans){
	$fullname_ebay = '';
	$fullname_array = array();
	$fullname = array();
	$buyerdata = array();
	if($trans->getTransactionId() == $transaction_id){
		$buyer = $trans->getBuyer();
	
		if( $buyer->getRegistrationAddressName() != "")
			 $fullname_ebay = $buyer->getRegistrationAddressName();
		else
			 $fullname_ebay = $buyer->getShippingAddressName();
		$fullname_array = split(" ",$fullname_ebay);
		$fullname[0] = $fullname_array[0];
		
		for($i=1;$i<count($fullname_array);$i++) {
			$fullname[1] .= $fullname_array[$i];
		}
		
		$buyerdata['firstname'] = $fullname[0];
		$buyerdata['lastname'] = $fullname[1];
		
		$ebaystreet1 = $buyer->getShippingAddressStreet1();
		$ebaystreet2 = $buyer->getShippingAddressStreet2();
		if( $ebaystreet1 == '' ){
			$ebaystreet1 = $buyer->getRegistrationAddressStreet();
		}
		$buyerdata['street'] = $ebaystreet1;
		$buyerdata['street2'] = $ebaystreet2;
		unset($ebaystreet1);
		unset($ebaystreet2);
		
	
		if( $buyer->getRegistrationAddressZip() != "" )
			 $ebayzip = $buyer->getRegistrationAddressZip();
		else
			 $ebayzip = $buyer->getShippingAddressZip();
	
		$buyerdata['zip'] = $ebayzip;
		unset($ebayzip);
	
		if( $buyer->getRegistrationAddressCity() != "" )
			 $ebaycity = $buyer->getRegistrationAddressCity();
		else
			 $ebaycity = $buyer->getShippingAddressCity();
		$buyerdata['city'] = $ebaycity;
		unset($ebaycity);
	
		if($buyer->getRegistrationAddressCountry()!="")
			 $ebay_country = $buyer->getRegistrationAddressCountry();
		else
			 $ebay_country = $buyer->getShippingAddressCountry();
		$buyerdata['country'] = $ebay_country;
		unset($ebay_country);

	
		$sql_data_array = array(
						  'customers_name' => $buyerdata['firstname'].' '.$buyerdata['lastname'],
						  'customers_street_address' => $buyerdata['street'],
						  'customers_postcode' => $buyerdata['zip'],
						  'customers_city' => $buyerdata['city'],
						  'customers_country' => $buyerdata['country'],
						  'delivery_name' => $buyerdata['firstname'].' '.$buyerdata['lastname'],
						  'delivery_street_address' => $buyerdata['street'],
						  'delivery_postcode' => $buyerdata['zip'],
						  'delivery_city' => $buyerdata['city'],
						  'delivery_country' => $buyerdata['country'],
						  'billing_name' => $buyerdata['firstname'].' '.$buyerdata['lastname'],
						  'billing_street_address' => $buyerdata['street'],
						  'billing_postcode' => $buyerdata['zip'],
						  'billing_city' => $buyerdata['city'],
						  'billing_country' => $buyerdata['country']);
		yes_db_perform(TABLE_ORDERS, $sql_data_array,'update',[
                    'customers_id'=>$cID,
                    'orders_id'=>$oID
                ]);
	}
}
xtc_redirect(xtc_href_link('admin/orders.php','oID='.$oID));
?>
