<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_count_products_in_category.inc.php,v 1.2 2008/05/26 09:23:45 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(general.php,v 1.225 2003/05/29); www.oscommerce.com 
   (c) 2003	 nextcommerce (xtc_count_products_in_category.inc.php,v 1.3 2003/08/13); www.nextcommerce.org 

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   
function xtc_count_products_in_category($category_id, $include_inactive = false) {
    $products_count = 0;
    $parameters = [
        'categories_id'=>(int)$category_id
    ];
    if ($include_inactive == true) {
        $products_query = "select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p2c.categories_id =:categories_id";
    } else {
        $products_query = "select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p.products_status = '1' and p2c.categories_id =:categories_id";
    }

    $products = yes_query($products_query,$parameters,true);
    $products_count += $products['total'];

    $child_categories_query = "select categories_id from " . TABLE_CATEGORIES . " where parent_id =:categories_id";

    $child_categories_query = yes_query($child_categories_query,$parameters);
    if (sizeOf($child_categories_query)) {
        foreach($child_categories_query as $child_categories) {
            $products_count += xtc_count_products_in_category($child_categories['categories_id'], $include_inactive);
        }
    }
    return $products_count;
}
