<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_currency_exists.inc.php,v 1.2 2007/12/03 16:01:24 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(general.php,v 1.225 2003/05/29); www.oscommerce.com 
   (c) 2003	 nextcommerce (xtc_currency_exists.inc.php); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

function xtc_currency_exists($code) {
    global $InstanceCache;
    if(empty($code)){
        $code = (defined('DEFAULT_CURRENCY'))?DEFAULT_CURRENCY:'EUR';
    }
    $param ='/[^a-zA-Z]/';
    $code=preg_replace($param,'',$code);
    
    $key = 'currencies_values_'.$code;
    $CachedString = $InstanceCache->getItem($key);
    if (!$CachedString->isHit()) {
	$currency_code = yes_query(sprintf(
            "SELECT code, currencies_id from %s WHERE code =:code LIMIT 1",
                TABLE_CURRENCIES
            ),['code'=>$code]
        );
	if (sizeOf($currency_code)) {
            $curr = current($currency_code);
            if ($curr['code'] == $code) {
                $return = $code;
            } else {
                $return = false;
            }
	} else {
            $return = false;
	}
        $CachedString->set($return)->expiresAfter(0)->addTag('shop');//currencies_values_
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        return $return;
    }
    return $CachedString->get();
}

