<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_oe_get_price_o_tax.inc.php

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   XTC-Bestellbearbeitung:
   http://www.xtc-webservice.de / Matthias Hinsche
   info@xtc-webservice.de

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2003	 nextcommerce (xtc_get_products_price.inc.php,v 1.13 2003/08/20); www.nextcommerce.org
   
   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

// Berechnet Nettopreis aus Brutto
/**
 * Ermittelt den Netto Wert von $value
 * Wird $check mit true uebergeben, wird $tax_class_id verwendet. Ansonsten
 * gilt der Wert $tax_class_id als tax rate, also zb 19
 * 
 * @param float $value
 * @param mixed $tax_class_id
 * @param mixed $check
 * @return float
 */
function xtc_oe_get_price_o_tax($value, $tax_class_id, $check=0) {
    if ($check === true or $check =='1'){
        $tax = yes_query(
            "select tax_rate from " . TABLE_TAX_RATES . " where tax_class_id =:tax_class_id",
            ['tax_class_id'=>(int)$tax_class_id],
            true
        );
        return ($value/($tax['tax_rate']+100)*100);
    }
    // tax_class_id enthaelt den prozentwert
    return ($value/($tax_class_id+100)*100);
}
