<?php
/*
   * REQUIRE: class.storagequantity,class.ebayapi.php,smarty
  */
function xtc_warning_process($orders_array,$warningmode,$automatic = 0) {
    if(!function_exists('yes_write_notice')){
        require(DIR_FS_INC.'yes_write_notice.inc.php');
    }
    $recipients_array = main::get_notice_recipients('distributor_products');
    $order_recipients_array = main::get_notice_recipients('incoming_payments');
        
	$astr = (intval($automatic) == 1)? 'Automatisch ' : '';
	
	$EXPORT_WRITTEN = false;
	global $smarty,$EBAYAPI;
	$export_count = 0;
	if($warningmode == 3){

		$path = \main::get_exportdata_path()."RAexport/";
		if(!is_dir($path)){
			mkdir($path);
			//chmod($path,0777);
		}
		$datei = 'RA_AUTOEXPORT_'.yes_get_sha1_from_string( date('Y-m-d_H-i-s') ).'.csv';
		$filename = $path.'/'.$datei;
	
		$fh = fopen($filename,'a+') or die("Kann ".$filename." nicht anlegen.");
		fclose($fh);
		$csv = new CSVfile($filename);
		$csv->open("w");
	
		$data[] = 'Re-Nr';
		$data[] = 'Re-Datum';
		$data[] = 'Mahn-Historie';
		$data[] = 'Ebay-Nr';
		$data[] = 'Firma';
		$data[] = 'Name';
		$data[] = 'Strasse';
		$data[] = 'Adresszusatz';
		$data[] = 'Stadt';
		$data[] = 'PLZ';
		$data[] = 'Land';
		$data[] = 'Produkte';
		$data[] = 'Rechnungsbetrag';
		$data[] = 'EK-Preis';
		$data[] = 'Forderung';
		$data[] = 'Aktenzeichen';
		$data[] = 'Aktenzeichen Datum';
		$data[] = 'Aufforderungsschreiben Datum';
		$data[] = 'Anwaltsgeb�hren';
		$data[] = 'Anwalt Rechnungsnummer';
		$data[] = 'Forderung erhalten';
		$data[] = 'Datum Weiterleitung';
		$data[] = 'Erhaltener Gesamtbetrag';
		$data[] = 'Datum Weiterleitung';
		$csv->addRow($data);
	}
	for($i=0;$i<sizeOf($orders_array);$i++){
		$oID = xtc_db_prepare_input($orders_array[$i]);
		$order = new order($oID);
		// bei der 3. mahnung gibts keine mail mehr
		if($warningmode < 3) {
			$auctions = array();
			// ADDON KOMBINIERTE
			$combined_orders = $order->get_combined_orders();
			for($coi=0;$coi<sizeOf($combined_orders);$coi++){
				$cOID = $combined_orders[$coi]['orders_id'];
				$check_co_status_query = xtc_db_query("select et.transactionid, o.ebay_id from " . TABLE_ORDERS . " o LEFT JOIN ".TABLE_EBAY_TRANSACTIONS." et USING(orders_id) where o.orders_id = '" . xtc_db_input($cOID) . "' and o.ebay_id != ''");
				$check_co_status = xtc_db_fetch_array($check_co_status_query);
				if($check_co_status['ebay_id'] != ''){
					$auctions[] = array('ebay_id'=>$check_co_status['ebay_id'],
                    	'transaction_id'=>$check_co_status['transactionid']
                    );
                }
			}

			$check_status_query = xtc_db_query("select o.customers_name, o.customers_email_address,o.customers_id, o.ebay_id, o.date_purchased,ot.text from " . TABLE_ORDERS . " o LEFT JOIN ".TABLE_ORDERS_TOTAL." ot USING(orders_id) where o.orders_id = '" . xtc_db_input($oID) . "' && o.orders_id=ot.orders_id && ot.class='ot_total'");
			$check_status = xtc_db_fetch_array($check_status_query);

			if( sizeOf($combined_orders) == 0){
        		if($check_status['ebay_id'] != ''){
          			$auctions[] = array(
            			'ebay_id'=>$check_status['ebay_id'],
            			'transaction_id'=>'-'
          			);
        		}
			}
			if($check_status['customers_email_address'] != ''){
				$smarty->assign('NAME',$check_status['customers_name']);
				
				// NEUE VARIABLEN
				$smarty->assign('BANK_WRAP',BANK_WRAP);
				$smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);
				
				$smarty->assign('ORDER_NR',$oID);
				if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and constant('MODULE_OTHER_FIBUNUMBERS_STATUS') == 'True'){
					$smarty->assign('FIBU_NUMBER',$order->get_fibunumber());
				}
				$smarty->assign('EBAYID',$check_status['ebay_id']);
				$smarty->assign('ORDER_LINK',xtc_catalog_href_link(FILENAME_CATALOG_ACCOUNT_HISTORY_INFO, 'order_id=' . $oID, 'SSL'));
				$smarty->assign('ORDER_DATE',yes_strftime('%d.%m.%Y',strtotime($check_status['date_purchased'])) );
				$smarty->assign('ORDER_PRICE',$check_status['text']);

				$tpl_path_lang = (!empty($order->info['language']))?$order->info['language']:'german';
				$html_mail = $smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE . '/admin/mail/'.$tpl_path_lang."/send_warning".($warningmode+1).".html");
				$txt_mail  = $smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE . '/admin/mail/'.$tpl_path_lang."/send_warning".($warningmode+1)."_mail.txt");
	
				switch($warningmode){
					case '1': $warningmail_subject = '1. Mahnung'; break;
					case '2': $warningmail_subject = '2. Mahnung'; break;
					case '3': $warningmail_subject = 'An Rechtsanwalt übergeben'; break;
					default: $warningmail_subject = 'Zahlungserinnerung'; break;
				}
				if(!main::isDev(true)){
					xtc_php_mail(EMAIL_BILLING_ADDRESS,EMAIL_BILLING_NAME , $check_status['customers_email_address'], $check_status['customers_name'], '', EMAIL_BILLING_REPLY_ADDRESS, EMAIL_BILLING_REPLY_ADDRESS_NAME, '', '', $warningmail_subject, $html_mail , $txt_mail);
				}
				// add to mails
        \YES4Trade\Model\ebay_emails::create_ebay_emails([
            'subject'=>$warningmail_subject,
            'mailto'=>$check_status['customers_email_address'],
            'from_name'=>EMAIL_BILLING_REPLY_ADDRESS_NAME,
            'from_email'=>EMAIL_BILLING_REPLY_ADDRESS,
            'date'=>date('Y-m-d H:i:s'),
            'ebay_id'=>$order->info['ebay_id'],
            'customers_id'=>intval($order->customer['ID']),
            'orders_id'=>intval($order->info['id']),
            'read_status'=>\YES4Trade\Model\ebay_emails::READ_STATUS1,
            'reply_status'=>\YES4Trade\Model\ebay_emails::REPLY_STATUS1,
            'allocation_status'=>\YES4Trade\Model\ebay_emails::ALLOCATION_STATUS1,
            'ownmail'=>\YES4Trade\Model\ebay_emails::OWNMAIL1,
            'format'=>'text/html'
          ],$html_mail
        );
			}			
      $order->add_history(intval($order->info['orders_status']),
          1, $astr."Stufe ".($warningmode+1)." Mahnung."
      );
			switch($warningmode){
				case '1': $warning_action = $astr.'1. Mahnung verschickt'; break;
				case '2': $warning_action = $astr.'2. Mahnung verschickt'; break;
				default: $warning_action = $astr.'Zahlungserinnerung verschickt'; break;
			}
			xtc_db_query("INSERT INTO ".TABLE_EBAY_WARNING_HISTORY." SET orders_id='".$oID."',customers_id='".$check_status['customers_id']."',action='".$warning_action."',warning_date=now(),warning_status='".($warningmode+1)."'" );
			xtc_db_query("UPDATE ".TABLE_ORDERS." SET last_warning=now(),warning_status='".($warningmode+1)."',last_modified=now() WHERE orders_id='".$oID."'" );
		}else if($warningmode == 3){ // RA EXPORT
			//
			// ERMITTELE DEN VK PREIS DER RECHNUNG
			//
			$vkprice = 0;
			foreach($order->totals as $k=>$total){
				if($total['class'] == 'ot_subtotal'){
					$vkprice = $total['value'];
				}
			}
			
			
			$EKSPERRE = false; // falls cronjob und "entgangener gewinn" und kein EK preis ignorieren wir die rechng
			
			// BERECHNUNG ENTGANGENER GEWINN
			if(WARNING_ENTGANGENER_GEWINN_ACTIVE == 1){
				//
				// ERMITTELE DEN EK PREIS DER RECHNUNG
				//
				$ekprice = 0;
				foreach($order->products as $k=>$product){
					$ek = (xtc_get_price_ek($product['id'])*$product['qty']);
					$ekprice += $ek;
					if($ek == 0){
                                                yes_write_notice('Kein EK Preis: pID '.$product['id'], 
                                                        "Beim Rechtsanwaltsexport wurde festgestellt, dass der Artikel mit der pID ".$product['id'].", ".xtc_get_products_name($product['id'])." (oder ggf ein enthaltenes Colliprodukt), keinen Einkaufspreis hat. Dieser wird ben&ouml;tigt um den &quot;Entgangenen Gewinn&quot; zu berechnen.",
                                                        0, $recipients_array
                                                );
					}
				}
				if($ekprice == 0){
					$EKSPERRE = true; // KEIN EK -> KEIN EXPORT
				}
				if(WARNING_ENTGANGENER_GEWINN_PROZENT > 0){
					$proz = $vkprice-$ekprice;
					$proz = (($proz/100)*WARNING_ENTGANGENER_GEWINN_PROZENT);
					$forderung = $vkprice-$ekprice-$proz;
				}else{
					$forderung = $vkprice-$ekprice;
				}
				
					
				if($forderung <= WARNING_ENTGANGENER_GEWINN_MINIMUM){
					$exportRA = false;
					$warning_action = $astr.'Nach 2. Mahnung storniert - Gesamtforderung unter '.WARNING_ENTGANGENER_GEWINN_MINIMUM.', kein RA Export';
					xtc_db_query("INSERT INTO ".TABLE_EBAY_WARNING_HISTORY." SET orders_id='".$oID."',customers_id='".$order->customer['ID']."',action='".$warning_action."',warning_date=now(),warning_status='".($warningmode+1)."'" );
					xtc_db_query("UPDATE ".TABLE_ORDERS." SET last_warning=now(),warning_status='".($warningmode+1)."',last_modified=now() WHERE orders_id='".$oID."'" );
					$order_link = sprintf('<br /><a href="%s" target="_blank">Zum Auftrag</a>',xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$oID));
					yes_write_notice('Mahnstufe 3 Auftrag '.$oID,
							$astr.' - Gesamtforderung unter '.WARNING_ENTGANGENER_GEWINN_MINIMUM.', kein RA Export'.$order_link,
							0,$order_recipients_array
					);
					//xtc_orders_storno($oID,$order,$astr.'Nach 2. Mahnung storniert - Gesamtforderung unter '.WARNING_ENTGANGENER_GEWINN_MINIMUM.', kein RA Export');
				}else{
					$exportRA = true;
				}
			}else{
				$forderung = $vkprice;
				if($forderung <= WARNING_RECHNUNGSBETRAG_MINIMUM){
					$exportRA = false;
					$warning_action = 'Nach 2. Mahnung storniert - Gesamtforderung unter '.WARNING_RECHNUNGSBETRAG_MINIMUM.', kein RA Export';
					xtc_db_query("INSERT INTO ".TABLE_EBAY_WARNING_HISTORY." SET orders_id='".$oID."',customers_id='".$order->customer['ID']."',action='".$warning_action."',warning_date=now(),warning_status='".($warningmode+1)."'" );
					xtc_db_query("UPDATE ".TABLE_ORDERS." SET last_warning=now(),warning_status='".($warningmode+1)."',last_modified=now() WHERE orders_id='".$oID."'" );
					$order_link = sprintf('<br /><a href="%s" target="_blank">Zum Auftrag</a>',xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$oID));
					yes_write_notice('Mahnstufe 3 Auftrag '.$oID,
							$astr.' - Gesamtforderung unter '.WARNING_ENTGANGENER_GEWINN_MINIMUM.', kein RA Export'.$order_link,
							0,$order_recipients_array
					);
					//xtc_orders_storno($oID,$order,$astr.'aus Mahnwesen Stufe 3 heraus storniert - Gesamtforderung unter '.WARNING_RECHNUNGSBETRAG_MINIMUM.', kein RA Export');
				}else{
					$exportRA = true;
				}
			}
			
			if($exportRA && !$EKSPERRE){
				$export_count++;
				//
				// Vorgangshistorie
				//
				$history_string = '';
				$history_query = xtc_db_query("SELECT * FROM ebay_warning_history WHERE orders_id='".$oID."'");
				while( $history = xtc_db_fetch_array($history_query) ){
					$history_string .= 'am '.yes_strftime('%d.%m.%Y',strtotime($history['warning_date'])).' '.$history['action'].' / ';
				}
				$history_string = substr($history_string,0,(strlen($history_string)-3) );
				
				//
				// Produkte in Rechnung
				//
				$products_string = '';
				if(is_array($order->products)){
					foreach($order->products as $k=>$product){
						$products_string .= $product['qty'].'x '.$product['name'].' = '.number_format($product['price']*$product['qty'],2,',','').' '.$order->info['currency'].' / ';
					}
					$products_string = substr($products_string,0,(strlen($products_string)-3) );
				}else{
					$products_string = 'keine Produkte';
				}
				
				$data = array();
				$data[] = $oID;
				$data[] = yes_strftime('%d.%m.%Y',strtotime($order->info['date_purchased']));
				$data[] = $history_string;
				$data[] = $order->info['ebay_id'];
				$data[] = $order->customer['company'];
				$data[] = $order->customer['name'];
				$data[] = $order->customer['street_address'];
				$data[] = $order->customer['suburb'];
				$data[] = $order->customer['city'];
				$data[] = $order->customer['postcode'];
				$data[] = $order->customer['country'];
				$data[] = $products_string;
				$data[] = number_format($vkprice,2,',','');
				$data[] = number_format($ekprice,2,',','');
				$data[] = number_format($forderung,2,',','');
				$data[] = '';
				$data[] = '';
				$data[] = '';
				$data[] = '';
				$data[] = '';
				$data[] = '';
				$data[] = '';
				$data[] = '';
				$data[] = '';
				$csv->addRow($data);
				$EXPORT_WRITTEN = true;
				//
				// IN EXPORT-TABELLE SPEICHERN
				//
				$sql_array = array('orders_id'=>$oID,
					'date_purchased'=>$order->info['date_purchased'],
					'warning_history'=>xtc_db_input($history_string),
					'ebay_id'=>$order->info['ebay_id'],
					'customer_company'=>$order->customer['company'],
					'customer_name'=>$order->customer['name'],
					'customer_street_address'=>$order->customer['street_address'],
					'customer_suburb'=>$order->customer['suburb'],
					'customer_city'=>$order->customer['city'],
					'customer_postcode'=>$order->customer['postcode'],
					'customer_country'=>$order->customer['country'],
					'products'=>xtc_db_input($products_string),
					'totalprice'=>$vkprice,
					'ekprice'=>$ekprice,
					'outstanding'=>$forderung,
					'status'=>'0',
					'date_saved'=>"now()"
				);
				xtc_db_perform('lawyer_export',$sql_array);
				$order_link = sprintf('<br /><a href="%s" target="_blank">Zum Auftrag</a>',xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$oID));
                                yes_write_notice('Mahnstufe 3 Auftrag '.$oID.' an RA uebergeben',
                                        $astr.' den Auftrag ggf stornieren und an RA uebergeben.'.$order_link,
                                        0,$order_recipients_array
                                );
				//xtc_orders_storno($oID,$order,$astr.'nach 2. Mahnung storniert und RA Export');
				$warning_action = $astr.' Evtl. stornieren und an Rechtsanwalt uebergeben';
				xtc_db_query("INSERT INTO ".TABLE_EBAY_WARNING_HISTORY." SET orders_id='".$oID."',customers_id='".$check_status['customers_id']."',action='".$warning_action."',warning_date=now(),warning_status='".($warningmode+1)."'" );
				xtc_db_query("UPDATE ".TABLE_ORDERS." SET last_warning=now(),warning_status='".($warningmode+1)."',last_modified=now() WHERE orders_id='".$oID."'" );
				
				
				
			} // end if EXPORT
		} // end if warningmode 3
	} // end orders
		
	if($warningmode == 3){
		if($EXPORT_WRITTEN){
			$csv->close();
			if(strlen(WARNING_LAWYER_EMAIL)>3){ // email an RE
				xtc_php_mail(STORE_OWNER_EMAIL_ADDRESS, STORE_OWNER_EMAIL_ADDRESS, WARNING_LAWYER_EMAIL, WARNING_LAWYER_EMAIL, '', STORE_OWNER_EMAIL_ADDRESS, STORE_OWNER_EMAIL_ADDRESS, $filename, $path_to_more_attachements='', 'Mahnungen Export vom '.date('d.m.y H:i:s'), '<p><b>Guten Tag,</b></p>Im Anhang finden Sie als CSV Datei die Exportdaten.', "Guten Tag,\r\n\r\nIm Anhang finden Sie als CSV Datei die Exportdaten.");
			}
		}
		
		if($export_count == 0){
			unlink($filename);
		}
	}
}

